/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.IOException;
import java.io.Writer;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONWriter {
    private static final int maxdepth = 200;
    private boolean comma = false;
    protected char mode = (char)105;
    private final JSONObject[] stack = new JSONObject[200];
    private int top = 0;
    protected Writer writer;

    public JSONWriter(Writer writer) {
        this.writer = writer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONWriter append(String string2) throws JSONException {
        block5: {
            if (string2 == null) {
                throw new JSONException("Null pointer");
            }
            char c = this.mode;
            if (c != 'o' && c != 'a') {
                throw new JSONException("Value out of sequence.");
            }
            try {
                if (this.comma && c == 'a') {
                    this.writer.write(44);
                }
                this.writer.write(string2);
                if (this.mode != 'o') break block5;
            }
            catch (IOException iOException) {
                throw new JSONException(iOException);
            }
            this.mode = (char)107;
        }
        this.comma = true;
        return this;
    }

    private JSONWriter end(char c, char c2) throws JSONException {
        if (this.mode != c) {
            String string2 = c == 'a' ? "Misplaced endArray." : "Misplaced endObject.";
            throw new JSONException(string2);
        }
        this.pop(c);
        try {
            this.writer.write(c2);
            this.comma = true;
            return this;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException);
        }
    }

    private void pop(char c) throws JSONException {
        int n = this.top;
        if (n > 0) {
            JSONObject[] jSONObjectArray = this.stack;
            JSONObject jSONObject = jSONObjectArray[n - 1];
            int n2 = 97;
            char c2 = jSONObject == null ? (char)'a' : 'k';
            if (c2 == c) {
                c = (char)(n - 1);
                this.top = c;
                c = c == '\u0000' ? (char)100 : (jSONObjectArray[c - '\u0001'] == null ? (char)n2 : (char)107);
                this.mode = c;
                return;
            }
            throw new JSONException("Nesting error.");
        }
        throw new JSONException("Nesting error.");
    }

    private void push(JSONObject jSONObject) throws JSONException {
        int n = this.top;
        if (n < 200) {
            this.stack[n] = jSONObject;
            int n2 = jSONObject == null ? 97 : 107;
            this.mode = (char)n2;
            this.top = n + 1;
            return;
        }
        throw new JSONException("Nesting too deep.");
    }

    public JSONWriter array() throws JSONException {
        char c = this.mode;
        if (c != 'i' && c != 'o' && c != 'a') {
            throw new JSONException("Misplaced array.");
        }
        this.push(null);
        this.append("[");
        this.comma = false;
        return this;
    }

    public JSONWriter endArray() throws JSONException {
        return this.end('a', ']');
    }

    public JSONWriter endObject() throws JSONException {
        return this.end('k', '}');
    }

    public JSONWriter key(String string2) throws JSONException {
        if (string2 != null) {
            if (this.mode == 'k') {
                try {
                    this.stack[this.top - 1].putOnce(string2, Boolean.TRUE);
                    if (this.comma) {
                        this.writer.write(44);
                    }
                    this.writer.write(JSONObject.quote(string2));
                    this.writer.write(58);
                    this.comma = false;
                    this.mode = (char)111;
                    return this;
                }
                catch (IOException iOException) {
                    throw new JSONException(iOException);
                }
            }
            throw new JSONException("Misplaced key.");
        }
        throw new JSONException("Null key.");
    }

    public JSONWriter object() throws JSONException {
        char c;
        if (this.mode == 'i') {
            this.mode = (char)111;
        }
        if ((c = this.mode) != 'o' && c != 'a') {
            throw new JSONException("Misplaced object.");
        }
        this.append("{");
        this.push(new JSONObject());
        this.comma = false;
        return this;
    }

    public JSONWriter value(double d) throws JSONException {
        return this.value(new Double(d));
    }

    public JSONWriter value(long l) throws JSONException {
        return this.append(Long.toString(l));
    }

    public JSONWriter value(Object object) throws JSONException {
        return this.append(JSONObject.valueToString(object));
    }

    public JSONWriter value(boolean bl) throws JSONException {
        String string2 = bl ? "true" : "false";
        return this.append(string2);
    }
}

