/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.json.XMLTokener;

public class XML {
    public static final Character AMP = Character.valueOf('&');
    public static final Character APOS = Character.valueOf('\'');
    public static final Character BANG = Character.valueOf('!');
    public static final Character EQ = Character.valueOf('=');
    public static final Character GT = Character.valueOf('>');
    public static final Character LT = Character.valueOf('<');
    public static final Character QUEST = Character.valueOf('?');
    public static final Character QUOT = Character.valueOf('\"');
    public static final Character SLASH = Character.valueOf('/');

    public static String escape(String string2) {
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c != '\"') {
                if (c != '<') {
                    if (c != '>') {
                        if (c != '&') {
                            if (c != '\'') {
                                stringBuilder.append(c);
                                continue;
                            }
                            stringBuilder.append("&apos;");
                            continue;
                        }
                        stringBuilder.append("&amp;");
                        continue;
                    }
                    stringBuilder.append("&gt;");
                    continue;
                }
                stringBuilder.append("&lt;");
                continue;
            }
            stringBuilder.append("&quot;");
        }
        return stringBuilder.toString();
    }

    public static void noSpace(String string2) throws JSONException {
        int n = string2.length();
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                if (!Character.isWhitespace(string2.charAt(i))) {
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("'");
                stringBuilder.append(string2);
                stringBuilder.append("' contains a space character.");
                throw new JSONException(stringBuilder.toString());
            }
            return;
        }
        throw new JSONException("Empty string.");
    }

    private static boolean parse(XMLTokener object, JSONObject object2, String object3) throws JSONException {
        Object object4 = ((XMLTokener)object).nextToken();
        Object object5 = BANG;
        int n = 1;
        if (object4 == object5) {
            int n2 = ((JSONTokener)object).next();
            if (n2 == 45) {
                if (((JSONTokener)object).next() == '-') {
                    ((XMLTokener)object).skipPast("-->");
                    return false;
                }
                ((JSONTokener)object).back();
            } else if (n2 == 91) {
                if ("CDATA".equals(((XMLTokener)object).nextToken()) && ((JSONTokener)object).next() == '[') {
                    if (((String)(object = ((XMLTokener)object).nextCDATA())).length() > 0) {
                        ((JSONObject)object2).accumulate("content", object);
                    }
                    return false;
                }
                throw ((JSONTokener)object).syntaxError("Expected 'CDATA['");
            }
            while ((object2 = ((XMLTokener)object).nextMeta()) != null) {
                if (object2 == LT) {
                    n2 = n + '\u0001';
                } else {
                    n2 = n;
                    if (object2 == GT) {
                        n2 = n - 1;
                    }
                }
                n = n2;
                if (n2 > 0) continue;
                return false;
            }
            throw ((JSONTokener)object).syntaxError("Missing '>' after '<!'.");
        }
        if (object4 == QUEST) {
            ((XMLTokener)object).skipPast("?>");
            return false;
        }
        if (object4 == SLASH) {
            object2 = ((XMLTokener)object).nextToken();
            if (object3 != null) {
                if (object2.equals(object3)) {
                    if (((XMLTokener)object).nextToken() == GT) {
                        return true;
                    }
                    throw ((JSONTokener)object).syntaxError("Misshaped close tag");
                }
                object4 = new StringBuilder();
                ((StringBuilder)object4).append("Mismatched ");
                ((StringBuilder)object4).append((String)object3);
                ((StringBuilder)object4).append(" and ");
                ((StringBuilder)object4).append(object2);
                throw ((JSONTokener)object).syntaxError(((StringBuilder)object4).toString());
            }
            object3 = new StringBuilder();
            ((StringBuilder)object3).append("Mismatched close tag ");
            ((StringBuilder)object3).append(object2);
            throw ((JSONTokener)object).syntaxError(((StringBuilder)object3).toString());
        }
        if (!(object4 instanceof Character)) {
            object5 = (String)object4;
            JSONObject jSONObject = new JSONObject();
            block1: while (true) {
                object3 = null;
                while (true) {
                    object4 = object3;
                    if (object3 == null) {
                        object4 = ((XMLTokener)object).nextToken();
                    }
                    if (!(object4 instanceof String)) break block1;
                    object4 = (String)object4;
                    object3 = ((XMLTokener)object).nextToken();
                    if (object3 == EQ) {
                        object3 = ((XMLTokener)object).nextToken();
                        if (object3 instanceof String) {
                            jSONObject.accumulate((String)object4, XML.stringToValue((String)object3));
                            continue block1;
                        }
                        throw ((JSONTokener)object).syntaxError("Missing value");
                    }
                    jSONObject.accumulate((String)object4, "");
                }
                break;
            }
            if (object4 == SLASH) {
                if (((XMLTokener)object).nextToken() == GT) {
                    if (jSONObject.length() > 0) {
                        ((JSONObject)object2).accumulate((String)object5, jSONObject);
                    } else {
                        ((JSONObject)object2).accumulate((String)object5, "");
                    }
                    return false;
                }
                throw ((JSONTokener)object).syntaxError("Misshaped tag");
            }
            if (object4 == GT) {
                while (true) {
                    if ((object3 = ((XMLTokener)object).nextContent()) == null) {
                        if (object5 == null) {
                            return false;
                        }
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append("Unclosed tag ");
                        ((StringBuilder)object2).append((String)object5);
                        throw ((JSONTokener)object).syntaxError(((StringBuilder)object2).toString());
                    }
                    if (object3 instanceof String) {
                        if (((String)(object3 = (String)object3)).length() <= 0) continue;
                        jSONObject.accumulate("content", XML.stringToValue((String)object3));
                        continue;
                    }
                    if (object3 == LT && XML.parse((XMLTokener)object, jSONObject, (String)object5)) break;
                }
                if (jSONObject.length() == 0) {
                    ((JSONObject)object2).accumulate((String)object5, "");
                } else if (jSONObject.length() == 1 && jSONObject.opt("content") != null) {
                    ((JSONObject)object2).accumulate((String)object5, jSONObject.opt("content"));
                } else {
                    ((JSONObject)object2).accumulate((String)object5, jSONObject);
                }
                return false;
            }
            throw ((JSONTokener)object).syntaxError("Misshaped tag");
        }
        throw ((JSONTokener)object).syntaxError("Misshaped tag");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object stringToValue(String string2) {
        if ("true".equalsIgnoreCase(string2)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string2)) {
            return Boolean.FALSE;
        }
        if ("null".equalsIgnoreCase(string2)) {
            return JSONObject.NULL;
        }
        try {
            Long l;
            boolean bl;
            char c = string2.charAt(0);
            if (c != '-') {
                if (c < '0') return string2;
                if (c > '9') return string2;
            }
            if (!(bl = (l = new Long(string2)).toString().equals(string2))) return string2;
            return l;
        }
        catch (Exception exception) {
            try {
                Double d = new Double(string2);
                boolean bl = d.toString().equals(string2);
                if (!bl) return string2;
                return d;
            }
            catch (Exception exception2) {
                return string2;
            }
        }
    }

    public static JSONObject toJSONObject(String object) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        object = new XMLTokener((String)object);
        while (((JSONTokener)object).more() && ((XMLTokener)object).skipPast("<")) {
            XML.parse((XMLTokener)object, jSONObject, null);
        }
        return jSONObject;
    }

    public static String toString(Object object) throws JSONException {
        return XML.toString(object, null);
    }

    public static String toString(Object object, String charSequence) throws JSONException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = object instanceof JSONObject;
        int n = 0;
        if (bl) {
            if (charSequence != null) {
                stringBuilder.append('<');
                stringBuilder.append((String)charSequence);
                stringBuilder.append('>');
            }
            JSONObject jSONObject = (JSONObject)object;
            Iterator<String> iterator2 = jSONObject.keys();
            while (iterator2.hasNext()) {
                int n2;
                Object object2;
                String string2 = iterator2.next();
                object = object2 = jSONObject.opt(string2);
                if (object2 == null) {
                    object = "";
                }
                if (object instanceof String) {
                    object2 = (String)object;
                }
                if ("content".equals(string2)) {
                    if (object instanceof JSONArray) {
                        object = (JSONArray)object;
                        n2 = ((JSONArray)object).length();
                        for (n = 0; n < n2; ++n) {
                            if (n > 0) {
                                stringBuilder.append('\n');
                            }
                            stringBuilder.append(XML.escape(((JSONArray)object).get(n).toString()));
                        }
                        continue;
                    }
                    stringBuilder.append(XML.escape(object.toString()));
                    continue;
                }
                if (object instanceof JSONArray) {
                    object = (JSONArray)object;
                    n2 = ((JSONArray)object).length();
                    for (n = 0; n < n2; ++n) {
                        object2 = ((JSONArray)object).get(n);
                        if (object2 instanceof JSONArray) {
                            stringBuilder.append('<');
                            stringBuilder.append(string2);
                            stringBuilder.append('>');
                            stringBuilder.append(XML.toString(object2));
                            stringBuilder.append("</");
                            stringBuilder.append(string2);
                            stringBuilder.append('>');
                            continue;
                        }
                        stringBuilder.append(XML.toString(object2, string2));
                    }
                    continue;
                }
                if ("".equals(object)) {
                    stringBuilder.append('<');
                    stringBuilder.append(string2);
                    stringBuilder.append("/>");
                    continue;
                }
                stringBuilder.append(XML.toString(object, string2));
            }
            if (charSequence != null) {
                stringBuilder.append("</");
                stringBuilder.append((String)charSequence);
                stringBuilder.append('>');
            }
            return stringBuilder.toString();
        }
        Object object3 = object;
        if (object.getClass().isArray()) {
            object3 = new JSONArray(object);
        }
        if (object3 instanceof JSONArray) {
            object3 = (JSONArray)object3;
            int n3 = ((JSONArray)object3).length();
            while (n < n3) {
                Object object4 = ((JSONArray)object3).opt(n);
                object = charSequence == null ? "array" : charSequence;
                stringBuilder.append(XML.toString(object4, (String)object));
                ++n;
            }
            return stringBuilder.toString();
        }
        object = object3 == null ? "null" : XML.escape(object3.toString());
        if (charSequence == null) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("\"");
            ((StringBuilder)charSequence).append((String)object);
            ((StringBuilder)charSequence).append("\"");
            object = ((StringBuilder)charSequence).toString();
        } else if (((String)object).length() == 0) {
            object = new StringBuilder();
            ((StringBuilder)object).append("<");
            ((StringBuilder)object).append((String)charSequence);
            ((StringBuilder)object).append("/>");
            object = ((StringBuilder)object).toString();
        } else {
            object3 = new StringBuilder();
            ((StringBuilder)object3).append("<");
            ((StringBuilder)object3).append((String)charSequence);
            ((StringBuilder)object3).append(">");
            ((StringBuilder)object3).append((String)object);
            ((StringBuilder)object3).append("</");
            ((StringBuilder)object3).append((String)charSequence);
            ((StringBuilder)object3).append(">");
            object = ((StringBuilder)object3).toString();
        }
        return object;
    }
}

