/*
 * Decompiled with CFR 0.152.
 */
package org.leibnizcenter.xml;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.dom.CDATASectionImpl;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.CommentImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.ProcessingInstructionImpl;
import org.apache.xerces.dom.TextImpl;
import org.leibnizcenter.xml.NotImplemented;
import org.leibnizcenter.xml.helpers.XmlNodeToJsonElement;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TerseJson {
    private final Options options;

    public TerseJson() {
        this.options = new Options();
    }

    public TerseJson(Options options) {
        this.options = options;
    }

    protected static void addInitialDocNode(CoreDocumentImpl coreDocumentImpl, JsonReader jsonReader) throws IOException, NotImplemented {
        jsonReader.beginArray();
        while (!jsonReader.peek().equals((Object)JsonToken.END_ARRAY)) {
            coreDocumentImpl.appendChild(TerseJson.parseNextNode(coreDocumentImpl, jsonReader));
        }
        jsonReader.endArray();
    }

    protected static void addInitialElement(JsonReader jsonReader, CoreDocumentImpl coreDocumentImpl) throws IOException, NotImplemented {
        ElementImpl elementImpl = new ElementImpl(coreDocumentImpl, jsonReader.nextString());
        coreDocumentImpl.appendChild(elementImpl);
        if (!jsonReader.peek().equals((Object)JsonToken.END_ARRAY)) {
            TerseJson.setChildren(coreDocumentImpl, jsonReader, elementImpl);
            if (!jsonReader.peek().equals((Object)JsonToken.END_ARRAY)) {
                TerseJson.setAttributes(jsonReader, elementImpl);
            }
        }
    }

    public static Document parse(JsonReader object) throws IOException, NotImplemented {
        int n;
        block4: {
            DocumentImpl documentImpl;
            block3: {
                block2: {
                    object.beginArray();
                    n = object.nextInt();
                    documentImpl = new DocumentImpl();
                    if (n != 1) break block2;
                    TerseJson.addInitialElement((JsonReader)object, documentImpl);
                    break block3;
                }
                if (n != 9) break block4;
                TerseJson.addInitialDocNode(documentImpl, (JsonReader)object);
            }
            object.endArray();
            return documentImpl;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Don't know how to handle root node with type ");
        ((StringBuilder)object).append(n);
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    public static Node parseNextNode(CoreDocumentImpl coreDocumentImpl, JsonReader jsonReader) throws IOException, NotImplemented {
        ChildNode childNode;
        block10: {
            ElementImpl elementImpl;
            block4: {
                block5: {
                    block6: {
                        block7: {
                            block8: {
                                block9: {
                                    if (jsonReader.peek().equals((Object)JsonToken.STRING)) {
                                        return coreDocumentImpl.createTextNode(jsonReader.nextString());
                                    }
                                    jsonReader.beginArray();
                                    int n = jsonReader.nextInt();
                                    if (n == 1) break block4;
                                    if (n == 2) break block5;
                                    if (n == 3) break block6;
                                    if (n == 4) break block7;
                                    if (n == 7) break block8;
                                    if (n == 8) break block9;
                                    if (n != 9 && n != 11) {
                                        throw new NotImplemented();
                                    }
                                    break block5;
                                }
                                childNode = new CommentImpl(coreDocumentImpl, jsonReader.nextString());
                                break block10;
                            }
                            childNode = new ProcessingInstructionImpl(coreDocumentImpl, jsonReader.nextString(), jsonReader.nextString());
                            break block10;
                        }
                        childNode = new CDATASectionImpl(coreDocumentImpl, jsonReader.nextString());
                        break block10;
                    }
                    childNode = new TextImpl(coreDocumentImpl, jsonReader.nextString());
                    break block10;
                }
                throw new IllegalStateException();
            }
            childNode = elementImpl = new ElementImpl(coreDocumentImpl, jsonReader.nextString());
            if (!jsonReader.peek().equals((Object)JsonToken.END_ARRAY)) {
                TerseJson.setChildren(coreDocumentImpl, jsonReader, elementImpl);
                childNode = elementImpl;
                if (!jsonReader.peek().equals((Object)JsonToken.END_ARRAY)) {
                    TerseJson.setAttributes(jsonReader, elementImpl);
                    childNode = elementImpl;
                }
            }
        }
        jsonReader.endArray();
        return childNode;
    }

    protected static void setAttributes(JsonReader jsonReader, Element element) throws IOException {
        jsonReader.beginArray();
        while (!jsonReader.peek().equals((Object)JsonToken.END_ARRAY)) {
            jsonReader.beginArray();
            element.setAttribute(jsonReader.nextString(), jsonReader.nextString());
            jsonReader.endArray();
        }
        jsonReader.endArray();
    }

    protected static void setChildren(CoreDocumentImpl coreDocumentImpl, JsonReader jsonReader, Element element) throws IOException, NotImplemented {
        jsonReader.beginArray();
        while (!jsonReader.peek().equals((Object)JsonToken.END_ARRAY)) {
            element.appendChild(TerseJson.parseNextNode(coreDocumentImpl, jsonReader));
        }
        jsonReader.endArray();
    }

    private boolean shouldIgnoreNodeNotImplemented() {
        return this.options.errorBehaviour.equals((Object)ErrorBehaviour.IgnoreKnownErrors);
    }

    public Object convert(Node node) throws NotImplemented {
        switch (node.getNodeType()) {
            default: {
                break;
            }
            case 11: {
                return new Object[]{node.getNodeType(), this.getChildren(node)};
            }
            case 10: {
                node = (DocumentType)node;
                return XmlNodeToJsonElement.documentType((DocumentType)node, this.convertNamedNodeMap(node.getEntities()), this.convertNamedNodeMap(node.getNotations()));
            }
            case 9: {
                return new Object[]{node.getNodeType(), this.getChildren(node)};
            }
            case 7: {
                return new Object[]{node.getNodeType(), node.getNodeName(), this.getNodeValue(node)};
            }
            case 6: {
                return XmlNodeToJsonElement.entity((Entity)node);
            }
            case 5: 
            case 12: {
                if (!this.shouldIgnoreNodeNotImplemented()) break;
                return new Object[0];
            }
            case 4: 
            case 8: {
                return new Object[]{node.getNodeType(), this.getNodeValue(node)};
            }
            case 3: {
                return this.getNodeValue((Text)node);
            }
            case 2: {
                return new String[]{node.getNodeName(), this.getNodeValue(node)};
            }
            case 1: {
                String[][] stringArray = this.getAttributes(node);
                Object[] objectArray = this.getChildren(node);
                return XmlNodeToJsonElement.element((Element)node, (Object[])stringArray, objectArray);
            }
        }
        throw new NotImplemented(node);
    }

    protected String[][] convertNamedNodeMap(NamedNodeMap namedNodeMap) throws NotImplemented {
        String[][] stringArray = new String[namedNodeMap.getLength()][];
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            stringArray[i] = (String[])this.convert(namedNodeMap.item(i));
        }
        return stringArray;
    }

    public Object fromXml(Node node) throws NotImplemented {
        return this.convert(node);
    }

    protected String[][] getAttributes(Node object) throws NotImplemented {
        object = object.getAttributes();
        String[][] stringArray = new String[object.getLength()][];
        for (int i = 0; i < object.getLength(); ++i) {
            stringArray[i] = (String[])this.convert(object.item(i));
        }
        return stringArray;
    }

    protected Object[] getChildren(Node object) throws NotImplemented {
        switch (object.getNodeType()) {
            default: {
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                if (!this.shouldIgnoreNodeNotImplemented()) break;
                return new Object[0];
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Should not try to get children of node ");
                stringBuilder.append(object.toString());
                throw new IllegalStateException(stringBuilder.toString());
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: {
                object = this.getConvertedChildNodes((Node)object);
                return object.toArray(new Object[object.size()]);
            }
        }
        throw new NotImplemented((Node)object);
    }

    protected List<Object> getConvertedChildNodes(Node object) throws NotImplemented {
        NodeList nodeList = object.getChildNodes();
        object = new ArrayList(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object2 = this.convert(nodeList.item(i));
            if (object2 == null) continue;
            object.add(object2);
        }
        return object;
    }

    protected String getNodeValue(Node node) {
        String string2;
        block5: {
            block4: {
                block3: {
                    string2 = node.getNodeValue();
                    if (string2 == null) {
                        return null;
                    }
                    int n = 1.$SwitchMap$org$leibnizcenter$xml$TerseJson$WhitespaceBehaviour[this.options.whitespaceBehaviour.ordinal()];
                    if (n == 2) break block3;
                    if (n == 3) break block4;
                    break block5;
                }
                if (node.getNodeType() == 3 && string2.matches("^\\s*$")) {
                    return null;
                }
            }
            String string3 = string2;
            if (node.getNodeType() == 3) {
                string3 = string2.replaceAll("\\s\\s+", " ");
            }
            string2 = string3.replaceAll("(^\\s+)|(\\s+$)", "");
        }
        return string2;
    }

    public String stringify(Node node) throws NotImplemented {
        return new Gson().toJson(this.convert(node));
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public Document toXml(InputStream inputStream) throws IOException, NotImplemented {
        void var2_5;
        InputStreamReader inputStreamReader;
        block13: {
            void var4_10;
            JsonReader jsonReader;
            block12: {
                Document document;
                inputStreamReader = new InputStreamReader(inputStream, "utf-8");
                jsonReader = new JsonReader((Reader)inputStreamReader);
                inputStreamReader = jsonReader;
                try {
                    document = TerseJson.parse(jsonReader);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    break block12;
                }
                jsonReader.close();
                if (inputStream != null) {
                    inputStream.close();
                }
                return document;
                catch (Throwable throwable) {
                    inputStreamReader = null;
                    break block13;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    jsonReader = null;
                }
            }
            inputStreamReader = jsonReader;
            inputStreamReader = jsonReader;
            IllegalStateException illegalStateException = new IllegalStateException((Throwable)var4_10);
            inputStreamReader = jsonReader;
            try {
                throw illegalStateException;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (inputStreamReader != null) {
            inputStreamReader.close();
        }
        if (inputStream != null) {
            inputStream.close();
        }
        throw var2_5;
    }

    public Document toXml(String string2) throws IOException, NotImplemented {
        return this.toXml(new ByteArrayInputStream(string2.getBytes(StandardCharsets.UTF_8)));
    }

    public static final class ErrorBehaviour
    extends Enum<ErrorBehaviour> {
        private static final /* synthetic */ ErrorBehaviour[] $VALUES;
        public static final /* enum */ ErrorBehaviour IgnoreKnownErrors;
        public static final /* enum */ ErrorBehaviour ThrowAllErrors;

        static {
            ErrorBehaviour errorBehaviour;
            ErrorBehaviour errorBehaviour2;
            IgnoreKnownErrors = errorBehaviour2 = new ErrorBehaviour();
            ThrowAllErrors = errorBehaviour = new ErrorBehaviour();
            $VALUES = new ErrorBehaviour[]{errorBehaviour2, errorBehaviour};
        }

        public static ErrorBehaviour valueOf(String string2) {
            return Enum.valueOf(ErrorBehaviour.class, string2);
        }

        public static ErrorBehaviour[] values() {
            return (ErrorBehaviour[])$VALUES.clone();
        }
    }

    public static class Options {
        public ErrorBehaviour errorBehaviour;
        public WhitespaceBehaviour whitespaceBehaviour = WhitespaceBehaviour.Preserve;

        public Options() {
            this.errorBehaviour = ErrorBehaviour.ThrowAllErrors;
        }

        public static Options with(ErrorBehaviour errorBehaviour) {
            return new Options().setErrorBehaviour(errorBehaviour);
        }

        public static Options with(WhitespaceBehaviour whitespaceBehaviour) {
            return new Options().setWhitespaceBehaviour(whitespaceBehaviour);
        }

        public Options and(ErrorBehaviour errorBehaviour) {
            return this.setErrorBehaviour(errorBehaviour);
        }

        public Options and(WhitespaceBehaviour whitespaceBehaviour) {
            return this.setWhitespaceBehaviour(whitespaceBehaviour);
        }

        public Options setErrorBehaviour(ErrorBehaviour errorBehaviour) {
            this.errorBehaviour = errorBehaviour;
            return this;
        }

        public Options setWhitespaceBehaviour(WhitespaceBehaviour whitespaceBehaviour) {
            this.whitespaceBehaviour = whitespaceBehaviour;
            return this;
        }
    }

    public static final class WhitespaceBehaviour
    extends Enum<WhitespaceBehaviour> {
        private static final /* synthetic */ WhitespaceBehaviour[] $VALUES;
        public static final /* enum */ WhitespaceBehaviour Compact;
        public static final /* enum */ WhitespaceBehaviour Ignore;
        public static final /* enum */ WhitespaceBehaviour Preserve;

        static {
            WhitespaceBehaviour whitespaceBehaviour;
            WhitespaceBehaviour whitespaceBehaviour2;
            WhitespaceBehaviour whitespaceBehaviour3;
            Preserve = whitespaceBehaviour3 = new WhitespaceBehaviour();
            Compact = whitespaceBehaviour2 = new WhitespaceBehaviour();
            Ignore = whitespaceBehaviour = new WhitespaceBehaviour();
            $VALUES = new WhitespaceBehaviour[]{whitespaceBehaviour3, whitespaceBehaviour2, whitespaceBehaviour};
        }

        public static WhitespaceBehaviour valueOf(String string2) {
            return Enum.valueOf(WhitespaceBehaviour.class, string2);
        }

        public static WhitespaceBehaviour[] values() {
            return (WhitespaceBehaviour[])$VALUES.clone();
        }
    }
}

