/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.classfile;

import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.classfile.ConstantEntry;
import org.mozilla.classfile.FieldOrMethodRef;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.UintMap;

final class ConstantPool {
    static final byte CONSTANT_Class = 7;
    static final byte CONSTANT_Double = 6;
    static final byte CONSTANT_Fieldref = 9;
    static final byte CONSTANT_Float = 4;
    static final byte CONSTANT_Integer = 3;
    static final byte CONSTANT_InterfaceMethodref = 11;
    static final byte CONSTANT_InvokeDynamic = 18;
    static final byte CONSTANT_Long = 5;
    static final byte CONSTANT_MethodHandle = 15;
    static final byte CONSTANT_MethodType = 16;
    static final byte CONSTANT_Methodref = 10;
    static final byte CONSTANT_NameAndType = 12;
    static final byte CONSTANT_String = 8;
    static final byte CONSTANT_Utf8 = 1;
    private static final int ConstantPoolSize = 256;
    private static final int MAX_UTF_ENCODING_SIZE = 65535;
    private ClassFileWriter cfw;
    private ObjToIntMap itsClassHash;
    private UintMap itsConstantData;
    private ObjToIntMap itsConstantHash;
    private ObjToIntMap itsFieldRefHash;
    private ObjToIntMap itsMethodRefHash;
    private byte[] itsPool;
    private UintMap itsPoolTypes;
    private UintMap itsStringConstHash = new UintMap();
    private int itsTop;
    private int itsTopIndex;
    private ObjToIntMap itsUtf8Hash = new ObjToIntMap();

    ConstantPool(ClassFileWriter classFileWriter) {
        this.itsFieldRefHash = new ObjToIntMap();
        this.itsMethodRefHash = new ObjToIntMap();
        this.itsClassHash = new ObjToIntMap();
        this.itsConstantHash = new ObjToIntMap();
        this.itsConstantData = new UintMap();
        this.itsPoolTypes = new UintMap();
        this.cfw = classFileWriter;
        this.itsTopIndex = 1;
        this.itsPool = new byte[256];
        this.itsTop = 0;
    }

    private short addNameAndType(String object, String string2) {
        int n;
        short s = this.addUtf8((String)object);
        int n2 = this.addUtf8(string2);
        this.ensure(5);
        object = this.itsPool;
        int n3 = this.itsTop;
        this.itsTop = n = n3 + 1;
        object[n3] = (byte)12;
        this.itsTop = n = ClassFileWriter.putInt16(s, (byte[])object, n);
        this.itsTop = ClassFileWriter.putInt16(n2, this.itsPool, n);
        this.itsPoolTypes.put(this.itsTopIndex, 12);
        n2 = this.itsTopIndex;
        this.itsTopIndex = n2 + 1;
        return (short)n2;
    }

    private void ensure(int n) {
        int n2 = this.itsTop;
        byte[] byArray = this.itsPool;
        if (n2 + n > byArray.length) {
            int n3;
            int n4 = n3 = byArray.length * 2;
            if (n2 + n > n3) {
                n4 = n2 + n;
            }
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            this.itsPool = byArray2;
        }
    }

    short addClass(String string2) {
        int n;
        int n2 = n = this.itsClassHash.get(string2, -1);
        if (n == -1) {
            String string3;
            if (string2.indexOf(46) > 0) {
                string3 = ClassFileWriter.getSlashedForm(string2);
                n = this.itsClassHash.get(string3, -1);
                if (n != -1) {
                    this.itsClassHash.put(string2, n);
                }
            } else {
                string3 = string2;
            }
            n2 = n;
            if (n == -1) {
                int n3;
                n2 = this.addUtf8(string3);
                this.ensure(3);
                byte[] byArray = this.itsPool;
                n = this.itsTop;
                this.itsTop = n3 = n + 1;
                byArray[n] = (byte)7;
                this.itsTop = ClassFileWriter.putInt16(n2, byArray, n3);
                n = this.itsTopIndex;
                this.itsTopIndex = n + 1;
                this.itsClassHash.put(string3, n);
                n2 = n;
                if (!string2.equals(string3)) {
                    this.itsClassHash.put(string2, n);
                    n2 = n;
                }
            }
        }
        this.setConstantData(n2, string2);
        this.itsPoolTypes.put(n2, 7);
        return (short)n2;
    }

    int addConstant(double d) {
        this.ensure(9);
        byte[] byArray = this.itsPool;
        int n = this.itsTop;
        this.itsTop = n + 1;
        byArray[n] = (byte)6;
        this.itsTop = ClassFileWriter.putInt64(Double.doubleToLongBits(d), this.itsPool, this.itsTop);
        n = this.itsTopIndex;
        this.itsTopIndex = n + 2;
        this.itsPoolTypes.put(n, 6);
        return n;
    }

    int addConstant(float f) {
        this.ensure(5);
        byte[] byArray = this.itsPool;
        int n = this.itsTop;
        this.itsTop = n + 1;
        byArray[n] = (byte)4;
        this.itsTop = ClassFileWriter.putInt32(Float.floatToIntBits(f), this.itsPool, this.itsTop);
        this.itsPoolTypes.put(this.itsTopIndex, 4);
        n = this.itsTopIndex;
        this.itsTopIndex = n + 1;
        return n;
    }

    int addConstant(int n) {
        int n2;
        this.ensure(5);
        byte[] byArray = this.itsPool;
        int n3 = this.itsTop;
        this.itsTop = n2 = n3 + 1;
        byArray[n3] = (byte)3;
        this.itsTop = ClassFileWriter.putInt32(n, byArray, n2);
        this.itsPoolTypes.put(this.itsTopIndex, 3);
        n = this.itsTopIndex;
        this.itsTopIndex = n + 1;
        return (short)n;
    }

    int addConstant(long l) {
        int n;
        this.ensure(9);
        byte[] byArray = this.itsPool;
        int n2 = this.itsTop;
        this.itsTop = n = n2 + 1;
        byArray[n2] = (byte)5;
        this.itsTop = ClassFileWriter.putInt64(l, byArray, n);
        n2 = this.itsTopIndex;
        this.itsTopIndex = n2 + 2;
        this.itsPoolTypes.put(n2, 5);
        return n2;
    }

    int addConstant(Object object) {
        if (!(object instanceof Integer || object instanceof Byte || object instanceof Short)) {
            if (object instanceof Character) {
                return this.addConstant(((Character)object).charValue());
            }
            if (object instanceof Boolean) {
                return this.addConstant(((Boolean)object).booleanValue() ? 1 : 0);
            }
            if (object instanceof Float) {
                return this.addConstant(((Float)object).floatValue());
            }
            if (object instanceof Long) {
                return this.addConstant((Long)object);
            }
            if (object instanceof Double) {
                return this.addConstant((Double)object);
            }
            if (object instanceof String) {
                return this.addConstant((String)object);
            }
            if (object instanceof ClassFileWriter.MHandle) {
                return this.addMethodHandle((ClassFileWriter.MHandle)object);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("value ");
            stringBuilder.append(object);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        return this.addConstant(((Number)object).intValue());
    }

    int addConstant(String object) {
        int n;
        int n2 = this.addUtf8((String)object) & 0xFFFF;
        int n3 = n = this.itsStringConstHash.getInt(n2, -1);
        if (n == -1) {
            int n4;
            n3 = this.itsTopIndex;
            this.itsTopIndex = n3 + 1;
            this.ensure(3);
            object = this.itsPool;
            n = this.itsTop;
            this.itsTop = n4 = n + 1;
            object[n] = (byte)8;
            this.itsTop = ClassFileWriter.putInt16(n2, (byte[])object, n4);
            this.itsStringConstHash.put(n2, n3);
        }
        this.itsPoolTypes.put(n3, 8);
        return n3;
    }

    short addFieldRef(String object, String string2, String string3) {
        int n;
        FieldOrMethodRef fieldOrMethodRef = new FieldOrMethodRef((String)object, string2, string3);
        int n2 = n = this.itsFieldRefHash.get(fieldOrMethodRef, -1);
        if (n == -1) {
            int n3;
            n2 = this.addNameAndType(string2, string3);
            n = this.addClass((String)object);
            this.ensure(5);
            object = this.itsPool;
            int n4 = this.itsTop;
            this.itsTop = n3 = n4 + 1;
            object[n4] = (byte)9;
            this.itsTop = n = ClassFileWriter.putInt16(n, (byte[])object, n3);
            this.itsTop = ClassFileWriter.putInt16(n2, this.itsPool, n);
            n2 = this.itsTopIndex;
            this.itsTopIndex = n2 + 1;
            this.itsFieldRefHash.put(fieldOrMethodRef, n2);
        }
        this.setConstantData(n2, fieldOrMethodRef);
        this.itsPoolTypes.put(n2, 9);
        return (short)n2;
    }

    short addInterfaceMethodRef(String object, String string2, String string3) {
        int n;
        int n2 = this.addNameAndType(string2, string3);
        short s = this.addClass((String)object);
        this.ensure(5);
        byte[] byArray = this.itsPool;
        int n3 = this.itsTop;
        this.itsTop = n = n3 + 1;
        byArray[n3] = (byte)11;
        this.itsTop = n3 = ClassFileWriter.putInt16(s, byArray, n);
        this.itsTop = ClassFileWriter.putInt16(n2, this.itsPool, n3);
        object = new FieldOrMethodRef((String)object, string2, string3);
        this.setConstantData(this.itsTopIndex, object);
        this.itsPoolTypes.put(this.itsTopIndex, 11);
        n2 = this.itsTopIndex;
        this.itsTopIndex = n2 + 1;
        return (short)n2;
    }

    short addInvokeDynamic(String object, String string2, int n) {
        int n2;
        ConstantEntry constantEntry = new ConstantEntry(18, n, (String)object, string2);
        int n3 = n2 = this.itsConstantHash.get(constantEntry, -1);
        if (n2 == -1) {
            int n4;
            n3 = this.addNameAndType((String)object, string2);
            this.ensure(5);
            object = this.itsPool;
            n2 = this.itsTop;
            this.itsTop = n4 = n2 + 1;
            object[n2] = (byte)18;
            this.itsTop = n = ClassFileWriter.putInt16(n, (byte[])object, n4);
            this.itsTop = ClassFileWriter.putInt16(n3, this.itsPool, n);
            n3 = this.itsTopIndex;
            this.itsTopIndex = n3 + 1;
            this.itsConstantHash.put(constantEntry, n3);
            this.setConstantData(n3, string2);
            this.itsPoolTypes.put(n3, 18);
        }
        return (short)n3;
    }

    short addMethodHandle(ClassFileWriter.MHandle mHandle) {
        int n;
        int n2 = n = this.itsConstantHash.get(mHandle, -1);
        if (n == -1) {
            n2 = mHandle.tag <= 4 ? (int)this.addFieldRef(mHandle.owner, mHandle.name, mHandle.desc) : (mHandle.tag == 9 ? (int)this.addInterfaceMethodRef(mHandle.owner, mHandle.name, mHandle.desc) : (int)this.addMethodRef(mHandle.owner, mHandle.name, mHandle.desc));
            this.ensure(4);
            byte[] byArray = this.itsPool;
            int n3 = this.itsTop;
            this.itsTop = n = n3 + 1;
            byArray[n3] = (byte)15;
            this.itsTop = n + 1;
            byArray[n] = mHandle.tag;
            this.itsTop = ClassFileWriter.putInt16(n2, this.itsPool, this.itsTop);
            n2 = this.itsTopIndex;
            this.itsTopIndex = n2 + 1;
            this.itsConstantHash.put(mHandle, n2);
            this.itsPoolTypes.put(n2, 15);
        }
        return (short)n2;
    }

    short addMethodRef(String object, String string2, String string3) {
        int n;
        FieldOrMethodRef fieldOrMethodRef = new FieldOrMethodRef((String)object, string2, string3);
        int n2 = n = this.itsMethodRefHash.get(fieldOrMethodRef, -1);
        if (n == -1) {
            n2 = this.addNameAndType(string2, string3);
            short s = this.addClass((String)object);
            this.ensure(5);
            object = this.itsPool;
            int n3 = this.itsTop;
            this.itsTop = n = n3 + 1;
            object[n3] = (byte)10;
            this.itsTop = n = ClassFileWriter.putInt16(s, (byte[])object, n);
            this.itsTop = ClassFileWriter.putInt16(n2, this.itsPool, n);
            n2 = this.itsTopIndex;
            this.itsTopIndex = n2 + 1;
            this.itsMethodRefHash.put(fieldOrMethodRef, n2);
        }
        this.setConstantData(n2, fieldOrMethodRef);
        this.itsPoolTypes.put(n2, 10);
        return (short)n2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    short addUtf8(String var1_1) {
        var3_3 = var2_2 = this.itsUtf8Hash.get(var1_1, -1);
        if (var2_2 == -1) {
            var4_4 = var1_1.length();
            var5_5 = 0;
            if (var4_4 > 65535) {
                while (true) {
                    var6_6 = 1;
                    var3_3 = var2_2;
                    var2_2 = var6_6;
                    break;
                }
            } else {
                this.ensure(var4_4 * 3 + 3);
                var3_3 = this.itsTop;
                this.itsPool[var3_3] = (byte)true;
                var3_3 = var3_3 + 1 + 2;
                var7_7 /* !! */  = this.cfw.getCharBuffer(var4_4);
                var1_1.getChars(0, var4_4, var7_7 /* !! */ , 0);
                for (var6_6 = 0; var6_6 != var4_4; ++var6_6) {
                    var8_8 = var7_7 /* !! */ [var6_6];
                    if (var8_8 != '\u0000' && var8_8 <= '\u007f') {
                        var9_9 = this.itsPool;
                        var10_10 = var3_3 + 1;
                        var9_9[var3_3] = (byte)var8_8;
                        var3_3 = var10_10;
                        continue;
                    }
                    if (var8_8 > '\u07ff') {
                        var9_9 = this.itsPool;
                        var10_10 = var3_3 + 1;
                        var9_9[var3_3] = (byte)(var8_8 >> 12 | 224);
                        var11_11 = var10_10 + 1;
                        var9_9[var10_10] = (byte)(var8_8 >> 6 & 63 | 128);
                        var3_3 = var11_11 + 1;
                        var9_9[var11_11] = (byte)(var8_8 & 63 | 128);
                        continue;
                    }
                    var9_9 = this.itsPool;
                    var10_10 = var3_3 + 1;
                    var9_9[var3_3] = (byte)(var8_8 >> 6 | 192);
                    var3_3 = var10_10 + 1;
                    var9_9[var10_10] = (byte)(var8_8 & 63 | 128);
                }
                if ((var10_10 = var3_3 - ((var6_6 = this.itsTop) + 1 + 2)) > 65535) ** continue;
                var7_7 /* !! */  = (char[])this.itsPool;
                var7_7 /* !! */ [var6_6 + 1] = (char)((byte)(var10_10 >>> 8));
                var7_7 /* !! */ [var6_6 + 2] = (char)((byte)var10_10);
                this.itsTop = var3_3;
                var3_3 = this.itsTopIndex;
                this.itsTopIndex = var3_3 + 1;
                this.itsUtf8Hash.put(var1_1, var3_3);
                var2_2 = var5_5;
            }
            if (var2_2 != 0) {
                throw new IllegalArgumentException("Too big string");
            }
        }
        this.setConstantData(var3_3, var1_1);
        this.itsPoolTypes.put(var3_3, 1);
        return (short)var3_3;
    }

    Object getConstantData(int n) {
        return this.itsConstantData.getObject(n);
    }

    byte getConstantType(int n) {
        return (byte)this.itsPoolTypes.getInt(n, 0);
    }

    int getUtfEncodingLimit(String string2, int n, int n2) {
        int n3 = 65535;
        if ((n2 - n) * 3 <= 65535) {
            return n2;
        }
        for (int i = n; i != n2; ++i) {
            n = string2.charAt(i);
            n = n != 0 && n <= 127 ? n3 - 1 : (n < 2047 ? n3 - 2 : n3 - 3);
            if (n < 0) {
                return i;
            }
            n3 = n;
        }
        return n2;
    }

    int getWriteSize() {
        return this.itsTop + 2;
    }

    boolean isUnderUtfEncodingLimit(String string2) {
        int n = string2.length();
        boolean bl = true;
        if (n * 3 <= 65535) {
            return true;
        }
        if (n > 65535) {
            return false;
        }
        if (n != this.getUtfEncodingLimit(string2, 0, n)) {
            bl = false;
        }
        return bl;
    }

    void setConstantData(int n, Object object) {
        this.itsConstantData.put(n, object);
    }

    int write(byte[] byArray, int n) {
        n = ClassFileWriter.putInt16((short)this.itsTopIndex, byArray, n);
        System.arraycopy(this.itsPool, 0, byArray, n, this.itsTop);
        return n + this.itsTop;
    }
}

