/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.classfile;

import org.mozilla.classfile.ConstantPool;
import org.mozilla.classfile.TypeInfo;

final class SuperBlock {
    private int end;
    private int index;
    private boolean isInQueue;
    private boolean isInitialized;
    private int[] locals;
    private int[] stack;
    private int start;

    SuperBlock(int n, int n2, int n3, int[] nArray) {
        this.index = n;
        this.start = n2;
        this.end = n3;
        int[] nArray2 = new int[nArray.length];
        this.locals = nArray2;
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.stack = new int[0];
        this.isInitialized = false;
        this.isInQueue = false;
    }

    private boolean mergeState(int[] nArray, int[] nArray2, int n, ConstantPool constantPool) {
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            nArray[i] = TypeInfo.merge(nArray[i], nArray2[i], constantPool);
            if (n2 == nArray[i]) continue;
            bl = true;
        }
        return bl;
    }

    int getEnd() {
        return this.end;
    }

    int getIndex() {
        return this.index;
    }

    int[] getLocals() {
        int[] nArray = this.locals;
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    int[] getStack() {
        int[] nArray = this.stack;
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    int getStart() {
        return this.start;
    }

    int[] getTrimmedLocals() {
        int n;
        int[] nArray;
        int n2;
        for (n2 = this.locals.length - 1; n2 >= 0 && (nArray = this.locals)[n2] == 0 && !TypeInfo.isTwoWords(nArray[n2 - 1]); --n2) {
        }
        int n3 = n2 + 1;
        int n4 = 0;
        int n5 = n3;
        for (n2 = 0; n2 < n3; ++n2) {
            n = n5;
            if (TypeInfo.isTwoWords(this.locals[n2])) {
                n = n5 - 1;
            }
            n5 = n;
        }
        nArray = new int[n5];
        n2 = 0;
        for (n = n4; n < n5; ++n) {
            int[] nArray2 = this.locals;
            nArray[n] = nArray2[n2];
            n4 = n2;
            if (TypeInfo.isTwoWords(nArray2[n2])) {
                n4 = n2 + 1;
            }
            n2 = n4 + 1;
        }
        return nArray;
    }

    boolean isInQueue() {
        return this.isInQueue;
    }

    boolean isInitialized() {
        return this.isInitialized;
    }

    boolean merge(int[] nArray, int n, int[] nArray2, int n2, ConstantPool constantPool) {
        boolean bl = this.isInitialized;
        boolean bl2 = true;
        if (!bl) {
            System.arraycopy(nArray, 0, this.locals, 0, n);
            nArray = new int[n2];
            this.stack = nArray;
            System.arraycopy(nArray2, 0, nArray, 0, n2);
            this.isInitialized = true;
            return true;
        }
        int[] nArray3 = this.locals;
        if (nArray3.length == n && this.stack.length == n2) {
            boolean bl3 = this.mergeState(nArray3, nArray, n, constantPool);
            boolean bl4 = this.mergeState(this.stack, nArray2, n2, constantPool);
            bl = bl2;
            if (!bl3) {
                bl = bl4 ? bl2 : false;
            }
            return bl;
        }
        throw new IllegalArgumentException("bad merge attempt");
    }

    void setInQueue(boolean bl) {
        this.isInQueue = bl;
    }

    void setInitialized(boolean bl) {
        this.isInitialized = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("sb ");
        stringBuilder.append(this.index);
        return stringBuilder.toString();
    }
}

