/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.classfile;

import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.classfile.ConstantPool;

final class TypeInfo {
    static final int DOUBLE = 3;
    static final int FLOAT = 2;
    static final int INTEGER = 1;
    static final int LONG = 4;
    static final int NULL = 5;
    static final int OBJECT_TAG = 7;
    static final int TOP = 0;
    static final int UNINITIALIZED_THIS = 6;
    static final int UNINITIALIZED_VAR_TAG = 8;

    private TypeInfo() {
    }

    static final int OBJECT(int n) {
        return (n & 0xFFFF) << 8 | 7;
    }

    static final int OBJECT(String string2, ConstantPool constantPool) {
        return TypeInfo.OBJECT(constantPool.addClass(string2));
    }

    static final int UNINITIALIZED_VARIABLE(int n) {
        return (n & 0xFFFF) << 8 | 8;
    }

    static final int fromType(String string2, ConstantPool constantPool) {
        if (string2.length() == 1) {
            char c = string2.charAt(0);
            if (c != 'F') {
                if (c != 'S' && c != 'Z' && c != 'I') {
                    if (c != 'J') {
                        switch (c) {
                            default: {
                                throw new IllegalArgumentException("bad type");
                            }
                            case 'D': {
                                return 3;
                            }
                            case 'B': 
                            case 'C': {
                                return 1;
                            }
                        }
                    }
                    return 4;
                }
                return 1;
            }
            return 2;
        }
        return TypeInfo.OBJECT(string2, constantPool);
    }

    private static Class<?> getClassFromInternalName(String object) {
        try {
            object = Class.forName(((String)object).replace('/', '.'));
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    static final int getPayload(int n) {
        return n >>> 8;
    }

    static final String getPayloadAsType(int n, ConstantPool constantPool) {
        if (TypeInfo.getTag(n) == 7) {
            return (String)constantPool.getConstantData(TypeInfo.getPayload(n));
        }
        throw new IllegalArgumentException("expecting object type");
    }

    static final int getTag(int n) {
        return n & 0xFF;
    }

    static boolean isTwoWords(int n) {
        boolean bl = n == 3 || n == 4;
        return bl;
    }

    static int merge(int n, int n2, ConstantPool constantPool) {
        int n3 = TypeInfo.getTag(n);
        int n4 = TypeInfo.getTag(n2);
        boolean bl = true;
        boolean bl2 = n3 == 7;
        if (n4 != 7) {
            bl = false;
        }
        if (!(n == n2 || bl2 && n2 == 5)) {
            if (n3 != 0 && n4 != 0) {
                Class clazz;
                if (n == 5 && bl) {
                    return n2;
                }
                if (bl2 && bl) {
                    String string2 = TypeInfo.getPayloadAsType(n, constantPool);
                    String string3 = TypeInfo.getPayloadAsType(n2, constantPool);
                    String string4 = (String)constantPool.getConstantData(2);
                    Object object = (String)constantPool.getConstantData(4);
                    clazz = string2;
                    if (string2.equals(string4)) {
                        clazz = object;
                    }
                    string2 = string3;
                    if (string3.equals(string4)) {
                        string2 = object;
                    }
                    if (((Class)(object = TypeInfo.getClassFromInternalName((String)((Object)clazz)))).isAssignableFrom(clazz = TypeInfo.getClassFromInternalName(string2))) {
                        return n;
                    }
                    if (clazz.isAssignableFrom((Class<?>)object)) {
                        return n2;
                    }
                    if (!clazz.isInterface() && !((Class)object).isInterface()) {
                        for (clazz = clazz.getSuperclass(); clazz != null; clazz = clazz.getSuperclass()) {
                            if (!clazz.isAssignableFrom((Class<?>)object)) continue;
                            return TypeInfo.OBJECT(ClassFileWriter.getSlashedForm(clazz.getName()), constantPool);
                        }
                    } else {
                        return TypeInfo.OBJECT("java/lang/Object", constantPool);
                    }
                }
                clazz = new StringBuilder();
                ((StringBuilder)((Object)clazz)).append("bad merge attempt between ");
                ((StringBuilder)((Object)clazz)).append(TypeInfo.toString(n, constantPool));
                ((StringBuilder)((Object)clazz)).append(" and ");
                ((StringBuilder)((Object)clazz)).append(TypeInfo.toString(n2, constantPool));
                throw new IllegalArgumentException(((StringBuilder)((Object)clazz)).toString());
            }
            return 0;
        }
        return n;
    }

    static void print(int[] nArray, int n, int[] nArray2, int n2, ConstantPool constantPool) {
        System.out.print("locals: ");
        System.out.println(TypeInfo.toString(nArray, n, constantPool));
        System.out.print("stack: ");
        System.out.println(TypeInfo.toString(nArray2, n2, constantPool));
        System.out.println();
    }

    static void print(int[] nArray, int[] nArray2, ConstantPool constantPool) {
        TypeInfo.print(nArray, nArray.length, nArray2, nArray2.length, constantPool);
    }

    static String toString(int n, ConstantPool constantPool) {
        int n2 = TypeInfo.getTag(n);
        switch (n2) {
            default: {
                if (n2 != 7) break;
                return TypeInfo.getPayloadAsType(n, constantPool);
            }
            case 6: {
                return "uninitialized_this";
            }
            case 5: {
                return "null";
            }
            case 4: {
                return "long";
            }
            case 3: {
                return "double";
            }
            case 2: {
                return "float";
            }
            case 1: {
                return "int";
            }
            case 0: {
                return "top";
            }
        }
        if (n2 == 8) {
            return "uninitialized";
        }
        throw new IllegalArgumentException("bad type");
    }

    private static String toString(int[] nArray, int n, ConstantPool constantPool) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(TypeInfo.toString(nArray[i], constantPool));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

