/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeArrayIterator;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.UniqueTag;

final class Arguments
extends IdScriptableObject {
    private static final String FTAG = "Arguments";
    private static final int Id_callee = 1;
    private static final int Id_caller = 3;
    private static final int Id_length = 2;
    private static final int MAX_INSTANCE_ID = 3;
    private static BaseFunction iteratorMethod = new BaseFunction(){

        @Override
        public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
            return new NativeArrayIterator(scriptable, scriptable2);
        }
    };
    static final long serialVersionUID = 4275508002492040609L;
    private NativeCall activation;
    private Object[] args;
    private int calleeAttr = 2;
    private Object calleeObj;
    private int callerAttr = 2;
    private Object callerObj;
    private int lengthAttr = 2;
    private Object lengthObj;

    public Arguments(NativeCall idScriptableObject) {
        this.activation = idScriptableObject;
        Object[] objectArray = idScriptableObject.getParentScope();
        this.setParentScope((Scriptable)objectArray);
        this.setPrototype(ScriptableObject.getObjectPrototype((Scriptable)objectArray));
        objectArray = ((NativeCall)idScriptableObject).originalArgs;
        this.args = objectArray;
        this.lengthObj = objectArray.length;
        idScriptableObject = ((NativeCall)idScriptableObject).function;
        this.calleeObj = idScriptableObject;
        int n = ((NativeFunction)idScriptableObject).getLanguageVersion();
        this.callerObj = n <= 130 && n != 0 ? null : NOT_FOUND;
        this.defineProperty(SymbolKey.ITERATOR, (Object)iteratorMethod, 2);
    }

    private Object arg(int n) {
        Object[] objectArray;
        if (n >= 0 && (objectArray = this.args).length > n) {
            return objectArray[n];
        }
        return NOT_FOUND;
    }

    private Object getFromActivation(int n) {
        String string2 = this.activation.function.getParamOrVarName(n);
        NativeCall nativeCall = this.activation;
        return nativeCall.get(string2, (Scriptable)nativeCall);
    }

    private void putIntoActivation(int n, Object object) {
        String string2 = this.activation.function.getParamOrVarName(n);
        NativeCall nativeCall = this.activation;
        nativeCall.put(string2, (Scriptable)nativeCall, object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeArg(int n) {
        synchronized (this) {
            if (this.args[n] != NOT_FOUND) {
                if (this.args == this.activation.originalArgs) {
                    this.args = (Object[])this.args.clone();
                }
                this.args[n] = NOT_FOUND;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void replaceArg(int n, Object object) {
        if (this.sharedWithActivation(n)) {
            this.putIntoActivation(n, object);
        }
        synchronized (this) {
            if (this.args == this.activation.originalArgs) {
                this.args = (Object[])this.args.clone();
            }
            this.args[n] = object;
            return;
        }
    }

    private boolean sharedWithActivation(int n) {
        if (Context.getContext().isStrictMode()) {
            return false;
        }
        NativeFunction nativeFunction = this.activation.function;
        int n2 = nativeFunction.getParamCount();
        if (n < n2) {
            if (n < n2 - 1) {
                String string2 = nativeFunction.getParamOrVarName(n);
                ++n;
                while (n < n2) {
                    if (string2.equals(nativeFunction.getParamOrVarName(n))) {
                        return false;
                    }
                    ++n;
                }
            }
            return true;
        }
        return false;
    }

    void defineAttributesForStrictMode() {
        if (!Context.getContext().isStrictMode()) {
            return;
        }
        this.setGetterOrSetter("caller", 0, new ThrowTypeError("caller"), true);
        this.setGetterOrSetter("caller", 0, new ThrowTypeError("caller"), false);
        this.setGetterOrSetter("callee", 0, new ThrowTypeError("callee"), true);
        this.setGetterOrSetter("callee", 0, new ThrowTypeError("callee"), false);
        this.setAttributes("caller", 6);
        this.setAttributes("callee", 6);
        this.callerObj = null;
        this.calleeObj = null;
    }

    @Override
    protected void defineOwnProperty(Context object, Object object2, ScriptableObject scriptableObject, boolean bl) {
        super.defineOwnProperty((Context)object, object2, scriptableObject, bl);
        double d = ScriptRuntime.toNumber(object2);
        int n = (int)d;
        if (d != (double)n) {
            return;
        }
        if (this.arg(n) == NOT_FOUND) {
            return;
        }
        if (this.isAccessorDescriptor(scriptableObject)) {
            this.removeArg(n);
            return;
        }
        object = Arguments.getProperty((Scriptable)scriptableObject, "value");
        if (object == NOT_FOUND) {
            return;
        }
        this.replaceArg(n, object);
        if (Arguments.isFalse(Arguments.getProperty((Scriptable)scriptableObject, "writable"))) {
            this.removeArg(n);
        }
    }

    @Override
    public void delete(int n) {
        if (n >= 0 && n < this.args.length) {
            this.removeArg(n);
        }
        super.delete(n);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected int findInstanceIdInfo(String var1_1) {
        block12: {
            block11: {
                var2_2 = var1_1.length();
                var3_3 = 0;
                if (var2_2 != 6) ** GOTO lbl-1000
                var2_2 = var1_1.charAt(5);
                if (var2_2 == 101) {
                    var4_4 = "callee";
                    var2_2 = 1;
                } else if (var2_2 == 104) {
                    var4_4 = "length";
                    var2_2 = 2;
                } else if (var2_2 == 114) {
                    var4_4 = "caller";
                    var2_2 = 3;
                } else lbl-1000:
                // 2 sources

                {
                    var4_4 = null;
                    var2_2 = 0;
                }
                if (var4_4 == null || var4_4 == var1_1 || var4_4.equals(var1_1)) {
                    var3_3 = var2_2;
                }
                if (Context.getContext().isStrictMode() && (var3_3 == 1 || var3_3 == 3)) {
                    return super.findInstanceIdInfo(var1_1);
                }
                if (var3_3 == 0) {
                    return super.findInstanceIdInfo(var1_1);
                }
                if (var3_3 == 1) break block11;
                if (var3_3 == 2) ** GOTO lbl31
                if (var3_3 == 3) {
                    var2_2 = this.callerAttr;
                } else {
                    throw new IllegalStateException();
lbl31:
                    // 1 sources

                    var2_2 = this.lengthAttr;
                }
                break block12;
            }
            var2_2 = this.calleeAttr;
        }
        return Arguments.instanceIdInfo(var2_2, var3_3);
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        Object object = this.arg(n);
        if (object == NOT_FOUND) {
            return super.get(n, scriptable);
        }
        if (this.sharedWithActivation(n)) {
            return this.getFromActivation(n);
        }
        return object;
    }

    @Override
    public String getClassName() {
        return FTAG;
    }

    @Override
    Object[] getIds(boolean bl, boolean bl2) {
        Object[] objectArray = super.getIds(bl, bl2);
        Object[] objectArray2 = this.args;
        Object object = objectArray;
        if (objectArray2.length != 0) {
            int n;
            int n2;
            int n3 = objectArray2.length;
            boolean[] blArray = new boolean[n3];
            int n4 = objectArray2.length;
            int n5 = 0;
            for (n2 = 0; n2 != objectArray.length; ++n2) {
                object = objectArray[n2];
                n = n4;
                if (object instanceof Integer) {
                    int n6 = (Integer)object;
                    n = n4;
                    if (n6 >= 0) {
                        n = n4;
                        if (n6 < this.args.length) {
                            n = n4;
                            if (!blArray[n6]) {
                                blArray[n6] = true;
                                n = n4 - 1;
                            }
                        }
                    }
                }
                n4 = n;
            }
            n2 = n4;
            if (!bl) {
                n = 0;
                while (true) {
                    n2 = n4;
                    if (n >= n3) break;
                    n2 = n4;
                    if (!blArray[n]) {
                        n2 = n4;
                        if (super.has(n, (Scriptable)this)) {
                            blArray[n] = true;
                            n2 = n4 - 1;
                        }
                    }
                    ++n;
                    n4 = n2;
                }
            }
            object = objectArray;
            if (n2 != 0) {
                object = new Object[objectArray.length + n2];
                System.arraycopy(objectArray, 0, object, n2, objectArray.length);
                n = 0;
                for (n4 = n5; n4 != this.args.length; ++n4) {
                    n5 = n;
                    if (!blArray[n4]) {
                        object[n] = n4;
                        n5 = n + 1;
                    }
                    n = n5;
                }
                if (n != n2) {
                    Kit.codeBug();
                }
            }
        }
        return object;
    }

    @Override
    protected String getInstanceIdName(int n) {
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    return null;
                }
                return "caller";
            }
            return "length";
        }
        return "callee";
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        if (n != 1) {
            if (n != 2) {
                Object object;
                if (n != 3) {
                    return super.getInstanceIdValue(n);
                }
                Object object2 = this.callerObj;
                if (object2 == UniqueTag.NULL_VALUE) {
                    object = null;
                } else {
                    object = object2;
                    if (object2 == null) {
                        NativeCall nativeCall = this.activation.parentActivationCall;
                        object = object2;
                        if (nativeCall != null) {
                            object = nativeCall.get("arguments", (Scriptable)nativeCall);
                        }
                    }
                }
                return object;
            }
            return this.lengthObj;
        }
        return this.calleeObj;
    }

    @Override
    protected int getMaxInstanceId() {
        return 3;
    }

    @Override
    protected ScriptableObject getOwnPropertyDescriptor(Context object, Object object2) {
        int n;
        if (object2 instanceof Scriptable) {
            return super.getOwnPropertyDescriptor((Context)object, object2);
        }
        double d = ScriptRuntime.toNumber(object2);
        if (d != (double)(n = (int)d)) {
            return super.getOwnPropertyDescriptor((Context)object, object2);
        }
        Object object3 = this.arg(n);
        if (object3 == NOT_FOUND) {
            return super.getOwnPropertyDescriptor((Context)object, object2);
        }
        if (this.sharedWithActivation(n)) {
            object3 = this.getFromActivation(n);
        }
        if (super.has(n, (Scriptable)this)) {
            object = super.getOwnPropertyDescriptor((Context)object, object2);
            ((ScriptableObject)object).put("value", (Scriptable)object, object3);
            return object;
        }
        object = object2 = this.getParentScope();
        if (object2 == null) {
            object = this;
        }
        return Arguments.buildDataDescriptor((Scriptable)object, object3, 0);
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        if (this.arg(n) != NOT_FOUND) {
            return true;
        }
        return super.has(n, scriptable);
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        if (this.arg(n) == NOT_FOUND) {
            super.put(n, scriptable, object);
        } else {
            this.replaceArg(n, object);
        }
    }

    @Override
    public void put(String string2, Scriptable scriptable, Object object) {
        super.put(string2, scriptable, object);
    }

    @Override
    protected void setInstanceIdAttributes(int n, int n2) {
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    super.setInstanceIdAttributes(n, n2);
                    return;
                }
                this.callerAttr = n2;
                return;
            }
            this.lengthAttr = n2;
            return;
        }
        this.calleeAttr = n2;
    }

    @Override
    protected void setInstanceIdValue(int n, Object object) {
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    super.setInstanceIdValue(n, object);
                    return;
                }
                if (object == null) {
                    object = UniqueTag.NULL_VALUE;
                }
                this.callerObj = object;
                return;
            }
            this.lengthObj = object;
            return;
        }
        this.calleeObj = object;
    }

    private static class ThrowTypeError
    extends BaseFunction {
        private String propertyName;

        ThrowTypeError(String string2) {
            this.propertyName = string2;
        }

        @Override
        public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
            throw ScriptRuntime.typeError1("msg.arguments.not.access.strict", this.propertyName);
        }
    }
}

