/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ArrowFunction
extends BaseFunction {
    static final long serialVersionUID = -7377989503697220633L;
    private final Scriptable boundThis;
    private final Callable targetFunction;

    public ArrowFunction(Context context, Scriptable scriptable, Callable object, Scriptable scriptable2) {
        this.targetFunction = object;
        this.boundThis = scriptable2;
        ScriptRuntime.setFunctionProtoAndParent(this, scriptable);
        object = ScriptRuntime.typeErrorThrower();
        scriptable = new NativeObject();
        ((IdScriptableObject)scriptable).put("get", scriptable, object);
        ((IdScriptableObject)scriptable).put("set", scriptable, object);
        object = false;
        ((IdScriptableObject)scriptable).put("enumerable", scriptable, object);
        ((IdScriptableObject)scriptable).put("configurable", scriptable, object);
        ((ScriptableObject)scriptable).preventExtensions();
        this.defineOwnProperty(context, "caller", (ScriptableObject)scriptable, false);
        this.defineOwnProperty(context, "arguments", (ScriptableObject)scriptable, false);
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        scriptable2 = this.boundThis;
        if (scriptable2 == null) {
            scriptable2 = ScriptRuntime.getTopCallScope(context);
        }
        return this.targetFunction.call(context, scriptable, scriptable2, objectArray);
    }

    @Override
    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        throw ScriptRuntime.typeError1("msg.not.ctor", this.decompile(0, 0));
    }

    @Override
    String decompile(int n, int n2) {
        Callable callable = this.targetFunction;
        if (callable instanceof BaseFunction) {
            return ((BaseFunction)callable).decompile(n, n2);
        }
        return super.decompile(n, n2);
    }

    @Override
    public int getLength() {
        Callable callable = this.targetFunction;
        if (callable instanceof BaseFunction) {
            return ((BaseFunction)callable).getLength();
        }
        return 0;
    }

    @Override
    public boolean hasInstance(Scriptable scriptable) {
        Callable callable = this.targetFunction;
        if (callable instanceof Function) {
            return ((Function)callable).hasInstance(scriptable);
        }
        throw ScriptRuntime.typeError0("msg.not.ctor");
    }
}

