/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BoundFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.DefaultErrorReporter;
import org.mozilla.javascript.Delegator;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Evaluator;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UniqueTag;

public class BaseFunction
extends IdScriptableObject
implements Function {
    private static final Object FUNCTION_TAG = "Function";
    private static final int Id_apply = 4;
    private static final int Id_arguments = 5;
    private static final int Id_arity = 2;
    private static final int Id_bind = 6;
    private static final int Id_call = 5;
    private static final int Id_constructor = 1;
    private static final int Id_length = 1;
    private static final int Id_name = 3;
    private static final int Id_prototype = 4;
    private static final int Id_toSource = 3;
    private static final int Id_toString = 2;
    private static final int MAX_INSTANCE_ID = 5;
    private static final int MAX_PROTOTYPE_ID = 6;
    static final long serialVersionUID = 5311394446546053859L;
    private int argumentsAttributes = 6;
    private Object argumentsObj = NOT_FOUND;
    private Object prototypeProperty;
    private int prototypePropertyAttributes = 6;

    public BaseFunction() {
    }

    public BaseFunction(Scriptable scriptable, Scriptable scriptable2) {
        super(scriptable, scriptable2);
    }

    private Object getArguments() {
        Object object = this.defaultHas("arguments") ? this.defaultGet("arguments") : this.argumentsObj;
        if (object != NOT_FOUND) {
            return object;
        }
        object = ScriptRuntime.findFunctionActivation(Context.getContext(), this);
        object = object == null ? null : ((IdScriptableObject)object).get("arguments", (Scriptable)object);
        return object;
    }

    static void init(Scriptable scriptable, boolean bl) {
        BaseFunction baseFunction = new BaseFunction();
        baseFunction.prototypePropertyAttributes = 7;
        baseFunction.exportAsJSClass(6, scriptable, bl);
    }

    static boolean isApply(IdFunctionObject idFunctionObject) {
        boolean bl = idFunctionObject.hasTag(FUNCTION_TAG) && idFunctionObject.methodId() == 4;
        return bl;
    }

    static boolean isApplyOrCall(IdFunctionObject idFunctionObject) {
        int n;
        return idFunctionObject.hasTag(FUNCTION_TAG) && ((n = idFunctionObject.methodId()) == 4 || n == 5);
        {
        }
    }

    private static Object jsConstructor(Context context, Scriptable object, Object[] object2) {
        int n;
        int n2 = ((Object[])object2).length;
        CharSequence charSequence = new StringBuilder();
        charSequence.append("function ");
        if (context.getLanguageVersion() != 120) {
            charSequence.append("anonymous");
        }
        charSequence.append('(');
        for (int i = 0; i < (n = n2 - 1); ++i) {
            if (i > 0) {
                charSequence.append(',');
            }
            charSequence.append(ScriptRuntime.toString(object2[i]));
        }
        charSequence.append(") {");
        if (n2 != 0) {
            charSequence.append(ScriptRuntime.toString(object2[n]));
        }
        charSequence.append("\n}");
        String string2 = charSequence.toString();
        int[] nArray = new int[1];
        charSequence = Context.getSourcePositionFromStack(nArray);
        object2 = charSequence;
        if (charSequence == null) {
            nArray[0] = 1;
            object2 = "<eval'ed string>";
        }
        charSequence = ScriptRuntime.makeUrlForGeneratedScript(false, (String)object2, nArray[0]);
        Scriptable scriptable = ScriptableObject.getTopLevelScope((Scriptable)object);
        ErrorReporter errorReporter = DefaultErrorReporter.forEval(context.getErrorReporter());
        object = Context.createInterpreter();
        if (object != null) {
            return context.compileFunction(scriptable, string2, (Evaluator)object, errorReporter, (String)charSequence, 1, null);
        }
        throw new JavaScriptException("Interpreter not present", (String)object2, nArray[0]);
    }

    private BaseFunction realFunction(Scriptable object, IdFunctionObject idFunctionObject) {
        Object object2;
        object = object2 = object.getDefaultValue(ScriptRuntime.FunctionClass);
        if (object2 instanceof Delegator) {
            object = ((Delegator)object2).getDelegee();
        }
        if (object instanceof BaseFunction) {
            return (BaseFunction)object;
        }
        throw ScriptRuntime.typeError1("msg.incompat.call", idFunctionObject.getFunctionName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object setupDefaultPrototype() {
        synchronized (this) {
            Object object = this.prototypeProperty;
            if (object != null) {
                return object;
            }
            object = new NativeObject();
            ((ScriptableObject)object).defineProperty("constructor", (Object)this, 2);
            this.prototypeProperty = object;
            Scriptable scriptable = BaseFunction.getObjectPrototype(this);
            if (scriptable != object) {
                ((ScriptableObject)object).setPrototype(scriptable);
            }
            return object;
        }
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        return Undefined.instance;
    }

    @Override
    public Scriptable construct(Context object, Scriptable object2, Object[] object3) {
        block10: {
            block9: {
                block8: {
                    Scriptable scriptable = this.createObject((Context)object, (Scriptable)object2);
                    if (scriptable == null) break block8;
                    object2 = this.call((Context)object, (Scriptable)object2, scriptable, (Object[])object3);
                    object = scriptable;
                    if (object2 instanceof Scriptable) {
                        object = (Scriptable)object2;
                    }
                    break block9;
                }
                if (!((object = this.call((Context)object, (Scriptable)object2, null, (Object[])object3)) instanceof Scriptable)) break block10;
                object2 = (Scriptable)object;
                if (object2.getPrototype() == null && object2 != (object = this.getClassPrototype())) {
                    object2.setPrototype((Scriptable)object);
                }
                object = object2;
                if (object2.getParentScope() == null) {
                    object3 = this.getParentScope();
                    object = object2;
                    if (object2 != object3) {
                        object2.setParentScope((Scriptable)object3);
                        object = object2;
                    }
                }
            }
            return object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Bad implementaion of call as constructor, name=");
        ((StringBuilder)object).append(this.getFunctionName());
        ((StringBuilder)object).append(" in ");
        ((StringBuilder)object).append(this.getClass().getName());
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    public Scriptable createObject(Context object, Scriptable scriptable) {
        object = new NativeObject();
        object.setPrototype(this.getClassPrototype());
        object.setParentScope(this.getParentScope());
        return object;
    }

    String decompile(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        n = 1;
        if ((n2 & 1) == 0) {
            n = 0;
        }
        if (n == 0) {
            stringBuilder.append("function ");
            stringBuilder.append(this.getFunctionName());
            stringBuilder.append("() {\n\t");
        }
        stringBuilder.append("[native code, arity=");
        stringBuilder.append(this.getArity());
        stringBuilder.append("]\n");
        if (n == 0) {
            stringBuilder.append("}\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public Object execIdCall(IdFunctionObject scriptable, Context context, Scriptable scriptable2, Scriptable objectArray, Object[] objectArray2) {
        if (!scriptable.hasTag(FUNCTION_TAG)) {
            return super.execIdCall((IdFunctionObject)scriptable, context, scriptable2, (Scriptable)objectArray, objectArray2);
        }
        int n = scriptable.methodId();
        boolean bl = true;
        int n2 = 0;
        switch (n) {
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
            case 6: {
                if (objectArray instanceof Callable) {
                    Callable callable = (Callable)objectArray;
                    n = objectArray2.length;
                    if (n > 0) {
                        scriptable = ScriptRuntime.toObjectOrNull(context, objectArray2[0], scriptable2);
                        objectArray = new Object[--n];
                        System.arraycopy(objectArray2, 1, objectArray, 0, n);
                    } else {
                        objectArray = ScriptRuntime.emptyArgs;
                        scriptable = null;
                    }
                    return new BoundFunction(context, scriptable2, callable, scriptable, objectArray);
                }
                throw ScriptRuntime.notFunctionError(objectArray);
            }
            case 4: 
            case 5: {
                if (n != 4) {
                    bl = false;
                }
                return ScriptRuntime.applyOrCall(bl, context, scriptable2, (Scriptable)objectArray, objectArray2);
            }
            case 3: {
                scriptable = this.realFunction((Scriptable)objectArray, (IdFunctionObject)scriptable);
                int n3 = 2;
                int n4 = n2;
                n = n3;
                if (objectArray2.length != 0) {
                    int n5 = ScriptRuntime.toInt32(objectArray2[0]);
                    n4 = n2;
                    n = n3;
                    if (n5 >= 0) {
                        n4 = n5;
                        n = 0;
                    }
                }
                return ((BaseFunction)scriptable).decompile(n4, n);
            }
            case 2: {
                return this.realFunction((Scriptable)objectArray, (IdFunctionObject)scriptable).decompile(ScriptRuntime.toInt32(objectArray2, 0), 0);
            }
            case 1: 
        }
        return BaseFunction.jsConstructor(context, scriptable2, objectArray2);
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        idFunctionObject.setPrototype(this);
        super.fillConstructorProperties(idFunctionObject);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected int findInstanceIdInfo(String var1_1) {
        block16: {
            block15: {
                block14: {
                    block11: {
                        block12: {
                            block13: {
                                var2_2 = var1_1.length();
                                if (var2_2 == 4) break block11;
                                if (var2_2 == 5) break block12;
                                if (var2_2 == 6) break block13;
                                if (var2_2 != 9) ** GOTO lbl-1000
                                var2_2 = var1_1.charAt(0);
                                if (var2_2 == 97) {
                                    var3_3 = "arguments";
                                    var2_2 = 5;
                                } else if (var2_2 == 112) {
                                    var3_3 = "prototype";
                                    var2_2 = 4;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    var3_3 = null;
                                    var2_2 = 0;
                                }
                                break block14;
                            }
                            var3_3 = "length";
                            var2_2 = 1;
                            break block14;
                        }
                        var3_3 = "arity";
                        var2_2 = 2;
                        break block14;
                    }
                    var3_3 = "name";
                    var2_2 = 3;
                }
                var4_4 = var2_2;
                if (var3_3 != null) {
                    var4_4 = var2_2;
                    if (var3_3 != var1_1) {
                        var4_4 = var2_2;
                        if (!var3_3.equals(var1_1)) {
                            var4_4 = 0;
                        }
                    }
                }
                if (var4_4 == 0) {
                    return super.findInstanceIdInfo(var1_1);
                }
                if (var4_4 == 1 || var4_4 == 2 || var4_4 == 3) break block15;
                if (var4_4 == 4) ** GOTO lbl45
                if (var4_4 == 5) {
                    var2_2 = this.argumentsAttributes;
                } else {
                    throw new IllegalStateException();
lbl45:
                    // 1 sources

                    if (!this.hasPrototypeProperty()) {
                        return 0;
                    }
                    var2_2 = this.prototypePropertyAttributes;
                }
                break block16;
            }
            var2_2 = 7;
        }
        return BaseFunction.instanceIdInfo(var2_2, var4_4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int findPrototypeId(String string2) {
        String string3;
        int n = string2.length();
        int n2 = 3;
        int n3 = 0;
        if (n != 4) {
            if (n != 5) {
                if (n != 8) {
                    if (n != 11) return 0;
                    n2 = 1;
                    string3 = "constructor";
                } else {
                    n = string2.charAt(3);
                    if (n == 111) {
                        string3 = "toSource";
                    } else {
                        if (n != 116) return 0;
                        n2 = 2;
                        string3 = "toString";
                    }
                }
            } else {
                string3 = "apply";
                n2 = 4;
            }
        } else {
            n2 = string2.charAt(0);
            if (n2 == 98) {
                n2 = 6;
                string3 = "bind";
            } else {
                if (n2 != 99) return 0;
                string3 = "call";
                n2 = 5;
            }
        }
        if (string3 == null) return n2;
        if (string3 == string2) return n2;
        if (string3.equals(string2)) return n2;
        return n3;
    }

    public int getArity() {
        return 0;
    }

    @Override
    public String getClassName() {
        return "Function";
    }

    protected Scriptable getClassPrototype() {
        Object object = this.getPrototypeProperty();
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        return ScriptableObject.getObjectPrototype(this);
    }

    public String getFunctionName() {
        return "";
    }

    @Override
    protected String getInstanceIdName(int n) {
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    if (n != 4) {
                        if (n != 5) {
                            return super.getInstanceIdName(n);
                        }
                        return "arguments";
                    }
                    return "prototype";
                }
                return "name";
            }
            return "arity";
        }
        return "length";
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    if (n != 4) {
                        if (n != 5) {
                            return super.getInstanceIdValue(n);
                        }
                        return this.getArguments();
                    }
                    return this.getPrototypeProperty();
                }
                return this.getFunctionName();
            }
            return ScriptRuntime.wrapInt(this.getArity());
        }
        return ScriptRuntime.wrapInt(this.getLength());
    }

    public int getLength() {
        return 0;
    }

    @Override
    protected int getMaxInstanceId() {
        return 5;
    }

    protected Object getPrototypeProperty() {
        Object object;
        Object object2 = this.prototypeProperty;
        if (object2 == null) {
            object = this instanceof NativeFunction ? this.setupDefaultPrototype() : Undefined.instance;
        } else {
            object = object2;
            if (object2 == UniqueTag.NULL_VALUE) {
                object = null;
            }
        }
        return object;
    }

    @Override
    public String getTypeOf() {
        String string2 = this.avoidObjectDetection() ? "undefined" : "function";
        return string2;
    }

    @Override
    public boolean hasInstance(Scriptable scriptable) {
        Object object = ScriptableObject.getProperty((Scriptable)this, "prototype");
        if (object instanceof Scriptable) {
            return ScriptRuntime.jsDelegatesTo(scriptable, (Scriptable)object);
        }
        throw ScriptRuntime.typeError1("msg.instanceof.bad.prototype", this.getFunctionName());
    }

    protected boolean hasPrototypeProperty() {
        boolean bl = this.prototypeProperty != null || this instanceof NativeFunction;
        return bl;
    }

    @Override
    protected void initPrototypeId(int n) {
        String string2;
        int n2 = 1;
        switch (n) {
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
            case 6: {
                string2 = "bind";
                break;
            }
            case 5: {
                string2 = "call";
                break;
            }
            case 4: {
                n2 = 2;
                string2 = "apply";
                break;
            }
            case 3: {
                string2 = "toSource";
                break;
            }
            case 2: {
                n2 = 0;
                string2 = "toString";
                break;
            }
            case 1: {
                string2 = "constructor";
            }
        }
        this.initPrototypeMethod(FUNCTION_TAG, n, string2, n2);
    }

    public void setImmunePrototypeProperty(Object object) {
        if ((this.prototypePropertyAttributes & 1) == 0) {
            if (object == null) {
                object = UniqueTag.NULL_VALUE;
            }
            this.prototypeProperty = object;
            this.prototypePropertyAttributes = 7;
            return;
        }
        throw new IllegalStateException();
    }

    @Override
    protected void setInstanceIdAttributes(int n, int n2) {
        if (n != 4) {
            if (n != 5) {
                super.setInstanceIdAttributes(n, n2);
                return;
            }
            this.argumentsAttributes = n2;
            return;
        }
        this.prototypePropertyAttributes = n2;
    }

    @Override
    protected void setInstanceIdValue(int n, Object object) {
        if (n != 1 && n != 2 && n != 3) {
            if (n != 4) {
                if (n != 5) {
                    super.setInstanceIdValue(n, object);
                    return;
                }
                if (object == NOT_FOUND) {
                    Kit.codeBug();
                }
                if (this.defaultHas("arguments")) {
                    this.defaultPut("arguments", object);
                } else if ((this.argumentsAttributes & 1) == 0) {
                    this.argumentsObj = object;
                }
                return;
            }
            if ((this.prototypePropertyAttributes & 1) == 0) {
                if (object == null) {
                    object = UniqueTag.NULL_VALUE;
                }
                this.prototypeProperty = object;
            }
        }
    }
}

