/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class BoundFunction
extends BaseFunction {
    static final long serialVersionUID = 2118137342826470729L;
    private final Object[] boundArgs;
    private final Scriptable boundThis;
    private final int length;
    private final Callable targetFunction;

    public BoundFunction(Context context, Scriptable scriptable, Callable callable, Scriptable object, Object[] objectArray) {
        this.targetFunction = callable;
        this.boundThis = object;
        this.boundArgs = objectArray;
        boolean bl = callable instanceof BaseFunction;
        object = false;
        this.length = bl ? Math.max(0, ((BaseFunction)callable).getLength() - objectArray.length) : 0;
        ScriptRuntime.setFunctionProtoAndParent(this, scriptable);
        callable = ScriptRuntime.typeErrorThrower(context);
        scriptable = new NativeObject();
        ((IdScriptableObject)scriptable).put("get", scriptable, (Object)callable);
        ((IdScriptableObject)scriptable).put("set", scriptable, (Object)callable);
        ((IdScriptableObject)scriptable).put("enumerable", scriptable, object);
        ((IdScriptableObject)scriptable).put("configurable", scriptable, object);
        ((ScriptableObject)scriptable).preventExtensions();
        this.defineOwnProperty(context, "caller", (ScriptableObject)scriptable, false);
        this.defineOwnProperty(context, "arguments", (ScriptableObject)scriptable, false);
    }

    private Object[] concat(Object[] objectArray, Object[] objectArray2) {
        Object[] objectArray3 = new Object[objectArray.length + objectArray2.length];
        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
        System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, objectArray2.length);
        return objectArray3;
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        scriptable2 = this.boundThis;
        if (scriptable2 == null) {
            scriptable2 = ScriptRuntime.getTopCallScope(context);
        }
        return this.targetFunction.call(context, scriptable, scriptable2, this.concat(this.boundArgs, objectArray));
    }

    @Override
    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        Callable callable = this.targetFunction;
        if (callable instanceof Function) {
            return ((Function)callable).construct(context, scriptable, this.concat(this.boundArgs, objectArray));
        }
        throw ScriptRuntime.typeError0("msg.not.ctor");
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public boolean hasInstance(Scriptable scriptable) {
        Callable callable = this.targetFunction;
        if (callable instanceof Function) {
            return ((Function)callable).hasInstance(scriptable);
        }
        throw ScriptRuntime.typeError0("msg.not.ctor");
    }
}

