/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Icode;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NodeTransformer;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.UintMap;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.ScriptNode;

class CodeGenerator
extends Icode {
    private static final int ECF_TAIL = 1;
    private static final int MIN_FIXUP_TABLE_SIZE = 40;
    private static final int MIN_LABEL_TABLE_SIZE = 32;
    private CompilerEnvirons compilerEnv;
    private int doubleTableTop;
    private int exceptionTableTop;
    private long[] fixupTable;
    private int fixupTableTop;
    private int iCodeTop;
    private InterpreterData itsData;
    private boolean itsInFunctionFlag;
    private boolean itsInTryFlag;
    private int[] labelTable;
    private int labelTableTop;
    private int lineNumber;
    private ObjArray literalIds;
    private int localTop;
    private ScriptNode scriptOrFn;
    private int stackDepth;
    private ObjToIntMap strings = new ObjToIntMap(20);

    CodeGenerator() {
        this.literalIds = new ObjArray();
    }

    private void addBackwardGoto(int n, int n2) {
        int n3 = this.iCodeTop;
        if (n3 > n2) {
            this.addGotoOp(n);
            this.resolveGoto(n3, n2);
            return;
        }
        throw Kit.codeBug();
    }

    private void addExceptionHandler(int n, int n2, int n3, boolean bl, int n4, int n5) {
        int[] nArray;
        int n6 = this.exceptionTableTop;
        int[] nArray2 = this.itsData.itsExceptionTable;
        if (nArray2 == null) {
            if (n6 != 0) {
                Kit.codeBug();
            }
            this.itsData.itsExceptionTable = nArray = new int[12];
        } else {
            nArray = nArray2;
            if (nArray2.length == n6) {
                nArray = new int[nArray2.length * 2];
                System.arraycopy(this.itsData.itsExceptionTable, 0, nArray, 0, n6);
                this.itsData.itsExceptionTable = nArray;
            }
        }
        nArray[n6 + 0] = n;
        nArray[n6 + 1] = n2;
        nArray[n6 + 2] = n3;
        nArray[n6 + 3] = bl ? 1 : 0;
        nArray[n6 + 4] = n4;
        nArray[n6 + 5] = n5;
        this.exceptionTableTop = n6 + 6;
    }

    private void addGoto(Node object, int n) {
        int n2;
        int n3 = this.getTargetLabel((Node)object);
        if (n3 >= this.labelTableTop) {
            Kit.codeBug();
        }
        if ((n2 = this.labelTable[n3]) != -1) {
            this.addBackwardGoto(n, n2);
        } else {
            n2 = this.iCodeTop;
            this.addGotoOp(n);
            n = this.fixupTableTop;
            object = this.fixupTable;
            if (object == null || n == ((Object)object).length) {
                if (object == null) {
                    this.fixupTable = new long[40];
                } else {
                    long[] lArray = new long[((Object)object).length * 2];
                    System.arraycopy(object, 0, lArray, 0, n);
                    this.fixupTable = lArray;
                }
            }
            this.fixupTableTop = n + 1;
            this.fixupTable[n] = (long)n3 << 32 | (long)n2;
        }
    }

    private void addGotoOp(int n) {
        byte[] byArray = this.itsData.itsICode;
        int n2 = this.iCodeTop;
        byte[] byArray2 = byArray;
        if (n2 + 3 > byArray.length) {
            byArray2 = this.increaseICodeCapacity(3);
        }
        byArray2[n2] = (byte)n;
        this.iCodeTop = n2 + 1 + 2;
    }

    private void addIcode(int n) {
        if (Icode.validIcode(n)) {
            this.addUint8(n & 0xFF);
            return;
        }
        throw Kit.codeBug();
    }

    private void addIndexOp(int n, int n2) {
        this.addIndexPrefix(n2);
        if (Icode.validIcode(n)) {
            this.addIcode(n);
        } else {
            this.addToken(n);
        }
    }

    private void addIndexPrefix(int n) {
        if (n < 0) {
            Kit.codeBug();
        }
        if (n < 6) {
            this.addIcode(-32 - n);
        } else if (n <= 255) {
            this.addIcode(-38);
            this.addUint8(n);
        } else if (n <= 65535) {
            this.addIcode(-39);
            this.addUint16(n);
        } else {
            this.addIcode(-40);
            this.addInt(n);
        }
    }

    private void addInt(int n) {
        byte[] byArray = this.itsData.itsICode;
        int n2 = this.iCodeTop;
        int n3 = n2 + 4;
        byte[] byArray2 = byArray;
        if (n3 > byArray.length) {
            byArray2 = this.increaseICodeCapacity(4);
        }
        byArray2[n2] = (byte)(n >>> 24);
        byArray2[n2 + 1] = (byte)(n >>> 16);
        byArray2[n2 + 2] = (byte)(n >>> 8);
        byArray2[n2 + 3] = (byte)n;
        this.iCodeTop = n3;
    }

    private void addStringOp(int n, String string2) {
        this.addStringPrefix(string2);
        if (Icode.validIcode(n)) {
            this.addIcode(n);
        } else {
            this.addToken(n);
        }
    }

    private void addStringPrefix(String string2) {
        int n;
        int n2 = n = this.strings.get(string2, -1);
        if (n == -1) {
            n2 = this.strings.size();
            this.strings.put(string2, n2);
        }
        if (n2 < 4) {
            this.addIcode(-41 - n2);
        } else if (n2 <= 255) {
            this.addIcode(-45);
            this.addUint8(n2);
        } else if (n2 <= 65535) {
            this.addIcode(-46);
            this.addUint16(n2);
        } else {
            this.addIcode(-47);
            this.addInt(n2);
        }
    }

    private void addToken(int n) {
        if (Icode.validTokenCode(n)) {
            this.addUint8(n);
            return;
        }
        throw Kit.codeBug();
    }

    private void addUint16(int n) {
        if ((0xFFFF0000 & n) == 0) {
            byte[] byArray = this.itsData.itsICode;
            int n2 = this.iCodeTop;
            int n3 = n2 + 2;
            byte[] byArray2 = byArray;
            if (n3 > byArray.length) {
                byArray2 = this.increaseICodeCapacity(2);
            }
            byArray2[n2] = (byte)(n >>> 8);
            byArray2[n2 + 1] = (byte)n;
            this.iCodeTop = n3;
            return;
        }
        throw Kit.codeBug();
    }

    private void addUint8(int n) {
        if ((n & 0xFFFFFF00) == 0) {
            byte[] byArray = this.itsData.itsICode;
            int n2 = this.iCodeTop;
            byte[] byArray2 = byArray;
            if (n2 == byArray.length) {
                byArray2 = this.increaseICodeCapacity(1);
            }
            byArray2[n2] = (byte)n;
            this.iCodeTop = n2 + 1;
            return;
        }
        throw Kit.codeBug();
    }

    private void addVarOp(int n, int n2) {
        if (n != -7) {
            if (n != 157) {
                if (n != 55 && n != 56) {
                    throw Kit.codeBug();
                }
                if (n2 < 128) {
                    n = n == 55 ? -48 : -49;
                    this.addIcode(n);
                    this.addUint8(n2);
                    return;
                }
            } else {
                if (n2 < 128) {
                    this.addIcode(-61);
                    this.addUint8(n2);
                    return;
                }
                this.addIndexOp(-60, n2);
                return;
            }
        }
        this.addIndexOp(n, n2);
    }

    private int allocLocal() {
        int n;
        int n2 = this.localTop;
        this.localTop = n = n2 + 1;
        if (n > this.itsData.itsMaxLocals) {
            this.itsData.itsMaxLocals = this.localTop;
        }
        return n2;
    }

    private RuntimeException badTree(Node node) {
        throw new RuntimeException(node.toString());
    }

    private void fixLabelGotos() {
        for (int i = 0; i < this.fixupTableTop; ++i) {
            long l = this.fixupTable[i];
            int n = (int)(l >> 32);
            int n2 = (int)l;
            if ((n = this.labelTable[n]) != -1) {
                this.resolveGoto(n2, n);
                continue;
            }
            throw Kit.codeBug();
        }
        this.fixupTableTop = 0;
    }

    private void generateCallFunAndThis(Node node) {
        int n = node.getType();
        if (n != 33 && n != 36) {
            if (n != 39) {
                this.visitExpression(node, 0);
                this.addIcode(-18);
                this.stackChange(1);
            } else {
                this.addStringOp(-15, node.getString());
                this.stackChange(2);
            }
        } else {
            node = node.getFirstChild();
            this.visitExpression(node, 0);
            node = node.getNext();
            if (n == 33) {
                this.addStringOp(-16, node.getString());
                this.stackChange(1);
            } else {
                this.visitExpression(node, 0);
                this.addIcode(-17);
            }
        }
    }

    private void generateFunctionICode() {
        this.itsInFunctionFlag = true;
        FunctionNode functionNode = (FunctionNode)this.scriptOrFn;
        this.itsData.itsFunctionType = functionNode.getFunctionType();
        this.itsData.itsNeedsActivation = functionNode.requiresActivation();
        if (functionNode.getFunctionName() != null) {
            this.itsData.itsName = functionNode.getName();
        }
        if (functionNode.isGenerator()) {
            this.addIcode(-62);
            this.addUint16(functionNode.getBaseLineno() & 0xFFFF);
        }
        if (functionNode.isInStrictMode()) {
            this.itsData.isStrict = true;
        }
        this.generateICodeFromTree(functionNode.getLastChild());
    }

    private void generateICodeFromTree(Node object) {
        int n;
        int n2;
        this.generateNestedFunctions();
        this.generateRegExpLiterals();
        this.visitStatement((Node)object, 0);
        this.fixLabelGotos();
        if (this.itsData.itsFunctionType == 0) {
            this.addToken(65);
        }
        if ((n2 = this.itsData.itsICode.length) != (n = this.iCodeTop)) {
            object = new byte[n];
            System.arraycopy(this.itsData.itsICode, 0, object, 0, this.iCodeTop);
            this.itsData.itsICode = (byte[])object;
        }
        if (this.strings.size() == 0) {
            this.itsData.itsStringTable = null;
        } else {
            this.itsData.itsStringTable = new String[this.strings.size()];
            ObjToIntMap.Iterator iterator2 = this.strings.newIterator();
            iterator2.start();
            while (!iterator2.done()) {
                object = (String)iterator2.getKey();
                n2 = iterator2.getValue();
                if (this.itsData.itsStringTable[n2] != null) {
                    Kit.codeBug();
                }
                this.itsData.itsStringTable[n2] = object;
                iterator2.next();
            }
        }
        if (this.doubleTableTop == 0) {
            this.itsData.itsDoubleTable = null;
        } else {
            n2 = this.itsData.itsDoubleTable.length;
            n = this.doubleTableTop;
            if (n2 != n) {
                object = new double[n];
                System.arraycopy(this.itsData.itsDoubleTable, 0, object, 0, this.doubleTableTop);
                this.itsData.itsDoubleTable = (double[])object;
            }
        }
        if (this.exceptionTableTop != 0 && (n2 = this.itsData.itsExceptionTable.length) != (n = this.exceptionTableTop)) {
            object = new int[n];
            System.arraycopy(this.itsData.itsExceptionTable, 0, object, 0, this.exceptionTableTop);
            this.itsData.itsExceptionTable = (int[])object;
        }
        this.itsData.itsMaxVars = this.scriptOrFn.getParamAndVarCount();
        object = this.itsData;
        ((InterpreterData)object).itsMaxFrameArray = ((InterpreterData)object).itsMaxVars + this.itsData.itsMaxLocals + this.itsData.itsMaxStack;
        this.itsData.argNames = this.scriptOrFn.getParamAndVarNames();
        this.itsData.argIsConst = this.scriptOrFn.getParamAndVarConst();
        this.itsData.argCount = this.scriptOrFn.getParamCount();
        this.itsData.encodedSourceStart = this.scriptOrFn.getEncodedSourceStart();
        this.itsData.encodedSourceEnd = this.scriptOrFn.getEncodedSourceEnd();
        if (this.literalIds.size() != 0) {
            this.itsData.literalIds = this.literalIds.toArray();
        }
    }

    private void generateNestedFunctions() {
        int n = this.scriptOrFn.getFunctionCount();
        if (n == 0) {
            return;
        }
        InterpreterData[] interpreterDataArray = new InterpreterData[n];
        for (int i = 0; i != n; ++i) {
            FunctionNode functionNode = this.scriptOrFn.getFunctionNode(i);
            CodeGenerator codeGenerator = new CodeGenerator();
            codeGenerator.compilerEnv = this.compilerEnv;
            codeGenerator.scriptOrFn = functionNode;
            codeGenerator.itsData = new InterpreterData(this.itsData);
            codeGenerator.generateFunctionICode();
            interpreterDataArray[i] = codeGenerator.itsData;
        }
        this.itsData.itsNestedFunctions = interpreterDataArray;
    }

    private void generateRegExpLiterals() {
        int n = this.scriptOrFn.getRegexpCount();
        if (n == 0) {
            return;
        }
        Context context = Context.getContext();
        RegExpProxy regExpProxy = ScriptRuntime.checkRegExpProxy(context);
        Object[] objectArray = new Object[n];
        for (int i = 0; i != n; ++i) {
            objectArray[i] = regExpProxy.compileRegExp(context, this.scriptOrFn.getRegexpString(i), this.scriptOrFn.getRegexpFlags(i));
        }
        this.itsData.itsRegExpLiterals = objectArray;
    }

    private int getDoubleIndex(double d) {
        int n = this.doubleTableTop;
        if (n == 0) {
            this.itsData.itsDoubleTable = new double[64];
        } else if (this.itsData.itsDoubleTable.length == n) {
            double[] dArray = new double[n * 2];
            System.arraycopy(this.itsData.itsDoubleTable, 0, dArray, 0, n);
            this.itsData.itsDoubleTable = dArray;
        }
        this.itsData.itsDoubleTable[n] = d;
        this.doubleTableTop = n + 1;
        return n;
    }

    private int getLocalBlockRef(Node node) {
        return ((Node)node.getProp(3)).getExistingIntProp(2);
    }

    private int getTargetLabel(Node node) {
        int n = node.labelId();
        if (n != -1) {
            return n;
        }
        n = this.labelTableTop;
        int[] nArray = this.labelTable;
        if (nArray == null || n == nArray.length) {
            if (nArray == null) {
                this.labelTable = new int[32];
            } else {
                int[] nArray2 = new int[nArray.length * 2];
                System.arraycopy(nArray, 0, nArray2, 0, n);
                this.labelTable = nArray2;
            }
        }
        this.labelTableTop = n + 1;
        this.labelTable[n] = -1;
        node.labelId(n);
        return n;
    }

    private byte[] increaseICodeCapacity(int n) {
        int n2 = this.iCodeTop;
        int n3 = this.itsData.itsICode.length;
        if ((n += n2) > n3) {
            if (n <= (n3 *= 2)) {
                n = n3;
            }
            byte[] byArray = new byte[n];
            System.arraycopy(this.itsData.itsICode, 0, byArray, 0, n2);
            this.itsData.itsICode = byArray;
            return byArray;
        }
        throw Kit.codeBug();
    }

    private void markTargetLabel(Node node) {
        int n = this.getTargetLabel(node);
        if (this.labelTable[n] != -1) {
            Kit.codeBug();
        }
        this.labelTable[n] = this.iCodeTop;
    }

    private void releaseLocal(int n) {
        int n2;
        this.localTop = n2 = this.localTop - 1;
        if (n != n2) {
            Kit.codeBug();
        }
    }

    private void resolveForwardGoto(int n) {
        int n2 = this.iCodeTop;
        if (n2 >= n + 3) {
            this.resolveGoto(n, n2);
            return;
        }
        throw Kit.codeBug();
    }

    private void resolveGoto(int n, int n2) {
        int n3 = n2 - n;
        if (n3 >= 0 && n3 <= 2) {
            throw Kit.codeBug();
        }
        int n4 = n + 1;
        n = n3;
        if (n3 != (short)n3) {
            if (this.itsData.longJumps == null) {
                this.itsData.longJumps = new UintMap();
            }
            this.itsData.longJumps.put(n4, n2);
            n = 0;
        }
        byte[] byArray = this.itsData.itsICode;
        byArray[n4] = (byte)(n >> 8);
        byArray[n4 + 1] = (byte)n;
    }

    private void stackChange(int n) {
        if (n <= 0) {
            this.stackDepth += n;
        } else {
            if ((n = this.stackDepth + n) > this.itsData.itsMaxStack) {
                this.itsData.itsMaxStack = n;
            }
            this.stackDepth = n;
        }
    }

    private void updateLineNumber(Node node) {
        int n = node.getLineno();
        if (n != this.lineNumber && n >= 0) {
            if (this.itsData.firstLinePC < 0) {
                this.itsData.firstLinePC = n;
            }
            this.lineNumber = n;
            this.addIcode(-26);
            this.addUint16(n & 0xFFFF);
        }
    }

    private void visitArrayComprehension(Node node, Node node2, Node node3) {
        this.visitStatement(node2, this.stackDepth);
        this.visitExpression(node3, 0);
    }

    /*
     * Exception decompiling
     */
    private void visitExpression(Node var1_1, int var2_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void visitIncDec(Node node, Node node2) {
        int n = node.getExistingIntProp(13);
        int n2 = node2.getType();
        if (n2 != 33) {
            if (n2 != 36) {
                if (n2 != 39) {
                    if (n2 != 55) {
                        if (n2 != 68) throw this.badTree(node);
                        this.visitExpression(node2.getFirstChild(), 0);
                        this.addIcode(-11);
                        this.addUint8(n);
                        return;
                    } else {
                        if (this.itsData.itsNeedsActivation) {
                            Kit.codeBug();
                        }
                        this.addVarOp(-7, this.scriptOrFn.getIndexForNameNode(node2));
                        this.addUint8(n);
                        this.stackChange(1);
                    }
                    return;
                } else {
                    this.addStringOp(-8, node2.getString());
                    this.addUint8(n);
                    this.stackChange(1);
                }
                return;
            } else {
                node = node2.getFirstChild();
                this.visitExpression(node, 0);
                this.visitExpression(node.getNext(), 0);
                this.addIcode(-10);
                this.addUint8(n);
                this.stackChange(-1);
            }
            return;
        } else {
            node = node2.getFirstChild();
            this.visitExpression(node, 0);
            this.addStringOp(-9, node.getNext().getString());
            this.addUint8(n);
        }
    }

    private void visitLiteral(Node object, Node object2) {
        block17: {
            Object object3;
            int n;
            int n2;
            block16: {
                block15: {
                    n2 = ((Node)object).getType();
                    if (n2 != 66) break block15;
                    n = 0;
                    for (object3 = object2; object3 != null; object3 = object3.getNext()) {
                        ++n;
                    }
                    object3 = null;
                    break block16;
                }
                if (n2 != 67) break block17;
                object3 = (Object[])((Node)object).getProp(12);
                n = ((Object[])object3).length;
            }
            this.addIndexOp(-29, n);
            this.stackChange(2);
            while (object2 != null) {
                n = object2.getType();
                if (n == 152) {
                    this.visitExpression(object2.getFirstChild(), 0);
                    this.addIcode(-57);
                } else if (n == 153) {
                    this.visitExpression(object2.getFirstChild(), 0);
                    this.addIcode(-58);
                } else if (n == 164) {
                    this.visitExpression(object2.getFirstChild(), 0);
                    this.addIcode(-30);
                } else {
                    this.visitExpression((Node)object2, 0);
                    this.addIcode(-30);
                }
                this.stackChange(-1);
                object2 = object2.getNext();
            }
            if (n2 == 66) {
                if ((object = (Object)((int[])((Node)object).getProp(11))) == null) {
                    this.addToken(66);
                } else {
                    n = this.literalIds.size();
                    this.literalIds.add(object);
                    this.addIndexOp(-31, n);
                }
            } else {
                n = this.literalIds.size();
                this.literalIds.add(object3);
                this.addIndexOp(67, n);
            }
            this.stackChange(-1);
            return;
        }
        throw this.badTree((Node)object);
    }

    /*
     * Exception decompiling
     */
    private void visitStatement(Node var1_1, int var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CASE]], but top level block is 11[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public InterpreterData compile(CompilerEnvirons object, ScriptNode scriptNode, String string2, boolean bl) {
        this.compilerEnv = object;
        new NodeTransformer().transform(scriptNode, (CompilerEnvirons)object);
        this.scriptOrFn = bl ? scriptNode.getFunctionNode(0) : scriptNode;
        this.itsData = object = new InterpreterData(((CompilerEnvirons)object).getLanguageVersion(), this.scriptOrFn.getSourceName(), string2, this.scriptOrFn.isInStrictMode());
        ((InterpreterData)object).topLevel = true;
        if (bl) {
            this.generateFunctionICode();
        } else {
            this.generateICodeFromTree(this.scriptOrFn);
        }
        return this.itsData;
    }
}

