/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ContextListener;
import org.mozilla.javascript.ContinuationPending;
import org.mozilla.javascript.DefaultErrorReporter;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Evaluator;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeContinuation;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.VMBridge;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.ScriptNode;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;
import org.mozilla.javascript.xml.XMLLib;

public class Context {
    public static final int FEATURE_DYNAMIC_SCOPE = 7;
    public static final int FEATURE_E4X = 6;
    public static final int FEATURE_ENHANCED_JAVA_ACCESS = 13;
    public static final int FEATURE_ENUMERATE_IDS_FIRST = 16;
    public static final int FEATURE_INTEGER_WITHOUT_DECIMAL_PLACE = 18;
    public static final int FEATURE_LOCATION_INFORMATION_IN_ERROR = 10;
    public static final int FEATURE_MEMBER_EXPR_AS_FUNCTION_NAME = 2;
    public static final int FEATURE_NON_ECMA_GET_YEAR = 1;
    public static final int FEATURE_OLD_UNDEF_NULL_THIS = 15;
    public static final int FEATURE_PARENT_PROTO_PROPERTIES = 5;
    @Deprecated
    public static final int FEATURE_PARENT_PROTO_PROPRTIES = 5;
    public static final int FEATURE_RESERVED_KEYWORD_AS_IDENTIFIER = 3;
    public static final int FEATURE_STRICT_EVAL = 9;
    public static final int FEATURE_STRICT_MODE = 11;
    public static final int FEATURE_STRICT_VARS = 8;
    public static final int FEATURE_THREAD_SAFE_OBJECTS = 17;
    public static final int FEATURE_TO_STRING_AS_SOURCE = 4;
    public static final int FEATURE_V8_EXTENSIONS = 14;
    public static final int FEATURE_WARNING_AS_ERROR = 12;
    public static final int VERSION_1_0 = 100;
    public static final int VERSION_1_1 = 110;
    public static final int VERSION_1_2 = 120;
    public static final int VERSION_1_3 = 130;
    public static final int VERSION_1_4 = 140;
    public static final int VERSION_1_5 = 150;
    public static final int VERSION_1_6 = 160;
    public static final int VERSION_1_7 = 170;
    public static final int VERSION_1_8 = 180;
    public static final int VERSION_DEFAULT = 0;
    public static final int VERSION_ES6 = 200;
    public static final int VERSION_UNKNOWN = -1;
    private static Class<?> codegenClass;
    public static final Object[] emptyArgs;
    public static final String errorReporterProperty = "error reporter";
    private static String implementationVersion;
    private static Class<?> interpreterClass;
    public static final String languageVersionProperty = "language version";
    Set<String> activationNames;
    private ClassLoader applicationClassLoader;
    XMLLib cachedXMLLib;
    private ClassShutter classShutter;
    NativeCall currentActivationCall;
    Debugger debugger;
    private Object debuggerData;
    private int enterCount;
    private ErrorReporter errorReporter;
    private final ContextFactory factory;
    public boolean generateObserverCount;
    private boolean generatingDebug;
    private boolean generatingDebugChanged;
    private boolean generatingSource = true;
    private boolean hasClassShutter;
    int instructionCount;
    int instructionThreshold;
    Object interpreterSecurityDomain;
    boolean isContinuationsTopCall;
    boolean isTopLevelStrict;
    ObjToIntMap iterating;
    Object lastInterpreterFrame;
    private Locale locale;
    private int maximumInterpreterStackDepth;
    private int optimizationLevel;
    ObjArray previousInterpreterInvocations;
    private Object propertyListeners;
    RegExpProxy regExpProxy;
    int scratchIndex;
    Scriptable scratchScriptable;
    long scratchUint32;
    private Object sealKey;
    private boolean sealed;
    private SecurityController securityController;
    private Map<Object, Object> threadLocalMap;
    Scriptable topCallScope;
    BaseFunction typeErrorThrower;
    boolean useDynamicScope;
    int version;
    private WrapFactory wrapFactory;

    static {
        emptyArgs = ScriptRuntime.emptyArgs;
        codegenClass = Kit.classOrNull("org.mozilla.javascript.optimizer.Codegen");
        interpreterClass = Kit.classOrNull("org.mozilla.javascript.Interpreter");
    }

    @Deprecated
    public Context() {
        this(ContextFactory.getGlobal());
    }

    protected Context(ContextFactory contextFactory) {
        int n = 0;
        this.generateObserverCount = false;
        if (contextFactory != null) {
            this.factory = contextFactory;
            this.version = 0;
            if (codegenClass == null) {
                n = -1;
            }
            this.optimizationLevel = n;
            this.maximumInterpreterStackDepth = Integer.MAX_VALUE;
            return;
        }
        throw new IllegalArgumentException("factory == null");
    }

    static /* synthetic */ ClassShutter access$002(Context context, ClassShutter classShutter) {
        context.classShutter = classShutter;
        return classShutter;
    }

    @Deprecated
    public static void addContextListener(ContextListener contextListener) {
        if ("org.mozilla.javascript.tools.debugger.Main".equals(contextListener.getClass().getName())) {
            Class<?> clazz = contextListener.getClass();
            Class<?> clazz2 = Kit.classOrNull("org.mozilla.javascript.ContextFactory");
            Object object = ContextFactory.getGlobal();
            try {
                clazz.getMethod("attachTo", clazz2).invoke((Object)contextListener, object);
                return;
            }
            catch (Exception exception) {
                object = new RuntimeException();
                Kit.initCause((RuntimeException)object, exception);
                throw object;
            }
        }
        ContextFactory.getGlobal().addListener(contextListener);
    }

    @Deprecated
    public static Object call(ContextAction contextAction) {
        return Context.call(ContextFactory.getGlobal(), contextAction);
    }

    public static Object call(ContextFactory contextFactory, final Callable callable, final Scriptable scriptable, final Scriptable scriptable2, final Object[] objectArray) {
        ContextFactory contextFactory2 = contextFactory;
        if (contextFactory == null) {
            contextFactory2 = ContextFactory.getGlobal();
        }
        return Context.call(contextFactory2, new ContextAction(){

            @Override
            public Object run(Context context) {
                return callable.call(context, scriptable, scriptable2, objectArray);
            }
        });
    }

    static Object call(ContextFactory object, ContextAction contextAction) {
        object = Context.enter(null, (ContextFactory)object);
        try {
            object = contextAction.run((Context)object);
            return object;
        }
        finally {
            Context.exit();
        }
    }

    public static void checkLanguageVersion(int n) {
        if (Context.isValidLanguageVersion(n)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Bad language version: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public static void checkOptimizationLevel(int n) {
        if (Context.isValidOptimizationLevel(n)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Optimization level outside [-1..9]: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    private Object compileImpl(Scriptable object, Reader object2, String object3, String string2, int n, Object object4, boolean bl, Evaluator evaluator, ErrorReporter object5) throws IOException {
        String string3 = string2;
        if (string2 == null) {
            string3 = "unnamed script";
        }
        if (object4 != null && this.getSecurityController() == null) {
            throw new IllegalArgumentException("securityDomain should be null if setSecurityController() was never called");
        }
        boolean bl2 = false;
        boolean bl3 = object2 == null;
        boolean bl4 = object3 == null;
        if (!(bl3 ^ bl4)) {
            Kit.codeBug();
        }
        bl3 = bl2;
        if (object == null) {
            bl3 = true;
        }
        if (!(bl3 ^ bl)) {
            Kit.codeBug();
        }
        CompilerEnvirons compilerEnvirons = new CompilerEnvirons();
        compilerEnvirons.initFromContext(this);
        ErrorReporter errorReporter = object5;
        if (object5 == null) {
            errorReporter = compilerEnvirons.getErrorReporter();
        }
        object5 = object2;
        string2 = object3;
        if (this.debugger != null) {
            object5 = object2;
            string2 = object3;
            if (object2 != null) {
                string2 = Kit.readReader((Reader)object2);
                object5 = null;
            }
        }
        object2 = new Parser(compilerEnvirons, errorReporter);
        if (bl) {
            ((Parser)object2).calledByCompileFunction = true;
        }
        if (this.isStrictMode()) {
            ((Parser)object2).setDefaultUseStrictDirective(true);
        }
        object2 = string2 != null ? ((Parser)object2).parse(string2, string3, n) : ((Parser)object2).parse((Reader)object5, string3, n);
        if (bl && (((Node)object2).getFirstChild() == null || ((Node)object2).getFirstChild().getType() != 110)) {
            object = new StringBuilder();
            ((StringBuilder)object).append("compileFunction only accepts source with single JS function: ");
            ((StringBuilder)object).append(string2);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        object3 = new IRFactory(compilerEnvirons, errorReporter).transformTree((AstRoot)object2);
        object2 = evaluator;
        if (evaluator == null) {
            object2 = this.createCompiler();
        }
        object3 = object2.compile(compilerEnvirons, (ScriptNode)object3, ((ScriptNode)object3).getEncodedSource(), bl);
        if (this.debugger != null) {
            if (string2 == null) {
                Kit.codeBug();
            }
            if (object3 instanceof DebuggableScript) {
                Context.notifyDebugger_r(this, (DebuggableScript)object3, string2);
            } else {
                throw new RuntimeException("NOT SUPPORTED");
            }
        }
        object = bl ? object2.createFunctionObject(this, (Scriptable)object, object3, object4) : object2.createScriptObject(object3, object4);
        return object;
    }

    private Evaluator createCompiler() {
        Object object;
        object = this.optimizationLevel >= 0 && (object = codegenClass) != null ? (Evaluator)Kit.newInstanceOrNull(object) : null;
        Object object2 = object;
        if (object == null) {
            object2 = Context.createInterpreter();
        }
        return object2;
    }

    static Evaluator createInterpreter() {
        return (Evaluator)Kit.newInstanceOrNull(interpreterClass);
    }

    public static Context enter() {
        return Context.enter(null);
    }

    @Deprecated
    public static Context enter(Context context) {
        return Context.enter(context, ContextFactory.getGlobal());
    }

    static final Context enter(Context context, ContextFactory contextFactory) {
        block11: {
            block7: {
                Object object;
                block10: {
                    block8: {
                        block9: {
                            Context context2;
                            block6: {
                                object = VMBridge.instance.getThreadContextHelper();
                                context2 = VMBridge.instance.getContext(object);
                                if (context2 == null) break block6;
                                context = context2;
                                break block7;
                            }
                            if (context != null) break block8;
                            context2 = contextFactory.makeContext();
                            if (context2.enterCount != 0) break block9;
                            contextFactory.onContextCreated(context2);
                            context = context2;
                            if (contextFactory.isSealed()) {
                                context = context2;
                                if (!context2.isSealed()) {
                                    context2.seal(null);
                                    context = context2;
                                }
                            }
                            break block10;
                        }
                        throw new IllegalStateException("factory.makeContext() returned Context instance already associated with some thread");
                    }
                    if (context.enterCount != 0) break block11;
                }
                VMBridge.instance.setContext(object, context);
            }
            ++context.enterCount;
            return context;
        }
        throw new IllegalStateException("can not use Context instance already associated with some thread");
    }

    public static void exit() {
        Object object = VMBridge.instance.getThreadContextHelper();
        Context context = VMBridge.instance.getContext(object);
        if (context != null) {
            int n;
            if (context.enterCount < 1) {
                Kit.codeBug();
            }
            context.enterCount = n = context.enterCount - 1;
            if (n == 0) {
                VMBridge.instance.setContext(object, null);
                context.factory.onContextReleased(context);
            }
            return;
        }
        throw new IllegalStateException("Calling Context.exit without previous Context.enter");
    }

    private void firePropertyChangeImpl(Object object, String string2, Object object2, Object object3) {
        int n = 0;
        Object object4;
        while ((object4 = Kit.getListener(object, n)) != null) {
            if (object4 instanceof PropertyChangeListener) {
                ((PropertyChangeListener)object4).propertyChange(new PropertyChangeEvent(this, string2, object2, object3));
            }
            ++n;
        }
        return;
    }

    static Context getContext() {
        Context context = Context.getCurrentContext();
        if (context != null) {
            return context;
        }
        throw new RuntimeException("No Context associated with current Thread");
    }

    public static Context getCurrentContext() {
        Object object = VMBridge.instance.getThreadContextHelper();
        return VMBridge.instance.getContext(object);
    }

    public static DebuggableScript getDebuggableView(Script script) {
        if (script instanceof NativeFunction) {
            return ((NativeFunction)((Object)script)).getDebuggableView();
        }
        return null;
    }

    static String getSourcePositionFromStack(int[] nArray) {
        StackTraceElement[] stackTraceElementArray;
        Context object2 = Context.getCurrentContext();
        if (object2 == null) {
            return null;
        }
        if (object2.lastInterpreterFrame != null && (stackTraceElementArray = Context.createInterpreter()) != null) {
            return stackTraceElementArray.getSourcePositionFromStack(object2, nArray);
        }
        for (StackTraceElement stackTraceElement : new Throwable().getStackTrace()) {
            int n;
            String string2 = stackTraceElement.getFileName();
            if (string2 == null || string2.endsWith(".java") || (n = stackTraceElement.getLineNumber()) < 0) continue;
            nArray[0] = n;
            return string2;
        }
        return null;
    }

    public static Object getUndefinedValue() {
        return Undefined.instance;
    }

    public static boolean isValidLanguageVersion(int n) {
        switch (n) {
            default: {
                return false;
            }
            case 0: 
            case 100: 
            case 110: 
            case 120: 
            case 130: 
            case 140: 
            case 150: 
            case 160: 
            case 170: 
            case 180: 
            case 200: 
        }
        return true;
    }

    public static boolean isValidOptimizationLevel(int n) {
        boolean bl = -1 <= n && n <= 9;
        return bl;
    }

    public static Object javaToJS(Object object, Scriptable scriptable) {
        Object object2 = object;
        if (!(object instanceof String)) {
            object2 = object;
            if (!(object instanceof Number)) {
                object2 = object;
                if (!(object instanceof Boolean)) {
                    if (object instanceof Scriptable) {
                        object2 = object;
                    } else {
                        if (object instanceof Character) {
                            return String.valueOf(((Character)object).charValue());
                        }
                        object2 = Context.getContext();
                        object2 = ((Context)object2).getWrapFactory().wrap((Context)object2, scriptable, object, null);
                    }
                }
            }
        }
        return object2;
    }

    public static Object jsToJava(Object object, Class<?> clazz) throws EvaluatorException {
        return NativeJavaObject.coerceTypeImpl(clazz, object);
    }

    private static void notifyDebugger_r(Context context, DebuggableScript debuggableScript, String string2) {
        context.debugger.handleCompilationDone(context, debuggableScript, string2);
        for (int i = 0; i != debuggableScript.getFunctionCount(); ++i) {
            Context.notifyDebugger_r(context, debuggableScript.getFunction(i), string2);
        }
    }

    static void onSealedMutation() {
        throw new IllegalStateException();
    }

    @Deprecated
    public static void removeContextListener(ContextListener contextListener) {
        ContextFactory.getGlobal().addListener(contextListener);
    }

    public static void reportError(String string2) {
        int[] nArray = new int[]{0};
        Context.reportError(string2, Context.getSourcePositionFromStack(nArray), nArray[0], null, 0);
    }

    public static void reportError(String string2, String string3, int n, String string4, int n2) {
        Context context = Context.getCurrentContext();
        if (context != null) {
            context.getErrorReporter().error(string2, string3, n, string4, n2);
            return;
        }
        throw new EvaluatorException(string2, string3, n, string4, n2);
    }

    public static EvaluatorException reportRuntimeError(String string2) {
        int[] nArray = new int[]{0};
        return Context.reportRuntimeError(string2, Context.getSourcePositionFromStack(nArray), nArray[0], null, 0);
    }

    public static EvaluatorException reportRuntimeError(String string2, String string3, int n, String string4, int n2) {
        Context context = Context.getCurrentContext();
        if (context != null) {
            return context.getErrorReporter().runtimeError(string2, string3, n, string4, n2);
        }
        throw new EvaluatorException(string2, string3, n, string4, n2);
    }

    static EvaluatorException reportRuntimeError0(String string2) {
        return Context.reportRuntimeError(ScriptRuntime.getMessage0(string2));
    }

    static EvaluatorException reportRuntimeError1(String string2, Object object) {
        return Context.reportRuntimeError(ScriptRuntime.getMessage1(string2, object));
    }

    static EvaluatorException reportRuntimeError2(String string2, Object object, Object object2) {
        return Context.reportRuntimeError(ScriptRuntime.getMessage2(string2, object, object2));
    }

    static EvaluatorException reportRuntimeError3(String string2, Object object, Object object2, Object object3) {
        return Context.reportRuntimeError(ScriptRuntime.getMessage3(string2, object, object2, object3));
    }

    static EvaluatorException reportRuntimeError4(String string2, Object object, Object object2, Object object3, Object object4) {
        return Context.reportRuntimeError(ScriptRuntime.getMessage4(string2, object, object2, object3, object4));
    }

    public static void reportWarning(String string2) {
        int[] nArray = new int[]{0};
        Context.reportWarning(string2, Context.getSourcePositionFromStack(nArray), nArray[0], null, 0);
    }

    public static void reportWarning(String string2, String string3, int n, String string4, int n2) {
        Context context = Context.getContext();
        if (context.hasFeature(12)) {
            Context.reportError(string2, string3, n, string4, n2);
        } else {
            context.getErrorReporter().warning(string2, string3, n, string4, n2);
        }
    }

    public static void reportWarning(String string2, Throwable throwable) {
        int[] nArray = new int[]{0};
        String string3 = Context.getSourcePositionFromStack(nArray);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(string2);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        Context.reportWarning(((Object)stringWriter).toString(), string3, nArray[0], null, 0);
    }

    @Deprecated
    public static void setCachingEnabled(boolean bl) {
    }

    public static RuntimeException throwAsScriptRuntimeEx(Throwable throwable) {
        Context context;
        while (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        if (throwable instanceof Error && ((context = Context.getContext()) == null || !context.hasFeature(13))) {
            throw (Error)throwable;
        }
        if (throwable instanceof RhinoException) {
            throw (RhinoException)throwable;
        }
        throw new WrappedException(throwable);
    }

    public static boolean toBoolean(Object object) {
        return ScriptRuntime.toBoolean(object);
    }

    public static double toNumber(Object object) {
        return ScriptRuntime.toNumber(object);
    }

    public static Scriptable toObject(Object object, Scriptable scriptable) {
        return ScriptRuntime.toObject(scriptable, object);
    }

    @Deprecated
    public static Scriptable toObject(Object object, Scriptable scriptable, Class<?> clazz) {
        return ScriptRuntime.toObject(scriptable, object);
    }

    public static String toString(Object object) {
        return ScriptRuntime.toString(object);
    }

    @Deprecated
    public static Object toType(Object object, Class<?> serializable) throws IllegalArgumentException {
        try {
            object = Context.jsToJava(object, serializable);
            return object;
        }
        catch (EvaluatorException evaluatorException) {
            serializable = new IllegalArgumentException(evaluatorException.getMessage());
            Kit.initCause(serializable, evaluatorException);
            throw serializable;
        }
    }

    public void addActivationName(String string2) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (this.activationNames == null) {
            this.activationNames = new HashSet<String>();
        }
        this.activationNames.add(string2);
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.propertyListeners = Kit.addListener(this.propertyListeners, propertyChangeListener);
    }

    public Object callFunctionWithContinuations(Callable callable, Scriptable scriptable, Object[] objectArray) throws ContinuationPending {
        if (callable instanceof InterpretedFunction) {
            if (!ScriptRuntime.hasTopCall(this)) {
                this.isContinuationsTopCall = true;
                return ScriptRuntime.doTopCall(callable, this, scriptable, scriptable, objectArray, this.isTopLevelStrict);
            }
            throw new IllegalStateException("Cannot have any pending top calls when executing a script with continuations");
        }
        throw new IllegalArgumentException("Function argument was not created by interpreted mode ");
    }

    public ContinuationPending captureContinuation() {
        return new ContinuationPending(Interpreter.captureContinuation(this));
    }

    public final Function compileFunction(Scriptable scriptable, String string2, String string3, int n, Object object) {
        return this.compileFunction(scriptable, string2, null, null, string3, n, object);
    }

    final Function compileFunction(Scriptable scriptable, String string2, Evaluator evaluator, ErrorReporter errorReporter, String string3, int n, Object object) {
        try {
            scriptable = (Function)this.compileImpl(scriptable, null, string2, string3, n, object, true, evaluator, errorReporter);
            return scriptable;
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    public final Script compileReader(Reader reader, String string2, int n, Object object) throws IOException {
        block0: {
            if (n >= 0) break block0;
            n = 0;
        }
        return (Script)this.compileImpl(null, reader, null, string2, n, object, false, null, null);
    }

    @Deprecated
    public final Script compileReader(Scriptable scriptable, Reader reader, String string2, int n, Object object) throws IOException {
        return this.compileReader(reader, string2, n, object);
    }

    public final Script compileString(String string2, String string3, int n, Object object) {
        block0: {
            if (n >= 0) break block0;
            n = 0;
        }
        return this.compileString(string2, null, null, string3, n, object);
    }

    final Script compileString(String object, Evaluator evaluator, ErrorReporter errorReporter, String string2, int n, Object object2) {
        try {
            object = (Script)this.compileImpl(null, null, (String)object, string2, n, object2, false, evaluator, errorReporter);
            return object;
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    public GeneratedClassLoader createClassLoader(ClassLoader classLoader) {
        return this.getFactory().createClassLoader(classLoader);
    }

    public final String decompileFunction(Function function, int n) {
        if (function instanceof BaseFunction) {
            return ((BaseFunction)function).decompile(n, 0);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("function ");
        stringBuilder.append(function.getClassName());
        stringBuilder.append("() {\n\t[native code]\n}\n");
        return stringBuilder.toString();
    }

    public final String decompileFunctionBody(Function function, int n) {
        if (function instanceof BaseFunction) {
            return ((BaseFunction)function).decompile(n, 1);
        }
        return "[native code]\n";
    }

    public final String decompileScript(Script script, int n) {
        return ((NativeFunction)((Object)script)).decompile(n, 0);
    }

    public final Object evaluateReader(Scriptable scriptable, Reader object, String string2, int n, Object object2) throws IOException {
        if ((object = this.compileReader(scriptable, (Reader)object, string2, n, object2)) != null) {
            return object.exec(this, scriptable);
        }
        return null;
    }

    public final Object evaluateString(Scriptable scriptable, String object, String string2, int n, Object object2) {
        if ((object = this.compileString((String)object, string2, n, object2)) != null) {
            return object.exec(this, scriptable);
        }
        return null;
    }

    public Object executeScriptWithContinuations(Script script, Scriptable scriptable) throws ContinuationPending {
        if (script instanceof InterpretedFunction && ((InterpretedFunction)(script = (InterpretedFunction)script)).isScript()) {
            return this.callFunctionWithContinuations((Callable)((Object)script), scriptable, ScriptRuntime.emptyArgs);
        }
        throw new IllegalArgumentException("Script argument was not a script or was not created by interpreted mode ");
    }

    final void firePropertyChange(String string2, Object object, Object object2) {
        Object object3 = this.propertyListeners;
        if (object3 != null) {
            this.firePropertyChangeImpl(object3, string2, object, object2);
        }
    }

    public final ClassLoader getApplicationClassLoader() {
        if (this.applicationClassLoader == null) {
            ContextFactory contextFactory = this.getFactory();
            ClassLoader classLoader = contextFactory.getApplicationClassLoader();
            Class<?> clazz = classLoader;
            if (classLoader == null) {
                clazz = Thread.currentThread().getContextClassLoader();
                if (clazz != null && Kit.testIfCanLoadRhinoClasses((ClassLoader)((Object)clazz))) {
                    return clazz;
                }
                clazz = contextFactory.getClass();
                clazz = clazz != ScriptRuntime.ContextFactoryClass ? clazz.getClassLoader() : this.getClass().getClassLoader();
            }
            this.applicationClassLoader = clazz;
        }
        return this.applicationClassLoader;
    }

    final ClassShutter getClassShutter() {
        synchronized (this) {
            ClassShutter classShutter = this.classShutter;
            return classShutter;
        }
    }

    public final ClassShutterSetter getClassShutterSetter() {
        synchronized (this) {
            block4: {
                boolean bl = this.hasClassShutter;
                if (!bl) break block4;
                return null;
            }
            this.hasClassShutter = true;
            ClassShutterSetter classShutterSetter = new ClassShutterSetter(){

                @Override
                public ClassShutter getClassShutter() {
                    return Context.this.classShutter;
                }

                @Override
                public void setClassShutter(ClassShutter classShutter) {
                    Context.access$002(Context.this, classShutter);
                }
            };
            return classShutterSetter;
        }
    }

    public final Debugger getDebugger() {
        return this.debugger;
    }

    public final Object getDebuggerContextData() {
        return this.debuggerData;
    }

    public XMLLib.Factory getE4xImplementationFactory() {
        return this.getFactory().getE4xImplementationFactory();
    }

    public final Object[] getElements(Scriptable scriptable) {
        return ScriptRuntime.getArrayElements(scriptable);
    }

    public final ErrorReporter getErrorReporter() {
        ErrorReporter errorReporter;
        ErrorReporter errorReporter2 = errorReporter = this.errorReporter;
        if (errorReporter == null) {
            errorReporter2 = DefaultErrorReporter.instance;
        }
        return errorReporter2;
    }

    public final ContextFactory getFactory() {
        return this.factory;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String getImplementationVersion() {
        Object object;
        Object object2;
        Enumeration<URL> enumeration;
        if (implementationVersion != null) return implementationVersion;
        Object object3 = null;
        try {
            enumeration = Context.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        }
        catch (IOException iOException) {
            return null;
        }
        while (enumeration.hasMoreElements()) {
            block17: {
                block16: {
                    block15: {
                        object2 = enumeration.nextElement();
                        object2 = ((URL)object2).openStream();
                        object = new Manifest((InputStream)object2);
                        Attributes attributes = ((Manifest)object).getMainAttributes();
                        if (!"Mozilla Rhino".equals(attributes.getValue("Implementation-Title"))) break block15;
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Rhino ");
                        ((StringBuilder)object).append(attributes.getValue("Implementation-Version"));
                        ((StringBuilder)object).append(" ");
                        ((StringBuilder)object).append(attributes.getValue("Built-Date").replaceAll("-", " "));
                        implementationVersion = object = ((StringBuilder)object).toString();
                        if (object2 == null) return object;
                        ((InputStream)object2).close();
                        return object;
                    }
                    if (object2 == null) continue;
                    break block17;
                    catch (Throwable throwable) {
                        object3 = object2;
                        object2 = throwable;
                        break block16;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (object3 == null) throw object2;
                ((InputStream)object3).close();
                throw object2;
                catch (IOException iOException) {
                    block18: {
                        object2 = null;
                        break block18;
                        catch (IOException iOException2) {}
                    }
                    if (object2 == null) continue;
                }
            }
            try {
                ((InputStream)object2).close();
            }
            catch (IOException iOException) {}
        }
        return implementationVersion;
        catch (IOException iOException) {
            return object;
        }
        catch (IOException iOException) {
            throw object2;
        }
    }

    public final int getInstructionObserverThreshold() {
        return this.instructionThreshold;
    }

    public final int getLanguageVersion() {
        return this.version;
    }

    public final Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    public final int getMaximumInterpreterStackDepth() {
        return this.maximumInterpreterStackDepth;
    }

    public final int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    RegExpProxy getRegExpProxy() {
        Class<?> clazz;
        if (this.regExpProxy == null && (clazz = Kit.classOrNull("org.mozilla.javascript.regexp.RegExpImpl")) != null) {
            this.regExpProxy = (RegExpProxy)Kit.newInstanceOrNull(clazz);
        }
        return this.regExpProxy;
    }

    SecurityController getSecurityController() {
        SecurityController securityController = SecurityController.global();
        if (securityController != null) {
            return securityController;
        }
        return this.securityController;
    }

    public final Object getThreadLocal(Object object) {
        Map<Object, Object> map = this.threadLocalMap;
        if (map == null) {
            return null;
        }
        return map.get(object);
    }

    public final WrapFactory getWrapFactory() {
        if (this.wrapFactory == null) {
            this.wrapFactory = new WrapFactory();
        }
        return this.wrapFactory;
    }

    public boolean hasFeature(int n) {
        return this.getFactory().hasFeature(this, n);
    }

    public final Scriptable initSafeStandardObjects(ScriptableObject scriptableObject) {
        return this.initSafeStandardObjects(scriptableObject, false);
    }

    public final ScriptableObject initSafeStandardObjects() {
        return this.initSafeStandardObjects(null, false);
    }

    public ScriptableObject initSafeStandardObjects(ScriptableObject scriptableObject, boolean bl) {
        return ScriptRuntime.initSafeStandardObjects(this, scriptableObject, bl);
    }

    public final Scriptable initStandardObjects(ScriptableObject scriptableObject) {
        return this.initStandardObjects(scriptableObject, false);
    }

    public final ScriptableObject initStandardObjects() {
        return this.initStandardObjects(null, false);
    }

    public ScriptableObject initStandardObjects(ScriptableObject scriptableObject, boolean bl) {
        return ScriptRuntime.initStandardObjects(this, scriptableObject, bl);
    }

    public final boolean isActivationNeeded(String string2) {
        Set<String> set = this.activationNames;
        boolean bl = set != null && set.contains(string2);
        return bl;
    }

    public final boolean isGeneratingDebug() {
        return this.generatingDebug;
    }

    public final boolean isGeneratingDebugChanged() {
        return this.generatingDebugChanged;
    }

    public final boolean isGeneratingSource() {
        return this.generatingSource;
    }

    public final boolean isSealed() {
        return this.sealed;
    }

    public final boolean isStrictMode() {
        NativeCall nativeCall;
        boolean bl = this.isTopLevelStrict || (nativeCall = this.currentActivationCall) != null && nativeCall.isStrict;
        return bl;
    }

    final boolean isVersionECMA1() {
        int n = this.version;
        boolean bl = n == 0 || n >= 130;
        return bl;
    }

    public Scriptable newArray(Scriptable scriptable, int n) {
        NativeArray nativeArray = new NativeArray(n);
        ScriptRuntime.setBuiltinProtoAndParent(nativeArray, scriptable, TopLevel.Builtins.Array);
        return nativeArray;
    }

    public Scriptable newArray(Scriptable scriptable, Object[] object) {
        if (object.getClass().getComponentType() == ScriptRuntime.ObjectClass) {
            object = new NativeArray((Object[])object);
            ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)object, scriptable, TopLevel.Builtins.Array);
            return object;
        }
        throw new IllegalArgumentException();
    }

    public Scriptable newObject(Scriptable scriptable) {
        NativeObject nativeObject = new NativeObject();
        ScriptRuntime.setBuiltinProtoAndParent(nativeObject, scriptable, TopLevel.Builtins.Object);
        return nativeObject;
    }

    public Scriptable newObject(Scriptable scriptable, String string2) {
        return this.newObject(scriptable, string2, ScriptRuntime.emptyArgs);
    }

    public Scriptable newObject(Scriptable scriptable, String string2, Object[] objectArray) {
        return ScriptRuntime.newObject(this, scriptable, string2, objectArray);
    }

    protected void observeInstructionCount(int n) {
        this.getFactory().observeInstructionCount(this, n);
    }

    public final void putThreadLocal(Object object, Object object2) {
        synchronized (this) {
            if (this.sealed) {
                Context.onSealedMutation();
            }
            if (this.threadLocalMap == null) {
                HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
                this.threadLocalMap = hashMap;
            }
            this.threadLocalMap.put(object, object2);
            return;
        }
    }

    public void removeActivationName(String string2) {
        Set<String> set;
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if ((set = this.activationNames) != null) {
            set.remove(string2);
        }
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.propertyListeners = Kit.removeListener(this.propertyListeners, propertyChangeListener);
    }

    public final void removeThreadLocal(Object object) {
        Map<Object, Object> map;
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if ((map = this.threadLocalMap) == null) {
            return;
        }
        map.remove(object);
    }

    public Object resumeContinuation(Object object, Scriptable scriptable, Object object2) throws ContinuationPending {
        return Interpreter.restartContinuation((NativeContinuation)object, this, scriptable, new Object[]{object2});
    }

    public final void seal(Object object) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.sealed = true;
        this.sealKey = object;
    }

    public final void setApplicationClassLoader(ClassLoader classLoader) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (classLoader == null) {
            this.applicationClassLoader = null;
            return;
        }
        if (Kit.testIfCanLoadRhinoClasses(classLoader)) {
            this.applicationClassLoader = classLoader;
            return;
        }
        throw new IllegalArgumentException("Loader can not resolve Rhino classes");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setClassShutter(ClassShutter object) {
        synchronized (this) {
            if (this.sealed) {
                Context.onSealedMutation();
            }
            if (object == null) {
                object = new IllegalArgumentException();
                throw object;
            }
            if (!this.hasClassShutter) {
                this.classShutter = object;
                this.hasClassShutter = true;
                return;
            }
            object = new SecurityException("Cannot overwrite existing ClassShutter object");
            throw object;
        }
    }

    public final void setDebugger(Debugger debugger, Object object) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.debugger = debugger;
        this.debuggerData = object;
    }

    public final ErrorReporter setErrorReporter(ErrorReporter errorReporter) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (errorReporter != null) {
            ErrorReporter errorReporter2 = this.getErrorReporter();
            if (errorReporter == errorReporter2) {
                return errorReporter2;
            }
            Object object = this.propertyListeners;
            if (object != null) {
                this.firePropertyChangeImpl(object, errorReporterProperty, errorReporter2, errorReporter);
            }
            this.errorReporter = errorReporter;
            return errorReporter2;
        }
        throw new IllegalArgumentException();
    }

    public void setGenerateObserverCount(boolean bl) {
        this.generateObserverCount = bl;
    }

    public final void setGeneratingDebug(boolean bl) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.generatingDebugChanged = true;
        if (bl && this.getOptimizationLevel() > 0) {
            this.setOptimizationLevel(0);
        }
        this.generatingDebug = bl;
    }

    public final void setGeneratingSource(boolean bl) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.generatingSource = bl;
    }

    public final void setInstructionObserverThreshold(int n) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (n >= 0) {
            this.instructionThreshold = n;
            boolean bl = n > 0;
            this.setGenerateObserverCount(bl);
            return;
        }
        throw new IllegalArgumentException();
    }

    public void setLanguageVersion(int n) {
        int n2;
        if (this.sealed) {
            Context.onSealedMutation();
        }
        Context.checkLanguageVersion(n);
        Object object = this.propertyListeners;
        if (object != null && n != (n2 = this.version)) {
            this.firePropertyChangeImpl(object, languageVersionProperty, n2, n);
        }
        this.version = n;
    }

    public final Locale setLocale(Locale locale) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        Locale locale2 = this.locale;
        this.locale = locale;
        return locale2;
    }

    public final void setMaximumInterpreterStackDepth(int n) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (this.optimizationLevel == -1) {
            if (n >= 1) {
                this.maximumInterpreterStackDepth = n;
                return;
            }
            throw new IllegalArgumentException("Cannot set maximumInterpreterStackDepth to less than 1");
        }
        throw new IllegalStateException("Cannot set maximumInterpreterStackDepth when optimizationLevel != -1");
    }

    public final void setOptimizationLevel(int n) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        int n2 = -1;
        int n3 = n;
        if (n == -2) {
            n3 = -1;
        }
        Context.checkOptimizationLevel(n3);
        if (codegenClass == null) {
            n3 = n2;
        }
        this.optimizationLevel = n3;
    }

    public final void setSecurityController(SecurityController securityController) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (securityController != null) {
            if (this.securityController == null) {
                if (!SecurityController.hasGlobal()) {
                    this.securityController = securityController;
                    return;
                }
                throw new SecurityException("Can not overwrite existing global SecurityController object");
            }
            throw new SecurityException("Can not overwrite existing SecurityController object");
        }
        throw new IllegalArgumentException();
    }

    public final void setWrapFactory(WrapFactory wrapFactory) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (wrapFactory != null) {
            this.wrapFactory = wrapFactory;
            return;
        }
        throw new IllegalArgumentException();
    }

    public final boolean stringIsCompilableUnit(String string2) {
        boolean bl;
        Object object = new CompilerEnvirons();
        ((CompilerEnvirons)object).initFromContext(this);
        boolean bl2 = false;
        ((CompilerEnvirons)object).setGeneratingSource(false);
        object = new Parser((CompilerEnvirons)object, DefaultErrorReporter.instance);
        try {
            ((Parser)object).parse(string2, null, 1);
            bl = false;
        }
        catch (EvaluatorException evaluatorException) {
            bl = true;
        }
        if (!bl || !((Parser)object).eof()) {
            bl2 = true;
        }
        return bl2;
    }

    public final void unseal(Object object) {
        if (object != null) {
            if (this.sealKey == object) {
                if (this.sealed) {
                    this.sealed = false;
                    this.sealKey = null;
                    return;
                }
                throw new IllegalStateException();
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }

    public static interface ClassShutterSetter {
        public ClassShutter getClassShutter();

        public void setClassShutter(ClassShutter var1);
    }
}

