/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.DefiningClassLoader;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.xml.XMLLib;

public class ContextFactory {
    private static ContextFactory global = new ContextFactory();
    private static volatile boolean hasCustomGlobal;
    private ClassLoader applicationClassLoader;
    private boolean disabledListening;
    private volatile Object listeners;
    private final Object listenersLock = new Object();
    private volatile boolean sealed;

    static /* synthetic */ ContextFactory access$002(ContextFactory contextFactory) {
        global = contextFactory;
        return contextFactory;
    }

    public static ContextFactory getGlobal() {
        return global;
    }

    public static GlobalSetter getGlobalSetter() {
        synchronized (ContextFactory.class) {
            if (!hasCustomGlobal) {
                hasCustomGlobal = true;
                1GlobalSetterImpl globalSetterImpl = new 1GlobalSetterImpl();
                return globalSetterImpl;
            }
            IllegalStateException illegalStateException = new IllegalStateException();
            throw illegalStateException;
        }
    }

    public static boolean hasExplicitGlobal() {
        return hasCustomGlobal;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void initGlobal(ContextFactory object) {
        synchronized (ContextFactory.class) {
            Throwable throwable2;
            block6: {
                if (object != null) {
                    block5: {
                        try {
                            if (hasCustomGlobal) break block5;
                            hasCustomGlobal = true;
                            global = object;
                        }
                        catch (Throwable throwable2) {
                            break block6;
                        }
                        return;
                    }
                    object = new IllegalStateException();
                    throw object;
                }
                object = new IllegalArgumentException();
                throw object;
            }
            throw throwable2;
        }
    }

    private boolean isDom3Present() {
        Class<?> clazz = Kit.classOrNull("org.w3c.dom.Node");
        if (clazz == null) {
            return false;
        }
        try {
            clazz.getMethod("getUserData", String.class);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void addListener(Listener object) {
        this.checkNotSealed();
        Object object2 = this.listenersLock;
        synchronized (object2) {
            if (!this.disabledListening) {
                this.listeners = Kit.addListener(this.listeners, object);
                return;
            }
            object = new IllegalStateException();
            throw object;
        }
    }

    public final Object call(ContextAction contextAction) {
        return Context.call(this, contextAction);
    }

    protected final void checkNotSealed() {
        if (!this.sealed) {
            return;
        }
        throw new IllegalStateException();
    }

    protected GeneratedClassLoader createClassLoader(final ClassLoader classLoader) {
        return AccessController.doPrivileged(new PrivilegedAction<DefiningClassLoader>(){

            @Override
            public DefiningClassLoader run() {
                return new DefiningClassLoader(classLoader);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void disableContextListening() {
        this.checkNotSealed();
        Object object = this.listenersLock;
        synchronized (object) {
            this.disabledListening = true;
            this.listeners = null;
            return;
        }
    }

    protected Object doTopCall(Callable object, Context object2, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        object = object2 = object.call((Context)object2, scriptable, scriptable2, objectArray);
        if (object2 instanceof ConsString) {
            object = object2.toString();
        }
        return object;
    }

    @Deprecated
    public final Context enter() {
        return this.enterContext(null);
    }

    public Context enterContext() {
        return this.enterContext(null);
    }

    public final Context enterContext(Context context) {
        return Context.enter(context, this);
    }

    @Deprecated
    public final void exit() {
        Context.exit();
    }

    public final ClassLoader getApplicationClassLoader() {
        return this.applicationClassLoader;
    }

    protected XMLLib.Factory getE4xImplementationFactory() {
        if (this.isDom3Present()) {
            return XMLLib.Factory.create("org.mozilla.javascript.xmlimpl.XMLLibImpl");
        }
        return null;
    }

    protected boolean hasFeature(Context context, int n) {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        boolean bl6 = bl;
        boolean bl7 = bl2;
        boolean bl8 = bl3;
        switch (n) {
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
            case 17: 
            case 18: {
                return false;
            }
            case 16: {
                bl7 = context.getLanguageVersion() >= 200 ? bl5 : false;
                return bl7;
            }
            case 15: {
                bl6 = context.getLanguageVersion() <= 170 ? bl : false;
            }
            case 14: {
                return bl6;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return false;
            }
            case 6: {
                n = context.getLanguageVersion();
                bl7 = bl2;
                if (n != 0) {
                    bl7 = n >= 160 ? bl2 : false;
                }
            }
            case 5: {
                return bl7;
            }
            case 4: {
                bl8 = context.getLanguageVersion() == 120 ? bl3 : false;
            }
            case 3: {
                return bl8;
            }
            case 2: {
                return false;
            }
            case 1: 
        }
        n = context.getLanguageVersion();
        bl7 = bl4;
        if (n != 100) {
            bl7 = bl4;
            if (n != 110) {
                bl7 = n == 120 ? bl4 : false;
            }
        }
        return bl7;
    }

    public final void initApplicationClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            if (Kit.testIfCanLoadRhinoClasses(classLoader)) {
                if (this.applicationClassLoader == null) {
                    this.checkNotSealed();
                    this.applicationClassLoader = classLoader;
                    return;
                }
                throw new IllegalStateException("applicationClassLoader can only be set once");
            }
            throw new IllegalArgumentException("Loader can not resolve Rhino classes");
        }
        throw new IllegalArgumentException("loader is null");
    }

    public final boolean isSealed() {
        return this.sealed;
    }

    protected Context makeContext() {
        return new Context(this);
    }

    protected void observeInstructionCount(Context context, int n) {
    }

    protected void onContextCreated(Context context) {
        Object object = this.listeners;
        int n = 0;
        Listener listener;
        while ((listener = (Listener)Kit.getListener(object, n)) != null) {
            listener.contextCreated(context);
            ++n;
        }
        return;
    }

    protected void onContextReleased(Context context) {
        Object object = this.listeners;
        int n = 0;
        Listener listener;
        while ((listener = (Listener)Kit.getListener(object, n)) != null) {
            listener.contextReleased(context);
            ++n;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void removeListener(Listener object) {
        this.checkNotSealed();
        Object object2 = this.listenersLock;
        synchronized (object2) {
            if (!this.disabledListening) {
                this.listeners = Kit.removeListener(this.listeners, object);
                return;
            }
            object = new IllegalStateException();
            throw object;
        }
    }

    public final void seal() {
        this.checkNotSealed();
        this.sealed = true;
    }

    class 1GlobalSetterImpl
    implements GlobalSetter {
        1GlobalSetterImpl() {
        }

        @Override
        public ContextFactory getContextFactoryGlobal() {
            return global;
        }

        @Override
        public void setContextFactoryGlobal(ContextFactory contextFactory) {
            ContextFactory contextFactory2 = contextFactory;
            if (contextFactory == null) {
                contextFactory2 = new ContextFactory();
            }
            ContextFactory.access$002(contextFactory2);
        }
    }

    public static interface GlobalSetter {
        public ContextFactory getContextFactoryGlobal();

        public void setContextFactoryGlobal(ContextFactory var1);
    }

    public static interface Listener {
        public void contextCreated(Context var1);

        public void contextReleased(Context var1);
    }
}

