/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;

public abstract class ES6Iterator
extends IdScriptableObject {
    public static final String DONE_PROPERTY = "done";
    private static final int Id_iterator = 2;
    private static final int Id_next = 1;
    private static final int Id_toStringTag = 3;
    private static final int MAX_PROTOTYPE_ID = 3;
    public static final String NEXT_METHOD = "next";
    public static final String VALUE_PROPERTY = "value";
    protected boolean exhausted = false;

    ES6Iterator() {
    }

    ES6Iterator(Scriptable scriptable) {
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        this.setParentScope(scriptable);
        this.setPrototype((IdScriptableObject)ScriptableObject.getTopScopeValue(scriptable, this.getTag()));
    }

    static void init(ScriptableObject scriptableObject, boolean bl, IdScriptableObject idScriptableObject, String string2) {
        if (scriptableObject != null) {
            idScriptableObject.setParentScope(scriptableObject);
            idScriptableObject.setPrototype(ES6Iterator.getObjectPrototype(scriptableObject));
        }
        idScriptableObject.activatePrototypeMap(3);
        if (bl) {
            idScriptableObject.sealObject();
        }
        if (scriptableObject != null) {
            scriptableObject.associateValue(string2, idScriptableObject);
        }
    }

    private Scriptable makeIteratorResult(Context object, Scriptable scriptable, boolean bl, Object object2) {
        object = ((Context)object).newObject(scriptable);
        ScriptableObject.putProperty((Scriptable)object, VALUE_PROPERTY, object2);
        ScriptableObject.putProperty((Scriptable)object, DONE_PROPERTY, (Object)bl);
        return object;
    }

    @Override
    public Object execIdCall(IdFunctionObject idScriptableObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!((IdFunctionObject)idScriptableObject).hasTag(this.getTag())) {
            return super.execIdCall((IdFunctionObject)idScriptableObject, context, scriptable, scriptable2, objectArray);
        }
        int n = ((IdFunctionObject)idScriptableObject).methodId();
        if (scriptable2 instanceof ES6Iterator) {
            idScriptableObject = (ES6Iterator)scriptable2;
            if (n != 1) {
                if (n == 2) {
                    return idScriptableObject;
                }
                throw new IllegalArgumentException(String.valueOf(n));
            }
            return ((ES6Iterator)idScriptableObject).next(context, scriptable);
        }
        throw ES6Iterator.incompatibleCallError((IdFunctionObject)idScriptableObject);
    }

    @Override
    protected int findPrototypeId(String string2) {
        if (NEXT_METHOD.equals(string2)) {
            return 1;
        }
        return 0;
    }

    @Override
    protected int findPrototypeId(Symbol symbol) {
        if (SymbolKey.ITERATOR.equals(symbol)) {
            return 2;
        }
        if (SymbolKey.TO_STRING_TAG.equals(symbol)) {
            return 3;
        }
        return 0;
    }

    protected abstract String getTag();

    @Override
    protected void initPrototypeId(int n) {
        if (n != 1) {
            if (n != 2) {
                if (n == 3) {
                    this.initPrototypeValue(3, SymbolKey.TO_STRING_TAG, (Object)this.getClassName(), 3);
                    return;
                }
                throw new IllegalArgumentException(String.valueOf(n));
            }
            this.initPrototypeMethod((Object)this.getTag(), n, SymbolKey.ITERATOR, "[Symbol.iterator]", 0);
            return;
        }
        this.initPrototypeMethod(this.getTag(), n, NEXT_METHOD, 0);
    }

    protected abstract boolean isDone(Context var1, Scriptable var2);

    protected Object next(Context context, Scriptable scriptable) {
        Object object = Undefined.instance;
        boolean bl = this.isDone(context, scriptable) || this.exhausted;
        if (!bl) {
            object = this.nextValue(context, scriptable);
        } else {
            this.exhausted = true;
        }
        return this.makeIteratorResult(context, scriptable, bl, object);
    }

    protected abstract Object nextValue(Context var1, Scriptable var2);
}

