/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Iterator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SlotMap;

public class EmbeddedSlotMap
implements SlotMap {
    private static final int INITIAL_SLOT_SIZE = 4;
    private int count;
    private ScriptableObject.Slot firstAdded;
    private ScriptableObject.Slot lastAdded;
    private ScriptableObject.Slot[] slots;

    private void addKnownAbsentSlot(ScriptableObject.Slot[] slotArray, ScriptableObject.Slot slot) {
        int n = EmbeddedSlotMap.getSlotIndex(slotArray.length, slot.indexOrHash);
        ScriptableObject.Slot slot2 = slotArray[n];
        slotArray[n] = slot;
        slot.next = slot2;
    }

    private void copyTable(ScriptableObject.Slot[] slotArray, ScriptableObject.Slot[] slotArray2) {
        for (ScriptableObject.Slot slot : slotArray) {
            while (slot != null) {
                ScriptableObject.Slot slot2 = slot.next;
                slot.next = null;
                this.addKnownAbsentSlot(slotArray2, slot);
                slot = slot2;
            }
        }
    }

    private ScriptableObject.Slot createSlot(Object object, int n, ScriptableObject.SlotAccess object2, ScriptableObject.Slot object3) {
        ScriptableObject.Slot[] slotArray;
        int n2;
        block15: {
            block18: {
                ScriptableObject.Slot slot;
                block17: {
                    block16: {
                        block14: {
                            if (this.count != 0) break block14;
                            this.slots = new ScriptableObject.Slot[4];
                            break block15;
                        }
                        if (object3 == null) break block15;
                        n2 = EmbeddedSlotMap.getSlotIndex(this.slots.length, n);
                        object3 = this.slots[n2];
                        slotArray = object3;
                        while (!(object3 == null || ((ScriptableObject.Slot)object3).indexOrHash == n && (((ScriptableObject.Slot)object3).name == object || object != null && object.equals(((ScriptableObject.Slot)object3).name)))) {
                            slot = ((ScriptableObject.Slot)object3).next;
                            slotArray = object3;
                            object3 = slot;
                        }
                        if (object3 == null) break block15;
                        if (object2 != ScriptableObject.SlotAccess.MODIFY_GETTER_SETTER || object3 instanceof ScriptableObject.GetterSlot) break block16;
                        object = new ScriptableObject.GetterSlot(object, n, ((ScriptableObject.Slot)object3).getAttributes());
                        break block17;
                    }
                    if (object2 != ScriptableObject.SlotAccess.CONVERT_ACCESSOR_TO_DATA || !(object3 instanceof ScriptableObject.GetterSlot)) break block18;
                    object = new ScriptableObject.Slot(object, n, ((ScriptableObject.Slot)object3).getAttributes());
                }
                ((ScriptableObject.Slot)object).value = ((ScriptableObject.Slot)object3).value;
                ((ScriptableObject.Slot)object).next = ((ScriptableObject.Slot)object3).next;
                slot = this.firstAdded;
                object2 = slot;
                if (object3 == slot) {
                    this.firstAdded = object;
                } else {
                    while (object2 != null && ((ScriptableObject.Slot)object2).orderedNext != object3) {
                        object2 = ((ScriptableObject.Slot)object2).orderedNext;
                    }
                    if (object2 != null) {
                        ((ScriptableObject.Slot)object2).orderedNext = object;
                    }
                }
                ((ScriptableObject.Slot)object).orderedNext = ((ScriptableObject.Slot)object3).orderedNext;
                if (object3 == this.lastAdded) {
                    this.lastAdded = object;
                }
                if (slotArray == object3) {
                    this.slots[n2] = object;
                } else {
                    slotArray.next = object;
                }
                return object;
            }
            if (object2 == ScriptableObject.SlotAccess.MODIFY_CONST) {
                return null;
            }
            return object3;
        }
        n2 = this.count;
        slotArray = this.slots;
        if ((n2 + 1) * 4 > slotArray.length * 3) {
            object3 = new ScriptableObject.Slot[slotArray.length * 2];
            this.copyTable(slotArray, (ScriptableObject.Slot[])object3);
            this.slots = object3;
        }
        object = object2 == ScriptableObject.SlotAccess.MODIFY_GETTER_SETTER ? new ScriptableObject.GetterSlot(object, n, 0) : new ScriptableObject.Slot(object, n, 0);
        if (object2 == ScriptableObject.SlotAccess.MODIFY_CONST) {
            ((ScriptableObject.Slot)object).setAttributes(13);
        }
        this.insertNewSlot((ScriptableObject.Slot)object);
        return object;
    }

    private static int getSlotIndex(int n, int n2) {
        return n - 1 & n2;
    }

    private void insertNewSlot(ScriptableObject.Slot slot) {
        ++this.count;
        ScriptableObject.Slot slot2 = this.lastAdded;
        if (slot2 != null) {
            slot2.orderedNext = slot;
        }
        if (this.firstAdded == null) {
            this.firstAdded = slot;
        }
        this.lastAdded = slot;
        this.addKnownAbsentSlot(this.slots, slot);
    }

    @Override
    public void addSlot(ScriptableObject.Slot slot) {
        if (this.slots == null) {
            this.slots = new ScriptableObject.Slot[4];
        }
        this.insertNewSlot(slot);
    }

    @Override
    public ScriptableObject.Slot get(Object object, int n, ScriptableObject.SlotAccess slotAccess) {
        Object object2;
        block13: {
            Object object3;
            block14: {
                block15: {
                    object3 = this.slots;
                    object2 = null;
                    if (object3 == null && slotAccess == ScriptableObject.SlotAccess.QUERY) {
                        return null;
                    }
                    if (object != null) {
                        n = object.hashCode();
                    }
                    if ((object3 = this.slots) == null) break block13;
                    int n2 = EmbeddedSlotMap.getSlotIndex(((ScriptableObject.Slot[])object3).length, n);
                    object3 = this.slots[n2];
                    while (object3 != null) {
                        object2 = object3.name;
                        if (n == object3.indexOrHash && (object2 == object || object != null && object.equals(object2))) break;
                        object3 = object3.next;
                    }
                    if ((n2 = 1.$SwitchMap$org$mozilla$javascript$ScriptableObject$SlotAccess[slotAccess.ordinal()]) == 1) break block14;
                    if (n2 == 2 || n2 == 3) break block15;
                    if (n2 != 4) {
                        if (n2 != 5) {
                            object2 = object3;
                        } else {
                            object2 = object3;
                            if (!(object3 instanceof ScriptableObject.GetterSlot)) {
                                return object3;
                            }
                        }
                    } else {
                        object2 = object3;
                        if (object3 instanceof ScriptableObject.GetterSlot) {
                            return object3;
                        }
                    }
                    break block13;
                }
                object2 = object3;
                if (object3 == null) break block13;
            }
            return object3;
        }
        return this.createSlot(object, n, slotAccess, (ScriptableObject.Slot)object2);
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.count == 0;
        return bl;
    }

    @Override
    public Iterator<ScriptableObject.Slot> iterator() {
        return new Iter(this.firstAdded);
    }

    @Override
    public ScriptableObject.Slot query(Object object, int n) {
        if (this.slots == null) {
            return null;
        }
        if (object != null) {
            n = object.hashCode();
        }
        int n2 = EmbeddedSlotMap.getSlotIndex(this.slots.length, n);
        ScriptableObject.Slot slot = this.slots[n2];
        while (slot != null) {
            Object object2 = slot.name;
            if (n == slot.indexOrHash && (object2 == object || object != null && object.equals(object2))) {
                return slot;
            }
            slot = slot.next;
        }
        return null;
    }

    @Override
    public void remove(Object object, int n) {
        if (object != null) {
            n = object.hashCode();
        }
        if (this.count != 0) {
            ScriptableObject.Slot slot;
            int n2 = EmbeddedSlotMap.getSlotIndex(this.slots.length, n);
            ScriptableObject.Slot slot2 = slot = this.slots[n2];
            while (!(slot == null || slot.indexOrHash == n && (slot.name == object || object != null && object.equals(slot.name)))) {
                ScriptableObject.Slot slot3 = slot.next;
                slot2 = slot;
                slot = slot3;
            }
            if (slot != null) {
                if ((slot.getAttributes() & 4) != 0) {
                    if (!Context.getContext().isStrictMode()) {
                        return;
                    }
                    throw ScriptRuntime.typeError1("msg.delete.property.with.configurable.false", object);
                }
                --this.count;
                if (slot2 == slot) {
                    this.slots[n2] = slot.next;
                } else {
                    slot2.next = slot.next;
                }
                slot2 = this.firstAdded;
                object = slot2;
                if (slot == slot2) {
                    object = null;
                    this.firstAdded = slot.orderedNext;
                } else {
                    while (((ScriptableObject.Slot)object).orderedNext != slot) {
                        object = ((ScriptableObject.Slot)object).orderedNext;
                    }
                    ((ScriptableObject.Slot)object).orderedNext = slot.orderedNext;
                }
                if (slot == this.lastAdded) {
                    this.lastAdded = object;
                }
            }
        }
    }

    @Override
    public int size() {
        return this.count;
    }

    private static final class Iter
    implements Iterator<ScriptableObject.Slot> {
        private ScriptableObject.Slot next;

        Iter(ScriptableObject.Slot slot) {
            this.next = slot;
        }

        @Override
        public boolean hasNext() {
            boolean bl = this.next != null;
            return bl;
        }

        @Override
        public ScriptableObject.Slot next() {
            ScriptableObject.Slot slot = this.next;
            this.next = slot.orderedNext;
            return slot;
        }
    }
}

