/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class FunctionObject
extends BaseFunction {
    public static final int JAVA_BOOLEAN_TYPE = 3;
    public static final int JAVA_DOUBLE_TYPE = 4;
    public static final int JAVA_INT_TYPE = 2;
    public static final int JAVA_OBJECT_TYPE = 6;
    public static final int JAVA_SCRIPTABLE_TYPE = 5;
    public static final int JAVA_STRING_TYPE = 1;
    public static final int JAVA_UNSUPPORTED_TYPE = 0;
    private static final short VARARGS_CTOR = -2;
    private static final short VARARGS_METHOD = -1;
    private static boolean sawSecurityException = false;
    static final long serialVersionUID = -5332312783643935019L;
    private String functionName;
    private transient boolean hasVoidReturn;
    private boolean isStatic;
    MemberBox member;
    private int parmsLength;
    private transient int returnTypeTag;
    private transient byte[] typeTags;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FunctionObject(String object, Member object2, Scriptable scriptable) {
        if (object2 instanceof Constructor) {
            this.member = new MemberBox((Constructor)object2);
            this.isStatic = true;
        } else {
            this.member = object2 = new MemberBox((Method)object2);
            this.isStatic = ((MemberBox)object2).isStatic();
        }
        object2 = this.member.getName();
        this.functionName = object;
        object = this.member.argTypes;
        int n = ((Object)object).length;
        if (n == 4 && (((Class)object[1]).isArray() || ((Class)object[2]).isArray())) {
            if (((Class)object[1]).isArray()) {
                if (!this.isStatic || object[0] != ScriptRuntime.ContextClass || ((Class)object[1]).getComponentType() != ScriptRuntime.ObjectClass || object[2] != ScriptRuntime.FunctionClass || object[3] != Boolean.TYPE) throw Context.reportRuntimeError1("msg.varargs.ctor", object2);
                this.parmsLength = -2;
            } else {
                if (!this.isStatic || object[0] != ScriptRuntime.ContextClass || object[1] != ScriptRuntime.ScriptableClass || ((Class)object[2]).getComponentType() != ScriptRuntime.ObjectClass || object[3] != ScriptRuntime.FunctionClass) throw Context.reportRuntimeError1("msg.varargs.fun", object2);
                this.parmsLength = -1;
            }
        } else {
            this.parmsLength = n;
            if (n > 0) {
                this.typeTags = new byte[n];
                for (int i = 0; i != n; ++i) {
                    int n2 = FunctionObject.getTypeTag(object[i]);
                    if (n2 == 0) throw Context.reportRuntimeError2("msg.bad.parms", ((Class)object[i]).getName(), object2);
                    this.typeTags[i] = (byte)n2;
                }
            }
        }
        if (this.member.isMethod()) {
            object = this.member.method().getReturnType();
            if (object == Void.TYPE) {
                this.hasVoidReturn = true;
            } else {
                this.returnTypeTag = FunctionObject.getTypeTag(object);
            }
        } else {
            object = this.member.getDeclaringClass();
            if (!ScriptRuntime.ScriptableClass.isAssignableFrom((Class<?>)object)) throw Context.reportRuntimeError1("msg.bad.ctor.return", ((Class)object).getName());
        }
        ScriptRuntime.setFunctionProtoAndParent(this, scriptable);
    }

    public static Object convertArg(Context object, Scriptable scriptable, Object object2, int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException();
            }
            case 6: {
                return object2;
            }
            case 5: {
                return ScriptRuntime.toObjectOrNull((Context)object, object2, scriptable);
            }
            case 4: {
                if (object2 instanceof Double) {
                    return object2;
                }
                return new Double(ScriptRuntime.toNumber(object2));
            }
            case 3: {
                if (object2 instanceof Boolean) {
                    return object2;
                }
                object = ScriptRuntime.toBoolean(object2) ? Boolean.TRUE : Boolean.FALSE;
                return object;
            }
            case 2: {
                if (object2 instanceof Integer) {
                    return object2;
                }
                return ScriptRuntime.toInt32(object2);
            }
            case 1: 
        }
        if (object2 instanceof String) {
            return object2;
        }
        return ScriptRuntime.toString(object2);
    }

    @Deprecated
    public static Object convertArg(Context context, Scriptable scriptable, Object object, Class<?> clazz) {
        int n = FunctionObject.getTypeTag(clazz);
        if (n != 0) {
            return FunctionObject.convertArg(context, scriptable, object, n);
        }
        throw Context.reportRuntimeError1("msg.cant.convert", clazz.getName());
    }

    static Method findSingleMethod(Method[] methodArray, String string2) {
        int n = methodArray.length;
        Method method = null;
        for (int i = 0; i != n; ++i) {
            Method method2 = methodArray[i];
            Method method3 = method;
            if (method2 != null) {
                method3 = method;
                if (string2.equals(method2.getName())) {
                    if (method == null) {
                        method3 = method2;
                    } else {
                        throw Context.reportRuntimeError2("msg.no.overload", string2, method2.getDeclaringClass().getName());
                    }
                }
            }
            method = method3;
        }
        return method;
    }

    static Method[] getMethodList(Class<?> methodArray) {
        int n;
        Method[] methodArray2;
        block8: {
            block7: {
                try {
                    if (sawSecurityException) break block7;
                    methodArray2 = methodArray.getDeclaredMethods();
                    break block8;
                }
                catch (SecurityException securityException) {
                    sawSecurityException = true;
                }
            }
            methodArray2 = null;
        }
        Method[] methodArray3 = methodArray2;
        if (methodArray2 == null) {
            methodArray3 = methodArray.getMethods();
        }
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < methodArray3.length; ++n) {
            if (sawSecurityException ? methodArray3[n].getDeclaringClass() != methodArray : !Modifier.isPublic(methodArray3[n].getModifiers())) {
                methodArray3[n] = null;
                continue;
            }
            ++n3;
        }
        methodArray = new Method[n3];
        n3 = 0;
        n = n2;
        n2 = n3;
        while (n < methodArray3.length) {
            n3 = n2;
            if (methodArray3[n] != null) {
                methodArray[n2] = methodArray3[n];
                n3 = n2 + 1;
            }
            ++n;
            n2 = n3;
        }
        return methodArray;
    }

    public static int getTypeTag(Class<?> clazz) {
        if (clazz == ScriptRuntime.StringClass) {
            return 1;
        }
        if (clazz != ScriptRuntime.IntegerClass && clazz != Integer.TYPE) {
            if (clazz != ScriptRuntime.BooleanClass && clazz != Boolean.TYPE) {
                if (clazz != ScriptRuntime.DoubleClass && clazz != Double.TYPE) {
                    if (ScriptRuntime.ScriptableClass.isAssignableFrom(clazz)) {
                        return 5;
                    }
                    if (clazz == ScriptRuntime.ObjectClass) {
                        return 6;
                    }
                    return 0;
                }
                return 4;
            }
            return 3;
        }
        return 2;
    }

    private void readObject(ObjectInputStream object) throws IOException, ClassNotFoundException {
        object.defaultReadObject();
        if (this.parmsLength > 0) {
            object = this.member.argTypes;
            this.typeTags = new byte[this.parmsLength];
            for (int i = 0; i != this.parmsLength; ++i) {
                this.typeTags[i] = (byte)FunctionObject.getTypeTag(object[i]);
            }
        }
        if (this.member.isMethod()) {
            object = this.member.method().getReturnType();
            if (object == Void.TYPE) {
                this.hasVoidReturn = true;
            } else {
                this.returnTypeTag = FunctionObject.getTypeTag(object);
            }
        }
    }

    public void addAsConstructor(Scriptable scriptable, Scriptable scriptable2) {
        this.initAsConstructor(scriptable, scriptable2);
        FunctionObject.defineProperty(scriptable, scriptable2.getClassName(), this, 2);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public Object call(Context var1_1, Scriptable var2_2, Scriptable var3_3, Object[] var4_4) {
        var5_5 = ((Object[])var4_4).length;
        var6_6 = 0;
        for (var7_7 = 0; var7_7 < var5_5; ++var7_7) {
            if (!(var4_4[var7_7] instanceof ConsString)) continue;
            var4_4[var7_7] = var4_4[var7_7].toString();
        }
        var7_7 = this.parmsLength;
        if (var7_7 < 0) {
            if (var7_7 == -1) {
                var3_3 /* !! */  = this.member.invoke(null, new Object[]{var1_1, var3_3 /* !! */ , var4_4, this});
lbl11:
                // 2 sources

                while (true) {
                    var7_7 = 1;
                    break;
                }
            } else {
                var7_7 = var3_3 /* !! */  == null ? 1 : 0;
                var3_3 /* !! */  = var7_7 != 0 ? Boolean.TRUE : Boolean.FALSE;
                var8_8 = new Object[]{var1_1, var4_4, this, var3_3 /* !! */ };
                if (this.member.isCtor()) {
                    var3_3 /* !! */  = this.member.newInstance(var8_8);
                    var7_7 = var6_6;
                } else {
                    var3_3 /* !! */  = this.member.invoke(null, var8_8);
                    var7_7 = var6_6;
                }
            }
        } else {
            var9_10 = var3_3 /* !! */ ;
            if (!this.isStatic) {
                var10_11 /* !! */  = this.member.getDeclaringClass();
                var9_10 = var3_3 /* !! */ ;
                if (!var10_11 /* !! */ .isInstance(var3_3 /* !! */ )) {
                    if (var3_3 /* !! */  == var2_2 && var2_2 != (var8_9 = this.getParentScope())) {
                        var12_13 = var11_12 = var10_11 /* !! */ .isInstance(var8_9);
                        if (var11_12) {
                            var3_3 /* !! */  = var8_9;
                            var12_13 = var11_12;
                        }
                    } else {
                        var12_13 = false;
                    }
                    if (var12_13) {
                        var9_10 = var3_3 /* !! */ ;
                    } else {
                        throw ScriptRuntime.typeError1("msg.incompat.call", this.functionName);
                    }
                }
            }
            if ((var7_7 = this.parmsLength) == var5_5) {
                var3_3 /* !! */  = var4_4;
                var7_7 = 0;
                while (true) {
                    var8_9 = var3_3 /* !! */ ;
                    if (var7_7 != this.parmsLength) {
                        var13_14 = var4_4[var7_7];
                        var10_11 /* !! */  = FunctionObject.convertArg(var1_1, var2_2, var13_14, this.typeTags[var7_7]);
                        var8_9 = var3_3 /* !! */ ;
                        if (var13_14 != var10_11 /* !! */ ) {
                            var8_9 = var3_3 /* !! */ ;
                            if (var3_3 /* !! */  == var4_4) {
                                var8_9 = (Object[])var4_4.clone();
                            }
                            var8_9[var7_7] = var10_11 /* !! */ ;
                        }
                        ++var7_7;
                        var3_3 /* !! */  = var8_9;
                        continue;
                    }
                    break;
                }
            } else if (var7_7 == 0) {
                var8_9 = ScriptRuntime.emptyArgs;
            } else {
                var10_11 /* !! */  = new Object[var7_7];
                var7_7 = 0;
                while (true) {
                    var8_9 = var10_11 /* !! */ ;
                    if (var7_7 == this.parmsLength) break;
                    var3_3 /* !! */  = var7_7 < var5_5 ? var4_4[var7_7] : Undefined.instance;
                    var10_11 /* !! */ [var7_7] = FunctionObject.convertArg(var1_1, var2_2, (Object)var3_3 /* !! */ , this.typeTags[var7_7]);
                    ++var7_7;
                }
            }
            if (this.member.isMethod()) {
                var3_3 /* !! */  = this.member.invoke(var9_10, var8_9);
                ** continue;
            }
            var3_3 /* !! */  = this.member.newInstance(var8_9);
            var7_7 = var6_6;
        }
        var4_4 = var3_3 /* !! */ ;
        if (var7_7 != 0) {
            if (this.hasVoidReturn) {
                var4_4 = Undefined.instance;
            } else {
                var4_4 = var3_3 /* !! */ ;
                if (this.returnTypeTag == 0) {
                    var4_4 = var1_1.getWrapFactory().wrap(var1_1, var2_2, var3_3 /* !! */ , null);
                }
            }
        }
        return var4_4;
    }

    @Override
    public Scriptable createObject(Context object, Scriptable scriptable) {
        if (!this.member.isCtor() && this.parmsLength != -2) {
            try {
                object = (Scriptable)this.member.getDeclaringClass().newInstance();
                object.setPrototype(this.getClassPrototype());
                object.setParentScope(this.getParentScope());
                return object;
            }
            catch (Exception exception) {
                throw Context.throwAsScriptRuntimeEx(exception);
            }
        }
        return null;
    }

    @Override
    public int getArity() {
        int n;
        int n2 = n = this.parmsLength;
        if (n < 0) {
            n2 = 1;
        }
        return n2;
    }

    @Override
    public String getFunctionName() {
        String string2;
        String string3 = string2 = this.functionName;
        if (string2 == null) {
            string3 = "";
        }
        return string3;
    }

    @Override
    public int getLength() {
        return this.getArity();
    }

    public Member getMethodOrConstructor() {
        if (this.member.isMethod()) {
            return this.member.method();
        }
        return this.member.ctor();
    }

    void initAsConstructor(Scriptable scriptable, Scriptable scriptable2) {
        ScriptRuntime.setFunctionProtoAndParent(this, scriptable);
        this.setImmunePrototypeProperty(scriptable2);
        scriptable2.setParentScope(this);
        FunctionObject.defineProperty(scriptable2, "constructor", this, 7);
        this.setParentScope(scriptable);
    }

    boolean isVarArgsConstructor() {
        boolean bl = this.parmsLength == -2;
        return bl;
    }

    boolean isVarArgsMethod() {
        boolean bl = this.parmsLength == -1;
        return bl;
    }
}

