/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.IdFunctionCall;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdFunctionObjectES6;
import org.mozilla.javascript.NativeSymbol;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.UniqueTag;

public abstract class IdScriptableObject
extends ScriptableObject
implements IdFunctionCall {
    private transient PrototypeValues prototypeValues;

    public IdScriptableObject() {
    }

    public IdScriptableObject(Scriptable scriptable, Scriptable scriptable2) {
        super(scriptable, scriptable2);
    }

    private ScriptableObject getBuiltInDescriptor(String string2) {
        int n;
        Object object = this.getParentScope();
        Scriptable scriptable = object;
        if (object == null) {
            scriptable = this;
        }
        if ((n = this.findInstanceIdInfo(string2)) != 0) {
            return IdScriptableObject.buildDataDescriptor(scriptable, this.getInstanceIdValue(0xFFFF & n), n >>> 16);
        }
        object = this.prototypeValues;
        if (object != null && (n = ((PrototypeValues)object).findId(string2)) != 0) {
            return IdScriptableObject.buildDataDescriptor(scriptable, this.prototypeValues.get(n), this.prototypeValues.getAttributes(n));
        }
        return null;
    }

    private ScriptableObject getBuiltInDescriptor(Symbol symbol) {
        int n;
        Object object = this.getParentScope();
        Scriptable scriptable = object;
        if (object == null) {
            scriptable = this;
        }
        if ((object = this.prototypeValues) != null && (n = ((PrototypeValues)object).findId(symbol)) != 0) {
            return IdScriptableObject.buildDataDescriptor(scriptable, this.prototypeValues.get(n), this.prototypeValues.getAttributes(n));
        }
        return null;
    }

    protected static EcmaError incompatibleCallError(IdFunctionObject idFunctionObject) {
        throw ScriptRuntime.typeError1("msg.incompat.call", idFunctionObject.getFunctionName());
    }

    protected static int instanceIdInfo(int n, int n2) {
        return n << 16 | n2;
    }

    private IdFunctionObject newIdFunction(Object object, int n, String string2, int n2, Scriptable scriptable) {
        object = Context.getContext().getLanguageVersion() < 200 ? new IdFunctionObject(this, object, n, string2, n2, scriptable) : new IdFunctionObjectES6(this, object, n, string2, n2, scriptable);
        if (this.isSealed()) {
            ((ScriptableObject)object).sealObject();
        }
        return object;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n != 0) {
            this.activatePrototypeMap(n);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        PrototypeValues prototypeValues = this.prototypeValues;
        int n = prototypeValues != null ? prototypeValues.getMaxId() : 0;
        objectOutputStream.writeInt(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void activatePrototypeMap(int n) {
        Serializable serializable = new PrototypeValues(this, n);
        synchronized (this) {
            if (this.prototypeValues == null) {
                this.prototypeValues = serializable;
                return;
            }
            serializable = new IllegalStateException();
            throw serializable;
        }
    }

    protected void addIdFunctionProperty(Scriptable scriptable, Object object, int n, String string2, int n2) {
        this.newIdFunction(object, n, string2, n2, ScriptableObject.getTopLevelScope(scriptable)).addAsProperty(scriptable);
    }

    protected final Object defaultGet(String string2) {
        return super.get(string2, (Scriptable)this);
    }

    protected final boolean defaultHas(String string2) {
        return super.has(string2, (Scriptable)this);
    }

    protected final void defaultPut(String string2, Object object) {
        super.put(string2, (Scriptable)this, object);
    }

    @Override
    public void defineOwnProperty(Context object, Object object2, ScriptableObject scriptableObject) {
        if (object2 instanceof String) {
            PrototypeValues prototypeValues;
            int n;
            String string2 = (String)object2;
            int n2 = this.findInstanceIdInfo(string2);
            if (n2 != 0) {
                n = 0xFFFF & n2;
                if (this.isAccessorDescriptor(scriptableObject)) {
                    this.delete(n);
                } else {
                    this.checkPropertyDefinition(scriptableObject);
                    this.checkPropertyChange(string2, this.getOwnPropertyDescriptor((Context)object, object2), scriptableObject);
                    object = IdScriptableObject.getProperty((Scriptable)scriptableObject, "value");
                    if (object != NOT_FOUND && ((n2 >>>= 16) & 1) == 0 && !this.sameValue(object, this.getInstanceIdValue(n))) {
                        this.setInstanceIdValue(n, object);
                    }
                    this.setAttributes(string2, this.applyDescriptorToAttributeBitset(n2, scriptableObject));
                    return;
                }
            }
            if ((prototypeValues = this.prototypeValues) != null && (n = prototypeValues.findId(string2)) != 0) {
                if (this.isAccessorDescriptor(scriptableObject)) {
                    this.prototypeValues.delete(n);
                } else {
                    this.checkPropertyDefinition(scriptableObject);
                    this.checkPropertyChange(string2, this.getOwnPropertyDescriptor((Context)object, object2), scriptableObject);
                    n2 = this.prototypeValues.getAttributes(n);
                    object = IdScriptableObject.getProperty((Scriptable)scriptableObject, "value");
                    if (object != NOT_FOUND && (n2 & 1) == 0 && !this.sameValue(object, this.prototypeValues.get(n))) {
                        this.prototypeValues.set(n, this, object);
                    }
                    this.prototypeValues.setAttributes(n, this.applyDescriptorToAttributeBitset(n2, scriptableObject));
                    return;
                }
            }
        }
        super.defineOwnProperty((Context)object, object2, scriptableObject);
    }

    @Override
    public void delete(String string2) {
        int n = this.findInstanceIdInfo(string2);
        if (n != 0 && !this.isSealed()) {
            if ((n >>> 16 & 4) != 0) {
                if (Context.getContext().isStrictMode()) {
                    throw ScriptRuntime.typeError1("msg.delete.property.with.configurable.false", string2);
                }
            } else {
                this.setInstanceIdValue(0xFFFF & n, NOT_FOUND);
            }
            return;
        }
        PrototypeValues prototypeValues = this.prototypeValues;
        if (prototypeValues != null && (n = prototypeValues.findId(string2)) != 0) {
            if (!this.isSealed()) {
                this.prototypeValues.delete(n);
            }
            return;
        }
        super.delete(string2);
    }

    @Override
    public void delete(Symbol symbol) {
        int n = this.findInstanceIdInfo(symbol);
        if (n != 0 && !this.isSealed()) {
            if ((n >>> 16 & 4) != 0) {
                if (Context.getContext().isStrictMode()) {
                    throw ScriptRuntime.typeError0("msg.delete.property.with.configurable.false");
                }
            } else {
                this.setInstanceIdValue(0xFFFF & n, NOT_FOUND);
            }
            return;
        }
        PrototypeValues prototypeValues = this.prototypeValues;
        if (prototypeValues != null && (n = prototypeValues.findId(symbol)) != 0) {
            if (!this.isSealed()) {
                this.prototypeValues.delete(n);
            }
            return;
        }
        super.delete(symbol);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        throw idFunctionObject.unknown();
    }

    public final IdFunctionObject exportAsJSClass(int n, Scriptable scriptable, boolean bl) {
        if (scriptable != this && scriptable != null) {
            this.setParentScope(scriptable);
            this.setPrototype(IdScriptableObject.getObjectPrototype(scriptable));
        }
        this.activatePrototypeMap(n);
        scriptable = this.prototypeValues.createPrecachedConstructor();
        if (bl) {
            this.sealObject();
        }
        this.fillConstructorProperties((IdFunctionObject)scriptable);
        if (bl) {
            ((ScriptableObject)scriptable).sealObject();
        }
        ((IdFunctionObject)scriptable).exportAsScopeProperty();
        return scriptable;
    }

    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
    }

    protected int findInstanceIdInfo(String string2) {
        return 0;
    }

    protected int findInstanceIdInfo(Symbol symbol) {
        return 0;
    }

    protected int findPrototypeId(String string2) {
        throw new IllegalStateException(string2);
    }

    protected int findPrototypeId(Symbol symbol) {
        return 0;
    }

    @Override
    public Object get(String object, Scriptable object2) {
        if ((object2 = super.get((String)object, (Scriptable)object2)) != NOT_FOUND) {
            return object2;
        }
        int n = this.findInstanceIdInfo((String)object);
        if (n != 0 && (object2 = this.getInstanceIdValue(n & 0xFFFF)) != NOT_FOUND) {
            return object2;
        }
        object2 = this.prototypeValues;
        if (object2 != null && (n = ((PrototypeValues)object2).findId((String)object)) != 0 && (object = this.prototypeValues.get(n)) != NOT_FOUND) {
            return object;
        }
        return NOT_FOUND;
    }

    @Override
    public Object get(Symbol object, Scriptable object2) {
        if ((object2 = super.get((Symbol)object, (Scriptable)object2)) != NOT_FOUND) {
            return object2;
        }
        int n = this.findInstanceIdInfo((Symbol)object);
        if (n != 0 && (object2 = this.getInstanceIdValue(n & 0xFFFF)) != NOT_FOUND) {
            return object2;
        }
        object2 = this.prototypeValues;
        if (object2 != null && (n = ((PrototypeValues)object2).findId((Symbol)object)) != 0 && (object = this.prototypeValues.get(n)) != NOT_FOUND) {
            return object;
        }
        return NOT_FOUND;
    }

    @Override
    public int getAttributes(String string2) {
        int n = this.findInstanceIdInfo(string2);
        if (n != 0) {
            return n >>> 16;
        }
        PrototypeValues prototypeValues = this.prototypeValues;
        if (prototypeValues != null && (n = prototypeValues.findId(string2)) != 0) {
            return this.prototypeValues.getAttributes(n);
        }
        return super.getAttributes(string2);
    }

    @Override
    Object[] getIds(boolean bl, boolean bl2) {
        Object[] objectArray;
        block9: {
            int n;
            Object[] objectArray2 = super.getIds(bl, bl2);
            objectArray = this.prototypeValues;
            Object[] objectArray3 = objectArray2;
            if (objectArray != null) {
                objectArray3 = objectArray.getNames(bl, objectArray2);
            }
            objectArray = objectArray3;
            if (n == 0) break block9;
            objectArray2 = null;
            int n2 = 0;
            for (n = this.getMaxInstanceId(); n != 0; --n) {
                int n3;
                block10: {
                    String string2;
                    block12: {
                        int n4;
                        block11: {
                            string2 = this.getInstanceIdName(n);
                            n4 = this.findInstanceIdInfo(string2);
                            objectArray = objectArray2;
                            n3 = n2;
                            if (n4 == 0) break block10;
                            if (((n4 >>>= 16) & 4) != 0 || NOT_FOUND != this.getInstanceIdValue(n)) break block11;
                            objectArray = objectArray2;
                            n3 = n2;
                            break block10;
                        }
                        if (bl) break block12;
                        objectArray = objectArray2;
                        n3 = n2;
                        if ((n4 & 2) != 0) break block10;
                    }
                    if (n2 == 0) {
                        objectArray2 = new Object[n];
                    }
                    objectArray2[n2] = string2;
                    n3 = n2 + 1;
                    objectArray = objectArray2;
                }
                objectArray2 = objectArray;
                n2 = n3;
            }
            objectArray = objectArray3;
            if (n2 != 0) {
                if (objectArray3.length == 0 && objectArray2.length == n2) {
                    objectArray = objectArray2;
                } else {
                    objectArray = new Object[objectArray3.length + n2];
                    System.arraycopy(objectArray3, 0, objectArray, 0, objectArray3.length);
                    System.arraycopy(objectArray2, 0, objectArray, objectArray3.length, n2);
                }
            }
        }
        return objectArray;
    }

    protected String getInstanceIdName(int n) {
        throw new IllegalArgumentException(String.valueOf(n));
    }

    protected Object getInstanceIdValue(int n) {
        throw new IllegalStateException(String.valueOf(n));
    }

    protected int getMaxInstanceId() {
        return 0;
    }

    @Override
    protected ScriptableObject getOwnPropertyDescriptor(Context object, Object object2) {
        ScriptableObject scriptableObject = super.getOwnPropertyDescriptor((Context)object, object2);
        object = scriptableObject;
        if (scriptableObject == null) {
            if (object2 instanceof String) {
                object = this.getBuiltInDescriptor((String)object2);
            } else {
                object = scriptableObject;
                if (ScriptRuntime.isSymbol(object2)) {
                    object = this.getBuiltInDescriptor(((NativeSymbol)object2).getKey());
                }
            }
        }
        return object;
    }

    @Override
    public boolean has(String string2, Scriptable scriptable) {
        int n = this.findInstanceIdInfo(string2);
        if (n != 0) {
            boolean bl = true;
            if ((n >>> 16 & 4) != 0) {
                return true;
            }
            if (NOT_FOUND == this.getInstanceIdValue(0xFFFF & n)) {
                bl = false;
            }
            return bl;
        }
        PrototypeValues prototypeValues = this.prototypeValues;
        if (prototypeValues != null && (n = prototypeValues.findId(string2)) != 0) {
            return this.prototypeValues.has(n);
        }
        return super.has(string2, scriptable);
    }

    @Override
    public boolean has(Symbol symbol, Scriptable scriptable) {
        int n = this.findInstanceIdInfo(symbol);
        if (n != 0) {
            boolean bl = true;
            if ((n >>> 16 & 4) != 0) {
                return true;
            }
            if (NOT_FOUND == this.getInstanceIdValue(0xFFFF & n)) {
                bl = false;
            }
            return bl;
        }
        PrototypeValues prototypeValues = this.prototypeValues;
        if (prototypeValues != null && (n = prototypeValues.findId(symbol)) != 0) {
            return this.prototypeValues.has(n);
        }
        return super.has(symbol, scriptable);
    }

    public final boolean hasPrototypeMap() {
        boolean bl = this.prototypeValues != null;
        return bl;
    }

    public final void initPrototypeConstructor(IdFunctionObject idFunctionObject) {
        int n = this.prototypeValues.constructorId;
        if (n != 0) {
            if (idFunctionObject.methodId() == n) {
                if (this.isSealed()) {
                    idFunctionObject.sealObject();
                }
                this.prototypeValues.initValue(n, "constructor", (Object)idFunctionObject, 2);
                return;
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalStateException();
    }

    protected void initPrototypeId(int n) {
        throw new IllegalStateException(String.valueOf(n));
    }

    public final IdFunctionObject initPrototypeMethod(Object object, int n, String string2, int n2) {
        return this.initPrototypeMethod(object, n, string2, string2, n2);
    }

    public final IdFunctionObject initPrototypeMethod(Object object, int n, String string2, String string3, int n2) {
        Scriptable scriptable = ScriptableObject.getTopLevelScope(this);
        if (string3 == null) {
            string3 = string2;
        }
        object = this.newIdFunction(object, n, string3, n2, scriptable);
        this.prototypeValues.initValue(n, string2, object, 2);
        return object;
    }

    public final IdFunctionObject initPrototypeMethod(Object object, int n, Symbol symbol, String string2, int n2) {
        object = this.newIdFunction(object, n, string2, n2, ScriptableObject.getTopLevelScope(this));
        this.prototypeValues.initValue(n, symbol, object, 2);
        return object;
    }

    public final void initPrototypeValue(int n, String string2, Object object, int n2) {
        this.prototypeValues.initValue(n, string2, object, n2);
    }

    public final void initPrototypeValue(int n, Symbol symbol, Object object, int n2) {
        this.prototypeValues.initValue(n, symbol, object, n2);
    }

    @Override
    public void put(String string2, Scriptable scriptable, Object object) {
        int n = this.findInstanceIdInfo(string2);
        if (n != 0) {
            if (scriptable == this && this.isSealed()) {
                throw Context.reportRuntimeError1("msg.modify.sealed", string2);
            }
            if ((n >>> 16 & 1) == 0) {
                if (scriptable == this) {
                    this.setInstanceIdValue(0xFFFF & n, object);
                } else {
                    scriptable.put(string2, scriptable, object);
                }
            }
            return;
        }
        PrototypeValues prototypeValues = this.prototypeValues;
        if (prototypeValues != null && (n = prototypeValues.findId(string2)) != 0) {
            if (scriptable == this && this.isSealed()) {
                throw Context.reportRuntimeError1("msg.modify.sealed", string2);
            }
            this.prototypeValues.set(n, scriptable, object);
            return;
        }
        super.put(string2, scriptable, object);
    }

    @Override
    public void put(Symbol symbol, Scriptable scriptable, Object object) {
        int n = this.findInstanceIdInfo(symbol);
        if (n != 0) {
            if (scriptable == this && this.isSealed()) {
                throw Context.reportRuntimeError0("msg.modify.sealed");
            }
            if ((n >>> 16 & 1) == 0) {
                if (scriptable == this) {
                    this.setInstanceIdValue(0xFFFF & n, object);
                } else {
                    IdScriptableObject.ensureSymbolScriptable(scriptable).put(symbol, scriptable, object);
                }
            }
            return;
        }
        PrototypeValues prototypeValues = this.prototypeValues;
        if (prototypeValues != null && (n = prototypeValues.findId(symbol)) != 0) {
            if (scriptable == this && this.isSealed()) {
                throw Context.reportRuntimeError0("msg.modify.sealed");
            }
            this.prototypeValues.set(n, scriptable, object);
            return;
        }
        super.put(symbol, scriptable, object);
    }

    @Override
    public void setAttributes(String string2, int n) {
        ScriptableObject.checkValidAttributes(n);
        int n2 = this.findInstanceIdInfo(string2);
        if (n2 != 0) {
            if (n != n2 >>> 16) {
                this.setInstanceIdAttributes(0xFFFF & n2, n);
            }
            return;
        }
        PrototypeValues prototypeValues = this.prototypeValues;
        if (prototypeValues != null && (n2 = prototypeValues.findId(string2)) != 0) {
            this.prototypeValues.setAttributes(n2, n);
            return;
        }
        super.setAttributes(string2, n);
    }

    protected void setInstanceIdAttributes(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Changing attributes not supported for ");
        stringBuilder.append(this.getClassName());
        stringBuilder.append(" ");
        stringBuilder.append(this.getInstanceIdName(n));
        stringBuilder.append(" property");
        throw ScriptRuntime.constructError("InternalError", stringBuilder.toString());
    }

    protected void setInstanceIdValue(int n, Object object) {
        throw new IllegalStateException(String.valueOf(n));
    }

    private static final class PrototypeValues
    implements Serializable {
        private static final int NAME_SLOT = 1;
        private static final int SLOT_SPAN = 2;
        static final long serialVersionUID = 3038645279153854371L;
        private short[] attributeArray;
        private IdFunctionObject constructor;
        private short constructorAttrs;
        int constructorId;
        private int maxId;
        private IdScriptableObject obj;
        private Object[] valueArray;

        PrototypeValues(IdScriptableObject idScriptableObject, int n) {
            if (idScriptableObject != null) {
                if (n >= 1) {
                    this.obj = idScriptableObject;
                    this.maxId = n;
                    return;
                }
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Object ensureId(int n) {
            int n2;
            Object object = this.valueArray;
            Object object2 = object;
            if (object == null) {
                synchronized (this) {
                    object = this.valueArray;
                    object2 = object;
                    if (object == null) {
                        n2 = this.maxId;
                        object2 = new Object[n2 * 2];
                        this.valueArray = object2;
                        this.attributeArray = new short[n2];
                    }
                }
            }
            n2 = (n - 1) * 2;
            Object object3 = object2[n2];
            object = object3;
            if (object3 != null) return object;
            int n3 = this.constructorId;
            if (n == n3) {
                this.initSlot(n3, "constructor", this.constructor, this.constructorAttrs);
                this.constructor = null;
            } else {
                this.obj.initPrototypeId(n);
            }
            object = object2[n2];
            if (object != null) {
                return object;
            }
            object2 = new StringBuilder();
            ((StringBuilder)object2).append(this.obj.getClass().getName());
            ((StringBuilder)object2).append(".initPrototypeId(int id) did not initialize id=");
            ((StringBuilder)object2).append(n);
            throw new IllegalStateException(((StringBuilder)object2).toString());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void initSlot(int n, String object, Object object2, int n2) {
            Object[] objectArray = this.valueArray;
            if (objectArray == null) {
                throw new IllegalStateException();
            }
            Object object3 = object2;
            if (object2 == null) {
                object3 = UniqueTag.NULL_VALUE;
            }
            int n3 = --n * 2;
            synchronized (this) {
                if (objectArray[n3] == null) {
                    objectArray[n3] = object3;
                    objectArray[n3 + 1] = object;
                    this.attributeArray[n] = (short)n2;
                } else if (!((String)object).equals(objectArray[n3 + 1])) {
                    object = new IllegalStateException();
                    throw object;
                }
                return;
            }
        }

        final IdFunctionObject createPrecachedConstructor() {
            if (this.constructorId == 0) {
                int n;
                this.constructorId = n = this.obj.findPrototypeId("constructor");
                if (n != 0) {
                    this.obj.initPrototypeId(n);
                    Serializable serializable = this.constructor;
                    if (serializable != null) {
                        ((IdFunctionObject)serializable).initFunction(this.obj.getClassName(), ScriptableObject.getTopLevelScope(this.obj));
                        this.constructor.markAsConstructor(this.obj);
                        return this.constructor;
                    }
                    serializable = new StringBuilder();
                    ((StringBuilder)serializable).append(this.obj.getClass().getName());
                    ((StringBuilder)serializable).append(".initPrototypeId() did not initialize id=");
                    ((StringBuilder)serializable).append(this.constructorId);
                    throw new IllegalStateException(((StringBuilder)serializable).toString());
                }
                throw new IllegalStateException("No id for constructor property");
            }
            throw new IllegalStateException();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        final void delete(int n) {
            this.ensureId(n);
            short[] sArray = this.attributeArray;
            if ((sArray[--n] & 4) != 0) {
                if (Context.getContext().isStrictMode()) throw ScriptRuntime.typeError1("msg.delete.property.with.configurable.false", (String)this.valueArray[n * 2 + 1]);
                return;
            }
            synchronized (this) {
                this.valueArray[n * 2] = Scriptable.NOT_FOUND;
                this.attributeArray[n] = (short)0;
                return;
            }
        }

        final int findId(String string2) {
            return this.obj.findPrototypeId(string2);
        }

        final int findId(Symbol symbol) {
            return this.obj.findPrototypeId(symbol);
        }

        final Object get(int n) {
            Object object;
            Object object2 = object = this.ensureId(n);
            if (object == UniqueTag.NULL_VALUE) {
                object2 = null;
            }
            return object2;
        }

        final int getAttributes(int n) {
            this.ensureId(n);
            return this.attributeArray[n - 1];
        }

        final int getMaxId() {
            return this.maxId;
        }

        final Object[] getNames(boolean bl, Object[] objectArray) {
            int n;
            Object[] objectArray2;
            Object[] objectArray3 = null;
            int n2 = 0;
            for (int i = 1; i <= this.maxId; ++i) {
                block10: {
                    Object object;
                    block9: {
                        object = this.ensureId(i);
                        if (bl) break block9;
                        objectArray2 = objectArray3;
                        n = n2;
                        if ((this.attributeArray[i - 1] & 2) != 0) break block10;
                    }
                    objectArray2 = objectArray3;
                    n = n2;
                    if (object != Scriptable.NOT_FOUND) {
                        object = (String)this.valueArray[(i - 1) * 2 + 1];
                        objectArray2 = objectArray3;
                        if (objectArray3 == null) {
                            objectArray2 = new Object[this.maxId];
                        }
                        objectArray2[n2] = object;
                        n = n2 + 1;
                    }
                }
                objectArray3 = objectArray2;
                n2 = n;
            }
            if (n2 == 0) {
                return objectArray;
            }
            if (objectArray != null && objectArray.length != 0) {
                n = objectArray.length;
                objectArray2 = new Object[n + n2];
                System.arraycopy(objectArray, 0, objectArray2, 0, n);
                System.arraycopy(objectArray3, 0, objectArray2, n, n2);
                return objectArray2;
            }
            objectArray = objectArray3;
            if (n2 != objectArray3.length) {
                objectArray = new Object[n2];
                System.arraycopy(objectArray3, 0, objectArray, 0, n2);
            }
            return objectArray;
        }

        final boolean has(int n) {
            Object object = this.valueArray;
            boolean bl = true;
            if (object == null) {
                return true;
            }
            if ((object = object[(n - 1) * 2]) == null) {
                return true;
            }
            if (object == Scriptable.NOT_FOUND) {
                bl = false;
            }
            return bl;
        }

        final void initValue(int n, String string2, Object object, int n2) {
            if (1 <= n && n <= this.maxId) {
                if (string2 != null) {
                    if (object != Scriptable.NOT_FOUND) {
                        ScriptableObject.checkValidAttributes(n2);
                        if (this.obj.findPrototypeId(string2) == n) {
                            if (n == this.constructorId) {
                                if (object instanceof IdFunctionObject) {
                                    this.constructor = (IdFunctionObject)object;
                                    this.constructorAttrs = (short)n2;
                                    return;
                                }
                                throw new IllegalArgumentException("consructor should be initialized with IdFunctionObject");
                            }
                            this.initSlot(n, string2, object, n2);
                            return;
                        }
                        throw new IllegalArgumentException(string2);
                    }
                    throw new IllegalArgumentException();
                }
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException();
        }

        final void initValue(int n, Symbol symbol, Object object, int n2) {
            if (1 <= n && n <= this.maxId) {
                if (symbol != null) {
                    if (object != Scriptable.NOT_FOUND) {
                        ScriptableObject.checkValidAttributes(n2);
                        if (this.obj.findPrototypeId(symbol) == n) {
                            if (n == this.constructorId) {
                                if (object instanceof IdFunctionObject) {
                                    this.constructor = (IdFunctionObject)object;
                                    this.constructorAttrs = (short)n2;
                                    return;
                                }
                                throw new IllegalArgumentException("consructor should be initialized with IdFunctionObject");
                            }
                            this.initSlot(n, "", object, n2);
                            return;
                        }
                        throw new IllegalArgumentException(symbol.toString());
                    }
                    throw new IllegalArgumentException();
                }
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        final void set(int n, Scriptable object, Object object2) {
            if (object2 == Scriptable.NOT_FOUND) throw new IllegalArgumentException();
            this.ensureId(n);
            short[] sArray = this.attributeArray;
            if ((sArray[--n] & 1) != 0) return;
            if (object != this.obj) {
                object.put((String)this.valueArray[n * 2 + 1], (Scriptable)object, object2);
                return;
            }
            object = object2;
            if (object2 == null) {
                object = UniqueTag.NULL_VALUE;
            }
            synchronized (this) {
                this.valueArray[n * 2] = object;
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        final void setAttributes(int n, int n2) {
            ScriptableObject.checkValidAttributes(n2);
            this.ensureId(n);
            synchronized (this) {
                this.attributeArray[n - 1] = (short)n2;
                return;
            }
        }
    }
}

