/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaPackage;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;

public class ImporterTopLevel
extends TopLevel {
    private static final Object IMPORTER_TAG = "Importer";
    private static final int Id_constructor = 1;
    private static final int Id_importClass = 2;
    private static final int Id_importPackage = 3;
    private static final int MAX_PROTOTYPE_ID = 3;
    static final long serialVersionUID = -9095380847465315412L;
    private ObjArray importedPackages = new ObjArray();
    private boolean topScopeFlag;

    public ImporterTopLevel() {
    }

    public ImporterTopLevel(Context context) {
        this(context, false);
    }

    public ImporterTopLevel(Context context, boolean bl) {
        this.initStandardObjects(context, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getPackageProperty(String string2, Scriptable scriptable) {
        Object[] objectArray;
        Object object = NOT_FOUND;
        Object object2 = this.importedPackages;
        synchronized (object2) {
            objectArray = this.importedPackages.toArray();
        }
        int n = 0;
        while (n < objectArray.length) {
            Object object3 = ((NativeJavaPackage)objectArray[n]).getPkgProperty(string2, scriptable, false);
            object2 = object;
            if (object3 != null) {
                object2 = object;
                if (!(object3 instanceof NativeJavaPackage)) {
                    if (object != NOT_FOUND) {
                        throw Context.reportRuntimeError2("msg.ambig.import", object.toString(), object3.toString());
                    }
                    object2 = object3;
                }
            }
            ++n;
            object = object2;
        }
        return object;
    }

    private void importClass(NativeJavaClass nativeJavaClass) {
        Object object = nativeJavaClass.getClassObject().getName();
        String string2 = ((String)object).substring(((String)object).lastIndexOf(46) + 1);
        if ((object = this.get(string2, (Scriptable)this)) != NOT_FOUND && object != nativeJavaClass) {
            throw Context.reportRuntimeError1("msg.prop.defined", string2);
        }
        this.put(string2, (Scriptable)this, (Object)nativeJavaClass);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void importPackage(NativeJavaPackage nativeJavaPackage) {
        if (nativeJavaPackage == null) {
            return;
        }
        ObjArray objArray = this.importedPackages;
        synchronized (objArray) {
            int n = 0;
            while (true) {
                if (n == this.importedPackages.size()) {
                    this.importedPackages.add(nativeJavaPackage);
                    return;
                }
                if (nativeJavaPackage.equals(this.importedPackages.get(n))) {
                    return;
                }
                ++n;
            }
        }
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        new ImporterTopLevel().exportAsJSClass(3, scriptable, bl);
    }

    private Object js_construct(Scriptable scriptable, Object[] objectArray) {
        ImporterTopLevel importerTopLevel = new ImporterTopLevel();
        for (int i = 0; i != objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof NativeJavaClass) {
                importerTopLevel.importClass((NativeJavaClass)object);
                continue;
            }
            if (object instanceof NativeJavaPackage) {
                importerTopLevel.importPackage((NativeJavaPackage)object);
                continue;
            }
            throw Context.reportRuntimeError1("msg.not.class.not.pkg", Context.toString(object));
        }
        importerTopLevel.setParentScope(scriptable);
        importerTopLevel.setPrototype(this);
        return importerTopLevel;
    }

    private Object js_importClass(Object[] objectArray) {
        for (int i = 0; i != objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof NativeJavaClass) {
                this.importClass((NativeJavaClass)object);
                continue;
            }
            throw Context.reportRuntimeError1("msg.not.class", Context.toString(object));
        }
        return Undefined.instance;
    }

    private Object js_importPackage(Object[] objectArray) {
        for (int i = 0; i != objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof NativeJavaPackage) {
                this.importPackage((NativeJavaPackage)object);
                continue;
            }
            throw Context.reportRuntimeError1("msg.not.pkg", Context.toString(object));
        }
        return Undefined.instance;
    }

    private ImporterTopLevel realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        if (this.topScopeFlag) {
            return this;
        }
        if (scriptable instanceof ImporterTopLevel) {
            return (ImporterTopLevel)scriptable;
        }
        throw ImporterTopLevel.incompatibleCallError(idFunctionObject);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(IMPORTER_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        if (n != 1) {
            if (n != 2) {
                if (n == 3) {
                    return this.realThis(scriptable2, idFunctionObject).js_importPackage(objectArray);
                }
                throw new IllegalArgumentException(String.valueOf(n));
            }
            return this.realThis(scriptable2, idFunctionObject).js_importClass(objectArray);
        }
        return this.js_construct(scriptable, objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int findPrototypeId(String string2) {
        String string3;
        int n = string2.length();
        int n2 = 0;
        if (n == 11) {
            n = string2.charAt(0);
            if (n == 99) {
                n = 1;
                string3 = "constructor";
            } else {
                if (n != 105) return 0;
                n = 2;
                string3 = "importClass";
            }
        } else {
            if (n != 13) return 0;
            n = 3;
            string3 = "importPackage";
        }
        if (string3 == null) return n;
        if (string3 == string2) return n;
        if (string3.equals(string2)) return n;
        return n2;
    }

    @Override
    public Object get(String string2, Scriptable scriptable) {
        Object object = super.get(string2, scriptable);
        if (object != NOT_FOUND) {
            return object;
        }
        return this.getPackageProperty(string2, scriptable);
    }

    @Override
    public String getClassName() {
        String string2 = this.topScopeFlag ? "global" : "JavaImporter";
        return string2;
    }

    @Override
    public boolean has(String string2, Scriptable scriptable) {
        boolean bl = super.has(string2, scriptable) || this.getPackageProperty(string2, scriptable) != NOT_FOUND;
        return bl;
    }

    @Deprecated
    public void importPackage(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        this.js_importPackage(objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void initPrototypeId(int n) {
        String string2;
        int n2 = 1;
        if (n != 1) {
            if (n != 2) {
                if (n != 3) throw new IllegalArgumentException(String.valueOf(n));
                string2 = "importPackage";
            } else {
                string2 = "importClass";
            }
        } else {
            n2 = 0;
            string2 = "constructor";
        }
        this.initPrototypeMethod(IMPORTER_TAG, n, string2, n2);
    }

    public void initStandardObjects(Context object, boolean bl) {
        ((Context)object).initStandardObjects(this, bl);
        this.topScopeFlag = true;
        object = this.exportAsJSClass(3, this, false);
        if (bl) {
            ((ScriptableObject)object).sealObject();
        }
        this.delete("constructor");
    }
}

