/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Method;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.VMBridge;
import org.mozilla.javascript.WrapFactory;

public class InterfaceAdapter {
    private final Object proxyHelper;

    private InterfaceAdapter(ContextFactory contextFactory, Class<?> clazz) {
        this.proxyHelper = VMBridge.instance.getInterfaceProxyHelper(contextFactory, new Class[]{clazz});
    }

    static Object create(Context object, Class<?> clazz, ScriptableObject scriptableObject) {
        if (clazz.isInterface()) {
            Scriptable scriptable = ScriptRuntime.getTopCallScope((Context)object);
            ClassCache classCache = ClassCache.get(scriptable);
            Method[] methodArray = (Method[])classCache.getInterfaceAdapter(clazz);
            ContextFactory contextFactory = ((Context)object).getFactory();
            if (methodArray == null) {
                methodArray = clazz.getMethods();
                if (scriptableObject instanceof Callable) {
                    int n = methodArray.length;
                    if (n != 0) {
                        if (n > 1) {
                            object = methodArray[0].getName();
                            for (int i = 1; i < n; ++i) {
                                if (((String)object).equals(methodArray[i].getName())) {
                                    continue;
                                }
                                throw Context.reportRuntimeError1("msg.no.function.interface.conversion", clazz.getName());
                            }
                        }
                    } else {
                        throw Context.reportRuntimeError1("msg.no.empty.interface.conversion", clazz.getName());
                    }
                }
                object = new InterfaceAdapter(contextFactory, clazz);
                classCache.cacheInterfaceAdapter(clazz, object);
            } else {
                object = methodArray;
            }
            return VMBridge.instance.newInterfaceProxy(((InterfaceAdapter)object).proxyHelper, contextFactory, (InterfaceAdapter)object, scriptableObject, scriptable);
        }
        throw new IllegalArgumentException();
    }

    public Object invoke(ContextFactory contextFactory, final Object object, final Scriptable scriptable, final Object object2, final Method method, final Object[] objectArray) {
        return contextFactory.call(new ContextAction(){

            @Override
            public Object run(Context context) {
                return InterfaceAdapter.this.invokeImpl(context, object, scriptable, object2, method, objectArray);
            }
        });
    }

    Object invokeImpl(Context object, Object object2, Scriptable scriptable, Object object3, Method method, Object[] objectArray) {
        block11: {
            Object object4;
            Object var8_8;
            block10: {
                block9: {
                    boolean bl = object2 instanceof Callable;
                    var8_8 = null;
                    if (!bl) break block9;
                    object2 = (Callable)object2;
                    break block10;
                }
                object4 = (Scriptable)object2;
                object2 = method.getName();
                if ((object4 = ScriptableObject.getProperty((Scriptable)object4, (String)object2)) == ScriptableObject.NOT_FOUND) {
                    Context.reportWarning(ScriptRuntime.getMessage1("msg.undefined.function.interface", object2));
                    object = method.getReturnType();
                    if (object == Void.TYPE) {
                        return null;
                    }
                    return Context.jsToJava(null, object);
                }
                if (!(object4 instanceof Callable)) break block11;
                object2 = (Callable)object4;
            }
            WrapFactory wrapFactory = ((Context)object).getWrapFactory();
            if (objectArray == null) {
                object4 = ScriptRuntime.emptyArgs;
            } else {
                int n = 0;
                int n2 = objectArray.length;
                while (true) {
                    object4 = objectArray;
                    if (n == n2) break;
                    object4 = objectArray[n];
                    if (!(object4 instanceof String || object4 instanceof Number || object4 instanceof Boolean)) {
                        objectArray[n] = wrapFactory.wrap((Context)object, scriptable, object4, null);
                    }
                    ++n;
                }
            }
            object = object2.call((Context)object, scriptable, wrapFactory.wrapAsJavaObject((Context)object, scriptable, object3, null), (Object[])object4);
            object2 = method.getReturnType();
            object = object2 == Void.TYPE ? var8_8 : Context.jsToJava(object, object2);
            return object;
        }
        throw Context.reportRuntimeError1("msg.not.function.interface", object2);
    }
}

