/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.CodeGenerator;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.ConstProperties;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Evaluator;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Icode;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeContinuation;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeWith;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ScriptStackElement;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SecurityUtilities;
import org.mozilla.javascript.UintMap;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UniqueTag;
import org.mozilla.javascript.ast.ScriptNode;
import org.mozilla.javascript.debug.DebugFrame;

public final class Interpreter
extends Icode
implements Evaluator {
    static final int EXCEPTION_HANDLER_SLOT = 2;
    static final int EXCEPTION_LOCAL_SLOT = 4;
    static final int EXCEPTION_SCOPE_SLOT = 5;
    static final int EXCEPTION_SLOT_SIZE = 6;
    static final int EXCEPTION_TRY_END_SLOT = 1;
    static final int EXCEPTION_TRY_START_SLOT = 0;
    static final int EXCEPTION_TYPE_SLOT = 3;
    InterpreterData itsData;

    private static void addInstructionCount(Context context, CallFrame callFrame, int n) {
        context.instructionCount += callFrame.pc - callFrame.pcPrevBranch + n;
        if (context.instructionCount > context.instructionThreshold) {
            context.observeInstructionCount(context.instructionCount);
            context.instructionCount = 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int bytecodeSpan(int n) {
        if (n == -54 || n == -23) return 3;
        if (n == -21) return 5;
        if (n == 50) return 3;
        if (n == 57) return 2;
        if (n == 73) return 3;
        if (n == 5 || n == 6 || n == 7) return 3;
        switch (n) {
            default: {
                switch (n) {
                    default: {
                        switch (n) {
                            default: {
                                switch (n) {
                                    default: {
                                        switch (n) {
                                            default: {
                                                if (!Interpreter.validBytecode(n)) throw Kit.codeBug();
                                                return 1;
                                            }
                                            case -11: 
                                            case -10: 
                                            case -9: 
                                            case -8: 
                                            case -7: {
                                                return 2;
                                            }
                                            case -6: {
                                                return 3;
                                            }
                                        }
                                    }
                                    case -27: 
                                    case -26: {
                                        return 3;
                                    }
                                    case -28: 
                                }
                                return 5;
                            }
                            case -38: {
                                return 2;
                            }
                            case -39: {
                                return 3;
                            }
                            case -40: 
                        }
                        return 5;
                    }
                    case -45: {
                        return 2;
                    }
                    case -46: {
                        return 3;
                    }
                    case -47: {
                        return 5;
                    }
                    case -49: 
                    case -48: 
                }
            }
            case -61: {
                return 2;
            }
            case -63: 
            case -62: 
        }
        return 3;
    }

    public static NativeContinuation captureContinuation(Context context) {
        if (context.lastInterpreterFrame != null && context.lastInterpreterFrame instanceof CallFrame) {
            return Interpreter.captureContinuation(context, (CallFrame)context.lastInterpreterFrame, true);
        }
        throw new IllegalStateException("Interpreter frames not found");
    }

    private static NativeContinuation captureContinuation(Context object, CallFrame callFrame, boolean bl) {
        NativeContinuation nativeContinuation = new NativeContinuation();
        ScriptRuntime.setObjectProtoAndParent(nativeContinuation, ScriptRuntime.getTopCallScope((Context)object));
        Object object2 = object = callFrame;
        while (object != null && !((CallFrame)object).frozen) {
            ((CallFrame)object).frozen = true;
            for (int i = ((CallFrame)object).savedStackTop + 1; i != ((CallFrame)object).stack.length; ++i) {
                ((CallFrame)object).stack[i] = null;
                ((CallFrame)object).stackAttributes[i] = 0;
            }
            if (((CallFrame)object).savedCallOp == 38) {
                ((CallFrame)object).stack[((CallFrame)object).savedStackTop] = null;
            } else if (((CallFrame)object).savedCallOp != 30) {
                Kit.codeBug();
            }
            CallFrame callFrame2 = ((CallFrame)object).parentFrame;
            object2 = object;
            object = callFrame2;
        }
        if (bl) {
            while (((CallFrame)object2).parentFrame != null) {
                object2 = ((CallFrame)object2).parentFrame;
            }
            if (!((CallFrame)object2).isContinuationsTopFrame) {
                throw new IllegalStateException("Cannot capture continuation from JavaScript code not called directly by executeScriptWithContinuations or callFunctionWithContinuations");
            }
        }
        nativeContinuation.initImplementation(callFrame);
        return nativeContinuation;
    }

    private static CallFrame captureFrameForGenerator(CallFrame callFrame) {
        callFrame.frozen = true;
        CallFrame callFrame2 = callFrame.cloneFrozen();
        callFrame.frozen = false;
        callFrame2.parentFrame = null;
        callFrame2.frameIndex = 0;
        return callFrame2;
    }

    private static void doAdd(Object[] objectArray, double[] object, int n, Context object2) {
        Object object3;
        Object object4;
        block15: {
            double d;
            int n2;
            block14: {
                block13: {
                    n2 = n + 1;
                    object4 = objectArray[n2];
                    object3 = objectArray[n];
                    if (object4 != UniqueTag.DOUBLE_MARK) break block13;
                    d = object[n2];
                    if (object3 == UniqueTag.DOUBLE_MARK) {
                        object[n] = object[n] + d;
                        return;
                    }
                    n2 = 1;
                    break block14;
                }
                if (object3 != UniqueTag.DOUBLE_MARK) break block15;
                d = object[n];
                object3 = object4;
                n2 = 0;
            }
            if (object3 instanceof Scriptable) {
                Number number = ScriptRuntime.wrapNumber(d);
                object4 = object3;
                object = number;
                if (n2 == 0) {
                    object4 = number;
                    object = object3;
                }
                objectArray[n] = ScriptRuntime.add(object4, object, (Context)object2);
            } else if (object3 instanceof CharSequence) {
                object = (CharSequence)object3;
                object2 = ScriptRuntime.toCharSequence(d);
                objectArray[n] = n2 != 0 ? new ConsString((CharSequence)object, (CharSequence)object2) : new ConsString((CharSequence)object2, (CharSequence)object);
            } else {
                double d2 = object3 instanceof Number ? ((Number)object3).doubleValue() : ScriptRuntime.toNumber(object3);
                objectArray[n] = UniqueTag.DOUBLE_MARK;
                object[n] = d2 + d;
            }
            return;
        }
        if (!(object3 instanceof Scriptable) && !(object4 instanceof Scriptable)) {
            if (!(object3 instanceof CharSequence) && !(object4 instanceof CharSequence)) {
                double d = object3 instanceof Number ? ((Number)object3).doubleValue() : ScriptRuntime.toNumber(object3);
                double d3 = object4 instanceof Number ? ((Number)object4).doubleValue() : ScriptRuntime.toNumber(object4);
                objectArray[n] = UniqueTag.DOUBLE_MARK;
                object[n] = d + d3;
            } else {
                objectArray[n] = new ConsString(ScriptRuntime.toCharSequence(object3), ScriptRuntime.toCharSequence(object4));
            }
        } else {
            objectArray[n] = ScriptRuntime.add(object3, object4, (Context)object2);
        }
    }

    private static int doArithmetic(CallFrame callFrame, int n, Object[] objectArray, double[] dArray, int n2) {
        double d = Interpreter.stack_double(callFrame, n2);
        double d2 = Interpreter.stack_double(callFrame, --n2);
        objectArray[n2] = UniqueTag.DOUBLE_MARK;
        switch (n) {
            default: {
                break;
            }
            case 25: {
                d2 %= d;
                break;
            }
            case 24: {
                d2 /= d;
                break;
            }
            case 23: {
                d2 *= d;
                break;
            }
            case 22: {
                d2 -= d;
            }
        }
        dArray[n2] = d2;
        return n2;
    }

    private static int doBitOp(CallFrame callFrame, int n, Object[] objectArray, double[] dArray, int n2) {
        int n3 = Interpreter.stack_int32(callFrame, n2 - 1);
        int n4 = Interpreter.stack_int32(callFrame, n2);
        objectArray[--n2] = UniqueTag.DOUBLE_MARK;
        if (n != 18) {
            if (n != 19) {
                switch (n) {
                    default: {
                        n = n3;
                        break;
                    }
                    case 11: {
                        n = n3 & n4;
                        break;
                    }
                    case 10: {
                        n = n3 ^ n4;
                        break;
                    }
                    case 9: {
                        n = n3 | n4;
                        break;
                    }
                }
            } else {
                n = n3 >> n4;
            }
        } else {
            n = n3 << n4;
        }
        dArray[n2] = n;
        return n2;
    }

    private static int doCallSpecial(Context context, CallFrame callFrame, Object[] objectArray, double[] dArray, int n, byte[] object, int n2) {
        int n3 = object[callFrame.pc] & 0xFF;
        int n4 = callFrame.pc;
        boolean bl = true;
        if (object[n4 + 1] == 0) {
            bl = false;
        }
        n4 = Interpreter.getIndex(object, callFrame.pc + 2);
        if (bl) {
            Object object2 = objectArray[n -= n2];
            object = object2;
            if (object2 == UniqueTag.DOUBLE_MARK) {
                object = ScriptRuntime.wrapNumber(dArray[n]);
            }
            objectArray[n] = ScriptRuntime.newSpecial(context, object, Interpreter.getArgsArray(objectArray, dArray, n + 1, n2), callFrame.scope, n3);
        } else {
            object = (Scriptable)objectArray[(n -= n2 + 1) + 1];
            objectArray[n] = ScriptRuntime.callSpecial(context, (Callable)objectArray[n], (Scriptable)object, Interpreter.getArgsArray(objectArray, dArray, n + 2, n2), callFrame.scope, callFrame.thisObj, n3, callFrame.idata.itsSourceFile, n4);
        }
        callFrame.pc += 4;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int doCompare(CallFrame callFrame, int n, Object[] objectArray, double[] dArray, int n2) {
        boolean bl;
        int n3;
        block19: {
            Object object;
            Object object2;
            block18: {
                double d;
                double d2;
                block17: {
                    block16: {
                        n3 = n2 - 1;
                        n2 = n3 + 1;
                        object2 = objectArray[n2];
                        object = objectArray[n3];
                        if (object2 != UniqueTag.DOUBLE_MARK) break block16;
                        d2 = dArray[n2];
                        d = Interpreter.stack_double(callFrame, n3);
                        break block17;
                    }
                    if (object != UniqueTag.DOUBLE_MARK) break block18;
                    d2 = ScriptRuntime.toNumber(object2);
                    d = dArray[n3];
                }
                bl = false;
                switch (n) {
                    default: {
                        throw Kit.codeBug();
                    }
                    case 17: {
                        if (d >= d2) {
                            break;
                        }
                        break block19;
                    }
                    case 16: {
                        if (d > d2) {
                            break;
                        }
                        break block19;
                    }
                    case 15: {
                        if (d <= d2) {
                            break;
                        }
                        break block19;
                    }
                    case 14: {
                        if (d < d2) {
                            break;
                        }
                        break block19;
                    }
                }
                bl = true;
                break block19;
            }
            switch (n) {
                default: {
                    throw Kit.codeBug();
                }
                case 17: {
                    bl = ScriptRuntime.cmp_LE(object2, object);
                    break;
                }
                case 16: {
                    bl = ScriptRuntime.cmp_LT(object2, object);
                    break;
                }
                case 15: {
                    bl = ScriptRuntime.cmp_LE(object, object2);
                    break;
                }
                case 14: {
                    bl = ScriptRuntime.cmp_LT(object, object2);
                }
            }
        }
        objectArray[n3] = ScriptRuntime.wrapBoolean(bl);
        return n3;
    }

    private static int doDelName(Context context, CallFrame object, int n, Object[] objectArray, double[] dArray, int n2) {
        Object object2;
        Object object3;
        Object object4 = object3 = objectArray[n2];
        if (object3 == UniqueTag.DOUBLE_MARK) {
            object4 = ScriptRuntime.wrapNumber(dArray[n2]);
        }
        object3 = object2 = objectArray[--n2];
        if (object2 == UniqueTag.DOUBLE_MARK) {
            object3 = ScriptRuntime.wrapNumber(dArray[n2]);
        }
        object = ((CallFrame)object).scope;
        boolean bl = n == 0;
        objectArray[n2] = ScriptRuntime.delete(object3, object4, context, (Scriptable)object, bl);
        return n2;
    }

    private static int doElemIncDec(Context context, CallFrame callFrame, byte[] byArray, Object[] objectArray, double[] dArray, int n) {
        Object object;
        Object object2;
        Object object3 = object2 = objectArray[n];
        if (object2 == UniqueTag.DOUBLE_MARK) {
            object3 = ScriptRuntime.wrapNumber(dArray[n]);
        }
        object2 = object = objectArray[--n];
        if (object == UniqueTag.DOUBLE_MARK) {
            object2 = ScriptRuntime.wrapNumber(dArray[n]);
        }
        objectArray[n] = ScriptRuntime.elemIncrDecr(object2, object3, context, callFrame.scope, byArray[callFrame.pc]);
        ++callFrame.pc;
        return n;
    }

    private static boolean doEquals(Object[] object, double[] dArray, int n) {
        int n2 = n + 1;
        Object object2 = object[n2];
        object = object[n];
        if (object2 == UniqueTag.DOUBLE_MARK) {
            if (object == UniqueTag.DOUBLE_MARK) {
                boolean bl = dArray[n] == dArray[n2];
                return bl;
            }
            return ScriptRuntime.eqNumber(dArray[n2], object);
        }
        if (object == UniqueTag.DOUBLE_MARK) {
            return ScriptRuntime.eqNumber(dArray[n], object2);
        }
        return ScriptRuntime.eq(object, object2);
    }

    private static int doGetElem(Context object, CallFrame callFrame, Object[] objectArray, double[] dArray, int n) {
        int n2;
        Object object2;
        Object object3 = object2 = objectArray[--n];
        if (object2 == UniqueTag.DOUBLE_MARK) {
            object3 = ScriptRuntime.wrapNumber(dArray[n]);
        }
        object = (object2 = objectArray[n2 = n + 1]) != UniqueTag.DOUBLE_MARK ? ScriptRuntime.getObjectElem(object3, object2, (Context)object, callFrame.scope) : ScriptRuntime.getObjectIndex(object3, dArray[n2], (Context)object, callFrame.scope);
        objectArray[n] = object;
        return n;
    }

    private static int doGetVar(CallFrame callFrame, Object[] objectArray, double[] object, int n, Object[] objectArray2, double[] dArray, int n2) {
        ++n;
        if (!callFrame.useActivation) {
            objectArray[n] = objectArray2[n2];
            object[n] = dArray[n2];
        } else {
            object = callFrame.idata.argNames[n2];
            objectArray[n] = callFrame.scope.get((String)object, callFrame.scope);
        }
        return n;
    }

    private static int doInOrInstanceof(Context context, int n, Object[] objectArray, double[] dArray, int n2) {
        Object object;
        Object object2;
        Object object3 = object2 = objectArray[n2];
        if (object2 == UniqueTag.DOUBLE_MARK) {
            object3 = ScriptRuntime.wrapNumber(dArray[n2]);
        }
        object2 = object = objectArray[--n2];
        if (object == UniqueTag.DOUBLE_MARK) {
            object2 = ScriptRuntime.wrapNumber(dArray[n2]);
        }
        boolean bl = n == 52 ? ScriptRuntime.in(object2, object3, context) : ScriptRuntime.instanceOf(object2, object3, context);
        objectArray[n2] = ScriptRuntime.wrapBoolean(bl);
        return n2;
    }

    private static int doRefMember(Context context, Object[] objectArray, double[] dArray, int n, int n2) {
        Object object;
        Object object2;
        Object object3 = object2 = objectArray[n];
        if (object2 == UniqueTag.DOUBLE_MARK) {
            object3 = ScriptRuntime.wrapNumber(dArray[n]);
        }
        object2 = object = objectArray[--n];
        if (object == UniqueTag.DOUBLE_MARK) {
            object2 = ScriptRuntime.wrapNumber(dArray[n]);
        }
        objectArray[n] = ScriptRuntime.memberRef(object2, object3, context, n2);
        return n;
    }

    private static int doRefNsMember(Context context, Object[] objectArray, double[] dArray, int n, int n2) {
        Object object;
        Object object2;
        Object object3;
        Object object4 = object3 = objectArray[n];
        if (object3 == UniqueTag.DOUBLE_MARK) {
            object4 = ScriptRuntime.wrapNumber(dArray[n]);
        }
        object3 = object2 = objectArray[--n];
        if (object2 == UniqueTag.DOUBLE_MARK) {
            object3 = ScriptRuntime.wrapNumber(dArray[n]);
        }
        object2 = object = objectArray[--n];
        if (object == UniqueTag.DOUBLE_MARK) {
            object2 = ScriptRuntime.wrapNumber(dArray[n]);
        }
        objectArray[n] = ScriptRuntime.memberRef(object2, object3, object4, context, n2);
        return n;
    }

    private static int doRefNsName(Context context, CallFrame callFrame, Object[] objectArray, double[] dArray, int n, int n2) {
        Object object;
        Object object2;
        Object object3 = object2 = objectArray[n];
        if (object2 == UniqueTag.DOUBLE_MARK) {
            object3 = ScriptRuntime.wrapNumber(dArray[n]);
        }
        object2 = object = objectArray[--n];
        if (object == UniqueTag.DOUBLE_MARK) {
            object2 = ScriptRuntime.wrapNumber(dArray[n]);
        }
        objectArray[n] = ScriptRuntime.nameRef(object2, object3, context, callFrame.scope, n2);
        return n;
    }

    private static int doSetConstVar(CallFrame callFrame, Object[] object, double[] object2, int n, Object[] object3, double[] dArray, int[] nArray, int n2) {
        block9: {
            block8: {
                block6: {
                    block7: {
                        if (callFrame.useActivation) break block6;
                        if ((nArray[n2] & 1) == 0) break block7;
                        if ((nArray[n2] & 8) != 0) {
                            object3[n2] = object[n];
                            nArray[n2] = nArray[n2] & 0xFFFFFFF7;
                            dArray[n2] = object2[n];
                        }
                        break block8;
                    }
                    throw Context.reportRuntimeError1("msg.var.redecl", callFrame.idata.argNames[n2]);
                }
                object3 = object[n];
                object = object3;
                if (object3 == UniqueTag.DOUBLE_MARK) {
                    object = ScriptRuntime.wrapNumber(object2[n]);
                }
                object2 = callFrame.idata.argNames[n2];
                if (!(callFrame.scope instanceof ConstProperties)) break block9;
                ((ConstProperties)((Object)callFrame.scope)).putConst((String)object2, callFrame.scope, object);
            }
            return n;
        }
        throw Kit.codeBug();
    }

    private static int doSetElem(Context object, CallFrame callFrame, Object[] objectArray, double[] dArray, int n) {
        Object object2;
        Object object3;
        int n2 = (n -= 2) + 2;
        Object object4 = object3 = objectArray[n2];
        if (object3 == UniqueTag.DOUBLE_MARK) {
            object4 = ScriptRuntime.wrapNumber(dArray[n2]);
        }
        object3 = object2 = objectArray[n];
        if (object2 == UniqueTag.DOUBLE_MARK) {
            object3 = ScriptRuntime.wrapNumber(dArray[n]);
        }
        object = (object2 = objectArray[n2 = n + 1]) != UniqueTag.DOUBLE_MARK ? ScriptRuntime.setObjectElem(object3, object2, object4, (Context)object, callFrame.scope) : ScriptRuntime.setObjectIndex(object3, dArray[n2], object4, (Context)object, callFrame.scope);
        objectArray[n] = object;
        return n;
    }

    private static int doSetVar(CallFrame callFrame, Object[] object, double[] object2, int n, Object[] object3, double[] dArray, int[] nArray, int n2) {
        if (!callFrame.useActivation) {
            if ((nArray[n2] & 1) == 0) {
                object3[n2] = object[n];
                dArray[n2] = object2[n];
            }
        } else {
            object3 = object[n];
            object = object3;
            if (object3 == UniqueTag.DOUBLE_MARK) {
                object = ScriptRuntime.wrapNumber(object2[n]);
            }
            object2 = callFrame.idata.argNames[n2];
            callFrame.scope.put((String)object2, callFrame.scope, object);
        }
        return n;
    }

    private static boolean doShallowEquals(Object[] object, double[] dArray, int n) {
        Object object2;
        block8: {
            boolean bl;
            block9: {
                double d;
                double d2;
                boolean bl2;
                block6: {
                    UniqueTag uniqueTag;
                    block4: {
                        block7: {
                            block5: {
                                int n2 = n + 1;
                                object2 = object[n2];
                                object = object[n];
                                uniqueTag = UniqueTag.DOUBLE_MARK;
                                bl2 = false;
                                if (object2 != uniqueTag) break block4;
                                d2 = dArray[n2];
                                if (object != uniqueTag) break block5;
                                d = dArray[n];
                                break block6;
                            }
                            if (!(object instanceof Number)) break block7;
                            d = ((Number)object).doubleValue();
                            break block6;
                        }
                        return false;
                    }
                    if (object != uniqueTag) break block8;
                    d = dArray[n];
                    bl = bl2;
                    if (!(object2 instanceof Number)) break block9;
                    d2 = ((Number)object2).doubleValue();
                }
                bl = bl2;
                if (d == d2) {
                    bl = true;
                }
            }
            return bl;
        }
        return ScriptRuntime.shallowEq(object, object2);
    }

    private static int doVarIncDec(Context object, CallFrame callFrame, Object[] objectArray, double[] object2, int n, Object[] objectArray2, double[] dArray, int[] nArray, int n2) {
        int n3 = n + 1;
        n = callFrame.idata.itsICode[callFrame.pc];
        if (!callFrame.useActivation) {
            object = objectArray2[n2];
            double d = object == UniqueTag.DOUBLE_MARK ? dArray[n2] : ScriptRuntime.toNumber(object);
            double d2 = (n & 1) == 0 ? 1.0 + d : d - 1.0;
            n = (n & 2) != 0 ? 1 : 0;
            if ((nArray[n2] & 1) == 0) {
                if (object != UniqueTag.DOUBLE_MARK) {
                    objectArray2[n2] = UniqueTag.DOUBLE_MARK;
                }
                dArray[n2] = d2;
                objectArray[n3] = UniqueTag.DOUBLE_MARK;
                if (n == 0) {
                    d = d2;
                }
                object2[n3] = d;
            } else if (n != 0 && object != UniqueTag.DOUBLE_MARK) {
                objectArray[n3] = object;
            } else {
                objectArray[n3] = UniqueTag.DOUBLE_MARK;
                if (n == 0) {
                    d = d2;
                }
                object2[n3] = d;
            }
        } else {
            object2 = callFrame.idata.argNames[n2];
            objectArray[n3] = ScriptRuntime.nameIncrDecr(callFrame.scope, (String)object2, (Context)object, n);
        }
        ++callFrame.pc;
        return n3;
    }

    static void dumpICode(InterpreterData interpreterData) {
    }

    private static void enterFrame(Context context, CallFrame callFrame, Object[] objectArray, boolean bl) {
        boolean bl2 = callFrame.idata.itsNeedsActivation;
        boolean bl3 = callFrame.debuggerFrame != null;
        if (bl2 || bl3) {
            Scriptable scriptable;
            block7: {
                Scriptable scriptable2 = callFrame.scope;
                if (scriptable2 == null) {
                    Kit.codeBug();
                    scriptable = scriptable2;
                } else {
                    scriptable = scriptable2;
                    if (bl) {
                        while (true) {
                            scriptable = scriptable2;
                            if (!(scriptable2 instanceof NativeWith)) break block7;
                            scriptable = scriptable2.getParentScope();
                            if (scriptable == null) break;
                            scriptable2 = scriptable;
                            if (callFrame.parentFrame == null) continue;
                            scriptable2 = scriptable;
                            if (callFrame.parentFrame.scope == scriptable) break;
                        }
                        Kit.codeBug();
                    }
                }
            }
            if (bl3) {
                callFrame.debuggerFrame.onEnter(context, scriptable, callFrame.thisObj, objectArray);
            }
            if (bl2) {
                ScriptRuntime.enterActivationFunction(context, scriptable);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void exitFrame(Context context, CallFrame callFrame, Object object) {
        if (callFrame.idata.itsNeedsActivation) {
            ScriptRuntime.exitActivationFunction(context);
        }
        if (callFrame.debuggerFrame == null) return;
        try {
            if (object instanceof Throwable) {
                callFrame.debuggerFrame.onExit(context, true, object);
                return;
            }
            ContinuationJump continuationJump = (ContinuationJump)object;
            object = continuationJump == null ? callFrame.result : continuationJump.result;
            Object object2 = object;
            if (object == UniqueTag.DOUBLE_MARK) {
                double d = continuationJump == null ? callFrame.resultDbl : continuationJump.resultDbl;
                object2 = ScriptRuntime.wrapNumber(d);
            }
            callFrame.debuggerFrame.onExit(context, false, object2);
            return;
        }
        catch (Throwable throwable) {
            System.err.println("RHINO USAGE WARNING: onExit terminated with exception");
            throwable.printStackTrace(System.err);
        }
    }

    private static Object freezeGenerator(Context object, CallFrame callFrame, int n, GeneratorState generatorState) {
        if (generatorState.operation != 2) {
            callFrame.frozen = true;
            callFrame.result = callFrame.stack[n];
            callFrame.resultDbl = callFrame.sDbl[n];
            callFrame.savedStackTop = n;
            --callFrame.pc;
            ScriptRuntime.exitActivationFunction((Context)object);
            object = callFrame.result != UniqueTag.DOUBLE_MARK ? callFrame.result : ScriptRuntime.wrapNumber(callFrame.resultDbl);
            return object;
        }
        throw ScriptRuntime.typeError0("msg.yield.closing");
    }

    private static Object[] getArgsArray(Object[] objectArray, double[] dArray, int n, int n2) {
        if (n2 == 0) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] objectArray2 = new Object[n2];
        int n3 = 0;
        while (n3 != n2) {
            Object object;
            Object object2 = object = objectArray[n];
            if (object == UniqueTag.DOUBLE_MARK) {
                object2 = ScriptRuntime.wrapNumber(dArray[n]);
            }
            objectArray2[n3] = object2;
            ++n3;
            ++n;
        }
        return objectArray2;
    }

    static String getEncodedSource(InterpreterData interpreterData) {
        if (interpreterData.encodedSource == null) {
            return null;
        }
        return interpreterData.encodedSource.substring(interpreterData.encodedSourceStart, interpreterData.encodedSourceEnd);
    }

    /*
     * Unable to fully structure code
     */
    private static int getExceptionHandler(CallFrame var0, boolean var1_1) {
        var2_2 = var0.idata.itsExceptionTable;
        var3_3 = -1;
        if (var2_2 == null) {
            return -1;
        }
        var4_4 = var0.pc - 1;
        var6_6 = 0;
        var7_7 = 0;
        for (var5_5 = 0; var5_5 != var2_2.length; var5_5 += 6) {
            block6: {
                block8: {
                    block7: {
                        var8_8 = var2_2[var5_5 + 0];
                        var9_9 = var2_2[var5_5 + 1];
                        var10_10 = var3_3;
                        var11_11 = var6_6;
                        var12_12 = var7_7;
                        if (var8_8 > var4_4) break block6;
                        if (var4_4 < var9_9) break block7;
                        var10_10 = var3_3;
                        var11_11 = var6_6;
                        var12_12 = var7_7;
                        break block6;
                    }
                    if (!var1_1 || var2_2[var5_5 + 3] == 1) break block8;
                    var10_10 = var3_3;
                    var11_11 = var6_6;
                    var12_12 = var7_7;
                    break block6;
                }
                if (var3_3 < 0) ** GOTO lbl39
                if (var6_6 < var9_9) {
                    var10_10 = var3_3;
                    var11_11 = var6_6;
                    var12_12 = var7_7;
                } else {
                    if (var7_7 > var8_8) {
                        Kit.codeBug();
                    }
                    if (var6_6 == var9_9) {
                        Kit.codeBug();
                    }
lbl39:
                    // 4 sources

                    var10_10 = var5_5;
                    var12_12 = var8_8;
                    var11_11 = var9_9;
                }
            }
            var3_3 = var10_10;
            var6_6 = var11_11;
            var7_7 = var12_12;
        }
        return var3_3;
    }

    private static int getIndex(byte[] byArray, int n) {
        byte by = byArray[n];
        return byArray[n + 1] & 0xFF | (by & 0xFF) << 8;
    }

    private static int getInt(byte[] byArray, int n) {
        byte by = byArray[n];
        byte by2 = byArray[n + 1];
        byte by3 = byArray[n + 2];
        return byArray[n + 3] & 0xFF | (by << 24 | (by2 & 0xFF) << 16 | (by3 & 0xFF) << 8);
    }

    static int[] getLineNumbers(InterpreterData object) {
        int n;
        UintMap uintMap = new UintMap();
        object = ((InterpreterData)object).itsICode;
        int n2 = ((Object)object).length;
        for (int i = 0; i != n2; i += n) {
            Object object2 = object[i];
            n = Interpreter.bytecodeSpan((int)object2);
            if (object2 != -26) continue;
            if (n != 3) {
                Kit.codeBug();
            }
            uintMap.put(Interpreter.getIndex((byte[])object, i + 1), 0);
        }
        return uintMap.getKeys();
    }

    private static int getShort(byte[] byArray, int n) {
        byte by = byArray[n];
        return byArray[n + 1] & 0xFF | by << 8;
    }

    private static CallFrame initFrame(Context context, Scriptable scriptable, Scriptable object, Object[] objectArray, double[] dArray, int n, int n2, InterpretedFunction interpretedFunction, CallFrame callFrame) {
        object = new CallFrame(context, (Scriptable)object, interpretedFunction, callFrame);
        ((CallFrame)object).initializeArgs(context, scriptable, objectArray, dArray, n, n2);
        Interpreter.enterFrame(context, (CallFrame)object, objectArray, false);
        return object;
    }

    private static CallFrame initFrameForApplyOrCall(Context object, CallFrame objectArray, int n, Object[] objectArray2, double[] dArray, int n2, int n3, Scriptable scriptable, IdFunctionObject idFunctionObject, InterpretedFunction interpretedFunction) {
        Object object2;
        Object object3;
        int n4;
        Object[] objectArray3 = objectArray;
        if (n != 0) {
            n4 = n2 + 2;
            object2 = object3 = objectArray2[n4];
            if (object3 == UniqueTag.DOUBLE_MARK) {
                object2 = ScriptRuntime.wrapNumber(dArray[n4]);
            }
            object2 = ScriptRuntime.toObjectOrNull((Context)object, object2, objectArray3.scope);
        } else {
            object2 = null;
        }
        object3 = object2;
        if (object2 == null) {
            object3 = ScriptRuntime.getTopCallScope((Context)object);
        }
        if (n3 == -55) {
            Interpreter.exitFrame((Context)object, (CallFrame)objectArray, null);
            objectArray3 = objectArray3.parentFrame;
        } else {
            objectArray3.savedStackTop = n2;
            objectArray3.savedCallOp = n3;
        }
        if (BaseFunction.isApply(idFunctionObject)) {
            objectArray = n < 2 ? ScriptRuntime.emptyArgs : ScriptRuntime.getApplyArguments((Context)object, objectArray2[n2 + 3]);
            object = Interpreter.initFrame((Context)object, scriptable, (Scriptable)object3, objectArray, null, 0, objectArray.length, interpretedFunction, (CallFrame)objectArray3);
        } else {
            for (n3 = 1; n3 < n; ++n3) {
                n4 = n2 + 1 + n3;
                int n5 = n2 + 2 + n3;
                objectArray2[n4] = objectArray2[n5];
                dArray[n4] = dArray[n5];
            }
            n = n < 2 ? 0 : --n;
            object = Interpreter.initFrame((Context)object, scriptable, (Scriptable)object3, objectArray2, dArray, n2 + 2, n, interpretedFunction, (CallFrame)objectArray3);
        }
        return object;
    }

    private static CallFrame initFrameForNoSuchMethod(Context object, CallFrame callFrame, int n, Object[] object2, double[] object3, int n2, int n3, Scriptable scriptable, Scriptable scriptable2, ScriptRuntime.NoSuchMethodShim object4, InterpretedFunction interpretedFunction) {
        int n4 = n2 + 2;
        Object[] objectArray = new Object[n];
        int n5 = 0;
        while (n5 < n) {
            Object object5;
            Object object6 = object5 = object2[n4];
            if (object5 == UniqueTag.DOUBLE_MARK) {
                object6 = ScriptRuntime.wrapNumber(object3[n4]);
            }
            objectArray[n5] = object6;
            ++n5;
            ++n4;
        }
        object3 = ((ScriptRuntime.NoSuchMethodShim)object4).methodName;
        object4 = ((Context)object).newArray(scriptable2, objectArray);
        if (n3 == -55) {
            object2 = callFrame.parentFrame;
            Interpreter.exitFrame((Context)object, callFrame, null);
        } else {
            object2 = callFrame;
        }
        object = Interpreter.initFrame((Context)object, scriptable2, scriptable, new Object[]{object3, object4}, null, 0, 2, interpretedFunction, (CallFrame)object2);
        if (n3 != -55) {
            callFrame.savedStackTop = n2;
            callFrame.savedCallOp = n3;
        }
        return object;
    }

    private static void initFunction(Context context, Scriptable scriptable, InterpretedFunction interpretedFunction, int n) {
        InterpretedFunction interpretedFunction2 = InterpretedFunction.createFunction(context, scriptable, interpretedFunction, n);
        ScriptRuntime.initFunction(context, scriptable, interpretedFunction2, interpretedFunction2.idata.itsFunctionType, interpretedFunction.idata.evalScriptFlag);
    }

    static Object interpret(InterpretedFunction object, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!ScriptRuntime.hasTopCall(context)) {
            Kit.codeBug();
        }
        if (context.interpreterSecurityDomain != ((InterpretedFunction)object).securityDomain) {
            Object object2 = context.interpreterSecurityDomain;
            context.interpreterSecurityDomain = ((InterpretedFunction)object).securityDomain;
            try {
                object = ((InterpretedFunction)object).securityController.callWithDomain(((InterpretedFunction)object).securityDomain, context, (Callable)object, scriptable, scriptable2, objectArray);
                return object;
            }
            finally {
                context.interpreterSecurityDomain = object2;
            }
        }
        object = Interpreter.initFrame(context, scriptable, scriptable2, objectArray, null, 0, objectArray.length, (InterpretedFunction)object, null);
        ((CallFrame)object).isContinuationsTopFrame = context.isContinuationsTopCall;
        context.isContinuationsTopCall = false;
        return Interpreter.interpretLoop(context, (CallFrame)object, null);
    }

    /*
     * Exception decompiling
     */
    private static Object interpretLoop(Context var0, CallFrame var1_1, Object var2_7) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 283->291)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static CallFrame processThrowable(Context object, Object object2, CallFrame callFrameArray, int object3, boolean bl) {
        if (object3 >= 0) {
            object = callFrameArray;
            if (callFrameArray.frozen) {
                object = callFrameArray.cloneFrozen();
            }
            callFrameArray = (CallFrame[])((CallFrame)object).idata.itsExceptionTable;
            ((CallFrame)object).pc = (int)callFrameArray[object3 + 2];
            if (bl) {
                ((CallFrame)object).pcPrevBranch = ((CallFrame)object).pc;
            }
            ((CallFrame)object).savedStackTop = ((CallFrame)object).emptyStackTop;
            int n = ((CallFrame)object).localShift;
            Object object4 = callFrameArray[object3 + 5];
            int n2 = ((CallFrame)object).localShift;
            object3 = callFrameArray[object3 + 4];
            ((CallFrame)object).scope = (Scriptable)((CallFrame)object).stack[n + object4];
            ((CallFrame)object).stack[n2 + object3] = object2;
        } else {
            int n;
            ContinuationJump continuationJump = (ContinuationJump)object2;
            if (continuationJump.branchFrame != callFrameArray) {
                Kit.codeBug();
            }
            if (continuationJump.capturedFrame == null) {
                Kit.codeBug();
            }
            int n3 = object3 = continuationJump.capturedFrame.frameIndex + 1;
            if (continuationJump.branchFrame != null) {
                n3 = object3 - continuationJump.branchFrame.frameIndex;
            }
            CallFrame callFrame = continuationJump.capturedFrame;
            int n4 = 0;
            object2 = null;
            object3 = 0;
            while (true) {
                n = object3;
                if (n4 == n3) break;
                if (!callFrame.frozen) {
                    Kit.codeBug();
                }
                n = object3;
                callFrameArray = object2;
                if (callFrame.useActivation) {
                    callFrameArray = object2;
                    if (object2 == null) {
                        callFrameArray = new CallFrame[n3 - n4];
                    }
                    callFrameArray[object3] = callFrame;
                    n = object3 + 1;
                }
                callFrame = callFrame.parentFrame;
                ++n4;
                object3 = n;
                object2 = callFrameArray;
            }
            while (n != 0) {
                Interpreter.enterFrame((Context)object, (CallFrame)object2[--n], ScriptRuntime.emptyArgs, true);
            }
            object = continuationJump.capturedFrame.cloneFrozen();
            Interpreter.setCallResult((CallFrame)object, continuationJump.result, continuationJump.resultDbl);
        }
        ((CallFrame)object).throwable = null;
        return object;
    }

    public static Object restartContinuation(NativeContinuation serializable, Context context, Scriptable object, Object[] objectArray) {
        if (!ScriptRuntime.hasTopCall(context)) {
            return ScriptRuntime.doTopCall(serializable, context, (Scriptable)object, null, objectArray, context.isTopLevelStrict);
        }
        object = objectArray.length == 0 ? Undefined.instance : objectArray[0];
        if ((CallFrame)serializable.getImplementation() == null) {
            return object;
        }
        serializable = new ContinuationJump((NativeContinuation)serializable, null);
        ((ContinuationJump)serializable).result = object;
        return Interpreter.interpretLoop(context, null, serializable);
    }

    public static Object resumeGenerator(Context object, Scriptable object2, int n, Object object3, Object object4) {
        object3 = (CallFrame)object3;
        object2 = new GeneratorState(n, object4);
        if (n == 2) {
            try {
                object = Interpreter.interpretLoop((Context)object, (CallFrame)object3, object2);
                return object;
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException == object4) {
                    return Undefined.instance;
                }
                throw runtimeException;
            }
        }
        object = Interpreter.interpretLoop((Context)object, (CallFrame)object3, object2);
        if (((GeneratorState)object2).returnedException == null) {
            return object;
        }
        throw ((GeneratorState)object2).returnedException;
    }

    private static void setCallResult(CallFrame callFrame, Object object, double d) {
        if (callFrame.savedCallOp == 38) {
            callFrame.stack[callFrame.savedStackTop] = object;
            callFrame.sDbl[callFrame.savedStackTop] = d;
        } else if (callFrame.savedCallOp == 30) {
            if (object instanceof Scriptable) {
                callFrame.stack[callFrame.savedStackTop] = object;
            }
        } else {
            Kit.codeBug();
        }
        callFrame.savedCallOp = 0;
    }

    private static boolean stack_boolean(CallFrame callFrame, int n) {
        Object object = callFrame.stack[n];
        Boolean bl = Boolean.TRUE;
        boolean bl2 = true;
        boolean bl3 = true;
        if (object == bl) {
            return true;
        }
        if (object == Boolean.FALSE) {
            return false;
        }
        if (object == UniqueTag.DOUBLE_MARK) {
            double d = callFrame.sDbl[n];
            if (d != d || d == 0.0) {
                bl3 = false;
            }
            return bl3;
        }
        if (object != null && object != Undefined.instance) {
            if (object instanceof Number) {
                double d = ((Number)object).doubleValue();
                bl3 = d == d && d != 0.0 ? bl2 : false;
                return bl3;
            }
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            return ScriptRuntime.toBoolean(object);
        }
        return false;
    }

    private static double stack_double(CallFrame callFrame, int n) {
        Object object = callFrame.stack[n];
        if (object != UniqueTag.DOUBLE_MARK) {
            return ScriptRuntime.toNumber(object);
        }
        return callFrame.sDbl[n];
    }

    private static int stack_int32(CallFrame callFrame, int n) {
        Object object = callFrame.stack[n];
        if (object == UniqueTag.DOUBLE_MARK) {
            return ScriptRuntime.toInt32(callFrame.sDbl[n]);
        }
        return ScriptRuntime.toInt32(object);
    }

    private static Object thawGenerator(CallFrame callFrame, int n, GeneratorState generatorState, int n2) {
        callFrame.frozen = false;
        int n3 = Interpreter.getIndex(callFrame.idata.itsICode, callFrame.pc);
        callFrame.pc += 2;
        if (generatorState.operation == 1) {
            return new JavaScriptException(generatorState.value, callFrame.idata.itsSourceFile, n3);
        }
        if (generatorState.operation == 2) {
            return generatorState.value;
        }
        if (generatorState.operation == 0) {
            if (n2 == 73) {
                callFrame.stack[n] = generatorState.value;
            }
            return Scriptable.NOT_FOUND;
        }
        throw Kit.codeBug();
    }

    @Override
    public void captureStackInfo(RhinoException rhinoException) {
        Object object = Context.getCurrentContext();
        if (object != null && ((Context)object).lastInterpreterFrame != null) {
            Object[] objectArray;
            int n;
            int n2;
            if (((Context)object).previousInterpreterInvocations != null && ((Context)object).previousInterpreterInvocations.size() != 0) {
                n = n2 = ((Context)object).previousInterpreterInvocations.size();
                if (((Context)object).previousInterpreterInvocations.peek() == ((Context)object).lastInterpreterFrame) {
                    n = n2 - 1;
                }
                objectArray = new CallFrame[n + 1];
                ((Context)object).previousInterpreterInvocations.toArray(objectArray);
            } else {
                objectArray = new CallFrame[1];
            }
            objectArray[objectArray.length - 1] = (CallFrame)((Context)object).lastInterpreterFrame;
            n = 0;
            for (n2 = 0; n2 != objectArray.length; ++n2) {
                n += objectArray[n2].frameIndex + 1;
            }
            int[] nArray = new int[n];
            n2 = objectArray.length;
            block1: while (n2 != 0) {
                int n3 = n2 - 1;
                object = objectArray[n3];
                int n4 = n;
                while (true) {
                    n2 = n3;
                    n = n4--;
                    if (object == null) continue block1;
                    nArray[n4] = ((CallFrame)object).pcSourceLineStart;
                    object = ((CallFrame)object).parentFrame;
                }
            }
            if (n != 0) {
                Kit.codeBug();
            }
            rhinoException.interpreterStackInfo = objectArray;
            rhinoException.interpreterLineData = nArray;
            return;
        }
        rhinoException.interpreterStackInfo = null;
        rhinoException.interpreterLineData = null;
    }

    @Override
    public Object compile(CompilerEnvirons object, ScriptNode scriptNode, String string2, boolean bl) {
        this.itsData = object = new CodeGenerator().compile((CompilerEnvirons)object, scriptNode, string2, bl);
        return object;
    }

    @Override
    public Function createFunctionObject(Context context, Scriptable scriptable, Object object, Object object2) {
        if (object != this.itsData) {
            Kit.codeBug();
        }
        return InterpretedFunction.createFunction(context, scriptable, this.itsData, object2);
    }

    @Override
    public Script createScriptObject(Object object, Object object2) {
        if (object != this.itsData) {
            Kit.codeBug();
        }
        return InterpretedFunction.createScript(this.itsData, object2);
    }

    @Override
    public String getPatchedStack(RhinoException serializable, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string2.length() + 1000);
        String string3 = SecurityUtilities.getSystemProperty("line.separator");
        CallFrame[] callFrameArray = (CallFrame[])serializable.interpreterStackInfo;
        int[] nArray = serializable.interpreterLineData;
        int n = callFrameArray.length;
        int n2 = nArray.length;
        int n3 = 0;
        while (n != 0) {
            char c;
            --n;
            int n4 = string2.indexOf("org.mozilla.javascript.Interpreter.interpretLoop", n3);
            if (n4 < 0) break;
            n4 += 48;
            while (n4 != string2.length() && (c = string2.charAt(n4)) != '\n' && c != '\r') {
                ++n4;
            }
            stringBuilder.append(string2.substring(n3, n4));
            serializable = callFrameArray[n];
            while (serializable != null) {
                if (n2 == 0) {
                    Kit.codeBug();
                }
                --n2;
                InterpreterData interpreterData = ((CallFrame)serializable).idata;
                stringBuilder.append(string3);
                stringBuilder.append("\tat script");
                if (interpreterData.itsName != null && interpreterData.itsName.length() != 0) {
                    stringBuilder.append('.');
                    stringBuilder.append(interpreterData.itsName);
                }
                stringBuilder.append('(');
                stringBuilder.append(interpreterData.itsSourceFile);
                n3 = nArray[n2];
                if (n3 >= 0) {
                    stringBuilder.append(':');
                    stringBuilder.append(Interpreter.getIndex(interpreterData.itsICode, n3));
                }
                stringBuilder.append(')');
                serializable = ((CallFrame)serializable).parentFrame;
            }
            n3 = n4;
        }
        stringBuilder.append(string2.substring(n3));
        return stringBuilder.toString();
    }

    @Override
    public List<String> getScriptStack(RhinoException scriptStackElementArray) {
        scriptStackElementArray = this.getScriptStackElements((RhinoException)scriptStackElementArray);
        ArrayList<String> arrayList = new ArrayList<String>(scriptStackElementArray.length);
        String string2 = SecurityUtilities.getSystemProperty("line.separator");
        for (ScriptStackElement[] scriptStackElementArray2 : scriptStackElementArray) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = scriptStackElementArray2.length;
            for (int i = 0; i < n; ++i) {
                scriptStackElementArray2[i].renderJavaStyle(stringBuilder);
                stringBuilder.append(string2);
            }
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    public ScriptStackElement[][] getScriptStackElements(RhinoException object) {
        if (object.interpreterStackInfo == null) {
            object = null;
            return null;
        }
        ArrayList<ScriptStackElement[]> arrayList = new ArrayList<ScriptStackElement[]>();
        CallFrame[] callFrameArray = (CallFrame[])object.interpreterStackInfo;
        int[] nArray = object.interpreterLineData;
        int n = callFrameArray.length;
        int n2 = nArray.length;
        while (n != 0) {
            object = callFrameArray[--n];
            ArrayList<ScriptStackElement> arrayList2 = new ArrayList<ScriptStackElement>();
            while (object != null) {
                if (n2 == 0) {
                    Kit.codeBug();
                }
                int n3 = n2 - 1;
                Object object2 = object.idata;
                String string2 = ((InterpreterData)object2).itsSourceFile;
                n2 = nArray[n3];
                n2 = n2 >= 0 ? Interpreter.getIndex(((InterpreterData)object2).itsICode, n2) : -1;
                object2 = ((InterpreterData)object2).itsName != null && ((InterpreterData)object2).itsName.length() != 0 ? ((InterpreterData)object2).itsName : null;
                object = object.parentFrame;
                arrayList2.add(new ScriptStackElement(string2, (String)object2, n2));
                n2 = n3;
            }
            arrayList.add(arrayList2.toArray(new ScriptStackElement[arrayList2.size()]));
        }
        return (ScriptStackElement[][])arrayList.toArray((T[])new ScriptStackElement[arrayList.size()][]);
    }

    @Override
    public String getSourcePositionFromStack(Context object, int[] nArray) {
        object = (CallFrame)((Context)object).lastInterpreterFrame;
        InterpreterData interpreterData = ((CallFrame)object).idata;
        nArray[0] = ((CallFrame)object).pcSourceLineStart >= 0 ? Interpreter.getIndex(interpreterData.itsICode, ((CallFrame)object).pcSourceLineStart) : 0;
        return interpreterData.itsSourceFile;
    }

    @Override
    public void setEvalScriptFlag(Script script) {
        ((InterpretedFunction)script).idata.evalScriptFlag = true;
    }

    private static class CallFrame
    implements Cloneable,
    Serializable {
        static final long serialVersionUID = -2843792508994958978L;
        final DebugFrame debuggerFrame;
        final int emptyStackTop;
        final InterpretedFunction fnOrScript;
        int frameIndex;
        boolean frozen;
        final InterpreterData idata;
        boolean isContinuationsTopFrame;
        final int localShift;
        CallFrame parentFrame;
        int pc;
        int pcPrevBranch;
        int pcSourceLineStart;
        Object result;
        double resultDbl;
        double[] sDbl;
        int savedCallOp;
        int savedStackTop;
        Scriptable scope;
        Object[] stack;
        int[] stackAttributes;
        final Scriptable thisObj;
        Object throwable;
        final boolean useActivation;
        final CallFrame varSource;

        CallFrame(Context context, Scriptable scriptable, InterpretedFunction interpretedFunction, CallFrame callFrame) {
            int n;
            InterpreterData interpreterData;
            this.idata = interpreterData = interpretedFunction.idata;
            DebugFrame debugFrame = context.debugger != null ? context.debugger.getFrame(context, interpreterData) : null;
            this.debuggerFrame = debugFrame;
            int n2 = 0;
            boolean bl = debugFrame != null || interpreterData.itsNeedsActivation;
            this.useActivation = bl;
            this.emptyStackTop = n = interpreterData.itsMaxVars + interpreterData.itsMaxLocals - 1;
            this.fnOrScript = interpretedFunction;
            this.varSource = this;
            this.localShift = interpreterData.itsMaxVars;
            this.thisObj = scriptable;
            this.parentFrame = callFrame;
            if (callFrame != null) {
                n2 = callFrame.frameIndex + 1;
            }
            this.frameIndex = n2;
            if (n2 <= context.getMaximumInterpreterStackDepth()) {
                this.result = Undefined.instance;
                this.pcSourceLineStart = interpreterData.firstLinePC;
                this.savedStackTop = n;
                return;
            }
            throw Context.reportRuntimeError("Exceeded maximum stack depth");
        }

        CallFrame cloneFrozen() {
            CallFrame callFrame;
            if (!this.frozen) {
                Kit.codeBug();
            }
            try {
                callFrame = (CallFrame)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException();
            }
            callFrame.stack = (Object[])this.stack.clone();
            callFrame.stackAttributes = (int[])this.stackAttributes.clone();
            callFrame.sDbl = (double[])this.sDbl.clone();
            callFrame.frozen = false;
            return callFrame;
        }

        void initializeArgs(Context context, Scriptable scriptable, Object[] object, double[] dArray, int n, int n2) {
            Object[] objectArray = object;
            double[] dArray2 = dArray;
            int n3 = n;
            if (this.useActivation) {
                objectArray = object;
                if (dArray != null) {
                    objectArray = Interpreter.getArgsArray(object, dArray, n, n2);
                }
                dArray2 = null;
                n3 = 0;
            }
            if (this.idata.itsFunctionType != 0) {
                this.scope = this.fnOrScript.getParentScope();
                if (this.useActivation) {
                    this.scope = this.idata.itsFunctionType == 4 ? ScriptRuntime.createArrowFunctionActivation(this.fnOrScript, this.scope, objectArray, this.idata.isStrict) : ScriptRuntime.createFunctionActivation(this.fnOrScript, this.scope, objectArray, this.idata.isStrict);
                }
            } else {
                this.scope = scriptable;
                object = this.fnOrScript;
                ScriptRuntime.initScript((NativeFunction)object, this.thisObj, context, scriptable, object.idata.evalScriptFlag);
            }
            if (this.idata.itsNestedFunctions != null) {
                if (this.idata.itsFunctionType != 0 && !this.idata.itsNeedsActivation) {
                    Kit.codeBug();
                }
                for (n = 0; n < this.idata.itsNestedFunctions.length; ++n) {
                    if (this.idata.itsNestedFunctions[n].itsFunctionType != 1) continue;
                    Interpreter.initFunction(context, this.scope, this.fnOrScript, n);
                }
            }
            if ((n = this.idata.itsMaxFrameArray) != this.emptyStackTop + this.idata.itsMaxStack + 1) {
                Kit.codeBug();
            }
            this.stack = new Object[n];
            this.stackAttributes = new int[n];
            this.sDbl = new double[n];
            int n4 = this.idata.getParamAndVarCount();
            for (n = 0; n < n4; ++n) {
                if (!this.idata.getParamOrVarConst(n)) continue;
                this.stackAttributes[n] = 13;
            }
            n = this.idata.argCount;
            if (n <= n2) {
                n2 = n;
            }
            System.arraycopy(objectArray, n3, this.stack, 0, n2);
            n = n2;
            if (dArray2 != null) {
                System.arraycopy(dArray2, n3, this.sDbl, 0, n2);
                n = n2;
            }
            while (n != this.idata.itsMaxVars) {
                this.stack[n] = Undefined.instance;
                ++n;
            }
        }
    }

    private static final class ContinuationJump
    implements Serializable {
        static final long serialVersionUID = 7687739156004308247L;
        CallFrame branchFrame;
        CallFrame capturedFrame;
        Object result;
        double resultDbl;

        ContinuationJump(NativeContinuation serializable, CallFrame callFrame) {
            CallFrame callFrame2;
            this.capturedFrame = callFrame2 = (CallFrame)serializable.getImplementation();
            if (callFrame2 != null && callFrame != null) {
                int n = callFrame2.frameIndex - callFrame.frameIndex;
                CallFrame callFrame3 = callFrame2;
                serializable = callFrame;
                if (n != 0) {
                    int n2;
                    if (n < 0) {
                        serializable = this.capturedFrame;
                        n = -n;
                    } else {
                        serializable = callFrame;
                        callFrame = callFrame2;
                    }
                    do {
                        callFrame3 = callFrame.parentFrame;
                        n = n2 = n - 1;
                        callFrame = callFrame3;
                    } while (n2 != 0);
                    if (callFrame3.frameIndex != ((CallFrame)serializable).frameIndex) {
                        Kit.codeBug();
                    }
                }
                while (callFrame3 != serializable && callFrame3 != null) {
                    callFrame3 = callFrame3.parentFrame;
                    serializable = ((CallFrame)serializable).parentFrame;
                }
                this.branchFrame = callFrame3;
                if (callFrame3 != null && !callFrame3.frozen) {
                    Kit.codeBug();
                }
            } else {
                this.branchFrame = null;
            }
        }
    }

    static class GeneratorState {
        int operation;
        RuntimeException returnedException;
        Object value;

        GeneratorState(int n, Object object) {
            this.operation = n;
            this.value = object;
        }
    }
}

