/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionCall;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.SecurityUtilities;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.VMBridge;
import org.mozilla.javascript.Wrapper;

public final class JavaAdapter
implements IdFunctionCall {
    private static final Object FTAG = "JavaAdapter";
    private static final int Id_JavaAdapter = 1;

    static int appendMethodSignature(Class<?>[] classArray, Class<?> clazz, StringBuilder stringBuilder) {
        stringBuilder.append('(');
        int n = classArray.length + 1;
        for (Class<?> clazz2 : classArray) {
            int n2;
            block4: {
                block3: {
                    JavaAdapter.appendTypeString(stringBuilder, clazz2);
                    if (clazz2 == Long.TYPE) break block3;
                    n2 = n;
                    if (clazz2 != Double.TYPE) break block4;
                }
                n2 = n + 1;
            }
            n = n2;
        }
        stringBuilder.append(')');
        JavaAdapter.appendTypeString(stringBuilder, clazz);
        return n;
    }

    private static void appendOverridableMethods(Class<?> methodArray, ArrayList<Method> arrayList, HashSet<String> hashSet) {
        methodArray = methodArray.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            int n;
            CharSequence charSequence = new StringBuilder();
            charSequence.append(methodArray[i].getName());
            charSequence.append(JavaAdapter.getMethodSignature(methodArray[i], methodArray[i].getParameterTypes()));
            charSequence = charSequence.toString();
            if (hashSet.contains(charSequence) || Modifier.isStatic(n = methodArray[i].getModifiers())) continue;
            if (Modifier.isFinal(n)) {
                hashSet.add((String)charSequence);
                continue;
            }
            if (!Modifier.isPublic(n) && !Modifier.isProtected(n)) continue;
            arrayList.add(methodArray[i]);
            hashSet.add((String)charSequence);
        }
    }

    private static StringBuilder appendTypeString(StringBuilder stringBuilder, Class<?> clazz) {
        while (clazz.isArray()) {
            stringBuilder.append('[');
            clazz = clazz.getComponentType();
        }
        if (clazz.isPrimitive()) {
            char c;
            char c2;
            char c3;
            char c4 = clazz == Boolean.TYPE ? (c3 = 'Z') : (clazz == Long.TYPE ? (c2 = 'J') : (c = Character.toUpperCase(clazz.getName().charAt(0))));
            stringBuilder.append(c4);
        } else {
            stringBuilder.append('L');
            stringBuilder.append(clazz.getName().replace('.', '/'));
            stringBuilder.append(';');
        }
        return stringBuilder;
    }

    public static Object callMethod(ContextFactory object, final Scriptable scriptable, final Function function, final Object[] objectArray, final long l) {
        if (function == null) {
            return null;
        }
        ContextFactory contextFactory = object;
        if (object == null) {
            contextFactory = ContextFactory.getGlobal();
        }
        final Scriptable scriptable2 = function.getParentScope();
        if (l == 0L) {
            return Context.call(contextFactory, function, scriptable2, scriptable, objectArray);
        }
        object = Context.getCurrentContext();
        if (object != null) {
            return JavaAdapter.doCall((Context)object, scriptable2, scriptable, function, objectArray, l);
        }
        return contextFactory.call(new ContextAction(){

            @Override
            public Object run(Context context) {
                return JavaAdapter.doCall(context, scriptable2, scriptable, function, objectArray, l);
            }
        });
    }

    public static Object convertResult(Object object, Class<?> clazz) {
        if (object == Undefined.instance && clazz != ScriptRuntime.ObjectClass && clazz != ScriptRuntime.StringClass) {
            return null;
        }
        return Context.jsToJava(object, clazz);
    }

    public static byte[] createAdapterCode(ObjToIntMap object, String string2, Class<?> object2, Class<?>[] object3, String object4) {
        Object object5;
        Object object6;
        Class<?>[] classArray;
        int n;
        Constructor<?> constructor2;
        int n2;
        ClassFileWriter classFileWriter = new ClassFileWriter(string2, ((Class)object2).getName(), "<adapter>");
        classFileWriter.addField("factory", "Lorg/mozilla/javascript/ContextFactory;", (short)17);
        classFileWriter.addField("delegee", "Lorg/mozilla/javascript/Scriptable;", (short)17);
        classFileWriter.addField("self", "Lorg/mozilla/javascript/Scriptable;", (short)17);
        int n3 = object3 == null ? 0 : ((Class<?>[])object3).length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (object3[n2] == null) continue;
            classFileWriter.addInterface(object3[n2].getName());
        }
        String string3 = ((Class)object2).getName().replace('.', '/');
        for (Constructor<?> constructor2 : ((Class)object2).getDeclaredConstructors()) {
            n = constructor2.getModifiers();
            if (!Modifier.isPublic(n) && !Modifier.isProtected(n)) continue;
            JavaAdapter.generateCtor(classFileWriter, string2, string3, constructor2);
        }
        JavaAdapter.generateSerialCtor(classFileWriter, string2, string3);
        if (object4 != null) {
            JavaAdapter.generateEmptyCtor(classFileWriter, string2, string3, (String)object4);
        }
        ObjToIntMap objToIntMap = new ObjToIntMap();
        constructor2 = new ObjToIntMap();
        for (n2 = 0; n2 < n3; ++n2) {
            object4 = object3[n2].getMethods();
            for (int i = 0; i < ((Method[])object4).length; ++i) {
                classArray = object4[i];
                n = classArray.getModifiers();
                if (Modifier.isStatic(n) || Modifier.isFinal(n) || VMBridge.instance.isDefaultMethod((Method)classArray)) continue;
                object6 = classArray.getName();
                object5 = classArray.getParameterTypes();
                if (!((ObjToIntMap)object).has(object6)) {
                    try {
                        ((Class)object2).getMethod((String)object6, (Class<?>)object5);
                        continue;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                String string4 = JavaAdapter.getMethodSignature(classArray, object5);
                CharSequence charSequence = new StringBuilder();
                charSequence.append((String)object6);
                charSequence.append(string4);
                charSequence = charSequence.toString();
                if (objToIntMap.has(charSequence)) continue;
                JavaAdapter.generateMethod(classFileWriter, string2, (String)object6, object5, classArray.getReturnType(), true);
                objToIntMap.put(charSequence, 0);
                ((ObjToIntMap)((Object)constructor2)).put(object6, 0);
            }
        }
        object2 = JavaAdapter.getOverridableMethods(object2);
        for (n3 = 0; n3 < ((Method[])object2).length; ++n3) {
            object6 = object2[n3];
            boolean bl = Modifier.isAbstract(((Method)object6).getModifiers());
            object3 = ((Method)object6).getName();
            if (!bl && !((ObjToIntMap)object).has(object3)) continue;
            classArray = ((Method)object6).getParameterTypes();
            object4 = JavaAdapter.getMethodSignature((Method)object6, classArray);
            object5 = new StringBuilder();
            object5.append((String)object3);
            object5.append((String)object4);
            object5 = object5.toString();
            if (objToIntMap.has(object5)) continue;
            JavaAdapter.generateMethod(classFileWriter, string2, object3, classArray, ((Method)object6).getReturnType(), true);
            objToIntMap.put(object5, 0);
            ((ObjToIntMap)((Object)constructor2)).put(object3, 0);
            if (bl) continue;
            JavaAdapter.generateSuper(classFileWriter, string2, string3, object3, (String)object4, classArray, ((Method)object6).getReturnType());
        }
        object2 = new ObjToIntMap.Iterator((ObjToIntMap)object);
        ((ObjToIntMap.Iterator)object2).start();
        while (!((ObjToIntMap.Iterator)object2).done()) {
            object = (String)((ObjToIntMap.Iterator)object2).getKey();
            if (!((ObjToIntMap)((Object)constructor2)).has(object)) {
                n2 = ((ObjToIntMap.Iterator)object2).getValue();
                object3 = new Class[n2];
                for (n3 = 0; n3 < n2; ++n3) {
                    object3[n3] = ScriptRuntime.ObjectClass;
                }
                JavaAdapter.generateMethod(classFileWriter, string2, (String)object, object3, ScriptRuntime.ObjectClass, false);
            }
            ((ObjToIntMap.Iterator)object2).next();
        }
        return classFileWriter.toByteArray();
    }

    public static Scriptable createAdapterWrapper(Scriptable scriptable, Object object) {
        object = new NativeJavaObject(ScriptableObject.getTopLevelScope(scriptable), object, null, true);
        ((NativeJavaObject)object).setPrototype(scriptable);
        return object;
    }

    private static Object doCall(Context context, Scriptable scriptable, Scriptable scriptable2, Function function, Object[] objectArray, long l) {
        for (int i = 0; i != objectArray.length; ++i) {
            Object object;
            if (0L == ((long)(1 << i) & l) || (object = objectArray[i]) instanceof Scriptable) continue;
            objectArray[i] = context.getWrapFactory().wrap(context, scriptable, object, null);
        }
        return function.call(context, scriptable, scriptable2, objectArray);
    }

    private static void generateCtor(ClassFileWriter classFileWriter, String string2, String string3, Constructor<?> classArray) {
        short s;
        classArray = classArray.getParameterTypes();
        int n = classArray.length;
        short s2 = 3;
        if (n == 0) {
            classFileWriter.startMethod("<init>", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/ContextFactory;)V", (short)1);
            classFileWriter.add(42);
            classFileWriter.addInvoke(183, string3, "<init>", "()V");
            s = s2;
        } else {
            StringBuilder stringBuilder = new StringBuilder("(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/ContextFactory;");
            int n2 = stringBuilder.length();
            int n3 = classArray.length;
            int n4 = 0;
            for (n = 0; n < n3; ++n) {
                JavaAdapter.appendTypeString(stringBuilder, classArray[n]);
            }
            stringBuilder.append(")V");
            classFileWriter.startMethod("<init>", stringBuilder.toString(), (short)1);
            classFileWriter.add(42);
            n3 = classArray.length;
            for (n = n4; n < n3; ++n) {
                s2 = (short)(s2 + JavaAdapter.generatePushParam(classFileWriter, s2, classArray[n]));
            }
            stringBuilder.delete(1, n2);
            classFileWriter.addInvoke(183, string3, "<init>", stringBuilder.toString());
            s = s2;
        }
        classFileWriter.add(42);
        classFileWriter.add(43);
        classFileWriter.add(181, string2, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add(42);
        classFileWriter.add(44);
        classFileWriter.add(181, string2, "factory", "Lorg/mozilla/javascript/ContextFactory;");
        classFileWriter.add(42);
        classFileWriter.add(43);
        classFileWriter.add(42);
        classFileWriter.addInvoke(184, "org/mozilla/javascript/JavaAdapter", "createAdapterWrapper", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add(181, string2, "self", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add(177);
        classFileWriter.stopMethod(s);
    }

    private static void generateEmptyCtor(ClassFileWriter classFileWriter, String string2, String string3, String string4) {
        classFileWriter.startMethod("<init>", "()V", (short)1);
        classFileWriter.add(42);
        classFileWriter.addInvoke(183, string3, "<init>", "()V");
        classFileWriter.add(42);
        classFileWriter.add(1);
        classFileWriter.add(181, string2, "factory", "Lorg/mozilla/javascript/ContextFactory;");
        classFileWriter.add(187, string4);
        classFileWriter.add(89);
        classFileWriter.addInvoke(183, string4, "<init>", "()V");
        classFileWriter.addInvoke(184, "org/mozilla/javascript/JavaAdapter", "runScript", "(Lorg/mozilla/javascript/Script;)Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add(76);
        classFileWriter.add(42);
        classFileWriter.add(43);
        classFileWriter.add(181, string2, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add(42);
        classFileWriter.add(43);
        classFileWriter.add(42);
        classFileWriter.addInvoke(184, "org/mozilla/javascript/JavaAdapter", "createAdapterWrapper", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add(181, string2, "self", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)2);
    }

    private static void generateMethod(ClassFileWriter classFileWriter, String string2, String string3, Class<?>[] classArray, Class<?> clazz, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = JavaAdapter.appendMethodSignature(classArray, clazz, stringBuilder);
        classFileWriter.startMethod(string3, stringBuilder.toString(), (short)1);
        classFileWriter.add(42);
        classFileWriter.add(180, string2, "factory", "Lorg/mozilla/javascript/ContextFactory;");
        classFileWriter.add(42);
        classFileWriter.add(180, string2, "self", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add(42);
        classFileWriter.add(180, string2, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.addPush(string3);
        classFileWriter.addInvoke(184, "org/mozilla/javascript/JavaAdapter", "getFunction", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Lorg/mozilla/javascript/Function;");
        JavaAdapter.generatePushWrappedArgs(classFileWriter, classArray, classArray.length);
        if (classArray.length <= 64) {
            long l = 0L;
            for (int i = 0; i != classArray.length; ++i) {
                long l2 = l;
                if (!classArray[i].isPrimitive()) {
                    l2 = l | (long)(1 << i);
                }
                l = l2;
            }
            classFileWriter.addPush(l);
            classFileWriter.addInvoke(184, "org/mozilla/javascript/JavaAdapter", "callMethod", "(Lorg/mozilla/javascript/ContextFactory;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Function;[Ljava/lang/Object;J)Ljava/lang/Object;");
            JavaAdapter.generateReturnResult(classFileWriter, clazz, bl);
            classFileWriter.stopMethod((short)n);
            return;
        }
        throw Context.reportRuntimeError0("JavaAdapter can not subclass methods with more then 64 arguments.");
    }

    /*
     * Unable to fully structure code
     */
    private static void generatePopResult(ClassFileWriter var0, Class<?> var1_1) {
        block7: {
            block5: {
                block6: {
                    if (!var1_1.isPrimitive()) break block5;
                    var2_2 = var1_1.getName().charAt(0);
                    if (var2_2 == 'f') break block6;
                    if (var2_2 == 'i') ** GOTO lbl-1000
                    if (var2_2 == 'l') ** GOTO lbl-1000
                    if (var2_2 != 's' && var2_2 != 'z') {
                        switch (var2_2) {
                            default: {
                                break;
                            }
                            case 'd': {
                                var0.add(175);
                                break;
                            }
                        }
                    }
                    ** GOTO lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        var0.add(173);
                        break;
                        case 'b': 
                        case 'c': lbl-1000:
                        // 3 sources

                        {
                            var0.add(172);
                            break;
                        }
                    }
                    break block7;
                }
                var0.add(174);
                break block7;
            }
            var0.add(176);
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    private static int generatePushParam(ClassFileWriter classFileWriter, int n, Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            classFileWriter.addALoad(n);
            return 1;
        }
        char c = clazz.getName().charAt(0);
        if (c == 'f') {
            classFileWriter.addFLoad(n);
            return 1;
        }
        if (c != 'i') {
            if (c == 'l') {
                classFileWriter.addLLoad(n);
                return 2;
            }
            if (c != 's' && c != 'z') {
                switch (c) {
                    default: {
                        throw Kit.codeBug();
                    }
                    case 'd': {
                        classFileWriter.addDLoad(n);
                        return 2;
                    }
                    case 'b': 
                    case 'c': 
                }
            }
        }
        classFileWriter.addILoad(n);
        return 1;
    }

    static void generatePushWrappedArgs(ClassFileWriter classFileWriter, Class<?>[] classArray, int n) {
        classFileWriter.addPush(n);
        classFileWriter.add(189, "java/lang/Object");
        int n2 = 1;
        for (n = 0; n != classArray.length; ++n) {
            classFileWriter.add(89);
            classFileWriter.addPush(n);
            n2 += JavaAdapter.generateWrapArg(classFileWriter, n2, classArray[n]);
            classFileWriter.add(83);
        }
    }

    static void generateReturnResult(ClassFileWriter object, Class<?> object2, boolean bl) {
        block3: {
            block6: {
                block7: {
                    block8: {
                        block9: {
                            block10: {
                                block5: {
                                    block4: {
                                        block2: {
                                            if (object2 != Void.TYPE) break block2;
                                            ((ClassFileWriter)object).add(87);
                                            ((ClassFileWriter)object).add(177);
                                            break block3;
                                        }
                                        if (object2 != Boolean.TYPE) break block4;
                                        ((ClassFileWriter)object).addInvoke(184, "org/mozilla/javascript/Context", "toBoolean", "(Ljava/lang/Object;)Z");
                                        ((ClassFileWriter)object).add(172);
                                        break block3;
                                    }
                                    if (object2 != Character.TYPE) break block5;
                                    ((ClassFileWriter)object).addInvoke(184, "org/mozilla/javascript/Context", "toString", "(Ljava/lang/Object;)Ljava/lang/String;");
                                    ((ClassFileWriter)object).add(3);
                                    ((ClassFileWriter)object).addInvoke(182, "java/lang/String", "charAt", "(I)C");
                                    ((ClassFileWriter)object).add(172);
                                    break block3;
                                }
                                if (!((Class)object2).isPrimitive()) break block6;
                                ((ClassFileWriter)object).addInvoke(184, "org/mozilla/javascript/Context", "toNumber", "(Ljava/lang/Object;)D");
                                char c = ((Class)object2).getName().charAt(0);
                                if (c == 'b') break block7;
                                if (c == 'd') break block8;
                                if (c == 'f') break block9;
                                if (c == 'i') break block7;
                                if (c == 'l') break block10;
                                if (c != 's') {
                                    object = new StringBuilder();
                                    ((StringBuilder)object).append("Unexpected return type ");
                                    ((StringBuilder)object).append(((Class)object2).toString());
                                    throw new RuntimeException(((StringBuilder)object).toString());
                                }
                                break block7;
                            }
                            ((ClassFileWriter)object).add(143);
                            ((ClassFileWriter)object).add(173);
                            break block3;
                        }
                        ((ClassFileWriter)object).add(144);
                        ((ClassFileWriter)object).add(174);
                        break block3;
                    }
                    ((ClassFileWriter)object).add(175);
                    break block3;
                }
                ((ClassFileWriter)object).add(142);
                ((ClassFileWriter)object).add(172);
                break block3;
            }
            object2 = ((Class)object2).getName();
            if (bl) {
                ((ClassFileWriter)object).addLoadConstant((String)object2);
                ((ClassFileWriter)object).addInvoke(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
                ((ClassFileWriter)object).addInvoke(184, "org/mozilla/javascript/JavaAdapter", "convertResult", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;");
            }
            ((ClassFileWriter)object).add(192, (String)object2);
            ((ClassFileWriter)object).add(176);
        }
    }

    private static void generateSerialCtor(ClassFileWriter classFileWriter, String string2, String string3) {
        classFileWriter.startMethod("<init>", "(Lorg/mozilla/javascript/ContextFactory;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;)V", (short)1);
        classFileWriter.add(42);
        classFileWriter.addInvoke(183, string3, "<init>", "()V");
        classFileWriter.add(42);
        classFileWriter.add(43);
        classFileWriter.add(181, string2, "factory", "Lorg/mozilla/javascript/ContextFactory;");
        classFileWriter.add(42);
        classFileWriter.add(44);
        classFileWriter.add(181, string2, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add(42);
        classFileWriter.add(45);
        classFileWriter.add(181, string2, "self", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)4);
    }

    private static void generateSuper(ClassFileWriter classFileWriter, String charSequence, String string2, String string3, String string4, Class<?>[] classArray, Class<?> clazz) {
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("super$");
        ((StringBuilder)charSequence).append(string3);
        classFileWriter.startMethod(((StringBuilder)charSequence).toString(), string4, (short)1);
        classFileWriter.add(25, 0);
        int n = classArray.length;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 += JavaAdapter.generatePushParam(classFileWriter, n2, classArray[i]);
        }
        classFileWriter.addInvoke(183, string2, string3, string4);
        if (!clazz.equals(Void.TYPE)) {
            JavaAdapter.generatePopResult(classFileWriter, clazz);
        } else {
            classFileWriter.add(177);
        }
        classFileWriter.stopMethod((short)(n2 + 1));
    }

    private static int generateWrapArg(ClassFileWriter classFileWriter, int n, Class<?> clazz) {
        block1: {
            block8: {
                int n2;
                block4: {
                    block9: {
                        block5: {
                            block6: {
                                block7: {
                                    int n3;
                                    block3: {
                                        block2: {
                                            block0: {
                                                boolean bl = clazz.isPrimitive();
                                                n3 = 1;
                                                n2 = 1;
                                                if (bl) break block0;
                                                classFileWriter.add(25, n);
                                                n = n3;
                                                break block1;
                                            }
                                            if (clazz != Boolean.TYPE) break block2;
                                            classFileWriter.add(187, "java/lang/Boolean");
                                            classFileWriter.add(89);
                                            classFileWriter.add(21, n);
                                            classFileWriter.addInvoke(183, "java/lang/Boolean", "<init>", "(Z)V");
                                            n = n3;
                                            break block1;
                                        }
                                        if (clazz != Character.TYPE) break block3;
                                        classFileWriter.add(21, n);
                                        classFileWriter.addInvoke(184, "java/lang/String", "valueOf", "(C)Ljava/lang/String;");
                                        n = n3;
                                        break block1;
                                    }
                                    classFileWriter.add(187, "java/lang/Double");
                                    classFileWriter.add(89);
                                    n3 = clazz.getName().charAt(0);
                                    if (n3 == 98) break block4;
                                    if (n3 == 100) break block5;
                                    if (n3 == 102) break block6;
                                    if (n3 == 105) break block4;
                                    if (n3 == 108) break block7;
                                    if (n3 == 115) break block4;
                                    n = n2;
                                    break block8;
                                }
                                classFileWriter.add(22, n);
                                classFileWriter.add(138);
                                break block9;
                            }
                            classFileWriter.add(23, n);
                            classFileWriter.add(141);
                            n = n2;
                            break block8;
                        }
                        classFileWriter.add(24, n);
                    }
                    n = 2;
                    break block8;
                }
                classFileWriter.add(21, n);
                classFileWriter.add(135);
                n = n2;
            }
            classFileWriter.addInvoke(183, "java/lang/Double", "<init>", "(D)V");
        }
        return n;
    }

    private static Class<?> getAdapterClass(Scriptable clazz, Class<?> clazz2, Class<?>[] classArray, Scriptable object) {
        ClassCache classCache = ClassCache.get((Scriptable)((Object)clazz));
        Map<JavaAdapterSignature, Class<?>> map = classCache.getInterfaceAdapterCacheMap();
        ObjToIntMap objToIntMap = JavaAdapter.getObjectFunctionNames((Scriptable)object);
        JavaAdapterSignature javaAdapterSignature = new JavaAdapterSignature(clazz2, classArray, objToIntMap);
        object = map.get(javaAdapterSignature);
        clazz = object;
        if (object == null) {
            clazz = new StringBuilder();
            ((StringBuilder)((Object)clazz)).append("adapter");
            ((StringBuilder)((Object)clazz)).append(classCache.newClassSerialNumber());
            clazz = ((StringBuilder)((Object)clazz)).toString();
            clazz = clazz2 = JavaAdapter.loadAdapterClass((String)((Object)clazz), JavaAdapter.createAdapterCode(objToIntMap, (String)((Object)clazz), clazz2, classArray, null));
            if (classCache.isCachingEnabled()) {
                map.put(javaAdapterSignature, clazz2);
                clazz = clazz2;
            }
        }
        return clazz;
    }

    public static Object getAdapterSelf(Class<?> clazz, Object object) throws NoSuchFieldException, IllegalAccessException {
        return clazz.getDeclaredField("self").get(object);
    }

    static int[] getArgsToConvert(Class<?>[] classArray) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 != classArray.length; ++n2) {
            n = n4;
            if (!classArray[n2].isPrimitive()) {
                n = n4 + 1;
            }
            n4 = n;
        }
        if (n4 == 0) {
            return null;
        }
        int[] nArray = new int[n4];
        n2 = 0;
        for (n = n3; n != classArray.length; ++n) {
            n4 = n2;
            if (!classArray[n].isPrimitive()) {
                nArray[n2] = n;
                n4 = n2 + 1;
            }
            n2 = n4;
        }
        return nArray;
    }

    public static Function getFunction(Scriptable object, String string2) {
        if ((object = ScriptableObject.getProperty((Scriptable)object, string2)) == Scriptable.NOT_FOUND) {
            return null;
        }
        if (object instanceof Function) {
            return (Function)object;
        }
        throw ScriptRuntime.notFunctionError(object, string2);
    }

    private static String getMethodSignature(Method method, Class<?>[] classArray) {
        StringBuilder stringBuilder = new StringBuilder();
        JavaAdapter.appendMethodSignature(classArray, method.getReturnType(), stringBuilder);
        return stringBuilder.toString();
    }

    private static ObjToIntMap getObjectFunctionNames(Scriptable scriptable) {
        Object[] objectArray = ScriptableObject.getPropertyIds(scriptable);
        ObjToIntMap objToIntMap = new ObjToIntMap(objectArray.length);
        for (int i = 0; i != objectArray.length; ++i) {
            int n;
            String string2;
            Object object;
            if (!(objectArray[i] instanceof String) || !((object = ScriptableObject.getProperty(scriptable, string2 = (String)objectArray[i])) instanceof Function)) continue;
            int n2 = n = ScriptRuntime.toInt32(ScriptableObject.getProperty((Scriptable)((Function)object), "length"));
            if (n < 0) {
                n2 = 0;
            }
            objToIntMap.put(string2, n2);
        }
        return objToIntMap;
    }

    static Method[] getOverridableMethods(Class<?> classArray) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        HashSet<String> hashSet = new HashSet<String>();
        Object object = classArray;
        while (true) {
            if (object == null) break;
            JavaAdapter.appendOverridableMethods(object, arrayList, hashSet);
            object = object.getSuperclass();
        }
        for (Object object2 = classArray; object2 != null; object2 = object2.getSuperclass()) {
            classArray = object2.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                JavaAdapter.appendOverridableMethods(classArray[i], arrayList, hashSet);
            }
        }
        return arrayList.toArray(new Method[arrayList.size()]);
    }

    public static void init(Context object, Scriptable scriptable, boolean bl) {
        object = new IdFunctionObject(new JavaAdapter(), FTAG, 1, "JavaAdapter", 1, scriptable);
        ((IdFunctionObject)object).markAsConstructor(null);
        if (bl) {
            ((ScriptableObject)object).sealObject();
        }
        ((IdFunctionObject)object).exportAsScopeProperty();
    }

    /*
     * Unable to fully structure code
     */
    static Object js_createAdapter(Context var0, Scriptable var1_2, Object[] var2_3) {
        block12: {
            block13: {
                var3_4 = var2_3.length;
                if (var3_4 == 0) break block12;
                for (var4_5 = 0; var4_5 < var3_4 - 1 && !((var5_6 = var2_3[var4_5]) instanceof NativeObject); ++var4_5) {
                    if (var5_6 instanceof NativeJavaClass) {
                        continue;
                    }
                    throw ScriptRuntime.typeError2("msg.not.java.class.arg", String.valueOf(var4_5), ScriptRuntime.toString(var5_6));
                }
                var5_6 = null;
                var6_7 = new Class[var4_5];
                var8_9 = 0;
                for (var7_8 = 0; var7_8 < var4_5; ++var7_8) {
                    var9_10 = ((NativeJavaClass)var2_3[var7_8]).getClassObject();
                    if (!var9_10.isInterface()) {
                        if (var5_6 == null) {
                            var5_6 = var9_10;
                            continue;
                        }
                        throw ScriptRuntime.typeError2("msg.only.one.super", var5_6.getName(), var9_10.getName());
                    }
                    var6_7[var8_9] = var9_10;
                    ++var8_9;
                }
                var9_10 = var5_6;
                if (var5_6 == null) {
                    var9_10 = ScriptRuntime.ObjectClass;
                }
                var5_6 = new Class[var8_9];
                System.arraycopy(var6_7, 0, var5_6, 0, var8_9);
                var6_7 = ScriptableObject.ensureScriptable(var2_3[var4_5]);
                var5_6 = JavaAdapter.getAdapterClass(var1_2, var9_10, var5_6, (Scriptable)var6_7);
                var7_8 = var3_4 - var4_5 - 1;
                if (var7_8 <= 0) ** GOTO lbl46
                try {
                    var9_10 = new Object[var7_8 + 2];
                    var9_10[0] = var6_7;
                }
                catch (Exception var0_1) {
                    throw Context.throwAsScriptRuntimeEx(var0_1);
                }
                var9_10[1] = var0.getFactory();
                System.arraycopy(var2_3, var4_5 + 1, var9_10, 2, var7_8);
                var6_7 = new NativeJavaClass(var1_2, (Class<?>)var5_6, true);
                var6_7 = var6_7.members.ctors;
                var4_5 = var6_7.findCachedFunction((Context)var0, var9_10);
                if (var4_5 < 0) ** GOTO lbl44
                var0 = NativeJavaClass.constructInternal(var9_10, var6_7.methods[var4_5]);
                break block13;
lbl44:
                // 1 sources

                var0 = NativeJavaMethod.scriptSignature(var2_3);
                throw Context.reportRuntimeError2("msg.no.java.ctor", var5_6.getName(), var0);
lbl46:
                // 1 sources

                var2_3 = ScriptRuntime.ScriptableClass;
                var9_10 = ScriptRuntime.ContextFactoryClass;
                var0 = var0.getFactory();
                var0 = var5_6.getConstructor(new Class[]{var2_3, var9_10}).newInstance(new Object[]{var6_7, var0});
            }
            var2_3 = JavaAdapter.getAdapterSelf(var5_6, var0);
            if (var2_3 instanceof Wrapper && (var0 = ((Wrapper)var2_3).unwrap()) instanceof Scriptable) {
                if (var0 instanceof ScriptableObject) {
                    ScriptRuntime.setObjectProtoAndParent((ScriptableObject)var0, var1_2);
                }
                return var0;
            }
            return var2_3;
        }
        throw ScriptRuntime.typeError0("msg.adapter.zero.args");
    }

    /*
     * Unable to fully structure code
     */
    static Class<?> loadAdapterClass(String var0, byte[] var1_1) {
        var2_2 = SecurityController.getStaticSecurityDomainClass();
        if (var2_2 != CodeSource.class && var2_2 != ProtectionDomain.class) {
            while (true) {
                var3_3 = null;
                break;
            }
        } else {
            var4_4 = var3_3 = SecurityUtilities.getScriptProtectionDomain();
            if (var3_3 == null) {
                var4_4 = JavaAdapter.class.getProtectionDomain();
            }
            var3_3 = var4_4;
            if (var2_2 == CodeSource.class) {
                if (var4_4 == null) ** continue;
                var3_3 = var4_4.getCodeSource();
            }
        }
        var4_4 = SecurityController.createLoader(null, var3_3);
        var0 = var4_4.defineClass((String)var0, var1_1);
        var4_4.linkClass((Class<?>)var0);
        return var0;
    }

    public static Object readAdapterObject(Scriptable scriptable, ObjectInputStream object) throws IOException, ClassNotFoundException {
        Object object2 = Context.getCurrentContext();
        object2 = object2 != null ? ((Context)object2).getFactory() : null;
        Class<?> clazz = Class.forName((String)((ObjectInputStream)object).readObject());
        Object object3 = (String[])((ObjectInputStream)object).readObject();
        Object object4 = new Class[((String[])object3).length];
        for (int i = 0; i < ((String[])object3).length; ++i) {
            object4[i] = Class.forName(object3[i]);
        }
        object = (Scriptable)((ObjectInputStream)object).readObject();
        clazz = JavaAdapter.getAdapterClass(scriptable, clazz, object4, (Scriptable)object);
        object4 = ScriptRuntime.ContextFactoryClass;
        Class<Scriptable> clazz2 = ScriptRuntime.ScriptableClass;
        object3 = ScriptRuntime.ScriptableClass;
        try {
            scriptable = clazz.getConstructor(new Class[]{object4, clazz2, object3}).newInstance(object2, object, scriptable);
            return scriptable;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new ClassNotFoundException("adapter");
        }
    }

    public static Scriptable runScript(final Script script) {
        return (Scriptable)ContextFactory.getGlobal().call(new ContextAction(){

            @Override
            public Object run(Context context) {
                ScriptableObject scriptableObject = ScriptRuntime.getGlobal(context);
                script.exec(context, scriptableObject);
                return scriptableObject;
            }
        });
    }

    public static void writeAdapterObject(Object object, ObjectOutputStream objectOutputStream) throws IOException {
        Class<?> clazz = object.getClass();
        objectOutputStream.writeObject(clazz.getSuperclass().getName());
        Class<?>[] classArray = clazz.getInterfaces();
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = classArray[i].getName();
        }
        objectOutputStream.writeObject(stringArray);
        try {
            objectOutputStream.writeObject(clazz.getField("delegee").get(object));
            return;
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            throw new IOException();
        }
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (idFunctionObject.hasTag(FTAG) && idFunctionObject.methodId() == 1) {
            return JavaAdapter.js_createAdapter(context, scriptable, objectArray);
        }
        throw idFunctionObject.unknown();
    }

    static class JavaAdapterSignature {
        Class<?>[] interfaces;
        ObjToIntMap names;
        Class<?> superClass;

        JavaAdapterSignature(Class<?> clazz, Class<?>[] classArray, ObjToIntMap objToIntMap) {
            this.superClass = clazz;
            this.interfaces = classArray;
            this.names = objToIntMap;
        }

        public boolean equals(Object object) {
            int n;
            if (!(object instanceof JavaAdapterSignature)) {
                return false;
            }
            object = (JavaAdapterSignature)object;
            if (this.superClass != ((JavaAdapterSignature)object).superClass) {
                return false;
            }
            Object object2 = this.interfaces;
            Object object3 = ((JavaAdapterSignature)object).interfaces;
            if (object2 != object3) {
                if (((Class<?>[])object2).length != ((Class<?>[])object3).length) {
                    return false;
                }
                for (n = 0; n < ((Class<?>[])(object3 = this.interfaces)).length; ++n) {
                    if (object3[n] == ((JavaAdapterSignature)object).interfaces[n]) continue;
                    return false;
                }
            }
            if (this.names.size() != ((JavaAdapterSignature)object).names.size()) {
                return false;
            }
            object2 = new ObjToIntMap.Iterator(this.names);
            ((ObjToIntMap.Iterator)object2).start();
            while (!((ObjToIntMap.Iterator)object2).done()) {
                object3 = (String)((ObjToIntMap.Iterator)object2).getKey();
                n = ((ObjToIntMap.Iterator)object2).getValue();
                if (n != ((JavaAdapterSignature)object).names.get(object3, n + 1)) {
                    return false;
                }
                ((ObjToIntMap.Iterator)object2).next();
            }
            return true;
        }

        public int hashCode() {
            return this.superClass.hashCode() + Arrays.hashCode(this.interfaces) ^ this.names.size();
        }
    }
}

