/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.BeanProperty;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.FieldAndMethods;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeJavaConstructor;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

class JavaMembers {
    private Class<?> cl;
    NativeJavaMethod ctors;
    private Map<String, FieldAndMethods> fieldAndMethods;
    private Map<String, Object> members;
    private Map<String, FieldAndMethods> staticFieldAndMethods;
    private Map<String, Object> staticMembers;

    JavaMembers(Scriptable scriptable, Class<?> clazz) {
        this(scriptable, clazz, false);
    }

    JavaMembers(Scriptable scriptable, Class<?> clazz, boolean bl) {
        try {
            Context context = ContextFactory.getGlobal().enterContext();
            HashMap<String, Object> hashMap = context.getClassShutter();
            if (hashMap != null && !hashMap.visibleToScripts(clazz.getName())) {
                throw Context.reportRuntimeError1("msg.access.prohibited", clazz.getName());
            }
            hashMap = new HashMap<String, Object>();
            this.members = hashMap;
            hashMap = new HashMap<String, Object>();
            this.staticMembers = hashMap;
            this.cl = clazz;
            this.reflect(scriptable, bl, context.hasFeature(13));
            return;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static void discoverAccessibleMethods(Class<?> var0, Map<MethodSignature, Method> var1_2, boolean var2_3, boolean var3_4) {
        block29: {
            block31: {
                block32: {
                    block30: {
                        var4_5 = Modifier.isPublic(var0.getModifiers());
                        var5_6 = 0;
                        if (var4_5) break block30;
                        var6_7 = var0;
                        if (!var3_4) ** GOTO lbl-1000
                    }
                    var6_7 = var0;
                    if (var2_3) break block31;
                    if (!var3_4) break block32;
                    var6_7 = var0;
                    break block31;
                }
                var6_7 = var0;
                var7_9 /* !! */  = var0.getMethods();
                var6_7 = var0;
                ** try [egrp 1[TRYBLOCK] [1 : 53->58)] { 
lbl18:
                // 3 sources

                for (Method[] var10_12 : var7_9 /* !! */ ) {
                    var6_7 = var0;
                    var6_7 = var0;
                    var11_13 = new MethodSignature((Method)var10_12 /* !! */ );
                    var6_7 = var0;
                    if (var1_2.containsKey(var11_13)) continue;
                    var6_7 = var0;
                    var1_2.put(var11_13, (Method)var10_12 /* !! */ );
                }
                break block29;
            }
            while ((var0 = var6_7) != null) {
                ** try [egrp 6[TRYBLOCK] [6 : 134->145)] { 
lbl35:
                // 4 sources

                for (Object var6_7 : var0.getDeclaredMethods()) {
                    var12_14 = var6_7.getModifiers();
                    if (!Modifier.isPublic(var12_14) && !Modifier.isProtected(var12_14) && !var3_4) continue;
                    var11_13 = new MethodSignature((Method)var6_7);
                    if (var1_2.containsKey(var11_13)) continue;
                    if (!var3_4) ** GOTO lbl46
                    if (!var6_7.isAccessible()) {
                        var6_7.setAccessible(true);
                    }
lbl46:
                    // 4 sources

                    var1_2.put(var11_13, (Method)var6_7);
                }
                var6_7 = var0.getInterfaces();
                var8_10 = ((Object)var6_7).length;
                for (var9_11 = 0; var9_11 < var8_10; ++var9_11) {
                    JavaMembers.discoverAccessibleMethods(var6_7[var9_11], var1_2, var2_3, var3_4);
                    continue;
                }
                try {
                    var6_7 = var0.getSuperclass();
                    continue;
                }
lbl59:
                // 7 sources

                catch (SecurityException var6_8) {
                    var6_7 = var0;
                    var10_12 /* !! */  = var0.getMethods();
                    var6_7 = var0;
                    var8_10 = var10_12 /* !! */ .length;
                    for (var9_11 = 0; var9_11 < var8_10; ++var9_11) {
                        var7_9 /* !! */  = var10_12 /* !! */ [var9_11];
                        var6_7 = var0;
                        var6_7 = var0;
                        try {
                            var11_13 = new MethodSignature((Method)var7_9 /* !! */ );
                            var6_7 = var0;
                        }
lbl73:
                        // 10 sources

                        catch (SecurityException var0_1) {
                            var0 = new StringBuilder();
                            var0.append("Could not discover accessible methods of class ");
                            var0.append(var6_7.getName());
                            var0.append(" due to lack of privileges, attemping superclasses/interfaces.");
                            Context.reportWarning(var0.toString());
                        }
                        if (var1_2.containsKey(var11_13)) continue;
                        var6_7 = var0;
                        var1_2.put(var11_13, (Method)var7_9 /* !! */ );
                    }
                    break;
                }
lbl-1000:
                // 2 sources

                {
                    var0 = var6_7.getInterfaces();
                    var8_10 = ((Class<?>[])var0).length;
                    for (var9_11 = var5_6; var9_11 < var8_10; ++var9_11) {
                        JavaMembers.discoverAccessibleMethods(var0[var9_11], var1_2, var2_3, var3_4);
                    }
                    var0 = var6_7.getSuperclass();
                    if (var0 != null) {
                        JavaMembers.discoverAccessibleMethods(var0, var1_2, var2_3, var3_4);
                        break;
                    }
                    break;
                    break;
                }
                break;
            }
        }
    }

    private static Method[] discoverAccessibleMethods(Class<?> clazz, boolean bl, boolean bl2) {
        HashMap<MethodSignature, Method> hashMap = new HashMap<MethodSignature, Method>();
        JavaMembers.discoverAccessibleMethods(clazz, hashMap, bl, bl2);
        return hashMap.values().toArray(new Method[hashMap.size()]);
    }

    private static MemberBox extractGetMethod(MemberBox[] memberBoxArray, boolean bl) {
        for (MemberBox memberBox : memberBoxArray) {
            if (memberBox.argTypes.length != 0 || bl && !memberBox.isStatic()) continue;
            if (memberBox.method().getReturnType() == Void.TYPE) break;
            return memberBox;
        }
        return null;
    }

    private static MemberBox extractSetMethod(Class<?> clazz, MemberBox[] memberBoxArray, boolean bl) {
        for (int i = 1; i <= 2; ++i) {
            for (MemberBox memberBox : memberBoxArray) {
                Class<?>[] classArray;
                if (bl && !memberBox.isStatic() || (classArray = memberBox.argTypes).length != 1) continue;
                if (i == 1) {
                    if (classArray[0] != clazz) continue;
                    return memberBox;
                }
                if (i != 2) {
                    Kit.codeBug();
                }
                if (!classArray[0].isAssignableFrom(clazz)) continue;
                return memberBox;
            }
        }
        return null;
    }

    private static MemberBox extractSetMethod(MemberBox[] memberBoxArray, boolean bl) {
        for (MemberBox memberBox : memberBoxArray) {
            if (bl && !memberBox.isStatic() || memberBox.method().getReturnType() != Void.TYPE || memberBox.argTypes.length != 1) continue;
            return memberBox;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private MemberBox findExplicitFunction(String string2, boolean bl) {
        void var4_14;
        Object object;
        int n = string2.indexOf(40);
        if (n < 0) {
            return null;
        }
        if (bl) {
            Map<String, Object> object2 = this.staticMembers;
        } else {
            Map<String, Object> map = this.members;
        }
        int n2 = bl && n == 0 ? 1 : 0;
        if (n2 != 0) {
            MemberBox[] memberBoxArray = this.ctors.methods;
        } else {
            void var4_11;
            void var4_6;
            String string3 = string2.substring(0, n);
            object = var4_6.get(string3);
            Object v = object;
            if (!bl) {
                Object v2 = object;
                if (object == null) {
                    Object object2 = this.staticMembers.get(string3);
                }
            }
            if (var4_11 instanceof NativeJavaMethod) {
                MemberBox[] memberBoxArray = ((NativeJavaMethod)var4_11).methods;
            } else {
                Object var4_13 = null;
            }
        }
        if (var4_14 != null) {
            for (void var6_18 : var4_14) {
                object = JavaMembers.liveConnectSignature(var6_18.argTypes);
                if (((String)object).length() + n != string2.length() || !string2.regionMatches(n, (String)object, 0, ((String)object).length())) continue;
                return var6_18;
            }
        }
        return null;
    }

    private MemberBox findGetter(boolean bl, Map<String, Object> object, String string2, String string3) {
        if (object.containsKey(string2 = string2.concat(string3)) && (object = object.get(string2)) instanceof NativeJavaMethod) {
            return JavaMembers.extractGetMethod(((NativeJavaMethod)object).methods, bl);
        }
        return null;
    }

    private Constructor<?>[] getAccessibleConstructors(boolean bl) {
        if (bl && this.cl != ScriptRuntime.ClassClass) {
            try {
                AccessibleObject[] accessibleObjectArray = this.cl.getDeclaredConstructors();
                AccessibleObject.setAccessible(accessibleObjectArray, true);
                return accessibleObjectArray;
            }
            catch (SecurityException securityException) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Could not access constructor  of class ");
                stringBuilder.append(this.cl.getName());
                stringBuilder.append(" due to lack of privileges.");
                Context.reportWarning(stringBuilder.toString());
            }
        }
        return this.cl.getConstructors();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Field[] getAccessibleFields(boolean bl, boolean bl2) {
        if (!bl2) {
            if (!bl) return this.cl.getFields();
        }
        try {
            ArrayList<Field> arrayList = new ArrayList<Field>();
            Object object = this.cl;
            while (object != null) {
                for (Field field : object.getDeclaredFields()) {
                    int n = field.getModifiers();
                    if (!bl2 && !Modifier.isPublic(n) && !Modifier.isProtected(n)) continue;
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    arrayList.add(field);
                }
                object = object.getSuperclass();
            }
            return arrayList.toArray(new Field[arrayList.size()]);
        }
        catch (SecurityException securityException) {
            return this.cl.getFields();
        }
    }

    private Object getExplicitFunction(Scriptable object, String string2, Object object2, boolean bl) {
        Map<String, Object> map = bl ? this.staticMembers : this.members;
        object2 = null;
        MemberBox memberBox = this.findExplicitFunction(string2, bl);
        if (memberBox != null) {
            Scriptable scriptable = ScriptableObject.getFunctionPrototype((Scriptable)object);
            if (memberBox.isCtor()) {
                object2 = new NativeJavaConstructor(memberBox);
                ((ScriptableObject)object2).setPrototype(scriptable);
                map.put(string2, object2);
            } else {
                object2 = object = map.get(memberBox.getName());
                if (object instanceof NativeJavaMethod) {
                    object2 = object;
                    if (((NativeJavaMethod)object).methods.length > 1) {
                        object2 = new NativeJavaMethod(memberBox, string2);
                        ((ScriptableObject)object2).setPrototype(scriptable);
                        map.put(string2, object2);
                    }
                }
            }
        }
        return object2;
    }

    static String javaSignature(Class<?> serializable) {
        int n;
        Object object;
        if (!((Class)serializable).isArray()) {
            return ((Class)serializable).getName();
        }
        int n2 = 0;
        do {
            n = n2 + 1;
            object = ((Class)serializable).getComponentType();
            n2 = n;
            serializable = object;
        } while (((Class)object).isArray());
        object = ((Class)object).getName();
        if (n == 1) {
            return ((String)object).concat("[]");
        }
        serializable = new StringBuilder(((String)object).length() + n * 2);
        ((StringBuilder)serializable).append((String)object);
        while (n != 0) {
            --n;
            ((StringBuilder)serializable).append("[]");
        }
        return ((StringBuilder)serializable).toString();
    }

    static String liveConnectSignature(Class<?>[] classArray) {
        int n = classArray.length;
        if (n == 0) {
            return "()";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int i = 0; i != n; ++i) {
            if (i != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(JavaMembers.javaSignature(classArray[i]));
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    static JavaMembers lookupClass(Scriptable object, Class<?> clazz, Class<?> clazz2, boolean bl) {
        ClassCache classCache = ClassCache.get((Scriptable)object);
        Map<Class<?>, JavaMembers> map = classCache.getClassCacheMap();
        object = clazz;
        while (true) {
            Class<?> clazz3;
            if ((clazz3 = map.get(object)) != null) {
                if (object != clazz) {
                    map.put(clazz, (JavaMembers)((Object)clazz3));
                }
                return clazz3;
            }
            try {
                clazz3 = new JavaMembers(classCache.getAssociatedScope(), (Class<?>)object, bl);
            }
            catch (SecurityException securityException) {
                if (clazz2 != null && clazz2.isInterface()) {
                    object = clazz2;
                    clazz2 = null;
                    continue;
                }
                Class clazz4 = ((Class)object).getSuperclass();
                clazz3 = clazz4;
                if (clazz4 == null) {
                    if (((Class)object).isInterface()) {
                        clazz3 = ScriptRuntime.ObjectClass;
                    } else {
                        throw securityException;
                    }
                }
                object = clazz3;
                continue;
            }
            if (classCache.isCachingEnabled()) {
                map.put((Class<?>)object, (JavaMembers)((Object)clazz3));
                if (object != clazz) {
                    map.put(clazz, (JavaMembers)((Object)clazz3));
                }
            }
            return clazz3;
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void reflect(Scriptable var1_1, boolean var2_2, boolean var3_3) {
        var4_4 = JavaMembers.discoverAccessibleMethods(this.cl, var2_2, var3_3);
        var5_5 = ((Method[])var4_4).length;
        var6_6 = 0;
        for (var7_7 = 0; var7_7 < var5_5; ++var7_7) {
            var8_8 = var4_4[var7_7];
            var9_9 = Modifier.isStatic(var8_8.getModifiers()) != false ? this.staticMembers : this.members;
            var11_12 = var9_9.get(var10_11 /* !! */  = var8_8.getName());
            if (var11_12 == null) {
                var9_9.put((String)var10_11 /* !! */ , (Object)var8_8);
                continue;
            }
            if (var11_12 instanceof ObjArray) {
                var9_9 = (ObjArray)var11_12;
            } else {
                if (!(var11_12 instanceof Method)) {
                    Kit.codeBug();
                }
                var12_13 /* !! */  = new ObjArray();
                var12_13 /* !! */ .add(var11_12);
                var9_9.put(var10_11 /* !! */ , var12_13 /* !! */ );
                var9_9 = var12_13 /* !! */ ;
            }
            var9_9.add(var8_8);
        }
        for (var7_7 = 0; var7_7 != 2; ++var7_7) {
            var5_5 = var7_7 == 0 ? 1 : 0;
            var9_9 = var5_5 != 0 ? this.staticMembers : this.members;
            for (Object var4_4 : var9_9.entrySet()) {
                var10_11 /* !! */  = var4_4.getValue();
                if (var10_11 /* !! */  instanceof Method) {
                    var12_13 /* !! */  = new MemberBox[]{new MemberBox((Method)var10_11 /* !! */ )};
                } else {
                    var13_14 = (var10_11 /* !! */  = (ObjArray)var10_11 /* !! */ ).size();
                    if (var13_14 < 2) {
                        Kit.codeBug();
                    }
                    var12_13 /* !! */  = new MemberBox[var13_14];
                    for (var5_5 = 0; var5_5 != var13_14; ++var5_5) {
                        var12_13 /* !! */ [var5_5] = new MemberBox((Method)var10_11 /* !! */ .get(var5_5));
                    }
                }
                var12_13 /* !! */  = new NativeJavaMethod(var12_13 /* !! */ );
                if (var1_1 != null) {
                    ScriptRuntime.setFunctionProtoAndParent((BaseFunction)var12_13 /* !! */ , (Scriptable)var1_1);
                }
                var9_9.put(var4_4.getKey(), var12_13 /* !! */ );
            }
        }
        var10_11 /* !! */  = this.getAccessibleFields(var2_2, var3_3);
        var5_5 = var10_11 /* !! */ .length;
        for (var7_7 = 0; var7_7 < var5_5; ++var7_7) {
            block34: {
                block33: {
                    var9_9 = var10_11 /* !! */ [var7_7];
                    var8_8 = var9_9.getName();
                    var13_14 = var9_9.getModifiers();
                    var2_2 = Modifier.isStatic(var13_14);
                    if (!var2_2) ** GOTO lbl60
                    var12_13 /* !! */  = this.staticMembers;
                    break block33;
lbl60:
                    // 1 sources

                    var12_13 /* !! */  = this.members;
                }
                var4_4 = var12_13 /* !! */ .get(var8_8);
                if (var4_4 != null) ** GOTO lbl68
                var12_13 /* !! */ .put(var8_8, var9_9);
                continue;
lbl68:
                // 1 sources

                if (!(var4_4 instanceof NativeJavaMethod)) ** GOTO lbl92
                var4_4 = (NativeJavaMethod)var4_4;
                var11_12 = new FieldAndMethods((Scriptable)var1_1, var4_4.methods, (Field)var9_9);
                if (!var2_2) ** GOTO lbl75
                var9_9 = this.staticFieldAndMethods;
                break block34;
lbl75:
                // 1 sources

                var9_9 = this.fieldAndMethods;
            }
            var4_4 = var9_9;
            if (var9_9 != null) ** GOTO lbl86
            var4_4 = new HashMap();
            if (!var2_2) ** GOTO lbl85
            try {
                block35: {
                    this.staticFieldAndMethods = var4_4;
                    break block35;
lbl85:
                    // 1 sources

                    this.fieldAndMethods = var4_4;
                }
                var4_4.put(var8_8, var11_12);
                var12_13 /* !! */ .put(var8_8, var11_12);
                continue;
lbl92:
                // 1 sources

                if (var4_4 instanceof Field) {
                    if (!((Field)var4_4).getDeclaringClass().isAssignableFrom(var9_9.getDeclaringClass())) continue;
                    var12_13 /* !! */ .put(var8_8, var9_9);
                    continue;
                }
                Kit.codeBug();
                continue;
            }
            catch (SecurityException var9_10) {
                var9_9 = new StringBuilder();
                var9_9.append("Could not access field ");
                var9_9.append((String)var8_8);
                var9_9.append(" of class ");
                var9_9.append(this.cl.getName());
                var9_9.append(" due to lack of privileges.");
                Context.reportWarning(var9_9.toString());
            }
        }
        for (var7_7 = 0; var7_7 != 2; ++var7_7) {
            var2_2 = var7_7 == 0;
            var4_4 = var2_2 != false ? this.staticMembers : this.members;
            var10_11 /* !! */  = new HashMap<K, V>();
            for (Object var1_1 : var4_4.keySet()) {
                var14_15 = var1_1.startsWith("get");
                var15_16 = var1_1.startsWith("set");
                var16_17 = var1_1.startsWith("is");
                if (!var14_15 && !var16_17 && !var15_16) continue;
                var5_5 = var16_17 != false ? 2 : 3;
                var9_9 = var1_1.substring(var5_5);
                if (var9_9.length() == 0) continue;
                var17_18 = var9_9.charAt(0);
                if (!Character.isUpperCase(var17_18)) ** GOTO lbl-1000
                if (var9_9.length() == 1) {
                    var1_1 = var9_9.toLowerCase();
                } else if (!Character.isUpperCase(var9_9.charAt(1))) {
                    var1_1 = new StringBuilder();
                    var1_1.append(Character.toLowerCase(var17_18));
                    var1_1.append(var9_9.substring(1));
                    var1_1 = var1_1.toString();
                } else lbl-1000:
                // 2 sources

                {
                    var1_1 = var9_9;
                }
                if (var10_11 /* !! */ .containsKey(var1_1) || (var12_13 /* !! */  = var4_4.get(var1_1)) != null && (!var3_3 || !(var12_13 /* !! */  instanceof Member) || !Modifier.isPrivate(((Member)var12_13 /* !! */ ).getModifiers()))) continue;
                var12_13 /* !! */  = this.findGetter(var2_2, (Map<String, Object>)var4_4, "get", (String)var9_9);
                var8_8 = var12_13 /* !! */ ;
                if (var12_13 /* !! */  == null) {
                    var8_8 = this.findGetter(var2_2, (Map<String, Object>)var4_4, "is", (String)var9_9);
                }
                var12_13 /* !! */  = "set".concat((String)var9_9);
                var15_16 = var4_4.containsKey(var12_13 /* !! */ );
                var9_9 = null;
                if (var15_16 && (var12_13 /* !! */  = var4_4.get(var12_13 /* !! */ )) instanceof NativeJavaMethod) {
                    var12_13 /* !! */  = (NativeJavaMethod)var12_13 /* !! */ ;
                    var9_9 = var8_8 != null ? JavaMembers.extractSetMethod(var8_8.method().getReturnType(), var12_13 /* !! */ .methods, var2_2) : JavaMembers.extractSetMethod(var12_13 /* !! */ .methods, var2_2);
                    if (var12_13 /* !! */ .methods.length <= 1) {
                        var12_13 /* !! */  = null;
                    }
                } else {
                    var12_13 /* !! */  = null;
                }
                var10_11 /* !! */ .put(var1_1, new BeanProperty((MemberBox)var8_8, (MemberBox)var9_9, (NativeJavaMethod)var12_13 /* !! */ ));
            }
            var1_1 = var10_11 /* !! */ .keySet().iterator();
            while (var1_1.hasNext()) {
                var9_9 = (String)var1_1.next();
                var4_4.put(var9_9, var10_11 /* !! */ .get(var9_9));
            }
        }
        var1_1 = this.getAccessibleConstructors(var3_3);
        var9_9 = new MemberBox[((Constructor<?>[])var1_1).length];
        for (var7_7 = var6_6; var7_7 != ((Constructor<?>[])var1_1).length; ++var7_7) {
            var9_9[var7_7] = new MemberBox(var1_1[var7_7]);
        }
        this.ctors = new NativeJavaMethod((MemberBox[])var9_9, this.cl.getSimpleName());
    }

    Object get(Scriptable scriptable, String object, Object clazz, boolean bl) {
        Map<String, Object> map;
        block10: {
            Object object2;
            block11: {
                map = bl ? this.staticMembers : this.members;
                map = object2 = map.get(object);
                if (!bl) {
                    map = object2;
                    if (object2 == null) {
                        map = this.staticMembers.get(object);
                    }
                }
                object2 = map;
                if (map == null) {
                    object2 = object = this.getExplicitFunction(scriptable, (String)object, clazz, bl);
                    if (object == null) {
                        return Scriptable.NOT_FOUND;
                    }
                }
                if (object2 instanceof Scriptable) {
                    return object2;
                }
                map = Context.getContext();
                try {
                    if (object2 instanceof BeanProperty) {
                        object2 = (BeanProperty)object2;
                        if (((BeanProperty)object2).getter == null) {
                            return Scriptable.NOT_FOUND;
                        }
                        object = ((BeanProperty)object2).getter.invoke(clazz, Context.emptyArgs);
                        clazz = ((BeanProperty)object2).getter.method().getReturnType();
                        break block10;
                    }
                    object2 = (Field)object2;
                    if (!bl) break block11;
                    clazz = null;
                }
                catch (Exception exception) {
                    throw Context.throwAsScriptRuntimeEx(exception);
                }
            }
            object = ((Field)object2).get(clazz);
            clazz = ((Field)object2).getType();
        }
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        return ((Context)((Object)map)).getWrapFactory().wrap((Context)((Object)map), scriptable, object, clazz);
    }

    /*
     * WARNING - void declaration
     */
    Map<String, FieldAndMethods> getFieldAndMethodsObjects(Scriptable scriptable, Object object, boolean bl) {
        void var4_6;
        if (bl) {
            Map<String, FieldAndMethods> map2 = this.staticFieldAndMethods;
        } else {
            Map<String, FieldAndMethods> map = this.fieldAndMethods;
        }
        if (var4_6 == null) {
            return null;
        }
        HashMap<String, FieldAndMethods> hashMap = new HashMap<String, FieldAndMethods>(var4_6.size());
        for (FieldAndMethods fieldAndMethods : var4_6.values()) {
            FieldAndMethods fieldAndMethods2 = new FieldAndMethods(scriptable, fieldAndMethods.methods, fieldAndMethods.field);
            fieldAndMethods2.javaObject = object;
            hashMap.put(fieldAndMethods.field.getName(), fieldAndMethods2);
        }
        return hashMap;
    }

    Object[] getIds(boolean bl) {
        Map<String, Object> map = bl ? this.staticMembers : this.members;
        return map.keySet().toArray(new Object[map.size()]);
    }

    boolean has(String string2, boolean bl) {
        Map<String, Object> map = bl ? this.staticMembers : this.members;
        map = map.get(string2);
        boolean bl2 = true;
        if (map != null) {
            return true;
        }
        bl = this.findExplicitFunction(string2, bl) != null ? bl2 : false;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void put(Scriptable object, String object2, Object object3, Object object4, boolean bl) {
        Object object5;
        Map<String, Object> map = bl ? this.staticMembers : this.members;
        Object object6 = object5 = map.get(object2);
        if (!bl) {
            object6 = object5;
            if (object5 == null) {
                object6 = this.staticMembers.get(object2);
            }
        }
        if (object6 == null) throw this.reportMemberNotFound((String)object2);
        object5 = object6;
        if (object6 instanceof FieldAndMethods) {
            object5 = ((FieldAndMethods)map.get((Object)object2)).field;
        }
        if (object5 instanceof BeanProperty) {
            object6 = (BeanProperty)object5;
            if (((BeanProperty)object6).setter == null) throw this.reportMemberNotFound((String)object2);
            if (((BeanProperty)object6).setters != null && object4 != null) {
                ((BeanProperty)object6).setters.call(Context.getContext(), ScriptableObject.getTopLevelScope((Scriptable)object), (Scriptable)object, new Object[]{object4});
                return;
            }
            object = Context.jsToJava(object4, ((BeanProperty)object6).setter.argTypes[0]);
            try {
                ((BeanProperty)object6).setter.invoke(object3, new Object[]{object});
                return;
            }
            catch (Exception exception) {
                throw Context.throwAsScriptRuntimeEx(exception);
            }
        }
        if (!(object5 instanceof Field)) {
            object = object5 == null ? "msg.java.internal.private" : "msg.java.method.assign";
            throw Context.reportRuntimeError1((String)object, object2);
        }
        object = (Field)object5;
        object2 = Context.jsToJava(object4, ((Field)object).getType());
        try {
            ((Field)object).set(object3, object2);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Context.reportRuntimeError3("msg.java.internal.field.type", object4.getClass().getName(), object, object3.getClass().getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            if ((((Field)object).getModifiers() & 0x10) == 0) throw Context.throwAsScriptRuntimeEx(illegalAccessException);
            return;
        }
    }

    RuntimeException reportMemberNotFound(String string2) {
        return Context.reportRuntimeError2("msg.java.member.not.found", this.cl.getName(), string2);
    }

    private static final class MethodSignature {
        private final Class<?>[] args;
        private final String name;

        private MethodSignature(String string2, Class<?>[] classArray) {
            this.name = string2;
            this.args = classArray;
        }

        MethodSignature(Method method) {
            this(method.getName(), method.getParameterTypes());
        }

        public boolean equals(Object object) {
            boolean bl;
            boolean bl2 = object instanceof MethodSignature;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (MethodSignature)object;
                bl3 = bl;
                if (((MethodSignature)object).name.equals(this.name)) {
                    bl3 = bl;
                    if (Arrays.equals(this.args, ((MethodSignature)object).args)) {
                        bl3 = true;
                    }
                }
            }
            return bl3;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.args.length;
        }
    }
}

