/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContinuationPending;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.VMBridge;

final class MemberBox
implements Serializable {
    private static final Class<?>[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};
    static final long serialVersionUID = 6358550398665688245L;
    transient Class<?>[] argTypes;
    transient Object delegateTo;
    private transient Member memberObject;
    transient boolean vararg;

    MemberBox(Constructor<?> constructor) {
        this.init(constructor);
    }

    MemberBox(Method method) {
        this.init(method);
    }

    private void init(Constructor<?> constructor) {
        this.memberObject = constructor;
        this.argTypes = constructor.getParameterTypes();
        this.vararg = constructor.isVarArgs();
    }

    private void init(Method method) {
        this.memberObject = method;
        this.argTypes = method.getParameterTypes();
        this.vararg = method.isVarArgs();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Member readMember(ObjectInputStream object) throws IOException, ClassNotFoundException {
        if (!((ObjectInputStream)object).readBoolean()) {
            return null;
        }
        boolean bl = ((ObjectInputStream)object).readBoolean();
        CharSequence charSequence = (String)((ObjectInputStream)object).readObject();
        Class clazz = (Class)((ObjectInputStream)object).readObject();
        Class<?>[] classArray = MemberBox.readParameters((ObjectInputStream)object);
        if (!bl) return clazz.getConstructor(classArray);
        try {
            return clazz.getMethod((String)charSequence, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("Cannot find member: ");
            ((StringBuilder)charSequence).append(noSuchMethodException);
            throw new IOException(((StringBuilder)charSequence).toString());
        }
    }

    private void readObject(ObjectInputStream object) throws IOException, ClassNotFoundException {
        ((ObjectInputStream)object).defaultReadObject();
        object = MemberBox.readMember((ObjectInputStream)object);
        if (object instanceof Method) {
            this.init((Method)object);
        } else {
            this.init((Constructor)object);
        }
    }

    private static Class<?>[] readParameters(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readShort();
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            classArray[i] = !objectInputStream.readBoolean() ? (Class)objectInputStream.readObject() : primitives[objectInputStream.readByte()];
        }
        return classArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Method searchAccessibleMethod(Method genericDeclaration, Class<?>[] classArray) {
        int n = ((Method)genericDeclaration).getModifiers();
        if (!Modifier.isPublic(n)) return null;
        if (Modifier.isStatic(n)) return null;
        Class<Object> clazz = ((Method)genericDeclaration).getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) return null;
        String string2 = ((Method)genericDeclaration).getName();
        Object object = clazz.getInterfaces();
        n = 0;
        int n2 = ((Class<?>[])object).length;
        while (true) {
            genericDeclaration = clazz;
            if (n == n2) break;
            genericDeclaration = object[n];
            if (Modifier.isPublic(((Class)genericDeclaration).getModifiers())) {
                try {
                    return ((Class)genericDeclaration).getMethod(string2, classArray);
                }
                catch (NoSuchMethodException | SecurityException exception) {}
            }
            ++n;
        }
        while ((clazz = ((Class)genericDeclaration).getSuperclass()) != null) {
            genericDeclaration = clazz;
            if (!Modifier.isPublic(clazz.getModifiers())) continue;
            try {
                object = clazz.getMethod(string2, classArray);
                n = ((Method)object).getModifiers();
                genericDeclaration = clazz;
                if (!Modifier.isPublic(n)) continue;
                boolean bl = Modifier.isStatic(n);
                genericDeclaration = clazz;
                if (bl) continue;
                return object;
            }
            catch (NoSuchMethodException | SecurityException exception) {
                genericDeclaration = clazz;
                continue;
            }
            break;
        }
        return null;
    }

    private static void writeMember(ObjectOutputStream objectOutputStream, Member member) throws IOException {
        if (member == null) {
            objectOutputStream.writeBoolean(false);
            return;
        }
        objectOutputStream.writeBoolean(true);
        boolean bl = member instanceof Method;
        if (!bl && !(member instanceof Constructor)) {
            throw new IllegalArgumentException("not Method or Constructor");
        }
        objectOutputStream.writeBoolean(bl);
        objectOutputStream.writeObject(member.getName());
        objectOutputStream.writeObject(member.getDeclaringClass());
        if (bl) {
            MemberBox.writeParameters(objectOutputStream, ((Method)member).getParameterTypes());
        } else {
            MemberBox.writeParameters(objectOutputStream, ((Constructor)member).getParameterTypes());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        MemberBox.writeMember(objectOutputStream, this.memberObject);
    }

    private static void writeParameters(ObjectOutputStream object, Class<?>[] classArray) throws IOException {
        ((ObjectOutputStream)object).writeShort(classArray.length);
        block0: for (int i = 0; i < classArray.length; ++i) {
            Class<?>[] classArray2;
            Class<?> clazz = classArray[i];
            boolean bl = clazz.isPrimitive();
            ((ObjectOutputStream)object).writeBoolean(bl);
            if (!bl) {
                ((ObjectOutputStream)object).writeObject(clazz);
                continue;
            }
            for (int j = 0; j < (classArray2 = primitives).length; ++j) {
                if (!clazz.equals(classArray2[j])) continue;
                ((ObjectOutputStream)object).writeByte(j);
                continue block0;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Primitive ");
            ((StringBuilder)object).append(clazz);
            ((StringBuilder)object).append(" not found");
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
    }

    Constructor<?> ctor() {
        return (Constructor)this.memberObject;
    }

    Class<?> getDeclaringClass() {
        return this.memberObject.getDeclaringClass();
    }

    String getName() {
        return this.memberObject.getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object invoke(Object object, Object[] objectArray) {
        Method method = this.method();
        try {
            try {
                return method.invoke(object, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                Method method2 = MemberBox.searchAccessibleMethod(method, this.argTypes);
                if (method2 != null) {
                    this.memberObject = method2;
                    method = method2;
                    return method.invoke(object, objectArray);
                }
                if (!VMBridge.instance.tryToMakeAccessible(method)) throw Context.throwAsScriptRuntimeEx(illegalAccessException);
                return method.invoke(object, objectArray);
            }
        }
        catch (Exception exception) {
            throw Context.throwAsScriptRuntimeEx(exception);
        }
        catch (InvocationTargetException invocationTargetException) {}
        do {
            Object[] objectArray2;
            objectArray2 = objectArray = ((InvocationTargetException)objectArray2).getTargetException();
        } while (objectArray instanceof InvocationTargetException);
        if (!(objectArray instanceof ContinuationPending)) throw Context.throwAsScriptRuntimeEx((Throwable)objectArray);
        throw (ContinuationPending)objectArray;
    }

    boolean isCtor() {
        return this.memberObject instanceof Constructor;
    }

    boolean isMethod() {
        return this.memberObject instanceof Method;
    }

    boolean isStatic() {
        return Modifier.isStatic(this.memberObject.getModifiers());
    }

    Member member() {
        return this.memberObject;
    }

    Method method() {
        return (Method)this.memberObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object newInstance(Object[] objectArray) {
        Constructor<?> constructor = this.ctor();
        try {
            try {
                return constructor.newInstance(objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!VMBridge.instance.tryToMakeAccessible(constructor)) throw Context.throwAsScriptRuntimeEx(illegalAccessException);
                return constructor.newInstance(objectArray);
            }
        }
        catch (Exception exception) {
            throw Context.throwAsScriptRuntimeEx(exception);
        }
    }

    String toJavaDeclaration() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isMethod()) {
            Method method = this.method();
            stringBuilder.append(method.getReturnType());
            stringBuilder.append(' ');
            stringBuilder.append(method.getName());
        } else {
            String string2 = this.ctor().getDeclaringClass().getName();
            int n = string2.lastIndexOf(46);
            String string3 = string2;
            if (n >= 0) {
                string3 = string2.substring(n + 1);
            }
            stringBuilder.append(string3);
        }
        stringBuilder.append(JavaMembers.liveConnectSignature(this.argTypes));
        return stringBuilder.toString();
    }

    public String toString() {
        return this.memberObject.toString();
    }
}

