/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeArrayIterator;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeString;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ScriptRuntimeES6;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Sorting;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.regexp.NativeRegExp;

public class NativeArray
extends IdScriptableObject
implements List {
    private static final Object ARRAY_TAG = "Array";
    private static final int ConstructorId_concat = -13;
    private static final int ConstructorId_every = -17;
    private static final int ConstructorId_filter = -18;
    private static final int ConstructorId_find = -22;
    private static final int ConstructorId_findIndex = -23;
    private static final int ConstructorId_forEach = -19;
    private static final int ConstructorId_indexOf = -15;
    private static final int ConstructorId_isArray = -26;
    private static final int ConstructorId_join = -5;
    private static final int ConstructorId_lastIndexOf = -16;
    private static final int ConstructorId_map = -20;
    private static final int ConstructorId_pop = -9;
    private static final int ConstructorId_push = -8;
    private static final int ConstructorId_reduce = -24;
    private static final int ConstructorId_reduceRight = -25;
    private static final int ConstructorId_reverse = -6;
    private static final int ConstructorId_shift = -10;
    private static final int ConstructorId_slice = -14;
    private static final int ConstructorId_some = -21;
    private static final int ConstructorId_sort = -7;
    private static final int ConstructorId_splice = -12;
    private static final int ConstructorId_unshift = -11;
    private static final Comparator<Object> DEFAULT_COMPARATOR;
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private static final double GROW_FACTOR = 1.5;
    private static final int Id_concat = 13;
    private static final int Id_constructor = 1;
    private static final int Id_every = 17;
    private static final int Id_filter = 18;
    private static final int Id_find = 22;
    private static final int Id_findIndex = 23;
    private static final int Id_forEach = 19;
    private static final int Id_indexOf = 15;
    private static final int Id_join = 5;
    private static final int Id_lastIndexOf = 16;
    private static final int Id_length = 1;
    private static final int Id_map = 20;
    private static final int Id_pop = 9;
    private static final int Id_push = 8;
    private static final int Id_reduce = 24;
    private static final int Id_reduceRight = 25;
    private static final int Id_reverse = 6;
    private static final int Id_shift = 10;
    private static final int Id_slice = 14;
    private static final int Id_some = 21;
    private static final int Id_sort = 7;
    private static final int Id_splice = 12;
    private static final int Id_toLocaleString = 3;
    private static final int Id_toSource = 4;
    private static final int Id_toString = 2;
    private static final int Id_unshift = 11;
    private static final int MAX_INSTANCE_ID = 1;
    private static final int MAX_PRE_GROW_SIZE = 0x55555554;
    private static final int MAX_PROTOTYPE_ID = 26;
    private static final Integer NEGATIVE_ONE;
    private static final Comparator<Object> STRING_COMPARATOR;
    private static final int SymbolId_iterator = 26;
    private static int maximumInitialCapacity = 0;
    static final long serialVersionUID = 7331366857676127338L;
    private Object[] dense;
    private boolean denseOnly;
    private long length;
    private int lengthAttr = 6;

    static {
        NEGATIVE_ONE = -1;
        STRING_COMPARATOR = new StringLikeComparator();
        DEFAULT_COMPARATOR = new ElementComparator();
        maximumInitialCapacity = 10000;
    }

    public NativeArray(long l) {
        boolean bl = l <= (long)maximumInitialCapacity;
        this.denseOnly = bl;
        if (bl) {
            int n;
            int n2 = n = (int)l;
            if (n < 10) {
                n2 = 10;
            }
            Object[] objectArray = new Object[n2];
            this.dense = objectArray;
            Arrays.fill(objectArray, Scriptable.NOT_FOUND);
        }
        this.length = l;
    }

    public NativeArray(Object[] objectArray) {
        this.denseOnly = true;
        this.dense = objectArray;
        this.length = objectArray.length;
    }

    private ScriptableObject defaultIndexPropertyDescriptor(Object object) {
        Scriptable scriptable;
        Scriptable scriptable2 = scriptable = this.getParentScope();
        if (scriptable == null) {
            scriptable2 = this;
        }
        scriptable = new NativeObject();
        ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)scriptable, scriptable2, TopLevel.Builtins.Object);
        ((ScriptableObject)scriptable).defineProperty("value", object, 0);
        ((ScriptableObject)scriptable).defineProperty("writable", true, 0);
        ((ScriptableObject)scriptable).defineProperty("enumerable", true, 0);
        ((ScriptableObject)scriptable).defineProperty("configurable", true, 0);
        return scriptable;
    }

    private static void defineElem(Context context, Scriptable scriptable, long l, Object object) {
        if (l > Integer.MAX_VALUE) {
            scriptable.put(Long.toString(l), scriptable, object);
        } else {
            scriptable.put((int)l, scriptable, object);
        }
    }

    private static void deleteElem(Scriptable scriptable, long l) {
        int n = (int)l;
        if ((long)n == l) {
            scriptable.delete(n);
        } else {
            scriptable.delete(Long.toString(l));
        }
    }

    private boolean ensureCapacity(int n) {
        Object[] objectArray = this.dense;
        if (n > objectArray.length) {
            if (n > 0x55555554) {
                this.denseOnly = false;
                return false;
            }
            n = Math.max(n, (int)((double)objectArray.length * 1.5));
            objectArray = new Object[n];
            Object[] objectArray2 = this.dense;
            System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
            Arrays.fill(objectArray, this.dense.length, n, Scriptable.NOT_FOUND);
            this.dense = objectArray;
        }
        return true;
    }

    private static Object getElem(Context object, Scriptable scriptable, long l) {
        object = NativeArray.getRawElem(scriptable, l);
        if (object == Scriptable.NOT_FOUND) {
            object = Undefined.instance;
        }
        return object;
    }

    static long getLengthProperty(Context object, Scriptable scriptable) {
        if (scriptable instanceof NativeString) {
            return ((NativeString)scriptable).getLength();
        }
        if (scriptable instanceof NativeArray) {
            return ((NativeArray)scriptable).getLength();
        }
        object = ScriptableObject.getProperty(scriptable, "length");
        if (object == Scriptable.NOT_FOUND) {
            return 0L;
        }
        return ScriptRuntime.toUint32(object);
    }

    static int getMaximumInitialCapacity() {
        return maximumInitialCapacity;
    }

    private static Object getRawElem(Scriptable scriptable, long l) {
        if (l > Integer.MAX_VALUE) {
            return ScriptableObject.getProperty(scriptable, Long.toString(l));
        }
        return ScriptableObject.getProperty(scriptable, (int)l);
    }

    static void init(Scriptable scriptable, boolean bl) {
        new NativeArray(0L).exportAsJSClass(26, scriptable, bl);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static Object iterativeMethod(Context var0, IdFunctionObject var1_1, Scriptable var2_2, Scriptable var3_3, Object[] var4_4) {
        block19: {
            var5_5 = Math.abs(var1_1.methodId());
            var1_1 = 22 != var5_5 && 23 != var5_5 ? var3_3 : ScriptRuntimeES6.requireObjectCoercible(var0, (Scriptable)var3_3, (IdFunctionObject)var1_1);
            var6_6 = NativeArray.getLengthProperty(var0, (Scriptable)var1_1);
            var3_3 = var4_4 /* !! */ .length > 0 ? var4_4 /* !! */ [0] : Undefined.instance;
            if (var3_3 == null || !(var3_3 instanceof Function)) break block19;
            if (var0.getLanguageVersion() >= 200 && var3_3 instanceof NativeRegExp) {
                throw ScriptRuntime.notFunctionError(var3_3);
            }
            var8_7 = (Function)var3_3;
            var9_8 = ScriptableObject.getTopLevelScope(var8_7);
            var3_3 = var4_4 /* !! */ .length >= 2 && var4_4 /* !! */ [1] != null && var4_4 /* !! */ [1] != Undefined.instance ? ScriptRuntime.toObject(var0, var2_2, var4_4 /* !! */ [1]) : var9_8;
            if (var5_5 != 18 && var5_5 != 20) {
                var2_2 = null;
            } else {
                var10_9 = var5_5 == 20 ? (int)var6_6 : 0;
                var2_2 = var0.newArray(var2_2, var10_9);
            }
            var13_11 = var11_10 = 0L;
            while (var11_10 < var6_6) {
                block21: {
                    block20: {
                        var15_12 = new Object[3];
                        var16_13 = NativeArray.getRawElem((Scriptable)var1_1, var11_10);
                        var4_4 /* !! */  = var16_13;
                        if (var16_13 != Scriptable.NOT_FOUND) break block20;
                        if (var5_5 != 22 && var5_5 != 23) break block21;
                        var4_4 /* !! */  = Undefined.instance;
                    }
                    var15_12[0] = var4_4 /* !! */ ;
                    var15_12[1] = var11_10;
                    var15_12[2] = var1_1;
                    var16_13 = var8_7.call(var0, var9_8, (Scriptable)var3_3, var15_12);
                    switch (var5_5) lbl-1000:
                    // 5 sources

                    {
                        default: {
                            break;
                        }
                        case 23: {
                            if (!ScriptRuntime.toBoolean(var16_13)) ** GOTO lbl-1000
                            return ScriptRuntime.wrapNumber(var11_10);
                        }
                        case 22: {
                            if (!ScriptRuntime.toBoolean(var16_13)) ** GOTO lbl-1000
                            return var4_4 /* !! */ ;
                        }
                        case 21: {
                            if (!ScriptRuntime.toBoolean(var16_13)) ** GOTO lbl-1000
                            return Boolean.TRUE;
                        }
                        case 20: {
                            NativeArray.defineElem(var0, var2_2, var11_10, var16_13);
                            break;
                        }
                        case 18: {
                            if (!ScriptRuntime.toBoolean(var16_13)) ** GOTO lbl-1000
                            var17_14 = var13_11 + 1L;
                            NativeArray.defineElem(var0, var2_2, var13_11, var15_12[0]);
                            var13_11 = var17_14;
                            break;
                        }
                        case 17: {
                            if (ScriptRuntime.toBoolean(var16_13)) break;
                            return Boolean.FALSE;
                        }
                    }
                }
                ++var11_10;
            }
            switch (var5_5) {
                default: {
                    return Undefined.instance;
                }
                case 23: {
                    return ScriptRuntime.wrapNumber(-1.0);
                }
                case 21: {
                    return Boolean.FALSE;
                }
                case 18: 
                case 20: {
                    return var2_2;
                }
                case 17: 
            }
            return Boolean.TRUE;
        }
        throw ScriptRuntime.notFunctionError(var3_3);
    }

    private static Object jsConstructor(Context object, Scriptable scriptable, Object[] objectArray) {
        if (objectArray.length == 0) {
            return new NativeArray(0L);
        }
        if (((Context)object).getLanguageVersion() == 120) {
            return new NativeArray(objectArray);
        }
        object = objectArray[0];
        if (objectArray.length <= 1 && object instanceof Number) {
            long l = ScriptRuntime.toUint32(object);
            if ((double)l == ((Number)object).doubleValue()) {
                return new NativeArray(l);
            }
            throw ScriptRuntime.constructError("RangeError", ScriptRuntime.getMessage0("msg.arraylength.bad"));
        }
        return new NativeArray(objectArray);
    }

    private static Scriptable js_concat(Context object, Scriptable scriptable, Scriptable object2, Object[] objectArray) {
        long l;
        long l2;
        long l3;
        int n;
        Object object3;
        scriptable = NativeArray.getTopLevelScope(scriptable);
        int n2 = 0;
        scriptable = ((Context)object).newArray(scriptable, 0);
        if (object2 instanceof NativeArray && scriptable instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)object2;
            object3 = (NativeArray)scriptable;
            if (nativeArray.denseOnly && ((NativeArray)object3).denseOnly) {
                int n3;
                int n4 = (int)nativeArray.length;
                boolean bl = true;
                for (n3 = 0; n3 < objectArray.length && bl; ++n3) {
                    if (objectArray[n3] instanceof NativeArray) {
                        NativeArray nativeArray2 = (NativeArray)objectArray[n3];
                        bl = nativeArray2.denseOnly;
                        n = (int)((long)n4 + nativeArray2.length);
                    } else {
                        n = n4 + 1;
                    }
                    n4 = n;
                }
                if (bl && super.ensureCapacity(n4)) {
                    System.arraycopy(nativeArray.dense, 0, ((NativeArray)object3).dense, 0, (int)nativeArray.length);
                    n = (int)nativeArray.length;
                    for (n3 = 0; n3 < objectArray.length && bl; ++n3) {
                        if (objectArray[n3] instanceof NativeArray) {
                            object = (NativeArray)objectArray[n3];
                            System.arraycopy(((NativeArray)object).dense, 0, ((NativeArray)object3).dense, n, (int)((NativeArray)object).length);
                            n += (int)((NativeArray)object).length;
                            continue;
                        }
                        ((NativeArray)object3).dense[n] = objectArray[n3];
                        ++n;
                    }
                    ((NativeArray)object3).length = n4;
                    return scriptable;
                }
            }
        }
        if (NativeArray.js_isArray(object2)) {
            l3 = NativeArray.getLengthProperty((Context)object, (Scriptable)object2);
            l2 = 0L;
            while (true) {
                n = n2;
                l = ++l2;
                if (l2 < l3) {
                    object3 = NativeArray.getRawElem((Scriptable)object2, l2);
                    if (object3 == NOT_FOUND) continue;
                    NativeArray.defineElem((Context)object, scriptable, l2, object3);
                    continue;
                }
                break;
            }
        } else {
            NativeArray.defineElem((Context)object, scriptable, 0L, object2);
            l = 1L;
            n = n2;
        }
        while (n < objectArray.length) {
            if (NativeArray.js_isArray(objectArray[n])) {
                object3 = (Scriptable)objectArray[n];
                long l4 = NativeArray.getLengthProperty((Context)object, (Scriptable)object3);
                l3 = 0L;
                while (true) {
                    l2 = ++l;
                    if (l3 < l4) {
                        object2 = NativeArray.getRawElem((Scriptable)object3, l3);
                        if (object2 != NOT_FOUND) {
                            NativeArray.defineElem((Context)object, scriptable, l, object2);
                        }
                        ++l3;
                        continue;
                    }
                    break;
                }
            } else {
                NativeArray.defineElem((Context)object, scriptable, l, objectArray[n]);
                l2 = l + 1L;
            }
            ++n;
            l = l2;
        }
        NativeArray.setLengthProperty((Context)object, scriptable, l);
        return scriptable;
    }

    private static Object js_indexOf(Context object, Scriptable object2, Object[] object3) {
        long l;
        long l2;
        int n;
        long l3;
        Object object4;
        block13: {
            block15: {
                block14: {
                    long l4;
                    block12: {
                        object4 = ((Object[])object3).length > 0 ? object3[0] : Undefined.instance;
                        l3 = NativeArray.getLengthProperty((Context)object, (Scriptable)object2);
                        n = ((Object[])object3).length;
                        l2 = 0L;
                        if (n >= 2) break block12;
                        l = l2;
                        break block13;
                    }
                    l = l4 = (long)ScriptRuntime.toInteger(object3[1]);
                    if (l4 >= 0L) break block14;
                    l = l4 += l3;
                    if (l4 < 0L) break block15;
                }
                l2 = l;
            }
            l = l2;
            if (l2 > l3 - 1L) {
                return NEGATIVE_ONE;
            }
        }
        l2 = l;
        if (object2 instanceof NativeArray) {
            object3 = (NativeArray)object2;
            l2 = l;
            if (((NativeArray)object3).denseOnly) {
                Scriptable scriptable = ((ScriptableObject)object3).getPrototype();
                n = (int)l;
                while ((l = (long)n) < l3) {
                    object = object2 = ((NativeArray)object3).dense[n];
                    if (object2 == NOT_FOUND) {
                        object = object2;
                        if (scriptable != null) {
                            object = ScriptableObject.getProperty(scriptable, n);
                        }
                    }
                    if (object != NOT_FOUND && ScriptRuntime.shallowEq(object, object4)) {
                        return l;
                    }
                    ++n;
                }
                return NEGATIVE_ONE;
            }
        }
        while (l2 < l3) {
            object = NativeArray.getRawElem((Scriptable)object2, l2);
            if (object != NOT_FOUND && ScriptRuntime.shallowEq(object, object4)) {
                return l2;
            }
            ++l2;
        }
        return NEGATIVE_ONE;
    }

    private static boolean js_isArray(Object object) {
        if (!(object instanceof Scriptable)) {
            return false;
        }
        return "Array".equals(((Scriptable)object).getClassName());
    }

    private static String js_join(Context object, Scriptable object2, Object[] object3) {
        int n;
        long l = NativeArray.getLengthProperty((Context)object, (Scriptable)object2);
        if (l == (long)(n = (int)l)) {
            String[] stringArray;
            int n2 = ((Object[])object3).length;
            int n3 = 0;
            int n4 = 0;
            object3 = n2 >= 1 && object3[0] != Undefined.instance ? ScriptRuntime.toString(object3[0]) : ",";
            if (object2 instanceof NativeArray) {
                stringArray = (String[])object2;
                if (stringArray.denseOnly) {
                    object = new StringBuilder();
                    while (n4 < n) {
                        if (n4 != 0) {
                            ((StringBuilder)object).append((String)object3);
                        }
                        if (n4 < ((Object[])(object2 = stringArray.dense)).length && (object2 = object2[n4]) != null && object2 != Undefined.instance && object2 != Scriptable.NOT_FOUND) {
                            ((StringBuilder)object).append(ScriptRuntime.toString(object2));
                        }
                        ++n4;
                    }
                    return ((StringBuilder)object).toString();
                }
            }
            if (n == 0) {
                return "";
            }
            stringArray = new String[n];
            n4 = 0;
            for (n2 = 0; n2 != n; ++n2) {
                Object object4 = NativeArray.getElem((Context)object, (Scriptable)object2, n2);
                int n5 = n4;
                if (object4 != null) {
                    n5 = n4;
                    if (object4 != Undefined.instance) {
                        object4 = ScriptRuntime.toString(object4);
                        n5 = n4 + ((String)object4).length();
                        stringArray[n2] = object4;
                    }
                }
                n4 = n5;
            }
            object2 = new StringBuilder(n4 + (n - 1) * ((String)object3).length());
            for (n4 = n3; n4 != n; ++n4) {
                if (n4 != 0) {
                    ((StringBuilder)object2).append((String)object3);
                }
                if ((object = stringArray[n4]) == null) continue;
                ((StringBuilder)object2).append((String)object);
            }
            return ((StringBuilder)object2).toString();
        }
        throw Context.reportRuntimeError1("msg.arraylength.too.big", String.valueOf(l));
    }

    private static Object js_lastIndexOf(Context object, Scriptable object2, Object[] object3) {
        long l;
        long l2;
        Object object4 = ((Object[])object3).length > 0 ? object3[0] : Undefined.instance;
        long l3 = NativeArray.getLengthProperty((Context)object, (Scriptable)object2);
        if (((Object[])object3).length < 2) {
            l2 = l3 - 1L;
        } else {
            l = (long)ScriptRuntime.toInteger(object3[1]);
            if (l >= l3) {
                l = l3 - 1L;
            } else {
                l2 = l;
                if (l < 0L) {
                    l2 = l + l3;
                }
                l = l2;
            }
            l2 = l;
            if (l < 0L) {
                return NEGATIVE_ONE;
            }
        }
        l = l2;
        if (object2 instanceof NativeArray) {
            object3 = (NativeArray)object2;
            l = l2;
            if (((NativeArray)object3).denseOnly) {
                Scriptable scriptable = ((ScriptableObject)object3).getPrototype();
                for (int i = (int)l2; i >= 0; --i) {
                    object = object2 = ((NativeArray)object3).dense[i];
                    if (object2 == NOT_FOUND) {
                        object = object2;
                        if (scriptable != null) {
                            object = ScriptableObject.getProperty(scriptable, i);
                        }
                    }
                    if (object == NOT_FOUND || !ScriptRuntime.shallowEq(object, object4)) continue;
                    return (long)i;
                }
                return NEGATIVE_ONE;
            }
        }
        while (l >= 0L) {
            object = NativeArray.getRawElem((Scriptable)object2, l);
            if (object != NOT_FOUND && ScriptRuntime.shallowEq(object, object4)) {
                return l;
            }
            --l;
        }
        return NEGATIVE_ONE;
    }

    private static Object js_pop(Context objectArray, Scriptable object, Object[] object2) {
        long l;
        if (object instanceof NativeArray) {
            object2 = (NativeArray)object;
            if (object2.denseOnly && (l = object2.length) > 0L) {
                object2.length = --l;
                objectArray = object2.dense;
                object = objectArray[(int)l];
                objectArray[(int)l] = NOT_FOUND;
                return object;
            }
        }
        if ((l = NativeArray.getLengthProperty((Context)objectArray, (Scriptable)object)) > 0L) {
            object2 = NativeArray.getElem((Context)objectArray, (Scriptable)object, --l);
            NativeArray.deleteElem((Scriptable)object, l);
        } else {
            object2 = Undefined.instance;
        }
        NativeArray.setLengthProperty((Context)objectArray, (Scriptable)object, l);
        return object2;
    }

    private static Object js_push(Context object, Scriptable object2, Object[] objectArray) {
        int n;
        boolean bl = object2 instanceof NativeArray;
        int n2 = 0;
        if (bl) {
            NativeArray nativeArray = (NativeArray)object2;
            if (nativeArray.denseOnly && nativeArray.ensureCapacity((int)nativeArray.length + objectArray.length)) {
                for (n = 0; n < objectArray.length; ++n) {
                    object = nativeArray.dense;
                    long l = nativeArray.length;
                    nativeArray.length = 1L + l;
                    object[(int)l] = objectArray[n];
                }
                return ScriptRuntime.wrapNumber(nativeArray.length);
            }
        }
        long l = NativeArray.getLengthProperty((Context)object, (Scriptable)object2);
        for (n = n2; n < objectArray.length; ++n) {
            NativeArray.setElem((Context)object, (Scriptable)object2, (long)n + l, objectArray[n]);
        }
        object2 = NativeArray.setLengthProperty((Context)object, (Scriptable)object2, l + (long)objectArray.length);
        if (object.getLanguageVersion() == 120) {
            object = objectArray.length == 0 ? Undefined.instance : objectArray[objectArray.length - 1];
            return object;
        }
        return object2;
    }

    private static Scriptable js_reverse(Context objectArray, Scriptable scriptable, Object[] object) {
        if (scriptable instanceof NativeArray) {
            object = (NativeArray)scriptable;
            if (object.denseOnly) {
                int n = 0;
                for (int i = (int)object.length - 1; n < i; ++n, --i) {
                    objectArray = object.dense;
                    Object object2 = objectArray[n];
                    objectArray[n] = objectArray[i];
                    objectArray[i] = object2;
                }
                return scriptable;
            }
        }
        long l = NativeArray.getLengthProperty((Context)objectArray, scriptable);
        long l2 = l / 2L;
        for (long i = 0L; i < l2; ++i) {
            long l3 = l - i - 1L;
            object = NativeArray.getRawElem(scriptable, i);
            NativeArray.setRawElem((Context)objectArray, scriptable, i, NativeArray.getRawElem(scriptable, l3));
            NativeArray.setRawElem((Context)objectArray, scriptable, l3, object);
        }
        return scriptable;
    }

    private static Object js_shift(Context object, Scriptable object2, Object[] object3) {
        long l;
        if (object2 instanceof NativeArray) {
            object3 = (NativeArray)object2;
            if (object3.denseOnly && (l = object3.length) > 0L) {
                object3.length = --l;
                object = object3.dense;
                object2 = object[0];
                System.arraycopy(object, 1, object, 0, (int)l);
                object3.dense[(int)object3.length] = NOT_FOUND;
                object = object2;
                if (object2 == NOT_FOUND) {
                    object = Undefined.instance;
                }
                return object;
            }
        }
        if ((l = NativeArray.getLengthProperty((Context)object, (Scriptable)object2)) > 0L) {
            long l2 = l - 1L;
            object3 = NativeArray.getElem((Context)object, (Scriptable)object2, 0L);
            if (l2 > 0L) {
                for (l = 1L; l <= l2; ++l) {
                    NativeArray.setRawElem((Context)object, (Scriptable)object2, l - 1L, NativeArray.getRawElem((Scriptable)object2, l));
                }
            }
            NativeArray.deleteElem((Scriptable)object2, l2);
            l = l2;
        } else {
            object3 = Undefined.instance;
        }
        NativeArray.setLengthProperty((Context)object, (Scriptable)object2, l);
        return object3;
    }

    private Scriptable js_slice(Context context, Scriptable scriptable, Object[] object) {
        long l;
        long l2;
        Scriptable scriptable2 = context.newArray(NativeArray.getTopLevelScope(this), 0);
        long l3 = NativeArray.getLengthProperty(context, scriptable);
        if (((Object[])object).length == 0) {
            l2 = 0L;
            l = l3;
        } else {
            long l4 = NativeArray.toSliceIndex(ScriptRuntime.toInteger(object[0]), l3);
            l = l3;
            l2 = l4;
            if (((Object[])object).length != 1) {
                if (object[1] == Undefined.instance) {
                    l = l3;
                    l2 = l4;
                } else {
                    l = NativeArray.toSliceIndex(ScriptRuntime.toInteger(object[1]), l3);
                    l2 = l4;
                }
            }
        }
        for (l3 = l2; l3 < l; ++l3) {
            object = NativeArray.getRawElem(scriptable, l3);
            if (object == NOT_FOUND) continue;
            NativeArray.defineElem(context, scriptable2, l3 - l2, object);
        }
        NativeArray.setLengthProperty(context, scriptable2, Math.max(0L, l - l2));
        return scriptable2;
    }

    private static Scriptable js_sort(Context context, Scriptable object, Scriptable scriptable, Object[] objectArray) {
        int n = objectArray.length;
        int n2 = 0;
        if (n > 0 && Undefined.instance != objectArray[0]) {
            objectArray = ScriptRuntime.getValueFunctionAndThis(objectArray[0], context);
            Scriptable scriptable2 = ScriptRuntime.lastStoredScriptable(context);
            object = new ElementComparator(new Comparator<Object>(new Object[2], (Callable)objectArray, context, (Scriptable)object, scriptable2){
                final /* synthetic */ Object[] val$cmpBuf;
                final /* synthetic */ Context val$cx;
                final /* synthetic */ Scriptable val$funThis;
                final /* synthetic */ Callable val$jsCompareFunction;
                final /* synthetic */ Scriptable val$scope;
                {
                    this.val$cmpBuf = objectArray;
                    this.val$jsCompareFunction = callable;
                    this.val$cx = context;
                    this.val$scope = scriptable;
                    this.val$funThis = scriptable2;
                }

                @Override
                public int compare(Object object, Object object2) {
                    Object[] objectArray = this.val$cmpBuf;
                    objectArray[0] = object;
                    objectArray[1] = object2;
                    double d = ScriptRuntime.toNumber(this.val$jsCompareFunction.call(this.val$cx, this.val$scope, this.val$funThis, objectArray));
                    if (d < 0.0) {
                        return -1;
                    }
                    if (d > 0.0) {
                        return 1;
                    }
                    return 0;
                }
            });
        } else {
            object = DEFAULT_COMPARATOR;
        }
        long l = NativeArray.getLengthProperty(context, scriptable);
        int n3 = (int)l;
        if (l == (long)n3) {
            objectArray = new Object[n3];
            for (n = 0; n != n3; ++n) {
                objectArray[n] = NativeArray.getRawElem(scriptable, n);
            }
            Sorting.hybridSort(objectArray, (Comparator<Object>)object);
            for (n = n2; n < n3; ++n) {
                NativeArray.setRawElem(context, scriptable, n, objectArray[n]);
            }
            return scriptable;
        }
        throw Context.reportRuntimeError1("msg.arraylength.too.big", String.valueOf(l));
    }

    private static Object js_splice(Context objectArray, Scriptable object, Scriptable scriptable, Object[] objectArray2) {
        long l;
        int n;
        long l2;
        long l3;
        boolean bl;
        NativeArray nativeArray;
        if (scriptable instanceof NativeArray) {
            nativeArray = (NativeArray)scriptable;
            bl = nativeArray.denseOnly;
        } else {
            nativeArray = null;
            bl = false;
        }
        object = NativeArray.getTopLevelScope((Scriptable)object);
        int n2 = objectArray2.length;
        if (n2 == 0) {
            return objectArray.newArray((Scriptable)object, 0);
        }
        long l4 = NativeArray.getLengthProperty((Context)objectArray, scriptable);
        long l5 = NativeArray.toSliceIndex(ScriptRuntime.toInteger(objectArray2[0]), l4);
        --n2;
        if (objectArray2.length == 1) {
            l3 = l4 - l5;
        } else {
            double d = ScriptRuntime.toInteger(objectArray2[1]);
            if (d < 0.0) {
                l2 = 0L;
            } else {
                l2 = l4 - l5;
                if (!(d > (double)l2)) {
                    l2 = (long)d;
                }
            }
            --n2;
            l3 = l2;
        }
        l2 = l5 + l3;
        if (l3 != 0L) {
            Object object2;
            if (l3 == 1L && objectArray.getLanguageVersion() == 120) {
                object = NativeArray.getElem((Context)objectArray, scriptable, l5);
            } else if (bl) {
                n = (int)(l2 - l5);
                object2 = new Object[n];
                System.arraycopy(nativeArray.dense, (int)l5, object2, 0, n);
                object = objectArray.newArray((Scriptable)object, (Object[])object2);
            } else {
                object = objectArray.newArray((Scriptable)object, 0);
                for (l = l5; l != l2; ++l) {
                    object2 = NativeArray.getRawElem(scriptable, l);
                    if (object2 == NOT_FOUND) continue;
                    NativeArray.setElem((Context)objectArray, (Scriptable)object, l - l5, object2);
                }
                NativeArray.setLengthProperty((Context)objectArray, (Scriptable)object, l2 - l5);
            }
        } else {
            object = objectArray.getLanguageVersion() == 120 ? Undefined.instance : objectArray.newArray((Scriptable)object, 0);
        }
        l = l4;
        long l6 = n2;
        l4 = l6 - l3;
        if (bl && (l3 = l + l4) < Integer.MAX_VALUE && nativeArray.ensureCapacity(n = (int)l3)) {
            objectArray = nativeArray.dense;
            System.arraycopy(objectArray, (int)l2, objectArray, (int)(l6 + l5), (int)(l - l2));
            if (n2 > 0) {
                System.arraycopy(objectArray2, 2, nativeArray.dense, (int)l5, n2);
            }
            if (l4 < 0L) {
                Arrays.fill(nativeArray.dense, n, (int)l, NOT_FOUND);
            }
            nativeArray.length = l3;
            return object;
        }
        long l7 = l4 - 0L;
        n = l7 == 0L ? 0 : (l7 < 0L ? -1 : 1);
        if (n > 0) {
            for (l3 = l - 1L; l3 >= l2; --l3) {
                NativeArray.setRawElem((Context)objectArray, scriptable, l3 + l4, NativeArray.getRawElem(scriptable, l3));
            }
        } else if (n < 0) {
            while (l2 < l) {
                NativeArray.setRawElem((Context)objectArray, scriptable, l2 + l4, NativeArray.getRawElem(scriptable, l2));
                ++l2;
            }
            for (l2 = l + l4; l2 < l; ++l2) {
                NativeArray.deleteElem(scriptable, l2);
            }
        }
        int n3 = objectArray2.length;
        for (n = 0; n < n2; ++n) {
            NativeArray.setElem((Context)objectArray, scriptable, (long)n + l5, objectArray2[n + (n3 - n2)]);
        }
        NativeArray.setLengthProperty((Context)objectArray, scriptable, l + l4);
        return object;
    }

    private static Object js_unshift(Context objectArray, Scriptable scriptable, Object[] objectArray2) {
        int n;
        Object object;
        boolean bl = scriptable instanceof NativeArray;
        int n2 = 0;
        if (bl) {
            object = (NativeArray)scriptable;
            if (((NativeArray)object).denseOnly && ((NativeArray)object).ensureCapacity((int)((NativeArray)object).length + objectArray2.length)) {
                long l;
                objectArray = ((NativeArray)object).dense;
                System.arraycopy(objectArray, 0, objectArray, objectArray2.length, (int)((NativeArray)object).length);
                for (n = 0; n < objectArray2.length; ++n) {
                    ((NativeArray)object).dense[n] = objectArray2[n];
                }
                ((NativeArray)object).length = l = ((NativeArray)object).length + (long)objectArray2.length;
                return ScriptRuntime.wrapNumber(l);
            }
        }
        long l = NativeArray.getLengthProperty((Context)objectArray, scriptable);
        int n3 = objectArray2.length;
        if (objectArray2.length > 0) {
            n = n2;
            if (l > 0L) {
                long l2 = l - 1L;
                while (true) {
                    n = n2;
                    if (l2 < 0L) break;
                    object = NativeArray.getRawElem(scriptable, l2);
                    NativeArray.setRawElem((Context)objectArray, scriptable, (long)n3 + l2, object);
                    --l2;
                }
            }
            while (n < objectArray2.length) {
                NativeArray.setElem((Context)objectArray, scriptable, n, objectArray2[n]);
                ++n;
            }
        }
        return NativeArray.setLengthProperty((Context)objectArray, scriptable, l + (long)objectArray2.length);
    }

    private static Object reduceMethod(Context context, int n, Scriptable object, Scriptable scriptable, Object[] object2) {
        long l = NativeArray.getLengthProperty(context, scriptable);
        object = ((Object[])object2).length > 0 ? object2[0] : Undefined.instance;
        if (object != null && object instanceof Function) {
            Function function = (Function)object;
            Scriptable scriptable2 = ScriptableObject.getTopLevelScope(function);
            n = n == 24 ? 1 : 0;
            object = ((Object[])object2).length > 1 ? object2[1] : Scriptable.NOT_FOUND;
            for (long i = 0L; i < l; ++i) {
                long l2 = n != 0 ? i : l - 1L - i;
                object2 = NativeArray.getRawElem(scriptable, l2);
                if (object2 == Scriptable.NOT_FOUND) continue;
                if (object == Scriptable.NOT_FOUND) {
                    object = object2;
                    continue;
                }
                object = function.call(context, scriptable2, scriptable2, new Object[]{object, object2, l2, scriptable});
            }
            if (object != Scriptable.NOT_FOUND) {
                return object;
            }
            throw ScriptRuntime.typeError0("msg.empty.array.reduce");
        }
        throw ScriptRuntime.notFunctionError(object);
    }

    private static void setElem(Context context, Scriptable scriptable, long l, Object object) {
        if (l > Integer.MAX_VALUE) {
            ScriptableObject.putProperty(scriptable, Long.toString(l), object);
        } else {
            ScriptableObject.putProperty(scriptable, (int)l, object);
        }
    }

    private void setLength(Object objectArray) {
        if ((this.lengthAttr & 1) != 0) {
            return;
        }
        double d = ScriptRuntime.toNumber(objectArray);
        long l = ScriptRuntime.toUint32(d);
        double d2 = l;
        if (d2 == d) {
            long l2;
            boolean bl = this.denseOnly;
            int n = 0;
            if (bl) {
                l2 = this.length;
                if (l < l2) {
                    objectArray = this.dense;
                    Arrays.fill(objectArray, (int)l, objectArray.length, NOT_FOUND);
                    this.length = l;
                    return;
                }
                if (l < 0x55555554L && d2 < (double)l2 * 1.5 && this.ensureCapacity((int)l)) {
                    this.length = l;
                    return;
                }
                this.denseOnly = false;
            }
            if (l < (l2 = this.length)) {
                if (l2 - l > 4096L) {
                    objectArray = this.getIds();
                    while (n < objectArray.length) {
                        Object object = objectArray[n];
                        if (object instanceof String) {
                            if (NativeArray.toArrayIndex((String)(object = (String)object)) >= l) {
                                this.delete((String)object);
                            }
                        } else {
                            int n2 = (Integer)object;
                            if ((long)n2 >= l) {
                                this.delete(n2);
                            }
                        }
                        ++n;
                    }
                } else {
                    for (l2 = l; l2 < this.length; ++l2) {
                        NativeArray.deleteElem(this, l2);
                    }
                }
            }
            this.length = l;
            return;
        }
        throw ScriptRuntime.constructError("RangeError", ScriptRuntime.getMessage0("msg.arraylength.bad"));
    }

    private static Object setLengthProperty(Context object, Scriptable scriptable, long l) {
        object = ScriptRuntime.wrapNumber(l);
        ScriptableObject.putProperty(scriptable, "length", object);
        return object;
    }

    static void setMaximumInitialCapacity(int n) {
        maximumInitialCapacity = n;
    }

    private static void setRawElem(Context context, Scriptable scriptable, long l, Object object) {
        if (object == NOT_FOUND) {
            NativeArray.deleteElem(scriptable, l);
        } else {
            NativeArray.setElem(context, scriptable, l, object);
        }
    }

    private static long toArrayIndex(double d) {
        long l;
        if (d == d && (double)(l = ScriptRuntime.toUint32(d)) == d && l != 0xFFFFFFFFL) {
            return l;
        }
        return -1L;
    }

    private static long toArrayIndex(Object object) {
        if (object instanceof String) {
            return NativeArray.toArrayIndex((String)object);
        }
        if (object instanceof Number) {
            return NativeArray.toArrayIndex(((Number)object).doubleValue());
        }
        return -1L;
    }

    private static long toArrayIndex(String string2) {
        long l = NativeArray.toArrayIndex(ScriptRuntime.toNumber(string2));
        if (Long.toString(l).equals(string2)) {
            return l;
        }
        return -1L;
    }

    private static int toDenseIndex(Object object) {
        long l = NativeArray.toArrayIndex(object);
        int n = 0L <= l && l < Integer.MAX_VALUE ? (int)l : -1;
        return n;
    }

    private static long toSliceIndex(double d, long l) {
        block4: {
            double d2;
            block3: {
                block2: {
                    if (!(d < 0.0)) break block2;
                    d2 = d += (double)l;
                    if (!(d < 0.0)) break block3;
                    l = 0L;
                    break block4;
                }
                d2 = d;
                if (d > (double)l) break block4;
            }
            l = (long)d2;
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String toStringHelper(Context context, Scriptable scriptable, Scriptable scriptable2, boolean bl, boolean bl2) {
        long l;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        String string2;
        long l2 = NativeArray.getLengthProperty(context, scriptable2);
        StringBuilder stringBuilder = new StringBuilder(256);
        if (bl) {
            stringBuilder.append('[');
            string2 = ", ";
        } else {
            string2 = ",";
        }
        if (context.iterating == null) {
            context.iterating = new ObjToIntMap(31);
            bl5 = false;
            bl4 = true;
        } else {
            bl5 = context.iterating.has(scriptable2);
            bl4 = false;
        }
        if (!bl5) {
            try {
                context.iterating.put(scriptable2, 0);
                boolean bl6 = !bl || context.getLanguageVersion() < 150;
                bl3 = false;
                for (l = 0L; l < l2; ++l) {
                    Object object;
                    if (l > 0L) {
                        stringBuilder.append(string2);
                    }
                    if ((object = NativeArray.getRawElem(scriptable2, l)) != NOT_FOUND && (!bl6 || object != null && object != Undefined.instance)) {
                        Object object2;
                        if (bl) {
                            stringBuilder.append(ScriptRuntime.uneval(context, scriptable, object));
                        } else if (object instanceof String) {
                            object2 = (String)object;
                            if (bl) {
                                stringBuilder.append('\"');
                                stringBuilder.append(ScriptRuntime.escapeString((String)object2));
                                stringBuilder.append('\"');
                            } else {
                                stringBuilder.append((String)object2);
                            }
                        } else {
                            object2 = object;
                            if (bl2) {
                                object2 = ScriptRuntime.getPropFunctionAndThis(object, "toLocaleString", context, scriptable).call(context, scriptable, ScriptRuntime.lastStoredScriptable(context), ScriptRuntime.emptyArgs);
                            }
                            stringBuilder.append(ScriptRuntime.toString(object2));
                        }
                        bl3 = true;
                        continue;
                    }
                    bl3 = false;
                }
            }
            catch (Throwable throwable) {
                if (!bl4) throw throwable;
                context.iterating = null;
                throw throwable;
            }
        }
        bl3 = false;
        l = 0L;
        if (bl4) {
            context.iterating = null;
        }
        if (!bl) return stringBuilder.toString();
        if (!bl3 && l > 0L) {
            stringBuilder.append(", ]");
            return stringBuilder.toString();
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public void add(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int n, Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object object) {
        boolean bl = this.indexOf(object) > -1;
        return bl;
    }

    @Override
    public boolean containsAll(Collection object) {
        object = object.iterator();
        while (object.hasNext()) {
            if (this.contains(object.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void defineOwnProperty(Context context, Object object, ScriptableObject scriptableObject, boolean bl) {
        long l;
        Object[] objectArray = this.dense;
        if (objectArray != null) {
            this.dense = null;
            this.denseOnly = false;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == NOT_FOUND) continue;
                this.put(i, (Scriptable)this, objectArray[i]);
            }
        }
        if ((l = NativeArray.toArrayIndex(object)) >= this.length) {
            this.length = l + 1L;
        }
        super.defineOwnProperty(context, object, scriptableObject, bl);
    }

    @Override
    public void delete(int n) {
        Object[] objectArray = this.dense;
        if (!(objectArray == null || n < 0 || n >= objectArray.length || this.isSealed() || !this.denseOnly && this.isGetterOrSetter(null, n, true))) {
            this.dense[n] = NOT_FOUND;
        } else {
            super.delete(n);
        }
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context object, Scriptable scriptable, Scriptable objectArray, Object[] objectArray2) {
        boolean bl;
        if (!idFunctionObject.hasTag(ARRAY_TAG)) {
            return super.execIdCall(idFunctionObject, (Context)object, scriptable, (Scriptable)objectArray, objectArray2);
        }
        int n = idFunctionObject.methodId();
        Object object2 = objectArray;
        block25: while (true) {
            bl = true;
            int n2 = 1;
            int n3 = 0;
            switch (n) {
                default: {
                    switch (n) {
                        default: {
                            object = new StringBuilder();
                            ((StringBuilder)object).append("Array.prototype has no method: ");
                            ((StringBuilder)object).append(idFunctionObject.getFunctionName());
                            throw new IllegalArgumentException(((StringBuilder)object).toString());
                        }
                        case 26: {
                            return new NativeArrayIterator(scriptable, (Scriptable)object2);
                        }
                        case 24: 
                        case 25: {
                            return NativeArray.reduceMethod((Context)object, n, scriptable, (Scriptable)object2, objectArray2);
                        }
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: {
                            return NativeArray.iterativeMethod((Context)object, idFunctionObject, scriptable, (Scriptable)object2, objectArray2);
                        }
                        case 16: {
                            return NativeArray.js_lastIndexOf((Context)object, (Scriptable)object2, objectArray2);
                        }
                        case 15: {
                            return NativeArray.js_indexOf((Context)object, (Scriptable)object2, objectArray2);
                        }
                        case 14: {
                            return this.js_slice((Context)object, (Scriptable)object2, objectArray2);
                        }
                        case 13: {
                            return NativeArray.js_concat((Context)object, scriptable, (Scriptable)object2, objectArray2);
                        }
                        case 12: {
                            return NativeArray.js_splice((Context)object, scriptable, (Scriptable)object2, objectArray2);
                        }
                        case 11: {
                            return NativeArray.js_unshift((Context)object, (Scriptable)object2, objectArray2);
                        }
                        case 10: {
                            return NativeArray.js_shift((Context)object, (Scriptable)object2, objectArray2);
                        }
                        case 9: {
                            return NativeArray.js_pop((Context)object, (Scriptable)object2, objectArray2);
                        }
                        case 8: {
                            return NativeArray.js_push((Context)object, (Scriptable)object2, objectArray2);
                        }
                        case 7: {
                            return NativeArray.js_sort((Context)object, scriptable, (Scriptable)object2, objectArray2);
                        }
                        case 6: {
                            return NativeArray.js_reverse((Context)object, (Scriptable)object2, objectArray2);
                        }
                        case 5: {
                            return NativeArray.js_join((Context)object, (Scriptable)object2, objectArray2);
                        }
                        case 4: {
                            return NativeArray.toStringHelper((Context)object, scriptable, (Scriptable)object2, true, false);
                        }
                        case 3: {
                            return NativeArray.toStringHelper((Context)object, scriptable, (Scriptable)object2, false, true);
                        }
                        case 2: {
                            return NativeArray.toStringHelper((Context)object, scriptable, (Scriptable)object2, ((Context)object).hasFeature(4), false);
                        }
                        case 1: 
                    }
                    n = object2 == null ? n2 : 0;
                    if (n == 0) {
                        return idFunctionObject.construct((Context)object, scriptable, objectArray2);
                    }
                    return NativeArray.jsConstructor((Context)object, scriptable, objectArray2);
                }
                case -25: 
                case -24: 
                case -23: 
                case -22: 
                case -21: 
                case -20: 
                case -19: 
                case -18: 
                case -17: 
                case -16: 
                case -15: 
                case -14: 
                case -13: 
                case -12: 
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -7: 
                case -6: 
                case -5: {
                    objectArray = objectArray2;
                    if (objectArray2.length > 0) {
                        object2 = ScriptRuntime.toObject((Context)object, scriptable, objectArray2[0]);
                        int n4 = objectArray2.length - 1;
                        objectArray = new Object[n4];
                        while (n3 < n4) {
                            n2 = n3 + 1;
                            objectArray[n3] = objectArray2[n2];
                            n3 = n2;
                        }
                    }
                    n = -n;
                    objectArray2 = objectArray;
                    continue block25;
                }
                case -26: 
            }
            break;
        }
        if (objectArray2.length <= 0 || !NativeArray.js_isArray(objectArray2[0])) {
            bl = false;
        }
        return bl;
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        Object object = ARRAY_TAG;
        this.addIdFunctionProperty(idFunctionObject, object, -5, "join", 1);
        this.addIdFunctionProperty(idFunctionObject, object, -6, "reverse", 0);
        this.addIdFunctionProperty(idFunctionObject, object, -7, "sort", 1);
        this.addIdFunctionProperty(idFunctionObject, object, -8, "push", 1);
        this.addIdFunctionProperty(idFunctionObject, object, -9, "pop", 0);
        this.addIdFunctionProperty(idFunctionObject, object, -10, "shift", 0);
        this.addIdFunctionProperty(idFunctionObject, object, -11, "unshift", 1);
        this.addIdFunctionProperty(idFunctionObject, object, -12, "splice", 2);
        this.addIdFunctionProperty(idFunctionObject, object, -13, "concat", 1);
        this.addIdFunctionProperty(idFunctionObject, object, -14, "slice", 2);
        this.addIdFunctionProperty(idFunctionObject, object, -15, "indexOf", 1);
        this.addIdFunctionProperty(idFunctionObject, object, -16, "lastIndexOf", 1);
        this.addIdFunctionProperty(idFunctionObject, object, -17, "every", 1);
        this.addIdFunctionProperty(idFunctionObject, object, -18, "filter", 1);
        this.addIdFunctionProperty(idFunctionObject, object, -19, "forEach", 1);
        this.addIdFunctionProperty(idFunctionObject, object, -20, "map", 1);
        this.addIdFunctionProperty(idFunctionObject, object, -21, "some", 1);
        this.addIdFunctionProperty(idFunctionObject, object, -22, "find", 1);
        this.addIdFunctionProperty(idFunctionObject, object, -23, "findIndex", 1);
        this.addIdFunctionProperty(idFunctionObject, object, -24, "reduce", 1);
        this.addIdFunctionProperty(idFunctionObject, object, -25, "reduceRight", 1);
        this.addIdFunctionProperty(idFunctionObject, object, -26, "isArray", 1);
        super.fillConstructorProperties(idFunctionObject);
    }

    @Override
    protected int findInstanceIdInfo(String string2) {
        if (string2.equals("length")) {
            return NativeArray.instanceIdInfo(this.lengthAttr, 1);
        }
        return super.findInstanceIdInfo(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int findPrototypeId(String string2) {
        String string3;
        int n;
        int n2;
        block42: {
            block40: {
                block41: {
                    int n3 = string2.length();
                    n2 = 3;
                    n = 0;
                    if (n3 == 11) break block40;
                    if (n3 == 14) break block41;
                    switch (n3) {
                        default: {
                            return 0;
                        }
                        case 9: {
                            n2 = 23;
                            string3 = "findIndex";
                            break block42;
                        }
                        case 8: {
                            n2 = string2.charAt(3);
                            if (n2 == 111) {
                                n2 = 4;
                                string3 = "toSource";
                            } else {
                                if (n2 != 116) return 0;
                                string3 = "toString";
                                n2 = 2;
                            }
                            break block42;
                        }
                        case 7: {
                            n2 = string2.charAt(0);
                            if (n2 != 102) {
                                if (n2 != 105) {
                                    if (n2 != 114) {
                                        if (n2 != 117) return 0;
                                        string3 = "unshift";
                                        n2 = 11;
                                    } else {
                                        n2 = 6;
                                        string3 = "reverse";
                                    }
                                } else {
                                    n2 = 15;
                                    string3 = "indexOf";
                                }
                            } else {
                                n2 = 19;
                                string3 = "forEach";
                            }
                            break block42;
                        }
                        case 6: {
                            n2 = string2.charAt(0);
                            if (n2 != 99) {
                                if (n2 != 102) {
                                    if (n2 != 114) {
                                        if (n2 != 115) return 0;
                                        n2 = 12;
                                        string3 = "splice";
                                    } else {
                                        n2 = 24;
                                        string3 = "reduce";
                                    }
                                } else {
                                    n2 = 18;
                                    string3 = "filter";
                                }
                            } else {
                                n2 = 13;
                                string3 = "concat";
                            }
                            break block42;
                        }
                        case 5: {
                            n2 = string2.charAt(1);
                            if (n2 == 104) {
                                n2 = 10;
                                string3 = "shift";
                            } else if (n2 == 108) {
                                string3 = "slice";
                                n2 = 14;
                            } else {
                                if (n2 != 118) return 0;
                                n2 = 17;
                                string3 = "every";
                            }
                            break block42;
                        }
                        case 4: {
                            n2 = string2.charAt(2);
                            if (n2 != 105) {
                                if (n2 != 109) {
                                    if (n2 != 110) {
                                        if (n2 != 114) {
                                            if (n2 != 115) return 0;
                                            n2 = 8;
                                            string3 = "push";
                                        } else {
                                            n2 = 7;
                                            string3 = "sort";
                                        }
                                    } else {
                                        n2 = 22;
                                        string3 = "find";
                                    }
                                } else {
                                    n2 = 21;
                                    string3 = "some";
                                }
                            } else {
                                n2 = 5;
                                string3 = "join";
                            }
                            break block42;
                        }
                        case 3: {
                            n2 = string2.charAt(0);
                            if (n2 == 109) {
                                if (string2.charAt(2) != 'p') return 0;
                                if (string2.charAt(1) != 'a') return 0;
                                return 20;
                            }
                            if (n2 != 112) return 0;
                            if (string2.charAt(2) != 'p') return 0;
                            if (string2.charAt(1) != 'o') return 0;
                            return 9;
                        }
                    }
                }
                string3 = "toLocaleString";
                break block42;
            }
            n2 = string2.charAt(0);
            if (n2 == 99) {
                string3 = "constructor";
                n2 = 1;
            } else if (n2 == 108) {
                n2 = 16;
                string3 = "lastIndexOf";
            } else {
                if (n2 != 114) return 0;
                n2 = 25;
                string3 = "reduceRight";
            }
        }
        if (string3 == null) return n2;
        if (string3 == string2) return n2;
        if (string3.equals(string2)) return n2;
        return n;
    }

    @Override
    protected int findPrototypeId(Symbol symbol) {
        if (SymbolKey.ITERATOR.equals(symbol)) {
            return 26;
        }
        return 0;
    }

    public Object get(int n) {
        return this.get((long)n);
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        if (!this.denseOnly && this.isGetterOrSetter(null, n, false)) {
            return super.get(n, scriptable);
        }
        Object[] objectArray = this.dense;
        if (objectArray != null && n >= 0 && n < objectArray.length) {
            return objectArray[n];
        }
        return super.get(n, scriptable);
    }

    public Object get(long l) {
        if (l >= 0L && l < this.length) {
            Object object = NativeArray.getRawElem(this, l);
            if (object != Scriptable.NOT_FOUND && object != Undefined.instance) {
                Object object2 = object;
                if (object instanceof Wrapper) {
                    object2 = ((Wrapper)object).unwrap();
                }
                return object2;
            }
            return null;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getAttributes(int n) {
        Object[] objectArray = this.dense;
        if (objectArray != null && n >= 0 && n < objectArray.length && objectArray[n] != NOT_FOUND) {
            return 0;
        }
        return super.getAttributes(n);
    }

    @Override
    public String getClassName() {
        return "Array";
    }

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        if (clazz == ScriptRuntime.NumberClass && Context.getContext().getLanguageVersion() == 120) {
            return this.length;
        }
        return super.getDefaultValue(clazz);
    }

    @Override
    public Object[] getIds(boolean bl, boolean bl2) {
        Object[] objectArray = super.getIds(bl, bl2);
        Object[] objectArray2 = this.dense;
        if (objectArray2 == null) {
            return objectArray;
        }
        int n = objectArray2.length;
        long l = this.length;
        int n2 = n;
        if ((long)n > l) {
            n2 = (int)l;
        }
        if (n2 == 0) {
            return objectArray;
        }
        int n3 = objectArray.length;
        Object[] objectArray3 = new Object[n2 + n3];
        int n4 = 0;
        for (n = 0; n != n2; ++n) {
            int n5 = n4;
            if (this.dense[n] != NOT_FOUND) {
                objectArray3[n4] = n;
                n5 = n4 + 1;
            }
            n4 = n5;
        }
        objectArray2 = objectArray3;
        if (n4 != n2) {
            objectArray2 = new Object[n4 + n3];
            System.arraycopy(objectArray3, 0, objectArray2, 0, n4);
        }
        System.arraycopy(objectArray, 0, objectArray2, n4, n3);
        return objectArray2;
    }

    public Integer[] getIndexIds() {
        Object[] objectArray = this.getIds();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(objectArray.length);
        for (Object object : objectArray) {
            int n = ScriptRuntime.toInt32(object);
            if (n < 0 || !ScriptRuntime.toString(n).equals(ScriptRuntime.toString(object))) continue;
            arrayList.add(n);
        }
        return arrayList.toArray(new Integer[arrayList.size()]);
    }

    @Override
    protected String getInstanceIdName(int n) {
        if (n == 1) {
            return "length";
        }
        return super.getInstanceIdName(n);
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        if (n == 1) {
            return ScriptRuntime.wrapNumber(this.length);
        }
        return super.getInstanceIdValue(n);
    }

    public long getLength() {
        return this.length;
    }

    @Override
    protected int getMaxInstanceId() {
        return 1;
    }

    @Override
    protected ScriptableObject getOwnPropertyDescriptor(Context context, Object object) {
        Object[] objectArray;
        int n;
        if (this.dense != null && (n = NativeArray.toDenseIndex(object)) >= 0 && n < (objectArray = this.dense).length && objectArray[n] != NOT_FOUND) {
            return this.defaultIndexPropertyDescriptor(this.dense[n]);
        }
        return super.getOwnPropertyDescriptor(context, object);
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        boolean bl = this.denseOnly;
        boolean bl2 = false;
        if (!bl && this.isGetterOrSetter(null, n, false)) {
            return super.has(n, scriptable);
        }
        Object[] objectArray = this.dense;
        if (objectArray != null && n >= 0 && n < objectArray.length) {
            if (objectArray[n] != NOT_FOUND) {
                bl2 = true;
            }
            return bl2;
        }
        return super.has(n, scriptable);
    }

    @Override
    public int indexOf(Object object) {
        long l = this.length;
        if (l <= Integer.MAX_VALUE) {
            int n;
            int n2 = (int)l;
            int n3 = 0;
            if (object == null) {
                for (n = n3; n < n2; ++n) {
                    if (this.get(n) != null) continue;
                    return n;
                }
            } else {
                for (n = 0; n < n2; ++n) {
                    if (!object.equals(this.get(n))) continue;
                    return n;
                }
            }
            return -1;
        }
        throw new IllegalStateException();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void initPrototypeId(int var1_1) {
        block29: {
            block28: {
                if (var1_1 == 26) {
                    this.initPrototypeMethod(NativeArray.ARRAY_TAG, var1_1, SymbolKey.ITERATOR, "[Symbol.iterator]", 0);
                    return;
                }
                switch (var1_1) {
                    default: {
                        throw new IllegalArgumentException(String.valueOf(var1_1));
                    }
                    case 25: {
                        var2_2 = "reduceRight";
                        break block28;
                    }
                    case 24: {
                        var2_2 = "reduce";
                        break block28;
                    }
                    case 23: {
                        var2_2 = "findIndex";
                        break block28;
                    }
                    case 22: {
                        var2_2 = "find";
                        break block28;
                    }
                    case 21: {
                        var2_2 = "some";
                        break block28;
                    }
                    case 20: {
                        var2_2 = "map";
                        break block28;
                    }
                    case 19: {
                        var2_2 = "forEach";
                        break block28;
                    }
                    case 18: {
                        var2_2 = "filter";
                        break block28;
                    }
                    case 17: {
                        var2_2 = "every";
                        break block28;
                    }
                    case 16: {
                        var2_2 = "lastIndexOf";
                        break block28;
                    }
                    case 15: {
                        var2_2 = "indexOf";
                        break block28;
                    }
                    case 14: {
                        var2_2 = "slice";
                        ** GOTO lbl49
                    }
                    case 13: {
                        var2_2 = "concat";
                        break block28;
                    }
                    case 12: {
                        var2_2 = "splice";
lbl49:
                        // 2 sources

                        var3_3 = 2;
                        break block29;
                    }
                    case 11: {
                        var2_2 = "unshift";
                        break block28;
                    }
                    case 10: {
                        var2_2 = "shift";
                        ** GOTO lbl80
                    }
                    case 9: {
                        var2_2 = "pop";
                        ** GOTO lbl80
                    }
                    case 8: {
                        var2_2 = "push";
                        break block28;
                    }
                    case 7: {
                        var2_2 = "sort";
                        break block28;
                    }
                    case 6: {
                        var2_2 = "reverse";
                        ** GOTO lbl80
                    }
                    case 5: {
                        var2_2 = "join";
                        break block28;
                    }
                    case 4: {
                        var2_2 = "toSource";
                        ** GOTO lbl80
                    }
                    case 3: {
                        var2_2 = "toLocaleString";
                        ** GOTO lbl80
                    }
                    case 2: {
                        var2_2 = "toString";
lbl80:
                        // 6 sources

                        var3_3 = 0;
                        break block29;
                    }
                    case 1: 
                }
                var2_2 = "constructor";
            }
            var3_3 = 1;
        }
        this.initPrototypeMethod(NativeArray.ARRAY_TAG, var1_1, var2_2, null, var3_3);
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.length == 0L;
        return bl;
    }

    @Override
    public Iterator iterator() {
        return this.listIterator(0);
    }

    @Deprecated
    public long jsGet_length() {
        return this.getLength();
    }

    @Override
    public int lastIndexOf(Object object) {
        long l = this.length;
        if (l <= Integer.MAX_VALUE) {
            int n = (int)l;
            if (object == null) {
                --n;
                while (n >= 0) {
                    if (this.get(n) == null) {
                        return n;
                    }
                    --n;
                }
            } else {
                --n;
                while (n >= 0) {
                    if (object.equals(this.get(n))) {
                        return n;
                    }
                    --n;
                }
            }
            return -1;
        }
        throw new IllegalStateException();
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(final int n) {
        long l = this.length;
        if (l <= Integer.MAX_VALUE) {
            final int n2 = (int)l;
            if (n >= 0 && n <= n2) {
                return new ListIterator(){
                    int cursor;
                    {
                        this.cursor = n3;
                    }

                    public void add(Object object) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean hasNext() {
                        boolean bl = this.cursor < n2;
                        return bl;
                    }

                    @Override
                    public boolean hasPrevious() {
                        boolean bl = this.cursor > 0;
                        return bl;
                    }

                    @Override
                    public Object next() {
                        int n3 = this.cursor;
                        if (n3 != n2) {
                            NativeArray nativeArray = NativeArray.this;
                            this.cursor = n3 + 1;
                            return nativeArray.get(n3);
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public int nextIndex() {
                        return this.cursor;
                    }

                    public Object previous() {
                        int n3 = this.cursor;
                        if (n3 != 0) {
                            NativeArray nativeArray = NativeArray.this;
                            this.cursor = --n3;
                            return nativeArray.get(n3);
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public int previousIndex() {
                        return this.cursor - 1;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    public void set(Object object) {
                        throw new UnsupportedOperationException();
                    }
                };
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Index: ");
            stringBuilder.append(n);
            throw new IndexOutOfBoundsException(stringBuilder.toString());
        }
        throw new IllegalStateException();
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        long l;
        long l2;
        if (!(scriptable != this || this.isSealed() || this.dense == null || n < 0 || !this.denseOnly && this.isGetterOrSetter(null, n, true))) {
            if (!this.isExtensible() && this.length <= (long)n) {
                return;
            }
            Object[] objectArray = this.dense;
            if (n < objectArray.length) {
                objectArray[n] = object;
                long l3 = this.length;
                long l4 = n;
                if (l3 <= l4) {
                    this.length = l4 + 1L;
                }
                return;
            }
            if (this.denseOnly && (double)n < (double)objectArray.length * 1.5 && this.ensureCapacity(n + 1)) {
                this.dense[n] = object;
                this.length = (long)n + 1L;
                return;
            }
            this.denseOnly = false;
        }
        super.put(n, scriptable, object);
        if (scriptable == this && (this.lengthAttr & 1) == 0 && (l2 = this.length) <= (l = (long)n)) {
            this.length = l + 1L;
        }
    }

    @Override
    public void put(String string2, Scriptable scriptable, Object object) {
        long l;
        super.put(string2, scriptable, object);
        if (scriptable == this && (l = NativeArray.toArrayIndex(string2)) >= this.length) {
            this.length = l + 1L;
            this.denseOnly = false;
        }
    }

    public Object remove(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public Object set(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    void setDenseOnly(boolean bl) {
        if (bl && !this.denseOnly) {
            throw new IllegalArgumentException();
        }
        this.denseOnly = bl;
    }

    @Override
    protected void setInstanceIdAttributes(int n, int n2) {
        if (n == 1) {
            this.lengthAttr = n2;
        }
    }

    @Override
    protected void setInstanceIdValue(int n, Object object) {
        if (n == 1) {
            this.setLength(object);
            return;
        }
        super.setInstanceIdValue(n, object);
    }

    @Override
    public int size() {
        long l = this.length;
        if (l <= Integer.MAX_VALUE) {
            return (int)l;
        }
        throw new IllegalStateException();
    }

    public List subList(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        return this.toArray(ScriptRuntime.emptyArgs);
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        long l = this.length;
        if (l <= Integer.MAX_VALUE) {
            int n = (int)l;
            if (objectArray.length < n) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
            }
            for (int i = 0; i < n; ++i) {
                objectArray[i] = this.get(i);
            }
            return objectArray;
        }
        throw new IllegalStateException();
    }

    public static final class ElementComparator
    implements Comparator<Object> {
        private final Comparator<Object> child;

        public ElementComparator() {
            this.child = STRING_COMPARATOR;
        }

        public ElementComparator(Comparator<Object> comparator) {
            this.child = comparator;
        }

        @Override
        public int compare(Object object, Object object2) {
            Object object3 = Undefined.instance;
            int n = 1;
            if (object == object3) {
                if (object2 == Undefined.instance) {
                    return 0;
                }
                if (object2 == Scriptable.NOT_FOUND) {
                    return -1;
                }
                return 1;
            }
            if (object == Scriptable.NOT_FOUND) {
                if (object2 == Scriptable.NOT_FOUND) {
                    n = 0;
                }
                return n;
            }
            if (object2 == Scriptable.NOT_FOUND) {
                return -1;
            }
            if (object2 == Undefined.instance) {
                return -1;
            }
            return this.child.compare(object, object2);
        }
    }

    public static final class StringLikeComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object object, Object object2) {
            return ScriptRuntime.toString(object).compareTo(ScriptRuntime.toString(object2));
        }
    }
}

