/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.ES6Iterator;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public final class NativeArrayIterator
extends ES6Iterator {
    private static final String ITERATOR_TAG = "ArrayIterator";
    private static final long serialVersionUID = 1L;
    private Scriptable arrayLike;
    private int index;

    private NativeArrayIterator() {
    }

    public NativeArrayIterator(Scriptable scriptable, Scriptable scriptable2) {
        super(scriptable);
        this.index = 0;
        this.arrayLike = scriptable2;
    }

    static void init(ScriptableObject scriptableObject, boolean bl) {
        ES6Iterator.init(scriptableObject, bl, new NativeArrayIterator(), ITERATOR_TAG);
    }

    @Override
    public String getClassName() {
        return "Array Iterator";
    }

    @Override
    protected String getTag() {
        return ITERATOR_TAG;
    }

    @Override
    protected boolean isDone(Context context, Scriptable scriptable) {
        boolean bl = (long)this.index >= NativeArray.getLengthProperty(context, this.arrayLike);
        return bl;
    }

    @Override
    protected Object nextValue(Context object, Scriptable object2) {
        object = this.arrayLike;
        int n = this.index;
        this.index = n + 1;
        object = object2 = object.get(n, (Scriptable)object);
        if (object2 == ScriptableObject.NOT_FOUND) {
            object = Undefined.instance;
        }
        return object;
    }
}

