/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

final class NativeBoolean
extends IdScriptableObject {
    private static final Object BOOLEAN_TAG = "Boolean";
    private static final int Id_constructor = 1;
    private static final int Id_toSource = 3;
    private static final int Id_toString = 2;
    private static final int Id_valueOf = 4;
    private static final int MAX_PROTOTYPE_ID = 4;
    static final long serialVersionUID = -3716996899943880933L;
    private boolean booleanValue;

    NativeBoolean(boolean bl) {
        this.booleanValue = bl;
    }

    static void init(Scriptable scriptable, boolean bl) {
        new NativeBoolean(false).exportAsJSClass(4, scriptable, bl);
    }

    @Override
    public Object execIdCall(IdFunctionObject object, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!((IdFunctionObject)object).hasTag(BOOLEAN_TAG)) {
            return super.execIdCall((IdFunctionObject)object, context, scriptable, scriptable2, objectArray);
        }
        int n = ((IdFunctionObject)object).methodId();
        boolean bl = true;
        if (n == 1) {
            n = objectArray.length;
            boolean bl2 = false;
            if (n == 0) {
                bl = bl2;
            } else if (!(objectArray[0] instanceof ScriptableObject) || !((ScriptableObject)objectArray[0]).avoidObjectDetection()) {
                bl = ScriptRuntime.toBoolean(objectArray[0]);
            }
            if (scriptable2 == null) {
                return new NativeBoolean(bl);
            }
            return ScriptRuntime.wrapBoolean(bl);
        }
        if (scriptable2 instanceof NativeBoolean) {
            bl = ((NativeBoolean)scriptable2).booleanValue;
            if (n != 2) {
                if (n != 3) {
                    if (n == 4) {
                        return ScriptRuntime.wrapBoolean(bl);
                    }
                    throw new IllegalArgumentException(String.valueOf(n));
                }
                object = bl ? "(new Boolean(true))" : "(new Boolean(false))";
                return object;
            }
            object = bl ? "true" : "false";
            return object;
        }
        throw NativeBoolean.incompatibleCallError((IdFunctionObject)object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int findPrototypeId(String string2) {
        String string3;
        int n = string2.length();
        int n2 = 3;
        int n3 = 0;
        if (n == 7) {
            n2 = 4;
            string3 = "valueOf";
        } else if (n == 8) {
            n = string2.charAt(3);
            if (n == 111) {
                string3 = "toSource";
            } else {
                if (n != 116) return 0;
                n2 = 2;
                string3 = "toString";
            }
        } else {
            if (n != 11) return 0;
            n2 = 1;
            string3 = "constructor";
        }
        if (string3 == null) return n2;
        if (string3 == string2) return n2;
        if (string3.equals(string2)) return n2;
        return n3;
    }

    @Override
    public String getClassName() {
        return "Boolean";
    }

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        if (clazz == ScriptRuntime.BooleanClass) {
            return ScriptRuntime.wrapBoolean(this.booleanValue);
        }
        return super.getDefaultValue(clazz);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void initPrototypeId(int n) {
        String string2;
        int n2 = 0;
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    if (n != 4) throw new IllegalArgumentException(String.valueOf(n));
                    string2 = "valueOf";
                } else {
                    string2 = "toSource";
                }
            } else {
                string2 = "toString";
            }
        } else {
            string2 = "constructor";
            n2 = 1;
        }
        this.initPrototypeMethod(BOOLEAN_TAG, n, string2, n2);
    }
}

