/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Arguments;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public final class NativeCall
extends IdScriptableObject {
    private static final Object CALL_TAG = "Call";
    private static final int Id_constructor = 1;
    private static final int MAX_PROTOTYPE_ID = 1;
    static final long serialVersionUID = -7471457301304454454L;
    private Arguments arguments;
    NativeFunction function;
    boolean isStrict;
    Object[] originalArgs;
    transient NativeCall parentActivationCall;

    NativeCall() {
    }

    NativeCall(NativeFunction nativeFunction, Scriptable object, Object[] objectArray, boolean bl, boolean bl2) {
        int n;
        this.function = nativeFunction;
        this.setParentScope((Scriptable)object);
        object = objectArray == null ? ScriptRuntime.emptyArgs : objectArray;
        this.originalArgs = object;
        this.isStrict = bl2;
        int n2 = nativeFunction.getParamAndVarCount();
        int n3 = nativeFunction.getParamCount();
        if (n2 != 0) {
            for (n = 0; n < n3; ++n) {
                String string2 = nativeFunction.getParamOrVarName(n);
                object = n < objectArray.length ? objectArray[n] : Undefined.instance;
                this.defineProperty(string2, object, 4);
            }
        }
        if (!super.has("arguments", (Scriptable)this) && !bl) {
            this.arguments = object = new Arguments(this);
            this.defineProperty("arguments", object, 4);
        }
        if (n2 != 0) {
            for (n = n3; n < n2; ++n) {
                object = nativeFunction.getParamOrVarName(n);
                if (super.has((String)object, (Scriptable)this)) continue;
                if (nativeFunction.getParamOrVarConst(n)) {
                    this.defineProperty((String)object, Undefined.instance, 13);
                    continue;
                }
                this.defineProperty((String)object, Undefined.instance, 4);
            }
        }
    }

    static void init(Scriptable scriptable, boolean bl) {
        new NativeCall().exportAsJSClass(1, scriptable, bl);
    }

    public void defineAttributesForArguments() {
        Arguments arguments = this.arguments;
        if (arguments != null) {
            arguments.defineAttributesForStrictMode();
        }
    }

    @Override
    public Object execIdCall(IdFunctionObject idScriptableObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!((IdFunctionObject)idScriptableObject).hasTag(CALL_TAG)) {
            return super.execIdCall((IdFunctionObject)idScriptableObject, context, scriptable, scriptable2, objectArray);
        }
        int n = ((IdFunctionObject)idScriptableObject).methodId();
        if (n == 1) {
            if (scriptable2 == null) {
                ScriptRuntime.checkDeprecated(context, "Call");
                idScriptableObject = new NativeCall();
                idScriptableObject.setPrototype(NativeCall.getObjectPrototype(scriptable));
                return idScriptableObject;
            }
            throw Context.reportRuntimeError1("msg.only.from.new", "Call");
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    @Override
    protected int findPrototypeId(String string2) {
        return string2.equals("constructor") ? 1 : 0;
    }

    @Override
    public String getClassName() {
        return "Call";
    }

    @Override
    protected void initPrototypeId(int n) {
        if (n == 1) {
            this.initPrototypeMethod(CALL_TAG, n, "constructor", 1);
            return;
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }
}

