/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptStackElement;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class NativeCallSite
extends IdScriptableObject {
    private static final String CALLSITE_TAG = "CallSite";
    private static final int Id_constructor = 1;
    private static final int Id_getColumnNumber = 9;
    private static final int Id_getEvalOrigin = 10;
    private static final int Id_getFileName = 7;
    private static final int Id_getFunction = 4;
    private static final int Id_getFunctionName = 5;
    private static final int Id_getLineNumber = 8;
    private static final int Id_getMethodName = 6;
    private static final int Id_getThis = 2;
    private static final int Id_getTypeName = 3;
    private static final int Id_isConstructor = 14;
    private static final int Id_isEval = 12;
    private static final int Id_isNative = 13;
    private static final int Id_isToplevel = 11;
    private static final int Id_toString = 15;
    private static final int MAX_PROTOTYPE_ID = 15;
    private ScriptStackElement element;

    private NativeCallSite() {
    }

    private Object getFalse() {
        return Boolean.FALSE;
    }

    private Object getFileName(Scriptable object) {
        while (object != null && !(object instanceof NativeCallSite)) {
            object = object.getPrototype();
        }
        if (object == null) {
            return NOT_FOUND;
        }
        object = ((NativeCallSite)object).element;
        object = object == null ? null : ((ScriptStackElement)object).fileName;
        return object;
    }

    private Object getFunctionName(Scriptable object) {
        while (object != null && !(object instanceof NativeCallSite)) {
            object = object.getPrototype();
        }
        if (object == null) {
            return NOT_FOUND;
        }
        object = ((NativeCallSite)object).element;
        object = object == null ? null : ((ScriptStackElement)object).functionName;
        return object;
    }

    private Object getLineNumber(Scriptable scriptable) {
        while (scriptable != null && !(scriptable instanceof NativeCallSite)) {
            scriptable = scriptable.getPrototype();
        }
        if (scriptable == null) {
            return NOT_FOUND;
        }
        scriptable = (NativeCallSite)scriptable;
        ScriptStackElement scriptStackElement = ((NativeCallSite)scriptable).element;
        if (scriptStackElement != null && scriptStackElement.lineNumber >= 0) {
            return ((NativeCallSite)scriptable).element.lineNumber;
        }
        return Undefined.instance;
    }

    private Object getNull() {
        return null;
    }

    private Object getUndefined() {
        return Undefined.instance;
    }

    static void init(Scriptable scriptable, boolean bl) {
        new NativeCallSite().exportAsJSClass(15, scriptable, bl);
    }

    private Object js_toString(Scriptable object) {
        while (object != null && !(object instanceof NativeCallSite)) {
            object = object.getPrototype();
        }
        if (object == null) {
            return NOT_FOUND;
        }
        NativeCallSite nativeCallSite = (NativeCallSite)object;
        object = new StringBuilder();
        nativeCallSite.element.renderJavaStyle((StringBuilder)object);
        return ((StringBuilder)object).toString();
    }

    static NativeCallSite make(Scriptable scriptable, Scriptable scriptable2) {
        Scriptable scriptable3;
        NativeCallSite nativeCallSite = new NativeCallSite();
        scriptable2 = scriptable3 = (Scriptable)scriptable2.get("prototype", scriptable2);
        nativeCallSite.setParentScope(scriptable);
        nativeCallSite.setPrototype(scriptable3);
        return nativeCallSite;
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(CALLSITE_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
            case 15: {
                return this.js_toString(scriptable2);
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return this.getFalse();
            }
            case 8: {
                return this.getLineNumber(scriptable2);
            }
            case 7: {
                return this.getFileName(scriptable2);
            }
            case 6: {
                return this.getNull();
            }
            case 5: {
                return this.getFunctionName(scriptable2);
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                return this.getUndefined();
            }
            case 1: 
        }
        return NativeCallSite.make(scriptable, idFunctionObject);
    }

    @Override
    protected int findPrototypeId(String string2) {
        int n;
        block26: {
            String string3;
            int n2;
            block25: {
                int n3 = string2.length();
                n = 4;
                n2 = 0;
                switch (n3) {
                    default: {
                        break;
                    }
                    case 15: {
                        n = string2.charAt(3);
                        if (n == 67) {
                            n = 9;
                            string3 = "getColumnNumber";
                        } else {
                            if (n != 70) break;
                            n = 5;
                            string3 = "getFunctionName";
                        }
                        break block25;
                    }
                    case 13: {
                        n = string2.charAt(3);
                        if (n != 69) {
                            if (n != 111) {
                                if (n != 76) {
                                    if (n != 77) break;
                                    n = 6;
                                    string3 = "getMethodName";
                                } else {
                                    n = 8;
                                    string3 = "getLineNumber";
                                }
                            } else {
                                n = 14;
                                string3 = "isConstructor";
                            }
                        } else {
                            n = 10;
                            string3 = "getEvalOrigin";
                        }
                        break block25;
                    }
                    case 11: {
                        n3 = string2.charAt(4);
                        if (n3 != 105) {
                            if (n3 != 121) {
                                if (n3 != 116) {
                                    if (n3 != 117) break;
                                    string3 = "getFunction";
                                } else {
                                    n = 1;
                                    string3 = "constructor";
                                }
                            } else {
                                string3 = "getTypeName";
                                n = 3;
                            }
                        } else {
                            n = 7;
                            string3 = "getFileName";
                        }
                        break block25;
                    }
                    case 10: {
                        n = 11;
                        string3 = "isToplevel";
                        break block25;
                    }
                    case 8: {
                        n = string2.charAt(0);
                        if (n == 105) {
                            n = 13;
                            string3 = "isNative";
                        } else {
                            if (n != 116) break;
                            n = 15;
                            string3 = "toString";
                        }
                        break block25;
                    }
                    case 7: {
                        n = 2;
                        string3 = "getThis";
                        break block25;
                    }
                    case 6: {
                        n = 12;
                        string3 = "isEval";
                        break block25;
                    }
                }
                string3 = null;
                n = 0;
            }
            if (string3 == null || string3 == string2 || string3.equals(string2)) break block26;
            n = n2;
        }
        return n;
    }

    @Override
    public String getClassName() {
        return CALLSITE_TAG;
    }

    @Override
    protected void initPrototypeId(int n) {
        String string2;
        switch (n) {
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
            case 15: {
                string2 = "toString";
                break;
            }
            case 14: {
                string2 = "isConstructor";
                break;
            }
            case 13: {
                string2 = "isNative";
                break;
            }
            case 12: {
                string2 = "isEval";
                break;
            }
            case 11: {
                string2 = "isToplevel";
                break;
            }
            case 10: {
                string2 = "getEvalOrigin";
                break;
            }
            case 9: {
                string2 = "getColumnNumber";
                break;
            }
            case 8: {
                string2 = "getLineNumber";
                break;
            }
            case 7: {
                string2 = "getFileName";
                break;
            }
            case 6: {
                string2 = "getMethodName";
                break;
            }
            case 5: {
                string2 = "getFunctionName";
                break;
            }
            case 4: {
                string2 = "getFunction";
                break;
            }
            case 3: {
                string2 = "getTypeName";
                break;
            }
            case 2: {
                string2 = "getThis";
                break;
            }
            case 1: {
                string2 = "constructor";
            }
        }
        this.initPrototypeMethod(CALLSITE_TAG, n, string2, 0);
    }

    void setElement(ScriptStackElement scriptStackElement) {
        this.element = scriptStackElement;
    }

    public String toString() {
        ScriptStackElement scriptStackElement = this.element;
        if (scriptStackElement == null) {
            return "";
        }
        return scriptStackElement.toString();
    }
}

