/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeCallSite;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ScriptStackElement;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

final class NativeError
extends IdScriptableObject {
    private static final int ConstructorId_captureStackTrace = -1;
    public static final int DEFAULT_STACK_LIMIT = -1;
    private static final Method ERROR_DELEGATE_GET_STACK;
    private static final Method ERROR_DELEGATE_SET_STACK;
    private static final Object ERROR_TAG;
    private static final int Id_constructor = 1;
    private static final int Id_toSource = 3;
    private static final int Id_toString = 2;
    private static final int MAX_PROTOTYPE_ID = 3;
    private static final String STACK_HIDE_KEY = "_stackHide";
    static final long serialVersionUID = -5338413581437645187L;
    private RhinoException stackProvider;

    static {
        ERROR_TAG = "Error";
        try {
            ERROR_DELEGATE_GET_STACK = NativeError.class.getMethod("getStackDelegated", Scriptable.class);
            ERROR_DELEGATE_SET_STACK = NativeError.class.getMethod("setStackDelegated", Scriptable.class, Object.class);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }

    NativeError() {
    }

    private Object callPrepareStack(Function function, ScriptStackElement[] scriptStackElementArray) {
        Context context = Context.getCurrentContext();
        Object[] objectArray = new Object[scriptStackElementArray.length];
        for (int i = 0; i < scriptStackElementArray.length; ++i) {
            NativeCallSite nativeCallSite = (NativeCallSite)context.newObject(this, "CallSite");
            nativeCallSite.setElement(scriptStackElementArray[i]);
            objectArray[i] = nativeCallSite;
        }
        return function.call(context, function, this, new Object[]{this, context.newArray((Scriptable)this, objectArray)});
    }

    static void init(Scriptable scriptable, boolean bl) {
        NativeError nativeError = new NativeError();
        ScriptableObject.putProperty((Scriptable)nativeError, "name", (Object)"Error");
        ScriptableObject.putProperty((Scriptable)nativeError, "message", (Object)"");
        ScriptableObject.putProperty((Scriptable)nativeError, "fileName", (Object)"");
        ScriptableObject.putProperty((Scriptable)nativeError, "lineNumber", (Object)0);
        nativeError.setAttributes("name", 2);
        nativeError.setAttributes("message", 2);
        nativeError.exportAsJSClass(3, scriptable, bl);
        NativeCallSite.init(nativeError, bl);
    }

    private static void js_captureStackTrace(Context object, Scriptable object2, Object[] object3) {
        ScriptableObject scriptableObject = (ScriptableObject)ScriptRuntime.toObjectOrNull((Context)object, object3[0], (Scriptable)object2);
        object3 = ((Object[])object3).length > 1 ? (Function)ScriptRuntime.toObjectOrNull((Context)object, object3[1], (Scriptable)object2) : null;
        object = (NativeError)((Context)object).newObject((Scriptable)object2, "Error");
        ((NativeError)object).setStackProvider(new EvaluatorException("[object Object]"));
        if (object3 != null && (object2 = object3.get("name", (Scriptable)object3)) != null && !Undefined.instance.equals(object2)) {
            ((ScriptableObject)object).associateValue(STACK_HIDE_KEY, Context.toString(object2));
        }
        scriptableObject.defineProperty("stack", object, ERROR_DELEGATE_GET_STACK, ERROR_DELEGATE_SET_STACK, 0);
    }

    private static String js_toSource(Context context, Scriptable scriptable, Scriptable object) {
        Object object2 = ScriptableObject.getProperty((Scriptable)object, "name");
        Object object3 = ScriptableObject.getProperty((Scriptable)object, "message");
        Object object4 = ScriptableObject.getProperty((Scriptable)object, "fileName");
        Object object5 = ScriptableObject.getProperty((Scriptable)object, "lineNumber");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(new ");
        object = object2;
        if (object2 == NOT_FOUND) {
            object = Undefined.instance;
        }
        stringBuilder.append(ScriptRuntime.toString(object));
        stringBuilder.append("(");
        if (object3 != NOT_FOUND || object4 != NOT_FOUND || object5 != NOT_FOUND) {
            object = object3;
            if (object3 == NOT_FOUND) {
                object = "";
            }
            stringBuilder.append(ScriptRuntime.uneval(context, scriptable, object));
            if (object4 != NOT_FOUND || object5 != NOT_FOUND) {
                int n;
                stringBuilder.append(", ");
                object = object4;
                if (object4 == NOT_FOUND) {
                    object = "";
                }
                stringBuilder.append(ScriptRuntime.uneval(context, scriptable, object));
                if (object5 != NOT_FOUND && (n = ScriptRuntime.toInt32(object5)) != 0) {
                    stringBuilder.append(", ");
                    stringBuilder.append(ScriptRuntime.toString(n));
                }
            }
        }
        stringBuilder.append("))");
        return stringBuilder.toString();
    }

    private static Object js_toString(Scriptable object) {
        Object object2 = ScriptableObject.getProperty((Scriptable)object, "name");
        object2 = object2 != NOT_FOUND && object2 != Undefined.instance ? ScriptRuntime.toString(object2) : "Error";
        object = ScriptableObject.getProperty((Scriptable)object, "message");
        object = object != NOT_FOUND && object != Undefined.instance ? ScriptRuntime.toString(object) : "";
        if (object2.toString().length() == 0) {
            return object;
        }
        if (object.toString().length() == 0) {
            return object2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((String)object2);
        stringBuilder.append(": ");
        stringBuilder.append((String)object);
        return stringBuilder.toString();
    }

    static NativeError make(Context object, Scriptable scriptable, IdFunctionObject scriptable2, Object[] objectArray) {
        object = (Scriptable)((IdScriptableObject)scriptable2).get("prototype", scriptable2);
        scriptable2 = (Scriptable)object;
        scriptable2 = new NativeError();
        ((ScriptableObject)scriptable2).setPrototype((Scriptable)object);
        ((ScriptableObject)scriptable2).setParentScope(scriptable);
        int n = objectArray.length;
        if (n >= 1) {
            if (objectArray[0] != Undefined.instance) {
                ScriptableObject.putProperty(scriptable2, "message", (Object)ScriptRuntime.toString(objectArray[0]));
            }
            if (n >= 2) {
                ScriptableObject.putProperty(scriptable2, "fileName", objectArray[1]);
                if (n >= 3) {
                    ScriptableObject.putProperty(scriptable2, "lineNumber", (Object)ScriptRuntime.toInt32(objectArray[2]));
                }
            }
        }
        return scriptable2;
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(ERROR_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        if (n != -1) {
            if (n != 1) {
                if (n != 2) {
                    if (n == 3) {
                        return NativeError.js_toSource(context, scriptable, scriptable2);
                    }
                    throw new IllegalArgumentException(String.valueOf(n));
                }
                return NativeError.js_toString(scriptable2);
            }
            return NativeError.make(context, scriptable, idFunctionObject, objectArray);
        }
        NativeError.js_captureStackTrace(context, scriptable2, objectArray);
        return Undefined.instance;
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        this.addIdFunctionProperty(idFunctionObject, ERROR_TAG, -1, "captureStackTrace", 2);
        ProtoProps protoProps = new ProtoProps();
        this.associateValue("_ErrorPrototypeProps", protoProps);
        idFunctionObject.defineProperty("stackTraceLimit", protoProps, ProtoProps.GET_STACK_LIMIT, ProtoProps.SET_STACK_LIMIT, 0);
        idFunctionObject.defineProperty("prepareStackTrace", protoProps, ProtoProps.GET_PREPARE_STACK, ProtoProps.SET_PREPARE_STACK, 0);
        super.fillConstructorProperties(idFunctionObject);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int findPrototypeId(String string2) {
        String string3;
        int n = string2.length();
        int n2 = 3;
        int n3 = 0;
        if (n == 8) {
            n = string2.charAt(3);
            if (n == 111) {
                string3 = "toSource";
            } else {
                if (n != 116) return 0;
                n2 = 2;
                string3 = "toString";
            }
        } else {
            if (n != 11) return 0;
            n2 = 1;
            string3 = "constructor";
        }
        if (string3 == null) return n2;
        if (string3 == string2) return n2;
        if (string3.equals(string2)) return n2;
        return n3;
    }

    @Override
    public String getClassName() {
        return "Error";
    }

    public Object getStackDelegated(Scriptable scriptable) {
        if (this.stackProvider == null) {
            return NOT_FOUND;
        }
        int n = -1;
        Object object = null;
        Object object2 = (ProtoProps)((NativeError)this.getPrototype()).getAssociatedValue("_ErrorPrototypeProps");
        if (object2 != null) {
            n = object2.getStackTraceLimit();
            object = object2.getPrepareStackTrace();
        }
        object2 = (String)this.getAssociatedValue(STACK_HIDE_KEY);
        object2 = this.stackProvider.getScriptStack(n, (String)object2);
        object = object == null ? RhinoException.formatStackTrace(object2, this.stackProvider.details()) : this.callPrepareStack((Function)object, (ScriptStackElement[])object2);
        this.setStackDelegated(scriptable, object);
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void initPrototypeId(int n) {
        String string2;
        int n2 = 0;
        if (n != 1) {
            if (n != 2) {
                if (n != 3) throw new IllegalArgumentException(String.valueOf(n));
                string2 = "toSource";
            } else {
                string2 = "toString";
            }
        } else {
            string2 = "constructor";
            n2 = 1;
        }
        this.initPrototypeMethod(ERROR_TAG, n, string2, n2);
    }

    public void setStackDelegated(Scriptable scriptable, Object object) {
        scriptable.delete("stack");
        this.stackProvider = null;
        scriptable.put("stack", scriptable, object);
    }

    public void setStackProvider(RhinoException rhinoException) {
        if (this.stackProvider == null) {
            this.stackProvider = rhinoException;
            this.defineProperty("stack", this, ERROR_DELEGATE_GET_STACK, ERROR_DELEGATE_SET_STACK, 2);
        }
    }

    public String toString() {
        Object object = NativeError.js_toString(this);
        object = object instanceof String ? (String)object : super.toString();
        return object;
    }

    private static final class ProtoProps
    implements Serializable {
        static final Method GET_PREPARE_STACK;
        static final Method GET_STACK_LIMIT;
        static final String KEY = "_ErrorPrototypeProps";
        static final Method SET_PREPARE_STACK;
        static final Method SET_STACK_LIMIT;
        private static final long serialVersionUID = 1907180507775337939L;
        private Function prepareStackTrace;
        private int stackTraceLimit = -1;

        static {
            try {
                GET_STACK_LIMIT = ProtoProps.class.getMethod("getStackTraceLimit", Scriptable.class);
                SET_STACK_LIMIT = ProtoProps.class.getMethod("setStackTraceLimit", Scriptable.class, Object.class);
                GET_PREPARE_STACK = ProtoProps.class.getMethod("getPrepareStackTrace", Scriptable.class);
                SET_PREPARE_STACK = ProtoProps.class.getMethod("setPrepareStackTrace", Scriptable.class, Object.class);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(noSuchMethodException);
            }
        }

        private ProtoProps() {
        }

        public Object getPrepareStackTrace(Scriptable object) {
            Function function = this.getPrepareStackTrace();
            object = function;
            if (function == null) {
                object = Undefined.instance;
            }
            return object;
        }

        public Function getPrepareStackTrace() {
            return this.prepareStackTrace;
        }

        public int getStackTraceLimit() {
            return this.stackTraceLimit;
        }

        public Object getStackTraceLimit(Scriptable scriptable) {
            int n = this.stackTraceLimit;
            if (n >= 0) {
                return n;
            }
            return Double.POSITIVE_INFINITY;
        }

        public void setPrepareStackTrace(Scriptable scriptable, Object object) {
            if (object != null && !Undefined.instance.equals(object)) {
                if (object instanceof Function) {
                    this.prepareStackTrace = (Function)object;
                }
            } else {
                this.prepareStackTrace = null;
            }
        }

        public void setStackTraceLimit(Scriptable scriptable, Object object) {
            double d = Context.toNumber(object);
            this.stackTraceLimit = !Double.isNaN(d) && !Double.isInfinite(d) ? (int)d : -1;
        }
    }
}

