/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeIterator;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public final class NativeGenerator
extends IdScriptableObject {
    public static final int GENERATOR_CLOSE = 2;
    public static final int GENERATOR_SEND = 0;
    private static final Object GENERATOR_TAG = "Generator";
    public static final int GENERATOR_THROW = 1;
    private static final int Id___iterator__ = 5;
    private static final int Id_close = 1;
    private static final int Id_next = 2;
    private static final int Id_send = 3;
    private static final int Id_throw = 4;
    private static final int MAX_PROTOTYPE_ID = 5;
    private static final long serialVersionUID = 1645892441041347273L;
    private boolean firstTime = true;
    private NativeFunction function;
    private int lineNumber;
    private String lineSource;
    private boolean locked;
    private Object savedState;

    private NativeGenerator() {
    }

    public NativeGenerator(Scriptable scriptable, NativeFunction nativeFunction, Object object) {
        this.function = nativeFunction;
        this.savedState = object;
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        this.setParentScope(scriptable);
        this.setPrototype((NativeGenerator)ScriptableObject.getTopScopeValue(scriptable, GENERATOR_TAG));
    }

    static NativeGenerator init(ScriptableObject scriptableObject, boolean bl) {
        NativeGenerator nativeGenerator = new NativeGenerator();
        if (scriptableObject != null) {
            nativeGenerator.setParentScope(scriptableObject);
            nativeGenerator.setPrototype(NativeGenerator.getObjectPrototype(scriptableObject));
        }
        nativeGenerator.activatePrototypeMap(5);
        if (bl) {
            nativeGenerator.sealObject();
        }
        if (scriptableObject != null) {
            scriptableObject.associateValue(GENERATOR_TAG, nativeGenerator);
        }
        return nativeGenerator;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object resume(Context object, Scriptable scriptable, int n, Object object2) {
        Throwable throwable2;
        block22: {
            if (this.savedState == null) {
                if (n == 2) {
                    return Undefined.instance;
                }
                if (n == 1) {
                    throw new JavaScriptException(object2, this.lineSource, this.lineNumber);
                }
                object2 = NativeIterator.getStopIterationObject(scriptable);
                throw new JavaScriptException(object2, this.lineSource, this.lineNumber);
            }
            try {
                synchronized (this) {
                    if (this.locked) throw ScriptRuntime.typeError0("msg.already.exec.gen");
                    this.locked = true;
                }
            }
            catch (Throwable throwable2) {
                break block22;
            }
            catch (RhinoException rhinoException) {
                this.lineNumber = rhinoException.lineNumber();
                this.lineSource = rhinoException.lineSource();
                this.savedState = null;
                throw rhinoException;
            }
            catch (GeneratorClosedException generatorClosedException) {
                Object object3 = Undefined.instance;
                synchronized (this) {
                    this.locked = false;
                }
                if (n != 2) return object3;
                this.savedState = null;
                return object3;
            }
            {
                object = this.function.resumeGenerator((Context)object, scriptable, n, this.savedState, object2);
            }
            synchronized (this) {
                this.locked = false;
            }
            if (n != 2) return object;
            this.savedState = null;
            return object;
        }
        synchronized (this) {
            this.locked = false;
        }
        if (n != 2) throw throwable2;
        this.savedState = null;
        throw throwable2;
    }

    @Override
    public Object execIdCall(IdFunctionObject object, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!((IdFunctionObject)object).hasTag(GENERATOR_TAG)) {
            return super.execIdCall((IdFunctionObject)object, context, scriptable, scriptable2, objectArray);
        }
        int n = ((IdFunctionObject)object).methodId();
        if (scriptable2 instanceof NativeGenerator) {
            NativeGenerator nativeGenerator = (NativeGenerator)scriptable2;
            if (n != 1) {
                if (n != 2) {
                    if (n != 3) {
                        if (n != 4) {
                            if (n == 5) {
                                return scriptable2;
                            }
                            throw new IllegalArgumentException(String.valueOf(n));
                        }
                        object = objectArray.length > 0 ? objectArray[0] : Undefined.instance;
                        return nativeGenerator.resume(context, scriptable, 1, object);
                    }
                    object = objectArray.length > 0 ? objectArray[0] : Undefined.instance;
                    if (nativeGenerator.firstTime && !object.equals(Undefined.instance)) {
                        throw ScriptRuntime.typeError0("msg.send.newborn");
                    }
                    return nativeGenerator.resume(context, scriptable, 0, object);
                }
                nativeGenerator.firstTime = false;
                return nativeGenerator.resume(context, scriptable, 0, Undefined.instance);
            }
            return nativeGenerator.resume(context, scriptable, 2, new GeneratorClosedException());
        }
        throw NativeGenerator.incompatibleCallError((IdFunctionObject)object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int findPrototypeId(String string2) {
        String string3;
        int n = string2.length();
        int n2 = 5;
        int n3 = 0;
        if (n == 4) {
            n2 = string2.charAt(0);
            if (n2 == 110) {
                n2 = 2;
                string3 = "next";
            } else {
                if (n2 != 115) return 0;
                n2 = 3;
                string3 = "send";
            }
        } else if (n == 5) {
            n2 = string2.charAt(0);
            if (n2 == 99) {
                n2 = 1;
                string3 = "close";
            } else {
                if (n2 != 116) return 0;
                string3 = "throw";
                n2 = 4;
            }
        } else {
            if (n != 12) return 0;
            string3 = "__iterator__";
        }
        if (string3 == null) return n2;
        if (string3 == string2) return n2;
        if (string3.equals(string2)) return n2;
        return n3;
    }

    @Override
    public String getClassName() {
        return "Generator";
    }

    @Override
    protected void initPrototypeId(int n) {
        String string2;
        int n2;
        block5: {
            block0: {
                block1: {
                    block6: {
                        block2: {
                            block3: {
                                block4: {
                                    n2 = 1;
                                    if (n == 1) break block0;
                                    if (n == 2) break block1;
                                    if (n == 3) break block2;
                                    if (n == 4) break block3;
                                    if (n != 5) break block4;
                                    string2 = "__iterator__";
                                    break block5;
                                }
                                throw new IllegalArgumentException(String.valueOf(n));
                            }
                            string2 = "throw";
                            break block6;
                        }
                        string2 = "send";
                    }
                    n2 = 0;
                    break block5;
                }
                string2 = "next";
                break block5;
            }
            string2 = "close";
        }
        this.initPrototypeMethod(GENERATOR_TAG, n, string2, n2);
    }

    public static class GeneratorClosedException
    extends RuntimeException {
        private static final long serialVersionUID = 2561315658662379681L;
    }
}

