/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.IdFunctionCall;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeError;
import org.mozilla.javascript.NativeNumber;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.xml.XMLLib;

public class NativeGlobal
implements Serializable,
IdFunctionCall {
    private static final Object FTAG = "Global";
    private static final int INVALID_UTF8 = Integer.MAX_VALUE;
    private static final int Id_decodeURI = 1;
    private static final int Id_decodeURIComponent = 2;
    private static final int Id_encodeURI = 3;
    private static final int Id_encodeURIComponent = 4;
    private static final int Id_escape = 5;
    private static final int Id_eval = 6;
    private static final int Id_isFinite = 7;
    private static final int Id_isNaN = 8;
    private static final int Id_isXMLName = 9;
    private static final int Id_new_CommonError = 14;
    private static final int Id_parseFloat = 10;
    private static final int Id_parseInt = 11;
    private static final int Id_unescape = 12;
    private static final int Id_uneval = 13;
    private static final int LAST_SCOPE_FUNCTION_ID = 13;
    private static final String URI_DECODE_RESERVED = ";/?:@&=+$,#";
    static final long serialVersionUID = 6080442165748707530L;

    @Deprecated
    public static EcmaError constructError(Context context, String string2, String string3, Scriptable scriptable) {
        return ScriptRuntime.constructError(string2, string3);
    }

    @Deprecated
    public static EcmaError constructError(Context context, String string2, String string3, Scriptable scriptable, String string4, int n, int n2, String string5) {
        return ScriptRuntime.constructError(string2, string3, string4, n, string5, n2);
    }

    /*
     * Unable to fully structure code
     */
    private static String decode(String var0, boolean var1_1) {
        var2_2 = var0;
        var3_3 = var0.length();
        var4_4 = null;
        var5_5 = 0;
        var6_6 = 0;
        while (var5_5 != var3_3) {
            block19: {
                block20: {
                    block21: {
                        block27: {
                            block28: {
                                block18: {
                                    block31: {
                                        block29: {
                                            block30: {
                                                block23: {
                                                    block26: {
                                                        block25: {
                                                            block24: {
                                                                block22: {
                                                                    var7_7 = var2_2.charAt(var5_5);
                                                                    if (var7_7 != 37) {
                                                                        var8_8 = var6_6;
                                                                        if (var4_4 != null) {
                                                                            var4_4[var6_6] = (char)var7_7;
                                                                            var8_8 = var6_6 + 1;
                                                                        }
                                                                        ++var5_5;
                                                                        var6_6 = var8_8;
                                                                        continue;
                                                                    }
                                                                    var0 = var4_4;
                                                                    var9_9 = var6_6;
                                                                    if (var4_4 == null) {
                                                                        var0 = new char[var3_3];
                                                                        var2_2.getChars(0, var5_5, (char[])var0, 0);
                                                                        var9_9 = var5_5;
                                                                    }
                                                                    if ((var10_10 = var5_5 + 3) > var3_3) break block19;
                                                                    var11_11 = NativeGlobal.unHex(var2_2.charAt(var5_5 + 1), var2_2.charAt(var5_5 + 2));
                                                                    if (var11_11 < 0) break block20;
                                                                    if ((var11_11 & 128) == 0) {
                                                                        var7_7 = var10_10;
                                                                        while (true) {
                                                                            var8_8 = (char)var11_11;
                                                                            var6_6 = var7_7;
                                                                            break block18;
                                                                            break;
                                                                        }
                                                                    }
                                                                    if ((var11_11 & 192) == 128) break block21;
                                                                    if ((var11_11 & 32) != 0) break block22;
                                                                    var6_6 = var11_11 & 31;
                                                                    var8_8 = 1;
                                                                    var7_7 = 128;
                                                                    break block23;
                                                                }
                                                                if ((var11_11 & 16) != 0) break block24;
                                                                var6_6 = var11_11 & 15;
                                                                var8_8 = 2;
                                                                var7_7 = 2048;
                                                                break block23;
                                                            }
                                                            if ((var11_11 & 8) != 0) break block25;
                                                            var6_6 = var11_11 & 7;
                                                            var8_8 = 3;
                                                            var7_7 = 65536;
                                                            break block23;
                                                        }
                                                        if ((var11_11 & 4) != 0) break block26;
                                                        var6_6 = var11_11 & 3;
                                                        var8_8 = 4;
                                                        var7_7 = 0x200000;
                                                        break block23;
                                                    }
                                                    if ((var11_11 & 2) != 0) break block27;
                                                    var8_8 = 5;
                                                    var6_6 = var11_11 & 1;
                                                    var7_7 = 0x4000000;
                                                }
                                                if (var8_8 * 3 + var10_10 > var3_3) break block28;
                                                var11_11 = var6_6;
                                                var6_6 = var10_10;
                                                for (var12_12 = 0; var12_12 != var8_8; ++var12_12) {
                                                    if (var2_2.charAt(var6_6) == '%') {
                                                        var10_10 = NativeGlobal.unHex(var2_2.charAt(var6_6 + 1), var2_2.charAt(var6_6 + 2));
                                                        if (var10_10 >= 0 && (var10_10 & 192) == 128) {
                                                            var11_11 = var11_11 << 6 | var10_10 & 63;
                                                            var6_6 += 3;
                                                            continue;
                                                        }
                                                        throw NativeGlobal.uriError();
                                                    }
                                                    throw NativeGlobal.uriError();
                                                }
                                                if (var11_11 < var7_7 || var11_11 >= 55296 && var11_11 <= 57343) break block29;
                                                if (var11_11 == 65534) break block30;
                                                var8_8 = var11_11;
                                                if (var11_11 != 65535) break block31;
                                            }
                                            var8_8 = 65533;
                                            break block31;
                                        }
                                        var8_8 = 0x7FFFFFFF;
                                    }
                                    var7_7 = var6_6;
                                    var11_11 = var8_8;
                                    if (var8_8 < 65536) ** continue;
                                    if ((var8_8 -= 65536) <= 1048575) {
                                        var7_7 = (char)((var8_8 >>> 10) + 55296);
                                        var8_8 = (char)((var8_8 & 1023) + 56320);
                                        var0[var9_9] = (char)var7_7;
                                        ++var9_9;
                                    } else {
                                        throw NativeGlobal.uriError();
                                    }
                                }
                                if (var1_1 && ";/?:@&=+$,#".indexOf(var8_8) >= 0) {
                                    while (true) {
                                        var8_8 = ++var9_9;
                                        if (var5_5 != var6_6) {
                                            var0[var9_9] = var2_2.charAt(var5_5);
                                            ++var5_5;
                                            continue;
                                        }
                                        break;
                                    }
                                } else {
                                    var0[var9_9] = (char)var8_8;
                                    var8_8 = var9_9 + 1;
                                }
                                var4_4 = var0;
                                var5_5 = var6_6;
                                var6_6 = var8_8;
                                continue;
                            }
                            throw NativeGlobal.uriError();
                        }
                        throw NativeGlobal.uriError();
                    }
                    throw NativeGlobal.uriError();
                }
                throw NativeGlobal.uriError();
            }
            throw NativeGlobal.uriError();
        }
        if (var4_4 != null) {
            var2_2 = new String((char[])var4_4, 0, var6_6);
        }
        return var2_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String encode(String string2, boolean bl) {
        int n = string2.length();
        StringBuilder stringBuilder = null;
        byte[] byArray = null;
        int n2 = 0;
        while (n2 != n) {
            int n3;
            byte[] byArray2;
            StringBuilder stringBuilder2;
            char c = string2.charAt(n2);
            if (NativeGlobal.encodeUnescaped(c, bl)) {
                stringBuilder2 = stringBuilder;
                byArray2 = byArray;
                n3 = n2;
                if (stringBuilder != null) {
                    stringBuilder.append(c);
                    stringBuilder2 = stringBuilder;
                    byArray2 = byArray;
                    n3 = n2;
                }
            } else {
                StringBuilder stringBuilder3 = stringBuilder;
                if (stringBuilder == null) {
                    stringBuilder3 = new StringBuilder(n + 3);
                    stringBuilder3.append(string2);
                    stringBuilder3.setLength(n2);
                    byArray = new byte[6];
                }
                if ('\udc00' <= c) {
                    if (c <= '\udfff') throw NativeGlobal.uriError();
                }
                int n4 = n2;
                n3 = c;
                if (c >= '\ud800') {
                    if ('\udbff' < c) {
                        n4 = n2;
                        n3 = c;
                    } else {
                        n4 = n2 + 1;
                        if (n4 == n) throw NativeGlobal.uriError();
                        n2 = string2.charAt(n4);
                        if (56320 > n2) throw NativeGlobal.uriError();
                        if (n2 > 57343) throw NativeGlobal.uriError();
                        n3 = n2 = (c - 55296 << 10) + (n2 - 56320) + 65536;
                    }
                }
                int n5 = NativeGlobal.oneUcs4ToUtf8Char(byArray, n3);
                n2 = 0;
                while (true) {
                    stringBuilder2 = stringBuilder3;
                    byArray2 = byArray;
                    n3 = n4;
                    if (n2 >= n5) break;
                    n3 = byArray[n2] & 0xFF;
                    stringBuilder3.append('%');
                    stringBuilder3.append(NativeGlobal.toHexChar(n3 >>> 4));
                    stringBuilder3.append(NativeGlobal.toHexChar(n3 & 0xF));
                    ++n2;
                }
            }
            n2 = n3 + 1;
            stringBuilder = stringBuilder2;
            byArray = byArray2;
        }
        if (stringBuilder != null) return stringBuilder.toString();
        return string2;
    }

    private static boolean encodeUnescaped(char c, boolean bl) {
        boolean bl2 = true;
        if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9') {
            return true;
        }
        if ("-_.!~*'()".indexOf(c) >= 0) {
            return true;
        }
        if (bl) {
            bl = URI_DECODE_RESERVED.indexOf(c) >= 0 ? bl2 : false;
            return bl;
        }
        return false;
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeGlobal nativeGlobal = new NativeGlobal();
        for (int i = 1; i <= 13; ++i) {
            int n;
            TopLevel.NativeErrors[] nativeErrorsArray;
            block19: {
                switch (i) {
                    default: {
                        throw Kit.codeBug();
                    }
                    case 13: {
                        nativeErrorsArray = "uneval";
                        break;
                    }
                    case 12: {
                        nativeErrorsArray = "unescape";
                        break;
                    }
                    case 11: {
                        nativeErrorsArray = "parseInt";
                        n = 2;
                        break block19;
                    }
                    case 10: {
                        nativeErrorsArray = "parseFloat";
                        break;
                    }
                    case 9: {
                        nativeErrorsArray = "isXMLName";
                        break;
                    }
                    case 8: {
                        nativeErrorsArray = "isNaN";
                        break;
                    }
                    case 7: {
                        nativeErrorsArray = "isFinite";
                        break;
                    }
                    case 6: {
                        nativeErrorsArray = "eval";
                        break;
                    }
                    case 5: {
                        nativeErrorsArray = "escape";
                        break;
                    }
                    case 4: {
                        nativeErrorsArray = "encodeURIComponent";
                        break;
                    }
                    case 3: {
                        nativeErrorsArray = "encodeURI";
                        break;
                    }
                    case 2: {
                        nativeErrorsArray = "decodeURIComponent";
                        break;
                    }
                    case 1: {
                        nativeErrorsArray = "decodeURI";
                    }
                }
                n = 1;
            }
            nativeErrorsArray = new IdFunctionObject(nativeGlobal, FTAG, i, (String)nativeErrorsArray, n, scriptable);
            if (bl) {
                nativeErrorsArray.sealObject();
            }
            nativeErrorsArray.exportAsScopeProperty();
        }
        ScriptableObject.defineProperty(scriptable, "NaN", ScriptRuntime.NaNobj, 7);
        ScriptableObject.defineProperty(scriptable, "Infinity", ScriptRuntime.wrapNumber(Double.POSITIVE_INFINITY), 7);
        ScriptableObject.defineProperty(scriptable, "undefined", Undefined.instance, 7);
        for (Object object : TopLevel.NativeErrors.values()) {
            if (object == TopLevel.NativeErrors.Error) continue;
            Object object2 = object.name();
            object = (ScriptableObject)ScriptRuntime.newBuiltinObject(context, scriptable, TopLevel.Builtins.Error, ScriptRuntime.emptyArgs);
            ((ScriptableObject)object).put("name", (Scriptable)object, object2);
            ((ScriptableObject)object).put("message", (Scriptable)object, "");
            object2 = new IdFunctionObject(nativeGlobal, FTAG, 14, (String)object2, 1, scriptable);
            ((IdFunctionObject)object2).markAsConstructor((Scriptable)object);
            ((ScriptableObject)object).put("constructor", (Scriptable)object, object2);
            ((ScriptableObject)object).setAttributes("constructor", 2);
            if (bl) {
                ((ScriptableObject)object).sealObject();
                ((ScriptableObject)object2).sealObject();
            }
            ((IdFunctionObject)object2).exportAsScopeProperty();
        }
    }

    static boolean isEvalFunction(Object object) {
        return object instanceof IdFunctionObject && ((IdFunctionObject)(object = (IdFunctionObject)object)).hasTag(FTAG) && ((IdFunctionObject)object).methodId() == 6;
    }

    private Object js_escape(Object[] object) {
        int n;
        int n2 = 0;
        String string2 = ScriptRuntime.toString((Object[])object, 0);
        if (((Object[])object).length > 1) {
            double d = ScriptRuntime.toNumber(object[1]);
            if (d != d || (double)(n = (int)d) != d || (n & 0xFFFFFFF8) != 0) {
                throw Context.reportRuntimeError0("msg.bad.esc.mask");
            }
        } else {
            n = 7;
        }
        StringBuilder stringBuilder = null;
        int n3 = string2.length();
        while (n2 != n3) {
            Object object2;
            block8: {
                int n4;
                char c;
                block11: {
                    block9: {
                        block10: {
                            block7: {
                                c = string2.charAt(n2);
                                if (n == 0 || !(c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '@' || c == '*' || c == '_' || c == '-' || c == '.') && ((n & 4) == 0 || c != '/' && c != '+')) break block7;
                                object2 = stringBuilder;
                                if (stringBuilder != null) {
                                    stringBuilder.append(c);
                                    object2 = stringBuilder;
                                }
                                break block8;
                            }
                            object = stringBuilder;
                            if (stringBuilder == null) {
                                object = new StringBuilder(n3 + 3);
                                ((StringBuilder)object).append(string2);
                                ((StringBuilder)object).setLength(n2);
                            }
                            n4 = 2;
                            if (c >= '\u0100') break block9;
                            if (c != ' ' || n != 2) break block10;
                            ((StringBuilder)object).append('+');
                            object2 = object;
                            break block8;
                        }
                        ((StringBuilder)object).append('%');
                        break block11;
                    }
                    ((StringBuilder)object).append('%');
                    ((StringBuilder)object).append('u');
                    n4 = 4;
                }
                n4 = (n4 - 1) * 4;
                while (true) {
                    object2 = object;
                    if (n4 < 0) break;
                    int n5 = c >> n4 & 0xF;
                    n5 = n5 < 10 ? (n5 += 48) : (n5 += 55);
                    ((StringBuilder)object).append((char)n5);
                    n4 -= 4;
                }
            }
            ++n2;
            stringBuilder = object2;
        }
        object = stringBuilder == null ? string2 : stringBuilder.toString();
        return object;
    }

    private Object js_eval(Context context, Scriptable scriptable, Object[] objectArray) {
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        return ScriptRuntime.evalSpecial(context, scriptable, scriptable, objectArray, "eval code", 1);
    }

    static Object js_parseFloat(Object[] object) {
        if (((Object[])object).length < 1) {
            return ScriptRuntime.NaNobj;
        }
        int n = 0;
        object = ScriptRuntime.toString(object[0]);
        int n2 = ((String)object).length();
        int n3 = 0;
        while (true) {
            block20: {
                int n4;
                int n5;
                if (n3 == n2) {
                    return ScriptRuntime.NaNobj;
                }
                int n6 = ((String)object).charAt(n3);
                if (ScriptRuntime.isStrWhiteSpaceChar(n6)) break block20;
                if (n6 != 43 && n6 != 45) {
                    n5 = n3;
                } else {
                    n5 = n3 + 1;
                    if (n5 == n2) {
                        return ScriptRuntime.NaNobj;
                    }
                    n6 = ((String)object).charAt(n5);
                }
                if (n6 == 73) {
                    if (n5 + 8 <= n2 && ((String)object).regionMatches(n5, "Infinity", 0, 8)) {
                        double d = ((String)object).charAt(n3) == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                        return ScriptRuntime.wrapNumber(d);
                    }
                    return ScriptRuntime.NaNobj;
                }
                n6 = -1;
                int n7 = -1;
                block6: while (true) {
                    int n8;
                    int n9;
                    block24: {
                        block21: {
                            block22: {
                                block23: {
                                    n4 = n5;
                                    if (n5 >= n2) break;
                                    n4 = ((String)object).charAt(n5);
                                    if (n4 == 43) break block21;
                                    if (n4 == 69 || n4 == 101) break block22;
                                    if (n4 == 45) break block21;
                                    if (n4 == 46) break block23;
                                    switch (n4) {
                                        default: {
                                            n4 = n5;
                                            break block6;
                                        }
                                        case 48: 
                                        case 49: 
                                        case 50: 
                                        case 51: 
                                        case 52: 
                                        case 53: 
                                        case 54: 
                                        case 55: 
                                        case 56: 
                                        case 57: {
                                            n4 = n;
                                            n9 = n6;
                                            n8 = n7;
                                            if (n6 == -1) break block24;
                                            n4 = 1;
                                            n9 = n6;
                                            n8 = n7;
                                            break;
                                        }
                                    }
                                    break block24;
                                }
                                if (n7 != -1) {
                                    n4 = n5;
                                    break;
                                }
                                n8 = n5;
                                n4 = n;
                                n9 = n6;
                                break block24;
                            }
                            if (n6 != -1) {
                                n4 = n5;
                                break;
                            }
                            if (n5 == n2 - 1) {
                                n4 = n5;
                                break;
                            }
                            n9 = n5;
                            n4 = n;
                            n8 = n7;
                            break block24;
                        }
                        if (n6 != n5 - 1) {
                            n4 = n5;
                            break;
                        }
                        n4 = n;
                        n9 = n6;
                        n8 = n7;
                        if (n5 == n2 - 1) {
                            n4 = n5 - 1;
                            break;
                        }
                    }
                    ++n5;
                    n = n4;
                    n6 = n9;
                    n7 = n8;
                }
                if (n6 == -1 || n != 0) {
                    n6 = n4;
                }
                object = ((String)object).substring(n3, n6);
                try {
                    object = Double.valueOf((String)object);
                    return object;
                }
                catch (NumberFormatException numberFormatException) {
                    return ScriptRuntime.NaNobj;
                }
            }
            ++n3;
        }
    }

    static Object js_parseInt(Object[] objectArray) {
        block16: {
            double d;
            int n;
            int n2;
            String string2;
            int n3;
            block18: {
                block19: {
                    int n4;
                    block20: {
                        int n5;
                        int n6;
                        block15: {
                            int n7;
                            block17: {
                                block14: {
                                    block13: {
                                        block12: {
                                            n3 = 0;
                                            n6 = 0;
                                            string2 = ScriptRuntime.toString(objectArray, 0);
                                            n7 = ScriptRuntime.toInt32(objectArray, 1);
                                            n5 = string2.length();
                                            if (n5 == 0) {
                                                return ScriptRuntime.NaNobj;
                                            }
                                            n2 = 0;
                                            while (ScriptRuntime.isStrWhiteSpaceChar(n4 = string2.charAt(n2))) {
                                                n2 = n = n2 + 1;
                                                if (n < n5) continue;
                                                n2 = n;
                                                break;
                                            }
                                            n = n3;
                                            if (n4 == 43) break block12;
                                            n = n6;
                                            if (n4 == 45) {
                                                n = 1;
                                            }
                                            n3 = n;
                                            n6 = n2;
                                            if (n == 0) break block13;
                                        }
                                        n6 = n2 + 1;
                                        n3 = n;
                                    }
                                    n4 = 16;
                                    if (n7 != 0) break block14;
                                    n = -1;
                                    n2 = n6;
                                    break block15;
                                }
                                if (n7 < 2 || n7 > 36) break block16;
                                n2 = n6;
                                n = n7;
                                if (n7 != 16) break block15;
                                n2 = n6;
                                n = n7;
                                if (n5 - n6 <= 1) break block15;
                                n2 = n6;
                                n = n7;
                                if (string2.charAt(n6) != '0') break block15;
                                char c = string2.charAt(n6 + 1);
                                if (c == 'x') break block17;
                                n2 = n6;
                                n = n7;
                                if (c != 'X') break block15;
                            }
                            n2 = n6 + 2;
                            n = n7;
                        }
                        if (n != -1) break block18;
                        if (n5 - n2 <= 1 || string2.charAt(n2) != '0') break block19;
                        n = n2 + 1;
                        n6 = string2.charAt(n);
                        if (n6 == 120 || n6 == 88) break block20;
                        if (48 > n6 || n6 > 57) break block19;
                        n6 = 8;
                        n2 = n;
                        n = n6;
                        break block18;
                    }
                    n2 += 2;
                    n = n4;
                    break block18;
                }
                n = 10;
            }
            double d2 = d = ScriptRuntime.stringPrefixToNumber(string2, n2, n);
            if (n3 != 0) {
                d2 = -d;
            }
            return ScriptRuntime.wrapNumber(d2);
        }
        return ScriptRuntime.NaNobj;
    }

    private Object js_unescape(Object[] object) {
        String string2 = ScriptRuntime.toString(object, 0);
        int n = string2.indexOf(37);
        object = string2;
        if (n >= 0) {
            int n2 = string2.length();
            object = string2.toCharArray();
            int n3 = n;
            while (n != n2) {
                int n4;
                Object object2 = object[n];
                n = n4 = n + 1;
                Object object3 = object2;
                if (object2 == 37) {
                    n = n4;
                    object3 = object2;
                    if (n4 != n2) {
                        int n5;
                        int n6;
                        if (object[n4] == 117) {
                            n6 = n4 + 1;
                            n5 = n4 + 5;
                        } else {
                            n5 = n4 + 2;
                            n6 = n4;
                        }
                        n = n4;
                        object3 = object2;
                        if (n5 <= n2) {
                            int n7 = 0;
                            while (n6 != n5) {
                                n7 = Kit.xDigitToInt((int)object[n6], n7);
                                ++n6;
                            }
                            n = n4;
                            object3 = object2;
                            if (n7 >= 0) {
                                object3 = (char)n7;
                                n = n5;
                            }
                        }
                    }
                }
                object[n3] = (char)object3;
                ++n3;
            }
            object = new String((char[])object, 0, n3);
        }
        return object;
    }

    private static int oneUcs4ToUtf8Char(byte[] byArray, int n) {
        int n2 = 1;
        if ((n & 0xFFFFFF80) == 0) {
            byArray[0] = (byte)n;
        } else {
            int n3 = n >>> 11;
            n2 = 2;
            while (n3 != 0) {
                n3 >>>= 5;
                ++n2;
            }
            n3 = n2;
            while (--n3 > 0) {
                byArray[n3] = (byte)(n & 0x3F | 0x80);
                n >>>= 6;
            }
            byArray[0] = (byte)(256 - (1 << 8 - n2) + n);
        }
        return n2;
    }

    private static char toHexChar(int n) {
        if (n >> 4 != 0) {
            Kit.codeBug();
        }
        n = n < 10 ? (n += 48) : n - 10 + 65;
        return (char)n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int unHex(char c) {
        int n = 65;
        if ('A' <= c && c <= 'F') {
            return c - n + 10;
        }
        n = 97;
        if ('a' <= c && c <= 'f') {
            return c - n + 10;
        }
        if ('0' > c) return -1;
        if (c > '9') return -1;
        return c - 48;
    }

    private static int unHex(char c, char c2) {
        int n = NativeGlobal.unHex(c);
        int n2 = NativeGlobal.unHex(c2);
        if (n >= 0 && n2 >= 0) {
            return n << 4 | n2;
        }
        return -1;
    }

    private static EcmaError uriError() {
        return ScriptRuntime.constructError("URIError", ScriptRuntime.getMessage0("msg.bad.uri"));
    }

    @Override
    public Object execIdCall(IdFunctionObject object, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (((IdFunctionObject)object).hasTag(FTAG)) {
            int n = ((IdFunctionObject)object).methodId();
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = true;
            switch (n) {
                default: {
                    break;
                }
                case 14: {
                    return NativeError.make(context, scriptable, (IdFunctionObject)object, objectArray);
                }
                case 13: {
                    object = objectArray.length != 0 ? objectArray[0] : Undefined.instance;
                    return ScriptRuntime.uneval(context, scriptable, object);
                }
                case 12: {
                    return this.js_unescape(objectArray);
                }
                case 11: {
                    return NativeGlobal.js_parseInt(objectArray);
                }
                case 10: {
                    return NativeGlobal.js_parseFloat(objectArray);
                }
                case 9: {
                    object = objectArray.length == 0 ? Undefined.instance : objectArray[0];
                    return ScriptRuntime.wrapBoolean(XMLLib.extractFromScope(scriptable).isXMLName(context, object));
                }
                case 8: {
                    double d;
                    if (objectArray.length >= 1 && (d = ScriptRuntime.toNumber(objectArray[0])) == d) {
                        bl3 = false;
                    }
                    return ScriptRuntime.wrapBoolean(bl3);
                }
                case 7: {
                    if (objectArray.length < 1) {
                        return Boolean.FALSE;
                    }
                    return NativeNumber.isFinite(objectArray[0]);
                }
                case 6: {
                    return this.js_eval(context, scriptable, objectArray);
                }
                case 5: {
                    return this.js_escape(objectArray);
                }
                case 3: 
                case 4: {
                    object = ScriptRuntime.toString(objectArray, 0);
                    bl3 = n == 3 ? bl : false;
                    return NativeGlobal.encode((String)object, bl3);
                }
                case 1: 
                case 2: {
                    object = ScriptRuntime.toString(objectArray, 0);
                    bl3 = n == 1 ? bl2 : false;
                    return NativeGlobal.decode((String)object, bl3);
                }
            }
        }
        throw ((IdFunctionObject)object).unknown();
    }
}

