/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Iterator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeGenerator;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.VMBridge;

public final class NativeIterator
extends IdScriptableObject {
    public static final String ITERATOR_PROPERTY_NAME = "__iterator__";
    private static final Object ITERATOR_TAG = "Iterator";
    private static final int Id___iterator__ = 3;
    private static final int Id_constructor = 1;
    private static final int Id_next = 2;
    private static final int MAX_PROTOTYPE_ID = 3;
    private static final String STOP_ITERATION = "StopIteration";
    private static final long serialVersionUID = -4136968203581667681L;
    private Object objectIterator;

    private NativeIterator() {
    }

    private NativeIterator(Object object) {
        this.objectIterator = object;
    }

    public static Object getStopIterationObject(Scriptable scriptable) {
        return ScriptableObject.getTopScopeValue(ScriptableObject.getTopLevelScope(scriptable), ITERATOR_TAG);
    }

    static void init(ScriptableObject scriptableObject, boolean bl) {
        new NativeIterator().exportAsJSClass(3, scriptableObject, bl);
        NativeGenerator.init(scriptableObject, bl);
        StopIteration stopIteration = new StopIteration();
        stopIteration.setPrototype(NativeIterator.getObjectPrototype(scriptableObject));
        stopIteration.setParentScope(scriptableObject);
        if (bl) {
            stopIteration.sealObject();
        }
        ScriptableObject.defineProperty(scriptableObject, STOP_ITERATION, stopIteration, 2);
        scriptableObject.associateValue(ITERATOR_TAG, stopIteration);
    }

    private static Object jsConstructor(Context object, Scriptable scriptable, Scriptable object2, Object[] objectArray) {
        int n = objectArray.length;
        boolean bl = false;
        if (n != 0 && objectArray[0] != null && objectArray[0] != Undefined.instance) {
            Scriptable scriptable2 = ScriptRuntime.toObject((Context)object, scriptable, objectArray[0]);
            boolean bl2 = bl;
            if (objectArray.length > 1) {
                bl2 = bl;
                if (ScriptRuntime.toBoolean(objectArray[1])) {
                    bl2 = true;
                }
            }
            if (object2 != null) {
                object2 = VMBridge.instance.getJavaIterator((Context)object, scriptable, scriptable2);
                if (object2 != null) {
                    scriptable = ScriptableObject.getTopLevelScope(scriptable);
                    return ((Context)object).getWrapFactory().wrap((Context)object, scriptable, new WrappedJavaIterator((Iterator<?>)object2, scriptable), WrappedJavaIterator.class);
                }
                object2 = ScriptRuntime.toIterator((Context)object, scriptable, scriptable2, bl2);
                if (object2 != null) {
                    return object2;
                }
            }
            n = bl2 ? 3 : 5;
            object = ScriptRuntime.enumInit(scriptable2, (Context)object, scriptable, n);
            ScriptRuntime.setEnumNumbers(object, true);
            object = new NativeIterator(object);
            ((ScriptableObject)object).setPrototype(ScriptableObject.getClassPrototype(scriptable, ((NativeIterator)object).getClassName()));
            ((ScriptableObject)object).setParentScope(scriptable);
            return object;
        }
        object = objectArray.length == 0 ? Undefined.instance : objectArray[0];
        throw ScriptRuntime.typeError1("msg.no.properties", ScriptRuntime.toString(object));
    }

    private Object next(Context context, Scriptable scriptable) {
        if (ScriptRuntime.enumNext(this.objectIterator).booleanValue()) {
            return ScriptRuntime.enumId(this.objectIterator, context);
        }
        throw new JavaScriptException(NativeIterator.getStopIterationObject(scriptable), null, 0);
    }

    @Override
    public Object execIdCall(IdFunctionObject idScriptableObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!((IdFunctionObject)idScriptableObject).hasTag(ITERATOR_TAG)) {
            return super.execIdCall((IdFunctionObject)idScriptableObject, context, scriptable, scriptable2, objectArray);
        }
        int n = ((IdFunctionObject)idScriptableObject).methodId();
        if (n == 1) {
            return NativeIterator.jsConstructor(context, scriptable, scriptable2, objectArray);
        }
        if (scriptable2 instanceof NativeIterator) {
            idScriptableObject = (NativeIterator)scriptable2;
            if (n != 2) {
                if (n == 3) {
                    return scriptable2;
                }
                throw new IllegalArgumentException(String.valueOf(n));
            }
            return super.next(context, scriptable);
        }
        throw NativeIterator.incompatibleCallError((IdFunctionObject)idScriptableObject);
    }

    @Override
    protected int findPrototypeId(String string2) {
        int n;
        block6: {
            String string3;
            n = string2.length();
            int n2 = 0;
            if (n == 4) {
                n = 2;
                string3 = "next";
            } else if (n == 11) {
                n = 1;
                string3 = "constructor";
            } else if (n == 12) {
                n = 3;
                string3 = ITERATOR_PROPERTY_NAME;
            } else {
                string3 = null;
                n = 0;
            }
            if (string3 == null || string3 == string2 || string3.equals(string2)) break block6;
            n = n2;
        }
        return n;
    }

    @Override
    public String getClassName() {
        return "Iterator";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void initPrototypeId(int n) {
        String string2;
        int n2 = 1;
        if (n != 1) {
            if (n != 2) {
                if (n != 3) throw new IllegalArgumentException(String.valueOf(n));
                string2 = ITERATOR_PROPERTY_NAME;
            } else {
                string2 = "next";
                n2 = 0;
            }
        } else {
            string2 = "constructor";
            n2 = 2;
        }
        this.initPrototypeMethod(ITERATOR_TAG, n, string2, n2);
    }

    static class StopIteration
    extends NativeObject {
        private static final long serialVersionUID = 2485151085722377663L;

        StopIteration() {
        }

        @Override
        public String getClassName() {
            return NativeIterator.STOP_ITERATION;
        }

        @Override
        public boolean hasInstance(Scriptable scriptable) {
            return scriptable instanceof StopIteration;
        }
    }

    public static class WrappedJavaIterator {
        private Iterator<?> iterator;
        private Scriptable scope;

        WrappedJavaIterator(Iterator<?> iterator2, Scriptable scriptable) {
            this.iterator = iterator2;
            this.scope = scriptable;
        }

        public Object __iterator__(boolean bl) {
            return this;
        }

        public Object next() {
            if (this.iterator.hasNext()) {
                return this.iterator.next();
            }
            throw new JavaScriptException(NativeIterator.getStopIterationObject(this.scope), null, 0);
        }
    }
}

