/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeBoolean;
import org.mozilla.javascript.NativeNumber;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeString;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.json.JsonParser;

public final class NativeJSON
extends IdScriptableObject {
    private static final int Id_parse = 2;
    private static final int Id_stringify = 3;
    private static final int Id_toSource = 1;
    private static final Object JSON_TAG = "JSON";
    private static final int LAST_METHOD_ID = 3;
    private static final int MAX_ID = 3;
    private static final int MAX_STRINGIFY_GAP_LENGTH = 10;
    static final long serialVersionUID = -4567599697595654984L;

    private NativeJSON() {
    }

    static void init(Scriptable scriptable, boolean bl) {
        NativeJSON nativeJSON = new NativeJSON();
        nativeJSON.activatePrototypeMap(3);
        nativeJSON.setPrototype(NativeJSON.getObjectPrototype(scriptable));
        nativeJSON.setParentScope(scriptable);
        if (bl) {
            nativeJSON.sealObject();
        }
        ScriptableObject.defineProperty(scriptable, "JSON", nativeJSON, 2);
    }

    private static String ja(NativeArray object, StringifyState stringifyState) {
        if (stringifyState.stack.search(object) == -1) {
            stringifyState.stack.push((Scriptable)object);
            String string2 = stringifyState.indent;
            Object object2 = new StringBuilder();
            ((StringBuilder)object2).append(stringifyState.indent);
            ((StringBuilder)object2).append(stringifyState.gap);
            stringifyState.indent = ((StringBuilder)object2).toString();
            LinkedList<Object> linkedList = new LinkedList<Object>();
            long l = ((NativeArray)object).getLength();
            for (long i = 0L; i < l; ++i) {
                object2 = i > Integer.MAX_VALUE ? NativeJSON.str(Long.toString(i), (Scriptable)object, stringifyState) : NativeJSON.str((int)i, (Scriptable)object, stringifyState);
                if (object2 == Undefined.instance) {
                    linkedList.add("null");
                    continue;
                }
                linkedList.add(object2);
            }
            if (linkedList.isEmpty()) {
                object = "[]";
            } else if (stringifyState.gap.length() == 0) {
                object = new StringBuilder();
                ((StringBuilder)object).append('[');
                ((StringBuilder)object).append(NativeJSON.join(linkedList, ","));
                ((StringBuilder)object).append(']');
                object = ((StringBuilder)object).toString();
            } else {
                object = new StringBuilder();
                ((StringBuilder)object).append(",\n");
                ((StringBuilder)object).append(stringifyState.indent);
                object2 = NativeJSON.join(linkedList, ((StringBuilder)object).toString());
                object = new StringBuilder();
                ((StringBuilder)object).append("[\n");
                ((StringBuilder)object).append(stringifyState.indent);
                ((StringBuilder)object).append((String)object2);
                ((StringBuilder)object).append('\n');
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(']');
                object = ((StringBuilder)object).toString();
            }
            stringifyState.stack.pop();
            stringifyState.indent = string2;
            return object;
        }
        throw ScriptRuntime.typeError0("msg.cyclic.value");
    }

    private static String jo(Scriptable object, StringifyState stringifyState) {
        if (stringifyState.stack.search(object) == -1) {
            stringifyState.stack.push((Scriptable)object);
            String string2 = stringifyState.indent;
            Object object2 = new StringBuilder();
            ((StringBuilder)object2).append(stringifyState.indent);
            ((StringBuilder)object2).append(stringifyState.gap);
            stringifyState.indent = ((StringBuilder)object2).toString();
            object2 = stringifyState.propertyList != null ? stringifyState.propertyList.toArray() : object.getIds();
            LinkedList<Object> linkedList = new LinkedList<Object>();
            for (Object object3 : object2) {
                Object object4 = NativeJSON.str(object3, (Scriptable)object, stringifyState);
                if (object4 == Undefined.instance) continue;
                CharSequence charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(NativeJSON.quote(object3.toString()));
                ((StringBuilder)charSequence).append(":");
                charSequence = ((StringBuilder)charSequence).toString();
                object3 = charSequence;
                if (stringifyState.gap.length() > 0) {
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append((String)charSequence);
                    ((StringBuilder)object3).append(" ");
                    object3 = ((StringBuilder)object3).toString();
                }
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append((String)object3);
                ((StringBuilder)charSequence).append(object4);
                linkedList.add(((StringBuilder)charSequence).toString());
            }
            if (linkedList.isEmpty()) {
                object = "{}";
            } else if (stringifyState.gap.length() == 0) {
                object = new StringBuilder();
                ((StringBuilder)object).append('{');
                ((StringBuilder)object).append(NativeJSON.join(linkedList, ","));
                ((StringBuilder)object).append('}');
                object = ((StringBuilder)object).toString();
            } else {
                object = new StringBuilder();
                ((StringBuilder)object).append(",\n");
                ((StringBuilder)object).append(stringifyState.indent);
                object = NativeJSON.join(linkedList, ((StringBuilder)object).toString());
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("{\n");
                ((StringBuilder)object2).append(stringifyState.indent);
                ((StringBuilder)object2).append((String)object);
                ((StringBuilder)object2).append('\n');
                ((StringBuilder)object2).append(string2);
                ((StringBuilder)object2).append('}');
                object = ((StringBuilder)object2).toString();
            }
            stringifyState.stack.pop();
            stringifyState.indent = string2;
            return object;
        }
        throw ScriptRuntime.typeError0("msg.cyclic.value");
    }

    private static String join(Collection<Object> object, String string2) {
        if (object != null && !object.isEmpty()) {
            if (!(object = object.iterator()).hasNext()) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder(object.next().toString());
            while (object.hasNext()) {
                stringBuilder.append(string2);
                stringBuilder.append(object.next().toString());
            }
            return stringBuilder.toString();
        }
        return "";
    }

    private static Object parse(Context object, Scriptable scriptable, String string2) {
        try {
            JsonParser jsonParser = new JsonParser((Context)object, scriptable);
            object = jsonParser.parseValue(string2);
            return object;
        }
        catch (JsonParser.ParseException parseException) {
            throw ScriptRuntime.constructError("SyntaxError", parseException.getMessage());
        }
    }

    public static Object parse(Context context, Scriptable scriptable, String object, Callable callable) {
        object = NativeJSON.parse(context, scriptable, (String)object);
        Scriptable scriptable2 = context.newObject(scriptable);
        scriptable2.put("", scriptable2, object);
        return NativeJSON.walk(context, scriptable, callable, scriptable2, "");
    }

    private static String quote(String string2) {
        StringBuilder stringBuilder = new StringBuilder(string2.length() + 2);
        stringBuilder.append('\"');
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c != '\f') {
                if (c != '\r') {
                    if (c != '\"') {
                        if (c != '\\') {
                            switch (c) {
                                default: {
                                    if (c < ' ') {
                                        stringBuilder.append("\\u");
                                        stringBuilder.append(String.format("%04x", c));
                                        break;
                                    }
                                    stringBuilder.append(c);
                                    break;
                                }
                                case '\n': {
                                    stringBuilder.append("\\n");
                                    break;
                                }
                                case '\t': {
                                    stringBuilder.append("\\t");
                                    break;
                                }
                                case '\b': {
                                    stringBuilder.append("\\b");
                                    break;
                                }
                            }
                            continue;
                        }
                        stringBuilder.append("\\\\");
                        continue;
                    }
                    stringBuilder.append("\\\"");
                    continue;
                }
                stringBuilder.append("\\r");
                continue;
            }
            stringBuilder.append("\\f");
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    private static String repeat(char c, int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return new String(cArray);
    }

    private static Object str(Object object, Scriptable object2, StringifyState stringifyState) {
        Object object3 = object instanceof String ? NativeJSON.getProperty((Scriptable)object2, (String)object) : NativeJSON.getProperty((Scriptable)object2, ((Number)object).intValue());
        Object object4 = object3;
        if (object3 instanceof Scriptable) {
            Scriptable scriptable = (Scriptable)object3;
            object4 = object3;
            if (NativeJSON.hasProperty(scriptable, "toJSON")) {
                object4 = object3;
                if (NativeJSON.getProperty(scriptable, "toJSON") instanceof Callable) {
                    object4 = NativeJSON.callMethod(stringifyState.cx, scriptable, "toJSON", new Object[]{object});
                }
            }
        }
        object3 = object4;
        if (stringifyState.replacer != null) {
            object3 = stringifyState.replacer.call(stringifyState.cx, stringifyState.scope, (Scriptable)object2, new Object[]{object, object4});
        }
        if (object3 instanceof NativeNumber) {
            object = ScriptRuntime.toNumber(object3);
        } else if (object3 instanceof NativeString) {
            object = ScriptRuntime.toString(object3);
        } else {
            object = object3;
            if (object3 instanceof NativeBoolean) {
                object = ((NativeBoolean)object3).getDefaultValue(ScriptRuntime.BooleanClass);
            }
        }
        object4 = "null";
        if (object == null) {
            return "null";
        }
        if (object.equals(Boolean.TRUE)) {
            return "true";
        }
        if (object.equals(Boolean.FALSE)) {
            return "false";
        }
        if (object instanceof CharSequence) {
            return NativeJSON.quote(object.toString());
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            object2 = object4;
            if (d == d) {
                object2 = object4;
                if (d != Double.POSITIVE_INFINITY) {
                    object2 = object4;
                    if (d != Double.NEGATIVE_INFINITY) {
                        object2 = ScriptRuntime.toString(object);
                    }
                }
            }
            return object2;
        }
        if (object instanceof Scriptable && !(object instanceof Callable)) {
            if (object instanceof NativeArray) {
                return NativeJSON.ja((NativeArray)object, stringifyState);
            }
            return NativeJSON.jo((Scriptable)object, stringifyState);
        }
        return Undefined.instance;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Object stringify(Context var0, Scriptable var1_1, Object var2_2, Object var3_3, Object var4_4) {
        block9: {
            if (var3_3 /* !! */  instanceof Callable) {
                var5_5 = (Callable)var3_3 /* !! */ ;
                var6_6 = null;
            } else if (var3_3 /* !! */  instanceof NativeArray) {
                var6_6 = new LinkedList<E>();
                var5_5 = (NativeArray)var3_3 /* !! */ ;
                var3_3 /* !! */  = var5_5.getIndexIds();
                var7_7 = var3_3 /* !! */ .length;
                for (var8_8 = 0; var8_8 < var7_7; ++var8_8) {
                    var9_9 /* !! */  = var5_5.get(var3_3 /* !! */ [var8_8], (Scriptable)var5_5);
                    if (!(var9_9 /* !! */  instanceof String) && !(var9_9 /* !! */  instanceof Number)) {
                        if (!(var9_9 /* !! */  instanceof NativeString) && !(var9_9 /* !! */  instanceof NativeNumber)) continue;
                        var6_6.add(ScriptRuntime.toString(var9_9 /* !! */ ));
                        continue;
                    }
                    var6_6.add(var9_9 /* !! */ );
                }
                var5_5 = null;
            } else {
                var6_6 = var5_5 = null;
            }
            var3_3 /* !! */  = var4_4 instanceof NativeNumber != false ? Double.valueOf(ScriptRuntime.toNumber(var4_4)) : (var4_4 instanceof NativeString != false ? ScriptRuntime.toString(var4_4) : var4_4);
            if (!(var3_3 /* !! */  instanceof Number)) break block9;
            var8_8 = Math.min(10, (int)ScriptRuntime.toInteger(var3_3 /* !! */ ));
            var4_4 = var8_8 > 0 ? NativeJSON.repeat(' ', var8_8) : "";
            var9_9 /* !! */  = var8_8;
            ** GOTO lbl37
        }
        if (var3_3 /* !! */  instanceof String) {
            var10_10 = (String)var3_3 /* !! */ ;
            var9_9 /* !! */  = var3_3 /* !! */ ;
            var4_4 = var10_10;
            if (var10_10.length() > 10) {
                var4_4 = var10_10.substring(0, 10);
                var9_9 /* !! */  = var3_3 /* !! */ ;
            }
lbl37:
            // 4 sources

            var3_3 /* !! */  = var4_4;
        } else {
            var4_4 = "";
            var9_9 /* !! */  = var3_3 /* !! */ ;
            var3_3 /* !! */  = var4_4;
        }
        var3_3 /* !! */  = new StringifyState((Context)var0, var1_1, "", (String)var3_3 /* !! */ , (Callable)var5_5, (List<Object>)var6_6, var9_9 /* !! */ );
        var0 = new NativeObject();
        var0.setParentScope(var1_1);
        var0.setPrototype(ScriptableObject.getObjectPrototype(var1_1));
        var0.defineProperty("", var2_2, 0);
        return NativeJSON.str("", (Scriptable)var0, (StringifyState)var3_3 /* !! */ );
    }

    private static Object walk(Context context, Scriptable scriptable, Callable callable, Scriptable scriptable2, Object object) {
        Object object2;
        block10: {
            object2 = object instanceof Number ? scriptable2.get(((Number)object).intValue(), scriptable2) : scriptable2.get((String)object, scriptable2);
            if (!(object2 instanceof Scriptable)) break block10;
            Scriptable scriptable3 = (Scriptable)object2;
            if (scriptable3 instanceof NativeArray) {
                long l = ((NativeArray)scriptable3).getLength();
                for (long i = 0L; i < l; ++i) {
                    Object object3;
                    if (i > Integer.MAX_VALUE) {
                        object3 = Long.toString(i);
                        Object object4 = NativeJSON.walk(context, scriptable, callable, scriptable3, object3);
                        if (object4 == Undefined.instance) {
                            scriptable3.delete((String)object3);
                            continue;
                        }
                        scriptable3.put((String)object3, scriptable3, object4);
                        continue;
                    }
                    int n = (int)i;
                    object3 = NativeJSON.walk(context, scriptable, callable, scriptable3, n);
                    if (object3 == Undefined.instance) {
                        scriptable3.delete(n);
                        continue;
                    }
                    scriptable3.put(n, scriptable3, object3);
                }
            } else {
                for (Object object5 : scriptable3.getIds()) {
                    Object object6 = NativeJSON.walk(context, scriptable, callable, scriptable3, object5);
                    if (object6 == Undefined.instance) {
                        if (object5 instanceof Number) {
                            scriptable3.delete(((Number)object5).intValue());
                            continue;
                        }
                        scriptable3.delete((String)object5);
                        continue;
                    }
                    if (object5 instanceof Number) {
                        scriptable3.put(((Number)object5).intValue(), scriptable3, object6);
                        continue;
                    }
                    scriptable3.put((String)object5, scriptable3, object6);
                }
            }
        }
        return callable.call(context, scriptable, scriptable2, new Object[]{object, object2});
    }

    @Override
    public Object execIdCall(IdFunctionObject object, Context context, Scriptable scriptable, Scriptable object2, Object[] object3) {
        block3: {
            Object object4;
            block4: {
                int n;
                block5: {
                    block9: {
                        block10: {
                            block6: {
                                block7: {
                                    block8: {
                                        if (!object.hasTag(JSON_TAG)) {
                                            return super.execIdCall((IdFunctionObject)object, context, scriptable, (Scriptable)object2, (Object[])object3);
                                        }
                                        n = object.methodId();
                                        if (n == 1) break block3;
                                        object = null;
                                        object2 = null;
                                        object4 = null;
                                        Object var8_8 = null;
                                        if (n == 2) break block4;
                                        if (n != 3) break block5;
                                        n = ((Object[])object3).length;
                                        if (n == 1) break block6;
                                        object = var8_8;
                                        if (n == 2) break block7;
                                        if (n == 3) break block8;
                                        object = object3 = null;
                                        break block9;
                                    }
                                    object = object3[2];
                                }
                                object4 = object3[1];
                                object2 = object;
                                object = object4;
                                break block10;
                            }
                            object2 = null;
                        }
                        object4 = object3[0];
                        object3 = object2;
                        object2 = object;
                        object = object3;
                        object3 = object2;
                        object2 = object4;
                    }
                    return NativeJSON.stringify(context, scriptable, object2, object3, object);
                }
                throw new IllegalStateException(String.valueOf(n));
            }
            object2 = ScriptRuntime.toString(object3, 0);
            object = object4;
            if (((Object[])object3).length > 1) {
                object = object3[1];
            }
            if (object instanceof Callable) {
                return NativeJSON.parse(context, scriptable, (String)object2, (Callable)object);
            }
            return NativeJSON.parse(context, scriptable, (String)object2);
        }
        return "JSON";
    }

    @Override
    protected int findPrototypeId(String string2) {
        int n;
        block6: {
            String string3;
            n = string2.length();
            int n2 = 0;
            if (n != 5) {
                if (n != 8) {
                    if (n != 9) {
                        string3 = null;
                        n = 0;
                    } else {
                        string3 = "stringify";
                        n = 3;
                    }
                } else {
                    string3 = "toSource";
                    n = 1;
                }
            } else {
                string3 = "parse";
                n = 2;
            }
            if (string3 == null || string3 == string2 || string3.equals(string2)) break block6;
            n = n2;
        }
        return n;
    }

    @Override
    public String getClassName() {
        return "JSON";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void initPrototypeId(int n) {
        String string2;
        int n2 = 3;
        if (n > 3) throw new IllegalStateException(String.valueOf(n));
        if (n != 1) {
            if (n != 2) {
                if (n != 3) throw new IllegalStateException(String.valueOf(n));
                string2 = "stringify";
            } else {
                string2 = "parse";
                n2 = 2;
            }
        } else {
            n2 = 0;
            string2 = "toSource";
        }
        this.initPrototypeMethod(JSON_TAG, n, string2, n2);
    }

    private static class StringifyState {
        Context cx;
        String gap;
        String indent;
        List<Object> propertyList;
        Callable replacer;
        Scriptable scope;
        Object space;
        Stack<Scriptable> stack = new Stack();

        StringifyState(Context context, Scriptable scriptable, String string2, String string3, Callable callable, List<Object> list, Object object) {
            this.cx = context;
            this.scope = scriptable;
            this.indent = string2;
            this.gap = string3;
            this.replacer = callable;
            this.propertyList = list;
            this.space = object;
        }
    }
}

