/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Array;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeJavaArray
extends NativeJavaObject {
    static final long serialVersionUID = -924022554283675333L;
    Object array;
    Class<?> cls;
    int length;

    public NativeJavaArray(Scriptable object, Object object2) {
        super((Scriptable)object, null, ScriptRuntime.ObjectClass);
        object = object2.getClass();
        if (((Class)object).isArray()) {
            this.array = object2;
            this.length = Array.getLength(object2);
            this.cls = ((Class)object).getComponentType();
            return;
        }
        throw new RuntimeException("Array expected");
    }

    public static NativeJavaArray wrap(Scriptable scriptable, Object object) {
        return new NativeJavaArray(scriptable, object);
    }

    @Override
    public Object get(int n, Scriptable object) {
        if (n >= 0 && n < this.length) {
            object = Context.getContext();
            Object object2 = Array.get(this.array, n);
            return ((Context)object).getWrapFactory().wrap((Context)object, this, object2, this.cls);
        }
        return Undefined.instance;
    }

    @Override
    public Object get(String string2, Scriptable object) {
        if (string2.equals("length")) {
            return this.length;
        }
        if ((object = super.get(string2, (Scriptable)object)) == NOT_FOUND && !ScriptableObject.hasProperty(this.getPrototype(), string2)) {
            throw Context.reportRuntimeError2("msg.java.member.not.found", this.array.getClass().getName(), string2);
        }
        return object;
    }

    @Override
    public String getClassName() {
        return "JavaArray";
    }

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        if (clazz != null && clazz != ScriptRuntime.StringClass) {
            if (clazz == ScriptRuntime.BooleanClass) {
                return Boolean.TRUE;
            }
            if (clazz == ScriptRuntime.NumberClass) {
                return ScriptRuntime.NaNobj;
            }
            return this;
        }
        return this.array.toString();
    }

    @Override
    public Object[] getIds() {
        int n = this.length;
        Object[] objectArray = new Object[n];
        while (--n >= 0) {
            objectArray[n] = n;
        }
        return objectArray;
    }

    @Override
    public Scriptable getPrototype() {
        if (this.prototype == null) {
            this.prototype = ScriptableObject.getArrayPrototype(this.getParentScope());
        }
        return this.prototype;
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        boolean bl = n >= 0 && n < this.length;
        return bl;
    }

    @Override
    public boolean has(String string2, Scriptable scriptable) {
        boolean bl = string2.equals("length") || super.has(string2, scriptable);
        return bl;
    }

    @Override
    public boolean hasInstance(Scriptable object) {
        if (!(object instanceof Wrapper)) {
            return false;
        }
        object = ((Wrapper)object).unwrap();
        return this.cls.isInstance(object);
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        if (n >= 0 && n < this.length) {
            Array.set(this.array, n, Context.jsToJava(object, this.cls));
            return;
        }
        throw Context.reportRuntimeError2("msg.java.array.index.out.of.bounds", String.valueOf(n), String.valueOf(this.length - 1));
    }

    @Override
    public void put(String string2, Scriptable scriptable, Object object) {
        if (string2.equals("length")) {
            return;
        }
        throw Context.reportRuntimeError1("msg.java.array.member.not.found", string2);
    }

    @Override
    public Object unwrap() {
        return this.array;
    }
}

