/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ResolvedOverload;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeJavaMethod
extends BaseFunction {
    private static final int PREFERENCE_AMBIGUOUS = 3;
    private static final int PREFERENCE_EQUAL = 0;
    private static final int PREFERENCE_FIRST_ARG = 1;
    private static final int PREFERENCE_SECOND_ARG = 2;
    private static final boolean debug = false;
    static final long serialVersionUID = -3440381785576412928L;
    private String functionName;
    MemberBox[] methods;
    private transient CopyOnWriteArrayList<ResolvedOverload> overloadCache;

    public NativeJavaMethod(Method method, String string2) {
        this(new MemberBox(method), string2);
    }

    NativeJavaMethod(MemberBox memberBox, String string2) {
        this.functionName = string2;
        this.methods = new MemberBox[]{memberBox};
    }

    NativeJavaMethod(MemberBox[] memberBoxArray) {
        this.functionName = memberBoxArray[0].getName();
        this.methods = memberBoxArray;
    }

    NativeJavaMethod(MemberBox[] memberBoxArray, String string2) {
        this.functionName = string2;
        this.methods = memberBoxArray;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    static int findFunction(Context var0, MemberBox[] var1_1, Object[] var2_2) {
        if (var1_1 /* !! */ .length == 0) {
            return -1;
        }
        if (var1_1 /* !! */ .length == 1) {
            var1_1 /* !! */  = var1_1 /* !! */ [0];
            var0 = var1_1 /* !! */ .argTypes;
            var3_3 = ((Class<?>[])var0).length;
            if (var1_1 /* !! */ .vararg) {
                var4_5 = --var3_3;
                if (var3_3 > var2_2.length) {
                    return -1;
                }
            } else {
                var4_5 = var3_3;
                if (var3_3 != var2_2.length) {
                    return -1;
                }
            }
            for (var3_3 = 0; var3_3 != var4_5; ++var3_3) {
                if (NativeJavaObject.canConvert(var2_2[var3_3], var0[var3_3])) continue;
                return -1;
            }
            return 0;
        }
        var5_7 = null;
        var4_6 = -1;
        var6_8 = 0;
        for (var3_4 = 0; var3_4 < var1_1 /* !! */ .length; ++var3_4) {
            block34: {
                block35: {
                    block33: {
                        var7_9 = var1_1 /* !! */ [var3_4];
                        var8_10 = var7_9.argTypes;
                        var9_11 = var8_10.length;
                        if (!var7_9.vararg) break block33;
                        var10_12 = --var9_11;
                        if (var9_11 <= var2_2.length) break block34;
                        break block35;
                    }
                    var10_12 = var9_11;
                    if (var9_11 == var2_2.length) break block34;
                }
                while (true) {
                    var10_12 = var4_6;
                    ** GOTO lbl83
                    break;
                }
            }
            for (var9_11 = 0; var9_11 < var10_12; ++var9_11) {
                if (!NativeJavaObject.canConvert(var2_2[var9_11], var8_10[var9_11])) ** continue;
            }
            if (var4_6 < 0) ** GOTO lbl-1000
            var11_13 = 0;
            var10_12 = 0;
            block4: for (var9_11 = -1; var9_11 != var6_8; ++var9_11) {
                block38: {
                    block37: {
                        block36: {
                            var12_14 /* !! */  = var9_11 == -1 ? var4_6 : (int)var5_7[var9_11];
                            var13_15 = var1_1 /* !! */ [var12_14 /* !! */ ];
                            if (!var0.hasFeature(13) || (var13_15.member().getModifiers() & 1) == (var7_9.member().getModifiers() & 1)) break block36;
                            if ((var13_15.member().getModifiers() & 1) != 0) lbl-1000:
                            // 2 sources

                            {
                                while (true) {
                                    ++var10_12;
                                    continue block4;
                                    break;
                                }
                            }
                            break block37;
                        }
                        var12_14 /* !! */  = NativeJavaMethod.preferSignature(var2_2, var8_10, var7_9.vararg, var13_15.argTypes, var13_15.vararg);
                        if (var12_14 /* !! */  == 3) break;
                        if (var12_14 /* !! */  != 1) break block38;
                    }
                    ++var11_13;
                    continue;
                }
                if (var12_14 /* !! */  == 2) {
                    ** continue;
                }
                if (var12_14 /* !! */  != 0) {
                    Kit.codeBug();
                }
                var10_12 = var4_6;
                if (var13_15.isStatic()) {
                    var10_12 = var4_6;
                    if (var13_15.getDeclaringClass().isAssignableFrom(var7_9.getDeclaringClass())) {
                        ** if (var9_11 != -1) goto lbl-1000
                    }
                }
                ** GOTO lbl83
lbl-1000:
                // 2 sources

                {
                    var10_12 = var3_4;
                    ** GOTO lbl83
                }
lbl-1000:
                // 1 sources

                {
                    var5_7[var9_11] = var3_4;
                    var10_12 = var4_6;
                }
                ** GOTO lbl83
            }
            if (var11_13 == (var9_11 = var6_8 + 1)) {
                var4_6 = var3_4;
                var10_12 = 0;
            } else if (var10_12 == var9_11) {
                var10_12 = var4_6;
lbl83:
                // 5 sources

                var4_6 = var10_12;
                var10_12 = var6_8;
            } else {
                if (var5_7 == null) {
                    var5_7 = new int[var1_1 /* !! */ .length - 1];
                }
                var5_7[var6_8] = (String)var3_4;
                var10_12 = var9_11;
            }
            var6_8 = var10_12;
        }
        if (var4_6 < 0) {
            return -1;
        }
        if (var6_8 == 0) {
            return var4_6;
        }
        var0 = new StringBuilder();
        for (var3_4 = -1; var3_4 != var6_8; ++var3_4) {
            var10_12 = var3_4 == -1 ? var4_6 : var5_7[var3_4];
            var0.append("\n    ");
            var0.append(var1_1 /* !! */ [var10_12].toJavaDeclaration());
        }
        var7_9 = var1_1 /* !! */ [var4_6];
        var5_7 = var7_9.getName();
        var7_9 = var7_9.getDeclaringClass().getName();
        if (var1_1 /* !! */ [0].isCtor()) {
            throw Context.reportRuntimeError3("msg.constructor.ambiguous", var5_7, NativeJavaMethod.scriptSignature(var2_2), var0.toString());
        }
        throw Context.reportRuntimeError4("msg.method.ambiguous", var7_9, var5_7, NativeJavaMethod.scriptSignature(var2_2), var0.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int preferSignature(Object[] objectArray, Class<?>[] classArray, boolean bl, Class<?>[] classArray2, boolean bl2) {
        int n = 0;
        int n2 = 0;
        while (true) {
            block5: {
                int n3;
                block6: {
                    block8: {
                        Class<?> clazz;
                        Class<?> clazz2;
                        block9: {
                            block7: {
                                int n4;
                                n3 = n2;
                                if (n >= objectArray.length) return n3;
                                n3 = 1;
                                clazz2 = bl && n >= classArray.length ? classArray[classArray.length - 1] : classArray[n];
                                clazz = bl2 && n >= classArray2.length ? classArray2[classArray2.length - 1] : classArray2[n];
                                if (clazz2 == clazz) break block5;
                                Object object = objectArray[n];
                                int n5 = NativeJavaObject.getConversionWeight(object, clazz2);
                                if (n5 < (n4 = NativeJavaObject.getConversionWeight(object, clazz))) break block6;
                                if (n5 > n4) break block7;
                                if (n5 != 0) break block8;
                                if (!clazz2.isAssignableFrom(clazz)) break block9;
                            }
                            n3 = 2;
                            break block6;
                        }
                        if (clazz.isAssignableFrom(clazz2)) break block6;
                    }
                    n3 = 3;
                }
                n2 = n3 = n2 | n3;
                if (n3 == 3) {
                    return n3;
                }
            }
            ++n;
        }
    }

    private static void printDebug(String string2, MemberBox memberBox, Object[] objectArray) {
    }

    static String scriptSignature(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i != objectArray.length; ++i) {
            Object object = objectArray[i];
            object = object == null ? "null" : (object instanceof Boolean ? "boolean" : (object instanceof String ? "string" : (object instanceof Number ? "number" : (object instanceof Scriptable ? (object instanceof Undefined ? "undefined" : (object instanceof Wrapper ? ((Wrapper)object).unwrap().getClass().getName() : (object instanceof Function ? "function" : "object"))) : JavaMembers.javaSignature(object.getClass())))));
            if (i != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append((String)object);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public Object call(Context object, Scriptable object2, Scriptable object3, Object[] objectArray) {
        Object object4;
        Class<?> clazz;
        Object[] objectArray2;
        if (this.methods.length == 0) {
            throw new RuntimeException("No methods defined for call");
        }
        int n = this.findCachedFunction((Context)object, objectArray);
        int n2 = 0;
        int n3 = 0;
        if (n < 0) {
            object2 = this.methods[0].method().getDeclaringClass();
            object = new StringBuilder();
            ((StringBuilder)object).append(((Class)object2).getName());
            ((StringBuilder)object).append('.');
            ((StringBuilder)object).append(this.getFunctionName());
            ((StringBuilder)object).append('(');
            ((StringBuilder)object).append(NativeJavaMethod.scriptSignature(objectArray));
            ((StringBuilder)object).append(')');
            throw Context.reportRuntimeError1("msg.java.no_such_method", ((StringBuilder)object).toString());
        }
        MemberBox memberBox = this.methods[n];
        Object object5 = memberBox.argTypes;
        if (memberBox.vararg) {
            void var4_7;
            objectArray2 = new Object[((Class<?>[])object5).length];
            for (n2 = 0; n2 < ((Class<?>[])object5).length - 1; ++n2) {
                objectArray2[n2] = Context.jsToJava(objectArray[n2], object5[n2]);
            }
            if (objectArray.length == ((Class<?>[])object5).length && (objectArray[objectArray.length - 1] == null || objectArray[objectArray.length - 1] instanceof NativeArray || objectArray[objectArray.length - 1] instanceof NativeJavaArray)) {
                Object object6 = Context.jsToJava(objectArray[objectArray.length - 1], object5[((Object)object5).length - 1]);
            } else {
                clazz = object5[((Class<?>[])object5).length - 1].getComponentType();
                object4 = Array.newInstance(clazz, objectArray.length - ((Object)object5).length + 1);
                for (n2 = n3; n2 < Array.getLength(object4); ++n2) {
                    Array.set(object4, n2, Context.jsToJava(objectArray[((Object)object5).length - 1 + n2], clazz));
                }
                Object object7 = object4;
            }
            objectArray2[((Object)object5).length - 1] = var4_7;
        } else {
            object4 = objectArray;
            while (true) {
                objectArray2 = object4;
                if (n2 >= ((Object[])object4).length) break;
                Object object8 = object4[n2];
                clazz = Context.jsToJava(object8, object5[n2]);
                objectArray2 = object4;
                if (clazz != object8) {
                    objectArray2 = object4;
                    if (objectArray == object4) {
                        objectArray2 = (Object[])object4.clone();
                    }
                    objectArray2[n2] = clazz;
                }
                ++n2;
                object4 = objectArray2;
            }
        }
        if (memberBox.isStatic()) {
            object3 = null;
        } else {
            object5 = memberBox.getDeclaringClass();
            Class<?> clazz2 = object3;
            while (true) {
                void var4_10;
                if (var4_10 == null) {
                    throw Context.reportRuntimeError3("msg.nonjava.method", this.getFunctionName(), ScriptRuntime.toString(object3), ((Class)object5).getName());
                }
                if (var4_10 instanceof Wrapper && ((Class)object5).isInstance(object4 = ((Wrapper)var4_10).unwrap())) {
                    object3 = object4;
                    break;
                }
                Scriptable scriptable = var4_10.getPrototype();
            }
        }
        Object object9 = memberBox.invoke(object3, objectArray2);
        object3 = memberBox.method().getReturnType();
        object = object2 = ((Context)object).getWrapFactory().wrap((Context)object, (Scriptable)object2, object9, (Class<?>)object3);
        if (object2 != null) return object;
        object = object2;
        if (object3 != Void.TYPE) return object;
        return Undefined.instance;
    }

    @Override
    String decompile(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        n = 1;
        if ((n2 & 1) == 0) {
            n = 0;
        }
        if (n == 0) {
            stringBuilder.append("function ");
            stringBuilder.append(this.getFunctionName());
            stringBuilder.append("() {");
        }
        stringBuilder.append("/*\n");
        stringBuilder.append(this.toString());
        String string2 = n != 0 ? "*/\n" : "*/}\n";
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int findCachedFunction(Context object, Object[] objectArray) {
        Object object2 = this.methods;
        if (((MemberBox[])object2).length <= 1) {
            return NativeJavaMethod.findFunction((Context)object, (MemberBox[])object2, objectArray);
        }
        object2 = this.overloadCache;
        if (object2 != null) {
            Iterator iterator2 = ((CopyOnWriteArrayList)object2).iterator();
            while (iterator2.hasNext()) {
                object2 = (ResolvedOverload)iterator2.next();
                if (!((ResolvedOverload)object2).matches(objectArray)) continue;
                return ((ResolvedOverload)object2).index;
            }
        } else {
            this.overloadCache = new CopyOnWriteArrayList();
        }
        int n = NativeJavaMethod.findFunction((Context)object, this.methods, objectArray);
        if (this.overloadCache.size() < this.methods.length * 2) {
            object = this.overloadCache;
            synchronized (object) {
                object2 = new ResolvedOverload(objectArray, n);
                if (!this.overloadCache.contains(object2)) {
                    this.overloadCache.add(0, (ResolvedOverload)object2);
                }
            }
        }
        return n;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.methods.length;
        for (int i = 0; i != n; ++i) {
            if (this.methods[i].isMethod()) {
                Method method = this.methods[i].method();
                stringBuilder.append(JavaMembers.javaSignature(method.getReturnType()));
                stringBuilder.append(' ');
                stringBuilder.append(method.getName());
            } else {
                stringBuilder.append(this.methods[i].getName());
            }
            stringBuilder.append(JavaMembers.liveConnectSignature(this.methods[i].argTypes));
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

