/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.FieldAndMethods;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.InterfaceAdapter;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeDate;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeJavaObject
implements Scriptable,
Wrapper,
Serializable {
    private static final Object COERCED_INTERFACE_KEY = "Coerced Interface";
    static final byte CONVERSION_NONE = 99;
    static final byte CONVERSION_NONTRIVIAL = 0;
    static final byte CONVERSION_TRIVIAL = 1;
    private static final int JSTYPE_BOOLEAN = 2;
    private static final int JSTYPE_JAVA_ARRAY = 7;
    private static final int JSTYPE_JAVA_CLASS = 5;
    private static final int JSTYPE_JAVA_OBJECT = 6;
    private static final int JSTYPE_NULL = 1;
    private static final int JSTYPE_NUMBER = 3;
    private static final int JSTYPE_OBJECT = 8;
    private static final int JSTYPE_STRING = 4;
    private static final int JSTYPE_UNDEFINED = 0;
    private static Method adapter_readAdapterObject;
    private static Method adapter_writeAdapterObject;
    static final long serialVersionUID = -6948590651130498591L;
    private transient Map<String, FieldAndMethods> fieldAndMethods;
    protected transient boolean isAdapter;
    protected transient Object javaObject;
    protected transient JavaMembers members;
    protected Scriptable parent;
    protected Scriptable prototype;
    protected transient Class<?> staticType;

    static {
        Class[] classArray = new Class[2];
        Class<?> clazz = Kit.classOrNull("org.mozilla.javascript.JavaAdapter");
        if (clazz != null) {
            try {
                classArray[0] = ScriptRuntime.ObjectClass;
                classArray[1] = Kit.classOrNull("java.io.ObjectOutputStream");
                adapter_writeAdapterObject = clazz.getMethod("writeAdapterObject", classArray);
                classArray[0] = ScriptRuntime.ScriptableClass;
                classArray[1] = Kit.classOrNull("java.io.ObjectInputStream");
                adapter_readAdapterObject = clazz.getMethod("readAdapterObject", classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                adapter_writeAdapterObject = null;
                adapter_readAdapterObject = null;
            }
        }
    }

    public NativeJavaObject() {
    }

    public NativeJavaObject(Scriptable scriptable, Object object, Class<?> clazz) {
        this(scriptable, object, clazz, false);
    }

    public NativeJavaObject(Scriptable scriptable, Object object, Class<?> clazz, boolean bl) {
        this.parent = scriptable;
        this.javaObject = object;
        this.staticType = clazz;
        this.isAdapter = bl;
        this.initMembers();
    }

    public static boolean canConvert(Object object, Class<?> clazz) {
        boolean bl = NativeJavaObject.getConversionWeight(object, clazz) < 99;
        return bl;
    }

    private static Object coerceToNumber(Class<?> clazz, Object object) {
        Class<?> clazz2 = object.getClass();
        if (clazz != Character.TYPE && clazz != ScriptRuntime.CharacterClass) {
            if (clazz != ScriptRuntime.ObjectClass && clazz != ScriptRuntime.DoubleClass && clazz != Double.TYPE) {
                if (clazz != ScriptRuntime.FloatClass && clazz != Float.TYPE) {
                    if (clazz != ScriptRuntime.IntegerClass && clazz != Integer.TYPE) {
                        if (clazz != ScriptRuntime.LongClass && clazz != Long.TYPE) {
                            if (clazz != ScriptRuntime.ShortClass && clazz != Short.TYPE) {
                                if (clazz != ScriptRuntime.ByteClass && clazz != Byte.TYPE) {
                                    return new Double(NativeJavaObject.toDouble(object));
                                }
                                if (clazz2 == ScriptRuntime.ByteClass) {
                                    return object;
                                }
                                return (byte)NativeJavaObject.toInteger(object, ScriptRuntime.ByteClass, -128.0, 127.0);
                            }
                            if (clazz2 == ScriptRuntime.ShortClass) {
                                return object;
                            }
                            return (short)NativeJavaObject.toInteger(object, ScriptRuntime.ShortClass, -32768.0, 32767.0);
                        }
                        if (clazz2 == ScriptRuntime.LongClass) {
                            return object;
                        }
                        double d = Double.longBitsToDouble(4890909195324358655L);
                        double d2 = Double.longBitsToDouble(-4332462841530417152L);
                        return NativeJavaObject.toInteger(object, ScriptRuntime.LongClass, d2, d);
                    }
                    if (clazz2 == ScriptRuntime.IntegerClass) {
                        return object;
                    }
                    return (int)NativeJavaObject.toInteger(object, ScriptRuntime.IntegerClass, -2.147483648E9, 2.147483647E9);
                }
                if (clazz2 == ScriptRuntime.FloatClass) {
                    return object;
                }
                double d = NativeJavaObject.toDouble(object);
                if (!Double.isInfinite(d) && !Double.isNaN(d)) {
                    double d3 = 0.0;
                    double d4 = d - 0.0;
                    double d5 = d4 == 0.0 ? 0 : (d4 > 0.0 ? 1 : -1);
                    if (d5 != false) {
                        double d6 = Math.abs(d);
                        if (d6 < (double)1.4E-45f) {
                            if (d5 <= 0) {
                                d3 = 0.0;
                            }
                            return new Float(d3);
                        }
                        if (d6 > 3.4028234663852886E38) {
                            float f = d5 > 0 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
                            return new Float(f);
                        }
                        return new Float((float)d);
                    }
                }
                return new Float((float)d);
            }
            if (clazz2 != ScriptRuntime.DoubleClass) {
                object = new Double(NativeJavaObject.toDouble(object));
            }
            return object;
        }
        if (clazz2 == ScriptRuntime.CharacterClass) {
            return object;
        }
        return Character.valueOf((char)NativeJavaObject.toInteger(object, ScriptRuntime.CharacterClass, 0.0, 65535.0));
    }

    @Deprecated
    public static Object coerceType(Class<?> clazz, Object object) {
        return NativeJavaObject.coerceTypeImpl(clazz, object);
    }

    static Object coerceTypeImpl(Class<?> clazz, Object object) {
        if (object != null && object.getClass() == clazz) {
            return object;
        }
        int n = NativeJavaObject.getJSTypeCode(object);
        int n2 = 0;
        switch (n) {
            default: {
                break;
            }
            case 8: {
                if (clazz == ScriptRuntime.StringClass) {
                    return ScriptRuntime.toString(object);
                }
                if (clazz.isPrimitive()) {
                    if (clazz == Boolean.TYPE) {
                        NativeJavaObject.reportConversionError(object, clazz);
                    }
                    return NativeJavaObject.coerceToNumber(clazz, object);
                }
                if (clazz.isInstance(object)) {
                    return object;
                }
                if (clazz == ScriptRuntime.DateClass && object instanceof NativeDate) {
                    return new Date((long)((NativeDate)object).getJSTimeValue());
                }
                if (clazz.isArray() && object instanceof NativeArray) {
                    NativeArray nativeArray = (NativeArray)object;
                    long l = nativeArray.getLength();
                    Class<?> clazz2 = clazz.getComponentType();
                    Object object2 = Array.newInstance(clazz2, (int)l);
                    while ((long)n2 < l) {
                        try {
                            Array.set(object2, n2, NativeJavaObject.coerceTypeImpl(clazz2, nativeArray.get(n2, (Scriptable)nativeArray)));
                        }
                        catch (EvaluatorException evaluatorException) {
                            NativeJavaObject.reportConversionError(object, clazz);
                        }
                        ++n2;
                    }
                    return object2;
                }
                if (object instanceof Wrapper) {
                    if (clazz.isInstance(object = ((Wrapper)object).unwrap())) {
                        return object;
                    }
                    NativeJavaObject.reportConversionError(object, clazz);
                    break;
                }
                if (clazz.isInterface() && (object instanceof NativeObject || object instanceof NativeFunction)) {
                    return NativeJavaObject.createInterfaceAdapter(clazz, (ScriptableObject)object);
                }
                NativeJavaObject.reportConversionError(object, clazz);
                break;
            }
            case 6: 
            case 7: {
                Object object3 = object;
                if (object instanceof Wrapper) {
                    object3 = ((Wrapper)object).unwrap();
                }
                if (clazz.isPrimitive()) {
                    if (clazz == Boolean.TYPE) {
                        NativeJavaObject.reportConversionError(object3, clazz);
                    }
                    return NativeJavaObject.coerceToNumber(clazz, object3);
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return object3.toString();
                }
                if (clazz.isInstance(object3)) {
                    return object3;
                }
                NativeJavaObject.reportConversionError(object3, clazz);
                object = object3;
                break;
            }
            case 5: {
                Object object4 = object;
                if (object instanceof Wrapper) {
                    object4 = ((Wrapper)object).unwrap();
                }
                if (clazz != ScriptRuntime.ClassClass && clazz != ScriptRuntime.ObjectClass) {
                    if (clazz == ScriptRuntime.StringClass) {
                        return object4.toString();
                    }
                    NativeJavaObject.reportConversionError(object4, clazz);
                    object = object4;
                    break;
                }
                return object4;
            }
            case 4: {
                if (clazz != ScriptRuntime.StringClass && !clazz.isInstance(object)) {
                    if (clazz != Character.TYPE && clazz != ScriptRuntime.CharacterClass) {
                        if (clazz.isPrimitive() && clazz != Boolean.TYPE || ScriptRuntime.NumberClass.isAssignableFrom(clazz)) {
                            return NativeJavaObject.coerceToNumber(clazz, object);
                        }
                        NativeJavaObject.reportConversionError(object, clazz);
                        break;
                    }
                    CharSequence charSequence = (CharSequence)object;
                    if (charSequence.length() == 1) {
                        return Character.valueOf(charSequence.charAt(0));
                    }
                    return NativeJavaObject.coerceToNumber(clazz, object);
                }
                return object.toString();
            }
            case 3: {
                if (clazz == ScriptRuntime.StringClass) {
                    return ScriptRuntime.toString(object);
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    if (Context.getCurrentContext().hasFeature(18) && (double)Math.round(NativeJavaObject.toDouble(object)) == NativeJavaObject.toDouble(object)) {
                        return NativeJavaObject.coerceToNumber(Long.TYPE, object);
                    }
                    return NativeJavaObject.coerceToNumber(Double.TYPE, object);
                }
                if (clazz.isPrimitive() && clazz != Boolean.TYPE || ScriptRuntime.NumberClass.isAssignableFrom(clazz)) {
                    return NativeJavaObject.coerceToNumber(clazz, object);
                }
                NativeJavaObject.reportConversionError(object, clazz);
                break;
            }
            case 2: {
                if (clazz != Boolean.TYPE && clazz != ScriptRuntime.BooleanClass && clazz != ScriptRuntime.ObjectClass) {
                    if (clazz == ScriptRuntime.StringClass) {
                        return object.toString();
                    }
                    NativeJavaObject.reportConversionError(object, clazz);
                    break;
                }
                return object;
            }
            case 1: {
                if (clazz.isPrimitive()) {
                    NativeJavaObject.reportConversionError(object, clazz);
                }
                return null;
            }
            case 0: {
                if (clazz != ScriptRuntime.StringClass && clazz != ScriptRuntime.ObjectClass) {
                    NativeJavaObject.reportConversionError("undefined", clazz);
                    break;
                }
                return "undefined";
            }
        }
        return object;
    }

    protected static Object createInterfaceAdapter(Class<?> clazz, ScriptableObject scriptableObject) {
        Object object = Kit.makeHashKeyFromPair(COERCED_INTERFACE_KEY, clazz);
        Object object2 = scriptableObject.getAssociatedValue(object);
        if (object2 != null) {
            return object2;
        }
        return scriptableObject.associateValue(object, InterfaceAdapter.create(Context.getContext(), clazz, scriptableObject));
    }

    static int getConversionWeight(Object object, Class<?> clazz) {
        int n = NativeJavaObject.getJSTypeCode(object);
        int n2 = 99;
        switch (n) {
            default: {
                break;
            }
            case 8: {
                if (clazz != ScriptRuntime.ObjectClass && clazz.isInstance(object)) {
                    return 1;
                }
                if (clazz.isArray()) {
                    if (!(object instanceof NativeArray)) break;
                    return 2;
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    return 3;
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return 4;
                }
                if (clazz == ScriptRuntime.DateClass) {
                    if (!(object instanceof NativeDate)) break;
                    return 1;
                }
                if (clazz.isInterface()) {
                    if (object instanceof NativeFunction) {
                        return 1;
                    }
                    if (object instanceof NativeObject) {
                        return 2;
                    }
                    return 12;
                }
                if (!clazz.isPrimitive() || clazz == Boolean.TYPE) break;
                return NativeJavaObject.getSizeRank(clazz) + 4;
            }
            case 6: 
            case 7: {
                Object object2 = object;
                if (object instanceof Wrapper) {
                    object2 = ((Wrapper)object).unwrap();
                }
                if (clazz.isInstance(object2)) {
                    return 0;
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return 2;
                }
                if (!clazz.isPrimitive() || clazz == Boolean.TYPE) break;
                if (n != 7) {
                    n2 = NativeJavaObject.getSizeRank(clazz) + 2;
                }
                return n2;
            }
            case 5: {
                if (clazz == ScriptRuntime.ClassClass) {
                    return 1;
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    return 3;
                }
                if (clazz != ScriptRuntime.StringClass) break;
                return 4;
            }
            case 4: {
                if (clazz == ScriptRuntime.StringClass) {
                    return 1;
                }
                if (clazz.isInstance(object)) {
                    return 2;
                }
                if (!clazz.isPrimitive()) break;
                if (clazz == Character.TYPE) {
                    return 3;
                }
                if (clazz == Boolean.TYPE) break;
                return 4;
            }
            case 3: {
                if (clazz.isPrimitive()) {
                    if (clazz == Double.TYPE) {
                        return 1;
                    }
                    if (clazz == Boolean.TYPE) break;
                    return NativeJavaObject.getSizeRank(clazz) + 1;
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return 9;
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    return 10;
                }
                if (!ScriptRuntime.NumberClass.isAssignableFrom(clazz)) break;
                return 2;
            }
            case 2: {
                if (clazz == Boolean.TYPE) {
                    return 1;
                }
                if (clazz == ScriptRuntime.BooleanClass) {
                    return 2;
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    return 3;
                }
                if (clazz != ScriptRuntime.StringClass) break;
                return 4;
            }
            case 1: {
                if (clazz.isPrimitive()) break;
                return 1;
            }
            case 0: {
                if (clazz != ScriptRuntime.StringClass && clazz != ScriptRuntime.ObjectClass) break;
                return 1;
            }
        }
        return 99;
    }

    private static int getJSTypeCode(Object object) {
        if (object == null) {
            return 1;
        }
        if (object == Undefined.instance) {
            return 0;
        }
        if (object instanceof CharSequence) {
            return 4;
        }
        if (object instanceof Number) {
            return 3;
        }
        if (object instanceof Boolean) {
            return 2;
        }
        if (object instanceof Scriptable) {
            if (object instanceof NativeJavaClass) {
                return 5;
            }
            if (object instanceof NativeJavaArray) {
                return 7;
            }
            if (object instanceof Wrapper) {
                return 6;
            }
            return 8;
        }
        if (object instanceof Class) {
            return 5;
        }
        if (object.getClass().isArray()) {
            return 7;
        }
        return 6;
    }

    static int getSizeRank(Class<?> clazz) {
        if (clazz == Double.TYPE) {
            return 1;
        }
        if (clazz == Float.TYPE) {
            return 2;
        }
        if (clazz == Long.TYPE) {
            return 3;
        }
        if (clazz == Integer.TYPE) {
            return 4;
        }
        if (clazz == Short.TYPE) {
            return 5;
        }
        if (clazz == Character.TYPE) {
            return 6;
        }
        if (clazz == Byte.TYPE) {
            return 7;
        }
        if (clazz == Boolean.TYPE) {
            return 99;
        }
        return 8;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readObject(ObjectInputStream object) throws IOException, ClassNotFoundException {
        boolean bl;
        ((ObjectInputStream)object).defaultReadObject();
        this.isAdapter = bl = ((ObjectInputStream)object).readBoolean();
        if (bl) {
            Method method = adapter_readAdapterObject;
            if (method == null) throw new ClassNotFoundException();
            try {
                this.javaObject = method.invoke(null, this, object);
            }
            catch (Exception exception) {
                throw new IOException();
            }
        } else {
            this.javaObject = ((ObjectInputStream)object).readObject();
        }
        object = (String)((ObjectInputStream)object).readObject();
        this.staticType = object != null ? Class.forName((String)object) : null;
        this.initMembers();
    }

    static void reportConversionError(Object object, Class<?> clazz) {
        throw Context.reportRuntimeError2("msg.conversion.not.allowed", String.valueOf(object), JavaMembers.javaSignature(clazz));
    }

    private static double toDouble(Object object) {
        Object[] objectArray;
        GenericDeclaration genericDeclaration;
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            return ScriptRuntime.toNumber((String)object);
        }
        if (object instanceof Scriptable) {
            if (object instanceof Wrapper) {
                return NativeJavaObject.toDouble(((Wrapper)object).unwrap());
            }
            return ScriptRuntime.toNumber(object);
        }
        try {
            genericDeclaration = object.getClass();
            objectArray = null;
            genericDeclaration = ((Class)genericDeclaration).getMethod("doubleValue", null);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            genericDeclaration = null;
        }
        if (genericDeclaration != null) {
            try {
                objectArray = null;
                double d = ((Number)((Method)genericDeclaration).invoke(object, null)).doubleValue();
                return d;
            }
            catch (InvocationTargetException invocationTargetException) {
                NativeJavaObject.reportConversionError(object, Double.TYPE);
            }
            catch (IllegalAccessException illegalAccessException) {
                NativeJavaObject.reportConversionError(object, Double.TYPE);
            }
        }
        return ScriptRuntime.toNumber(object.toString());
    }

    private static long toInteger(Object object, Class<?> clazz, double d, double d2) {
        double d3 = NativeJavaObject.toDouble(object);
        if (Double.isInfinite(d3) || Double.isNaN(d3)) {
            NativeJavaObject.reportConversionError(ScriptRuntime.toString(object), clazz);
        }
        if ((d3 = d3 > 0.0 ? Math.floor(d3) : Math.ceil(d3)) < d || d3 > d2) {
            NativeJavaObject.reportConversionError(ScriptRuntime.toString(object), clazz);
        }
        return (long)d3;
    }

    @Deprecated
    public static Object wrap(Scriptable scriptable, Object object, Class<?> clazz) {
        Context context = Context.getContext();
        return context.getWrapFactory().wrap(context, scriptable, object, clazz);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Class<?> clazz;
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeBoolean(this.isAdapter);
        if (this.isAdapter) {
            Method method = adapter_writeAdapterObject;
            if (method == null) throw new IOException();
            clazz = this.javaObject;
            try {
                method.invoke(null, clazz, objectOutputStream);
            }
            catch (Exception exception) {
                throw new IOException();
            }
        } else {
            objectOutputStream.writeObject(this.javaObject);
        }
        clazz = this.staticType;
        if (clazz != null) {
            objectOutputStream.writeObject(clazz.getClass().getName());
            return;
        } else {
            objectOutputStream.writeObject(null);
        }
    }

    @Override
    public void delete(int n) {
    }

    @Override
    public void delete(String string2) {
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        throw this.members.reportMemberNotFound(Integer.toString(n));
    }

    @Override
    public Object get(String string2, Scriptable map) {
        map = this.fieldAndMethods;
        if (map != null && (map = map.get(string2)) != null) {
            return map;
        }
        return this.members.get(this, string2, this.javaObject, false);
    }

    @Override
    public String getClassName() {
        return "JavaObject";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getDefaultValue(Class<?> object) {
        Class<?> clazz = object;
        if (object == null) {
            clazz = object;
            if (this.javaObject instanceof Boolean) {
                clazz = ScriptRuntime.BooleanClass;
            }
        }
        if (clazz == null) return this.javaObject.toString();
        if (clazz == ScriptRuntime.StringClass) return this.javaObject.toString();
        if (clazz == ScriptRuntime.BooleanClass) {
            object = "booleanValue";
        } else {
            if (clazz != ScriptRuntime.NumberClass) throw Context.reportRuntimeError0("msg.default.value");
            object = "doubleValue";
        }
        object = this.get((String)object, (Scriptable)this);
        if (object instanceof Function) {
            object = (Function)object;
            return object.call(Context.getContext(), object.getParentScope(), this, ScriptRuntime.emptyArgs);
        }
        if (clazz != ScriptRuntime.NumberClass) return this.javaObject.toString();
        object = this.javaObject;
        if (!(object instanceof Boolean)) return this.javaObject.toString();
        double d = (Boolean)object != false ? 1.0 : 0.0;
        return ScriptRuntime.wrapNumber(d);
    }

    @Override
    public Object[] getIds() {
        return this.members.getIds(false);
    }

    @Override
    public Scriptable getParentScope() {
        return this.parent;
    }

    @Override
    public Scriptable getPrototype() {
        Scriptable scriptable;
        Scriptable scriptable2 = scriptable = this.prototype;
        if (scriptable == null) {
            scriptable2 = scriptable;
            if (this.javaObject instanceof String) {
                scriptable2 = TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(this.parent), TopLevel.Builtins.String);
            }
        }
        return scriptable2;
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        return false;
    }

    @Override
    public boolean has(String string2, Scriptable scriptable) {
        return this.members.has(string2, false);
    }

    @Override
    public boolean hasInstance(Scriptable scriptable) {
        return false;
    }

    protected void initMembers() {
        Class<?> clazz = this.javaObject;
        clazz = clazz != null ? clazz.getClass() : this.staticType;
        this.members = clazz = JavaMembers.lookupClass(this.parent, clazz, this.staticType, this.isAdapter);
        this.fieldAndMethods = ((JavaMembers)((Object)clazz)).getFieldAndMethodsObjects(this, this.javaObject, false);
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        throw this.members.reportMemberNotFound(Integer.toString(n));
    }

    @Override
    public void put(String string2, Scriptable scriptable, Object object) {
        if (this.prototype != null && !this.members.has(string2, false)) {
            scriptable = this.prototype;
            scriptable.put(string2, scriptable, object);
        } else {
            this.members.put(this, string2, this.javaObject, object, false);
        }
    }

    @Override
    public void setParentScope(Scriptable scriptable) {
        this.parent = scriptable;
    }

    @Override
    public void setPrototype(Scriptable scriptable) {
        this.prototype = scriptable;
    }

    @Override
    public Object unwrap() {
        return this.javaObject;
    }
}

