/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.typedarrays.Conversions;

final class NativeMath
extends IdScriptableObject {
    private static final int Id_E = 30;
    private static final int Id_LN10 = 32;
    private static final int Id_LN2 = 33;
    private static final int Id_LOG10E = 35;
    private static final int Id_LOG2E = 34;
    private static final int Id_PI = 31;
    private static final int Id_SQRT1_2 = 36;
    private static final int Id_SQRT2 = 37;
    private static final int Id_abs = 2;
    private static final int Id_acos = 3;
    private static final int Id_asin = 4;
    private static final int Id_atan = 5;
    private static final int Id_atan2 = 6;
    private static final int Id_cbrt = 20;
    private static final int Id_ceil = 7;
    private static final int Id_cos = 8;
    private static final int Id_cosh = 21;
    private static final int Id_exp = 9;
    private static final int Id_expm1 = 22;
    private static final int Id_floor = 10;
    private static final int Id_hypot = 23;
    private static final int Id_imul = 28;
    private static final int Id_log = 11;
    private static final int Id_log10 = 25;
    private static final int Id_log1p = 24;
    private static final int Id_max = 12;
    private static final int Id_min = 13;
    private static final int Id_pow = 14;
    private static final int Id_random = 15;
    private static final int Id_round = 16;
    private static final int Id_sin = 17;
    private static final int Id_sinh = 26;
    private static final int Id_sqrt = 18;
    private static final int Id_tan = 19;
    private static final int Id_tanh = 27;
    private static final int Id_toSource = 1;
    private static final int Id_trunc = 29;
    private static final int LAST_METHOD_ID = 29;
    private static final Object MATH_TAG = "Math";
    private static final int MAX_ID = 37;
    static final long serialVersionUID = -8838847185801131569L;

    private NativeMath() {
    }

    static void init(Scriptable scriptable, boolean bl) {
        NativeMath nativeMath = new NativeMath();
        nativeMath.activatePrototypeMap(37);
        nativeMath.setPrototype(NativeMath.getObjectPrototype(scriptable));
        nativeMath.setParentScope(scriptable);
        if (bl) {
            nativeMath.sealObject();
        }
        ScriptableObject.defineProperty(scriptable, "Math", nativeMath, 2);
    }

    private double js_hypot(Object[] objectArray) {
        double d = 0.0;
        if (objectArray == null) {
            return 0.0;
        }
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            double d2 = ScriptRuntime.toNumber(objectArray[i]);
            if (d2 == ScriptRuntime.NaN) {
                return d2;
            }
            if (d2 != Double.POSITIVE_INFINITY && d2 != Double.NEGATIVE_INFINITY) {
                d += d2 * d2;
                continue;
            }
            return Double.POSITIVE_INFINITY;
        }
        return Math.sqrt(d);
    }

    private Object js_imul(Object[] objectArray) {
        if (objectArray != null && objectArray.length >= 2) {
            long l;
            long l2 = l = Conversions.toUint32(objectArray[0]) * Conversions.toUint32(objectArray[1]) % 0x100000000L;
            if (l >= 0x80000000L) {
                l2 = l - 0x100000000L;
            }
            return ScriptRuntime.toNumber(l2);
        }
        return ScriptRuntime.wrapNumber(ScriptRuntime.NaN);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double js_pow(double d, double d2) {
        double d3 = Double.POSITIVE_INFINITY;
        if (d2 != d2) {
            return d2;
        }
        double d4 = d2 - 0.0;
        double d5 = d4 == 0.0 ? 0 : (d4 > 0.0 ? 1 : -1);
        if (d5 == false) {
            return 1.0;
        }
        double d6 = 0.0;
        double d7 = Double.NEGATIVE_INFINITY;
        if (d == 0.0) {
            if (1.0 / d > 0.0) {
                d2 = d3;
                if (d5 <= 0) return d2;
                return 0.0;
            }
            long l = (long)d2;
            if ((double)l == d2 && (l & 1L) != 0L) {
                if (d5 <= 0) return Double.NEGATIVE_INFINITY;
                d = d6;
                d2 = d;
                return d2;
            }
            d2 = d3;
            if (d5 <= 0) return d2;
            return 0.0;
        }
        d6 = Math.pow(d, d2);
        if (d6 == d6) return d6;
        if (d2 == Double.POSITIVE_INFINITY) {
            d2 = d3;
            if (d < -1.0) return d2;
            if (!(1.0 < d)) {
                if (!(-1.0 < d)) return d6;
                if (!(d < 1.0)) return d6;
                return 0.0;
            }
            d2 = d3;
            return d2;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            if (d < -1.0) return 0.0;
            if (1.0 < d) return 0.0;
            if (!(-1.0 < d)) return d6;
            if (!(d < 1.0)) return d6;
            return d3;
        }
        if (d == Double.POSITIVE_INFINITY) {
            if (d5 <= 0) return 0.0;
            return d3;
        }
        if (d != Double.NEGATIVE_INFINITY) return d6;
        long l = (long)d2;
        if ((double)l == d2 && (l & 1L) != 0L) {
            if (d5 <= 0) return 0.0;
            return d7;
        }
        if (d5 <= 0) return 0.0;
        return d3;
    }

    private double js_trunc(double d) {
        d = d < 0.0 ? Math.ceil(d) : Math.floor(d);
        return d;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object execIdCall(IdFunctionObject var1_1, Context var2_2, Scriptable var3_3, Scriptable var4_4, Object[] var5_5) {
        if (!var1_1.hasTag(NativeMath.MATH_TAG)) {
            return super.execIdCall(var1_1, var2_2, var3_3, var4_4, var5_5);
        }
        var6_6 = var1_1.methodId();
        var7_7 = NaN;
        var9_8 = -Infinity;
        var11_9 = 0;
        block0 : switch (var6_6) {
            default: {
                throw new IllegalStateException(String.valueOf(var6_6));
            }
            case 29: {
                var9_8 = this.js_trunc(ScriptRuntime.toNumber(var5_5, 0));
                break;
            }
            case 28: {
                return this.js_imul(var5_5);
            }
            case 27: {
                var9_8 = Math.tanh(ScriptRuntime.toNumber(var5_5, 0));
                break;
            }
            case 26: {
                var9_8 = Math.sinh(ScriptRuntime.toNumber(var5_5, 0));
                break;
            }
            case 25: {
                var9_8 = Math.log10(ScriptRuntime.toNumber(var5_5, 0));
                break;
            }
            case 24: {
                var9_8 = Math.log1p(ScriptRuntime.toNumber(var5_5, 0));
                break;
            }
            case 23: {
                var9_8 = this.js_hypot(var5_5);
                break;
            }
            case 22: {
                var9_8 = Math.expm1(ScriptRuntime.toNumber(var5_5, 0));
                break;
            }
            case 21: {
                var9_8 = Math.cosh(ScriptRuntime.toNumber(var5_5, 0));
                break;
            }
            case 20: {
                var9_8 = Math.cbrt(ScriptRuntime.toNumber(var5_5, 0));
                break;
            }
            case 19: {
                var9_8 = Math.tan(ScriptRuntime.toNumber(var5_5, 0));
                break;
            }
            case 18: {
                var9_8 = Math.sqrt(ScriptRuntime.toNumber(var5_5, 0));
                break;
            }
            case 17: {
                var12_10 = ScriptRuntime.toNumber(var5_5, 0);
                var9_8 = var7_7;
                if (var12_10 == Infinity) break;
                if (var12_10 == -Infinity) {
                    var9_8 = var7_7;
                    break;
                }
                var9_8 = Math.sin(var12_10);
                break;
            }
            case 16: {
                var9_8 = var7_7 = ScriptRuntime.toNumber(var5_5, 0);
                if (var7_7 != var7_7) break;
                var9_8 = var7_7;
                if (var7_7 == Infinity) break;
                var9_8 = var7_7;
                if (var7_7 == -Infinity) break;
                var14_13 = Math.round(var7_7);
                if (var14_13 != 0L) {
                    var9_8 = var14_13;
                    break;
                }
                if (var7_7 < 0.0) {
                    var9_8 = ScriptRuntime.negativeZero;
                    break;
                }
                var9_8 = var7_7;
                if (var7_7 == 0.0) break;
lbl70:
                // 3 sources

                while (true) {
                    var9_8 = 0.0;
                    break block0;
                    break;
                }
            }
            case 15: {
                var9_8 = Math.random();
                break;
            }
            case 14: {
                var9_8 = this.js_pow(ScriptRuntime.toNumber(var5_5, 0), ScriptRuntime.toNumber(var5_5, 1));
                break;
            }
            case 12: 
            case 13: {
                if (var6_6 != 12) {
                    var9_8 = Infinity;
                }
                while (var11_9 != var5_5.length) {
                    var7_7 = ScriptRuntime.toNumber(var5_5[var11_9]);
                    if (var7_7 != var7_7) {
                        var9_8 = var7_7;
                        break block0;
                    }
                    var9_8 = var6_6 == 12 ? Math.max(var9_8, var7_7) : Math.min(var9_8, var7_7);
                    ++var11_9;
                }
                break;
            }
            case 11: {
                var9_8 = ScriptRuntime.toNumber(var5_5, 0);
                if (var9_8 < 0.0) {
                    var9_8 = var7_7;
                    break;
                }
                var9_8 = Math.log(var9_8);
                break;
            }
            case 10: {
                var9_8 = Math.floor(ScriptRuntime.toNumber(var5_5, 0));
                break;
            }
            case 9: {
                var9_8 = ScriptRuntime.toNumber(var5_5, 0);
                if (var9_8 == Infinity) break;
                if (var9_8 == -Infinity) ** GOTO lbl70
                var9_8 = Math.exp(var9_8);
                break;
            }
            case 8: {
                var12_11 = ScriptRuntime.toNumber(var5_5, 0);
                var9_8 = var7_7;
                if (var12_11 == Infinity) break;
                if (var12_11 == -Infinity) {
                    var9_8 = var7_7;
                    break;
                }
                var9_8 = Math.cos(var12_11);
                break;
            }
            case 7: {
                var9_8 = Math.ceil(ScriptRuntime.toNumber(var5_5, 0));
                break;
            }
            case 6: {
                var9_8 = Math.atan2(ScriptRuntime.toNumber(var5_5, 0), ScriptRuntime.toNumber(var5_5, 1));
                break;
            }
            case 5: {
                var9_8 = Math.atan(ScriptRuntime.toNumber(var5_5, 0));
                break;
            }
            case 3: 
            case 4: {
                var12_12 = ScriptRuntime.toNumber(var5_5, 0);
                var9_8 = var7_7;
                if (var12_12 != var12_12) break;
                var9_8 = var7_7;
                if (!(-1.0 <= var12_12)) break;
                var9_8 = var7_7;
                if (!(var12_12 <= 1.0)) break;
                if (var6_6 == 3) {
                    var9_8 = Math.acos(var12_12);
                    break;
                }
                var9_8 = Math.asin(var12_12);
                break;
            }
            case 2: {
                var7_7 = ScriptRuntime.toNumber(var5_5, 0);
                if (var7_7 != 0.0) ** break;
                ** continue;
                var9_8 = var7_7;
                if (!(var7_7 < 0.0)) break;
                var9_8 = -var7_7;
                break;
            }
        }
        return ScriptRuntime.wrapNumber(var9_8);
        {
            ** case 1:
        }
lbl148:
        // 1 sources

        return "Math";
    }

    @Override
    protected int findPrototypeId(String string2) {
        int n;
        block70: {
            String string3;
            int n2;
            block69: {
                int n3 = string2.length();
                n = 4;
                n2 = 0;
                block0 : switch (n3) {
                    default: {
                        break;
                    }
                    case 8: {
                        string3 = "toSource";
                        n = 1;
                        break block69;
                    }
                    case 7: {
                        n = 36;
                        string3 = "SQRT1_2";
                        break block69;
                    }
                    case 6: {
                        n = string2.charAt(0);
                        if (n == 76) {
                            n = 35;
                            string3 = "LOG10E";
                        } else {
                            if (n != 114) break;
                            n = 15;
                            string3 = "random";
                        }
                        break block69;
                    }
                    case 5: {
                        n = string2.charAt(0);
                        if (n != 76) {
                            if (n != 83) {
                                if (n != 97) {
                                    if (n != 104) {
                                        if (n != 108) {
                                            if (n != 114) {
                                                if (n != 116) {
                                                    if (n != 101) {
                                                        if (n != 102) break;
                                                        n = 10;
                                                        string3 = "floor";
                                                    } else {
                                                        n = 22;
                                                        string3 = "expm1";
                                                    }
                                                } else {
                                                    n = 29;
                                                    string3 = "trunc";
                                                }
                                            } else {
                                                n = 16;
                                                string3 = "round";
                                            }
                                        } else {
                                            n = string2.charAt(4);
                                            if (n == 48) {
                                                n = 25;
                                                string3 = "log10";
                                            } else {
                                                if (n != 112) break;
                                                n = 24;
                                                string3 = "log1p";
                                            }
                                        }
                                    } else {
                                        n = 23;
                                        string3 = "hypot";
                                    }
                                } else {
                                    n = 6;
                                    string3 = "atan2";
                                }
                            } else {
                                n = 37;
                                string3 = "SQRT2";
                            }
                        } else {
                            n = 34;
                            string3 = "LOG2E";
                        }
                        break block69;
                    }
                    case 4: {
                        n3 = string2.charAt(1);
                        if (n3 != 78) {
                            if (n3 != 101) {
                                if (n3 != 105) {
                                    if (n3 != 109) {
                                        if (n3 != 111) {
                                            if (n3 != 113) {
                                                if (n3 != 115) {
                                                    if (n3 != 116) {
                                                        switch (n3) {
                                                            default: {
                                                                break block0;
                                                            }
                                                            case 99: {
                                                                n = 3;
                                                                string3 = "acos";
                                                                break;
                                                            }
                                                            case 98: {
                                                                n = 20;
                                                                string3 = "cbrt";
                                                                break;
                                                            }
                                                            case 97: {
                                                                n = 27;
                                                                string3 = "tanh";
                                                                break;
                                                            }
                                                        }
                                                    } else {
                                                        n = 5;
                                                        string3 = "atan";
                                                    }
                                                } else {
                                                    string3 = "asin";
                                                }
                                            } else {
                                                n = 18;
                                                string3 = "sqrt";
                                            }
                                        } else {
                                            n = 21;
                                            string3 = "cosh";
                                        }
                                    } else {
                                        n = 28;
                                        string3 = "imul";
                                    }
                                } else {
                                    n = 26;
                                    string3 = "sinh";
                                }
                            } else {
                                n = 7;
                                string3 = "ceil";
                            }
                        } else {
                            n = 32;
                            string3 = "LN10";
                        }
                        break block69;
                    }
                    case 3: {
                        n = string2.charAt(0);
                        if (n != 76) {
                            if (n != 97) {
                                if (n != 99) {
                                    if (n != 101) {
                                        if (n != 112) {
                                            if (n != 108) {
                                                if (n != 109) {
                                                    if (n != 115) {
                                                        if (n != 116 || string2.charAt(2) != 'n' || string2.charAt(1) != 'a') break;
                                                        n = 19;
                                                    } else {
                                                        if (string2.charAt(2) != 'n' || string2.charAt(1) != 'i') break;
                                                        n = 17;
                                                    }
                                                } else {
                                                    n = string2.charAt(2);
                                                    if (n == 110) {
                                                        if (string2.charAt(1) != 'i') break;
                                                        n = 13;
                                                    } else {
                                                        if (n != 120 || string2.charAt(1) != 'a') break;
                                                        n = 12;
                                                    }
                                                }
                                            } else {
                                                if (string2.charAt(2) != 'g' || string2.charAt(1) != 'o') break;
                                                n = 11;
                                            }
                                        } else {
                                            if (string2.charAt(2) != 'w' || string2.charAt(1) != 'o') break;
                                            n = 14;
                                        }
                                    } else {
                                        if (string2.charAt(2) != 'p' || string2.charAt(1) != 'x') break;
                                        n = 9;
                                    }
                                } else {
                                    if (string2.charAt(2) != 's' || string2.charAt(1) != 'o') break;
                                    n = 8;
                                }
                            } else {
                                if (string2.charAt(2) != 's' || string2.charAt(1) != 'b') break;
                                n = 2;
                            }
                        } else {
                            if (string2.charAt(2) != '2' || string2.charAt(1) != 'N') break;
                            n = 33;
                        }
                        break block70;
                    }
                    case 2: {
                        if (string2.charAt(0) != 'P' || string2.charAt(1) != 'I') break;
                        n = 31;
                        break block70;
                    }
                    case 1: {
                        if (string2.charAt(0) != 'E') break;
                        n = 30;
                        break block70;
                    }
                }
                string3 = null;
                n = 0;
            }
            if (string3 == null || string3 == string2 || string3.equals(string2)) break block70;
            n = n2;
        }
        return n;
    }

    @Override
    public String getClassName() {
        return "Math";
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void initPrototypeId(int var1_1) {
        block44: {
            block41: {
                block42: {
                    block43: {
                        if (var1_1 > 29) break block41;
                        var2_2 = 1;
                        switch (var1_1) {
                            default: {
                                throw new IllegalStateException(String.valueOf(var1_1));
                            }
                            case 29: {
                                var3_3 = "trunc";
                                break block42;
                            }
                            case 28: {
                                var3_3 = "imul";
                                ** GOTO lbl77
                            }
                            case 27: {
                                var3_3 = "tanh";
                                break block42;
                            }
                            case 26: {
                                var3_3 = "sinh";
                                break block42;
                            }
                            case 25: {
                                var3_3 = "log10";
                                break block42;
                            }
                            case 24: {
                                var3_3 = "log1p";
                                break block42;
                            }
                            case 23: {
                                var3_3 = "hypot";
                                ** GOTO lbl77
                            }
                            case 22: {
                                var3_3 = "expm1";
                                break block42;
                            }
                            case 21: {
                                var3_3 = "cosh";
                                break block42;
                            }
                            case 20: {
                                var3_3 = "cbrt";
                                break block42;
                            }
                            case 19: {
                                var3_3 = "tan";
                                break block42;
                            }
                            case 18: {
                                var3_3 = "sqrt";
                                break block42;
                            }
                            case 17: {
                                var3_3 = "sin";
                                break block42;
                            }
                            case 16: {
                                var3_3 = "round";
                                break block42;
                            }
                            case 15: {
                                var3_3 = "random";
                                break block43;
                            }
                            case 14: {
                                var3_3 = "pow";
                                ** GOTO lbl77
                            }
                            case 13: {
                                var3_3 = "min";
                                ** GOTO lbl77
                            }
                            case 12: {
                                var3_3 = "max";
                                ** GOTO lbl77
                            }
                            case 11: {
                                var3_3 = "log";
                                break block42;
                            }
                            case 10: {
                                var3_3 = "floor";
                                break block42;
                            }
                            case 9: {
                                var3_3 = "exp";
                                break block42;
                            }
                            case 8: {
                                var3_3 = "cos";
                                break block42;
                            }
                            case 7: {
                                var3_3 = "ceil";
                                break block42;
                            }
                            case 6: {
                                var3_3 = "atan2";
lbl77:
                                // 6 sources

                                var2_2 = 2;
                                break block42;
                            }
                            case 5: {
                                var3_3 = "atan";
                                break block42;
                            }
                            case 4: {
                                var3_3 = "asin";
                                break block42;
                            }
                            case 3: {
                                var3_3 = "acos";
                                break block42;
                            }
                            case 2: {
                                var3_3 = "abs";
                                break block42;
                            }
                            case 1: 
                        }
                        var3_3 = "toSource";
                    }
                    var2_2 = 0;
                }
                this.initPrototypeMethod(NativeMath.MATH_TAG, var1_1, var3_3, var2_2);
                break block44;
            }
            switch (var1_1) {
                default: {
                    throw new IllegalStateException(String.valueOf(var1_1));
                }
                case 37: {
                    var4_5 = 1.4142135623730951;
                    var3_4 = "SQRT2";
                    break;
                }
                case 36: {
                    var4_5 = 0.7071067811865476;
                    var3_4 = "SQRT1_2";
                    break;
                }
                case 35: {
                    var4_5 = 0.4342944819032518;
                    var3_4 = "LOG10E";
                    break;
                }
                case 34: {
                    var4_5 = 1.4426950408889634;
                    var3_4 = "LOG2E";
                    break;
                }
                case 33: {
                    var4_5 = 0.6931471805599453;
                    var3_4 = "LN2";
                    break;
                }
                case 32: {
                    var4_5 = 2.302585092994046;
                    var3_4 = "LN10";
                    break;
                }
                case 31: {
                    var4_5 = 3.141592653589793;
                    var3_4 = "PI";
                    break;
                }
                case 30: {
                    var4_5 = 2.718281828459045;
                    var3_4 = "E";
                }
            }
            this.initPrototypeValue(var1_1, var3_4, (Object)ScriptRuntime.wrapNumber(var4_5), 7);
        }
    }
}

