/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.DToA;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

final class NativeNumber
extends IdScriptableObject {
    private static final int ConstructorId_isFinite = -1;
    private static final int ConstructorId_isInteger = -3;
    private static final int ConstructorId_isNaN = -2;
    private static final int ConstructorId_isSafeInteger = -4;
    private static final int ConstructorId_parseFloat = -5;
    private static final int ConstructorId_parseInt = -6;
    private static final int Id_constructor = 1;
    private static final int Id_toExponential = 7;
    private static final int Id_toFixed = 6;
    private static final int Id_toLocaleString = 3;
    private static final int Id_toPrecision = 8;
    private static final int Id_toSource = 4;
    private static final int Id_toString = 2;
    private static final int Id_valueOf = 5;
    private static final int MAX_PRECISION = 100;
    private static final int MAX_PROTOTYPE_ID = 8;
    private static final double MAX_SAFE_INTEGER;
    private static final double MIN_SAFE_INTEGER;
    private static final Object NUMBER_TAG;
    static final long serialVersionUID = 3504516769741512101L;
    private double doubleValue;

    static {
        double d;
        NUMBER_TAG = "Number";
        MAX_SAFE_INTEGER = d = Math.pow(2.0, 53.0) - 1.0;
        MIN_SAFE_INTEGER = -d;
    }

    NativeNumber(double d) {
        this.doubleValue = d;
    }

    private Double doubleVal(Number number) {
        if (number instanceof Double) {
            return (Double)number;
        }
        return number.doubleValue();
    }

    private Object execConstructorCall(int n, Object[] objectArray) {
        Boolean bl = false;
        switch (n) {
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
            case -1: {
                if (objectArray.length != 0 && Undefined.instance != objectArray[0] && objectArray[0] instanceof Number) {
                    return NativeNumber.isFinite(objectArray[0]);
                }
                return bl;
            }
            case -2: {
                if (objectArray.length != 0 && Undefined.instance != objectArray[0] && objectArray[0] instanceof Number) {
                    return this.isNaN((Number)objectArray[0]);
                }
                return bl;
            }
            case -3: {
                if (objectArray.length != 0 && Undefined.instance != objectArray[0] && objectArray[0] instanceof Number) {
                    return this.isInteger((Number)objectArray[0]);
                }
                return bl;
            }
            case -4: {
                if (objectArray.length != 0 && Undefined.instance != objectArray[0] && objectArray[0] instanceof Number) {
                    return this.isSafeInteger((Number)objectArray[0]);
                }
                return bl;
            }
            case -5: {
                return NativeGlobal.js_parseFloat(objectArray);
            }
            case -6: 
        }
        return NativeGlobal.js_parseInt(objectArray);
    }

    static void init(Scriptable scriptable, boolean bl) {
        new NativeNumber(0.0).exportAsJSClass(8, scriptable, bl);
    }

    private boolean isDoubleInteger(Double d) {
        boolean bl = !d.isInfinite() && !d.isNaN() && Math.floor(d) == d;
        return bl;
    }

    private boolean isDoubleNan(Double d) {
        return d.isNaN();
    }

    private boolean isDoubleSafeInteger(Double d) {
        boolean bl = this.isDoubleInteger(d) && d <= MAX_SAFE_INTEGER && d >= MIN_SAFE_INTEGER;
        return bl;
    }

    static Object isFinite(Object object) {
        boolean bl = !((Double)(object = Double.valueOf(ScriptRuntime.toNumber(object)))).isInfinite() && !((Double)object).isNaN();
        return ScriptRuntime.wrapBoolean(bl);
    }

    private boolean isInteger(Number number) {
        return ScriptRuntime.toBoolean(this.isDoubleInteger(this.doubleVal(number)));
    }

    private Object isNaN(Number number) {
        return ScriptRuntime.toBoolean(this.isDoubleNan(this.doubleVal(number)));
    }

    private boolean isSafeInteger(Number number) {
        return ScriptRuntime.toBoolean(this.isDoubleSafeInteger(this.doubleVal(number)));
    }

    private static String num_to(double d, Object[] object, int n, int n2, int n3, int n4) {
        block4: {
            block3: {
                block2: {
                    int n5 = ((Object[])object).length;
                    int n6 = 0;
                    if (n5 != 0) break block2;
                    n2 = n6;
                    break block3;
                }
                double d2 = ScriptRuntime.toInteger(object[0]);
                if (d2 < (double)n3 || d2 > 100.0) break block4;
                n3 = ScriptRuntime.toInt32(d2);
                n = n2;
                n2 = n3;
            }
            object = new StringBuilder();
            DToA.JS_dtostr((StringBuilder)object, n, n2 + n4, d);
            return ((StringBuilder)object).toString();
        }
        throw ScriptRuntime.constructError("RangeError", ScriptRuntime.getMessage1("msg.bad.precision", ScriptRuntime.toString(object[0])));
    }

    @Override
    public Object execIdCall(IdFunctionObject serializable, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!((IdFunctionObject)serializable).hasTag(NUMBER_TAG)) {
            return super.execIdCall((IdFunctionObject)serializable, context, scriptable, scriptable2, objectArray);
        }
        int n = ((IdFunctionObject)serializable).methodId();
        double d = 0.0;
        if (n == 1) {
            if (objectArray.length >= 1) {
                d = ScriptRuntime.toNumber(objectArray[0]);
            }
            if (scriptable2 == null) {
                return new NativeNumber(d);
            }
            return ScriptRuntime.wrapNumber(d);
        }
        if (n < 1) {
            return this.execConstructorCall(n, objectArray);
        }
        if (scriptable2 instanceof NativeNumber) {
            d = ((NativeNumber)scriptable2).doubleValue;
            int n2 = 10;
            switch (n) {
                default: {
                    throw new IllegalArgumentException(String.valueOf(n));
                }
                case 8: {
                    if (objectArray.length != 0 && objectArray[0] != Undefined.instance) {
                        if (Double.isNaN(d)) {
                            return "NaN";
                        }
                        if (Double.isInfinite(d)) {
                            if (d >= 0.0) {
                                return "Infinity";
                            }
                            return "-Infinity";
                        }
                        return NativeNumber.num_to(d, objectArray, 0, 4, 1, 0);
                    }
                    return ScriptRuntime.numberToString(d, 10);
                }
                case 7: {
                    if (Double.isNaN(d)) {
                        return "NaN";
                    }
                    if (Double.isInfinite(d)) {
                        if (d >= 0.0) {
                            return "Infinity";
                        }
                        return "-Infinity";
                    }
                    return NativeNumber.num_to(d, objectArray, 1, 3, 0, 1);
                }
                case 6: {
                    return NativeNumber.num_to(d, objectArray, 2, 2, -20, 0);
                }
                case 5: {
                    return ScriptRuntime.wrapNumber(d);
                }
                case 4: {
                    serializable = new StringBuilder();
                    ((StringBuilder)serializable).append("(new Number(");
                    ((StringBuilder)serializable).append(ScriptRuntime.toString(d));
                    ((StringBuilder)serializable).append("))");
                    return ((StringBuilder)serializable).toString();
                }
                case 2: 
                case 3: 
            }
            n = n2;
            if (objectArray.length != 0) {
                n = objectArray[0] == Undefined.instance ? n2 : ScriptRuntime.toInt32(objectArray[0]);
            }
            return ScriptRuntime.numberToString(d, n);
        }
        throw NativeNumber.incompatibleCallError((IdFunctionObject)serializable);
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        idFunctionObject.defineProperty("NaN", (Object)ScriptRuntime.NaNobj, 7);
        idFunctionObject.defineProperty("POSITIVE_INFINITY", (Object)ScriptRuntime.wrapNumber(Double.POSITIVE_INFINITY), 7);
        idFunctionObject.defineProperty("NEGATIVE_INFINITY", (Object)ScriptRuntime.wrapNumber(Double.NEGATIVE_INFINITY), 7);
        idFunctionObject.defineProperty("MAX_VALUE", (Object)ScriptRuntime.wrapNumber(Double.MAX_VALUE), 7);
        idFunctionObject.defineProperty("MIN_VALUE", (Object)ScriptRuntime.wrapNumber(Double.MIN_VALUE), 7);
        idFunctionObject.defineProperty("MAX_SAFE_INTEGER", (Object)ScriptRuntime.wrapNumber(MAX_SAFE_INTEGER), 7);
        idFunctionObject.defineProperty("MIN_SAFE_INTEGER", (Object)ScriptRuntime.wrapNumber(MIN_SAFE_INTEGER), 7);
        Object object = NUMBER_TAG;
        this.addIdFunctionProperty(idFunctionObject, object, -1, "isFinite", 1);
        this.addIdFunctionProperty(idFunctionObject, object, -2, "isNaN", 1);
        this.addIdFunctionProperty(idFunctionObject, object, -3, "isInteger", 1);
        this.addIdFunctionProperty(idFunctionObject, object, -4, "isSafeInteger", 1);
        this.addIdFunctionProperty(idFunctionObject, object, -5, "parseFloat", 1);
        this.addIdFunctionProperty(idFunctionObject, object, -6, "parseInt", 1);
        super.fillConstructorProperties(idFunctionObject);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int findPrototypeId(String string2) {
        String string3;
        int n = string2.length();
        int n2 = 3;
        int n3 = 0;
        if (n != 7) {
            if (n != 8) {
                if (n != 11) {
                    if (n != 13) {
                        if (n != 14) return 0;
                        string3 = "toLocaleString";
                    } else {
                        string3 = "toExponential";
                        n2 = 7;
                    }
                } else {
                    n2 = string2.charAt(0);
                    if (n2 == 99) {
                        n2 = 1;
                        string3 = "constructor";
                    } else {
                        if (n2 != 116) return 0;
                        string3 = "toPrecision";
                        n2 = 8;
                    }
                }
            } else {
                n2 = string2.charAt(3);
                if (n2 == 111) {
                    n2 = 4;
                    string3 = "toSource";
                } else {
                    if (n2 != 116) return 0;
                    n2 = 2;
                    string3 = "toString";
                }
            }
        } else {
            n2 = string2.charAt(0);
            if (n2 == 116) {
                n2 = 6;
                string3 = "toFixed";
            } else {
                if (n2 != 118) return 0;
                n2 = 5;
                string3 = "valueOf";
            }
        }
        if (string3 == null) return n2;
        if (string3 == string2) return n2;
        if (string3.equals(string2)) return n2;
        return n3;
    }

    @Override
    public String getClassName() {
        return "Number";
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void initPrototypeId(int var1_1) {
        block10: {
            var2_2 = 1;
            switch (var1_1) {
                default: {
                    throw new IllegalArgumentException(String.valueOf(var1_1));
                }
                case 8: {
                    var3_3 = "toPrecision";
                    break block10;
                }
                case 7: {
                    var3_3 = "toExponential";
                    break block10;
                }
                case 6: {
                    var3_3 = "toFixed";
                    break block10;
                }
                case 5: {
                    var3_3 = "valueOf";
                    ** GOTO lbl19
                }
                case 4: {
                    var3_3 = "toSource";
lbl19:
                    // 2 sources

                    var2_2 = 0;
                    break block10;
                }
                case 3: {
                    var3_3 = "toLocaleString";
                    break block10;
                }
                case 2: {
                    var3_3 = "toString";
                    break block10;
                }
                case 1: 
            }
            var3_3 = "constructor";
        }
        this.initPrototypeMethod(NativeNumber.NUMBER_TAG, var1_1, var3_3, var2_2);
    }

    public String toString() {
        return ScriptRuntime.numberToString(this.doubleValue, 10);
    }
}

