/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.DefaultErrorReporter;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

class NativeScript
extends BaseFunction {
    private static final int Id_compile = 3;
    private static final int Id_constructor = 1;
    private static final int Id_exec = 4;
    private static final int Id_toString = 2;
    private static final int MAX_PROTOTYPE_ID = 4;
    private static final Object SCRIPT_TAG = "Script";
    static final long serialVersionUID = -6795101161980121700L;
    private Script script;

    private NativeScript(Script script) {
        this.script = script;
    }

    private static Script compile(Context context, String string2) {
        String string3;
        int[] nArray = new int[]{0};
        String string4 = string3 = Context.getSourcePositionFromStack(nArray);
        if (string3 == null) {
            nArray[0] = 1;
            string4 = "<Script object>";
        }
        return context.compileString(string2, null, DefaultErrorReporter.forEval(context.getErrorReporter()), string4, nArray[0], null);
    }

    static void init(Scriptable scriptable, boolean bl) {
        new NativeScript(null).exportAsJSClass(4, scriptable, bl);
    }

    private static NativeScript realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        if (scriptable instanceof NativeScript) {
            return (NativeScript)scriptable;
        }
        throw NativeScript.incompatibleCallError(idFunctionObject);
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable object, Object[] objectArray) {
        object = this.script;
        if (object != null) {
            return object.exec(context, scriptable);
        }
        return Undefined.instance;
    }

    @Override
    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        throw Context.reportRuntimeError0("msg.script.is.not.constructor");
    }

    @Override
    String decompile(int n, int n2) {
        Script script = this.script;
        if (script instanceof NativeFunction) {
            return ((NativeFunction)((Object)script)).decompile(n, n2);
        }
        return super.decompile(n, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject object, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!((IdFunctionObject)object).hasTag(SCRIPT_TAG)) {
            return super.execIdCall((IdFunctionObject)object, context, scriptable, scriptable2, objectArray);
        }
        int n = ((IdFunctionObject)object).methodId();
        String string2 = "";
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    if (n != 4) {
                        throw new IllegalArgumentException(String.valueOf(n));
                    }
                    throw Context.reportRuntimeError1("msg.cant.call.indirect", "exec");
                }
                object = NativeScript.realThis(scriptable2, (IdFunctionObject)object);
                ((NativeScript)object).script = NativeScript.compile(context, ScriptRuntime.toString(objectArray, 0));
                return object;
            }
            object = NativeScript.realThis((Scriptable)scriptable2, (IdFunctionObject)object).script;
            if (object == null) {
                return "";
            }
            return context.decompileScript((Script)object, 0);
        }
        object = objectArray.length == 0 ? string2 : ScriptRuntime.toString(objectArray[0]);
        object = new NativeScript(NativeScript.compile(context, (String)object));
        ScriptRuntime.setObjectProtoAndParent((ScriptableObject)object, scriptable);
        return object;
    }

    @Override
    protected int findPrototypeId(String string2) {
        int n;
        block8: {
            String string3;
            int n2 = string2.length();
            n = 4;
            int n3 = 0;
            if (n2 != 4) {
                if (n2 != 11) {
                    if (n2 != 7) {
                        if (n2 != 8) {
                            string3 = null;
                            n = 0;
                        } else {
                            n = 2;
                            string3 = "toString";
                        }
                    } else {
                        n = 3;
                        string3 = "compile";
                    }
                } else {
                    n = 1;
                    string3 = "constructor";
                }
            } else {
                string3 = "exec";
            }
            if (string3 == null || string3 == string2 || string3.equals(string2)) break block8;
            n = n3;
        }
        return n;
    }

    @Override
    public int getArity() {
        return 0;
    }

    @Override
    public String getClassName() {
        return "Script";
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    protected void initPrototypeId(int n) {
        String string2;
        int n2;
        block4: {
            block5: {
                block0: {
                    block1: {
                        block2: {
                            block3: {
                                n2 = 0;
                                if (n == 1) break block0;
                                if (n == 2) break block1;
                                if (n == 3) break block2;
                                if (n != 4) break block3;
                                string2 = "exec";
                                break block4;
                            }
                            throw new IllegalArgumentException(String.valueOf(n));
                        }
                        string2 = "compile";
                        break block5;
                    }
                    string2 = "toString";
                    break block4;
                }
                string2 = "constructor";
            }
            n2 = 1;
        }
        this.initPrototypeMethod(SCRIPT_TAG, n, string2, n2);
    }
}

