/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;

public class NativeSymbol
extends IdScriptableObject
implements Symbol {
    public static final String CLASS_NAME = "Symbol";
    private static final Object CONSTRUCTOR_SLOT;
    private static final int ConstructorId_for = -1;
    private static final int ConstructorId_keyFor = -2;
    private static final Object GLOBAL_TABLE_KEY;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_valueOf = 4;
    private static final int MAX_PROTOTYPE_ID = 5;
    private static final int SymbolId_toPrimitive = 5;
    private static final int SymbolId_toStringTag = 3;
    public static final String TYPE_NAME = "symbol";
    private static final long serialVersionUID = -589539749749830003L;
    private final SymbolKey key;
    private final NativeSymbol symbolData;

    static {
        GLOBAL_TABLE_KEY = new Object();
        CONSTRUCTOR_SLOT = new Object();
    }

    private NativeSymbol(String string2) {
        this.key = new SymbolKey(string2);
        this.symbolData = this;
    }

    public NativeSymbol(NativeSymbol nativeSymbol) {
        this.key = nativeSymbol.key;
        this.symbolData = nativeSymbol.symbolData;
    }

    private NativeSymbol(SymbolKey symbolKey) {
        this.key = symbolKey;
        this.symbolData = this;
    }

    public static NativeSymbol construct(Context context, Scriptable scriptable, Object[] objectArray) {
        Object object = CONSTRUCTOR_SLOT;
        context.putThreadLocal(object, Boolean.TRUE);
        try {
            scriptable = (NativeSymbol)context.newObject(scriptable, CLASS_NAME, objectArray);
            context.removeThreadLocal(object);
            return scriptable;
        }
        catch (Throwable throwable) {
            context.removeThreadLocal(CONSTRUCTOR_SLOT);
            throw throwable;
        }
    }

    private static void createStandardSymbol(Context context, Scriptable scriptable, ScriptableObject scriptableObject, String string2, SymbolKey symbolKey) {
        scriptableObject.defineProperty(string2, (Object)context.newObject(scriptable, CLASS_NAME, new Object[]{string2, symbolKey}), 7);
    }

    private Map<String, NativeSymbol> getGlobalMap() {
        HashMap hashMap;
        ScriptableObject scriptableObject = (ScriptableObject)NativeSymbol.getTopLevelScope(this);
        Object object = GLOBAL_TABLE_KEY;
        HashMap hashMap2 = hashMap = (HashMap)scriptableObject.getAssociatedValue(object);
        if (hashMap == null) {
            hashMap2 = new HashMap();
            scriptableObject.associateValue(object, hashMap2);
        }
        return hashMap2;
    }

    private NativeSymbol getSelf(Object object) {
        try {
            NativeSymbol nativeSymbol = (NativeSymbol)object;
            return nativeSymbol;
        }
        catch (ClassCastException classCastException) {
            throw ScriptRuntime.typeError1("msg.invalid.type", object.getClass().getName());
        }
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        IdFunctionObject idFunctionObject = new NativeSymbol("").exportAsJSClass(5, scriptable, false);
        Object object = CONSTRUCTOR_SLOT;
        context.putThreadLocal(object, Boolean.TRUE);
        try {
            NativeSymbol.createStandardSymbol(context, scriptable, idFunctionObject, "iterator", SymbolKey.ITERATOR);
            NativeSymbol.createStandardSymbol(context, scriptable, idFunctionObject, "species", SymbolKey.SPECIES);
            NativeSymbol.createStandardSymbol(context, scriptable, idFunctionObject, "toStringTag", SymbolKey.TO_STRING_TAG);
            NativeSymbol.createStandardSymbol(context, scriptable, idFunctionObject, "hasInstance", SymbolKey.HAS_INSTANCE);
            NativeSymbol.createStandardSymbol(context, scriptable, idFunctionObject, "isConcatSpreadable", SymbolKey.IS_CONCAT_SPREADABLE);
            NativeSymbol.createStandardSymbol(context, scriptable, idFunctionObject, "isRegExp", SymbolKey.IS_REGEXP);
            NativeSymbol.createStandardSymbol(context, scriptable, idFunctionObject, "toPrimitive", SymbolKey.TO_PRIMITIVE);
            NativeSymbol.createStandardSymbol(context, scriptable, idFunctionObject, "match", SymbolKey.MATCH);
            NativeSymbol.createStandardSymbol(context, scriptable, idFunctionObject, "replace", SymbolKey.REPLACE);
            NativeSymbol.createStandardSymbol(context, scriptable, idFunctionObject, "search", SymbolKey.SEARCH);
            NativeSymbol.createStandardSymbol(context, scriptable, idFunctionObject, "split", SymbolKey.SPLIT);
            NativeSymbol.createStandardSymbol(context, scriptable, idFunctionObject, "unscopables", SymbolKey.UNSCOPABLES);
            context.removeThreadLocal(object);
            if (bl) {
                idFunctionObject.sealObject();
            }
            return;
        }
        catch (Throwable throwable) {
            context.removeThreadLocal(CONSTRUCTOR_SLOT);
            throw throwable;
        }
    }

    private static NativeSymbol js_constructor(Object[] objectArray) {
        String string2;
        int n = objectArray.length;
        String string3 = string2 = "";
        if (n > 0) {
            string3 = Undefined.instance.equals(objectArray[0]) ? string2 : ScriptRuntime.toString(objectArray[0]);
        }
        if (objectArray.length > 1) {
            return new NativeSymbol((SymbolKey)objectArray[1]);
        }
        return new NativeSymbol(string3);
    }

    private Object js_for(Context context, Scriptable scriptable, Object[] object) {
        object = ((Object[])object).length > 0 ? object[0] : Undefined.instance;
        String string2 = ScriptRuntime.toString(object);
        Map<String, NativeSymbol> map = this.getGlobalMap();
        NativeSymbol nativeSymbol = map.get(string2);
        object = nativeSymbol;
        if (nativeSymbol == null) {
            object = NativeSymbol.construct(context, scriptable, new Object[]{string2});
            map.put(string2, (NativeSymbol)object);
        }
        return object;
    }

    private Object js_keyFor(Context object, Scriptable object22, Object[] object3) {
        Object object2;
        if ((object2 = ((void)object2).length > 0 ? object2[0] : Undefined.instance) instanceof NativeSymbol) {
            object = (NativeSymbol)object2;
            for (Map.Entry<String, NativeSymbol> entry : this.getGlobalMap().entrySet()) {
                if (entry.getValue().key != ((NativeSymbol)object).key) continue;
                return entry.getKey();
            }
            return Undefined.instance;
        }
        throw ScriptRuntime.throwCustomError((Context)object, (Scriptable)object22, "TypeError", "Not a Symbol");
    }

    private Object js_valueOf() {
        return this.symbolData;
    }

    public boolean equals(Object object) {
        return this.key.equals(object);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(CLASS_NAME)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        if (n != -2) {
            if (n != -1) {
                if (n != 1) {
                    if (n != 2) {
                        if (n != 4 && n != 5) {
                            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
                        }
                        return this.getSelf(scriptable2).js_valueOf();
                    }
                    return this.getSelf(scriptable2).toString();
                }
                if (scriptable2 == null) {
                    if (context.getThreadLocal(CONSTRUCTOR_SLOT) != null) {
                        return NativeSymbol.js_constructor(objectArray);
                    }
                    throw ScriptRuntime.typeError0("msg.no.symbol.new");
                }
                return NativeSymbol.construct(context, scriptable, objectArray);
            }
            return this.js_for(context, scriptable, objectArray);
        }
        return this.js_keyFor(context, scriptable, objectArray);
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        super.fillConstructorProperties(idFunctionObject);
        this.addIdFunctionProperty(idFunctionObject, CLASS_NAME, -1, "for", 1);
        this.addIdFunctionProperty(idFunctionObject, CLASS_NAME, -2, "keyFor", 1);
    }

    @Override
    protected int findPrototypeId(String string2) {
        int n;
        block6: {
            String string3;
            n = string2.length();
            int n2 = 0;
            if (n == 7) {
                n = 4;
                string3 = "valueOf";
            } else if (n == 8) {
                n = 2;
                string3 = "toString";
            } else if (n == 11) {
                n = 1;
                string3 = "constructor";
            } else {
                string3 = null;
                n = 0;
            }
            if (string3 == null || string3 == string2 || string3.equals(string2)) break block6;
            n = n2;
        }
        return n;
    }

    @Override
    protected int findPrototypeId(Symbol symbol) {
        if (SymbolKey.TO_STRING_TAG.equals(symbol)) {
            return 3;
        }
        if (SymbolKey.TO_PRIMITIVE.equals(symbol)) {
            return 5;
        }
        return 0;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    SymbolKey getKey() {
        return this.key;
    }

    @Override
    public String getTypeOf() {
        String string2 = this.isSymbol() ? TYPE_NAME : super.getTypeOf();
        return string2;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    protected void initPrototypeId(int n) {
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    if (n != 4) {
                        if (n != 5) {
                            super.initPrototypeId(n);
                        } else {
                            this.initPrototypeMethod((Object)CLASS_NAME, n, SymbolKey.TO_PRIMITIVE, "Symbol.toPrimitive", 1);
                        }
                    } else {
                        this.initPrototypeMethod(CLASS_NAME, n, "valueOf", 0);
                    }
                } else {
                    this.initPrototypeValue(n, SymbolKey.TO_STRING_TAG, (Object)CLASS_NAME, 3);
                }
            } else {
                this.initPrototypeMethod(CLASS_NAME, n, "toString", 0);
            }
        } else {
            this.initPrototypeMethod(CLASS_NAME, n, "constructor", 1);
        }
    }

    public boolean isSymbol() {
        boolean bl = this.symbolData == this;
        return bl;
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        block4: {
            block3: {
                block2: {
                    if (this.isSymbol()) break block2;
                    super.put(n, scriptable, object);
                    break block3;
                }
                if (Context.getCurrentContext().isStrictMode()) break block4;
            }
            return;
        }
        throw ScriptRuntime.typeError0("msg.no.assign.symbol.strict");
    }

    @Override
    public void put(String string2, Scriptable scriptable, Object object) {
        block4: {
            block3: {
                block2: {
                    if (this.isSymbol()) break block2;
                    super.put(string2, scriptable, object);
                    break block3;
                }
                if (Context.getCurrentContext().isStrictMode()) break block4;
            }
            return;
        }
        throw ScriptRuntime.typeError0("msg.no.assign.symbol.strict");
    }

    @Override
    public void put(Symbol symbol, Scriptable scriptable, Object object) {
        block4: {
            block3: {
                block2: {
                    if (this.isSymbol()) break block2;
                    super.put(symbol, scriptable, object);
                    break block3;
                }
                if (Context.getCurrentContext().isStrictMode()) break block4;
            }
            return;
        }
        throw ScriptRuntime.typeError0("msg.no.assign.symbol.strict");
    }

    public String toString() {
        return this.key.toString();
    }
}

