/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ast.Comment;
import org.mozilla.javascript.ast.Jump;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NumberLiteral;
import org.mozilla.javascript.ast.Scope;
import org.mozilla.javascript.ast.ScriptNode;

public class Node
implements Iterable<Node> {
    public static final int ARROW_FUNCTION_PROP = 27;
    public static final int ATTRIBUTE_FLAG = 2;
    public static final int BOTH = 0;
    public static final int CASEARRAY_PROP = 5;
    public static final int CATCH_SCOPE_PROP = 14;
    public static final int CONTROL_BLOCK_PROP = 18;
    public static final int DECR_FLAG = 1;
    public static final int DESCENDANTS_FLAG = 4;
    public static final int DESTRUCTURING_ARRAY_LENGTH = 21;
    public static final int DESTRUCTURING_NAMES = 22;
    public static final int DESTRUCTURING_PARAMS = 23;
    public static final int DESTRUCTURING_SHORTHAND = 26;
    public static final int DIRECTCALL_PROP = 9;
    public static final int END_DROPS_OFF = 1;
    public static final int END_RETURNS = 2;
    public static final int END_RETURNS_VALUE = 4;
    public static final int END_UNREACHED = 0;
    public static final int END_YIELDS = 8;
    public static final int EXPRESSION_CLOSURE_PROP = 25;
    public static final int FUNCTION_PROP = 1;
    public static final int GENERATOR_END_PROP = 20;
    public static final int INCRDECR_PROP = 13;
    public static final int ISNUMBER_PROP = 8;
    public static final int JSDOC_PROP = 24;
    public static final int LABEL_ID_PROP = 15;
    public static final int LAST_PROP = 27;
    public static final int LEFT = 1;
    public static final int LOCAL_BLOCK_PROP = 3;
    public static final int LOCAL_PROP = 2;
    public static final int MEMBER_TYPE_PROP = 16;
    public static final int NAME_PROP = 17;
    public static final int NON_SPECIALCALL = 0;
    private static final Node NOT_SET = new Node(-1);
    public static final int OBJECT_IDS_PROP = 12;
    public static final int PARENTHESIZED_PROP = 19;
    public static final int POST_FLAG = 2;
    public static final int PROPERTY_FLAG = 1;
    public static final int REGEXP_PROP = 4;
    public static final int RIGHT = 2;
    public static final int SKIP_INDEXES_PROP = 11;
    public static final int SPECIALCALL_EVAL = 1;
    public static final int SPECIALCALL_PROP = 10;
    public static final int SPECIALCALL_WITH = 2;
    public static final int TARGETBLOCK_PROP = 6;
    public static final int VARIABLE_PROP = 7;
    protected Node first;
    protected Node last;
    protected int lineno = -1;
    protected Node next;
    protected PropListItem propListHead;
    protected int type = -1;

    public Node(int n) {
        this.type = n;
    }

    public Node(int n, int n2) {
        this.type = n;
        this.lineno = n2;
    }

    public Node(int n, Node node) {
        this.type = n;
        this.last = node;
        this.first = node;
        node.next = null;
    }

    public Node(int n, Node node, int n2) {
        this(n, node);
        this.lineno = n2;
    }

    public Node(int n, Node node, Node node2) {
        this.type = n;
        this.first = node;
        this.last = node2;
        node.next = node2;
        node2.next = null;
    }

    public Node(int n, Node node, Node node2, int n2) {
        this(n, node, node2);
        this.lineno = n2;
    }

    public Node(int n, Node node, Node node2, Node node3) {
        this.type = n;
        this.first = node;
        this.last = node3;
        node.next = node2;
        node2.next = node3;
        node3.next = null;
    }

    public Node(int n, Node node, Node node2, Node node3, int n2) {
        this(n, node, node2, node3);
        this.lineno = n2;
    }

    private static void appendPrintId(Node node, ObjToIntMap objToIntMap, StringBuilder stringBuilder) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int endCheck() {
        int n = this.type;
        if (n != 4) {
            if (n == 50) return 0;
            if (n == 73) return 8;
            if (n != 130 && n != 142) {
                if (n == 121) return this.endCheckBreak();
                if (n == 122) return 0;
                switch (n) {
                    default: {
                        return 1;
                    }
                    case 134: {
                        Node node = this.first;
                        if (node == null) return 1;
                        return node.endCheck();
                    }
                    case 133: {
                        return this.endCheckLoop();
                    }
                    case 132: 
                }
                Node node = this.next;
                if (node == null) return 1;
                return node.endCheck();
            }
            Node node = this.first;
            if (node == null) {
                return 1;
            }
            n = node.type;
            if (n == 7) return node.endCheckIf();
            if (n == 82) return node.endCheckTry();
            if (n == 115) return node.endCheckSwitch();
            if (n == 131) return node.endCheckLabel();
            return this.endCheckBlock();
        }
        if (this.first == null) return 2;
        return 4;
    }

    private int endCheckBlock() {
        Node node = this.first;
        int n = 1;
        while (n & true && node != null) {
            n = n & 0xFFFFFFFE | node.endCheck();
            node = node.next;
        }
        return n;
    }

    private int endCheckBreak() {
        ((Jump)this).getJumpStatement().putIntProp(18, 1);
        return 0;
    }

    private int endCheckIf() {
        Node node = this.next;
        Node node2 = ((Jump)this).target;
        int n = node.endCheck();
        n = node2 != null ? (n |= node2.endCheck()) : (n |= 1);
        return n;
    }

    private int endCheckLabel() {
        return this.next.endCheck() | this.getIntProp(18, 0);
    }

    private int endCheckLoop() {
        int n;
        Node node;
        Node node2 = this.first;
        while ((node = node2.next) != this.last) {
            node2 = node;
        }
        if (node2.type != 6) {
            return 1;
        }
        int n2 = n = ((Jump)node2).target.next.endCheck();
        if (node2.first.type == 45) {
            n2 = n & 0xFFFFFFFE;
        }
        return this.getIntProp(18, 0) | n2;
    }

    private int endCheckSwitch() {
        return 0;
    }

    private int endCheckTry() {
        return 0;
    }

    private PropListItem ensureProperty(int n) {
        PropListItem propListItem;
        PropListItem propListItem2 = propListItem = this.lookupProperty(n);
        if (propListItem == null) {
            propListItem2 = new PropListItem();
            propListItem2.type = n;
            propListItem2.next = this.propListHead;
            this.propListHead = propListItem2;
        }
        return propListItem2;
    }

    private static void generatePrintIds(Node node, ObjToIntMap objToIntMap) {
    }

    private PropListItem lookupProperty(int n) {
        PropListItem propListItem = this.propListHead;
        while (propListItem != null && n != propListItem.type) {
            propListItem = propListItem.next;
        }
        return propListItem;
    }

    public static Node newNumber(double d) {
        NumberLiteral numberLiteral = new NumberLiteral();
        numberLiteral.setNumber(d);
        return numberLiteral;
    }

    public static Node newString(int n, String string2) {
        Name name = new Name();
        name.setIdentifier(string2);
        name.setType(n);
        return name;
    }

    public static Node newString(String string2) {
        return Node.newString(41, string2);
    }

    public static Node newTarget() {
        return new Node(132);
    }

    private static final String propToString(int n) {
        return null;
    }

    private void resetTargets_r() {
        int n = this.type;
        if (n == 132 || n == 73) {
            this.labelId(-1);
        }
        Node node = this.first;
        while (node != null) {
            node.resetTargets_r();
            node = node.next;
        }
    }

    private void toString(ObjToIntMap objToIntMap, StringBuilder stringBuilder) {
    }

    private static void toStringTreeHelper(ScriptNode scriptNode, Node node, ObjToIntMap objToIntMap, int n, StringBuilder stringBuilder) {
    }

    public void addChildAfter(Node node, Node node2) {
        if (node.next == null) {
            node.next = node2.next;
            node2.next = node;
            if (this.last == node2) {
                this.last = node;
            }
            return;
        }
        throw new RuntimeException("newChild had siblings in addChildAfter");
    }

    public void addChildBefore(Node node, Node node2) {
        if (node.next == null) {
            Node node3 = this.first;
            if (node3 == node2) {
                node.next = node3;
                this.first = node;
                return;
            }
            this.addChildAfter(node, this.getChildBefore(node2));
            return;
        }
        throw new RuntimeException("newChild had siblings in addChildBefore");
    }

    public void addChildToBack(Node node) {
        node.next = null;
        Node node2 = this.last;
        if (node2 == null) {
            this.last = node;
            this.first = node;
            return;
        }
        node2.next = node;
        this.last = node;
    }

    public void addChildToFront(Node node) {
        node.next = this.first;
        this.first = node;
        if (this.last == null) {
            this.last = node;
        }
    }

    public void addChildrenToBack(Node node) {
        Node node2 = this.last;
        if (node2 != null) {
            node2.next = node;
        }
        this.last = node.getLastSibling();
        if (this.first == null) {
            this.first = node;
        }
    }

    public void addChildrenToFront(Node node) {
        Node node2 = node.getLastSibling();
        node2.next = this.first;
        this.first = node;
        if (this.last == null) {
            this.last = node2;
        }
    }

    public Node getChildBefore(Node node) {
        Node node2;
        Node node3 = node2 = this.first;
        if (node == node2) {
            return null;
        }
        while ((node2 = node3.next) != node) {
            if (node2 != null) {
                node3 = node2;
                continue;
            }
            throw new RuntimeException("node is not a child");
        }
        return node3;
    }

    public final double getDouble() {
        return ((NumberLiteral)this).getNumber();
    }

    public int getExistingIntProp(int n) {
        PropListItem propListItem = this.lookupProperty(n);
        if (propListItem == null) {
            Kit.codeBug();
        }
        return propListItem.intValue;
    }

    public Node getFirstChild() {
        return this.first;
    }

    public int getIntProp(int n, int n2) {
        PropListItem propListItem = this.lookupProperty(n);
        if (propListItem == null) {
            return n2;
        }
        return propListItem.intValue;
    }

    public String getJsDoc() {
        Comment comment = this.getJsDocNode();
        if (comment != null) {
            return comment.getValue();
        }
        return null;
    }

    public Comment getJsDocNode() {
        return (Comment)this.getProp(24);
    }

    public Node getLastChild() {
        return this.last;
    }

    public Node getLastSibling() {
        Node node;
        Node node2 = this;
        while ((node = node2.next) != null) {
            node2 = node;
        }
        return node2;
    }

    public int getLineno() {
        return this.lineno;
    }

    public Node getNext() {
        return this.next;
    }

    public Object getProp(int n) {
        PropListItem propListItem = this.lookupProperty(n);
        if (propListItem == null) {
            return null;
        }
        return propListItem.objectValue;
    }

    public Scope getScope() {
        return ((Name)this).getScope();
    }

    public final String getString() {
        return ((Name)this).getIdentifier();
    }

    public int getType() {
        return this.type;
    }

    public boolean hasChildren() {
        boolean bl = this.first != null;
        return bl;
    }

    public boolean hasConsistentReturnUsage() {
        int n = this.endCheck();
        boolean bl = (n & 4) == 0 || (n & 0xB) == 0;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasSideEffects() {
        int n = this.type;
        boolean bl = true;
        boolean bl2 = true;
        if (n == 30) return true;
        if (n == 31) return true;
        if (n == 37) return true;
        if (n == 38) return true;
        if (n == 50) return true;
        if (n == 51) return true;
        if (n == 56) return true;
        if (n == 57) return true;
        if (n == 82) return true;
        if (n == 83) return true;
        switch (n) {
            default: {
                switch (n) {
                    default: {
                        switch (n) {
                            default: {
                                switch (n) {
                                    default: {
                                        switch (n) {
                                            default: {
                                                return false;
                                            }
                                            case 113: 
                                            case 114: 
                                            case 115: 
                                        }
                                        return true;
                                    }
                                    case 105: 
                                    case 106: {
                                        if (this.first == null || this.last == null) {
                                            Kit.codeBug();
                                        }
                                        bl = bl2;
                                        if (this.first.hasSideEffects()) return bl;
                                        if (!this.last.hasSideEffects()) return false;
                                        return bl2;
                                    }
                                    case 107: 
                                    case 108: 
                                }
                                return true;
                            }
                            case 69: 
                            case 70: 
                            case 71: 
                        }
                        return true;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                }
                return true;
            }
            case 103: {
                Node node = this.first;
                if (node == null || (node = node.next) == null || node.next == null) {
                    Kit.codeBug();
                }
                if (!this.first.next.hasSideEffects()) return false;
                if (!this.first.next.next.hasSideEffects()) return false;
                return bl;
            }
            case 90: 
            case 134: {
                Node node = this.last;
                if (node == null) return true;
                return node.hasSideEffects();
            }
            case -1: 
            case 35: 
            case 65: 
            case 73: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 154: 
            case 155: 
            case 159: 
            case 160: 
        }
        return true;
    }

    @Override
    public Iterator<Node> iterator() {
        return new NodeIterator();
    }

    public final int labelId() {
        int n = this.type;
        if (n != 132 && n != 73) {
            Kit.codeBug();
        }
        return this.getIntProp(15, -1);
    }

    public void labelId(int n) {
        int n2 = this.type;
        if (n2 != 132 && n2 != 73) {
            Kit.codeBug();
        }
        this.putIntProp(15, n);
    }

    public void putIntProp(int n, int n2) {
        this.ensureProperty((int)n).intValue = n2;
    }

    public void putProp(int n, Object object) {
        if (object == null) {
            this.removeProp(n);
        } else {
            this.ensureProperty((int)n).objectValue = object;
        }
    }

    public void removeChild(Node node) {
        Node node2 = this.getChildBefore(node);
        if (node2 == null) {
            this.first = this.first.next;
        } else {
            node2.next = node.next;
        }
        if (node == this.last) {
            this.last = node2;
        }
        node.next = null;
    }

    public void removeChildren() {
        this.last = null;
        this.first = null;
    }

    public void removeProp(int n) {
        PropListItem propListItem = this.propListHead;
        if (propListItem != null) {
            PropListItem propListItem2 = null;
            while (propListItem.type != n) {
                PropListItem propListItem3 = propListItem.next;
                if (propListItem3 == null) {
                    return;
                }
                propListItem2 = propListItem;
                propListItem = propListItem3;
            }
            if (propListItem2 == null) {
                this.propListHead = propListItem.next;
            } else {
                propListItem2.next = propListItem.next;
            }
        }
    }

    public void replaceChild(Node node, Node node2) {
        node2.next = node.next;
        if (node == this.first) {
            this.first = node2;
        } else {
            this.getChildBefore((Node)node).next = node2;
        }
        if (node == this.last) {
            this.last = node2;
        }
        node.next = null;
    }

    public void replaceChildAfter(Node node, Node node2) {
        Node node3 = node.next;
        node2.next = node3.next;
        node.next = node2;
        if (node3 == this.last) {
            this.last = node2;
        }
        node3.next = null;
    }

    public void resetTargets() {
        if (this.type == 126) {
            this.resetTargets_r();
        } else {
            Kit.codeBug();
        }
    }

    public final void setDouble(double d) {
        ((NumberLiteral)this).setNumber(d);
    }

    public void setJsDocNode(Comment comment) {
        this.putProp(24, comment);
    }

    public void setLineno(int n) {
        this.lineno = n;
    }

    public void setScope(Scope scope) {
        if (scope == null) {
            Kit.codeBug();
        }
        if (this instanceof Name) {
            ((Name)this).setScope(scope);
            return;
        }
        throw Kit.codeBug();
    }

    public final void setString(String string2) {
        if (string2 == null) {
            Kit.codeBug();
        }
        ((Name)this).setIdentifier(string2);
    }

    public Node setType(int n) {
        this.type = n;
        return this;
    }

    public String toString() {
        return String.valueOf(this.type);
    }

    public String toStringTree(ScriptNode scriptNode) {
        return null;
    }

    public class NodeIterator
    implements Iterator<Node> {
        private Node cursor;
        private Node prev = Node.access$000();
        private Node prev2;
        private boolean removed = false;

        public NodeIterator() {
            this.cursor = Node.this.first;
        }

        @Override
        public boolean hasNext() {
            boolean bl = this.cursor != null;
            return bl;
        }

        @Override
        public Node next() {
            Node node = this.cursor;
            if (node != null) {
                this.removed = false;
                this.prev2 = this.prev;
                this.prev = node;
                this.cursor = node.next;
                return this.prev;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.prev != NOT_SET) {
                if (!this.removed) {
                    if (this.prev == Node.this.first) {
                        Node.this.first = this.prev.next;
                    } else if (this.prev == Node.this.last) {
                        this.prev2.next = null;
                        Node.this.last = this.prev2;
                    } else {
                        this.prev2.next = this.cursor;
                    }
                    return;
                }
                throw new IllegalStateException("remove() already called for current element");
            }
            throw new IllegalStateException("next() has not been called");
        }
    }

    private static class PropListItem {
        int intValue;
        PropListItem next;
        Object objectValue;
        int type;

        private PropListItem() {
        }
    }
}

