/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ObjArray
implements Serializable {
    private static final int FIELDS_STORE_SIZE = 5;
    static final long serialVersionUID = 4174889037736658296L;
    private transient Object[] data;
    private transient Object f0;
    private transient Object f1;
    private transient Object f2;
    private transient Object f3;
    private transient Object f4;
    private boolean sealed;
    private int size;

    private void ensureCapacity(int n) {
        int n2 = n - 5;
        if (n2 > 0) {
            Object[] objectArray = this.data;
            n = 10;
            if (objectArray == null) {
                if (10 >= n2) {
                    n2 = 10;
                }
                this.data = new Object[n2];
            } else {
                int n3 = objectArray.length;
                if (n3 < n2) {
                    if (n3 > 5) {
                        n = n3 * 2;
                    }
                    if (n < n2) {
                        n = n2;
                    }
                    Object[] objectArray2 = new Object[n];
                    n = this.size;
                    if (n > 5) {
                        System.arraycopy(objectArray, 0, objectArray2, 0, n - 5);
                    }
                    this.data = objectArray2;
                }
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    private Object getImpl(int n) {
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    if (n != 3) {
                        if (n != 4) {
                            return this.data[n - 5];
                        }
                        return this.f4;
                    }
                    return this.f3;
                }
                return this.f2;
            }
            return this.f1;
        }
        return this.f0;
    }

    private static RuntimeException onEmptyStackTopRead() {
        throw new RuntimeException("Empty stack");
    }

    private static RuntimeException onInvalidIndex(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n);
        stringBuilder.append(" \u2209 [0, ");
        stringBuilder.append(n2);
        stringBuilder.append(')');
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    private static RuntimeException onSeledMutation() {
        throw new IllegalStateException("Attempt to modify sealed array");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = this.size;
        if (n > 5) {
            this.data = new Object[n - 5];
        }
        for (int i = 0; i != n; ++i) {
            this.setImpl(i, objectInputStream.readObject());
        }
    }

    private void setImpl(int n, Object object) {
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    if (n != 3) {
                        if (n != 4) {
                            this.data[n - 5] = object;
                        } else {
                            this.f4 = object;
                        }
                    } else {
                        this.f3 = object;
                    }
                } else {
                    this.f2 = object;
                }
            } else {
                this.f1 = object;
            }
        } else {
            this.f0 = object;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.size;
        for (int i = 0; i != n; ++i) {
            objectOutputStream.writeObject(this.getImpl(i));
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void add(int var1_1, Object var2_2) {
        block11: {
            block12: {
                block13: {
                    var3_3 = this.size;
                    if (var1_1 < 0 || var1_1 > var3_3) break block11;
                    if (this.sealed) break block12;
                    if (var1_1 == 0) break block13;
                    var4_4 = var2_2 /* !! */ ;
                    if (var1_1 == 1) ** GOTO lbl20
                    var4_4 = var2_2 /* !! */ ;
                    if (var1_1 == 2) ** GOTO lbl26
                    var4_4 = var2_2 /* !! */ ;
                    if (var1_1 == 3) ** GOTO lbl32
                    var4_4 = var2_2 /* !! */ ;
                    if (var1_1 == 4) ** GOTO lbl38
                    ** GOTO lbl44
                }
                if (var3_3 == 0) {
                    this.f0 = var2_2 /* !! */ ;
                } else {
                    var4_4 = this.f0;
                    this.f0 = var2_2 /* !! */ ;
lbl20:
                    // 2 sources

                    if (var3_3 == 1) {
                        this.f1 = var4_4;
                    } else {
                        var2_2 /* !! */  = this.f1;
                        this.f1 = var4_4;
                        var4_4 = var2_2 /* !! */ ;
lbl26:
                        // 2 sources

                        if (var3_3 == 2) {
                            this.f2 = var4_4;
                        } else {
                            var2_2 /* !! */  = this.f2;
                            this.f2 = var4_4;
                            var4_4 = var2_2 /* !! */ ;
lbl32:
                            // 2 sources

                            if (var3_3 == 3) {
                                this.f3 = var4_4;
                            } else {
                                var2_2 /* !! */  = this.f3;
                                this.f3 = var4_4;
                                var4_4 = var2_2 /* !! */ ;
lbl38:
                                // 2 sources

                                if (var3_3 == 4) {
                                    this.f4 = var4_4;
                                } else {
                                    var2_2 /* !! */  = this.f4;
                                    this.f4 = var4_4;
                                    var1_1 = 5;
lbl44:
                                    // 2 sources

                                    this.ensureCapacity(var3_3 + 1);
                                    if (var1_1 != var3_3) {
                                        var4_4 = this.data;
                                        var5_5 = var1_1 - 5;
                                        System.arraycopy(var4_4, var5_5, var4_4, var5_5 + 1, var3_3 - var1_1);
                                    }
                                    this.data[var1_1 - 5] = var2_2 /* !! */ ;
                                }
                            }
                        }
                    }
                }
                this.size = var3_3 + 1;
                return;
            }
            throw ObjArray.onSeledMutation();
        }
        throw ObjArray.onInvalidIndex(var1_1, var3_3 + 1);
    }

    public final void add(Object object) {
        if (!this.sealed) {
            int n = this.size;
            if (n >= 5) {
                this.ensureCapacity(n + 1);
            }
            this.size = n + 1;
            this.setImpl(n, object);
            return;
        }
        throw ObjArray.onSeledMutation();
    }

    public final void clear() {
        if (!this.sealed) {
            int n = this.size;
            for (int i = 0; i != n; ++i) {
                this.setImpl(i, null);
            }
            this.size = 0;
            return;
        }
        throw ObjArray.onSeledMutation();
    }

    public final Object get(int n) {
        if (n >= 0 && n < this.size) {
            return this.getImpl(n);
        }
        throw ObjArray.onInvalidIndex(n, this.size);
    }

    public int indexOf(Object object) {
        int n = this.size;
        for (int i = 0; i != n; ++i) {
            Object object2 = this.getImpl(i);
            if (!(object2 == object || object2 != null && object2.equals(object))) {
                continue;
            }
            return i;
        }
        return -1;
    }

    public final boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    public final boolean isSealed() {
        return this.sealed;
    }

    public int lastIndexOf(Object object) {
        int n = this.size;
        while (n != 0) {
            int n2 = n - 1;
            Object object2 = this.getImpl(n2);
            if (object2 != object) {
                n = n2;
                if (object2 == null) continue;
                n = n2;
                if (!object2.equals(object)) continue;
            }
            return n2;
        }
        return -1;
    }

    public final Object peek() {
        int n = this.size;
        if (n != 0) {
            return this.getImpl(n - 1);
        }
        throw ObjArray.onEmptyStackTopRead();
    }

    public final Object pop() {
        if (!this.sealed) {
            int n = this.size - 1;
            if (n != -1) {
                Object object;
                if (n != 0) {
                    if (n != 1) {
                        if (n != 2) {
                            if (n != 3) {
                                if (n != 4) {
                                    Object[] objectArray = this.data;
                                    int n2 = n - 5;
                                    object = objectArray[n2];
                                    objectArray[n2] = null;
                                } else {
                                    object = this.f4;
                                    this.f4 = null;
                                }
                            } else {
                                object = this.f3;
                                this.f3 = null;
                            }
                        } else {
                            object = this.f2;
                            this.f2 = null;
                        }
                    } else {
                        object = this.f1;
                        this.f1 = null;
                    }
                } else {
                    object = this.f0;
                    this.f0 = null;
                }
                this.size = n;
                return object;
            }
            throw ObjArray.onEmptyStackTopRead();
        }
        throw ObjArray.onSeledMutation();
    }

    public final void push(Object object) {
        this.add(object);
    }

    /*
     * Unable to fully structure code
     */
    public final void remove(int var1_1) {
        block11: {
            block12: {
                block13: {
                    var2_2 = this.size;
                    if (var1_1 < 0 || var1_1 >= var2_2) break block11;
                    if (this.sealed) break block12;
                    --var2_2;
                    if (var1_1 == 0) break block13;
                    if (var1_1 == 1) ** GOTO lbl16
                    if (var1_1 == 2) ** GOTO lbl20
                    if (var1_1 == 3) ** GOTO lbl24
                    if (var1_1 == 4) ** GOTO lbl28
                    ** GOTO lbl33
                }
                if (var2_2 == 0) {
                    this.f0 = null;
                } else {
                    this.f0 = this.f1;
lbl16:
                    // 2 sources

                    if (var2_2 == 1) {
                        this.f1 = null;
                    } else {
                        this.f1 = this.f2;
lbl20:
                        // 2 sources

                        if (var2_2 == 2) {
                            this.f2 = null;
                        } else {
                            this.f2 = this.f3;
lbl24:
                            // 2 sources

                            if (var2_2 == 3) {
                                this.f3 = null;
                            } else {
                                this.f3 = this.f4;
lbl28:
                                // 2 sources

                                if (var2_2 == 4) {
                                    this.f4 = null;
                                } else {
                                    this.f4 = this.data[0];
                                    var1_1 = 5;
lbl33:
                                    // 2 sources

                                    if (var1_1 != var2_2) {
                                        var3_3 = this.data;
                                        var4_4 = var1_1 - 5;
                                        System.arraycopy(var3_3, var4_4 + 1, var3_3, var4_4, var2_2 - var1_1);
                                    }
                                    this.data[var2_2 - 5] = null;
                                }
                            }
                        }
                    }
                }
                this.size = var2_2;
                return;
            }
            throw ObjArray.onSeledMutation();
        }
        throw ObjArray.onInvalidIndex(var1_1, var2_2);
    }

    public final void seal() {
        this.sealed = true;
    }

    public final void set(int n, Object object) {
        if (n >= 0 && n < this.size) {
            if (!this.sealed) {
                this.setImpl(n, object);
                return;
            }
            throw ObjArray.onSeledMutation();
        }
        throw ObjArray.onInvalidIndex(n, this.size);
    }

    public final void setSize(int n) {
        if (n >= 0) {
            if (!this.sealed) {
                int n2 = this.size;
                if (n < n2) {
                    for (int i = n; i != n2; ++i) {
                        this.setImpl(i, null);
                    }
                } else if (n > n2 && n > 5) {
                    this.ensureCapacity(n);
                }
                this.size = n;
                return;
            }
            throw ObjArray.onSeledMutation();
        }
        throw new IllegalArgumentException();
    }

    public final int size() {
        return this.size;
    }

    public final void toArray(Object[] objectArray) {
        this.toArray(objectArray, 0);
    }

    public final void toArray(Object[] objectArray, int n) {
        int n2 = this.size;
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    if (n2 != 3) {
                        if (n2 != 4) {
                            if (n2 != 5) {
                                System.arraycopy(this.data, 0, objectArray, n + 5, n2 - 5);
                            }
                            objectArray[n + 4] = this.f4;
                        }
                        objectArray[n + 3] = this.f3;
                    }
                    objectArray[n + 2] = this.f2;
                }
                objectArray[n + 1] = this.f1;
            }
            objectArray[n + 0] = this.f0;
        }
    }

    public final Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        this.toArray(objectArray, 0);
        return objectArray;
    }
}

