/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.UniqueTag;

public class ObjToIntMap
implements Serializable {
    private static final int A = -1640531527;
    private static final Object DELETED = new Object();
    private static final boolean check = false;
    static final long serialVersionUID = -1542220580748809402L;
    private int keyCount;
    private transient Object[] keys;
    private transient int occupiedCount;
    private int power;
    private transient int[] values;

    public ObjToIntMap() {
        this(4);
    }

    public ObjToIntMap(int n) {
        if (n < 0) {
            Kit.codeBug();
        }
        int n2 = n * 4 / 3;
        n = 2;
        while (1 << n < n2) {
            ++n;
        }
        this.power = n;
    }

    private int ensureIndex(Object object) {
        int n;
        block17: {
            int n2;
            block16: {
                int n3;
                int n4;
                block15: {
                    n = object.hashCode();
                    Object object2 = this.keys;
                    int n5 = -1;
                    if (object2 != null) {
                        int n6 = -1640531527 * n;
                        int n7 = this.power;
                        n4 = n6 >>> 32 - n7;
                        object2 = object2[n4];
                        n2 = n5;
                        n3 = n4;
                        if (object2 != null) {
                            n7 = 1 << n7;
                            n3 = n4;
                            if (object2 != object) {
                                if (this.values[n7 + n4] == n && object2.equals(object)) {
                                    n3 = n4;
                                } else {
                                    n2 = n5;
                                    if (object2 == DELETED) {
                                        n2 = n4;
                                    }
                                    n5 = n7 - 1;
                                    n6 = ObjToIntMap.tableLookupStep(n6, n5, this.power);
                                    n3 = n4;
                                    while (true) {
                                        if ((object2 = this.keys[n4 = n3 + n6 & n5]) == null) {
                                            n3 = n4;
                                            break block15;
                                        }
                                        n3 = n4;
                                        if (object2 == object) break;
                                        if (this.values[n7 + n4] == n && object2.equals(object)) {
                                            n3 = n4;
                                            break;
                                        }
                                        n3 = n4;
                                        if (object2 != DELETED) continue;
                                        n3 = n4;
                                        if (n2 >= 0) continue;
                                        n2 = n4;
                                        n3 = n4;
                                    }
                                }
                            }
                            return n3;
                        }
                    } else {
                        n3 = -1;
                        n2 = n5;
                    }
                }
                if (n2 >= 0) break block16;
                if (this.keys == null || (n4 = this.occupiedCount) * 4 >= (1 << this.power) * 3) break block17;
                this.occupiedCount = n4 + 1;
                n2 = n3;
            }
            this.keys[n2] = object;
            this.values[(1 << this.power) + n2] = n;
            ++this.keyCount;
            return n2;
        }
        this.rehashTable();
        return this.insertNewKey(object, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int findIndex(Object object) {
        int n;
        if (this.keys == null) return -1;
        int n2 = object.hashCode();
        int n3 = -1640531527 * n2;
        int n4 = n3 >>> 32 - (n = this.power);
        Object object2 = this.keys[n4];
        if (object2 == null) return -1;
        int n5 = 1 << n;
        n = n4;
        if (object2 == object) return n;
        if (this.values[n5 + n4] == n2 && object2.equals(object)) {
            return n4;
        }
        int n6 = n5 - 1;
        n3 = ObjToIntMap.tableLookupStep(n3, n6, this.power);
        n = n4;
        while ((object2 = this.keys[n4 = n + n3 & n6]) != null) {
            n = n4;
            if (object2 == object) return n;
            n = n4;
            if (this.values[n5 + n4] != n2) continue;
            n = n4;
            if (!object2.equals(object)) continue;
            return n4;
        }
        return -1;
    }

    private int insertNewKey(Object object, int n) {
        int n2 = -1640531527 * n;
        int n3 = this.power;
        int n4 = n2 >>> 32 - n3;
        int n5 = 1 << n3;
        int n6 = n4;
        if (this.keys[n4] != null) {
            int n7 = n5 - 1;
            n2 = ObjToIntMap.tableLookupStep(n2, n7, n3);
            do {
                n4 = n6 = n4 + n2 & n7;
            } while (this.keys[n6] != null);
        }
        this.keys[n6] = object;
        this.values[n5 + n6] = n;
        ++this.occupiedCount;
        ++this.keyCount;
        return n6;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = this.keyCount;
        if (n != 0) {
            this.keyCount = 0;
            int n2 = 1 << this.power;
            this.keys = new Object[n2];
            this.values = new int[n2 * 2];
            for (int i = 0; i != n; ++i) {
                Object object = objectInputStream.readObject();
                n2 = this.insertNewKey(object, object.hashCode());
                this.values[n2] = objectInputStream.readInt();
            }
        }
    }

    private void rehashTable() {
        Object[] objectArray = this.keys;
        if (objectArray == null) {
            int n = 1 << this.power;
            this.keys = new Object[n];
            this.values = new int[n * 2];
        } else {
            int n = this.keyCount;
            if (n * 2 >= this.occupiedCount) {
                ++this.power;
            }
            int n2 = 1 << this.power;
            int[] nArray = this.values;
            int n3 = objectArray.length;
            this.keys = new Object[n2];
            this.values = new int[n2 * 2];
            n2 = 0;
            this.keyCount = 0;
            this.occupiedCount = 0;
            while (n != 0) {
                Object object = objectArray[n2];
                int n4 = n;
                if (object != null) {
                    n4 = n;
                    if (object != DELETED) {
                        n4 = this.insertNewKey(object, nArray[n3 + n2]);
                        this.values[n4] = nArray[n2];
                        n4 = n - 1;
                    }
                }
                ++n2;
                n = n4;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int tableLookupStep(int n, int n2, int n3) {
        if ((n3 = 32 - n3 * 2) >= 0) {
            n >>>= n3;
            return n & n2 | 1;
        }
        n2 >>>= -n3;
        return n & n2 | 1;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.keyCount;
        int n2 = 0;
        while (n != 0) {
            Object object = this.keys[n2];
            int n3 = n;
            if (object != null) {
                n3 = n;
                if (object != DELETED) {
                    n3 = n - 1;
                    objectOutputStream.writeObject(object);
                    objectOutputStream.writeInt(this.values[n2]);
                }
            }
            ++n2;
            n = n3;
        }
    }

    public void clear() {
        int n = this.keys.length;
        while (n != 0) {
            Object[] objectArray = this.keys;
            objectArray[--n] = null;
        }
        this.keyCount = 0;
        this.occupiedCount = 0;
    }

    public int get(Object object, int n) {
        int n2;
        Object object2 = object;
        if (object == null) {
            object2 = UniqueTag.NULL_VALUE;
        }
        if ((n2 = this.findIndex(object2)) >= 0) {
            return this.values[n2];
        }
        return n;
    }

    public int getExisting(Object object) {
        int n;
        Object object2 = object;
        if (object == null) {
            object2 = UniqueTag.NULL_VALUE;
        }
        if ((n = this.findIndex(object2)) >= 0) {
            return this.values[n];
        }
        Kit.codeBug();
        return 0;
    }

    public void getKeys(Object[] objectArray, int n) {
        int n2 = this.keyCount;
        int n3 = 0;
        int n4 = n;
        n = n3;
        while (n2 != 0) {
            Object object = this.keys[n];
            int n5 = n2;
            n3 = n4;
            if (object != null) {
                n5 = n2;
                n3 = n4;
                if (object != DELETED) {
                    Object object2 = object;
                    if (object == UniqueTag.NULL_VALUE) {
                        object2 = null;
                    }
                    objectArray[n4] = object2;
                    n3 = n4 + 1;
                    n5 = n2 - 1;
                }
            }
            ++n;
            n2 = n5;
            n4 = n3;
        }
    }

    public Object[] getKeys() {
        Object[] objectArray = new Object[this.keyCount];
        this.getKeys(objectArray, 0);
        return objectArray;
    }

    public boolean has(Object object) {
        Object object2 = object;
        if (object == null) {
            object2 = UniqueTag.NULL_VALUE;
        }
        boolean bl = this.findIndex(object2) >= 0;
        return bl;
    }

    final void initIterator(Iterator iterator2) {
        iterator2.init(this.keys, this.values, this.keyCount);
    }

    public Object intern(Object object) {
        boolean bl;
        if (object == null) {
            object = UniqueTag.NULL_VALUE;
            bl = true;
        } else {
            bl = false;
        }
        int n = this.ensureIndex(object);
        this.values[n] = 0;
        object = bl ? null : this.keys[n];
        return object;
    }

    public boolean isEmpty() {
        boolean bl = this.keyCount == 0;
        return bl;
    }

    public Iterator newIterator() {
        return new Iterator(this);
    }

    public void put(Object object, int n) {
        Object object2 = object;
        if (object == null) {
            object2 = UniqueTag.NULL_VALUE;
        }
        int n2 = this.ensureIndex(object2);
        this.values[n2] = n;
    }

    public void remove(Object object) {
        int n;
        Object object2 = object;
        if (object == null) {
            object2 = UniqueTag.NULL_VALUE;
        }
        if ((n = this.findIndex(object2)) >= 0) {
            this.keys[n] = DELETED;
            --this.keyCount;
        }
    }

    public int size() {
        return this.keyCount;
    }

    public static class Iterator {
        private int cursor;
        private Object[] keys;
        ObjToIntMap master;
        private int remaining;
        private int[] values;

        Iterator(ObjToIntMap objToIntMap) {
            this.master = objToIntMap;
        }

        public boolean done() {
            boolean bl = this.remaining < 0;
            return bl;
        }

        public Object getKey() {
            Object object;
            Object object2 = object = this.keys[this.cursor];
            if (object == UniqueTag.NULL_VALUE) {
                object2 = null;
            }
            return object2;
        }

        public int getValue() {
            return this.values[this.cursor];
        }

        final void init(Object[] objectArray, int[] nArray, int n) {
            this.keys = objectArray;
            this.values = nArray;
            this.cursor = -1;
            this.remaining = n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void next() {
            if (this.remaining == -1) {
                Kit.codeBug();
            }
            if (this.remaining == 0) {
                this.remaining = -1;
                this.cursor = -1;
                return;
            }
            int n = this.cursor;
            while (true) {
                this.cursor = n + 1;
                Object object = this.keys[this.cursor];
                if (object != null && object != DELETED) {
                    --this.remaining;
                    return;
                }
                n = this.cursor;
            }
        }

        public void setValue(int n) {
            this.values[this.cursor] = n;
        }

        public void start() {
            this.master.initIterator(this);
            this.next();
        }
    }
}

