/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Token;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.ast.ArrayComprehension;
import org.mozilla.javascript.ast.ArrayComprehensionLoop;
import org.mozilla.javascript.ast.ArrayLiteral;
import org.mozilla.javascript.ast.Assignment;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.Block;
import org.mozilla.javascript.ast.BreakStatement;
import org.mozilla.javascript.ast.CatchClause;
import org.mozilla.javascript.ast.Comment;
import org.mozilla.javascript.ast.ConditionalExpression;
import org.mozilla.javascript.ast.ContinueStatement;
import org.mozilla.javascript.ast.DestructuringForm;
import org.mozilla.javascript.ast.DoLoop;
import org.mozilla.javascript.ast.ElementGet;
import org.mozilla.javascript.ast.EmptyExpression;
import org.mozilla.javascript.ast.EmptyStatement;
import org.mozilla.javascript.ast.ErrorNode;
import org.mozilla.javascript.ast.ExpressionStatement;
import org.mozilla.javascript.ast.ForInLoop;
import org.mozilla.javascript.ast.ForLoop;
import org.mozilla.javascript.ast.FunctionCall;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.GeneratorExpression;
import org.mozilla.javascript.ast.GeneratorExpressionLoop;
import org.mozilla.javascript.ast.IdeErrorReporter;
import org.mozilla.javascript.ast.IfStatement;
import org.mozilla.javascript.ast.InfixExpression;
import org.mozilla.javascript.ast.Jump;
import org.mozilla.javascript.ast.KeywordLiteral;
import org.mozilla.javascript.ast.Label;
import org.mozilla.javascript.ast.LabeledStatement;
import org.mozilla.javascript.ast.LetNode;
import org.mozilla.javascript.ast.Loop;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NewExpression;
import org.mozilla.javascript.ast.NumberLiteral;
import org.mozilla.javascript.ast.ObjectLiteral;
import org.mozilla.javascript.ast.ObjectProperty;
import org.mozilla.javascript.ast.ParenthesizedExpression;
import org.mozilla.javascript.ast.PropertyGet;
import org.mozilla.javascript.ast.RegExpLiteral;
import org.mozilla.javascript.ast.ReturnStatement;
import org.mozilla.javascript.ast.Scope;
import org.mozilla.javascript.ast.ScriptNode;
import org.mozilla.javascript.ast.StringLiteral;
import org.mozilla.javascript.ast.SwitchCase;
import org.mozilla.javascript.ast.SwitchStatement;
import org.mozilla.javascript.ast.Symbol;
import org.mozilla.javascript.ast.ThrowStatement;
import org.mozilla.javascript.ast.TryStatement;
import org.mozilla.javascript.ast.UnaryExpression;
import org.mozilla.javascript.ast.VariableDeclaration;
import org.mozilla.javascript.ast.VariableInitializer;
import org.mozilla.javascript.ast.WhileLoop;
import org.mozilla.javascript.ast.WithStatement;
import org.mozilla.javascript.ast.XmlDotQuery;
import org.mozilla.javascript.ast.XmlElemRef;
import org.mozilla.javascript.ast.XmlExpression;
import org.mozilla.javascript.ast.XmlFragment;
import org.mozilla.javascript.ast.XmlLiteral;
import org.mozilla.javascript.ast.XmlMemberGet;
import org.mozilla.javascript.ast.XmlPropRef;
import org.mozilla.javascript.ast.XmlRef;
import org.mozilla.javascript.ast.XmlString;
import org.mozilla.javascript.ast.Yield;

public class Parser {
    public static final int ARGC_LIMIT = 65536;
    static final int CLEAR_TI_MASK = 65535;
    private static final int GET_ENTRY = 2;
    private static final int METHOD_ENTRY = 8;
    private static final int PROP_ENTRY = 1;
    private static final int SET_ENTRY = 4;
    static final int TI_AFTER_EOL = 65536;
    static final int TI_CHECK_LABEL = 131072;
    boolean calledByCompileFunction;
    CompilerEnvirons compilerEnv;
    private int currentFlaggedToken = 0;
    private Comment currentJsDocComment;
    private LabeledStatement currentLabel;
    Scope currentScope;
    ScriptNode currentScriptOrFn;
    private int currentToken;
    private boolean defaultUseStrictDirective;
    private int endFlags;
    private IdeErrorReporter errorCollector;
    private ErrorReporter errorReporter;
    private boolean inDestructuringAssignment;
    private boolean inForInit;
    protected boolean inUseStrictDirective;
    private Map<String, LabeledStatement> labelSet;
    private List<Jump> loopAndSwitchSet;
    private List<Loop> loopSet;
    protected int nestingOfFunction;
    private boolean parseFinished;
    private int prevNameTokenLineno;
    private int prevNameTokenStart;
    private String prevNameTokenString = "";
    private List<Comment> scannedComments;
    private char[] sourceChars;
    private String sourceURI;
    private int syntaxErrorCount;
    private TokenStream ts;

    public Parser() {
        this(new CompilerEnvirons());
    }

    public Parser(CompilerEnvirons compilerEnvirons) {
        this(compilerEnvirons, compilerEnvirons.getErrorReporter());
    }

    public Parser(CompilerEnvirons compilerEnvirons, ErrorReporter errorReporter) {
        this.compilerEnv = compilerEnvirons;
        this.errorReporter = errorReporter;
        if (errorReporter instanceof IdeErrorReporter) {
            this.errorCollector = (IdeErrorReporter)errorReporter;
        }
    }

    static /* synthetic */ Map access$202(Parser parser, Map map) {
        parser.labelSet = map;
        return map;
    }

    static /* synthetic */ List access$302(Parser parser, List list) {
        parser.loopSet = list;
        return list;
    }

    static /* synthetic */ List access$402(Parser parser, List list) {
        parser.loopAndSwitchSet = list;
        return list;
    }

    static /* synthetic */ int access$502(Parser parser, int n) {
        parser.endFlags = n;
        return n;
    }

    static /* synthetic */ boolean access$602(Parser parser, boolean bl) {
        parser.inForInit = bl;
        return bl;
    }

    private void addError(String string2, String object, int n, int n2, int n3, String string3, int n4) {
        ++this.syntaxErrorCount;
        string2 = this.lookupMessage(string2, (String)object);
        object = this.errorCollector;
        if (object != null) {
            object.error(string2, this.sourceURI, n, n2);
        } else {
            this.errorReporter.error(string2, this.sourceURI, n3, string3, n4);
        }
    }

    private AstNode addExpr() throws IOException {
        AstNode astNode = this.mulExpr();
        while (true) {
            int n = this.peekToken();
            int n2 = this.ts.tokenBeg;
            if (n != 21 && n != 22) {
                return astNode;
            }
            this.consumeToken();
            astNode = new InfixExpression(n, astNode, this.mulExpr(), n2);
        }
    }

    private void addStrictWarning(String string2, String string3, int n, int n2, int n3, String string4, int n4) {
        if (this.compilerEnv.isStrictMode()) {
            this.addWarning(string2, string3, n, n2, n3, string4, n4);
        }
    }

    private void addWarning(String object, String string2, int n, int n2, int n3, String string3, int n4) {
        String string4 = this.lookupMessage((String)object, string2);
        if (this.compilerEnv.reportWarningAsError()) {
            this.addError((String)object, string2, n, n2, n3, string3, n4);
        } else {
            object = this.errorCollector;
            if (object != null) {
                object.warning(string4, this.sourceURI, n, n2);
            } else {
                this.errorReporter.warning(string4, this.sourceURI, n3, string3, n4);
            }
        }
    }

    private AstNode andExpr() throws IOException {
        AstNode astNode;
        AstNode astNode2 = astNode = this.bitOrExpr();
        if (this.matchToken(106)) {
            int n = this.ts.tokenBeg;
            astNode2 = new InfixExpression(106, astNode, this.andExpr(), n);
        }
        return astNode2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<AstNode> argumentList() throws IOException {
        if (this.matchToken(89)) {
            return null;
        }
        ArrayList<AstNode> arrayList = new ArrayList<AstNode>();
        boolean bl = this.inForInit;
        this.inForInit = false;
        try {
            boolean bl2;
            do {
                if (this.peekToken() == 73) {
                    this.reportError("msg.yield.parenthesized");
                }
                AstNode astNode = this.assignExpr();
                int n = this.peekToken();
                if (n == 120) {
                    try {
                        arrayList.add(this.generatorExpression(astNode, 0, true));
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                arrayList.add(astNode);
            } while (bl2 = this.matchToken(90));
            this.inForInit = bl;
        }
        catch (Throwable throwable) {
            this.inForInit = bl;
            throw throwable;
        }
        this.mustMatchToken(89, "msg.no.paren.arg");
        return arrayList;
    }

    private AstNode arrayComprehension(AstNode astNode, int n) throws IOException {
        ArrayList<ArrayComprehensionLoop> arrayList = new ArrayList<ArrayComprehensionLoop>();
        while (this.peekToken() == 120) {
            arrayList.add(this.arrayComprehensionLoop());
        }
        int n2 = -1;
        ConditionData conditionData = null;
        if (this.peekToken() == 113) {
            this.consumeToken();
            n2 = this.ts.tokenBeg - n;
            conditionData = this.condition();
        }
        this.mustMatchToken(85, "msg.no.bracket.arg");
        ArrayComprehension arrayComprehension = new ArrayComprehension(n, this.ts.tokenEnd - n);
        arrayComprehension.setResult(astNode);
        arrayComprehension.setLoops(arrayList);
        if (conditionData != null) {
            arrayComprehension.setIfPosition(n2);
            arrayComprehension.setFilter(conditionData.condition);
            arrayComprehension.setFilterLp(conditionData.lp - n);
            arrayComprehension.setFilterRp(conditionData.rp - n);
        }
        return arrayComprehension;
    }

    /*
     * Unable to fully structure code
     */
    private ArrayComprehensionLoop arrayComprehensionLoop() throws IOException {
        block20: {
            block19: {
                block18: {
                    block21: {
                        block17: {
                            block16: {
                                if (this.nextToken() != 120) {
                                    this.codeBug();
                                }
                                var1_1 = this.ts.tokenBeg;
                                var2_2 = new ArrayComprehensionLoop(var1_1);
                                this.pushScope(var2_2);
                                var3_3 = this.matchToken(39);
                                if (!var3_3) break block16;
                                if (this.ts.getString().equals("each")) {
                                    var4_4 = this.ts.tokenBeg - var1_1;
                                    break block17;
                                }
                                this.reportError("msg.no.paren.for");
                            }
                            var4_4 = -1;
                        }
                        var5_5 = this.mustMatchToken(88, "msg.no.paren.for") != false ? this.ts.tokenBeg - var1_1 : -1;
                        var6_6 = null;
                        var7_8 = this.peekToken();
                        if (var7_8 == 39) ** GOTO lbl33
                        if (var7_8 == 84 || var7_8 == 86) ** GOTO lbl30
                        this.reportError("msg.bad.var");
                        break block21;
lbl30:
                        // 1 sources

                        var6_6 = this.destructuringPrimaryExpr();
                        this.markDestructuring(var6_6);
                        break block21;
lbl33:
                        // 1 sources

                        this.consumeToken();
                        var6_6 = this.createNameNode();
                    }
                    var7_8 = var6_6.getType();
                    var8_9 = true;
                    if (var7_8 != 39) ** GOTO lbl41
                    this.defineSymbol(154, this.ts.getString(), true);
lbl41:
                    // 2 sources

                    if ((var7_8 = this.nextToken()) == 39) ** GOTO lbl46
                    if (var7_8 != 52) break block18;
                    var7_8 = this.ts.tokenBeg - var1_1;
                    break block19;
lbl46:
                    // 1 sources

                    if (!"of".equals(this.ts.getString())) break block18;
                    if (var4_4 == -1) ** GOTO lbl50
                    this.reportError("msg.invalid.for.each");
lbl50:
                    // 2 sources

                    var7_8 = this.ts.tokenBeg - var1_1;
                    var3_3 = true;
                }
                this.reportError("msg.in.after.for.name");
                var7_8 = -1;
            }
            var3_3 = false;
            var9_10 = this.expr();
            var10_11 = this.mustMatchToken(89, "msg.no.paren.for.ctrl") != false ? this.ts.tokenBeg - var1_1 : -1;
            var2_2.setLength(this.ts.tokenEnd - var1_1);
            var2_2.setIterator(var6_6);
            var2_2.setIteratedObject(var9_10);
            var2_2.setInPosition(var7_8);
            var2_2.setEachPosition(var4_4);
            if (var4_4 != -1) break block20;
            var8_9 = false;
        }
        try {
            var2_2.setIsForEach(var8_9);
            var2_2.setParens(var5_5, var10_11);
            var2_2.setIsForOf(var3_3);
            return var2_2;
        }
        finally {
            this.popScope();
        }
    }

    private AstNode arrayLiteral() throws IOException {
        if (this.currentToken != 84) {
            this.codeBug();
        }
        int n = this.ts.tokenBeg;
        int n2 = this.ts.tokenEnd;
        Object object = new ArrayList<AstNode>();
        ArrayLiteral arrayLiteral = new ArrayLiteral(n);
        int n3 = 1;
        int n4 = 0;
        while (true) {
            block14: {
                block13: {
                    int n5;
                    block12: {
                        int n6 = -1;
                        while ((n5 = this.peekToken()) == 90) {
                            this.consumeToken();
                            n6 = this.ts.tokenEnd;
                            if (n3 == 0) {
                                n3 = 1;
                                continue;
                            }
                            object.add(new EmptyExpression(this.ts.tokenBeg, 1));
                            ++n4;
                        }
                        if (n5 != 85) break block12;
                        this.consumeToken();
                        n2 = this.ts.tokenEnd;
                        arrayLiteral.setDestructuringLength(object.size() + n3);
                        arrayLiteral.setSkipCount(n4);
                        n3 = n2;
                        if (n6 != -1) {
                            this.warnTrailingComma(n, (List<?>)object, n6);
                            n3 = n2;
                        }
                        break block13;
                    }
                    if (n5 == 120 && n3 == 0 && object.size() == 1) {
                        return this.arrayComprehension((AstNode)object.get(0), n);
                    }
                    if (n5 != 0) break block14;
                    this.reportError("msg.no.bracket.arg");
                    n3 = n2;
                }
                object = object.iterator();
                while (object.hasNext()) {
                    arrayLiteral.addElement((AstNode)object.next());
                }
                arrayLiteral.setLength(n3 - n);
                return arrayLiteral;
            }
            if (n3 == 0) {
                this.reportError("msg.no.bracket.arg");
            }
            object.add(this.assignExpr());
            n3 = 0;
        }
    }

    private AstNode arrowFunction(AstNode node) throws IOException {
        PerFunctionVariables perFunctionVariables;
        FunctionNode functionNode;
        int n;
        block8: {
            n = this.ts.lineno;
            int n2 = node != null ? ((AstNode)node).getPosition() : -1;
            functionNode = new FunctionNode(n2);
            functionNode.setFunctionType(4);
            functionNode.setJsDocNode(this.getAndResetJsDoc());
            HashMap<String, Node> hashMap = new HashMap<String, Node>();
            HashSet<String> object2 = new HashSet<String>();
            perFunctionVariables = new PerFunctionVariables(functionNode);
            if (node instanceof ParenthesizedExpression) {
                functionNode.setParens(0, ((AstNode)node).getLength());
                node = ((ParenthesizedExpression)node).getExpression();
                if (!(node instanceof EmptyExpression)) {
                    this.arrowFunctionParams(functionNode, (AstNode)node, hashMap, object2);
                }
            } else {
                this.arrowFunctionParams(functionNode, (AstNode)node, hashMap, object2);
            }
            if (!hashMap.isEmpty()) {
                node = new Node(90);
                for (Map.Entry entry : hashMap.entrySet()) {
                    node.addChildToBack(this.createDestructuringAssignment(123, (Node)entry.getValue(), this.createName((String)entry.getKey())));
                }
                functionNode.putProp(23, node);
            }
            functionNode.setBody(this.parseFunctionBody(4, functionNode));
            functionNode.setEncodedSourceBounds(n2, this.ts.tokenEnd);
            functionNode.setLength(this.ts.tokenEnd - n2);
            if (!functionNode.isGenerator()) break block8;
            this.reportError("msg.arrowfunction.generator");
            return this.makeErrorNode();
        }
        functionNode.setSourceName(this.sourceURI);
        functionNode.setBaseLineno(n);
        functionNode.setEndLineno(this.ts.lineno);
        return functionNode;
        finally {
            perFunctionVariables.restore();
        }
    }

    private void arrowFunctionParams(FunctionNode object, AstNode astNode, Map<String, Node> map, Set<String> set) {
        if (!(astNode instanceof ArrayLiteral) && !(astNode instanceof ObjectLiteral)) {
            if (astNode instanceof InfixExpression && astNode.getType() == 90) {
                astNode = (InfixExpression)astNode;
                this.arrowFunctionParams((FunctionNode)object, ((InfixExpression)astNode).getLeft(), map, set);
                this.arrowFunctionParams((FunctionNode)object, ((InfixExpression)astNode).getRight(), map, set);
            } else if (astNode instanceof Name) {
                ((FunctionNode)object).addParam(astNode);
                object = ((Name)astNode).getIdentifier();
                this.defineSymbol(88, (String)object);
                if (this.inUseStrictDirective) {
                    if ("eval".equals(object) || "arguments".equals(object)) {
                        this.reportError("msg.bad.id.strict", (String)object);
                    }
                    if (set.contains(object)) {
                        this.addError("msg.dup.param.strict", (String)object);
                    }
                    set.add((String)object);
                }
            } else {
                this.reportError("msg.no.parm", astNode.getPosition(), astNode.getLength());
                ((FunctionNode)object).addParam(this.makeErrorNode());
            }
        } else {
            this.markDestructuring(astNode);
            ((FunctionNode)object).addParam(astNode);
            object = this.currentScriptOrFn.getNextTempName();
            this.defineSymbol(88, (String)object, false);
            map.put((String)object, astNode);
        }
    }

    private AstNode assignExpr() throws IOException {
        AstNode astNode;
        int n = this.peekToken();
        int n2 = 1;
        if (n == 73) {
            return this.returnOrYield(n, true);
        }
        AstNode astNode2 = this.condExpr();
        n = this.peekTokenOrEOL();
        if (n == 1) {
            n = this.peekToken();
        } else {
            n2 = 0;
        }
        if (91 <= n && n <= 102) {
            if (this.inDestructuringAssignment) {
                this.reportError("msg.destruct.default.vals");
            }
            this.consumeToken();
            Comment comment = this.getAndResetJsDoc();
            this.markDestructuring(astNode2);
            n2 = this.ts.tokenBeg;
            astNode = new Assignment(n, astNode2, this.assignExpr(), n2);
            if (comment != null) {
                astNode.setJsDocNode(comment);
            }
        } else if (n == 83) {
            astNode = astNode2;
            if (this.currentJsDocComment != null) {
                astNode2.setJsDocNode(this.getAndResetJsDoc());
                astNode = astNode2;
            }
        } else {
            astNode = astNode2;
            if (n2 == 0) {
                astNode = astNode2;
                if (n == 165) {
                    this.consumeToken();
                    astNode = this.arrowFunction(astNode2);
                }
            }
        }
        return astNode;
    }

    private AstNode attributeAccess() throws IOException {
        int n = this.nextToken();
        int n2 = this.ts.tokenBeg;
        if (n != 23) {
            if (n != 39) {
                if (n != 84) {
                    this.reportError("msg.no.name.after.xmlAttr");
                    return this.makeErrorNode();
                }
                return this.xmlElemRef(n2, null, -1);
            }
            return this.propertyName(n2, this.ts.getString(), 0);
        }
        this.saveNameTokenData(this.ts.tokenBeg, "*", this.ts.lineno);
        return this.propertyName(n2, "*", 0);
    }

    private void autoInsertSemicolon(AstNode astNode) throws IOException {
        block4: {
            int n;
            block2: {
                block3: {
                    int n2 = this.peekFlaggedToken();
                    n = astNode.getPosition();
                    int n3 = 0xFFFF & n2;
                    if (n3 == -1 || n3 == 0) break block2;
                    if (n3 == 83) break block3;
                    if (n3 == 87) break block2;
                    if ((n2 & 0x10000) == 0) {
                        this.reportError("msg.no.semi.stmt");
                    } else {
                        this.warnMissingSemi(n, this.nodeEnd(astNode));
                    }
                    break block4;
                }
                this.consumeToken();
                astNode.setLength(this.ts.tokenEnd - n);
                break block4;
            }
            this.warnMissingSemi(n, this.nodeEnd(astNode));
        }
    }

    private AstNode bitAndExpr() throws IOException {
        AstNode astNode = this.eqExpr();
        while (this.matchToken(11)) {
            int n = this.ts.tokenBeg;
            astNode = new InfixExpression(11, astNode, this.eqExpr(), n);
        }
        return astNode;
    }

    private AstNode bitOrExpr() throws IOException {
        AstNode astNode = this.bitXorExpr();
        while (this.matchToken(9)) {
            int n = this.ts.tokenBeg;
            astNode = new InfixExpression(9, astNode, this.bitXorExpr(), n);
        }
        return astNode;
    }

    private AstNode bitXorExpr() throws IOException {
        AstNode astNode = this.bitAndExpr();
        while (this.matchToken(10)) {
            int n = this.ts.tokenBeg;
            astNode = new InfixExpression(10, astNode, this.bitAndExpr(), n);
        }
        return astNode;
    }

    private AstNode block() throws IOException {
        if (this.currentToken != 86) {
            this.codeBug();
        }
        this.consumeToken();
        int n = this.ts.tokenBeg;
        Scope scope = new Scope(n);
        scope.setLineno(this.ts.lineno);
        this.pushScope(scope);
        try {
            this.statements(scope);
            this.mustMatchToken(87, "msg.no.brace.block");
            scope.setLength(this.ts.tokenEnd - n);
            return scope;
        }
        finally {
            this.popScope();
        }
    }

    private BreakStatement breakStatement() throws IOException {
        Name name;
        if (this.currentToken != 121) {
            this.codeBug();
        }
        this.consumeToken();
        int n = this.ts.lineno;
        int n2 = this.ts.tokenBeg;
        int n3 = this.ts.tokenEnd;
        int n4 = this.peekTokenOrEOL();
        Iterable<Node> iterable = null;
        if (n4 == 39) {
            name = this.createNameNode();
            n3 = this.getNodeEnd(name);
        } else {
            name = null;
        }
        Iterable<Node> iterable2 = this.matchJumpLabelName();
        if (iterable2 != null) {
            iterable = ((LabeledStatement)iterable2).getFirstLabel();
        }
        iterable2 = iterable;
        if (iterable == null) {
            iterable2 = iterable;
            if (name == null) {
                iterable2 = this.loopAndSwitchSet;
                if (iterable2 != null && iterable2.size() != 0) {
                    iterable = this.loopAndSwitchSet;
                    iterable2 = (Jump)iterable.get(iterable.size() - 1);
                } else {
                    iterable2 = iterable;
                    if (name == null) {
                        this.reportError("msg.bad.break", n2, n3 - n2);
                        iterable2 = iterable;
                    }
                }
            }
        }
        iterable = new BreakStatement(n2, n3 - n2);
        ((BreakStatement)iterable).setBreakLabel(name);
        if (iterable2 != null) {
            ((BreakStatement)iterable).setBreakTarget((Jump)iterable2);
        }
        ((Node)iterable).setLineno(n);
        return iterable;
    }

    private void checkBadIncDec(UnaryExpression object) {
        int n = this.removeParens(((UnaryExpression)object).getOperand()).getType();
        if (n != 39 && n != 33 && n != 36 && n != 68 && n != 38) {
            object = ((Node)object).getType() == 107 ? "msg.bad.incr" : "msg.bad.decr";
            this.reportError((String)object);
        }
    }

    private void checkCallRequiresActivation(AstNode astNode) {
        if (astNode.getType() == 39 && "eval".equals(((Name)astNode).getIdentifier()) || astNode.getType() == 33 && "eval".equals(((PropertyGet)astNode).getProperty().getIdentifier())) {
            this.setRequiresActivation();
        }
    }

    private RuntimeException codeBug() throws RuntimeException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ts.cursor=");
        stringBuilder.append(this.ts.cursor);
        stringBuilder.append(", ts.tokenBeg=");
        stringBuilder.append(this.ts.tokenBeg);
        stringBuilder.append(", currentToken=");
        stringBuilder.append(this.currentToken);
        throw Kit.codeBug(stringBuilder.toString());
    }

    private AstNode condExpr() throws IOException {
        AstNode astNode;
        block5: {
            AstNode astNode2;
            astNode = astNode2 = this.orExpr();
            if (this.matchToken(103)) {
                int n = this.ts.lineno;
                int n2 = this.ts.tokenBeg;
                int n3 = -1;
                boolean bl = this.inForInit;
                this.inForInit = false;
                AstNode astNode3 = this.assignExpr();
                if (this.mustMatchToken(104, "msg.no.colon.cond")) {
                    n3 = this.ts.tokenBeg;
                }
                AstNode astNode4 = this.assignExpr();
                int n4 = astNode2.getPosition();
                astNode = new ConditionalExpression(n4, this.getNodeEnd(astNode4) - n4);
                astNode.setLineno(n);
                ((ConditionalExpression)astNode).setTestExpression(astNode2);
                ((ConditionalExpression)astNode).setTrueExpression(astNode3);
                ((ConditionalExpression)astNode).setFalseExpression(astNode4);
                ((ConditionalExpression)astNode).setQuestionMarkPosition(n2 - n4);
                ((ConditionalExpression)astNode).setColonPosition(n3 - n4);
                break block5;
                finally {
                    this.inForInit = bl;
                }
            }
        }
        return astNode;
    }

    private ConditionData condition() throws IOException {
        ConditionData conditionData = new ConditionData();
        if (this.mustMatchToken(88, "msg.no.paren.cond")) {
            conditionData.lp = this.ts.tokenBeg;
        }
        conditionData.condition = this.expr();
        if (this.mustMatchToken(89, "msg.no.paren.after.cond")) {
            conditionData.rp = this.ts.tokenBeg;
        }
        if (conditionData.condition instanceof Assignment) {
            this.addStrictWarning("msg.equal.as.assign", "", conditionData.condition.getPosition(), conditionData.condition.getLength());
        }
        return conditionData;
    }

    private void consumeToken() {
        this.currentFlaggedToken = 0;
    }

    private ContinueStatement continueStatement() throws IOException {
        Name name;
        if (this.currentToken != 122) {
            this.codeBug();
        }
        this.consumeToken();
        int n = this.ts.lineno;
        int n2 = this.ts.tokenBeg;
        int n3 = this.ts.tokenEnd;
        int n4 = this.peekTokenOrEOL();
        Iterable<Node> iterable = null;
        if (n4 == 39) {
            name = this.createNameNode();
            n3 = this.getNodeEnd(name);
        } else {
            name = null;
        }
        Iterable<Node> iterable2 = this.matchJumpLabelName();
        if (iterable2 == null && name == null) {
            iterable2 = this.loopSet;
            if (iterable2 != null && iterable2.size() != 0) {
                iterable = this.loopSet;
                iterable = (Loop)iterable.get(iterable.size() - 1);
            } else {
                this.reportError("msg.continue.outside");
            }
        } else {
            if (iterable2 == null || !(((LabeledStatement)iterable2).getStatement() instanceof Loop)) {
                this.reportError("msg.continue.nonloop", n2, n3 - n2);
            }
            if (iterable2 != null) {
                iterable = (Loop)((LabeledStatement)iterable2).getStatement();
            }
        }
        iterable2 = new ContinueStatement(n2, n3 - n2);
        if (iterable != null) {
            ((ContinueStatement)iterable2).setTarget((Loop)iterable);
        }
        ((ContinueStatement)iterable2).setLabel(name);
        ((Node)iterable2).setLineno(n);
        return iterable2;
    }

    private Name createNameNode() {
        return this.createNameNode(false, 39);
    }

    private Name createNameNode(boolean bl, int n) {
        int n2 = this.ts.tokenBeg;
        String string2 = this.ts.getString();
        int n3 = this.ts.lineno;
        String string3 = this.prevNameTokenString;
        Object object = "";
        if (!"".equals(string3)) {
            n2 = this.prevNameTokenStart;
            string2 = this.prevNameTokenString;
            n3 = this.prevNameTokenLineno;
            this.prevNameTokenStart = 0;
            this.prevNameTokenString = "";
            this.prevNameTokenLineno = 0;
        }
        if (string2 == null) {
            if (this.compilerEnv.isIdeMode()) {
                string2 = object;
            } else {
                this.codeBug();
            }
        }
        object = new Name(n2, string2);
        ((Node)object).setLineno(n3);
        if (bl) {
            this.checkActivationName(string2, n);
        }
        return object;
    }

    private StringLiteral createStringLiteral() {
        int n = this.ts.tokenBeg;
        StringLiteral stringLiteral = new StringLiteral(n, this.ts.tokenEnd - n);
        stringLiteral.setLineno(this.ts.lineno);
        stringLiteral.setValue(this.ts.getString());
        stringLiteral.setQuoteCharacter(this.ts.getQuoteChar());
        return stringLiteral;
    }

    private AstNode defaultXmlNamespace() throws IOException {
        if (this.currentToken != 117) {
            this.codeBug();
        }
        this.consumeToken();
        this.mustHaveXML();
        this.setRequiresActivation();
        int n = this.ts.lineno;
        int n2 = this.ts.tokenBeg;
        if (!this.matchToken(39) || !"xml".equals(this.ts.getString())) {
            this.reportError("msg.bad.namespace");
        }
        if (!this.matchToken(39) || !"namespace".equals(this.ts.getString())) {
            this.reportError("msg.bad.namespace");
        }
        if (!this.matchToken(91)) {
            this.reportError("msg.bad.namespace");
        }
        AstNode astNode = this.expr();
        UnaryExpression unaryExpression = new UnaryExpression(n2, this.getNodeEnd(astNode) - n2);
        unaryExpression.setOperator(75);
        unaryExpression.setOperand(astNode);
        unaryExpression.setLineno(n);
        return new ExpressionStatement(unaryExpression, true);
    }

    private AstNode destructuringPrimaryExpr() throws IOException, ParserException {
        try {
            this.inDestructuringAssignment = true;
            AstNode astNode = this.primaryExpr();
            return astNode;
        }
        finally {
            this.inDestructuringAssignment = false;
        }
    }

    private DoLoop doLoop() throws IOException {
        int n;
        DoLoop doLoop;
        int n2;
        block4: {
            if (this.currentToken != 119) {
                this.codeBug();
            }
            this.consumeToken();
            n2 = this.ts.tokenBeg;
            doLoop = new DoLoop(n2);
            doLoop.setLineno(this.ts.lineno);
            this.enterLoop(doLoop);
            AstNode astNode = this.statement();
            this.mustMatchToken(118, "msg.no.while.do");
            doLoop.setWhilePosition(this.ts.tokenBeg - n2);
            ConditionData conditionData = this.condition();
            doLoop.setCondition(conditionData.condition);
            doLoop.setParens(conditionData.lp - n2, conditionData.rp - n2);
            n = this.getNodeEnd(astNode);
            doLoop.setBody(astNode);
            if (!this.matchToken(83)) break block4;
            n = this.ts.tokenEnd;
        }
        doLoop.setLength(n - n2);
        return doLoop;
        finally {
            this.exitLoop();
        }
    }

    private void enterLoop(Loop loop) {
        if (this.loopSet == null) {
            this.loopSet = new ArrayList<Loop>();
        }
        this.loopSet.add(loop);
        if (this.loopAndSwitchSet == null) {
            this.loopAndSwitchSet = new ArrayList<Jump>();
        }
        this.loopAndSwitchSet.add(loop);
        this.pushScope(loop);
        LabeledStatement labeledStatement = this.currentLabel;
        if (labeledStatement != null) {
            labeledStatement.setStatement(loop);
            this.currentLabel.getFirstLabel().setLoop(loop);
            loop.setRelative(-this.currentLabel.getPosition());
        }
    }

    private void enterSwitch(SwitchStatement switchStatement) {
        if (this.loopAndSwitchSet == null) {
            this.loopAndSwitchSet = new ArrayList<Jump>();
        }
        this.loopAndSwitchSet.add(switchStatement);
    }

    private AstNode eqExpr() throws IOException {
        AstNode astNode = this.relExpr();
        while (true) {
            int n = this.peekToken();
            int n2 = this.ts.tokenBeg;
            if (n != 12 && n != 13 && n != 46 && n != 47) {
                return astNode;
            }
            this.consumeToken();
            int n3 = n;
            if (this.compilerEnv.getLanguageVersion() == 120) {
                if (n == 12) {
                    n3 = 46;
                } else {
                    n3 = n;
                    if (n == 13) {
                        n3 = 47;
                    }
                }
            }
            astNode = new InfixExpression(n3, astNode, this.relExpr(), n2);
        }
    }

    private void exitLoop() {
        List<Jump> list = this.loopSet;
        Loop loop = list.remove(list.size() - 1);
        list = this.loopAndSwitchSet;
        list.remove(list.size() - 1);
        if (loop.getParent() != null) {
            loop.setRelative(loop.getParent().getPosition());
        }
        this.popScope();
    }

    private void exitSwitch() {
        List<Jump> list = this.loopAndSwitchSet;
        list.remove(list.size() - 1);
    }

    private AstNode expr() throws IOException {
        AstNode astNode = this.assignExpr();
        int n = astNode.getPosition();
        while (this.matchToken(90)) {
            int n2 = this.ts.tokenBeg;
            if (this.compilerEnv.isStrictMode() && !astNode.hasSideEffects()) {
                this.addStrictWarning("msg.no.side.effects", "", n, this.nodeEnd(astNode) - n);
            }
            if (this.peekToken() == 73) {
                this.reportError("msg.yield.parenthesized");
            }
            astNode = new InfixExpression(90, astNode, this.assignExpr(), n2);
        }
        return astNode;
    }

    /*
     * Unable to fully structure code
     */
    private Loop forLoop() throws IOException {
        block31: {
            block29: {
                block30: {
                    block28: {
                        block26: {
                            block27: {
                                if (this.currentToken != 120) {
                                    this.codeBug();
                                }
                                this.consumeToken();
                                var1_1 = this.ts.tokenBeg;
                                var2_2 = this.ts.lineno;
                                var3_3 = null;
                                var4_4 = null;
                                var5_5 = new Scope();
                                this.pushScope(var5_5);
                                var6_6 = this.matchToken(39);
                                var7_7 = 0;
                                var8_8 = 0;
                                if (!var6_6) break block26;
                                if (!"each".equals(this.ts.getString())) break block27;
                                var9_9 = this.ts.tokenBeg - var1_1;
                                var6_6 = true;
                            }
                            this.reportError("msg.no.paren.for");
                        }
                        var9_9 = -1;
                        var6_6 = false;
                        var10_10 = this.mustMatchToken(88, "msg.no.paren.for") != false ? this.ts.tokenBeg - var1_1 : -1;
                        var11_11 = this.forLoopInit(this.peekToken());
                        if (!this.matchToken(52)) break block28;
                        var12_12 = this.ts.tokenBeg - var1_1;
                        var13_13 = this.expr();
                        var8_8 = 1;
lbl35:
                        // 2 sources

                        while (true) {
                            var14_16 = false;
                            break block29;
                            break;
                        }
                    }
                    if (this.compilerEnv.getLanguageVersion() < 200 || !this.matchToken(39) || !"of".equals(this.ts.getString())) break block30;
                    var12_12 = this.ts.tokenBeg - var1_1;
                    var13_13 = this.expr();
                    var14_16 = true;
                    var4_4 = var3_3;
                    var8_8 = var7_7;
                    {
                        catch (Throwable var13_15) {
                            throw var13_15;
                        }
                    }
                }
                this.mustMatchToken(83, "msg.no.semi.for");
                if (this.peekToken() == 83) {
                    var13_13 = new EmptyExpression(this.ts.tokenBeg, 1);
                    var13_13.setLineno(this.ts.lineno);
                } else {
                    var13_13 = this.expr();
                }
                this.mustMatchToken(83, "msg.no.semi.for.cond");
                var12_12 = this.ts.tokenEnd;
                if (this.peekToken() == 89) {
                    var4_4 = new EmptyExpression(var12_12, 1);
                    var4_4.setLineno(this.ts.lineno);
                } else {
                    var4_4 = this.expr();
                }
                var12_12 = -1;
                ** continue;
            }
            var7_7 = this.mustMatchToken(89, "msg.no.paren.for.ctrl") != false ? this.ts.tokenBeg - var1_1 : -1;
            if (var8_8 != 0 || var14_16) break block31;
            var3_3 = new ForLoop(var1_1);
            var3_3.setInitializer(var11_11);
            var3_3.setCondition(var13_13);
            var3_3.setIncrement(var4_4);
            var13_13 = var3_3;
        }
        var4_4 = new ForInLoop(var1_1);
        if (var11_11 instanceof VariableDeclaration && ((VariableDeclaration)var11_11).getVariables().size() > 1) {
            this.reportError("msg.mult.index");
        }
        if (!var14_16 || !var6_6) ** GOTO lbl87
        this.reportError("msg.invalid.for.each");
lbl87:
        // 2 sources

        var4_4.setIterator(var11_11);
        var4_4.setIteratedObject(var13_13);
        var4_4.setInPosition(var12_12);
        var4_4.setIsForEach(var6_6);
        var4_4.setEachPosition(var9_9);
        var4_4.setIsForOf(var14_16);
        var13_13 = var4_4;
        this.currentScope.replaceWith((Scope)var13_13);
        this.popScope();
        this.enterLoop((Loop)var13_13);
        try {
            var4_4 = this.statement();
            var13_13.setLength(this.getNodeEnd(var4_4) - var1_1);
            var13_13.setBody(var4_4);
        }
        catch (Throwable var13_14) {
            this.exitLoop();
            throw var13_14;
        }
        this.exitLoop();
        var13_13.setParens(var10_10, var7_7);
        var13_13.setLineno(var2_2);
        return var13_13;
        finally {
            if (this.currentScope == var5_5) {
                this.popScope();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AstNode forLoopInit(int n) throws IOException {
        try {
            AstNode astNode;
            this.inForInit = true;
            if (n == 83) {
                astNode = new EmptyExpression(this.ts.tokenBeg, 1);
                astNode.setLineno(this.ts.lineno);
                return astNode;
            }
            if (n != 123 && n != 154) {
                astNode = this.expr();
                this.markDestructuring(astNode);
                return astNode;
            }
            this.consumeToken();
            astNode = this.variables(n, this.ts.tokenBeg, false);
            return astNode;
        }
        finally {
            this.inForInit = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FunctionNode function(int n) throws IOException {
        FunctionNode functionNode;
        Object object;
        int n2;
        block14: {
            Object object2;
            Object object3;
            n2 = this.ts.lineno;
            int n3 = this.ts.tokenBeg;
            boolean bl = this.matchToken(39);
            Object object4 = null;
            object = null;
            if (bl) {
                object3 = this.createNameNode(true, 39);
                if (this.inUseStrictDirective && ("eval".equals(object2 = ((Name)object3).getIdentifier()) || "arguments".equals(object2))) {
                    this.reportError("msg.bad.id.strict", (String)object2);
                }
                object2 = object3;
                if (!this.matchToken(88)) {
                    object2 = object3;
                    object4 = object;
                    if (this.compilerEnv.isAllowMemberExprAsFunctionName()) {
                        object4 = this.memberExprTail(false, (AstNode)object3);
                        object2 = null;
                    }
                    this.mustMatchToken(88, "msg.no.paren.parms");
                }
            } else if (this.matchToken(88)) {
                object2 = null;
            } else {
                object2 = this.compilerEnv.isAllowMemberExprAsFunctionName() ? this.memberExpr(false) : null;
                this.mustMatchToken(88, "msg.no.paren.parms");
                object3 = null;
                object4 = object2;
                object2 = object3;
            }
            int n4 = this.currentToken == 88 ? this.ts.tokenBeg : -1;
            int n5 = object4 != null ? 2 : n;
            if (n5 != 2 && object2 != null && ((Name)object2).length() > 0) {
                this.defineSymbol(110, ((Name)object2).getIdentifier());
            }
            functionNode = new FunctionNode(n3, (Name)object2);
            functionNode.setFunctionType(n);
            if (n4 != -1) {
                functionNode.setLp(n4 - n3);
            }
            functionNode.setJsDocNode(this.getAndResetJsDoc());
            object = new PerFunctionVariables(functionNode);
            this.parseFunctionParams(functionNode);
            functionNode.setBody(this.parseFunctionBody(n, functionNode));
            functionNode.setEncodedSourceBounds(n3, this.ts.tokenEnd);
            functionNode.setLength(this.ts.tokenEnd - n3);
            if (this.compilerEnv.isStrictMode() && !functionNode.getBody().hasConsistentReturnUsage()) {
                object3 = object2 != null && ((Name)object2).length() > 0 ? "msg.no.return.value" : "msg.anon.no.return.value";
                object2 = object2 == null ? "" : ((Name)object2).getIdentifier();
                this.addStrictWarning((String)object3, (String)object2);
            }
            if (object4 == null) break block14;
            Kit.codeBug();
            functionNode.setMemberExprNode((AstNode)object4);
        }
        functionNode.setSourceName(this.sourceURI);
        functionNode.setBaseLineno(n2);
        functionNode.setEndLineno(this.ts.lineno);
        if (this.compilerEnv.isIdeMode()) {
            functionNode.setParentScope(this.currentScope);
        }
        return functionNode;
        finally {
            ((PerFunctionVariables)object).restore();
        }
    }

    private AstNode generatorExpression(AstNode astNode, int n) throws IOException {
        return this.generatorExpression(astNode, n, false);
    }

    private AstNode generatorExpression(AstNode astNode, int n, boolean bl) throws IOException {
        ArrayList<GeneratorExpressionLoop> arrayList = new ArrayList<GeneratorExpressionLoop>();
        while (this.peekToken() == 120) {
            arrayList.add(this.generatorExpressionLoop());
        }
        int n2 = -1;
        ConditionData conditionData = null;
        if (this.peekToken() == 113) {
            this.consumeToken();
            n2 = this.ts.tokenBeg - n;
            conditionData = this.condition();
        }
        if (!bl) {
            this.mustMatchToken(89, "msg.no.paren.let");
        }
        GeneratorExpression generatorExpression = new GeneratorExpression(n, this.ts.tokenEnd - n);
        generatorExpression.setResult(astNode);
        generatorExpression.setLoops(arrayList);
        if (conditionData != null) {
            generatorExpression.setIfPosition(n2);
            generatorExpression.setFilter(conditionData.condition);
            generatorExpression.setFilterLp(conditionData.lp - n);
            generatorExpression.setFilterRp(conditionData.rp - n);
        }
        return generatorExpression;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GeneratorExpressionLoop generatorExpressionLoop() throws IOException {
        if (this.nextToken() != 120) {
            this.codeBug();
        }
        int n = this.ts.tokenBeg;
        GeneratorExpressionLoop generatorExpressionLoop = new GeneratorExpressionLoop(n);
        this.pushScope(generatorExpressionLoop);
        try {
            boolean bl = this.mustMatchToken(88, "msg.no.paren.for");
            int n2 = -1;
            int n3 = bl ? this.ts.tokenBeg - n : -1;
            AstNode astNode = null;
            int n4 = this.peekToken();
            if (n4 != 39) {
                if (n4 != 84 && n4 != 86) {
                    this.reportError("msg.bad.var");
                } else {
                    astNode = this.destructuringPrimaryExpr();
                    this.markDestructuring(astNode);
                }
            } else {
                this.consumeToken();
                astNode = this.createNameNode();
            }
            if (astNode.getType() == 39) {
                this.defineSymbol(154, this.ts.getString(), true);
            }
            n4 = this.mustMatchToken(52, "msg.in.after.for.name") ? this.ts.tokenBeg - n : -1;
            AstNode astNode2 = this.expr();
            if (this.mustMatchToken(89, "msg.no.paren.for.ctrl")) {
                n2 = this.ts.tokenBeg - n;
            }
            generatorExpressionLoop.setLength(this.ts.tokenEnd - n);
            generatorExpressionLoop.setIterator(astNode);
            generatorExpressionLoop.setIteratedObject(astNode2);
            generatorExpressionLoop.setInPosition(n4);
            generatorExpressionLoop.setParens(n3, n2);
            return generatorExpressionLoop;
        }
        finally {
            this.popScope();
        }
    }

    private Comment getAndResetJsDoc() {
        Comment comment = this.currentJsDocComment;
        this.currentJsDocComment = null;
        return comment;
    }

    private String getDirective(AstNode astNode) {
        if (astNode instanceof ExpressionStatement && (astNode = ((ExpressionStatement)astNode).getExpression()) instanceof StringLiteral) {
            return ((StringLiteral)astNode).getValue();
        }
        return null;
    }

    private int getNodeEnd(AstNode astNode) {
        return astNode.getPosition() + astNode.getLength();
    }

    private int getNumberOfEols(String string2) {
        int n = 0;
        for (int i = string2.length() - 1; i >= 0; --i) {
            int n2 = n;
            if (string2.charAt(i) == '\n') {
                n2 = n + 1;
            }
            n = n2;
        }
        return n;
    }

    private IfStatement ifStatement() throws IOException {
        if (this.currentToken != 113) {
            this.codeBug();
        }
        this.consumeToken();
        int n = this.ts.tokenBeg;
        int n2 = this.ts.lineno;
        int n3 = -1;
        ConditionData conditionData = this.condition();
        AstNode astNode = this.statement();
        AstNode astNode2 = null;
        if (this.matchToken(114)) {
            n3 = this.ts.tokenBeg - n;
            astNode2 = this.statement();
        }
        AstNode astNode3 = astNode2 != null ? astNode2 : astNode;
        astNode3 = new IfStatement(n, this.getNodeEnd(astNode3) - n);
        ((IfStatement)astNode3).setCondition(conditionData.condition);
        ((IfStatement)astNode3).setParens(conditionData.lp - n, conditionData.rp - n);
        ((IfStatement)astNode3).setThenPart(astNode);
        ((IfStatement)astNode3).setElsePart(astNode2);
        ((IfStatement)astNode3).setElsePosition(n3);
        astNode3.setLineno(n2);
        return astNode3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AstNode let(boolean bl, int n) throws IOException {
        LetNode letNode = new LetNode(n);
        letNode.setLineno(this.ts.lineno);
        if (this.mustMatchToken(88, "msg.no.paren.after.let")) {
            letNode.setLp(this.ts.tokenBeg - n);
        }
        this.pushScope(letNode);
        try {
            letNode.setVariables(this.variables(154, this.ts.tokenBeg, bl));
            if (this.mustMatchToken(89, "msg.no.paren.let")) {
                letNode.setRp(this.ts.tokenBeg - n);
            }
            if (bl && this.peekToken() == 86) {
                this.consumeToken();
                int n2 = this.ts.tokenBeg;
                AstNode astNode = this.statements();
                this.mustMatchToken(87, "msg.no.curly.let");
                astNode.setLength(this.ts.tokenEnd - n2);
                letNode.setLength(this.ts.tokenEnd - n);
                letNode.setBody(astNode);
                letNode.setType(154);
                return letNode;
            }
            AstNode astNode = this.expr();
            letNode.setLength(this.getNodeEnd(astNode) - n);
            letNode.setBody(astNode);
            if (!bl) return letNode;
            bl = !this.insideFunction();
            astNode = new ExpressionStatement(letNode, bl);
            astNode.setLineno(letNode.getLineno());
            return astNode;
        }
        finally {
            this.popScope();
        }
    }

    private AstNode letStatement() throws IOException {
        if (this.currentToken != 154) {
            this.codeBug();
        }
        this.consumeToken();
        int n = this.ts.lineno;
        int n2 = this.ts.tokenBeg;
        AstNode astNode = this.peekToken() == 88 ? this.let(true, n2) : this.variables(154, n2, true);
        astNode.setLineno(n);
        return astNode;
    }

    private int lineBeginningFor(int n) {
        char[] cArray = this.sourceChars;
        if (cArray == null) {
            return -1;
        }
        if (n <= 0) {
            return 0;
        }
        int n2 = n;
        if (n >= cArray.length) {
            n2 = cArray.length - 1;
        }
        while ((n = n2 - 1) >= 0) {
            n2 = n;
            if (!ScriptRuntime.isJSLineTerminator(cArray[n])) continue;
            return n + 1;
        }
        return 0;
    }

    private ErrorNode makeErrorNode() {
        ErrorNode errorNode = new ErrorNode(this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg);
        errorNode.setLineno(this.ts.lineno);
        return errorNode;
    }

    private LabeledStatement matchJumpLabelName() throws IOException {
        int n = this.peekTokenOrEOL();
        Object object = null;
        LabeledStatement labeledStatement = null;
        if (n == 39) {
            this.consumeToken();
            object = this.labelSet;
            if (object != null) {
                labeledStatement = object.get(this.ts.getString());
            }
            object = labeledStatement;
            if (labeledStatement == null) {
                this.reportError("msg.undef.label");
                object = labeledStatement;
            }
        }
        return object;
    }

    private boolean matchToken(int n) throws IOException {
        if (this.peekToken() != n) {
            return false;
        }
        this.consumeToken();
        return true;
    }

    private AstNode memberExpr(boolean bl) throws IOException {
        AstNode astNode;
        int n = this.peekToken();
        int n2 = this.ts.lineno;
        if (n != 30) {
            astNode = this.primaryExpr();
        } else {
            this.consumeToken();
            int n3 = this.ts.tokenBeg;
            astNode = new NewExpression(n3);
            Iterable<Node> iterable = this.memberExpr(false);
            n = this.getNodeEnd((AstNode)iterable);
            ((FunctionCall)astNode).setTarget((AstNode)iterable);
            if (this.matchToken(88)) {
                int n4 = this.ts.tokenBeg;
                iterable = this.argumentList();
                if (iterable != null && iterable.size() > 65536) {
                    this.reportError("msg.too.many.constructor.args");
                }
                int n5 = this.ts.tokenBeg;
                n = this.ts.tokenEnd;
                if (iterable != null) {
                    ((FunctionCall)astNode).setArguments((List<AstNode>)iterable);
                }
                ((FunctionCall)astNode).setParens(n4 - n3, n5 - n3);
            }
            if (this.matchToken(86)) {
                iterable = this.objectLiteral();
                n = this.getNodeEnd((AstNode)iterable);
                ((NewExpression)astNode).setInitializer((ObjectLiteral)iterable);
            }
            astNode.setLength(n - n3);
        }
        astNode.setLineno(n2);
        return this.memberExprTail(bl, astNode);
    }

    private AstNode memberExprTail(boolean bl, AstNode iterable) throws IOException {
        if (iterable == null) {
            this.codeBug();
        }
        int n = ((AstNode)iterable).getPosition();
        while (true) {
            AstNode astNode;
            int n2;
            AstNode astNode2;
            int n3;
            int n4;
            int n5;
            block10: {
                block14: {
                    block13: {
                        block11: {
                            block12: {
                                n5 = this.peekToken();
                                n4 = -1;
                                if (n5 == 84) break block10;
                                if (n5 == 88) break block11;
                                if (n5 == 109 || n5 == 144) break block12;
                                if (n5 == 147) {
                                    this.consumeToken();
                                    n3 = this.ts.tokenBeg;
                                    int n6 = this.ts.lineno;
                                    this.mustHaveXML();
                                    this.setRequiresActivation();
                                    astNode2 = this.expr();
                                    n2 = this.getNodeEnd(astNode2);
                                    n5 = n4;
                                    n4 = n2;
                                    if (this.mustMatchToken(89, "msg.no.paren")) {
                                        n5 = this.ts.tokenBeg;
                                        n4 = this.ts.tokenEnd;
                                    }
                                    astNode = new XmlDotQuery(n, n4 - n);
                                    ((InfixExpression)astNode).setLeft((AstNode)iterable);
                                    ((InfixExpression)astNode).setRight(astNode2);
                                    ((InfixExpression)astNode).setOperatorPosition(n3);
                                    ((XmlDotQuery)astNode).setRp(n5 - n);
                                    astNode.setLineno(n6);
                                    iterable = astNode;
                                    continue;
                                }
                                break block13;
                            }
                            n4 = this.ts.lineno;
                            iterable = this.propertyAccess(n5, (AstNode)iterable);
                            ((Node)iterable).setLineno(n4);
                            continue;
                        }
                        if (bl) break block14;
                    }
                    return iterable;
                }
                n4 = this.ts.lineno;
                this.consumeToken();
                this.checkCallRequiresActivation((AstNode)iterable);
                astNode = new FunctionCall(n);
                ((FunctionCall)astNode).setTarget((AstNode)iterable);
                astNode.setLineno(n4);
                ((FunctionCall)astNode).setLp(this.ts.tokenBeg - n);
                iterable = this.argumentList();
                if (iterable != null && iterable.size() > 65536) {
                    this.reportError("msg.too.many.function.args");
                }
                ((FunctionCall)astNode).setArguments((List<AstNode>)iterable);
                ((FunctionCall)astNode).setRp(this.ts.tokenBeg - n);
                astNode.setLength(this.ts.tokenEnd - n);
                iterable = astNode;
                continue;
            }
            this.consumeToken();
            n3 = this.ts.tokenBeg;
            n2 = this.ts.lineno;
            astNode2 = this.expr();
            n5 = this.getNodeEnd(astNode2);
            if (this.mustMatchToken(85, "msg.no.bracket.index")) {
                n4 = this.ts.tokenBeg;
                n5 = this.ts.tokenEnd;
            }
            astNode = new ElementGet(n, n5 - n);
            ((ElementGet)astNode).setTarget((AstNode)iterable);
            ((ElementGet)astNode).setElement(astNode2);
            ((ElementGet)astNode).setParens(n3, n4);
            astNode.setLineno(n2);
            iterable = astNode;
        }
    }

    private ObjectProperty methodDefinition(int n, AstNode astNode, int n2) throws IOException {
        FunctionNode functionNode = this.function(2);
        AstNode astNode2 = functionNode.getFunctionName();
        if (astNode2 != null && ((Name)astNode2).length() != 0) {
            this.reportError("msg.bad.prop");
        }
        astNode2 = new ObjectProperty(n);
        if (n2 != 2) {
            if (n2 != 4) {
                if (n2 == 8) {
                    ((ObjectProperty)astNode2).setIsNormalMethod();
                    functionNode.setFunctionIsNormalMethod();
                }
            } else {
                ((ObjectProperty)astNode2).setIsSetterMethod();
                functionNode.setFunctionIsSetterMethod();
            }
        } else {
            ((ObjectProperty)astNode2).setIsGetterMethod();
            functionNode.setFunctionIsGetterMethod();
        }
        n2 = this.getNodeEnd(functionNode);
        ((InfixExpression)astNode2).setLeft(astNode);
        ((InfixExpression)astNode2).setRight(functionNode);
        astNode2.setLength(n2 - n);
        return astNode2;
    }

    private AstNode mulExpr() throws IOException {
        AstNode astNode = this.unaryExpr();
        block3: while (true) {
            int n = this.peekToken();
            int n2 = this.ts.tokenBeg;
            switch (n) {
                default: {
                    break block3;
                }
                case 23: 
                case 24: 
                case 25: {
                    this.consumeToken();
                    astNode = new InfixExpression(n, astNode, this.unaryExpr(), n2);
                    continue block3;
                }
            }
            break;
        }
        return astNode;
    }

    private void mustHaveXML() {
        if (!this.compilerEnv.isXmlAvailable()) {
            this.reportError("msg.XML.not.available");
        }
    }

    private boolean mustMatchToken(int n, String string2) throws IOException {
        return this.mustMatchToken(n, string2, this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg);
    }

    private boolean mustMatchToken(int n, String string2, int n2, int n3) throws IOException {
        if (this.matchToken(n)) {
            return true;
        }
        this.reportError(string2, n2, n3);
        return false;
    }

    private AstNode name(int n, int n2) throws IOException {
        String string2 = this.ts.getString();
        n2 = this.ts.tokenBeg;
        int n3 = this.ts.lineno;
        if ((n & 0x20000) != 0 && this.peekToken() == 104) {
            Label label = new Label(n2, this.ts.tokenEnd - n2);
            label.setName(string2);
            label.setLineno(this.ts.lineno);
            return label;
        }
        this.saveNameTokenData(n2, string2, n3);
        if (this.compilerEnv.isXmlAvailable()) {
            return this.propertyName(-1, string2, 0);
        }
        return this.createNameNode(true, 39);
    }

    private AstNode nameOrLabel() throws IOException {
        if (this.currentToken == 39) {
            Object object;
            AstNode astNode;
            int n;
            block10: {
                Object object2;
                block9: {
                    n = this.ts.tokenBeg;
                    this.currentFlaggedToken |= 0x20000;
                    object2 = this.expr();
                    if (((Node)object2).getType() != 131) {
                        ExpressionStatement expressionStatement = new ExpressionStatement((AstNode)object2, this.insideFunction() ^ true);
                        expressionStatement.lineno = ((AstNode)object2).lineno;
                        return expressionStatement;
                    }
                    astNode = new LabeledStatement(n);
                    this.recordLabel((Label)object2, (LabeledStatement)astNode);
                    astNode.setLineno(this.ts.lineno);
                    while (this.peekToken() == 39) {
                        this.currentFlaggedToken |= 0x20000;
                        object2 = this.expr();
                        if (((Node)object2).getType() != 131) {
                            object2 = new ExpressionStatement((AstNode)object2, this.insideFunction() ^ true);
                            this.autoInsertSemicolon((AstNode)object2);
                            break block9;
                        }
                        this.recordLabel((Label)object2, (LabeledStatement)astNode);
                    }
                    object2 = null;
                }
                this.currentLabel = astNode;
                object = object2;
                if (object2 != null) break block10;
                object = this.statementHelper();
            }
            n = ((AstNode)object).getParent() == null ? this.getNodeEnd((AstNode)object) - n : this.getNodeEnd((AstNode)object);
            astNode.setLength(n);
            ((LabeledStatement)astNode).setStatement((AstNode)object);
            return astNode;
            finally {
                this.currentLabel = null;
                for (Label label : ((LabeledStatement)astNode).getLabels()) {
                    this.labelSet.remove(label.getName());
                }
            }
        }
        throw this.codeBug();
    }

    private int nextFlaggedToken() throws IOException {
        this.peekToken();
        int n = this.currentFlaggedToken;
        this.consumeToken();
        return n;
    }

    private int nextToken() throws IOException {
        int n = this.peekToken();
        this.consumeToken();
        return n;
    }

    private int nodeEnd(AstNode astNode) {
        return astNode.getPosition() + astNode.getLength();
    }

    private static final boolean nowAllSet(int n, int n2, int n3) {
        boolean bl = (n & n3) != n3 && (n2 & n3) == n3;
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private ObjectLiteral objectLiteral() throws IOException {
        var1_1 = this.ts.tokenBeg;
        var2_2 = this.ts.lineno;
        var3_3 = new ArrayList<ObjectProperty>();
        if (this.inUseStrictDirective) {
            var4_4 = new HashSet<AstNode>();
            var5_5 = new HashSet<Object>();
        } else {
            var4_4 = null;
            var5_5 = null;
        }
        var6_6 = this.getAndResetJsDoc();
        var7_7 = -1;
        while (true) {
            block22: {
                block23: {
                    block24: {
                        block25: {
                            block18: {
                                block19: {
                                    block21: {
                                        block20: {
                                            var8_8 = this.peekToken();
                                            var9_9 = this.getAndResetJsDoc();
                                            if (var8_8 == 87) {
                                                if (var7_7 == -1) break;
                                                this.warnTrailingComma(var1_1, var3_3, var7_7);
                                                break;
                                            }
                                            var10_10 = this.objliteralProperty();
                                            if (var10_10 == null) {
                                                this.reportError("msg.bad.prop");
                                                var10_10 = null;
lbl23:
                                                // 2 sources

                                                while (true) {
                                                    var7_7 = 1;
                                                    break block18;
                                                    break;
                                                }
                                            }
                                            var11_11 = this.ts.getString();
                                            var12_12 = this.ts.tokenBeg;
                                            this.consumeToken();
                                            var7_7 = this.peekToken();
                                            if (var7_7 == 90 || var7_7 == 104 || var7_7 == 87) break block19;
                                            if (var7_7 != 88) break block20;
                                            var7_7 = 8;
                                            break block21;
                                        }
                                        if (var10_10.getType() != 39) ** GOTO lbl-1000
                                        if ("get".equals(var11_11)) {
                                            var7_7 = 2;
                                        } else if ("set".equals(var11_11)) {
                                            var7_7 = 4;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            var7_7 = 1;
                                        }
                                    }
                                    if (var7_7 == 2 || var7_7 == 4) {
                                        var10_10 = this.objliteralProperty();
                                        if (var10_10 == null) {
                                            this.reportError("msg.bad.prop");
                                        }
                                        this.consumeToken();
                                    }
                                    if (var10_10 == null) {
                                        var10_10 = null;
                                    } else {
                                        var11_11 = this.ts.getString();
                                        var13_13 = this.methodDefinition(var12_12, (AstNode)var10_10, var7_7);
                                        var10_10.setJsDocNode(var9_9);
                                        var3_3.add(var13_13);
                                        var10_10 = var11_11;
                                    }
                                    break block18;
                                }
                                var10_10.setJsDocNode(var9_9);
                                var3_3.add(this.plainProperty((AstNode)var10_10, var8_8));
                                var10_10 = var11_11;
                                ** continue;
                            }
                            if (!this.inUseStrictDirective || var10_10 == null) break block22;
                            if (var7_7 == 1) break block23;
                            if (var7_7 == 2) break block24;
                            if (var7_7 == 4) break block25;
                            if (var7_7 == 8) break block23;
                            break block22;
                        }
                        if (var5_5.contains(var10_10)) {
                            this.addError("msg.dup.obj.lit.prop.strict", (String)var10_10);
                        }
                        var5_5.add(var10_10);
                        break block22;
                    }
                    if (var4_4.contains(var10_10)) {
                        this.addError("msg.dup.obj.lit.prop.strict", (String)var10_10);
                    }
                    var4_4.add((AstNode)var10_10);
                    break block22;
                }
                if (var4_4.contains(var10_10) || var5_5.contains(var10_10)) {
                    this.addError("msg.dup.obj.lit.prop.strict", (String)var10_10);
                }
                var4_4.add((AstNode)var10_10);
                var5_5.add(var10_10);
            }
            this.getAndResetJsDoc();
            if (!this.matchToken(90)) break;
            var7_7 = this.ts.tokenEnd;
        }
        this.mustMatchToken(87, "msg.no.brace.prop");
        var10_10 = new ObjectLiteral(var1_1, this.ts.tokenEnd - var1_1);
        if (var6_6 != null) {
            var10_10.setJsDocNode(var6_6);
        }
        var10_10.setElements(var3_3);
        var10_10.setLineno(var2_2);
        return var10_10;
    }

    private AstNode objliteralProperty() throws IOException {
        block6: {
            AstNode astNode;
            switch (this.peekToken()) {
                default: {
                    if (this.compilerEnv.isReservedKeywordAsIdentifier() && TokenStream.isKeyword(this.ts.getString(), this.compilerEnv.getLanguageVersion(), this.inUseStrictDirective)) {
                        astNode = this.createNameNode();
                        break;
                    }
                    break block6;
                }
                case 41: {
                    astNode = this.createStringLiteral();
                    break;
                }
                case 40: {
                    astNode = new NumberLiteral(this.ts.tokenBeg, this.ts.getString(), this.ts.getNumber());
                    break;
                }
                case 39: {
                    astNode = this.createNameNode();
                }
            }
            return astNode;
        }
        return null;
    }

    private AstNode orExpr() throws IOException {
        AstNode astNode;
        AstNode astNode2 = astNode = this.andExpr();
        if (this.matchToken(105)) {
            int n = this.ts.tokenBeg;
            astNode2 = new InfixExpression(105, astNode, this.orExpr(), n);
        }
        return astNode2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AstNode parenExpr() throws IOException {
        boolean bl = this.inForInit;
        this.inForInit = false;
        try {
            Comment comment = this.getAndResetJsDoc();
            int n = this.ts.lineno;
            int n2 = this.ts.tokenBeg;
            AstNode astNode = this.peekToken() == 89 ? new EmptyExpression(n2) : this.expr();
            if (this.peekToken() == 120) {
                astNode = this.generatorExpression(astNode, n2);
                return astNode;
            }
            ParenthesizedExpression parenthesizedExpression = new ParenthesizedExpression(astNode);
            Comment comment2 = comment;
            if (comment == null) {
                comment2 = this.getAndResetJsDoc();
            }
            if (comment2 != null) {
                parenthesizedExpression.setJsDocNode(comment2);
            }
            this.mustMatchToken(89, "msg.no.paren");
            if (astNode.getType() == 129 && this.peekToken() != 165) {
                this.reportError("msg.syntax");
                astNode = this.makeErrorNode();
                return astNode;
            }
            parenthesizedExpression.setLength(this.ts.tokenEnd - parenthesizedExpression.getPosition());
            parenthesizedExpression.setLineno(n);
            return parenthesizedExpression;
        }
        finally {
            this.inForInit = bl;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AstRoot parse() throws IOException {
        var1_1 = new AstRoot(0);
        this.currentScriptOrFn = var1_1;
        this.currentScope = var1_1;
        var2_2 = this.ts.lineno;
        var3_3 = this.inUseStrictDirective;
        this.inUseStrictDirective = var4_4 = this.defaultUseStrictDirective;
        if (var4_4) {
            var1_1.setInStrictMode(true);
        }
        var5_5 = 1;
        var6_6 = 0;
        while (true) {
            block21: {
                block22: {
                    block20: {
                        var7_7 = var6_6;
                        try {
                            var8_8 = this.peekToken();
                            if (var8_8 <= 0) break block20;
                            if (var8_8 != 110) break block21;
                            var7_7 = var6_6;
                            this.consumeToken();
                            var7_7 = var6_6;
                            var8_8 = this.calledByCompileFunction != false ? 2 : 1;
                            var7_7 = var6_6;
                            var9_9 = this.function(var8_8);
                            var8_8 = var5_5;
                            ** GOTO lbl87
                        }
                        catch (StackOverflowError var9_11) {
                            var9_9 = this.lookupMessage("msg.too.deep.parser.recursion");
                            var4_4 = this.compilerEnv.isIdeMode();
                            if (var4_4) {
                                var6_6 = var7_7;
                            }
                            ** GOTO lbl-1000
                        }
                        catch (Throwable var9_10) {
                            break block22;
                        }
                    }
lbl36:
                    // 2 sources

                    while (true) {
                        this.inUseStrictDirective = var3_3;
                        var7_7 = this.syntaxErrorCount;
                        if (var7_7 != 0) {
                            var9_9 = this.lookupMessage("msg.got.syntax.errors", String.valueOf(var7_7));
                            if (!this.compilerEnv.isIdeMode()) {
                                throw this.errorReporter.runtimeError((String)var9_9, this.sourceURI, var2_2, null, 0);
                            }
                        }
                        var9_9 = this.scannedComments;
                        var7_7 = var6_6;
                        if (var9_9 != null) {
                            var7_7 = var9_9.size();
                            var6_6 = Math.max(var6_6, this.getNodeEnd(this.scannedComments.get(var7_7 - 1)));
                            var9_9 = this.scannedComments.iterator();
                            while (true) {
                                var7_7 = var6_6;
                                if (!var9_9.hasNext()) break;
                                var1_1.addComment(var9_9.next());
                            }
                        }
                        var1_1.setLength(var7_7 - 0);
                        var1_1.setSourceName(this.sourceURI);
                        var1_1.setBaseLineno(var2_2);
                        var1_1.setEndLineno(this.ts.lineno);
                        return var1_1;
                    }
lbl-1000:
                    // 1 sources

                    {
                        throw Context.reportRuntimeError((String)var9_9, this.sourceURI, this.ts.lineno, null, 0);
                    }
                }
                this.inUseStrictDirective = var3_3;
                throw var9_10;
                catch (ParserException var9_12) {
                    ** continue;
                }
            }
            var7_7 = var6_6;
            {
                var10_13 = this.statement();
                var8_8 = var5_5;
                var9_9 = var10_13;
                if (var5_5 != 0) {
                    var7_7 = var6_6;
                    var11_14 = this.getDirective(var10_13);
                    if (var11_14 == null) {
                        var8_8 = 0;
                        var9_9 = var10_13;
                    } else {
                        var8_8 = var5_5;
                        var9_9 = var10_13;
                        var7_7 = var6_6;
                        if (var11_14.equals("use strict")) {
                            var7_7 = var6_6;
                            this.inUseStrictDirective = true;
                            var7_7 = var6_6;
                            var1_1.setInStrictMode(true);
                            var9_9 = var10_13;
                            var8_8 = var5_5;
                        }
                    }
                }
lbl87:
                // 7 sources

                var7_7 = var6_6;
                var7_7 = var6_6 = this.getNodeEnd((AstNode)var9_9);
                var1_1.addChildToBack((Node)var9_9);
                var7_7 = var6_6;
                var9_9.setParent(var1_1);
                var5_5 = var8_8;
                continue;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private AstNode parseFunctionBody(int var1_1, FunctionNode var2_2) throws IOException {
        block18: {
            block21: {
                if (this.matchToken(86)) ** GOTO lbl6
                if (this.compilerEnv.getLanguageVersion() >= 180 || var1_1 == 4) {
                    var3_5 = true;
                } else {
                    this.reportError("msg.no.brace.body");
lbl6:
                    // 2 sources

                    var3_5 = false;
                }
                var1_1 = var1_1 == 4 ? 1 : 0;
                ++this.nestingOfFunction;
                var4_6 = this.ts.tokenBeg;
                var5_7 = new Block(var4_6);
                var6_8 = this.inUseStrictDirective;
                var5_7.setLineno(this.ts.lineno);
                if (!var3_5) break block21;
                var7_9 = this.assignExpr();
                var2_2 = new ReturnStatement(var7_9.getPosition(), var7_9.getLength(), var7_9);
                var2_2.putProp(25, Boolean.TRUE);
                var5_7.putProp(25, Boolean.TRUE);
                if (var1_1 == 0) ** GOTO lbl22
                try {
                    var2_2.putProp(27, Boolean.TRUE);
lbl22:
                    // 2 sources

                    var5_7.addStatement(var2_2);
                }
                catch (Throwable var2_3) {
                    --this.nestingOfFunction;
                    this.inUseStrictDirective = var6_8;
                    throw var2_3;
                }
            }
            var1_1 = 1;
            while (true) {
                block20: {
                    block19: {
                        var8_11 = this.peekToken();
                        if (var8_11 == -1 || var8_11 == 0 || var8_11 == 87) break block18;
                        if (var8_11 == 110) break block19;
                        var7_10 = var9_12 = this.statement();
                        var8_11 = var1_1;
                        if (var1_1 == 0) break block20;
                        var10_13 = this.getDirective(var9_12);
                        if (var10_13 == null) {
                            var8_11 = 0;
                            var7_10 = var9_12;
                            break block20;
                        }
                        var7_10 = var9_12;
                        var8_11 = var1_1;
                        if (!var10_13.equals("use strict")) break block20;
                        this.inUseStrictDirective = true;
                        var2_2.setInStrictMode(true);
                        var7_10 = var9_12;
                        var8_11 = var1_1;
                        if (var6_8) break block20;
                        this.setRequiresActivation();
                        var7_10 = var9_12;
                        var8_11 = var1_1;
                        break block20;
                    }
                    this.consumeToken();
                    var7_10 = this.function(1);
                    var8_11 = var1_1;
                }
                var5_7.addStatement(var7_10);
                var1_1 = var8_11;
                continue;
                break;
            }
        }
lbl70:
        // 2 sources

        while (true) {
            --this.nestingOfFunction;
            this.inUseStrictDirective = var6_8;
            var8_11 = this.ts.tokenEnd;
            this.getAndResetJsDoc();
            var1_1 = var8_11;
            if (!var3_5) {
                var1_1 = var8_11;
                if (this.mustMatchToken(87, "msg.no.brace.after.body")) {
                    var1_1 = this.ts.tokenEnd;
                }
            }
            var5_7.setLength(var1_1 - var4_6);
            return var5_7;
        }
        catch (ParserException var2_4) {
            ** continue;
        }
    }

    private void parseFunctionParams(FunctionNode functionNode) throws IOException {
        Object object;
        if (this.matchToken(89)) {
            functionNode.setRp(this.ts.tokenBeg - functionNode.getPosition());
            return;
        }
        Object object2 = null;
        HashSet<Object> object32 = new HashSet<Object>();
        do {
            Object object3;
            int n;
            if ((n = this.peekToken()) != 84 && n != 86) {
                if (this.mustMatchToken(39, "msg.no.parm")) {
                    object3 = this.createNameNode();
                    object = this.getAndResetJsDoc();
                    if (object != null) {
                        ((Node)object3).setJsDocNode((Comment)object);
                    }
                    functionNode.addParam((AstNode)object3);
                    object3 = this.ts.getString();
                    this.defineSymbol(88, (String)object3);
                    object = object2;
                    if (this.inUseStrictDirective) {
                        if ("eval".equals(object3) || "arguments".equals(object3)) {
                            this.reportError("msg.bad.id.strict", (String)object3);
                        }
                        if (object32.contains(object3)) {
                            this.addError("msg.dup.param.strict", (String)object3);
                        }
                        object32.add(object3);
                        object = object2;
                    }
                } else {
                    functionNode.addParam(this.makeErrorNode());
                    object = object2;
                }
            } else {
                object3 = this.destructuringPrimaryExpr();
                this.markDestructuring((AstNode)object3);
                functionNode.addParam((AstNode)object3);
                object = object2;
                if (object2 == null) {
                    object = new HashMap();
                }
                object2 = this.currentScriptOrFn.getNextTempName();
                this.defineSymbol(88, (String)object2, false);
                object.put(object2, object3);
            }
            object2 = object;
        } while (this.matchToken(90));
        if (object != null) {
            object2 = new Node(90);
            for (Map.Entry entry : object.entrySet()) {
                ((Node)object2).addChildToBack(this.createDestructuringAssignment(123, (Node)entry.getValue(), this.createName((String)entry.getKey())));
            }
            functionNode.putProp(23, object2);
        }
        if (this.mustMatchToken(89, "msg.no.paren.after.parms")) {
            functionNode.setRp(this.ts.tokenBeg - functionNode.getPosition());
        }
    }

    private int peekFlaggedToken() throws IOException {
        this.peekToken();
        return this.currentFlaggedToken;
    }

    private int peekToken() throws IOException {
        if (this.currentFlaggedToken != 0) {
            return this.currentToken;
        }
        int n = this.ts.getLineno();
        int n2 = this.ts.getToken();
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int n5;
            if (n2 != 1 && n2 != 162) {
                this.currentToken = n2;
                n5 = n3;
                if (n4 != 0) {
                    n5 = 65536;
                }
                this.currentFlaggedToken = n2 | n5;
                return n2;
            }
            if (n2 == 1) {
                n2 = n + 1;
                n5 = 1;
            } else {
                n2 = n;
                n5 = n4;
                if (this.compilerEnv.isRecordingComments()) {
                    String string2 = this.ts.getAndResetCurrentComment();
                    this.recordComment(n, string2);
                    n2 = n + this.getNumberOfEols(string2);
                    n5 = n4;
                }
            }
            n4 = this.ts.getToken();
            n = n2;
            n2 = n4;
            n4 = n5;
        }
    }

    private int peekTokenOrEOL() throws IOException {
        int n = this.peekToken();
        if ((this.currentFlaggedToken & 0x10000) != 0) {
            n = 1;
        }
        return n;
    }

    private ObjectProperty plainProperty(AstNode astNode, int n) throws IOException {
        int n2 = this.peekToken();
        if ((n2 == 90 || n2 == 87) && n == 39 && this.compilerEnv.getLanguageVersion() >= 180) {
            if (!this.inDestructuringAssignment) {
                this.reportError("msg.bad.object.init");
            }
            Name name = new Name(astNode.getPosition(), astNode.getString());
            ObjectProperty objectProperty = new ObjectProperty();
            objectProperty.putProp(26, Boolean.TRUE);
            objectProperty.setLeftAndRight(astNode, name);
            return objectProperty;
        }
        this.mustMatchToken(104, "msg.no.colon.prop");
        ObjectProperty objectProperty = new ObjectProperty();
        objectProperty.setOperatorPosition(this.ts.tokenBeg);
        objectProperty.setLeftAndRight(astNode, this.assignExpr());
        return objectProperty;
    }

    private AstNode primaryExpr() throws IOException {
        block21: {
            block11: {
                block12: {
                    int n;
                    block13: {
                        block14: {
                            block15: {
                                block16: {
                                    block17: {
                                        block18: {
                                            block19: {
                                                block20: {
                                                    int n2 = this.peekFlaggedToken();
                                                    n = 0xFFFF & n2;
                                                    if (n == -1) break block11;
                                                    if (n == 0) break block12;
                                                    if (n == 24) break block13;
                                                    if (n == 84) break block14;
                                                    if (n == 86) break block15;
                                                    if (n == 88) break block16;
                                                    if (n == 101) break block13;
                                                    if (n == 110) break block17;
                                                    if (n == 128) break block18;
                                                    if (n == 148) break block19;
                                                    if (n == 154) break block20;
                                                    switch (n) {
                                                        default: {
                                                            this.consumeToken();
                                                            this.reportError("msg.syntax");
                                                            break block21;
                                                        }
                                                        case 42: 
                                                        case 43: 
                                                        case 44: 
                                                        case 45: {
                                                            this.consumeToken();
                                                            n2 = this.ts.tokenBeg;
                                                            return new KeywordLiteral(n2, this.ts.tokenEnd - n2, n);
                                                        }
                                                        case 41: {
                                                            this.consumeToken();
                                                            return this.createStringLiteral();
                                                        }
                                                        case 40: {
                                                            this.consumeToken();
                                                            CharSequence charSequence = this.ts.getString();
                                                            if (this.inUseStrictDirective && this.ts.isNumberOldOctal()) {
                                                                this.reportError("msg.no.old.octal.strict");
                                                            }
                                                            CharSequence charSequence2 = charSequence;
                                                            if (this.ts.isNumberBinary()) {
                                                                charSequence2 = new StringBuilder();
                                                                ((StringBuilder)charSequence2).append("0b");
                                                                ((StringBuilder)charSequence2).append((String)charSequence);
                                                                charSequence2 = ((StringBuilder)charSequence2).toString();
                                                            }
                                                            charSequence = charSequence2;
                                                            if (this.ts.isNumberOldOctal()) {
                                                                charSequence = new StringBuilder();
                                                                ((StringBuilder)charSequence).append("0");
                                                                ((StringBuilder)charSequence).append((String)charSequence2);
                                                                charSequence = ((StringBuilder)charSequence).toString();
                                                            }
                                                            charSequence2 = charSequence;
                                                            if (this.ts.isNumberOctal()) {
                                                                charSequence2 = new StringBuilder();
                                                                ((StringBuilder)charSequence2).append("0o");
                                                                ((StringBuilder)charSequence2).append((String)charSequence);
                                                                charSequence2 = ((StringBuilder)charSequence2).toString();
                                                            }
                                                            charSequence = charSequence2;
                                                            if (this.ts.isNumberHex()) {
                                                                charSequence = new StringBuilder();
                                                                ((StringBuilder)charSequence).append("0x");
                                                                ((StringBuilder)charSequence).append((String)charSequence2);
                                                                charSequence = ((StringBuilder)charSequence).toString();
                                                            }
                                                            return new NumberLiteral(this.ts.tokenBeg, (String)charSequence, this.ts.getNumber());
                                                        }
                                                        case 39: {
                                                            this.consumeToken();
                                                            return this.name(n2, n);
                                                        }
                                                    }
                                                }
                                                this.consumeToken();
                                                return this.let(false, this.ts.tokenBeg);
                                            }
                                            this.consumeToken();
                                            this.mustHaveXML();
                                            return this.attributeAccess();
                                        }
                                        this.consumeToken();
                                        this.reportError("msg.reserved.id", this.ts.getString());
                                        break block21;
                                    }
                                    this.consumeToken();
                                    return this.function(2);
                                }
                                this.consumeToken();
                                return this.parenExpr();
                            }
                            this.consumeToken();
                            return this.objectLiteral();
                        }
                        this.consumeToken();
                        return this.arrayLiteral();
                    }
                    this.consumeToken();
                    this.ts.readRegExp(n);
                    n = this.ts.tokenBeg;
                    RegExpLiteral regExpLiteral = new RegExpLiteral(n, this.ts.tokenEnd - n);
                    regExpLiteral.setValue(this.ts.getString());
                    regExpLiteral.setFlags(this.ts.readAndClearRegExpFlags());
                    return regExpLiteral;
                }
                this.consumeToken();
                this.reportError("msg.unexpected.eof");
                break block21;
            }
            this.consumeToken();
        }
        this.consumeToken();
        return this.makeErrorNode();
    }

    /*
     * Enabled aggressive block sorting
     */
    private AstNode propertyAccess(int n, AstNode astNode) throws IOException {
        Object object;
        int n2;
        block10: {
            int n3;
            block11: {
                block12: {
                    block13: {
                        if (astNode == null) {
                            this.codeBug();
                        }
                        n3 = 0;
                        int n4 = this.ts.lineno;
                        n2 = this.ts.tokenBeg;
                        this.consumeToken();
                        if (n == 144) {
                            this.mustHaveXML();
                            n3 = 4;
                        }
                        if (!this.compilerEnv.isXmlAvailable()) {
                            if (!(this.nextToken() == 39 || this.compilerEnv.isReservedKeywordAsIdentifier() && TokenStream.isKeyword(this.ts.getString(), this.compilerEnv.getLanguageVersion(), this.inUseStrictDirective))) {
                                this.reportError("msg.no.name.after.dot");
                            }
                            astNode = new PropertyGet(astNode, this.createNameNode(true, 33), n2);
                            astNode.setLineno(n4);
                            return astNode;
                        }
                        n4 = this.nextToken();
                        if (n4 == 23) break block11;
                        if (n4 == 39) break block12;
                        if (n4 == 50) break block13;
                        if (n4 != 128) {
                            if (n4 != 148) {
                                if (this.compilerEnv.isReservedKeywordAsIdentifier() && (object = Token.keywordToName(n4)) != null) {
                                    this.saveNameTokenData(this.ts.tokenBeg, (String)object, this.ts.lineno);
                                    object = this.propertyName(-1, (String)object, n3);
                                    break block10;
                                } else {
                                    this.reportError("msg.no.name.after.dot");
                                    return this.makeErrorNode();
                                }
                            }
                            object = this.attributeAccess();
                            break block10;
                        } else {
                            object = this.ts.getString();
                            this.saveNameTokenData(this.ts.tokenBeg, (String)object, this.ts.lineno);
                            object = this.propertyName(-1, (String)object, n3);
                        }
                        break block10;
                    }
                    this.saveNameTokenData(this.ts.tokenBeg, "throw", this.ts.lineno);
                    object = this.propertyName(-1, "throw", n3);
                    break block10;
                }
                object = this.propertyName(-1, this.ts.getString(), n3);
                break block10;
            }
            this.saveNameTokenData(this.ts.tokenBeg, "*", this.ts.lineno);
            object = this.propertyName(-1, "*", n3);
        }
        boolean bl = object instanceof XmlRef;
        InfixExpression infixExpression = bl ? new XmlMemberGet() : new PropertyGet();
        if (bl && n == 109) {
            infixExpression.setType(109);
        }
        n = astNode.getPosition();
        infixExpression.setPosition(n);
        infixExpression.setLength(this.getNodeEnd((AstNode)object) - n);
        infixExpression.setOperatorPosition(n2 - n);
        infixExpression.setLineno(astNode.getLineno());
        infixExpression.setLeft(astNode);
        infixExpression.setRight((AstNode)object);
        return infixExpression;
    }

    private AstNode propertyName(int n, String object, int n2) throws IOException {
        int n3;
        int n4 = n != -1 ? n : this.ts.tokenBeg;
        int n5 = this.ts.lineno;
        Name name = this.createNameNode(true, this.currentToken);
        if (this.matchToken(145)) {
            n3 = this.ts.tokenBeg;
            int n6 = this.nextToken();
            if (n6 != 23) {
                if (n6 != 39) {
                    if (n6 != 84) {
                        this.reportError("msg.no.name.after.coloncolon");
                        return this.makeErrorNode();
                    }
                    return this.xmlElemRef(n, name, n3);
                }
                object = this.createNameNode();
            } else {
                this.saveNameTokenData(this.ts.tokenBeg, "*", this.ts.lineno);
                object = this.createNameNode(false, -1);
            }
        } else {
            object = name;
            name = null;
            n3 = -1;
        }
        if (name == null && n2 == 0 && n == -1) {
            return object;
        }
        XmlPropRef xmlPropRef = new XmlPropRef(n4, this.getNodeEnd((AstNode)object) - n4);
        xmlPropRef.setAtPos(n);
        xmlPropRef.setNamespace(name);
        xmlPropRef.setColonPos(n3);
        xmlPropRef.setPropName((Name)object);
        xmlPropRef.setLineno(n5);
        return xmlPropRef;
    }

    private String readFully(Reader reader) throws IOException {
        reader = new BufferedReader(reader);
        try {
            int n;
            Object object = new char[1024];
            StringBuilder stringBuilder = new StringBuilder(1024);
            while ((n = ((BufferedReader)reader).read((char[])object, 0, 1024)) != -1) {
                stringBuilder.append((char[])object, 0, n);
            }
            object = stringBuilder.toString();
            return object;
        }
        finally {
            ((BufferedReader)reader).close();
        }
    }

    private void recordComment(int n, String object) {
        if (this.scannedComments == null) {
            this.scannedComments = new ArrayList<Comment>();
        }
        object = new Comment(this.ts.tokenBeg, this.ts.getTokenLength(), this.ts.commentType, (String)object);
        if (this.ts.commentType == Token.CommentType.JSDOC && this.compilerEnv.isRecordingLocalJsDocComments()) {
            this.currentJsDocComment = object;
        }
        ((Node)object).setLineno(n);
        this.scannedComments.add((Comment)object);
    }

    private void recordLabel(Label label, LabeledStatement labeledStatement) throws IOException {
        if (this.peekToken() != 104) {
            this.codeBug();
        }
        this.consumeToken();
        String string2 = label.getName();
        Object object = this.labelSet;
        if (object == null) {
            this.labelSet = new HashMap<String, LabeledStatement>();
        } else if ((object = object.get(string2)) != null) {
            if (this.compilerEnv.isIdeMode()) {
                object = ((LabeledStatement)object).getLabelByName(string2);
                this.reportError("msg.dup.label", ((AstNode)object).getAbsolutePosition(), ((AstNode)object).getLength());
            }
            this.reportError("msg.dup.label", label.getPosition(), label.getLength());
        }
        labeledStatement.addLabel(label);
        this.labelSet.put(string2, labeledStatement);
    }

    /*
     * Exception decompiling
     */
    private AstNode relExpr() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private AstNode returnOrYield(int n, boolean bl) throws IOException {
        Object object;
        boolean bl2 = this.insideFunction();
        int n2 = 4;
        if (!bl2) {
            object = n == 4 ? "msg.bad.return" : "msg.bad.yield";
            this.reportError((String)object);
        }
        this.consumeToken();
        int n3 = this.ts.lineno;
        int n4 = this.ts.tokenBeg;
        int n5 = this.ts.tokenEnd;
        AstNode astNode = null;
        int n6 = this.peekTokenOrEOL();
        int n7 = n5;
        object = astNode;
        if (n6 != -1) {
            n7 = n5;
            object = astNode;
            if (n6 != 0) {
                n7 = n5;
                object = astNode;
                if (n6 != 1) {
                    n7 = n5;
                    object = astNode;
                    if (n6 != 73) {
                        n7 = n5;
                        object = astNode;
                        if (n6 != 83) {
                            n7 = n5;
                            object = astNode;
                            if (n6 != 85) {
                                n7 = n5;
                                object = astNode;
                                if (n6 != 87) {
                                    n7 = n5;
                                    object = astNode;
                                    if (n6 != 89) {
                                        object = this.expr();
                                        n7 = this.getNodeEnd((AstNode)object);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        n5 = this.endFlags;
        if (n == 4) {
            n = n2;
            if (object == null) {
                n = 2;
            }
            this.endFlags = n5 | n;
            n = n7 - n4;
            astNode = new ReturnStatement(n4, n, (AstNode)object);
            object = astNode;
            if (Parser.nowAllSet(n5, this.endFlags, 6)) {
                this.addStrictWarning("msg.return.inconsistent", "", n4, n);
                object = astNode;
            }
        } else {
            if (!this.insideFunction()) {
                this.reportError("msg.bad.yield");
            }
            this.endFlags |= 8;
            astNode = new Yield(n4, n7 - n4, (AstNode)object);
            this.setRequiresActivation();
            this.setIsGenerator();
            object = astNode;
            if (!bl) {
                object = new ExpressionStatement(astNode);
            }
        }
        if (this.insideFunction() && Parser.nowAllSet(n5, this.endFlags, 12)) {
            astNode = ((FunctionNode)this.currentScriptOrFn).getFunctionName();
            if (astNode != null && ((Name)astNode).length() != 0) {
                this.addError("msg.generator.returns", ((Name)astNode).getIdentifier());
            } else {
                this.addError("msg.anon.generator.returns", "");
            }
        }
        ((Node)object).setLineno(n3);
        return object;
    }

    private void saveNameTokenData(int n, String string2, int n2) {
        this.prevNameTokenStart = n;
        this.prevNameTokenString = string2;
        this.prevNameTokenLineno = n2;
    }

    private AstNode shiftExpr() throws IOException {
        AstNode astNode = this.addExpr();
        block3: while (true) {
            int n = this.peekToken();
            int n2 = this.ts.tokenBeg;
            switch (n) {
                default: {
                    break block3;
                }
                case 18: 
                case 19: 
                case 20: {
                    this.consumeToken();
                    astNode = new InfixExpression(n, astNode, this.addExpr(), n2);
                    continue block3;
                }
            }
            break;
        }
        return astNode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AstNode statement() throws IOException {
        int n;
        int n2 = this.ts.tokenBeg;
        try {
            AstNode astNode = this.statementHelper();
            if (astNode != null) {
                if (this.compilerEnv.isStrictMode() && !astNode.hasSideEffects()) {
                    int n3 = astNode.getPosition();
                    n3 = Math.max(n3, this.lineBeginningFor(n3));
                    String string2 = astNode instanceof EmptyStatement ? "msg.extra.trailing.semi" : "msg.no.side.effects";
                    this.addStrictWarning(string2, "", n3, this.nodeEnd(astNode) - n3);
                }
                return astNode;
            }
        }
        catch (ParserException parserException) {}
        do {
            n = this.peekTokenOrEOL();
            this.consumeToken();
        } while (n != -1 && n != 0 && n != 1 && n != 83);
        return new EmptyStatement(n2, this.ts.tokenBeg - n2);
    }

    /*
     * Unable to fully structure code
     */
    private AstNode statementHelper() throws IOException {
        block14: {
            block26: {
                block15: {
                    block16: {
                        block17: {
                            block18: {
                                block19: {
                                    block20: {
                                        block21: {
                                            block22: {
                                                block23: {
                                                    block24: {
                                                        block25: {
                                                            var1_1 = this.currentLabel;
                                                            if (var1_1 != null && var1_1.getStatement() != null) {
                                                                this.currentLabel = null;
                                                            }
                                                            var2_2 = this.peekToken();
                                                            var3_3 = this.ts.tokenBeg;
                                                            if (var2_2 == -1) break block14;
                                                            if (var2_2 == 4) break block15;
                                                            if (var2_2 == 39) break block16;
                                                            if (var2_2 == 50) break block17;
                                                            if (var2_2 == 73) break block15;
                                                            if (var2_2 == 86) break block18;
                                                            if (var2_2 == 110) break block19;
                                                            if (var2_2 == 113) break block20;
                                                            if (var2_2 == 115) break block21;
                                                            if (var2_2 == 161) break block22;
                                                            if (var2_2 == 82) break block23;
                                                            if (var2_2 == 83) break block24;
                                                            if (var2_2 == 154) break block25;
                                                            if (var2_2 == 155) ** GOTO lbl-1000
                                                            switch (var2_2) {
                                                                default: {
                                                                    var3_3 = this.ts.lineno;
                                                                    var1_1 = new ExpressionStatement(this.expr(), true ^ this.insideFunction());
                                                                    var1_1.setLineno(var3_3);
                                                                    break;
                                                                }
                                                                case 124: {
                                                                    if (this.inUseStrictDirective) {
                                                                        this.reportError("msg.no.with.strict");
                                                                    }
                                                                    return this.withStatement();
                                                                }
                                                                case 122: {
                                                                    var1_1 = this.continueStatement();
                                                                    break;
                                                                }
                                                                case 121: {
                                                                    var1_1 = this.breakStatement();
                                                                    break;
                                                                }
                                                                case 120: {
                                                                    return this.forLoop();
                                                                }
                                                                case 119: {
                                                                    return this.doLoop();
                                                                }
                                                                case 118: {
                                                                    return this.whileLoop();
                                                                }
                                                                case 117: {
                                                                    var1_1 = this.defaultXmlNamespace();
                                                                    break;
                                                                }
                                                                case 123: lbl-1000:
                                                                // 2 sources

                                                                {
                                                                    this.consumeToken();
                                                                    var3_3 = this.ts.lineno;
                                                                    var1_1 = this.variables(this.currentToken, this.ts.tokenBeg, true);
                                                                    var1_1.setLineno(var3_3);
                                                                    break;
                                                                }
                                                            }
                                                            break block26;
                                                        }
                                                        var1_1 = this.letStatement();
                                                        if (!(var1_1 instanceof VariableDeclaration) || this.peekToken() != 83) {
                                                            return var1_1;
                                                        }
                                                        break block26;
                                                    }
                                                    this.consumeToken();
                                                    var3_3 = this.ts.tokenBeg;
                                                    var1_1 = new EmptyStatement(var3_3, this.ts.tokenEnd - var3_3);
                                                    var1_1.setLineno(this.ts.lineno);
                                                    return var1_1;
                                                }
                                                return this.tryStatement();
                                            }
                                            this.consumeToken();
                                            var1_1 = new KeywordLiteral(this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg, var2_2);
                                            var1_1.setLineno(this.ts.lineno);
                                            break block26;
                                        }
                                        return this.switchStatement();
                                    }
                                    return this.ifStatement();
                                }
                                this.consumeToken();
                                return this.function(3);
                            }
                            return this.block();
                        }
                        var1_1 = this.throwStatement();
                        break block26;
                    }
                    var1_1 = this.nameOrLabel();
                    if (!(var1_1 instanceof ExpressionStatement)) {
                        return var1_1;
                    }
                    break block26;
                }
                var1_1 = this.returnOrYield(var2_2, false);
            }
            this.autoInsertSemicolon(var1_1);
            return var1_1;
        }
        this.consumeToken();
        return this.makeErrorNode();
    }

    private AstNode statements() throws IOException {
        return this.statements(null);
    }

    private AstNode statements(AstNode astNode) throws IOException {
        int n;
        if (this.currentToken != 86 && !this.compilerEnv.isIdeMode()) {
            this.codeBug();
        }
        int n2 = this.ts.tokenBeg;
        if (astNode == null) {
            astNode = new Block(n2);
        }
        astNode.setLineno(this.ts.lineno);
        while ((n = this.peekToken()) > 0 && n != 87) {
            astNode.addChild(this.statement());
        }
        astNode.setLength(this.ts.tokenBeg - n2);
        return astNode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SwitchStatement switchStatement() throws IOException {
        if (this.currentToken != 115) {
            this.codeBug();
        }
        this.consumeToken();
        int n = this.ts.tokenBeg;
        SwitchStatement switchStatement = new SwitchStatement(n);
        if (this.mustMatchToken(88, "msg.no.paren.switch")) {
            switchStatement.setLp(this.ts.tokenBeg - n);
        }
        switchStatement.setLineno(this.ts.lineno);
        switchStatement.setExpression(this.expr());
        this.enterSwitch(switchStatement);
        try {
            if (this.mustMatchToken(89, "msg.no.paren.after.switch")) {
                switchStatement.setRp(this.ts.tokenBeg - n);
            }
            this.mustMatchToken(86, "msg.no.brace.switch");
            boolean bl = false;
            while (true) {
                AstNode astNode;
                int n2 = this.nextToken();
                int n3 = this.ts.tokenBeg;
                int n4 = this.ts.lineno;
                if (n2 == 87) break;
                if (n2 != 116) {
                    if (n2 != 117) {
                        this.reportError("msg.bad.switch");
                        return switchStatement;
                    }
                    if (bl) {
                        this.reportError("msg.double.switch.default");
                    }
                    bl = true;
                    astNode = null;
                    this.mustMatchToken(104, "msg.no.colon.case");
                } else {
                    astNode = this.expr();
                    this.mustMatchToken(104, "msg.no.colon.case");
                }
                SwitchCase switchCase = new SwitchCase(n3);
                switchCase.setExpression(astNode);
                switchCase.setLength(this.ts.tokenEnd - n);
                switchCase.setLineno(n4);
                while ((n4 = this.peekToken()) != 87 && n4 != 116 && n4 != 117 && n4 != 0) {
                    switchCase.addStatement(this.statement());
                }
                switchStatement.addCase(switchCase);
            }
            switchStatement.setLength(this.ts.tokenEnd - n);
            return switchStatement;
        }
        finally {
            this.exitSwitch();
        }
    }

    private ThrowStatement throwStatement() throws IOException {
        if (this.currentToken != 50) {
            this.codeBug();
        }
        this.consumeToken();
        int n = this.ts.tokenBeg;
        int n2 = this.ts.lineno;
        if (this.peekTokenOrEOL() == 1) {
            this.reportError("msg.bad.throw.eol");
        }
        AstNode astNode = this.expr();
        astNode = new ThrowStatement(n, this.getNodeEnd(astNode), astNode);
        astNode.setLineno(n2);
        return astNode;
    }

    private TryStatement tryStatement() throws IOException {
        ArrayList<CatchClause> arrayList;
        AstNode astNode;
        ArrayList<CatchClause> arrayList2;
        if (this.currentToken != 82) {
            this.codeBug();
        }
        this.consumeToken();
        Comment comment = this.getAndResetJsDoc();
        int n = this.ts.tokenBeg;
        int n2 = this.ts.lineno;
        if (this.peekToken() != 86) {
            this.reportError("msg.no.brace.try");
        }
        AstNode astNode2 = this.statement();
        int n3 = this.getNodeEnd(astNode2);
        int n4 = 0;
        int n5 = this.peekToken();
        if (n5 == 125) {
            arrayList2 = null;
            while (this.matchToken(125)) {
                int n6 = this.ts.lineno;
                if (n4 != 0) {
                    this.reportError("msg.catch.unreachable");
                }
                int n7 = this.ts.tokenBeg;
                n3 = this.mustMatchToken(88, "msg.no.paren.catch") ? this.ts.tokenBeg : -1;
                this.mustMatchToken(39, "msg.bad.catchcond");
                astNode = this.createNameNode();
                arrayList = this.getAndResetJsDoc();
                if (arrayList != null) {
                    astNode.setJsDocNode((Comment)((Object)arrayList));
                }
                arrayList = ((Name)astNode).getIdentifier();
                if (this.inUseStrictDirective && ("eval".equals(arrayList) || "arguments".equals(arrayList))) {
                    this.reportError("msg.bad.id.strict", (String)((Object)arrayList));
                }
                if (this.matchToken(113)) {
                    n5 = this.ts.tokenBeg;
                    arrayList = this.expr();
                } else {
                    n4 = 1;
                    n5 = -1;
                    arrayList = null;
                }
                int n8 = this.mustMatchToken(89, "msg.bad.catchcond") ? this.ts.tokenBeg : -1;
                this.mustMatchToken(86, "msg.no.brace.catchblock");
                Block block = (Block)this.statements();
                int n9 = this.getNodeEnd(block);
                CatchClause catchClause = new CatchClause(n7);
                catchClause.setVarName((Name)astNode);
                catchClause.setCatchCondition((AstNode)((Object)arrayList));
                catchClause.setBody(block);
                if (n5 != -1) {
                    catchClause.setIfPosition(n5 - n7);
                }
                catchClause.setParens(n3, n8);
                catchClause.setLineno(n6);
                n3 = this.mustMatchToken(87, "msg.no.brace.after.body") ? this.ts.tokenEnd : n9;
                catchClause.setLength(n3 - n7);
                arrayList = arrayList2;
                if (arrayList2 == null) {
                    arrayList = new ArrayList<CatchClause>();
                }
                arrayList.add(catchClause);
                arrayList2 = arrayList;
            }
        } else {
            if (n5 != 126) {
                this.mustMatchToken(126, "msg.try.no.catchfinally");
            }
            arrayList2 = null;
        }
        if (this.matchToken(126)) {
            n4 = this.ts.tokenBeg;
            arrayList = this.statement();
            n3 = this.getNodeEnd((AstNode)((Object)arrayList));
        } else {
            n4 = -1;
            arrayList = null;
        }
        astNode = new TryStatement(n, n3 - n);
        ((TryStatement)astNode).setTryBlock(astNode2);
        ((TryStatement)astNode).setCatchClauses(arrayList2);
        ((TryStatement)astNode).setFinallyBlock((AstNode)((Object)arrayList));
        if (n4 != -1) {
            ((TryStatement)astNode).setFinallyPosition(n4 - n);
        }
        astNode.setLineno(n2);
        if (comment != null) {
            astNode.setJsDocNode(comment);
        }
        return astNode;
    }

    private AstNode unaryExpr() throws IOException {
        block3: {
            int n;
            int n2;
            block9: {
                block4: {
                    block5: {
                        block6: {
                            block7: {
                                block8: {
                                    n2 = this.peekToken();
                                    n = this.ts.lineno;
                                    if (n2 == -1) break block3;
                                    if (n2 == 14) break block4;
                                    if (n2 == 127) break block5;
                                    if (n2 == 21) break block6;
                                    if (n2 == 22) break block7;
                                    if (n2 == 26 || n2 == 27) break block5;
                                    if (n2 == 31) break block8;
                                    if (n2 == 32) break block5;
                                    if (n2 == 107 || n2 == 108) {
                                        this.consumeToken();
                                        UnaryExpression unaryExpression = new UnaryExpression(n2, this.ts.tokenBeg, this.memberExpr(true));
                                        unaryExpression.setLineno(n);
                                        this.checkBadIncDec(unaryExpression);
                                        return unaryExpression;
                                    }
                                    break block9;
                                }
                                this.consumeToken();
                                UnaryExpression unaryExpression = new UnaryExpression(n2, this.ts.tokenBeg, this.unaryExpr());
                                unaryExpression.setLineno(n);
                                return unaryExpression;
                            }
                            this.consumeToken();
                            UnaryExpression unaryExpression = new UnaryExpression(29, this.ts.tokenBeg, this.unaryExpr());
                            unaryExpression.setLineno(n);
                            return unaryExpression;
                        }
                        this.consumeToken();
                        UnaryExpression unaryExpression = new UnaryExpression(28, this.ts.tokenBeg, this.unaryExpr());
                        unaryExpression.setLineno(n);
                        return unaryExpression;
                    }
                    this.consumeToken();
                    UnaryExpression unaryExpression = new UnaryExpression(n2, this.ts.tokenBeg, this.unaryExpr());
                    unaryExpression.setLineno(n);
                    return unaryExpression;
                }
                if (this.compilerEnv.isXmlAvailable()) {
                    this.consumeToken();
                    return this.memberExprTail(true, this.xmlInitializer());
                }
            }
            AstNode astNode = this.memberExpr(true);
            n2 = this.peekTokenOrEOL();
            if (n2 != 107 && n2 != 108) {
                return astNode;
            }
            this.consumeToken();
            astNode = new UnaryExpression(n2, this.ts.tokenBeg, astNode, true);
            astNode.setLineno(n);
            this.checkBadIncDec((UnaryExpression)astNode);
            return astNode;
        }
        this.consumeToken();
        return this.makeErrorNode();
    }

    private VariableDeclaration variables(int n, int n2, boolean bl) throws IOException {
        int n3;
        VariableDeclaration variableDeclaration = new VariableDeclaration(n2);
        variableDeclaration.setType(n);
        variableDeclaration.setLineno(this.ts.lineno);
        Object object = this.getAndResetJsDoc();
        if (object != null) {
            variableDeclaration.setJsDocNode((Comment)object);
        }
        do {
            Name name;
            int n4 = this.peekToken();
            int n5 = this.ts.tokenBeg;
            n3 = this.ts.tokenEnd;
            AstNode astNode = null;
            if (n4 != 84 && n4 != 86) {
                this.mustMatchToken(39, "msg.bad.var");
                name = this.createNameNode();
                name.setLineno(this.ts.getLineno());
                if (this.inUseStrictDirective && ("eval".equals(object = this.ts.getString()) || "arguments".equals(this.ts.getString()))) {
                    this.reportError("msg.bad.id.strict", (String)object);
                }
                this.defineSymbol(n, this.ts.getString(), this.inForInit);
                object = null;
            } else {
                object = this.destructuringPrimaryExpr();
                n3 = this.getNodeEnd((AstNode)object);
                if (!(object instanceof DestructuringForm)) {
                    this.reportError("msg.bad.assign.left", n5, n3 - n5);
                }
                this.markDestructuring((AstNode)object);
                name = null;
            }
            n4 = this.ts.lineno;
            Comment comment = this.getAndResetJsDoc();
            if (this.matchToken(91)) {
                astNode = this.assignExpr();
                n3 = this.getNodeEnd(astNode);
            }
            VariableInitializer variableInitializer = new VariableInitializer(n5, n3 - n5);
            if (object != null) {
                if (astNode == null && !this.inForInit) {
                    this.reportError("msg.destruct.assign.no.init");
                }
                variableInitializer.setTarget((AstNode)object);
            } else {
                variableInitializer.setTarget(name);
            }
            variableInitializer.setInitializer(astNode);
            variableInitializer.setType(n);
            variableInitializer.setJsDocNode(comment);
            variableInitializer.setLineno(n4);
            variableDeclaration.addVariable(variableInitializer);
        } while (this.matchToken(90));
        variableDeclaration.setLength(n3 - n2);
        variableDeclaration.setIsStatement(bl);
        return variableDeclaration;
    }

    private void warnMissingSemi(int n, int n2) {
        if (this.compilerEnv.isStrictMode()) {
            int[] nArray = new int[2];
            String string2 = this.ts.getLine(n2, nArray);
            int n3 = n;
            if (this.compilerEnv.isIdeMode()) {
                n3 = Math.max(n, n2 - nArray[1]);
            }
            if (string2 != null) {
                this.addStrictWarning("msg.missing.semi", "", n3, n2 - n3, nArray[0], string2, nArray[1]);
            } else {
                this.addStrictWarning("msg.missing.semi", "", n3, n2 - n3);
            }
        }
    }

    private void warnTrailingComma(int n, List<?> list, int n2) {
        if (this.compilerEnv.getWarnTrailingComma()) {
            if (!list.isEmpty()) {
                n = ((AstNode)list.get(0)).getPosition();
            }
            n = Math.max(n, this.lineBeginningFor(n2));
            this.addWarning("msg.extra.trailing.comma", n, n2 - n);
        }
    }

    private WhileLoop whileLoop() throws IOException {
        if (this.currentToken != 118) {
            this.codeBug();
        }
        this.consumeToken();
        int n = this.ts.tokenBeg;
        WhileLoop whileLoop = new WhileLoop(n);
        whileLoop.setLineno(this.ts.lineno);
        this.enterLoop(whileLoop);
        try {
            Object object = this.condition();
            whileLoop.setCondition(((ConditionData)object).condition);
            whileLoop.setParens(((ConditionData)object).lp - n, ((ConditionData)object).rp - n);
            object = this.statement();
            whileLoop.setLength(this.getNodeEnd((AstNode)object) - n);
            whileLoop.setBody((AstNode)object);
            return whileLoop;
        }
        finally {
            this.exitLoop();
        }
    }

    private WithStatement withStatement() throws IOException {
        if (this.currentToken != 124) {
            this.codeBug();
        }
        this.consumeToken();
        Comment comment = this.getAndResetJsDoc();
        int n = this.ts.lineno;
        int n2 = this.ts.tokenBeg;
        boolean bl = this.mustMatchToken(88, "msg.no.paren.with");
        int n3 = -1;
        int n4 = bl ? this.ts.tokenBeg : -1;
        AstNode astNode = this.expr();
        if (this.mustMatchToken(89, "msg.no.paren.after.with")) {
            n3 = this.ts.tokenBeg;
        }
        AstNode astNode2 = this.statement();
        WithStatement withStatement = new WithStatement(n2, this.getNodeEnd(astNode2) - n2);
        withStatement.setJsDocNode(comment);
        withStatement.setExpression(astNode);
        withStatement.setStatement(astNode2);
        withStatement.setParens(n4, n3);
        withStatement.setLineno(n);
        return withStatement;
    }

    private XmlElemRef xmlElemRef(int n, Name name, int n2) throws IOException {
        int n3 = this.ts.tokenBeg;
        int n4 = -1;
        int n5 = n != -1 ? n : n3;
        AstNode astNode = this.expr();
        int n6 = this.getNodeEnd(astNode);
        if (this.mustMatchToken(85, "msg.no.bracket.index")) {
            n4 = this.ts.tokenBeg;
            n6 = this.ts.tokenEnd;
        }
        XmlElemRef xmlElemRef = new XmlElemRef(n5, n6 - n5);
        xmlElemRef.setNamespace(name);
        xmlElemRef.setColonPos(n2);
        xmlElemRef.setAtPos(n);
        xmlElemRef.setExpression(astNode);
        xmlElemRef.setBrackets(n3, n4);
        return xmlElemRef;
    }

    private AstNode xmlInitializer() throws IOException {
        if (this.currentToken != 14) {
            this.codeBug();
        }
        int n = this.ts.tokenBeg;
        int n2 = this.ts.getFirstXMLToken();
        if (n2 != 146 && n2 != 149) {
            this.reportError("msg.syntax");
            return this.makeErrorNode();
        }
        XmlLiteral xmlLiteral = new XmlLiteral(n);
        xmlLiteral.setLineno(this.ts.lineno);
        while (true) {
            if (n2 != 146) {
                if (n2 != 149) {
                    this.reportError("msg.syntax");
                    return this.makeErrorNode();
                }
                xmlLiteral.addFragment(new XmlString(this.ts.tokenBeg, this.ts.getString()));
                return xmlLiteral;
            }
            xmlLiteral.addFragment(new XmlString(this.ts.tokenBeg, this.ts.getString()));
            this.mustMatchToken(86, "msg.syntax");
            n2 = this.ts.tokenBeg;
            AstNode astNode = this.peekToken() == 87 ? new EmptyExpression(n2, this.ts.tokenEnd - n2) : this.expr();
            this.mustMatchToken(87, "msg.syntax");
            astNode = new XmlExpression(n2, astNode);
            ((XmlExpression)astNode).setIsXmlAttribute(this.ts.isXMLAttribute());
            astNode.setLength(this.ts.tokenEnd - n2);
            xmlLiteral.addFragment((XmlFragment)astNode);
            n2 = this.ts.getNextXMLToken();
        }
    }

    void addError(String string2) {
        this.addError(string2, this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg);
    }

    void addError(String string2, int n) {
        this.addError(string2, Character.toString((char)n), this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg);
    }

    void addError(String string2, int n, int n2) {
        this.addError(string2, null, n, n2);
    }

    void addError(String string2, String string3) {
        this.addError(string2, string3, this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg);
    }

    void addError(String object, String string2, int n, int n2) {
        ++this.syntaxErrorCount;
        string2 = this.lookupMessage((String)object, string2);
        object = this.errorCollector;
        if (object != null) {
            object.error(string2, this.sourceURI, n, n2);
        } else {
            object = this.ts;
            if (object != null) {
                n2 = ((TokenStream)object).getLineno();
                object = this.ts.getLine();
                n = this.ts.getOffset();
            } else {
                object = "";
                n2 = 1;
                n = 1;
            }
            this.errorReporter.error(string2, this.sourceURI, n2, (String)object, n);
        }
    }

    void addStrictWarning(String string2, String string3) {
        int n;
        TokenStream tokenStream = this.ts;
        int n2 = -1;
        if (tokenStream != null) {
            n2 = tokenStream.tokenBeg;
            n = this.ts.tokenEnd - this.ts.tokenBeg;
        } else {
            n = -1;
        }
        this.addStrictWarning(string2, string3, n2, n);
    }

    void addStrictWarning(String string2, String string3, int n, int n2) {
        if (this.compilerEnv.isStrictMode()) {
            this.addWarning(string2, string3, n, n2);
        }
    }

    void addWarning(String string2, int n, int n2) {
        this.addWarning(string2, null, n, n2);
    }

    void addWarning(String string2, String string3) {
        int n;
        TokenStream tokenStream = this.ts;
        int n2 = -1;
        if (tokenStream != null) {
            n2 = tokenStream.tokenBeg;
            n = this.ts.tokenEnd - this.ts.tokenBeg;
        } else {
            n = -1;
        }
        this.addWarning(string2, string3, n2, n);
    }

    void addWarning(String object, String string2, int n, int n2) {
        String string3 = this.lookupMessage((String)object, string2);
        if (this.compilerEnv.reportWarningAsError()) {
            this.addError((String)object, string2, n, n2);
        } else {
            object = this.errorCollector;
            if (object != null) {
                object.warning(string3, this.sourceURI, n, n2);
            } else {
                this.errorReporter.warning(string3, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void checkActivationName(String string2, int n) {
        boolean bl;
        block6: {
            block5: {
                if (!this.insideFunction()) {
                    return;
                }
                boolean bl2 = false;
                if ("arguments".equals(string2) && ((FunctionNode)this.currentScriptOrFn).getFunctionType() != 4 || this.compilerEnv.getActivationNames() != null && this.compilerEnv.getActivationNames().contains(string2)) break block5;
                bl = bl2;
                if (!"length".equals(string2)) break block6;
                bl = bl2;
                if (n != 33) break block6;
                bl = bl2;
                if (this.compilerEnv.getLanguageVersion() != 120) break block6;
            }
            bl = true;
        }
        if (bl) {
            this.setRequiresActivation();
        }
    }

    protected void checkMutableReference(Node node) {
        if ((node.getIntProp(16, 0) & 4) != 0) {
            this.reportError("msg.bad.assign.left");
        }
    }

    Node createDestructuringAssignment(int n, Node node, Node node2) {
        String string2 = this.currentScriptOrFn.getNextTempName();
        node = this.destructuringAssignmentHelper(n, node, node2, string2);
        node.getLastChild().addChildToBack(this.createName(string2));
        return node;
    }

    protected Node createName(int n, String object, Node node) {
        object = this.createName((String)object);
        ((Node)object).setType(n);
        if (node != null) {
            ((Node)object).addChildToBack(node);
        }
        return object;
    }

    protected Node createName(String string2) {
        this.checkActivationName(string2, 39);
        return Node.newString(39, string2);
    }

    protected Node createNumber(double d) {
        return Node.newNumber(d);
    }

    protected Scope createScopeNode(int n, int n2) {
        Scope scope = new Scope();
        scope.setType(n);
        scope.setLineno(n2);
        return scope;
    }

    void defineSymbol(int n, String string2) {
        this.defineSymbol(n, string2, false);
    }

    void defineSymbol(int n, String string2, boolean bl) {
        Scope scope;
        if (string2 == null) {
            if (this.compilerEnv.isIdeMode()) {
                return;
            }
            this.codeBug();
        }
        Object object = (scope = this.currentScope.getDefiningScope(string2)) != null ? scope.getSymbol(string2) : null;
        int n2 = object != null ? ((Symbol)object).getDeclType() : -1;
        String string3 = "msg.var.redecl";
        if (object != null && (n2 == 155 || n == 155 || scope == this.currentScope && n2 == 154)) {
            object = n2 == 155 ? "msg.const.redecl" : (n2 == 154 ? "msg.let.redecl" : (n2 == 123 ? string3 : (n2 == 110 ? "msg.fn.redecl" : "msg.parm.redecl")));
            this.addError((String)object, string2);
            return;
        }
        if (n != 88) {
            if (n != 110 && n != 123) {
                if (n != 154) {
                    if (n != 155) {
                        throw this.codeBug();
                    }
                } else {
                    if (!bl && (this.currentScope.getType() == 113 || this.currentScope instanceof Loop)) {
                        this.addError("msg.let.decl.not.in.block");
                        return;
                    }
                    this.currentScope.putSymbol(new Symbol(n, string2));
                    return;
                }
            }
            if (object != null) {
                if (n2 == 123) {
                    this.addStrictWarning("msg.var.redecl", string2);
                } else if (n2 == 88) {
                    this.addStrictWarning("msg.var.hides.arg", string2);
                }
            } else {
                this.currentScriptOrFn.putSymbol(new Symbol(n, string2));
            }
            return;
        }
        if (object != null) {
            this.addWarning("msg.dup.parms", string2);
        }
        this.currentScriptOrFn.putSymbol(new Symbol(n, string2));
    }

    boolean destructuringArray(ArrayLiteral node, int n, String string2, Node node2, List<String> list) {
        int n2 = n == 155 ? 156 : 8;
        Iterator<AstNode> iterator2 = node.getElements().iterator();
        boolean bl = true;
        int n3 = 0;
        while (iterator2.hasNext()) {
            Object object = iterator2.next();
            if (((Node)object).getType() == 129) {
                ++n3;
                continue;
            }
            node = new Node(36, this.createName(string2), this.createNumber(n3));
            if (((Node)object).getType() == 39) {
                object = ((Node)object).getString();
                node2.addChildToBack(new Node(n2, this.createName(49, (String)object, null), node));
                if (n != -1) {
                    this.defineSymbol(n, (String)object, true);
                    list.add((String)object);
                }
            } else {
                node2.addChildToBack(this.destructuringAssignmentHelper(n, (Node)object, node, this.currentScriptOrFn.getNextTempName()));
            }
            ++n3;
            bl = false;
        }
        return bl;
    }

    Node destructuringAssignmentHelper(int n, Node node, Node node2, String string2) {
        Scope scope = this.createScopeNode(159, node.getLineno());
        scope.addChildToFront(new Node(154, this.createName(39, string2, node2)));
        this.pushScope(scope);
        boolean bl = true;
        this.defineSymbol(154, string2, true);
        node2 = new Node(90);
        scope.addChildToBack(node2);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = node.getType();
        if (n2 != 33 && n2 != 36) {
            if (n2 != 66) {
                if (n2 != 67) {
                    this.reportError("msg.bad.assign.left");
                } else {
                    bl = this.destructuringObject((ObjectLiteral)node, n, string2, node2, arrayList);
                }
            } else {
                bl = this.destructuringArray((ArrayLiteral)node, n, string2, node2, arrayList);
            }
        } else {
            if (n == 123 || n == 154 || n == 155) {
                this.reportError("msg.bad.assign.left");
            }
            node2.addChildToBack(this.simpleAssignment(node, this.createName(string2)));
        }
        if (bl) {
            node2.addChildToBack(this.createNumber(0.0));
        }
        scope.putProp(22, arrayList);
        return scope;
        finally {
            this.popScope();
        }
    }

    boolean destructuringObject(ObjectLiteral object, int n, String string2, Node node, List<String> list) {
        int n2 = n == 155 ? 156 : 8;
        Iterator<ObjectProperty> iterator2 = ((ObjectLiteral)object).getElements().iterator();
        boolean bl = true;
        while (iterator2.hasNext()) {
            block10: {
                int n3;
                Object object2;
                block8: {
                    block9: {
                        block7: {
                            object2 = iterator2.next();
                            object = this.ts;
                            n3 = object != null ? ((TokenStream)object).lineno : 0;
                            object = ((InfixExpression)object2).getLeft();
                            if (!(object instanceof Name)) break block7;
                            object = Node.newString(((Name)object).getIdentifier());
                            object = new Node(33, this.createName(string2), (Node)object);
                            break block8;
                        }
                        if (!(object instanceof StringLiteral)) break block9;
                        object = Node.newString(((StringLiteral)object).getValue());
                        object = new Node(33, this.createName(string2), (Node)object);
                        break block8;
                    }
                    if (!(object instanceof NumberLiteral)) break block10;
                    object = this.createNumber((int)((NumberLiteral)object).getNumber());
                    object = new Node(36, this.createName(string2), (Node)object);
                }
                ((Node)object).setLineno(n3);
                object2 = ((InfixExpression)object2).getRight();
                if (((Node)object2).getType() == 39) {
                    object2 = ((Name)object2).getIdentifier();
                    node.addChildToBack(new Node(n2, this.createName(49, (String)object2, null), (Node)object));
                    if (n != -1) {
                        this.defineSymbol(n, (String)object2, true);
                        list.add((String)object2);
                    }
                } else {
                    node.addChildToBack(this.destructuringAssignmentHelper(n, (Node)object2, (Node)object, this.currentScriptOrFn.getNextTempName()));
                }
                bl = false;
                continue;
            }
            throw this.codeBug();
        }
        return bl;
    }

    public boolean eof() {
        return this.ts.eof();
    }

    public boolean inUseStrictDirective() {
        return this.inUseStrictDirective;
    }

    boolean insideFunction() {
        boolean bl = this.nestingOfFunction != 0;
        return bl;
    }

    String lookupMessage(String string2) {
        return this.lookupMessage(string2, null);
    }

    String lookupMessage(String string2, String string3) {
        string2 = string3 == null ? ScriptRuntime.getMessage0(string2) : ScriptRuntime.getMessage1(string2, string3);
        return string2;
    }

    void markDestructuring(AstNode astNode) {
        if (astNode instanceof DestructuringForm) {
            ((DestructuringForm)((Object)astNode)).setIsDestructuring(true);
        } else if (astNode instanceof ParenthesizedExpression) {
            this.markDestructuring(((ParenthesizedExpression)astNode).getExpression());
        }
    }

    public AstRoot parse(Reader object, String object2, int n) throws IOException {
        if (!this.parseFinished) {
            if (this.compilerEnv.isIdeMode()) {
                return this.parse(this.readFully((Reader)object), (String)object2, n);
            }
            try {
                this.sourceURI = object2;
                this.ts = object2 = new TokenStream(this, (Reader)object, null, n);
                object = this.parse();
                return object;
            }
            finally {
                this.parseFinished = true;
            }
        }
        throw new IllegalStateException("parser reused");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AstRoot parse(String object, String string2, int n) {
        Throwable throwable2222222;
        if (this.parseFinished) {
            throw new IllegalStateException("parser reused");
        }
        this.sourceURI = string2;
        if (this.compilerEnv.isIdeMode()) {
            this.sourceChars = ((String)object).toCharArray();
        }
        this.ts = new TokenStream(this, null, (String)object, n);
        object = this.parse();
        this.parseFinished = true;
        return object;
        {
            catch (Throwable throwable2222222) {
            }
            catch (IOException iOException) {}
            {
                IllegalStateException illegalStateException = new IllegalStateException();
                throw illegalStateException;
            }
        }
        this.parseFinished = true;
        throw throwable2222222;
    }

    void popScope() {
        this.currentScope = this.currentScope.getParentScope();
    }

    void pushScope(Scope scope) {
        Scope scope2 = scope.getParentScope();
        if (scope2 != null) {
            if (scope2 != this.currentScope) {
                this.codeBug();
            }
        } else {
            this.currentScope.addChildScope(scope);
        }
        this.currentScope = scope;
    }

    protected AstNode removeParens(AstNode astNode) {
        while (astNode instanceof ParenthesizedExpression) {
            astNode = ((ParenthesizedExpression)astNode).getExpression();
        }
        return astNode;
    }

    void reportError(String string2) {
        this.reportError(string2, null);
    }

    void reportError(String string2, int n, int n2) {
        this.reportError(string2, null, n, n2);
    }

    void reportError(String string2, String string3) {
        TokenStream tokenStream = this.ts;
        if (tokenStream == null) {
            this.reportError(string2, string3, 1, 1);
        } else {
            this.reportError(string2, string3, tokenStream.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg);
        }
    }

    void reportError(String string2, String string3, int n, int n2) {
        this.addError(string2, string3, n, n2);
        if (this.compilerEnv.recoverFromErrors()) {
            return;
        }
        throw new ParserException();
    }

    public void setDefaultUseStrictDirective(boolean bl) {
        this.defaultUseStrictDirective = bl;
    }

    protected void setIsGenerator() {
        if (this.insideFunction()) {
            ((FunctionNode)this.currentScriptOrFn).setIsGenerator();
        }
    }

    protected void setRequiresActivation() {
        if (this.insideFunction()) {
            ((FunctionNode)this.currentScriptOrFn).setRequiresActivation();
        }
    }

    protected Node simpleAssignment(Node node, Node node2) {
        Node node3;
        int n = node.getType();
        if (n != 33 && n != 36) {
            if (n != 39) {
                if (n == 68) {
                    node = node.getFirstChild();
                    this.checkMutableReference(node);
                    return new Node(69, node, node2);
                }
                throw this.codeBug();
            }
            String string2 = ((Name)node).getIdentifier();
            if (this.inUseStrictDirective && ("eval".equals(string2) || "arguments".equals(string2))) {
                this.reportError("msg.bad.id.strict", string2);
            }
            node.setType(49);
            return new Node(8, node, node2);
        }
        if (node instanceof PropertyGet) {
            node3 = (PropertyGet)node;
            node = ((PropertyGet)node3).getTarget();
            node3 = ((PropertyGet)node3).getProperty();
        } else if (node instanceof ElementGet) {
            node3 = (ElementGet)node;
            node = ((ElementGet)node3).getTarget();
            node3 = ((ElementGet)node3).getElement();
        } else {
            Node node4 = node.getFirstChild();
            node3 = node.getLastChild();
            node = node4;
        }
        if (n == 33) {
            n = 35;
            node3.setType(41);
        } else {
            n = 37;
        }
        return new Node(n, node, node3, node2);
    }

    private static class ConditionData {
        AstNode condition;
        int lp = -1;
        int rp = -1;

        private ConditionData() {
        }
    }

    private static class ParserException
    extends RuntimeException {
        static final long serialVersionUID = 5882582646773765630L;

        private ParserException() {
        }
    }

    protected class PerFunctionVariables {
        private Scope savedCurrentScope;
        private ScriptNode savedCurrentScriptOrFn;
        private int savedEndFlags;
        private boolean savedInForInit;
        private Map<String, LabeledStatement> savedLabelSet;
        private List<Jump> savedLoopAndSwitchSet;
        private List<Loop> savedLoopSet;

        PerFunctionVariables(FunctionNode functionNode) {
            this.savedCurrentScriptOrFn = Parser.this.currentScriptOrFn;
            Parser.this.currentScriptOrFn = functionNode;
            this.savedCurrentScope = Parser.this.currentScope;
            Parser.this.currentScope = functionNode;
            this.savedLabelSet = Parser.this.labelSet;
            Parser.access$202(Parser.this, null);
            this.savedLoopSet = Parser.this.loopSet;
            Parser.access$302(Parser.this, null);
            this.savedLoopAndSwitchSet = Parser.this.loopAndSwitchSet;
            Parser.access$402(Parser.this, null);
            this.savedEndFlags = Parser.this.endFlags;
            Parser.access$502(Parser.this, 0);
            this.savedInForInit = Parser.this.inForInit;
            Parser.access$602(Parser.this, false);
        }

        void restore() {
            Parser.this.currentScriptOrFn = this.savedCurrentScriptOrFn;
            Parser.this.currentScope = this.savedCurrentScope;
            Parser.access$202(Parser.this, this.savedLabelSet);
            Parser.access$302(Parser.this, this.savedLoopSet);
            Parser.access$402(Parser.this, this.savedLoopAndSwitchSet);
            Parser.access$502(Parser.this, this.savedEndFlags);
            Parser.access$602(Parser.this, this.savedInForInit);
        }
    }
}

