/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.util.Map;
import java.util.WeakHashMap;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SecurityController;

public class PolicySecurityController
extends SecurityController {
    private static final Map<CodeSource, Map<ClassLoader, SoftReference<SecureCaller>>> callers;
    private static final byte[] secureCallerImplBytecode;

    static {
        secureCallerImplBytecode = PolicySecurityController.loadBytecode();
        callers = new WeakHashMap<CodeSource, Map<ClassLoader, SoftReference<SecureCaller>>>();
    }

    private static byte[] loadBytecode() {
        CharSequence charSequence = SecureCaller.class.getName();
        Object object = new StringBuilder();
        ((StringBuilder)object).append((String)charSequence);
        ((StringBuilder)object).append("Impl");
        object = new ClassFileWriter(((StringBuilder)object).toString(), (String)charSequence, "<generated>");
        ((ClassFileWriter)object).startMethod("<init>", "()V", (short)1);
        ((ClassFileWriter)object).addALoad(0);
        ((ClassFileWriter)object).addInvoke(183, (String)charSequence, "<init>", "()V");
        ((ClassFileWriter)object).add(177);
        ((ClassFileWriter)object).stopMethod((short)1);
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("(Lorg/mozilla/javascript/Callable;");
        ((StringBuilder)charSequence).append("Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;");
        ((ClassFileWriter)object).startMethod("call", ((StringBuilder)charSequence).toString(), (short)17);
        for (int i = 1; i < 6; ++i) {
            ((ClassFileWriter)object).addALoad(i);
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("(");
        ((StringBuilder)charSequence).append("Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;");
        ((ClassFileWriter)object).addInvoke(185, "org/mozilla/javascript/Callable", "call", ((StringBuilder)charSequence).toString());
        ((ClassFileWriter)object).add(176);
        ((ClassFileWriter)object).stopMethod((short)6);
        return ((ClassFileWriter)object).toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object callWithDomain(Object object, final Context context, Callable callable, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        WeakHashMap<ClassLoader, SoftReference<Object>> weakHashMap;
        final ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getApplicationClassLoader();
            }
        });
        final CodeSource codeSource = (CodeSource)object;
        Object object2 = callers;
        synchronized (object2) {
            object = object2.get(codeSource);
            weakHashMap = object;
            if (object == null) {
                weakHashMap = new WeakHashMap<ClassLoader, SoftReference<Object>>();
                object2.put((CodeSource)codeSource, weakHashMap);
            }
        }
        synchronized (weakHashMap) {
            object = (SoftReference)weakHashMap.get(classLoader);
            object = object != null ? (SecureCaller)((SoftReference)object).get() : null;
            object2 = object;
            if (object == null) {
                try {
                    object = new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            Loader loader = new Loader(classLoader, codeSource);
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append(SecureCaller.class.getName());
                            stringBuilder.append("Impl");
                            return loader.defineClass(stringBuilder.toString(), secureCallerImplBytecode).newInstance();
                        }
                    };
                    object2 = (SecureCaller)AccessController.doPrivileged(object);
                    object = new Object(object2);
                    weakHashMap.put(classLoader, (SoftReference<Object>)object);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    object = new Object(privilegedActionException.getCause());
                    throw object;
                }
            }
            return ((SecureCaller)object2).call(callable, context, scriptable, scriptable2, objectArray);
        }
    }

    @Override
    public GeneratedClassLoader createClassLoader(final ClassLoader classLoader, final Object object) {
        return (Loader)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return new Loader(classLoader, (CodeSource)object);
            }
        });
    }

    @Override
    public Object getDynamicSecurityDomain(Object object) {
        return object;
    }

    @Override
    public Class<?> getStaticSecurityDomainClassInternal() {
        return CodeSource.class;
    }

    private static class Loader
    extends SecureClassLoader
    implements GeneratedClassLoader {
        private final CodeSource codeSource;

        Loader(ClassLoader classLoader, CodeSource codeSource) {
            super(classLoader);
            this.codeSource = codeSource;
        }

        @Override
        public Class<?> defineClass(String string2, byte[] byArray) {
            return this.defineClass(string2, byArray, 0, byArray.length, this.codeSource);
        }

        @Override
        public void linkClass(Class<?> clazz) {
            this.resolveClass(clazz);
        }
    }

    public static abstract class SecureCaller {
        public abstract Object call(Callable var1, Context var2, Scriptable var3, Scriptable var4, Object[] var5);
    }
}

