/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.CharArrayWriter;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Evaluator;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.ScriptStackElement;
import org.mozilla.javascript.SecurityUtilities;
import org.mozilla.javascript.StackStyle;

public abstract class RhinoException
extends RuntimeException {
    private static final Pattern JAVA_STACK_PATTERN = Pattern.compile("_c_(.*)_\\d+");
    static final long serialVersionUID = 1883500631321581169L;
    private static StackStyle stackStyle = StackStyle.RHINO;
    private int columnNumber;
    int[] interpreterLineData;
    Object interpreterStackInfo;
    private int lineNumber;
    private String lineSource;
    private String sourceName;

    static {
        String string2 = System.getProperty("rhino.stack.style");
        if (string2 != null) {
            if ("Rhino".equalsIgnoreCase(string2)) {
                stackStyle = StackStyle.RHINO;
            } else if ("Mozilla".equalsIgnoreCase(string2)) {
                stackStyle = StackStyle.MOZILLA;
            } else if ("V8".equalsIgnoreCase(string2)) {
                stackStyle = StackStyle.V8;
            }
        }
    }

    RhinoException() {
        Evaluator evaluator = Context.createInterpreter();
        if (evaluator != null) {
            evaluator.captureStackInfo(this);
        }
    }

    RhinoException(String object) {
        super((String)object);
        object = Context.createInterpreter();
        if (object != null) {
            object.captureStackInfo(this);
        }
    }

    static String formatStackTrace(ScriptStackElement[] scriptStackElementArray, String object2) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = SecurityUtilities.getSystemProperty("line.separator");
        if (stackStyle == StackStyle.V8 && !"null".equals(object2)) {
            stringBuilder.append((String)object2);
            stringBuilder.append(string2);
        }
        for (ScriptStackElement scriptStackElement : scriptStackElementArray) {
            int n = 1.$SwitchMap$org$mozilla$javascript$StackStyle[stackStyle.ordinal()];
            if (n != 1) {
                if (n != 2) {
                    if (n == 3) {
                        scriptStackElement.renderJavaStyle(stringBuilder);
                    }
                } else {
                    scriptStackElement.renderV8Style(stringBuilder);
                }
            } else {
                scriptStackElement.renderMozillaStyle(stringBuilder);
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private String generateStackTrace() {
        Object object = new CharArrayWriter();
        super.printStackTrace(new PrintWriter((Writer)object));
        object = ((CharArrayWriter)object).toString();
        Evaluator evaluator = Context.createInterpreter();
        if (evaluator != null) {
            return evaluator.getPatchedStack(this, (String)object);
        }
        return null;
    }

    public static StackStyle getStackStyle() {
        return stackStyle;
    }

    public static void setStackStyle(StackStyle stackStyle) {
        RhinoException.stackStyle = stackStyle;
    }

    public static void useMozillaStackStyle(boolean bl) {
        StackStyle stackStyle = bl ? StackStyle.MOZILLA : StackStyle.RHINO;
        RhinoException.stackStyle = stackStyle;
    }

    public static boolean usesMozillaStackStyle() {
        boolean bl = stackStyle == StackStyle.MOZILLA;
        return bl;
    }

    public final int columnNumber() {
        return this.columnNumber;
    }

    public String details() {
        return super.getMessage();
    }

    @Override
    public final String getMessage() {
        CharSequence charSequence = this.details();
        String string2 = charSequence;
        if (this.sourceName != null) {
            if (this.lineNumber <= 0) {
                string2 = charSequence;
            } else {
                charSequence = new StringBuilder((String)charSequence);
                ((StringBuilder)charSequence).append(" (");
                string2 = this.sourceName;
                if (string2 != null) {
                    ((StringBuilder)charSequence).append(string2);
                }
                if (this.lineNumber > 0) {
                    ((StringBuilder)charSequence).append('#');
                    ((StringBuilder)charSequence).append(this.lineNumber);
                }
                ((StringBuilder)charSequence).append(')');
                string2 = ((StringBuilder)charSequence).toString();
            }
        }
        return string2;
    }

    public ScriptStackElement[] getScriptStack() {
        return this.getScriptStack(-1, null);
    }

    /*
     * WARNING - void declaration
     */
    public ScriptStackElement[] getScriptStack(int n, String string2) {
        ArrayList<ScriptStackElement> arrayList = new ArrayList<ScriptStackElement>();
        Object object = null;
        object = this.interpreterStackInfo != null && (object = Context.createInterpreter()) instanceof Interpreter ? ((Interpreter)object).getScriptStackElements(this) : null;
        StackTraceElement[] stackTraceElementArray = this.getStackTrace();
        int n2 = string2 == null ? 1 : 0;
        int n3 = stackTraceElementArray.length;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            int n6;
            int n7;
            int n8;
            block12: {
                StackTraceElement stackTraceElement;
                block10: {
                    void var14_18;
                    ScriptStackElement[] scriptStackElementArray;
                    block13: {
                        block11: {
                            stackTraceElement = stackTraceElementArray[i];
                            scriptStackElementArray = stackTraceElement.getFileName();
                            if (!stackTraceElement.getMethodName().startsWith("_c_") || stackTraceElement.getLineNumber() <= -1 || scriptStackElementArray == null || scriptStackElementArray.endsWith(".java")) break block10;
                            String string3 = stackTraceElement.getMethodName();
                            Matcher matcher = JAVA_STACK_PATTERN.matcher(string3);
                            if (!"_c_script_0".equals(string3) && matcher.find()) {
                                String string4 = matcher.group(1);
                            } else {
                                Object var14_17 = null;
                            }
                            if (n2 != 0 || !string2.equals(var14_18)) break block11;
                            n8 = 1;
                            n7 = n4;
                            n6 = n5;
                            break block12;
                        }
                        n8 = n2;
                        n7 = n4;
                        n6 = n5;
                        if (n2 == 0) break block12;
                        if (n < 0) break block13;
                        n8 = n2;
                        n7 = n4;
                        n6 = n5;
                        if (n5 >= n) break block12;
                    }
                    arrayList.add(new ScriptStackElement((String)scriptStackElementArray, (String)var14_18, stackTraceElement.getLineNumber()));
                    n6 = n5 + 1;
                    n8 = n2;
                    n7 = n4;
                    break block12;
                }
                n8 = n2;
                n7 = n4;
                n6 = n5;
                if (!"org.mozilla.javascript.Interpreter".equals(stackTraceElement.getClassName())) break block12;
                n8 = n2;
                n7 = n4;
                n6 = n5;
                if (!"interpretLoop".equals(stackTraceElement.getMethodName())) break block12;
                n8 = n2;
                n7 = n4;
                n6 = n5;
                if (object == null) break block12;
                n8 = n2;
                n7 = n4;
                n6 = n5;
                if (((ScriptStackElement[][])object).length <= n4) break block12;
                for (ScriptStackElement scriptStackElement : object[n4]) {
                    block15: {
                        block16: {
                            block14: {
                                if (n2 != 0 || !string2.equals(scriptStackElement.functionName)) break block14;
                                n7 = 1;
                                n8 = n5;
                                break block15;
                            }
                            n7 = n2;
                            n8 = n5;
                            if (n2 == 0) break block15;
                            if (n < 0) break block16;
                            n7 = n2;
                            n8 = n5;
                            if (n5 >= n) break block15;
                        }
                        arrayList.add(scriptStackElement);
                        n8 = n5 + 1;
                        n7 = n2;
                    }
                    n2 = n7;
                    n5 = n8;
                }
                n7 = n4 + 1;
                n6 = n5;
                n8 = n2;
            }
            n2 = n8;
            n4 = n7;
            n5 = n6;
        }
        return arrayList.toArray(new ScriptStackElement[arrayList.size()]);
    }

    public String getScriptStackTrace() {
        return this.getScriptStackTrace(-1, null);
    }

    public String getScriptStackTrace(int n, String string2) {
        return RhinoException.formatStackTrace(this.getScriptStack(n, string2), this.details());
    }

    @Deprecated
    public String getScriptStackTrace(FilenameFilter filenameFilter) {
        return this.getScriptStackTrace();
    }

    public final void initColumnNumber(int n) {
        if (n > 0) {
            if (this.columnNumber <= 0) {
                this.columnNumber = n;
                return;
            }
            throw new IllegalStateException();
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    public final void initLineNumber(int n) {
        if (n > 0) {
            if (this.lineNumber <= 0) {
                this.lineNumber = n;
                return;
            }
            throw new IllegalStateException();
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    public final void initLineSource(String string2) {
        if (string2 != null) {
            if (this.lineSource == null) {
                this.lineSource = string2;
                return;
            }
            throw new IllegalStateException();
        }
        throw new IllegalArgumentException();
    }

    public final void initSourceName(String string2) {
        if (string2 != null) {
            if (this.sourceName == null) {
                this.sourceName = string2;
                return;
            }
            throw new IllegalStateException();
        }
        throw new IllegalArgumentException();
    }

    public final int lineNumber() {
        return this.lineNumber;
    }

    public final String lineSource() {
        return this.lineSource;
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        if (this.interpreterStackInfo == null) {
            super.printStackTrace(printStream);
        } else {
            printStream.print(this.generateStackTrace());
        }
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        if (this.interpreterStackInfo == null) {
            super.printStackTrace(printWriter);
        } else {
            printWriter.print(this.generateStackTrace());
        }
    }

    final void recordErrorOrigin(String string2, int n, String string3, int n2) {
        int n3 = n;
        if (n == -1) {
            n3 = 0;
        }
        if (string2 != null) {
            this.initSourceName(string2);
        }
        if (n3 != 0) {
            this.initLineNumber(n3);
        }
        if (string3 != null) {
            this.initLineSource(string3);
        }
        if (n2 != 0) {
            this.initColumnNumber(n2);
        }
    }

    public final String sourceName() {
        return this.sourceName;
    }
}

