/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.mozilla.javascript.Arguments;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.DToA;
import org.mozilla.javascript.DefaultErrorReporter;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Evaluator;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.LazilyLoadedCtor;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeArrayIterator;
import org.mozilla.javascript.NativeBoolean;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeDate;
import org.mozilla.javascript.NativeError;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeIterator;
import org.mozilla.javascript.NativeJSON;
import org.mozilla.javascript.NativeMath;
import org.mozilla.javascript.NativeNumber;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeScript;
import org.mozilla.javascript.NativeString;
import org.mozilla.javascript.NativeStringIterator;
import org.mozilla.javascript.NativeSymbol;
import org.mozilla.javascript.NativeWith;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Ref;
import org.mozilla.javascript.RefCallable;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SpecialRef;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.v8dtoa.DoubleConversion;
import org.mozilla.javascript.v8dtoa.FastDtoa;
import org.mozilla.javascript.xml.XMLLib;
import org.mozilla.javascript.xml.XMLObject;

public class ScriptRuntime {
    public static final Class<?> BooleanClass;
    public static final Class<?> ByteClass;
    public static final Class<?> CharacterClass;
    public static final Class<?> ClassClass;
    public static final Class<?> ContextClass;
    public static final Class<?> ContextFactoryClass;
    private static final String DEFAULT_NS_TAG = "__default_namespace__";
    public static final Class<?> DateClass;
    public static final Class<?> DoubleClass;
    public static final int ENUMERATE_ARRAY = 2;
    public static final int ENUMERATE_ARRAY_NO_ITERATOR = 5;
    public static final int ENUMERATE_KEYS = 0;
    public static final int ENUMERATE_KEYS_NO_ITERATOR = 3;
    public static final int ENUMERATE_VALUES = 1;
    public static final int ENUMERATE_VALUES_IN_ORDER = 6;
    public static final int ENUMERATE_VALUES_NO_ITERATOR = 4;
    public static final Class<?> FloatClass;
    public static final Class<?> FunctionClass;
    public static final Class<?> IntegerClass;
    private static final Object LIBRARY_SCOPE_KEY;
    public static final Class<?> LongClass;
    public static final double NaN;
    public static final Double NaNobj;
    public static final Class<?> NumberClass;
    public static final Class<?> ObjectClass;
    public static Locale ROOT_LOCALE;
    public static final Class<Scriptable> ScriptableClass;
    public static final Class<?> ScriptableObjectClass;
    public static final Class<?> ShortClass;
    public static final Class<?> StringClass;
    public static final Object[] emptyArgs;
    public static final String[] emptyStrings;
    public static MessageProvider messageProvider;
    public static final double negativeZero;

    static {
        double d;
        BooleanClass = Kit.classOrNull("java.lang.Boolean");
        ByteClass = Kit.classOrNull("java.lang.Byte");
        CharacterClass = Kit.classOrNull("java.lang.Character");
        ClassClass = Kit.classOrNull("java.lang.Class");
        DoubleClass = Kit.classOrNull("java.lang.Double");
        FloatClass = Kit.classOrNull("java.lang.Float");
        IntegerClass = Kit.classOrNull("java.lang.Integer");
        LongClass = Kit.classOrNull("java.lang.Long");
        NumberClass = Kit.classOrNull("java.lang.Number");
        ObjectClass = Kit.classOrNull("java.lang.Object");
        ShortClass = Kit.classOrNull("java.lang.Short");
        StringClass = Kit.classOrNull("java.lang.String");
        DateClass = Kit.classOrNull("java.util.Date");
        ContextClass = Kit.classOrNull("org.mozilla.javascript.Context");
        ContextFactoryClass = Kit.classOrNull("org.mozilla.javascript.ContextFactory");
        FunctionClass = Kit.classOrNull("org.mozilla.javascript.Function");
        ScriptableObjectClass = Kit.classOrNull("org.mozilla.javascript.ScriptableObject");
        ScriptableClass = Scriptable.class;
        ROOT_LOCALE = new Locale("");
        LIBRARY_SCOPE_KEY = "LIBRARY_SCOPE";
        NaN = d = Double.longBitsToDouble(9221120237041090560L);
        negativeZero = Double.longBitsToDouble(Long.MIN_VALUE);
        NaNobj = new Double(d);
        messageProvider = new DefaultMessageProvider();
        emptyArgs = new Object[0];
        emptyStrings = new String[0];
    }

    protected ScriptRuntime() {
    }

    public static CharSequence add(CharSequence charSequence, Object object) {
        return new ConsString(charSequence, ScriptRuntime.toCharSequence(object));
    }

    public static CharSequence add(Object object, CharSequence charSequence) {
        return new ConsString(ScriptRuntime.toCharSequence(object), charSequence);
    }

    public static Object add(Object object, Object object2, Context object3) {
        Object object4;
        if (object instanceof Number && object2 instanceof Number) {
            return ScriptRuntime.wrapNumber(((Number)object).doubleValue() + ((Number)object2).doubleValue());
        }
        if (object instanceof XMLObject && (object4 = ((XMLObject)object).addValues((Context)object3, true, object2)) != Scriptable.NOT_FOUND) {
            return object4;
        }
        if (object2 instanceof XMLObject && (object3 = ((XMLObject)object2).addValues((Context)object3, false, object)) != Scriptable.NOT_FOUND) {
            return object3;
        }
        if (!(object instanceof Symbol) && !(object2 instanceof Symbol)) {
            object3 = object;
            if (object instanceof Scriptable) {
                object3 = ((Scriptable)object).getDefaultValue(null);
            }
            object = object2;
            if (object2 instanceof Scriptable) {
                object = ((Scriptable)object2).getDefaultValue(null);
            }
            if (!(object3 instanceof CharSequence) && !(object instanceof CharSequence)) {
                if (object3 instanceof Number && object instanceof Number) {
                    return ScriptRuntime.wrapNumber(((Number)object3).doubleValue() + ((Number)object).doubleValue());
                }
                return ScriptRuntime.wrapNumber(ScriptRuntime.toNumber(object3) + ScriptRuntime.toNumber(object));
            }
            return new ConsString(ScriptRuntime.toCharSequence(object3), ScriptRuntime.toCharSequence(object));
        }
        throw ScriptRuntime.typeError0("msg.not.a.number");
    }

    public static void addInstructionCount(Context context, int n) {
        context.instructionCount += n;
        if (context.instructionCount > context.instructionThreshold) {
            context.observeInstructionCount(context.instructionCount);
            context.instructionCount = 0;
        }
    }

    public static Object applyOrCall(boolean bl, Context context, Scriptable scriptable, Scriptable object, Object[] objectArray) {
        int n = objectArray.length;
        Callable callable = ScriptRuntime.getCallable((Scriptable)object);
        object = n != 0 ? (context.hasFeature(15) ? ScriptRuntime.toObjectOrNull(context, objectArray[0], scriptable) : (objectArray[0] == Undefined.instance ? Undefined.SCRIPTABLE_UNDEFINED : ScriptRuntime.toObjectOrNull(context, objectArray[0], scriptable))) : null;
        Object object2 = object;
        if (object == null) {
            object2 = object;
            if (context.hasFeature(15)) {
                object2 = ScriptRuntime.getTopCallScope(context);
            }
        }
        if (bl) {
            object = n <= 1 ? emptyArgs : ScriptRuntime.getApplyArguments(context, objectArray[1]);
        } else if (n <= 1) {
            object = emptyArgs;
        } else {
            object = new Object[--n];
            System.arraycopy(objectArray, 1, object, 0, n);
        }
        return callable.call(context, scriptable, (Scriptable)object2, (Object[])object);
    }

    /*
     * Unable to fully structure code
     */
    public static Scriptable bind(Context var0, Scriptable var1_1, String var2_2) {
        block14: {
            var3_3 = var1_1.getParentScope();
            var4_4 = null;
            var5_5 = var1_1;
            if (var3_3 == null) break block14;
            var5_5 = null;
            var4_4 = var1_1;
            var1_1 = var3_3;
            while (true) {
                block15: {
                    var3_3 = var1_1;
                    var6_6 = var4_4;
                    if (!(var4_4 instanceof NativeWith)) break;
                    var3_3 = var4_4.getPrototype();
                    if (var3_3 instanceof XMLObject) {
                        if ((var3_3 = (XMLObject)var3_3).has(var0, var2_2)) {
                            return var3_3;
                        }
                        var4_4 = var5_5;
                        if (var5_5 == null) {
                            var4_4 = var3_3;
                        }
                    } else {
                        var4_4 = var5_5;
                        if (ScriptableObject.hasProperty(var3_3, var2_2)) {
                            return var3_3;
                        }
                    }
                    if ((var5_5 = var1_1.getParentScope()) != null) break block15;
                    var5_5 = var4_4;
                    ** GOTO lbl38
                }
                var3_3 = var1_1;
                var1_1 = var5_5;
                var5_5 = var4_4;
                var4_4 = var3_3;
            }
            while (true) {
                block16: {
                    var1_1 = var3_3;
                    if (ScriptableObject.hasProperty(var6_6, var2_2)) {
                        return var6_6;
                    }
                    var3_3 = var1_1.getParentScope();
                    if (var3_3 != null) break block16;
lbl38:
                    // 2 sources

                    var4_4 = var5_5;
                    var5_5 = var1_1;
                    break;
                }
                var6_6 = var1_1;
            }
        }
        var1_1 = var5_5;
        if (var0.useDynamicScope) {
            var1_1 = ScriptRuntime.checkDynamicScope(var0.topCallScope, var5_5);
        }
        if (ScriptableObject.hasProperty(var1_1, var2_2)) {
            return var1_1;
        }
        return var4_4;
    }

    @Deprecated
    public static Object call(Context context, Object object, Object object2, Object[] objectArray, Scriptable scriptable) {
        if (object instanceof Function) {
            object = (Function)object;
            if ((object2 = ScriptRuntime.toObjectOrNull(context, object2, scriptable)) != null) {
                return object.call(context, scriptable, (Scriptable)object2, objectArray);
            }
            throw ScriptRuntime.undefCallError(object2, "function");
        }
        throw ScriptRuntime.notFunctionError(ScriptRuntime.toString(object));
    }

    public static Ref callRef(Callable callable, Scriptable object, Object[] objectArray, Context context) {
        if (callable instanceof RefCallable) {
            if ((object = (callable = (RefCallable)callable).refCall(context, (Scriptable)object, objectArray)) != null) {
                return object;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append(callable.getClass().getName());
            ((StringBuilder)object).append(".refCall() returned null");
            throw new IllegalStateException(((StringBuilder)object).toString());
        }
        throw ScriptRuntime.constructError("ReferenceError", ScriptRuntime.getMessage1("msg.no.ref.from.function", ScriptRuntime.toString(callable)));
    }

    public static Object callSpecial(Context context, Callable callable, Scriptable scriptable, Object[] objectArray, Scriptable scriptable2, Scriptable scriptable3, int n, String string2, int n2) {
        block7: {
            block8: {
                block6: {
                    block5: {
                        if (n != 1) break block5;
                        if (scriptable.getParentScope() == null && NativeGlobal.isEvalFunction(callable)) {
                            return ScriptRuntime.evalSpecial(context, scriptable2, scriptable3, objectArray, string2, n2);
                        }
                        break block6;
                    }
                    if (n != 2) break block7;
                    if (NativeWith.isWithFunction(callable)) break block8;
                }
                return callable.call(context, scriptable2, scriptable, objectArray);
            }
            throw Context.reportRuntimeError1("msg.only.from.new", "With");
        }
        throw Kit.codeBug();
    }

    static void checkDeprecated(Context object, String string2) {
        block3: {
            block2: {
                int n = ((Context)object).getLanguageVersion();
                if (n < 140 && n != 0) break block2;
                object = ScriptRuntime.getMessage1("msg.deprec.ctor", string2);
                if (n != 0) break block3;
                Context.reportWarning((String)object);
            }
            return;
        }
        throw Context.reportRuntimeError((String)object);
    }

    static Scriptable checkDynamicScope(Scriptable scriptable, Scriptable scriptable2) {
        Scriptable scriptable3;
        if (scriptable == scriptable2) {
            return scriptable;
        }
        Scriptable scriptable4 = scriptable;
        do {
            if ((scriptable3 = scriptable4.getPrototype()) == scriptable2) {
                return scriptable;
            }
            scriptable4 = scriptable3;
        } while (scriptable3 != null);
        return scriptable2;
    }

    public static RegExpProxy checkRegExpProxy(Context object) {
        if ((object = ScriptRuntime.getRegExpProxy((Context)object)) != null) {
            return object;
        }
        throw Context.reportRuntimeError0("msg.no.regexp");
    }

    public static boolean cmp_LE(Object object, Object object2) {
        block9: {
            double d;
            double d2;
            boolean bl;
            boolean bl2;
            block8: {
                block7: {
                    boolean bl3 = object instanceof Number;
                    bl2 = true;
                    bl = true;
                    if (!bl3 || !(object2 instanceof Number)) break block7;
                    d2 = ((Number)object).doubleValue();
                    d = ((Number)object2).doubleValue();
                    break block8;
                }
                if (object instanceof Symbol || object2 instanceof Symbol) break block9;
                Object object3 = object;
                if (object instanceof Scriptable) {
                    object3 = ((Scriptable)object).getDefaultValue(NumberClass);
                }
                object = object2;
                if (object2 instanceof Scriptable) {
                    object = ((Scriptable)object2).getDefaultValue(NumberClass);
                }
                if (object3 instanceof CharSequence && object instanceof CharSequence) {
                    if (object3.toString().compareTo(object.toString()) > 0) {
                        bl = false;
                    }
                    return bl;
                }
                d2 = ScriptRuntime.toNumber(object3);
                d = ScriptRuntime.toNumber(object);
            }
            bl = d2 <= d ? bl2 : false;
            return bl;
        }
        throw ScriptRuntime.typeError0("msg.compare.symbol");
    }

    public static boolean cmp_LT(Object object, Object object2) {
        block9: {
            double d;
            double d2;
            boolean bl;
            boolean bl2;
            block8: {
                block7: {
                    boolean bl3 = object instanceof Number;
                    bl2 = true;
                    bl = true;
                    if (!bl3 || !(object2 instanceof Number)) break block7;
                    d2 = ((Number)object).doubleValue();
                    d = ((Number)object2).doubleValue();
                    break block8;
                }
                if (object instanceof Symbol || object2 instanceof Symbol) break block9;
                Object object3 = object;
                if (object instanceof Scriptable) {
                    object3 = ((Scriptable)object).getDefaultValue(NumberClass);
                }
                object = object2;
                if (object2 instanceof Scriptable) {
                    object = ((Scriptable)object2).getDefaultValue(NumberClass);
                }
                if (object3 instanceof CharSequence && object instanceof CharSequence) {
                    if (object3.toString().compareTo(object.toString()) >= 0) {
                        bl = false;
                    }
                    return bl;
                }
                d2 = ScriptRuntime.toNumber(object3);
                d = ScriptRuntime.toNumber(object);
            }
            bl = d2 < d ? bl2 : false;
            return bl;
        }
        throw ScriptRuntime.typeError0("msg.compare.symbol");
    }

    public static EcmaError constructError(String string2, String string3) {
        int[] nArray = new int[1];
        return ScriptRuntime.constructError(string2, string3, Context.getSourcePositionFromStack(nArray), nArray[0], null, 0);
    }

    public static EcmaError constructError(String string2, String string3, int n) {
        int[] nArray = new int[1];
        String string4 = Context.getSourcePositionFromStack(nArray);
        if (nArray[0] != 0) {
            nArray[0] = nArray[0] + n;
        }
        return ScriptRuntime.constructError(string2, string3, string4, nArray[0], null, 0);
    }

    public static EcmaError constructError(String string2, String string3, String string4, int n, String string5, int n2) {
        return new EcmaError(string2, string3, string4, n, string5, n2);
    }

    public static Scriptable createArrowFunctionActivation(NativeFunction nativeFunction, Scriptable scriptable, Object[] objectArray, boolean bl) {
        return new NativeCall(nativeFunction, scriptable, objectArray, true, bl);
    }

    @Deprecated
    public static Scriptable createFunctionActivation(NativeFunction nativeFunction, Scriptable scriptable, Object[] objectArray) {
        return ScriptRuntime.createFunctionActivation(nativeFunction, scriptable, objectArray, false);
    }

    public static Scriptable createFunctionActivation(NativeFunction nativeFunction, Scriptable scriptable, Object[] objectArray, boolean bl) {
        return new NativeCall(nativeFunction, scriptable, objectArray, false, bl);
    }

    private static XMLLib currentXMLLib(Context context) {
        if (context.topCallScope != null) {
            XMLLib xMLLib;
            XMLLib xMLLib2 = xMLLib = context.cachedXMLLib;
            if (xMLLib == null) {
                xMLLib2 = XMLLib.extractFromScope(context.topCallScope);
                if (xMLLib2 != null) {
                    context.cachedXMLLib = xMLLib2;
                } else {
                    throw new IllegalStateException();
                }
            }
            return xMLLib2;
        }
        throw new IllegalStateException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String defaultObjectToSource(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] object) {
        boolean bl;
        boolean bl2;
        ObjToIntMap objToIntMap = context.iterating;
        int n = 0;
        if (objToIntMap == null) {
            context.iterating = new ObjToIntMap(31);
            bl2 = true;
            bl = false;
        } else {
            bl = context.iterating.has(scriptable2);
            bl2 = false;
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        if (bl2) {
            stringBuilder.append("(");
        }
        stringBuilder.append('{');
        if (!bl) {
            context.iterating.intern(scriptable2);
            return scriptable2.getIds();
        }
        if (bl2) {
            context.iterating = null;
        }
        stringBuilder.append('}');
        if (!bl2) return stringBuilder.toString();
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    static String defaultObjectToString(Scriptable scriptable) {
        if (scriptable == null) {
            return "[object Null]";
        }
        if (Undefined.isUndefined(scriptable)) {
            return "[object Undefined]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[object ");
        stringBuilder.append(scriptable.getClassName());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Deprecated
    public static Object delete(Object object, Object object2, Context context) {
        return ScriptRuntime.delete(object, object2, context, false);
    }

    public static Object delete(Object object, Object object2, Context context, Scriptable scriptable, boolean bl) {
        if ((scriptable = ScriptRuntime.toObjectOrNull(context, object, scriptable)) == null) {
            if (bl) {
                return Boolean.TRUE;
            }
            throw ScriptRuntime.undefDeleteError(object, object2);
        }
        return ScriptRuntime.wrapBoolean(ScriptRuntime.deleteObjectElem(scriptable, object2, context));
    }

    @Deprecated
    public static Object delete(Object object, Object object2, Context context, boolean bl) {
        return ScriptRuntime.delete(object, object2, context, ScriptRuntime.getTopCallScope(context), bl);
    }

    public static boolean deleteObjectElem(Scriptable scriptable, Object object, Context object2) {
        if (ScriptRuntime.isSymbol(object)) {
            object2 = ScriptableObject.ensureSymbolScriptable(scriptable);
            object = (Symbol)object;
            object2.delete((Symbol)object);
            return object2.has((Symbol)object, scriptable) ^ true;
        }
        if ((object = ScriptRuntime.toStringIdOrIndex((Context)object2, object)) == null) {
            int n = ScriptRuntime.lastIndexResult((Context)object2);
            scriptable.delete(n);
            return scriptable.has(n, scriptable) ^ true;
        }
        scriptable.delete((String)object);
        return scriptable.has((String)object, scriptable) ^ true;
    }

    private static Object doScriptableIncrDecr(Scriptable scriptable, String string2, Scriptable scriptable2, Object object, int n) {
        double d;
        boolean bl = (n & 2) != 0;
        if (object instanceof Number) {
            d = ((Number)object).doubleValue();
        } else {
            double d2;
            d = d2 = ScriptRuntime.toNumber(object);
            if (bl) {
                object = ScriptRuntime.wrapNumber(d2);
                d = d2;
            }
        }
        d = (n & 1) == 0 ? (d += 1.0) : (d -= 1.0);
        Number number = ScriptRuntime.wrapNumber(d);
        scriptable.put(string2, scriptable2, (Object)number);
        if (bl) {
            return object;
        }
        return number;
    }

    public static Object doTopCall(Callable callable, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        return ScriptRuntime.doTopCall(callable, context, scriptable, scriptable2, objectArray, context.isTopLevelStrict);
    }

    public static Object doTopCall(Callable object, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray, boolean bl) {
        if (scriptable != null) {
            if (context.topCallScope == null) {
                block5: {
                    context.topCallScope = ScriptableObject.getTopLevelScope(scriptable);
                    context.useDynamicScope = context.hasFeature(7);
                    boolean bl2 = context.isTopLevelStrict;
                    context.isTopLevelStrict = bl;
                    ContextFactory contextFactory = context.getFactory();
                    try {
                        object = contextFactory.doTopCall((Callable)object, context, scriptable, scriptable2, objectArray);
                        context.topCallScope = null;
                        context.cachedXMLLib = null;
                        context.isTopLevelStrict = bl2;
                        if (context.currentActivationCall != null) break block5;
                        return object;
                    }
                    catch (Throwable throwable) {
                        context.topCallScope = null;
                        context.cachedXMLLib = null;
                        context.isTopLevelStrict = bl2;
                        if (context.currentActivationCall != null) {
                            throw new IllegalStateException();
                        }
                        throw throwable;
                    }
                }
                throw new IllegalStateException();
            }
            throw new IllegalStateException();
        }
        throw new IllegalArgumentException();
    }

    @Deprecated
    public static Object elemIncrDecr(Object object, Object object2, Context context, int n) {
        return ScriptRuntime.elemIncrDecr(object, object2, context, ScriptRuntime.getTopCallScope(context), n);
    }

    public static Object elemIncrDecr(Object object, Object object2, Context context, Scriptable scriptable, int n) {
        double d;
        Object object3 = ScriptRuntime.getObjectElem(object, object2, context, scriptable);
        boolean bl = (n & 2) != 0;
        if (object3 instanceof Number) {
            d = ((Number)object3).doubleValue();
        } else {
            double d2;
            d = d2 = ScriptRuntime.toNumber(object3);
            if (bl) {
                object3 = ScriptRuntime.wrapNumber(d2);
                d = d2;
            }
        }
        d = (n & 1) == 0 ? (d += 1.0) : (d -= 1.0);
        Number number = ScriptRuntime.wrapNumber(d);
        ScriptRuntime.setObjectElem(object, object2, number, context, scriptable);
        if (bl) {
            return object3;
        }
        return number;
    }

    public static void enterActivationFunction(Context context, Scriptable scriptable) {
        if (context.topCallScope != null) {
            scriptable = (NativeCall)scriptable;
            ((NativeCall)scriptable).parentActivationCall = context.currentActivationCall;
            context.currentActivationCall = scriptable;
            ((NativeCall)scriptable).defineAttributesForArguments();
            return;
        }
        throw new IllegalStateException();
    }

    public static Scriptable enterDotQuery(Object object, Scriptable scriptable) {
        if (object instanceof XMLObject) {
            return ((XMLObject)object).enterDotQuery(scriptable);
        }
        throw ScriptRuntime.notXmlError(object);
    }

    public static Scriptable enterWith(Object object, Context object2, Scriptable scriptable) {
        if ((object2 = ScriptRuntime.toObjectOrNull((Context)object2, object, scriptable)) != null) {
            if (object2 instanceof XMLObject) {
                return ((XMLObject)object2).enterWith(scriptable);
            }
            return new NativeWith(scriptable, (Scriptable)object2);
        }
        throw ScriptRuntime.typeError1("msg.undef.with", ScriptRuntime.toString(object));
    }

    private static void enumChangeObject(IdEnumeration idEnumeration) {
        Object[] objectArray = null;
        while (idEnumeration.obj != null && (objectArray = idEnumeration.obj.getIds()).length == 0) {
            idEnumeration.obj = idEnumeration.obj.getPrototype();
        }
        if (idEnumeration.obj != null && idEnumeration.ids != null) {
            Object[] objectArray2 = idEnumeration.ids;
            int n = objectArray2.length;
            if (idEnumeration.used == null) {
                idEnumeration.used = new ObjToIntMap(n);
            }
            for (int i = 0; i != n; ++i) {
                idEnumeration.used.intern(objectArray2[i]);
            }
        }
        idEnumeration.ids = objectArray;
        idEnumeration.index = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object enumId(Object object, Context context) {
        IdEnumeration idEnumeration = (IdEnumeration)object;
        if (idEnumeration.iterator != null) {
            return idEnumeration.currentId;
        }
        int n = idEnumeration.enumType;
        if (n == 0) return idEnumeration.currentId;
        if (n == 1) return ScriptRuntime.enumValue(object, context);
        if (n != 2) {
            if (n == 3) return idEnumeration.currentId;
            if (n == 4) return ScriptRuntime.enumValue(object, context);
            if (n != 5) {
                throw Kit.codeBug();
            }
        }
        Object object2 = idEnumeration.currentId;
        object = ScriptRuntime.enumValue(object, context);
        return context.newArray(ScriptableObject.getTopLevelScope(idEnumeration.obj), new Object[]{object2, object});
    }

    @Deprecated
    public static Object enumInit(Object object, Context context, int n) {
        return ScriptRuntime.enumInit(object, context, ScriptRuntime.getTopCallScope(context), n);
    }

    public static Object enumInit(Object object, Context context, Scriptable scriptable, int n) {
        IdEnumeration idEnumeration = new IdEnumeration();
        idEnumeration.obj = ScriptRuntime.toObjectOrNull(context, object, scriptable);
        if (n == 6) {
            idEnumeration.enumType = n;
            idEnumeration.iterator = null;
            return ScriptRuntime.enumInitInOrder(context, idEnumeration);
        }
        if (idEnumeration.obj == null) {
            return idEnumeration;
        }
        idEnumeration.enumType = n;
        idEnumeration.iterator = null;
        if (n != 3 && n != 4 && n != 5) {
            scriptable = idEnumeration.obj.getParentScope();
            object = idEnumeration.obj;
            boolean bl = n == 0;
            idEnumeration.iterator = ScriptRuntime.toIterator(context, scriptable, (Scriptable)object, bl);
        }
        if (idEnumeration.iterator == null) {
            ScriptRuntime.enumChangeObject(idEnumeration);
        }
        return idEnumeration;
    }

    @Deprecated
    public static Object enumInit(Object object, Context context, boolean bl) {
        return ScriptRuntime.enumInit(object, context, bl ? 1 : 0);
    }

    private static Object enumInitInOrder(Context object, IdEnumeration idEnumeration) {
        if (idEnumeration.obj instanceof ScriptableObject) {
            Object object2 = (ScriptableObject)idEnumeration.obj;
            if (ScriptableObject.hasProperty((Scriptable)object2, SymbolKey.ITERATOR)) {
                if ((object2 = ScriptableObject.getProperty((Scriptable)object2, SymbolKey.ITERATOR)) instanceof Callable) {
                    if ((object = ((Callable)object2).call((Context)object, idEnumeration.obj.getParentScope(), idEnumeration.obj, new Object[0])) instanceof Scriptable) {
                        idEnumeration.iterator = (Scriptable)object;
                        return idEnumeration;
                    }
                    throw ScriptRuntime.typeError1("msg.not.iterable", ScriptRuntime.toString(idEnumeration.obj));
                }
                throw ScriptRuntime.typeError1("msg.not.iterable", ScriptRuntime.toString(idEnumeration.obj));
            }
            throw ScriptRuntime.typeError1("msg.not.iterable", ScriptRuntime.toString(idEnumeration.obj));
        }
        throw ScriptRuntime.typeError1("msg.not.iterable", ScriptRuntime.toString(idEnumeration.obj));
    }

    public static Boolean enumNext(Object object) {
        block10: {
            int n;
            IdEnumeration idEnumeration = (IdEnumeration)object;
            if (idEnumeration.iterator != null) {
                if (idEnumeration.enumType == 6) {
                    return ScriptRuntime.enumNextInOrder(idEnumeration);
                }
                object = ScriptableObject.getProperty(idEnumeration.iterator, "next");
                if (!(object instanceof Callable)) {
                    return Boolean.FALSE;
                }
                Callable callable = (Callable)object;
                object = Context.getContext();
                try {
                    idEnumeration.currentId = callable.call((Context)object, idEnumeration.iterator.getParentScope(), idEnumeration.iterator, emptyArgs);
                    object = Boolean.TRUE;
                    return object;
                }
                catch (JavaScriptException javaScriptException) {
                    if (javaScriptException.getValue() instanceof NativeIterator.StopIteration) {
                        return Boolean.FALSE;
                    }
                    throw javaScriptException;
                }
            }
            while (true) {
                if (idEnumeration.obj == null) {
                    return Boolean.FALSE;
                }
                if (idEnumeration.index == idEnumeration.ids.length) {
                    idEnumeration.obj = idEnumeration.obj.getPrototype();
                    ScriptRuntime.enumChangeObject(idEnumeration);
                    continue;
                }
                object = idEnumeration.ids;
                n = idEnumeration.index;
                idEnumeration.index = n + 1;
                object = object[n];
                if (idEnumeration.used != null && idEnumeration.used.has(object) || object instanceof Symbol) continue;
                if (object instanceof String) {
                    if (!idEnumeration.obj.has((String)(object = (String)object), idEnumeration.obj)) continue;
                    idEnumeration.currentId = object;
                    break block10;
                }
                n = ((Number)object).intValue();
                if (idEnumeration.obj.has(n, idEnumeration.obj)) break;
            }
            object = idEnumeration.enumNumbers ? Integer.valueOf(n) : String.valueOf(n);
            idEnumeration.currentId = object;
        }
        return Boolean.TRUE;
    }

    private static Boolean enumNextInOrder(IdEnumeration idEnumeration) {
        Object object = ScriptableObject.getProperty(idEnumeration.iterator, "next");
        if (object instanceof Callable) {
            Callable callable = (Callable)object;
            object = Context.getContext();
            Object object2 = idEnumeration.iterator.getParentScope();
            if ((object2 = ScriptableObject.getProperty((Scriptable)(object = ScriptRuntime.toObject((Context)object, (Scriptable)object2, callable.call((Context)object, (Scriptable)object2, idEnumeration.iterator, emptyArgs))), "done")) != ScriptableObject.NOT_FOUND && ScriptRuntime.toBoolean(object2)) {
                return Boolean.FALSE;
            }
            idEnumeration.currentId = ScriptableObject.getProperty((Scriptable)object, "value");
            return Boolean.TRUE;
        }
        throw ScriptRuntime.notFunctionError(idEnumeration.iterator, "next");
    }

    public static Object enumValue(Object object, Context context) {
        object = (IdEnumeration)object;
        if (ScriptRuntime.isSymbol(((IdEnumeration)object).currentId)) {
            object = ScriptableObject.ensureSymbolScriptable(((IdEnumeration)object).obj).get((Symbol)((IdEnumeration)object).currentId, ((IdEnumeration)object).obj);
        } else {
            String string2 = ScriptRuntime.toStringIdOrIndex(context, ((IdEnumeration)object).currentId);
            if (string2 == null) {
                int n = ScriptRuntime.lastIndexResult(context);
                object = ((IdEnumeration)object).obj.get(n, ((IdEnumeration)object).obj);
            } else {
                object = ((IdEnumeration)object).obj.get(string2, ((IdEnumeration)object).obj);
            }
        }
        return object;
    }

    public static boolean eq(Object object, Object object2) {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        if (object != null && object != Undefined.instance) {
            if (object instanceof Number) {
                return ScriptRuntime.eqNumber(((Number)object).doubleValue(), object2);
            }
            if (object == object2) {
                return true;
            }
            if (object instanceof CharSequence) {
                return ScriptRuntime.eqString((CharSequence)object, object2);
            }
            boolean bl4 = object instanceof Boolean;
            double d = 1.0;
            if (bl4) {
                bl = (Boolean)object;
                if (object2 instanceof Boolean) {
                    if (bl != (Boolean)object2) {
                        bl3 = false;
                    }
                    return bl3;
                }
                if (object2 instanceof ScriptableObject && (object = ((ScriptableObject)object2).equivalentValues(object)) != Scriptable.NOT_FOUND) {
                    return (Boolean)object;
                }
                if (!bl) {
                    d = 0.0;
                }
                return ScriptRuntime.eqNumber(d, object2);
            }
            if (object instanceof Scriptable) {
                if (object2 instanceof Scriptable) {
                    Object object3;
                    if (object instanceof ScriptableObject && (object3 = ((ScriptableObject)object).equivalentValues(object2)) != Scriptable.NOT_FOUND) {
                        return (Boolean)object3;
                    }
                    if (object2 instanceof ScriptableObject && (object3 = ((ScriptableObject)object2).equivalentValues(object)) != Scriptable.NOT_FOUND) {
                        return (Boolean)object3;
                    }
                    if (object instanceof Wrapper && object2 instanceof Wrapper) {
                        object = ((Wrapper)object).unwrap();
                        object2 = ((Wrapper)object2).unwrap();
                        bl3 = bl;
                        if (object != object2) {
                            bl3 = ScriptRuntime.isPrimitive(object) && ScriptRuntime.isPrimitive(object2) && ScriptRuntime.eq(object, object2) ? bl : false;
                        }
                        return bl3;
                    }
                    return false;
                }
                if (object2 instanceof Boolean) {
                    Object object4;
                    if (object instanceof ScriptableObject && (object4 = ((ScriptableObject)object).equivalentValues(object2)) != Scriptable.NOT_FOUND) {
                        return (Boolean)object4;
                    }
                    if (!((Boolean)object2).booleanValue()) {
                        d = 0.0;
                    }
                    return ScriptRuntime.eqNumber(d, object);
                }
                if (object2 instanceof Number) {
                    return ScriptRuntime.eqNumber(((Number)object2).doubleValue(), object);
                }
                if (object2 instanceof CharSequence) {
                    return ScriptRuntime.eqString((CharSequence)object2, object);
                }
                return false;
            }
            ScriptRuntime.warnAboutNonJSObject(object);
            bl3 = object == object2 ? bl2 : false;
            return bl3;
        }
        if (object2 != null && object2 != Undefined.instance) {
            if (object2 instanceof ScriptableObject && (object = ((ScriptableObject)object2).equivalentValues(object)) != Scriptable.NOT_FOUND) {
                return (Boolean)object;
            }
            return false;
        }
        return true;
    }

    static boolean eqNumber(double d, Object object) {
        block10: {
            while (true) {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                if (object == null || object == Undefined.instance) break block10;
                if (object instanceof Number) {
                    if (d == ((Number)object).doubleValue()) {
                        bl3 = true;
                    }
                    return bl3;
                }
                if (object instanceof CharSequence) {
                    bl3 = bl;
                    if (d == ScriptRuntime.toNumber(object)) {
                        bl3 = true;
                    }
                    return bl3;
                }
                if (object instanceof Boolean) {
                    double d2 = (Boolean)object != false ? 1.0 : 0.0;
                    bl3 = bl2;
                    if (d == d2) {
                        bl3 = true;
                    }
                    return bl3;
                }
                if (ScriptRuntime.isSymbol(object)) {
                    return false;
                }
                if (!(object instanceof Scriptable)) break;
                if (object instanceof ScriptableObject) {
                    Object object2 = ScriptRuntime.wrapNumber(d);
                    if ((object2 = ((ScriptableObject)object).equivalentValues(object2)) != Scriptable.NOT_FOUND) {
                        return (Boolean)object2;
                    }
                }
                object = ScriptRuntime.toPrimitive(object);
            }
            ScriptRuntime.warnAboutNonJSObject(object);
        }
        return false;
    }

    private static boolean eqString(CharSequence charSequence, Object object) {
        block10: {
            while (true) {
                Object object2;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                if (object == null || object == Undefined.instance) break block10;
                if (object instanceof CharSequence) {
                    object = (CharSequence)object;
                    bl = bl3;
                    if (charSequence.length() == object.length()) {
                        bl = bl3;
                        if (charSequence.toString().equals(object.toString())) {
                            bl = true;
                        }
                    }
                    return bl;
                }
                if (object instanceof Number) {
                    if (ScriptRuntime.toNumber(charSequence.toString()) == ((Number)object).doubleValue()) {
                        bl = true;
                    }
                    return bl;
                }
                if (object instanceof Boolean) {
                    double d = ScriptRuntime.toNumber(charSequence.toString());
                    double d2 = (Boolean)object != false ? 1.0 : 0.0;
                    bl = bl2;
                    if (d == d2) {
                        bl = true;
                    }
                    return bl;
                }
                if (ScriptRuntime.isSymbol(object)) {
                    return false;
                }
                if (!(object instanceof Scriptable)) break;
                if (object instanceof ScriptableObject && (object2 = ((ScriptableObject)object).equivalentValues(charSequence.toString())) != Scriptable.NOT_FOUND) {
                    return (Boolean)object2;
                }
                object = ScriptRuntime.toPrimitive(object);
            }
            ScriptRuntime.warnAboutNonJSObject(object);
        }
        return false;
    }

    private static RuntimeException errorWithClassName(String string2, Object object) {
        return Context.reportRuntimeError1(string2, object.getClass().getName());
    }

    public static String escapeAttributeValue(Object object, Context context) {
        return ScriptRuntime.currentXMLLib(context).escapeAttributeValue(object);
    }

    public static String escapeString(String string2) {
        return ScriptRuntime.escapeString(string2, '\"');
    }

    public static String escapeString(String string2, char c) {
        if (c != '\"' && c != '\'') {
            Kit.codeBug();
        }
        StringBuilder stringBuilder = null;
        int n = string2.length();
        for (int i = 0; i != n; ++i) {
            StringBuilder stringBuilder2;
            char c2 = string2.charAt(i);
            int n2 = 32;
            if (' ' <= c2 && c2 <= '~' && c2 != c && c2 != '\\') {
                stringBuilder2 = stringBuilder;
                if (stringBuilder != null) {
                    stringBuilder.append(c2);
                    stringBuilder2 = stringBuilder;
                }
            } else {
                StringBuilder stringBuilder3 = stringBuilder;
                if (stringBuilder == null) {
                    stringBuilder3 = new StringBuilder(n + 3);
                    stringBuilder3.append(string2);
                    stringBuilder3.setLength(i);
                }
                if (c2 != ' ') {
                    if (c2 != '\\') {
                        switch (c2) {
                            default: {
                                n2 = -1;
                                break;
                            }
                            case '\r': {
                                n2 = 114;
                                break;
                            }
                            case '\f': {
                                n2 = 102;
                                break;
                            }
                            case '\u000b': {
                                n2 = 118;
                                break;
                            }
                            case '\n': {
                                n2 = 110;
                                break;
                            }
                            case '\t': {
                                n2 = 116;
                                break;
                            }
                            case '\b': {
                                n2 = 98;
                                break;
                            }
                        }
                    } else {
                        n2 = 92;
                    }
                }
                if (n2 >= 0) {
                    stringBuilder3.append('\\');
                    stringBuilder3.append((char)n2);
                    stringBuilder2 = stringBuilder3;
                } else if (c2 == c) {
                    stringBuilder3.append('\\');
                    stringBuilder3.append(c);
                    stringBuilder2 = stringBuilder3;
                } else {
                    if (c2 < '\u0100') {
                        stringBuilder3.append("\\x");
                        n2 = 2;
                    } else {
                        stringBuilder3.append("\\u");
                        n2 = 4;
                    }
                    n2 = (n2 - 1) * 4;
                    while (true) {
                        stringBuilder2 = stringBuilder3;
                        if (n2 < 0) break;
                        int n3 = c2 >> n2 & 0xF;
                        n3 = n3 < 10 ? (n3 += 48) : (n3 += 87);
                        stringBuilder3.append((char)n3);
                        n2 -= 4;
                    }
                }
            }
            stringBuilder = stringBuilder2;
        }
        if (stringBuilder != null) {
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    public static String escapeTextValue(Object object, Context context) {
        return ScriptRuntime.currentXMLLib(context).escapeTextValue(object);
    }

    public static Object evalSpecial(Context context, Scriptable scriptable, Object object, Object[] object2, String object3, int n) {
        if (((Object[])object2).length < 1) {
            return Undefined.instance;
        }
        Object object4 = object2[0];
        if (!(object4 instanceof CharSequence)) {
            if (!context.hasFeature(11) && !context.hasFeature(9)) {
                Context.reportWarning(ScriptRuntime.getMessage0("msg.eval.nonstring"));
                return object4;
            }
            throw Context.reportRuntimeError0("msg.eval.nonstring.strict");
        }
        object2 = object3;
        Object object5 = n;
        if (object3 == null) {
            object3 = new int[1];
            object2 = Context.getSourcePositionFromStack((int[])object3);
            if (object2 != null) {
                object5 = object3[0];
            } else {
                object2 = "";
                object5 = n;
            }
        }
        String string2 = ScriptRuntime.makeUrlForGeneratedScript(true, (String)object2, object5);
        ErrorReporter errorReporter = DefaultErrorReporter.forEval(context.getErrorReporter());
        object3 = Context.createInterpreter();
        if (object3 != null) {
            object2 = context.compileString(object4.toString(), (Evaluator)object3, errorReporter, string2, 1, null);
            object3.setEvalScriptFlag((Script)object2);
            return ((Callable)object2).call(context, scriptable, (Scriptable)object, emptyArgs);
        }
        throw new JavaScriptException("Interpreter not present", (String)object2, (int)object5);
    }

    public static void exitActivationFunction(Context context) {
        NativeCall nativeCall = context.currentActivationCall;
        context.currentActivationCall = nativeCall.parentActivationCall;
        nativeCall.parentActivationCall = null;
    }

    static NativeCall findFunctionActivation(Context object, Function function) {
        object = ((Context)object).currentActivationCall;
        while (object != null) {
            if (((NativeCall)object).function == function) {
                return object;
            }
            object = ((NativeCall)object).parentActivationCall;
        }
        return null;
    }

    static Object[] getApplyArguments(Context context, Object object) {
        if (object != null && object != Undefined.instance) {
            Scriptable scriptable;
            if (object instanceof Scriptable && ScriptRuntime.isArrayLike(scriptable = (Scriptable)object)) {
                return context.getElements(scriptable);
            }
            if (object instanceof ScriptableObject) {
                return emptyArgs;
            }
            throw ScriptRuntime.typeError0("msg.arg.isnt.array");
        }
        return emptyArgs;
    }

    public static Object[] getArrayElements(Scriptable scriptable) {
        long l = NativeArray.getLengthProperty(Context.getContext(), scriptable);
        if (l <= Integer.MAX_VALUE) {
            int n = (int)l;
            if (n == 0) {
                return emptyArgs;
            }
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                Object object;
                Object object2 = object = ScriptableObject.getProperty(scriptable, i);
                if (object == Scriptable.NOT_FOUND) {
                    object2 = Undefined.instance;
                }
                objectArray[i] = object2;
            }
            return objectArray;
        }
        throw new IllegalArgumentException();
    }

    static Callable getCallable(Scriptable object) {
        Object object2;
        block4: {
            block3: {
                block2: {
                    if (!(object instanceof Callable)) break block2;
                    object = (Callable)object;
                    break block3;
                }
                object2 = object.getDefaultValue(FunctionClass);
                if (!(object2 instanceof Callable)) break block4;
                object = (Callable)object2;
            }
            return object;
        }
        throw ScriptRuntime.notFunctionError(object2, object);
    }

    @Deprecated
    public static Callable getElemFunctionAndThis(Object object, Object object2, Context context) {
        return ScriptRuntime.getElemFunctionAndThis(object, object2, context, ScriptRuntime.getTopCallScope(context));
    }

    public static Callable getElemFunctionAndThis(Object object, Object object2, Context context, Scriptable object3) {
        block8: {
            block7: {
                block5: {
                    block6: {
                        if (!ScriptRuntime.isSymbol(object2)) break block5;
                        Scriptable scriptable = ScriptRuntime.toObjectOrNull(context, object, (Scriptable)object3);
                        if (scriptable == null) break block6;
                        object3 = ScriptableObject.getProperty(scriptable, (Symbol)object2);
                        object = scriptable;
                        break block7;
                    }
                    throw ScriptRuntime.undefCallError(object, String.valueOf(object2));
                }
                Object object4 = ScriptRuntime.toStringIdOrIndex(context, object2);
                if (object4 != null) {
                    return ScriptRuntime.getPropFunctionAndThis(object, (String)object4, context, (Scriptable)object3);
                }
                int n = ScriptRuntime.lastIndexResult(context);
                object4 = ScriptRuntime.toObjectOrNull(context, object, (Scriptable)object3);
                if (object4 == null) break block8;
                object3 = ScriptableObject.getProperty((Scriptable)object4, n);
                object = object4;
            }
            if (object3 instanceof Callable) {
                ScriptRuntime.storeScriptable(context, (Scriptable)object);
                return (Callable)object3;
            }
            throw ScriptRuntime.notFunctionError(object3, object2);
        }
        throw ScriptRuntime.undefCallError(object, String.valueOf(object2));
    }

    static Function getExistingCtor(Context object, Scriptable scriptable, String string2) {
        object = ScriptableObject.getProperty(scriptable, string2);
        if (object instanceof Function) {
            return (Function)object;
        }
        if (object == Scriptable.NOT_FOUND) {
            throw Context.reportRuntimeError1("msg.ctor.not.found", string2);
        }
        throw Context.reportRuntimeError1("msg.not.ctor", string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScriptableObject getGlobal(Context context) {
        Class<?> clazz = Kit.classOrNull("org.mozilla.javascript.tools.shell.Global");
        if (clazz == null) return new ImporterTopLevel(context);
        try {
            return (ScriptableObject)clazz.getConstructor(ContextClass).newInstance(context);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            return new ImporterTopLevel(context);
        }
    }

    static Object getIndexObject(double d) {
        int n = (int)d;
        if ((double)n == d) {
            return n;
        }
        return ScriptRuntime.toString(d);
    }

    static Object getIndexObject(String object) {
        long l = ScriptRuntime.indexFromString((String)object);
        if (l >= 0L) {
            object = (int)l;
        }
        return object;
    }

    public static ScriptableObject getLibraryScopeOrNull(Scriptable scriptable) {
        return (ScriptableObject)ScriptableObject.getTopScopeValue(scriptable, LIBRARY_SCOPE_KEY);
    }

    public static String getMessage(String string2, Object[] objectArray) {
        return messageProvider.getMessage(string2, objectArray);
    }

    public static String getMessage0(String string2) {
        return ScriptRuntime.getMessage(string2, null);
    }

    public static String getMessage1(String string2, Object object) {
        return ScriptRuntime.getMessage(string2, new Object[]{object});
    }

    public static String getMessage2(String string2, Object object, Object object2) {
        return ScriptRuntime.getMessage(string2, new Object[]{object, object2});
    }

    public static String getMessage3(String string2, Object object, Object object2, Object object3) {
        return ScriptRuntime.getMessage(string2, new Object[]{object, object2, object3});
    }

    public static String getMessage4(String string2, Object object, Object object2, Object object3, Object object4) {
        return ScriptRuntime.getMessage(string2, new Object[]{object, object2, object3, object4});
    }

    public static Callable getNameFunctionAndThis(String string2, Context context, Scriptable scriptable) {
        Object object = scriptable.getParentScope();
        if (object == null) {
            object = ScriptRuntime.topScopeName(context, scriptable, string2);
            if (!(object instanceof Callable)) {
                if (object == Scriptable.NOT_FOUND) {
                    throw ScriptRuntime.notFoundError(scriptable, string2);
                }
                throw ScriptRuntime.notFunctionError(object, string2);
            }
            ScriptRuntime.storeScriptable(context, scriptable);
            return (Callable)object;
        }
        return (Callable)ScriptRuntime.nameOrFunction(context, scriptable, (Scriptable)object, string2, true);
    }

    @Deprecated
    public static Object getObjectElem(Object object, Object object2, Context context) {
        return ScriptRuntime.getObjectElem(object, object2, context, ScriptRuntime.getTopCallScope(context));
    }

    public static Object getObjectElem(Object object, Object object2, Context context, Scriptable scriptable) {
        if ((scriptable = ScriptRuntime.toObjectOrNull(context, object, scriptable)) != null) {
            return ScriptRuntime.getObjectElem(scriptable, object2, context);
        }
        throw ScriptRuntime.undefReadError(object, object2);
    }

    public static Object getObjectElem(Scriptable object, Object object2, Context context) {
        object = object instanceof XMLObject ? ((XMLObject)object).get(context, object2) : (ScriptRuntime.isSymbol(object2) ? ScriptableObject.getProperty((Scriptable)object, (Symbol)object2) : ((object2 = ScriptRuntime.toStringIdOrIndex(context, object2)) == null ? ScriptableObject.getProperty((Scriptable)object, ScriptRuntime.lastIndexResult(context)) : ScriptableObject.getProperty((Scriptable)object, (String)object2)));
        object2 = object;
        if (object == Scriptable.NOT_FOUND) {
            object2 = Undefined.instance;
        }
        return object2;
    }

    @Deprecated
    public static Object getObjectIndex(Object object, double d, Context context) {
        return ScriptRuntime.getObjectIndex(object, d, context, ScriptRuntime.getTopCallScope(context));
    }

    public static Object getObjectIndex(Object object, double d, Context context, Scriptable scriptable) {
        if ((scriptable = ScriptRuntime.toObjectOrNull(context, object, scriptable)) != null) {
            int n = (int)d;
            if ((double)n == d) {
                return ScriptRuntime.getObjectIndex(scriptable, n, context);
            }
            return ScriptRuntime.getObjectProp(scriptable, ScriptRuntime.toString(d), context);
        }
        throw ScriptRuntime.undefReadError(object, ScriptRuntime.toString(d));
    }

    public static Object getObjectIndex(Scriptable object, int n, Context object2) {
        object = object2 = ScriptableObject.getProperty((Scriptable)object, n);
        if (object2 == Scriptable.NOT_FOUND) {
            object = Undefined.instance;
        }
        return object;
    }

    @Deprecated
    public static Object getObjectProp(Object object, String string2, Context context) {
        return ScriptRuntime.getObjectProp(object, string2, context, ScriptRuntime.getTopCallScope(context));
    }

    public static Object getObjectProp(Object object, String string2, Context context, Scriptable scriptable) {
        if ((scriptable = ScriptRuntime.toObjectOrNull(context, object, scriptable)) != null) {
            return ScriptRuntime.getObjectProp(scriptable, string2, context);
        }
        throw ScriptRuntime.undefReadError(object, string2);
    }

    public static Object getObjectProp(Scriptable object, String string2, Context context) {
        Object object2;
        object = object2 = ScriptableObject.getProperty((Scriptable)object, string2);
        if (object2 == Scriptable.NOT_FOUND) {
            if (context.hasFeature(11)) {
                Context.reportWarning(ScriptRuntime.getMessage1("msg.ref.undefined.prop", string2));
            }
            object = Undefined.instance;
        }
        return object;
    }

    @Deprecated
    public static Object getObjectPropNoWarn(Object object, String string2, Context context) {
        return ScriptRuntime.getObjectPropNoWarn(object, string2, context, ScriptRuntime.getTopCallScope(context));
    }

    public static Object getObjectPropNoWarn(Object object, String object2, Context object3, Scriptable scriptable) {
        if ((object3 = ScriptRuntime.toObjectOrNull((Context)object3, object, scriptable)) != null) {
            object = object2 = ScriptableObject.getProperty((Scriptable)object3, (String)object2);
            if (object2 == Scriptable.NOT_FOUND) {
                object = Undefined.instance;
            }
            return object;
        }
        throw ScriptRuntime.undefReadError(object, object2);
    }

    @Deprecated
    public static Callable getPropFunctionAndThis(Object object, String string2, Context context) {
        return ScriptRuntime.getPropFunctionAndThis(object, string2, context, ScriptRuntime.getTopCallScope(context));
    }

    public static Callable getPropFunctionAndThis(Object object, String string2, Context context, Scriptable scriptable) {
        return ScriptRuntime.getPropFunctionAndThisHelper(object, string2, context, ScriptRuntime.toObjectOrNull(context, object, scriptable));
    }

    private static Callable getPropFunctionAndThisHelper(Object object, String string2, Context context, Scriptable scriptable) {
        if (scriptable != null) {
            Object object2;
            object = object2 = ScriptableObject.getProperty(scriptable, string2);
            if (!(object2 instanceof Callable)) {
                Object object3 = ScriptableObject.getProperty(scriptable, "__noSuchMethod__");
                object = object2;
                if (object3 instanceof Callable) {
                    object = new NoSuchMethodShim((Callable)object3, string2);
                }
            }
            if (object instanceof Callable) {
                ScriptRuntime.storeScriptable(context, scriptable);
                return (Callable)object;
            }
            throw ScriptRuntime.notFunctionError(scriptable, object, string2);
        }
        throw ScriptRuntime.undefCallError(object, string2);
    }

    public static RegExpProxy getRegExpProxy(Context context) {
        return context.getRegExpProxy();
    }

    public static Scriptable getTopCallScope(Context object) {
        object = ((Context)object).topCallScope;
        if (object != null) {
            return object;
        }
        throw new IllegalStateException();
    }

    public static Object getTopLevelProp(Scriptable scriptable, String string2) {
        return ScriptableObject.getProperty(ScriptableObject.getTopLevelScope(scriptable), string2);
    }

    static String[] getTopPackageNames() {
        String[] stringArray = "Dalvik".equals(System.getProperty("java.vm.name")) ? new String[]{"java", "javax", "org", "com", "edu", "net", "android"} : new String[]{"java", "javax", "org", "com", "edu", "net"};
        return stringArray;
    }

    public static Callable getValueFunctionAndThis(Object object, Context context) {
        if (object instanceof Callable) {
            Callable callable = (Callable)object;
            Object object2 = null;
            if (callable instanceof Scriptable) {
                object2 = ((Scriptable)((Object)callable)).getParentScope();
            }
            object = object2;
            if (object2 == null) {
                if (context.topCallScope != null) {
                    object = context.topCallScope;
                } else {
                    throw new IllegalStateException();
                }
            }
            object2 = object;
            if (object.getParentScope() != null) {
                if (object instanceof NativeWith) {
                    object2 = object;
                } else {
                    object2 = object;
                    if (object instanceof NativeCall) {
                        object2 = ScriptableObject.getTopLevelScope((Scriptable)object);
                    }
                }
            }
            ScriptRuntime.storeScriptable(context, (Scriptable)object2);
            return callable;
        }
        throw ScriptRuntime.notFunctionError(object);
    }

    public static boolean hasObjectElem(Scriptable scriptable, Object object, Context context) {
        boolean bl = ScriptRuntime.isSymbol(object) ? ScriptableObject.hasProperty(scriptable, (Symbol)object) : ((object = ScriptRuntime.toStringIdOrIndex(context, object)) == null ? ScriptableObject.hasProperty(scriptable, ScriptRuntime.lastIndexResult(context)) : ScriptableObject.hasProperty(scriptable, (String)object));
        return bl;
    }

    public static boolean hasTopCall(Context context) {
        boolean bl = context.topCallScope != null;
        return bl;
    }

    public static boolean in(Object object, Object object2, Context context) {
        if (object2 instanceof Scriptable) {
            return ScriptRuntime.hasObjectElem((Scriptable)object2, object, context);
        }
        throw ScriptRuntime.typeError0("msg.in.not.object");
    }

    public static long indexFromString(String string2) {
        int n = string2.length();
        if (n > 0) {
            int n2;
            boolean bl;
            int n3 = 0;
            int n4 = 0;
            int n5 = string2.charAt(0);
            if (n5 == 45 && n > 1) {
                n5 = string2.charAt(1);
                if (n5 == 48) {
                    return -1L;
                }
                bl = true;
                n2 = 1;
            } else {
                bl = false;
                n2 = 0;
            }
            int n6 = n5 - 48;
            if (n6 >= 0 && n6 <= 9 && n <= (n5 = bl ? 11 : 10)) {
                int n7 = -n6;
                int n8 = n2 + 1;
                n2 = n6;
                int n9 = n8;
                n5 = n7;
                if (n7 != 0) {
                    n2 = n6;
                    n6 = n4;
                    while (true) {
                        n3 = n6;
                        n9 = n8;
                        n5 = n7;
                        if (n8 == n) break;
                        n4 = string2.charAt(n8) - 48;
                        n3 = n6;
                        n2 = n4;
                        n9 = n8;
                        n5 = n7;
                        if (n4 < 0) break;
                        n3 = n6;
                        n2 = n4;
                        n9 = n8++;
                        n5 = n7;
                        if (n4 > 9) break;
                        n5 = n7 * 10 - n4;
                        n6 = n7;
                        n2 = n4;
                        n7 = n5;
                    }
                }
                if (n9 == n && (n3 > -214748364 || n3 == -214748364 && n2 <= (n8 = bl ? 8 : 7))) {
                    if (!bl) {
                        n5 = -n5;
                    }
                    return 0xFFFFFFFFL & (long)n5;
                }
            }
        }
        return -1L;
    }

    public static void initFunction(Context object, Scriptable scriptable, NativeFunction nativeFunction, int n, boolean bl) {
        block11: {
            block10: {
                block9: {
                    if (n != 1) break block9;
                    object = nativeFunction.getFunctionName();
                    if (object != null && ((String)object).length() != 0) {
                        if (!bl) {
                            ScriptableObject.defineProperty(scriptable, (String)object, nativeFunction, 4);
                        } else {
                            scriptable.put((String)object, scriptable, (Object)nativeFunction);
                        }
                    }
                    break block10;
                }
                if (n != 3) break block11;
                object = nativeFunction.getFunctionName();
                if (object != null && ((String)object).length() != 0) {
                    while (scriptable instanceof NativeWith) {
                        scriptable = scriptable.getParentScope();
                    }
                    scriptable.put((String)object, scriptable, (Object)nativeFunction);
                }
            }
            return;
        }
        throw Kit.codeBug();
    }

    public static ScriptableObject initSafeStandardObjects(Context context, ScriptableObject object, boolean bl) {
        ScriptableObject scriptableObject = object;
        if (object == null) {
            scriptableObject = new NativeObject();
        }
        scriptableObject.associateValue(LIBRARY_SCOPE_KEY, scriptableObject);
        new ClassCache().associate(scriptableObject);
        BaseFunction.init(scriptableObject, bl);
        NativeObject.init(scriptableObject, bl);
        object = ScriptableObject.getObjectPrototype(scriptableObject);
        ScriptableObject.getClassPrototype(scriptableObject, "Function").setPrototype((Scriptable)object);
        if (scriptableObject.getPrototype() == null) {
            scriptableObject.setPrototype((Scriptable)object);
        }
        NativeError.init(scriptableObject, bl);
        NativeGlobal.init(context, scriptableObject, bl);
        NativeArray.init(scriptableObject, bl);
        if (context.getOptimizationLevel() > 0) {
            NativeArray.setMaximumInitialCapacity(200000);
        }
        NativeString.init(scriptableObject, bl);
        NativeBoolean.init(scriptableObject, bl);
        NativeNumber.init(scriptableObject, bl);
        NativeDate.init(scriptableObject, bl);
        NativeMath.init(scriptableObject, bl);
        NativeJSON.init(scriptableObject, bl);
        NativeWith.init(scriptableObject, bl);
        NativeCall.init(scriptableObject, bl);
        NativeScript.init(scriptableObject, bl);
        NativeIterator.init(scriptableObject, bl);
        NativeArrayIterator.init(scriptableObject, bl);
        NativeStringIterator.init(scriptableObject, bl);
        boolean bl2 = context.hasFeature(6) && context.getE4xImplementationFactory() != null;
        new LazilyLoadedCtor(scriptableObject, "RegExp", "org.mozilla.javascript.regexp.NativeRegExp", bl, true);
        new LazilyLoadedCtor(scriptableObject, "Continuation", "org.mozilla.javascript.NativeContinuation", bl, true);
        if (bl2) {
            object = context.getE4xImplementationFactory().getImplementationClassName();
            new LazilyLoadedCtor(scriptableObject, "XML", (String)object, bl, true);
            new LazilyLoadedCtor(scriptableObject, "XMLList", (String)object, bl, true);
            new LazilyLoadedCtor(scriptableObject, "Namespace", (String)object, bl, true);
            new LazilyLoadedCtor(scriptableObject, "QName", (String)object, bl, true);
        }
        if (context.getLanguageVersion() >= 180 && context.hasFeature(14) || context.getLanguageVersion() >= 200) {
            new LazilyLoadedCtor(scriptableObject, "ArrayBuffer", "org.mozilla.javascript.typedarrays.NativeArrayBuffer", bl, true);
            new LazilyLoadedCtor(scriptableObject, "Int8Array", "org.mozilla.javascript.typedarrays.NativeInt8Array", bl, true);
            new LazilyLoadedCtor(scriptableObject, "Uint8Array", "org.mozilla.javascript.typedarrays.NativeUint8Array", bl, true);
            new LazilyLoadedCtor(scriptableObject, "Uint8ClampedArray", "org.mozilla.javascript.typedarrays.NativeUint8ClampedArray", bl, true);
            new LazilyLoadedCtor(scriptableObject, "Int16Array", "org.mozilla.javascript.typedarrays.NativeInt16Array", bl, true);
            new LazilyLoadedCtor(scriptableObject, "Uint16Array", "org.mozilla.javascript.typedarrays.NativeUint16Array", bl, true);
            new LazilyLoadedCtor(scriptableObject, "Int32Array", "org.mozilla.javascript.typedarrays.NativeInt32Array", bl, true);
            new LazilyLoadedCtor(scriptableObject, "Uint32Array", "org.mozilla.javascript.typedarrays.NativeUint32Array", bl, true);
            new LazilyLoadedCtor(scriptableObject, "Float32Array", "org.mozilla.javascript.typedarrays.NativeFloat32Array", bl, true);
            new LazilyLoadedCtor(scriptableObject, "Float64Array", "org.mozilla.javascript.typedarrays.NativeFloat64Array", bl, true);
            new LazilyLoadedCtor(scriptableObject, "DataView", "org.mozilla.javascript.typedarrays.NativeDataView", bl, true);
        }
        if (context.getLanguageVersion() >= 200) {
            NativeSymbol.init(context, scriptableObject, bl);
        }
        if (scriptableObject instanceof TopLevel) {
            ((TopLevel)scriptableObject).cacheBuiltins();
        }
        return scriptableObject;
    }

    public static void initScript(NativeFunction nativeFunction, Scriptable scriptable, Context object, Scriptable scriptable2, boolean bl) {
        if (((Context)object).topCallScope != null) {
            int n = nativeFunction.getParamAndVarCount();
            if (n != 0) {
                int n2;
                scriptable = scriptable2;
                while (true) {
                    n2 = n;
                    if (!(scriptable instanceof NativeWith)) break;
                    scriptable = scriptable.getParentScope();
                }
                while (true) {
                    n = n2 - 1;
                    if (n2 == 0) break;
                    object = nativeFunction.getParamOrVarName(n);
                    boolean bl2 = nativeFunction.getParamOrVarConst(n);
                    if (!ScriptableObject.hasProperty(scriptable2, (String)object)) {
                        if (bl2) {
                            ScriptableObject.defineConstProperty(scriptable, (String)object);
                        } else if (!bl) {
                            ScriptableObject.defineProperty(scriptable, (String)object, Undefined.instance, 4);
                        } else {
                            scriptable.put((String)object, scriptable, Undefined.instance);
                        }
                    } else {
                        ScriptableObject.redefineProperty(scriptable2, (String)object, bl2);
                    }
                    n2 = n;
                }
            }
            return;
        }
        throw new IllegalStateException();
    }

    public static ScriptableObject initStandardObjects(Context object, ScriptableObject stringArray, boolean bl) {
        object = ScriptRuntime.initSafeStandardObjects((Context)object, (ScriptableObject)stringArray, bl);
        new LazilyLoadedCtor((ScriptableObject)object, "Packages", "org.mozilla.javascript.NativeJavaTopPackage", bl, true);
        new LazilyLoadedCtor((ScriptableObject)object, "getClass", "org.mozilla.javascript.NativeJavaTopPackage", bl, true);
        new LazilyLoadedCtor((ScriptableObject)object, "JavaAdapter", "org.mozilla.javascript.JavaAdapter", bl, true);
        new LazilyLoadedCtor((ScriptableObject)object, "JavaImporter", "org.mozilla.javascript.ImporterTopLevel", bl, true);
        stringArray = ScriptRuntime.getTopPackageNames();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            new LazilyLoadedCtor((ScriptableObject)object, stringArray[i], "org.mozilla.javascript.NativeJavaTopPackage", bl, true);
        }
        return object;
    }

    public static boolean instanceOf(Object object, Object object2, Context context) {
        if (object2 instanceof Scriptable) {
            if (!(object instanceof Scriptable)) {
                return false;
            }
            return ((Scriptable)object2).hasInstance((Scriptable)object);
        }
        throw ScriptRuntime.typeError0("msg.instanceof.not.object");
    }

    private static boolean isArrayLike(Scriptable scriptable) {
        boolean bl = scriptable != null && (scriptable instanceof NativeArray || scriptable instanceof Arguments || ScriptableObject.hasProperty(scriptable, "length"));
        return bl;
    }

    public static boolean isArrayObject(Object object) {
        boolean bl = object instanceof NativeArray || object instanceof Arguments;
        return bl;
    }

    static boolean isGeneratedScript(String string2) {
        boolean bl = string2.indexOf("(eval)") >= 0 || string2.indexOf("(Function)") >= 0;
        return bl;
    }

    public static boolean isJSLineTerminator(int n) {
        boolean bl = false;
        if ((0xDFD0 & n) != 0) {
            return false;
        }
        if (n == 10 || n == 13 || n == 8232 || n == 8233) {
            bl = true;
        }
        return bl;
    }

    public static boolean isJSWhitespaceOrLineTerminator(int n) {
        boolean bl = ScriptRuntime.isStrWhiteSpaceChar(n) || ScriptRuntime.isJSLineTerminator(n);
        return bl;
    }

    public static boolean isNaN(Object object) {
        Double d = NaNobj;
        boolean bl = true;
        boolean bl2 = true;
        if (object == d) {
            return true;
        }
        if (object instanceof Double) {
            object = (Double)object;
            boolean bl3 = bl2;
            if ((Double)object != NaN) {
                bl3 = Double.isNaN((Double)object) ? bl2 : false;
            }
            return bl3;
        }
        if (object instanceof Float) {
            object = (Float)object;
            boolean bl4 = bl;
            if ((double)((Float)object).floatValue() != NaN) {
                bl4 = Float.isNaN(((Float)object).floatValue()) ? bl : false;
            }
            return bl4;
        }
        return false;
    }

    public static boolean isPrimitive(Object object) {
        boolean bl = object == null || object == Undefined.instance || object instanceof Number || object instanceof String || object instanceof Boolean;
        return bl;
    }

    public static boolean isRhinoRuntimeType(Class<?> clazz) {
        boolean bl;
        block6: {
            block5: {
                boolean bl2 = clazz.isPrimitive();
                boolean bl3 = false;
                bl = false;
                if (bl2) {
                    if (clazz != Character.TYPE) {
                        bl = true;
                    }
                    return bl;
                }
                if (clazz == StringClass || clazz == BooleanClass || NumberClass.isAssignableFrom(clazz)) break block5;
                bl = bl3;
                if (!ScriptableClass.isAssignableFrom(clazz)) break block6;
            }
            bl = true;
        }
        return bl;
    }

    static boolean isSpecialProperty(String string2) {
        boolean bl = string2.equals("__proto__") || string2.equals("__parent__");
        return bl;
    }

    static boolean isStrWhiteSpaceChar(int n) {
        boolean bl;
        boolean bl2 = bl = true;
        if (n != 32) {
            bl2 = bl;
            if (n != 160) {
                bl2 = bl;
                if (n != 65279) {
                    bl2 = bl;
                    if (n != 8232) {
                        bl2 = bl;
                        if (n != 8233) {
                            bl2 = bl;
                            switch (n) {
                                default: {
                                    bl2 = Character.getType(n) == 12 ? bl : false;
                                }
                                case 9: 
                                case 10: 
                                case 11: 
                                case 12: 
                                case 13: 
                            }
                        }
                    }
                }
            }
        }
        return bl2;
    }

    static boolean isSymbol(Object object) {
        boolean bl = object instanceof NativeSymbol && ((NativeSymbol)object).isSymbol() || object instanceof SymbolKey;
        return bl;
    }

    static boolean isValidIdentifierName(String string2, Context context, boolean bl) {
        int n = string2.length();
        if (n == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string2.charAt(0))) {
            return false;
        }
        for (int i = 1; i != n; ++i) {
            if (Character.isJavaIdentifierPart(string2.charAt(i))) continue;
            return false;
        }
        return TokenStream.isKeyword(string2, context.getLanguageVersion(), bl) ^ true;
    }

    private static boolean isVisible(Context object, Object object2) {
        boolean bl = (object = ((Context)object).getClassShutter()) == null || object.visibleToScripts(object2.getClass().getName());
        return bl;
    }

    public static boolean jsDelegatesTo(Scriptable scriptable, Scriptable scriptable2) {
        for (scriptable = scriptable.getPrototype(); scriptable != null; scriptable = scriptable.getPrototype()) {
            if (!scriptable.equals(scriptable2)) continue;
            return true;
        }
        return false;
    }

    static int lastIndexResult(Context context) {
        return context.scratchIndex;
    }

    public static Scriptable lastStoredScriptable(Context context) {
        Scriptable scriptable = context.scratchScriptable;
        context.scratchScriptable = null;
        return scriptable;
    }

    public static long lastUint32Result(Context context) {
        long l = context.scratchUint32;
        if (l >>> 32 == 0L) {
            return l;
        }
        throw new IllegalStateException();
    }

    public static Scriptable leaveDotQuery(Scriptable scriptable) {
        return ((NativeWith)scriptable).getParentScope();
    }

    public static Scriptable leaveWith(Scriptable scriptable) {
        return ((NativeWith)scriptable).getParentScope();
    }

    static String makeUrlForGeneratedScript(boolean bl, String string2, int n) {
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append('#');
            stringBuilder.append(n);
            stringBuilder.append("(eval)");
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append('#');
        stringBuilder.append(n);
        stringBuilder.append("(Function)");
        return stringBuilder.toString();
    }

    public static Ref memberRef(Object object, Object object2, Object object3, Context context, int n) {
        if (object instanceof XMLObject) {
            return ((XMLObject)object).memberRef(context, object2, object3, n);
        }
        throw ScriptRuntime.notXmlError(object);
    }

    public static Ref memberRef(Object object, Object object2, Context context, int n) {
        if (object instanceof XMLObject) {
            return ((XMLObject)object).memberRef(context, object2, n);
        }
        throw ScriptRuntime.notXmlError(object);
    }

    public static Object name(Context object, Scriptable scriptable, String string2) {
        Scriptable scriptable2 = scriptable.getParentScope();
        if (scriptable2 == null) {
            if ((object = ScriptRuntime.topScopeName((Context)object, scriptable, string2)) != Scriptable.NOT_FOUND) {
                return object;
            }
            throw ScriptRuntime.notFoundError(scriptable, string2);
        }
        return ScriptRuntime.nameOrFunction((Context)object, scriptable, scriptable2, string2, false);
    }

    @Deprecated
    public static Object nameIncrDecr(Scriptable scriptable, String string2, int n) {
        return ScriptRuntime.nameIncrDecr(scriptable, string2, Context.getContext(), n);
    }

    public static Object nameIncrDecr(Scriptable scriptable, String string2, Context context, int n) {
        Object object = scriptable;
        do {
            scriptable = object;
            if (context.useDynamicScope) {
                scriptable = object;
                if (object.getParentScope() == null) {
                    scriptable = ScriptRuntime.checkDynamicScope(context.topCallScope, (Scriptable)object);
                }
            }
            object = scriptable;
            while (!(object instanceof NativeWith) || !(object.getPrototype() instanceof XMLObject)) {
                Object object2 = object.get(string2, scriptable);
                if (object2 != Scriptable.NOT_FOUND) {
                    return ScriptRuntime.doScriptableIncrDecr((Scriptable)object, string2, scriptable, object2, n);
                }
                object = object2 = object.getPrototype();
                if (object2 != null) continue;
            }
        } while ((object = scriptable.getParentScope()) != null);
        throw ScriptRuntime.notFoundError((Scriptable)object, string2);
    }

    private static Object nameOrFunction(Context context, Scriptable object, Scriptable object2, String string2, boolean bl) {
        Object object3 = null;
        Object object4 = object;
        while (true) {
            Object object5;
            Object object6;
            block18: {
                block15: {
                    block16: {
                        block17: {
                            block12: {
                                block13: {
                                    block14: {
                                        if (!(object4 instanceof NativeWith)) break block12;
                                        object6 = object4.getPrototype();
                                        if (!(object6 instanceof XMLObject)) break block13;
                                        object4 = (XMLObject)object6;
                                        if (!((IdScriptableObject)object4).has(string2, (Scriptable)object4)) break block14;
                                        object2 = ((IdScriptableObject)object4).get(string2, (Scriptable)object4);
                                        object = object4;
                                        break block15;
                                    }
                                    object5 = object3;
                                    if (object3 != null) break block16;
                                    object5 = object4;
                                    break block16;
                                }
                                object4 = ScriptableObject.getProperty((Scriptable)object6, string2);
                                object5 = object3;
                                if (object4 == Scriptable.NOT_FOUND) break block16;
                                object = object6;
                                object2 = object4;
                                break block15;
                            }
                            if (!(object4 instanceof NativeCall)) break block17;
                            object4 = object4.get(string2, (Scriptable)object4);
                            object5 = object3;
                            if (object4 == Scriptable.NOT_FOUND) break block16;
                            if (bl) {
                                object = ScriptableObject.getTopLevelScope((Scriptable)object2);
                            }
                            object2 = object4;
                            break block15;
                        }
                        object6 = ScriptableObject.getProperty((Scriptable)object4, string2);
                        object5 = object3;
                        if (object6 == Scriptable.NOT_FOUND) break block16;
                        object2 = object6;
                        object = object4;
                        break block15;
                    }
                    if ((object6 = object2.getParentScope()) != null) break block18;
                    object = object4 = ScriptRuntime.topScopeName(context, (Scriptable)object2, string2);
                    if (object4 == Scriptable.NOT_FOUND) {
                        if (object5 != null && !bl) {
                            object = ((IdScriptableObject)object5).get(string2, (Scriptable)object5);
                        } else {
                            throw ScriptRuntime.notFoundError((Scriptable)object2, string2);
                        }
                    }
                    object4 = object2;
                    object2 = object;
                    object = object4;
                }
                if (bl) {
                    if (object2 instanceof Callable) {
                        ScriptRuntime.storeScriptable(context, (Scriptable)object);
                    } else {
                        throw ScriptRuntime.notFunctionError(object2, string2);
                    }
                }
                return object2;
            }
            object3 = object5;
            object4 = object2;
            object2 = object6;
        }
    }

    public static Ref nameRef(Object object, Object object2, Context context, Scriptable scriptable, int n) {
        return ScriptRuntime.currentXMLLib(context).nameRef(context, object, object2, scriptable, n);
    }

    public static Ref nameRef(Object object, Context context, Scriptable scriptable, int n) {
        return ScriptRuntime.currentXMLLib(context).nameRef(context, object, scriptable, n);
    }

    public static Scriptable newArrayLiteral(Object[] objectArray, int[] nArray, Context object, Scriptable scriptable) {
        int n;
        int n2;
        int n3 = objectArray.length;
        int n4 = nArray != null ? nArray.length : 0;
        int n5 = n3 + n4;
        if (n5 > 1 && n4 * 2 < n5) {
            if (n4 != 0) {
                Object[] objectArray2 = new Object[n5];
                n3 = 0;
                n2 = 0;
                for (n = 0; n != n5; ++n) {
                    if (n3 != n4 && nArray[n3] == n) {
                        objectArray2[n] = Scriptable.NOT_FOUND;
                        ++n3;
                        continue;
                    }
                    objectArray2[n] = objectArray[n2];
                    ++n2;
                }
                objectArray = objectArray2;
            }
            return ((Context)object).newArray(scriptable, objectArray);
        }
        object = ((Context)object).newArray(scriptable, n5);
        n3 = 0;
        n = 0;
        for (n2 = 0; n2 != n5; ++n2) {
            if (n3 != n4 && nArray[n3] == n2) {
                ++n3;
                continue;
            }
            object.put(n2, (Scriptable)object, objectArray[n]);
            ++n;
        }
        return object;
    }

    public static Scriptable newBuiltinObject(Context context, Scriptable objectArray, TopLevel.Builtins object, Object[] objectArray2) {
        Scriptable scriptable = ScriptableObject.getTopLevelScope((Scriptable)objectArray);
        object = TopLevel.getBuiltinCtor(context, scriptable, (TopLevel.Builtins)((Object)object));
        objectArray = objectArray2;
        if (objectArray2 == null) {
            objectArray = emptyArgs;
        }
        return object.construct(context, scriptable, objectArray);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Scriptable newCatchScope(Throwable var0, Scriptable var1_1, String var2_2, Context var3_3, Scriptable var4_4) {
        block19: {
            block14: {
                block15: {
                    block18: {
                        block17: {
                            block16: {
                                var5_5 = var0 instanceof JavaScriptException;
                                var6_6 = 0;
                                if (!var5_5) break block16;
                                var1_1 = ((JavaScriptException)var0).getValue();
                                break block14;
                            }
                            if (var1_1 != null) {
                                var1_1 = var7_7 /* !! */  = ((NativeObject)var1_1).getAssociatedValue(var0);
                                if (var7_7 /* !! */  == null) {
                                    Kit.codeBug();
                                    var1_1 = var7_7 /* !! */ ;
                                }
lbl13:
                                // 4 sources

                                while (true) {
                                    var6_6 = 1;
                                    break block14;
                                    break;
                                }
                            }
                            if (var0 instanceof EcmaError) {
                                var1_1 = (EcmaError)var0;
                                var7_7 /* !! */  = TopLevel.NativeErrors.valueOf(var1_1.getName());
                                var8_8 = var1_1.getErrorMessage();
lbl20:
                                // 3 sources

                                while (true) {
                                    var9_9 = var8_8;
                                    var8_8 = null;
                                    break block15;
                                    break;
                                }
                            }
                            if (!(var0 instanceof WrappedException)) break block17;
                            var1_1 = (WrappedException)var0;
                            var8_8 = var1_1.getWrappedException();
                            var7_7 /* !! */  = TopLevel.NativeErrors.JavaException;
                            var9_9 = new StringBuilder();
                            var9_9.append(var8_8.getClass().getName());
                            var9_9.append(": ");
                            var9_9.append(var8_8.getMessage());
                            var9_9 = var9_9.toString();
                            break block15;
                        }
                        if (!(var0 instanceof EvaluatorException)) break block18;
                        var1_1 = (EvaluatorException)var0;
                        var7_7 /* !! */  = TopLevel.NativeErrors.InternalError;
                        var8_8 = var1_1.getMessage();
                        ** GOTO lbl20
                    }
                    if (var3_3.hasFeature(13)) {
                        var1_1 = new WrappedException(var0);
                        var7_7 /* !! */  = TopLevel.NativeErrors.JavaException;
                        var8_8 = var0.toString();
                        ** continue;
                    }
                    break block19;
                }
                var11_11 = var10_10 = var1_1.sourceName();
                if (var10_10 == null) {
                    var11_11 = "";
                }
                if ((var6_6 = var1_1.lineNumber()) > 0) {
                    var10_10 = new Object[]{var9_9, var11_11, var6_6};
                    var9_9 = var10_10;
                } else {
                    var10_10 = new Object[]{var9_9, var11_11};
                    var9_9 = var10_10;
                }
                var7_7 /* !! */  = ScriptRuntime.newNativeError(var3_3, var4_4, (TopLevel.NativeErrors)var7_7 /* !! */ , var9_9);
                if (var7_7 /* !! */  instanceof NativeError) {
                    ((NativeError)var7_7 /* !! */ ).setStackProvider((RhinoException)var1_1);
                }
                if (var8_8 != null && ScriptRuntime.isVisible(var3_3, var8_8)) {
                    ScriptableObject.defineProperty((Scriptable)var7_7 /* !! */ , "javaException", var3_3.getWrapFactory().wrap(var3_3, var4_4, var8_8, null), 7);
                }
                if (ScriptRuntime.isVisible(var3_3, var1_1)) {
                    ScriptableObject.defineProperty((Scriptable)var7_7 /* !! */ , "rhinoException", var3_3.getWrapFactory().wrap(var3_3, var4_4, var1_1, null), 7);
                }
                var1_1 = var7_7 /* !! */ ;
                ** while (true)
            }
            var7_7 /* !! */  = new NativeObject();
            var7_7 /* !! */ .defineProperty(var2_2, var1_1, 4);
            if (ScriptRuntime.isVisible(var3_3, var0)) {
                var7_7 /* !! */ .defineProperty("__exception__", Context.javaToJS(var0, var4_4), 6);
            }
            if (var6_6 != 0) {
                var7_7 /* !! */ .associateValue(var0, var1_1);
            }
            return var7_7 /* !! */ ;
        }
        throw Kit.codeBug();
    }

    static Scriptable newNativeError(Context context, Scriptable objectArray, TopLevel.NativeErrors object, Object[] objectArray2) {
        Scriptable scriptable = ScriptableObject.getTopLevelScope((Scriptable)objectArray);
        object = TopLevel.getNativeErrorCtor(context, scriptable, (TopLevel.NativeErrors)((Object)object));
        objectArray = objectArray2;
        if (objectArray2 == null) {
            objectArray = emptyArgs;
        }
        return object.construct(context, scriptable, objectArray);
    }

    public static Scriptable newObject(Object object, Context context, Scriptable scriptable, Object[] objectArray) {
        if (object instanceof Function) {
            return ((Function)object).construct(context, scriptable, objectArray);
        }
        throw ScriptRuntime.notFunctionError(object);
    }

    public static Scriptable newObject(Context context, Scriptable objectArray, String object, Object[] objectArray2) {
        Scriptable scriptable = ScriptableObject.getTopLevelScope((Scriptable)objectArray);
        object = ScriptRuntime.getExistingCtor(context, scriptable, (String)object);
        objectArray = objectArray2;
        if (objectArray2 == null) {
            objectArray = emptyArgs;
        }
        return object.construct(context, scriptable, objectArray);
    }

    @Deprecated
    public static Scriptable newObjectLiteral(Object[] objectArray, Object[] objectArray2, Context context, Scriptable scriptable) {
        return ScriptRuntime.newObjectLiteral(objectArray, objectArray2, null, context, scriptable);
    }

    public static Scriptable newObjectLiteral(Object[] objectArray, Object[] objectArray2, int[] nArray, Context context, Scriptable scriptable) {
        Scriptable scriptable2 = context.newObject(scriptable);
        int n = objectArray.length;
        for (int i = 0; i != n; ++i) {
            Object object = objectArray[i];
            int n2 = nArray == null ? 0 : nArray[i];
            Object object2 = objectArray2[i];
            if (object instanceof String) {
                if (n2 == 0) {
                    if (ScriptRuntime.isSpecialProperty((String)(object = (String)object))) {
                        ScriptRuntime.specialRef(scriptable2, (String)object, context, scriptable).set(context, scriptable, object2);
                        continue;
                    }
                    scriptable2.put((String)object, scriptable2, object2);
                    continue;
                }
                ScriptableObject scriptableObject = (ScriptableObject)scriptable2;
                object2 = (Callable)object2;
                boolean bl = true;
                if (n2 != 1) {
                    bl = false;
                }
                scriptableObject.setGetterOrSetter((String)object, 0, (Callable)object2, bl);
                continue;
            }
            scriptable2.put((Integer)object, scriptable2, object2);
        }
        return scriptable2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object newSpecial(Context context, Object object, Object[] objectArray, Scriptable scriptable, int n) {
        if (n == 1) {
            if (!NativeGlobal.isEvalFunction(object)) return ScriptRuntime.newObject(object, context, scriptable, objectArray);
            throw ScriptRuntime.typeError1("msg.not.ctor", "eval");
        }
        if (n != 2) throw Kit.codeBug();
        if (!NativeWith.isWithFunction(object)) return ScriptRuntime.newObject(object, context, scriptable, objectArray);
        return NativeWith.newWithSpecial(context, scriptable, objectArray);
    }

    public static RuntimeException notFoundError(Scriptable scriptable, String string2) {
        throw ScriptRuntime.constructError("ReferenceError", ScriptRuntime.getMessage1("msg.is.not.defined", string2));
    }

    public static RuntimeException notFunctionError(Object object) {
        return ScriptRuntime.notFunctionError(object, object);
    }

    public static RuntimeException notFunctionError(Object object, Object object2) {
        object2 = object2 == null ? "null" : object2.toString();
        if (object == Scriptable.NOT_FOUND) {
            return ScriptRuntime.typeError1("msg.function.not.found", object2);
        }
        return ScriptRuntime.typeError2("msg.isnt.function", object2, ScriptRuntime.typeof(object));
    }

    public static RuntimeException notFunctionError(Object object, Object object2, String string2) {
        String string3;
        String string4 = string3 = ScriptRuntime.toString(object);
        if (object instanceof NativeFunction) {
            int n = string3.indexOf(123, string3.indexOf(41));
            string4 = string3;
            if (n > -1) {
                object = new StringBuilder();
                ((StringBuilder)object).append(string3.substring(0, n + 1));
                ((StringBuilder)object).append("...}");
                string4 = ((StringBuilder)object).toString();
            }
        }
        if (object2 == Scriptable.NOT_FOUND) {
            return ScriptRuntime.typeError2("msg.function.not.found.in", string2, string4);
        }
        return ScriptRuntime.typeError3("msg.isnt.function.in", string2, string4, ScriptRuntime.typeof(object2));
    }

    private static RuntimeException notXmlError(Object object) {
        throw ScriptRuntime.typeError1("msg.isnt.xml.object", ScriptRuntime.toString(object));
    }

    public static String numberToString(double d, int n) {
        if (n >= 2 && n <= 36) {
            if (d != d) {
                return "NaN";
            }
            if (d == Double.POSITIVE_INFINITY) {
                return "Infinity";
            }
            if (d == Double.NEGATIVE_INFINITY) {
                return "-Infinity";
            }
            if (d == 0.0) {
                return "0";
            }
            if (n != 10) {
                return DToA.JS_dtobasestr(n, d);
            }
            CharSequence charSequence = FastDtoa.numberToString(d);
            if (charSequence != null) {
                return charSequence;
            }
            charSequence = new StringBuilder();
            DToA.JS_dtostr((StringBuilder)charSequence, 0, 0, d);
            return ((StringBuilder)charSequence).toString();
        }
        throw Context.reportRuntimeError1("msg.bad.radix", Integer.toString(n));
    }

    public static Object[] padArguments(Object[] objectArray, int n) {
        if (n < objectArray.length) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        while (true) {
            if (n2 >= objectArray.length) break;
            objectArray2[n2] = objectArray[n2];
        }
        for (int i = ++n2; i < n; ++i) {
            objectArray2[i] = Undefined.instance;
        }
        return objectArray2;
    }

    @Deprecated
    public static Object propIncrDecr(Object object, String string2, Context context, int n) {
        return ScriptRuntime.propIncrDecr(object, string2, context, ScriptRuntime.getTopCallScope(context), n);
    }

    public static Object propIncrDecr(Object object, String string2, Context object2, Scriptable object3, int n) {
        if ((object2 = ScriptRuntime.toObjectOrNull((Context)object2, object, (Scriptable)object3)) != null) {
            object = object2;
            do {
                if ((object3 = object.get(string2, (Scriptable)object2)) != Scriptable.NOT_FOUND) {
                    return ScriptRuntime.doScriptableIncrDecr((Scriptable)object, string2, (Scriptable)object2, object3, n);
                }
                object = object3 = object.getPrototype();
            } while (object3 != null);
            object = NaNobj;
            object2.put(string2, (Scriptable)object2, object);
            return object;
        }
        throw ScriptRuntime.undefReadError(object, string2);
    }

    public static EcmaError rangeError(String string2) {
        return ScriptRuntime.constructError("RangeError", string2);
    }

    public static Object refDel(Ref ref, Context context) {
        return ScriptRuntime.wrapBoolean(ref.delete(context));
    }

    public static Object refGet(Ref ref, Context context) {
        return ref.get(context);
    }

    @Deprecated
    public static Object refIncrDecr(Ref ref, Context context, int n) {
        return ScriptRuntime.refIncrDecr(ref, context, ScriptRuntime.getTopCallScope(context), n);
    }

    public static Object refIncrDecr(Ref ref, Context context, Scriptable scriptable, int n) {
        double d;
        Object object = ref.get(context);
        boolean bl = (n & 2) != 0;
        if (object instanceof Number) {
            d = ((Number)object).doubleValue();
        } else {
            double d2;
            d = d2 = ScriptRuntime.toNumber(object);
            if (bl) {
                object = ScriptRuntime.wrapNumber(d2);
                d = d2;
            }
        }
        d = (n & 1) == 0 ? (d += 1.0) : (d -= 1.0);
        Number number = ScriptRuntime.wrapNumber(d);
        ref.set(context, scriptable, number);
        if (bl) {
            return object;
        }
        return number;
    }

    @Deprecated
    public static Object refSet(Ref ref, Object object, Context context) {
        return ScriptRuntime.refSet(ref, object, context, ScriptRuntime.getTopCallScope(context));
    }

    public static Object refSet(Ref ref, Object object, Context context, Scriptable scriptable) {
        return ref.set(context, scriptable, object);
    }

    public static boolean same(Object object, Object object2) {
        if (!ScriptRuntime.typeof(object).equals(ScriptRuntime.typeof(object2))) {
            return false;
        }
        if (object instanceof Number) {
            if (ScriptRuntime.isNaN(object) && ScriptRuntime.isNaN(object2)) {
                return true;
            }
            return object.equals(object2);
        }
        return ScriptRuntime.eq(object, object2);
    }

    public static Object searchDefaultNamespace(Context object) {
        NativeCall nativeCall = ((Context)object).currentActivationCall;
        Object object2 = nativeCall;
        if (nativeCall == null) {
            object2 = ScriptRuntime.getTopCallScope((Context)object);
        }
        while (true) {
            block9: {
                block8: {
                    block7: {
                        if ((object = object2.getParentScope()) != null) break block7;
                        object = object2 = ScriptableObject.getProperty((Scriptable)object2, DEFAULT_NS_TAG);
                        if (object2 == Scriptable.NOT_FOUND) {
                            return null;
                        }
                        break block8;
                    }
                    if ((object2 = object2.get(DEFAULT_NS_TAG, (Scriptable)object2)) == Scriptable.NOT_FOUND) break block9;
                    object = object2;
                }
                return object;
            }
            object2 = object;
        }
    }

    public static void setBuiltinProtoAndParent(ScriptableObject scriptableObject, Scriptable scriptable, TopLevel.Builtins builtins) {
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        scriptableObject.setParentScope(scriptable);
        scriptableObject.setPrototype(TopLevel.getBuiltinPrototype(scriptable, builtins));
    }

    public static Object setConst(Scriptable scriptable, Object object, Context context, String string2) {
        if (scriptable instanceof XMLObject) {
            scriptable.put(string2, scriptable, object);
        } else {
            ScriptableObject.putConstProperty(scriptable, string2, object);
        }
        return object;
    }

    public static Object setDefaultNamespace(Object object, Context context) {
        NativeCall nativeCall = context.currentActivationCall;
        Scriptable scriptable = nativeCall;
        if (nativeCall == null) {
            scriptable = ScriptRuntime.getTopCallScope(context);
        }
        object = ScriptRuntime.currentXMLLib(context).toDefaultXmlNamespace(context, object);
        if (!scriptable.has(DEFAULT_NS_TAG, scriptable)) {
            ScriptableObject.defineProperty(scriptable, DEFAULT_NS_TAG, object, 6);
        } else {
            scriptable.put(DEFAULT_NS_TAG, scriptable, object);
        }
        return Undefined.instance;
    }

    public static void setEnumNumbers(Object object, boolean bl) {
        ((IdEnumeration)object).enumNumbers = bl;
    }

    public static void setFunctionProtoAndParent(BaseFunction baseFunction, Scriptable scriptable) {
        baseFunction.setParentScope(scriptable);
        baseFunction.setPrototype(ScriptableObject.getFunctionPrototype(scriptable));
    }

    public static Object setName(Scriptable scriptable, Object object, Context context, Scriptable scriptable2, String string2) {
        if (scriptable != null) {
            ScriptableObject.putProperty(scriptable, string2, object);
        } else {
            if (context.hasFeature(11) || context.hasFeature(8)) {
                Context.reportWarning(ScriptRuntime.getMessage1("msg.assn.create.strict", string2));
            }
            scriptable = scriptable2 = ScriptableObject.getTopLevelScope(scriptable2);
            if (context.useDynamicScope) {
                scriptable = ScriptRuntime.checkDynamicScope(context.topCallScope, scriptable2);
            }
            scriptable.put(string2, scriptable, object);
        }
        return object;
    }

    @Deprecated
    public static Object setObjectElem(Object object, Object object2, Object object3, Context context) {
        return ScriptRuntime.setObjectElem(object, object2, object3, context, ScriptRuntime.getTopCallScope(context));
    }

    public static Object setObjectElem(Object object, Object object2, Object object3, Context context, Scriptable scriptable) {
        if ((scriptable = ScriptRuntime.toObjectOrNull(context, object, scriptable)) != null) {
            return ScriptRuntime.setObjectElem(scriptable, object2, object3, context);
        }
        throw ScriptRuntime.undefWriteError(object, object2, object3);
    }

    public static Object setObjectElem(Scriptable scriptable, Object object, Object object2, Context context) {
        if (scriptable instanceof XMLObject) {
            ((XMLObject)scriptable).put(context, object, object2);
        } else if (ScriptRuntime.isSymbol(object)) {
            ScriptableObject.putProperty(scriptable, (Symbol)object, object2);
        } else if ((object = ScriptRuntime.toStringIdOrIndex(context, object)) == null) {
            ScriptableObject.putProperty(scriptable, ScriptRuntime.lastIndexResult(context), object2);
        } else {
            ScriptableObject.putProperty(scriptable, (String)object, object2);
        }
        return object2;
    }

    @Deprecated
    public static Object setObjectIndex(Object object, double d, Object object2, Context context) {
        return ScriptRuntime.setObjectIndex(object, d, object2, context, ScriptRuntime.getTopCallScope(context));
    }

    public static Object setObjectIndex(Object object, double d, Object object2, Context context, Scriptable scriptable) {
        if ((scriptable = ScriptRuntime.toObjectOrNull(context, object, scriptable)) != null) {
            int n = (int)d;
            if ((double)n == d) {
                return ScriptRuntime.setObjectIndex(scriptable, n, object2, context);
            }
            return ScriptRuntime.setObjectProp(scriptable, ScriptRuntime.toString(d), object2, context);
        }
        throw ScriptRuntime.undefWriteError(object, String.valueOf(d), object2);
    }

    public static Object setObjectIndex(Scriptable scriptable, int n, Object object, Context context) {
        ScriptableObject.putProperty(scriptable, n, object);
        return object;
    }

    @Deprecated
    public static Object setObjectProp(Object object, String string2, Object object2, Context context) {
        return ScriptRuntime.setObjectProp(object, string2, object2, context, ScriptRuntime.getTopCallScope(context));
    }

    public static Object setObjectProp(Object object, String string2, Object object2, Context context, Scriptable scriptable) {
        if ((scriptable = ScriptRuntime.toObjectOrNull(context, object, scriptable)) != null) {
            return ScriptRuntime.setObjectProp(scriptable, string2, object2, context);
        }
        throw ScriptRuntime.undefWriteError(object, string2, object2);
    }

    public static Object setObjectProp(Scriptable scriptable, String string2, Object object, Context context) {
        ScriptableObject.putProperty(scriptable, string2, object);
        return object;
    }

    public static void setObjectProtoAndParent(ScriptableObject scriptableObject, Scriptable scriptable) {
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        scriptableObject.setParentScope(scriptable);
        scriptableObject.setPrototype(ScriptableObject.getClassPrototype(scriptable, scriptableObject.getClassName()));
    }

    public static void setRegExpProxy(Context context, RegExpProxy regExpProxy) {
        if (regExpProxy != null) {
            context.regExpProxy = regExpProxy;
            return;
        }
        throw new IllegalArgumentException();
    }

    public static boolean shallowEq(Object object, Object object2) {
        block15: {
            boolean bl;
            boolean bl2;
            block20: {
                block17: {
                    boolean bl3;
                    block19: {
                        block18: {
                            block16: {
                                boolean bl4 = false;
                                bl3 = false;
                                bl2 = false;
                                bl = false;
                                if (object == object2) {
                                    if (!(object instanceof Number)) {
                                        return true;
                                    }
                                    double d = ((Number)object).doubleValue();
                                    if (d == d) {
                                        bl = true;
                                    }
                                    return bl;
                                }
                                if (object == null || object == Undefined.instance || object == Undefined.SCRIPTABLE_UNDEFINED) break block15;
                                if (!(object instanceof Number)) break block16;
                                bl = bl3;
                                if (object2 instanceof Number) {
                                    bl = bl4;
                                    if (((Number)object).doubleValue() == ((Number)object2).doubleValue()) {
                                        bl = true;
                                    }
                                    return bl;
                                }
                                break block17;
                            }
                            if (!(object instanceof CharSequence)) break block18;
                            bl = bl3;
                            if (object2 instanceof CharSequence) {
                                return object.toString().equals(object2.toString());
                            }
                            break block17;
                        }
                        if (!(object instanceof Boolean)) break block19;
                        bl = bl3;
                        if (object2 instanceof Boolean) {
                            return object.equals(object2);
                        }
                        break block17;
                    }
                    if (!(object instanceof Scriptable)) break block20;
                    bl = bl3;
                    if (object instanceof Wrapper) {
                        bl = bl3;
                        if (object2 instanceof Wrapper) {
                            bl = bl3;
                            if (((Wrapper)object).unwrap() == ((Wrapper)object2).unwrap()) {
                                bl = true;
                            }
                        }
                    }
                }
                return bl;
            }
            ScriptRuntime.warnAboutNonJSObject(object);
            bl = bl2;
            if (object == object2) {
                bl = true;
            }
            return bl;
        }
        return object == Undefined.instance && object2 == Undefined.SCRIPTABLE_UNDEFINED || object == Undefined.SCRIPTABLE_UNDEFINED && object2 == Undefined.instance;
    }

    @Deprecated
    public static Ref specialRef(Object object, String string2, Context context) {
        return ScriptRuntime.specialRef(object, string2, context, ScriptRuntime.getTopCallScope(context));
    }

    public static Ref specialRef(Object object, String string2, Context context, Scriptable scriptable) {
        return SpecialRef.createSpecial(context, scriptable, object, string2);
    }

    private static void storeIndexResult(Context context, int n) {
        context.scratchIndex = n;
    }

    private static void storeScriptable(Context context, Scriptable scriptable) {
        if (context.scratchScriptable == null) {
            context.scratchScriptable = scriptable;
            return;
        }
        throw new IllegalStateException();
    }

    public static void storeUint32Result(Context context, long l) {
        if (l >>> 32 == 0L) {
            context.scratchUint32 = l;
            return;
        }
        throw new IllegalArgumentException();
    }

    public static Object strictSetName(Scriptable object, Object object2, Context context, Scriptable scriptable, String string2) {
        if (object != null) {
            ScriptableObject.putProperty((Scriptable)object, string2, object2);
            return object2;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Assignment to undefined \"");
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append("\" in strict mode");
        throw ScriptRuntime.constructError("ReferenceError", ((StringBuilder)object).toString());
    }

    static double stringPrefixToNumber(String string2, int n, int n2) {
        return ScriptRuntime.stringToNumber(string2, n, string2.length() - 1, n2, true);
    }

    static double stringToNumber(String string2, int n, int n2, int n3) {
        return ScriptRuntime.stringToNumber(string2, n, n2, n3, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static double stringToNumber(String string2, int n, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = n3 < 10 ? (int)((char)(n3 + 48 - 1)) : 57;
        if (n3 > 10) {
            n7 = (char)(n3 + 97 - 10);
            n6 = (char)(n3 + 65 - 10);
        } else {
            n7 = 97;
            n6 = 65;
        }
        double d = 0.0;
        for (n5 = n; n5 <= n2; ++n5) {
            block26: {
                block23: {
                    block25: {
                        block24: {
                            block22: {
                                n4 = string2.charAt(n5);
                                if (48 > n4 || n4 > n8) break block22;
                                n4 -= 48;
                                break block23;
                            }
                            if (97 > n4 || n4 >= n7) break block24;
                            n4 -= 97;
                            break block25;
                        }
                        if (65 > n4 || n4 >= n6) break block26;
                        n4 -= 65;
                    }
                    n4 += 10;
                }
                d = d * (double)n3 + (double)n4;
                continue;
            }
            if (bl) break;
            return NaN;
        }
        if (n == n5) {
            return NaN;
        }
        double d2 = d;
        if (!(d >= 9.007199254740992E15)) return d2;
        if (n3 == 10) {
            try {
                return Double.parseDouble(string2.substring(n, n5));
            }
            catch (NumberFormatException numberFormatException) {
                return NaN;
            }
        }
        if (n3 != 2 && n3 != 4 && n3 != 8 && n3 != 16) {
            d2 = d;
            if (n3 != 32) return d2;
        }
        int n9 = 53;
        n2 = 1;
        n8 = 0;
        n4 = 0;
        n6 = 0;
        int n10 = 0;
        double d3 = 0.0;
        int n11 = n;
        while (true) {
            int n12;
            int n13;
            int n14;
            int n15;
            block32: {
                block27: {
                    block28: {
                        block29: {
                            block31: {
                                block30: {
                                    n15 = n11;
                                    n = n2;
                                    if (n2 == 1) {
                                        if (n11 == n5) {
                                            if (n8 == 0) {
                                                return 0.0;
                                            }
                                            if (n8 != 3) {
                                                if (n8 != 4) break;
                                                d2 = d;
                                                if (n4 == 0) return d2 * d3;
                                            } else {
                                                d2 = d;
                                                if ((n4 & n6) == 0) return d2 * d3;
                                            }
                                            d2 = d + 1.0;
                                            return d2 * d3;
                                        }
                                        n = string2.charAt(n11);
                                        n = 48 <= n && n <= 57 ? (n -= 48) : (97 <= n && n <= 122 ? (n -= 87) : (n -= 55));
                                        n15 = n11 + 1;
                                        n2 = n3;
                                        n10 = n;
                                        n = n2;
                                    }
                                    n2 = (n10 & (n14 = n >> 1)) != 0 ? 1 : 0;
                                    if (n8 == 0) break block27;
                                    if (n8 == 1) break block28;
                                    if (n8 == 2) break block29;
                                    if (n8 == 3) break block30;
                                    n = n8;
                                    if (n8 == 4) break block31;
                                    n7 = n9;
                                    n = n8;
                                    n13 = n4;
                                    n12 = n6;
                                    d2 = d3;
                                    break block32;
                                }
                                n = n8;
                                if (n2 != 0) {
                                    n = 4;
                                }
                            }
                            d2 = d3 * 2.0;
                            n7 = n9;
                            n13 = n4;
                            n12 = n6;
                            break block32;
                        }
                        d2 = 2.0;
                        n = 3;
                        n7 = n9;
                        n13 = n2;
                        n12 = n6;
                        break block32;
                    }
                    double d4 = d *= 2.0;
                    if (n2 != 0) {
                        d4 = d + 1.0;
                    }
                    n7 = --n9;
                    n = n8;
                    n13 = n4;
                    n12 = n6;
                    d = d4;
                    d2 = d3;
                    if (n9 == 0) {
                        n = 2;
                        n7 = n9;
                        n13 = n4;
                        n12 = n2;
                        d = d4;
                        d2 = d3;
                    }
                    break block32;
                }
                n7 = n9;
                n = n8;
                n13 = n4;
                n12 = n6;
                d2 = d3;
                if (n2 != 0) {
                    n7 = n9 - 1;
                    d = 1.0;
                    n = 1;
                    d2 = d3;
                    n12 = n6;
                    n13 = n4;
                }
            }
            n11 = n15;
            n9 = n7;
            n2 = n14;
            n8 = n;
            n4 = n13;
            n6 = n12;
            d3 = d2;
        }
        d2 = d;
        return d2;
    }

    public static long testUint32String(String string2) {
        int n = string2.length();
        long l = -1L;
        if (1 <= n && n <= 10) {
            int n2 = string2.charAt(0) - 48;
            if (n2 == 0) {
                if (n == 1) {
                    l = 0L;
                }
                return l;
            }
            if (1 <= n2 && n2 <= 9) {
                l = n2;
                for (int i = 1; i != n; ++i) {
                    n2 = string2.charAt(i) - 48;
                    if (n2 >= 0 && n2 <= 9) {
                        l = l * 10L + (long)n2;
                        continue;
                    }
                    return -1L;
                }
                if (l >>> 32 == 0L) {
                    return l;
                }
            }
        }
        return -1L;
    }

    public static JavaScriptException throwCustomError(Context context, Scriptable scriptable, String string2, String string3) {
        int[] nArray = new int[]{0};
        String string4 = Context.getSourcePositionFromStack(nArray);
        return new JavaScriptException(context.newObject(scriptable, string2, new Object[]{string3, string4, nArray[0]}), string4, nArray[0]);
    }

    public static JavaScriptException throwError(Context context, Scriptable scriptable, String string2) {
        int[] nArray = new int[]{0};
        String string3 = Context.getSourcePositionFromStack(nArray);
        return new JavaScriptException(ScriptRuntime.newBuiltinObject(context, scriptable, TopLevel.Builtins.Error, new Object[]{string2, string3, nArray[0]}), string3, nArray[0]);
    }

    public static boolean toBoolean(Object object) {
        block9: {
            block10: {
                Object object2;
                while (true) {
                    if (object instanceof Boolean) {
                        return (Boolean)object;
                    }
                    boolean bl = false;
                    boolean bl2 = false;
                    if (object == null || object == Undefined.instance) break block9;
                    if (object instanceof CharSequence) {
                        if (((CharSequence)object).length() != 0) {
                            bl2 = true;
                        }
                        return bl2;
                    }
                    if (object instanceof Number) {
                        double d = ((Number)object).doubleValue();
                        bl2 = bl;
                        if (d == d) {
                            bl2 = bl;
                            if (d != 0.0) {
                                bl2 = true;
                            }
                        }
                        return bl2;
                    }
                    if (!(object instanceof Scriptable)) break block10;
                    if (object instanceof ScriptableObject && ((ScriptableObject)object).avoidObjectDetection()) {
                        return false;
                    }
                    if (Context.getContext().isVersionECMA1()) {
                        return true;
                    }
                    object = object2 = ((Scriptable)object).getDefaultValue(BooleanClass);
                    if (!(object2 instanceof Scriptable)) continue;
                    if (!ScriptRuntime.isSymbol(object2)) break;
                    object = object2;
                }
                throw ScriptRuntime.errorWithClassName("msg.primitive.expected", object2);
            }
            ScriptRuntime.warnAboutNonJSObject(object);
            return true;
        }
        return false;
    }

    public static CharSequence toCharSequence(Object object) {
        if (object instanceof NativeString) {
            return ((NativeString)object).toCharSequence();
        }
        object = object instanceof CharSequence ? (CharSequence)object : ScriptRuntime.toString(object);
        return object;
    }

    public static int toInt32(double d) {
        return DoubleConversion.doubleToInt32(d);
    }

    public static int toInt32(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return ScriptRuntime.toInt32(ScriptRuntime.toNumber(object));
    }

    public static int toInt32(Object[] objectArray, int n) {
        n = n < objectArray.length ? ScriptRuntime.toInt32(objectArray[n]) : 0;
        return n;
    }

    public static double toInteger(double d) {
        if (d != d) {
            return 0.0;
        }
        double d2 = d - 0.0;
        double d3 = d2 == 0.0 ? 0 : (d2 > 0.0 ? 1 : -1);
        double d4 = d;
        if (d3 != false) {
            d4 = d;
            if (d != Double.POSITIVE_INFINITY) {
                if (d == Double.NEGATIVE_INFINITY) {
                    d4 = d;
                } else {
                    if (d3 > 0) {
                        return Math.floor(d);
                    }
                    d4 = Math.ceil(d);
                }
            }
        }
        return d4;
    }

    public static double toInteger(Object object) {
        return ScriptRuntime.toInteger(ScriptRuntime.toNumber(object));
    }

    public static double toInteger(Object[] objectArray, int n) {
        double d = n < objectArray.length ? ScriptRuntime.toInteger(objectArray[n]) : 0.0;
        return d;
    }

    public static Scriptable toIterator(Context object, Scriptable scriptable, Scriptable scriptable2, boolean bl) {
        if (ScriptableObject.hasProperty(scriptable2, "__iterator__")) {
            Object object2 = ScriptableObject.getProperty(scriptable2, "__iterator__");
            if (object2 instanceof Callable) {
                Callable callable = (Callable)object2;
                if ((object = callable.call((Context)object, scriptable, scriptable2, new Object[]{object2 = bl ? Boolean.TRUE : Boolean.FALSE})) instanceof Scriptable) {
                    return (Scriptable)object;
                }
                throw ScriptRuntime.typeError0("msg.iterator.primitive");
            }
            throw ScriptRuntime.typeError0("msg.invalid.iterator");
        }
        return null;
    }

    public static double toNumber(Object object) {
        block8: {
            block9: {
                Object object2;
                while (true) {
                    if (object instanceof Number) {
                        return ((Number)object).doubleValue();
                    }
                    double d = 0.0;
                    if (object == null) {
                        return 0.0;
                    }
                    if (object == Undefined.instance) {
                        return NaN;
                    }
                    if (object instanceof String) {
                        return ScriptRuntime.toNumber((String)object);
                    }
                    if (object instanceof CharSequence) {
                        return ScriptRuntime.toNumber(object.toString());
                    }
                    if (object instanceof Boolean) {
                        if (((Boolean)object).booleanValue()) {
                            d = 1.0;
                        }
                        return d;
                    }
                    if (object instanceof Symbol) break block8;
                    if (!(object instanceof Scriptable)) break block9;
                    object = object2 = ((Scriptable)object).getDefaultValue(NumberClass);
                    if (!(object2 instanceof Scriptable)) continue;
                    if (!ScriptRuntime.isSymbol(object2)) break;
                    object = object2;
                }
                throw ScriptRuntime.errorWithClassName("msg.primitive.expected", object2);
            }
            ScriptRuntime.warnAboutNonJSObject(object);
            return NaN;
        }
        throw ScriptRuntime.typeError0("msg.not.a.number");
    }

    public static double toNumber(String string2) {
        int n = string2.length();
        int n2 = 0;
        while (true) {
            block19: {
                int n3;
                block20: {
                    char c;
                    block22: {
                        block21: {
                            char c2;
                            if (n2 == n) {
                                return 0.0;
                            }
                            c = string2.charAt(n2);
                            if (ScriptRuntime.isStrWhiteSpaceChar(c)) break block19;
                            n3 = n - 1;
                            while (ScriptRuntime.isStrWhiteSpaceChar(c2 = string2.charAt(n3))) {
                                --n3;
                            }
                            Context context = Context.getCurrentContext();
                            int n4 = context != null && context.getLanguageVersion() >= 200 ? 0 : 1;
                            int n5 = 16;
                            if (c == '0') {
                                int n6 = n2 + 2;
                                if (n6 <= n3) {
                                    char c3 = string2.charAt(n2 + 1);
                                    n = n5;
                                    if (c3 != 'x') {
                                        n = c3 == 'X' ? n5 : (n4 == 0 && (c3 == 'o' || c3 == 'O') ? 8 : (n4 == 0 && (c3 == 'b' || c3 == 'B') ? 2 : -1));
                                    }
                                    if (n != -1) {
                                        if (n4 != 0) {
                                            return ScriptRuntime.stringPrefixToNumber(string2, n6, n);
                                        }
                                        return ScriptRuntime.stringToNumber(string2, n6, n3, n);
                                    }
                                }
                            } else if (!(n4 == 0 || c != '+' && c != '-' || (n4 = n2 + 3) > n3 || string2.charAt(n2 + 1) != '0' || (n = (int)string2.charAt(n2 + 2)) != 120 && n != 88)) {
                                double d;
                                double d2 = d = ScriptRuntime.stringPrefixToNumber(string2, n4, 16);
                                if (c == '-') {
                                    d2 = -d;
                                }
                                return d2;
                            }
                            if (c2 != 'y') break block20;
                            if (c == '+') break block21;
                            n = n2;
                            if (c != '-') break block22;
                        }
                        n = n2 + 1;
                    }
                    if (n + 7 == n3 && string2.regionMatches(n, "Infinity", 0, 8)) {
                        double d = c == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                        return d;
                    }
                    return NaN;
                }
                string2 = string2.substring(n2, n3 + 1);
                for (n = string2.length() - 1; n >= 0; --n) {
                    n2 = string2.charAt(n);
                    if (48 <= n2 && n2 <= 57 || n2 == 46 || n2 == 101 || n2 == 69 || n2 == 43 || n2 == 45) continue;
                    return NaN;
                }
                try {
                    double d = Double.parseDouble(string2);
                    return d;
                }
                catch (NumberFormatException numberFormatException) {
                    return NaN;
                }
            }
            ++n2;
        }
    }

    public static double toNumber(Object[] objectArray, int n) {
        double d = n < objectArray.length ? ScriptRuntime.toNumber(objectArray[n]) : NaN;
        return d;
    }

    public static Scriptable toObject(Context object, Scriptable scriptable, Object object2) {
        if (ScriptRuntime.isSymbol(object2)) {
            object = new NativeSymbol((NativeSymbol)object2);
            ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)object, scriptable, TopLevel.Builtins.Symbol);
            return object;
        }
        if (object2 instanceof Scriptable) {
            return (Scriptable)object2;
        }
        if (object2 instanceof CharSequence) {
            object = new NativeString((CharSequence)object2);
            ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)object, scriptable, TopLevel.Builtins.String);
            return object;
        }
        if (object2 instanceof Number) {
            object = new NativeNumber(((Number)object2).doubleValue());
            ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)object, scriptable, TopLevel.Builtins.Number);
            return object;
        }
        if (object2 instanceof Boolean) {
            object = new NativeBoolean((Boolean)object2);
            ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)object, scriptable, TopLevel.Builtins.Boolean);
            return object;
        }
        if (object2 != null) {
            if (object2 != Undefined.instance) {
                if ((object = ((Context)object).getWrapFactory().wrap((Context)object, scriptable, object2, null)) instanceof Scriptable) {
                    return (Scriptable)object;
                }
                throw ScriptRuntime.errorWithClassName("msg.invalid.type", object2);
            }
            throw ScriptRuntime.typeError0("msg.undef.to.object");
        }
        throw ScriptRuntime.typeError0("msg.null.to.object");
    }

    @Deprecated
    public static Scriptable toObject(Context context, Scriptable scriptable, Object object, Class<?> clazz) {
        return ScriptRuntime.toObject(context, scriptable, object);
    }

    public static Scriptable toObject(Scriptable scriptable, Object object) {
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        return ScriptRuntime.toObject(Context.getContext(), scriptable, object);
    }

    @Deprecated
    public static Scriptable toObject(Scriptable scriptable, Object object, Class<?> clazz) {
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        return ScriptRuntime.toObject(Context.getContext(), scriptable, object);
    }

    @Deprecated
    public static Scriptable toObjectOrNull(Context context, Object object) {
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        if (object != null && object != Undefined.instance) {
            return ScriptRuntime.toObject(context, ScriptRuntime.getTopCallScope(context), object);
        }
        return null;
    }

    public static Scriptable toObjectOrNull(Context context, Object object, Scriptable scriptable) {
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        if (object != null && object != Undefined.instance) {
            return ScriptRuntime.toObject(context, scriptable, object);
        }
        return null;
    }

    public static Object toPrimitive(Object object) {
        return ScriptRuntime.toPrimitive(object, null);
    }

    public static Object toPrimitive(Object object, Class<?> clazz) {
        if (!(object instanceof Scriptable)) {
            return object;
        }
        if ((object = ((Scriptable)object).getDefaultValue(clazz)) instanceof Scriptable && !ScriptRuntime.isSymbol(object)) {
            throw ScriptRuntime.typeError0("msg.bad.default.value");
        }
        return object;
    }

    public static String toString(double d) {
        return ScriptRuntime.numberToString(d, 10);
    }

    public static String toString(Object object) {
        block5: {
            block6: {
                block7: {
                    Object object2;
                    while (true) {
                        if (object == null) {
                            return "null";
                        }
                        if (object == Undefined.instance || object == Undefined.SCRIPTABLE_UNDEFINED) break block5;
                        if (object instanceof String) {
                            return (String)object;
                        }
                        if (object instanceof CharSequence) {
                            return object.toString();
                        }
                        if (object instanceof Number) {
                            return ScriptRuntime.numberToString(((Number)object).doubleValue(), 10);
                        }
                        if (object instanceof Symbol) break block6;
                        if (!(object instanceof Scriptable)) break block7;
                        object = object2 = ((Scriptable)object).getDefaultValue(StringClass);
                        if (!(object2 instanceof Scriptable)) continue;
                        if (!ScriptRuntime.isSymbol(object2)) break;
                        object = object2;
                    }
                    throw ScriptRuntime.errorWithClassName("msg.primitive.expected", object2);
                }
                return object.toString();
            }
            throw ScriptRuntime.typeError0("msg.not.a.string");
        }
        return "undefined";
    }

    public static String toString(Object[] object, int n) {
        object = n < ((Object[])object).length ? ScriptRuntime.toString(object[n]) : "undefined";
        return object;
    }

    static String toStringIdOrIndex(Context context, Object object) {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            int n = (int)d;
            if ((double)n == d) {
                ScriptRuntime.storeIndexResult(context, n);
                return null;
            }
            return ScriptRuntime.toString(object);
        }
        long l = ScriptRuntime.indexFromString((String)(object = object instanceof String ? (String)object : ScriptRuntime.toString(object)));
        if (l >= 0L) {
            ScriptRuntime.storeIndexResult(context, (int)l);
            return null;
        }
        return object;
    }

    public static char toUint16(Object object) {
        return (char)DoubleConversion.doubleToInt32(ScriptRuntime.toNumber(object));
    }

    public static long toUint32(double d) {
        return (long)DoubleConversion.doubleToInt32(d) & 0xFFFFFFFFL;
    }

    public static long toUint32(Object object) {
        return ScriptRuntime.toUint32(ScriptRuntime.toNumber(object));
    }

    private static Object topScopeName(Context context, Scriptable scriptable, String string2) {
        Scriptable scriptable2 = scriptable;
        if (context.useDynamicScope) {
            scriptable2 = ScriptRuntime.checkDynamicScope(context.topCallScope, scriptable);
        }
        return ScriptableObject.getProperty(scriptable2, string2);
    }

    public static EcmaError typeError(String string2) {
        return ScriptRuntime.constructError("TypeError", string2);
    }

    public static EcmaError typeError0(String string2) {
        return ScriptRuntime.typeError(ScriptRuntime.getMessage0(string2));
    }

    public static EcmaError typeError1(String string2, Object object) {
        return ScriptRuntime.typeError(ScriptRuntime.getMessage1(string2, object));
    }

    public static EcmaError typeError2(String string2, Object object, Object object2) {
        return ScriptRuntime.typeError(ScriptRuntime.getMessage2(string2, object, object2));
    }

    public static EcmaError typeError3(String string2, String string3, String string4, String string5) {
        return ScriptRuntime.typeError(ScriptRuntime.getMessage3(string2, string3, string4, string5));
    }

    @Deprecated
    public static BaseFunction typeErrorThrower() {
        return ScriptRuntime.typeErrorThrower(Context.getCurrentContext());
    }

    public static BaseFunction typeErrorThrower(Context context) {
        if (context.typeErrorThrower == null) {
            BaseFunction baseFunction = new BaseFunction(){
                static final long serialVersionUID = -5891740962154902286L;

                @Override
                public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
                    throw ScriptRuntime.typeError0("msg.op.not.allowed");
                }

                @Override
                public int getLength() {
                    return 0;
                }
            };
            ScriptRuntime.setFunctionProtoAndParent(baseFunction, context.topCallScope);
            baseFunction.preventExtensions();
            context.typeErrorThrower = baseFunction;
        }
        return context.typeErrorThrower;
    }

    public static String typeof(Object object) {
        String string2 = "object";
        if (object == null) {
            return "object";
        }
        if (object == Undefined.instance) {
            return "undefined";
        }
        if (object instanceof ScriptableObject) {
            return ((ScriptableObject)object).getTypeOf();
        }
        if (object instanceof Scriptable) {
            if (object instanceof Callable) {
                string2 = "function";
            }
            return string2;
        }
        if (object instanceof CharSequence) {
            return "string";
        }
        if (object instanceof Number) {
            return "number";
        }
        if (object instanceof Boolean) {
            return "boolean";
        }
        throw ScriptRuntime.errorWithClassName("msg.invalid.type", object);
    }

    public static String typeofName(Scriptable scriptable, String string2) {
        Context context = Context.getContext();
        scriptable = ScriptRuntime.bind(context, scriptable, string2);
        if (scriptable == null) {
            return "undefined";
        }
        return ScriptRuntime.typeof(ScriptRuntime.getObjectProp(scriptable, string2, context));
    }

    public static RuntimeException undefCallError(Object object, Object object2) {
        return ScriptRuntime.typeError2("msg.undef.method.call", ScriptRuntime.toString(object), ScriptRuntime.toString(object2));
    }

    private static RuntimeException undefDeleteError(Object object, Object object2) {
        throw ScriptRuntime.typeError2("msg.undef.prop.delete", ScriptRuntime.toString(object), ScriptRuntime.toString(object2));
    }

    public static RuntimeException undefReadError(Object object, Object object2) {
        return ScriptRuntime.typeError2("msg.undef.prop.read", ScriptRuntime.toString(object), ScriptRuntime.toString(object2));
    }

    public static RuntimeException undefWriteError(Object object, Object object2, Object object3) {
        return ScriptRuntime.typeError3("msg.undef.prop.write", ScriptRuntime.toString(object), ScriptRuntime.toString(object2), ScriptRuntime.toString(object3));
    }

    static String uneval(Context object, Scriptable object2, Object object3) {
        if (object3 == null) {
            return "null";
        }
        if (object3 == Undefined.instance) {
            return "undefined";
        }
        if (object3 instanceof CharSequence) {
            object = ScriptRuntime.escapeString(object3.toString());
            object2 = new StringBuilder(((String)object).length() + 2);
            ((StringBuilder)object2).append('\"');
            ((StringBuilder)object2).append((String)object);
            ((StringBuilder)object2).append('\"');
            return ((StringBuilder)object2).toString();
        }
        if (object3 instanceof Number) {
            double d = ((Number)object3).doubleValue();
            if (d == 0.0 && 1.0 / d < 0.0) {
                return "-0";
            }
            return ScriptRuntime.toString(d);
        }
        if (object3 instanceof Boolean) {
            return ScriptRuntime.toString(object3);
        }
        if (object3 instanceof Scriptable) {
            Object object4;
            Scriptable scriptable = (Scriptable)object3;
            if (ScriptableObject.hasProperty(scriptable, "toSource") && (object4 = ScriptableObject.getProperty(scriptable, "toSource")) instanceof Function) {
                return ScriptRuntime.toString(((Function)object4).call((Context)object, (Scriptable)object2, scriptable, emptyArgs));
            }
            return ScriptRuntime.toString(object3);
        }
        ScriptRuntime.warnAboutNonJSObject(object3);
        return object3.toString();
    }

    public static Object updateDotQuery(boolean bl, Scriptable scriptable) {
        return ((NativeWith)scriptable).updateDotQuery(bl);
    }

    private static void warnAboutNonJSObject(Object object) {
        if (!"true".equals(ScriptRuntime.getMessage0("params.omit.non.js.object.warning"))) {
            object = ScriptRuntime.getMessage2("msg.non.js.object.warning", object, object.getClass().getName());
            Context.reportWarning((String)object);
            System.err.println((String)object);
        }
    }

    public static Boolean wrapBoolean(boolean bl) {
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        return bl2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Scriptable wrapException(Throwable var0, Scriptable var1_1, Context var2_2) {
        block15: {
            block13: {
                block14: {
                    if (var0 instanceof EcmaError) {
                        var3_3 = (EcmaError)var0;
                        var0 = var3_3.getName();
                        var4_4 /* !! */  = var3_3.getErrorMessage();
lbl5:
                        // 2 sources

                        while (true) {
                            var5_5 = var0;
                            var0 = null;
                            break block13;
                            break;
                        }
                    }
                    if (!(var0 instanceof WrappedException)) break block14;
                    var3_3 = (WrappedException)var0;
                    var0 = var3_3.getWrappedException();
                    var5_5 = new StringBuilder();
                    var5_5.append(var0.getClass().getName());
                    var5_5.append(": ");
                    var5_5.append(var0.getMessage());
                    var4_4 /* !! */  = var5_5.toString();
                    var5_5 = "JavaException";
                    break block13;
                }
                if (var0 instanceof EvaluatorException) {
                    var3_3 = (EvaluatorException)var0;
                    var4_4 /* !! */  = var3_3.getMessage();
                    var0 = "InternalError";
                    ** continue;
                }
                if (!var2_2.hasFeature(13)) break block15;
                var3_3 = new WrappedException((Throwable)var0);
                var4_4 /* !! */  = var0.toString();
                var5_5 = "JavaException";
                var0 = null;
            }
            var7_7 = var6_6 = var3_3.sourceName();
            if (var6_6 == null) {
                var7_7 = "";
            }
            if ((var8_8 = var3_3.lineNumber()) > 0) {
                var6_6 = new Object[]{var4_4 /* !! */ , var7_7, var8_8};
                var4_4 /* !! */  = var6_6;
            } else {
                var6_6 = new Object[]{var4_4 /* !! */ , var7_7};
                var4_4 /* !! */  = var6_6;
            }
            var4_4 /* !! */  = var2_2.newObject(var1_1, (String)var5_5, var4_4 /* !! */ );
            ScriptableObject.putProperty((Scriptable)var4_4 /* !! */ , "name", var5_5);
            if (var4_4 /* !! */  instanceof NativeError) {
                ((NativeError)var4_4 /* !! */ ).setStackProvider(var3_3);
            }
            if (var0 != null && ScriptRuntime.isVisible(var2_2, var0)) {
                ScriptableObject.defineProperty((Scriptable)var4_4 /* !! */ , "javaException", var2_2.getWrapFactory().wrap(var2_2, var1_1, var0, null), 7);
            }
            if (ScriptRuntime.isVisible(var2_2, var3_3)) {
                ScriptableObject.defineProperty((Scriptable)var4_4 /* !! */ , "rhinoException", var2_2.getWrapFactory().wrap(var2_2, var1_1, var3_3, null), 7);
            }
            return var4_4 /* !! */ ;
        }
        throw Kit.codeBug();
    }

    public static Integer wrapInt(int n) {
        return n;
    }

    public static Number wrapNumber(double d) {
        if (d != d) {
            return NaNobj;
        }
        return new Double(d);
    }

    public static Scriptable wrapRegExp(Context context, Scriptable scriptable, Object object) {
        return context.getRegExpProxy().wrapRegExp(context, scriptable, object);
    }

    private static class DefaultMessageProvider
    implements MessageProvider {
        private DefaultMessageProvider() {
        }

        @Override
        public String getMessage(String string2, Object[] objectArray) {
            Object object = Context.getCurrentContext();
            object = object != null ? ((Context)object).getLocale() : Locale.getDefault();
            object = ResourceBundle.getBundle("org.mozilla.javascript.resources.Messages", (Locale)object);
            try {
                object = ((ResourceBundle)object).getString(string2);
            }
            catch (MissingResourceException missingResourceException) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("no message resource found for message property ");
                stringBuilder.append(string2);
                throw new RuntimeException(stringBuilder.toString());
            }
            return new MessageFormat((String)object).format(objectArray);
        }
    }

    private static class IdEnumeration
    implements Serializable {
        private static final long serialVersionUID = 1L;
        Object currentId;
        boolean enumNumbers;
        int enumType;
        Object[] ids;
        int index;
        Scriptable iterator;
        Scriptable obj;
        ObjToIntMap used;

        private IdEnumeration() {
        }
    }

    public static interface MessageProvider {
        public String getMessage(String var1, Object[] var2);
    }

    static class NoSuchMethodShim
    implements Callable {
        String methodName;
        Callable noSuchMethodMethod;

        NoSuchMethodShim(Callable callable, String string2) {
            this.noSuchMethodMethod = callable;
            this.methodName = string2;
        }

        @Override
        public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] object) {
            String string2 = this.methodName;
            object = ScriptRuntime.newArrayLiteral(object, null, context, scriptable);
            return this.noSuchMethodMethod.call(context, scriptable, scriptable2, new Object[]{string2, object});
        }
    }
}

