/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;

public final class ScriptStackElement
implements Serializable {
    static final long serialVersionUID = -6416688260860477449L;
    public final String fileName;
    public final String functionName;
    public final int lineNumber;

    public ScriptStackElement(String string2, String string3, int n) {
        this.fileName = string2;
        this.functionName = string3;
        this.lineNumber = n;
    }

    private void appendV8Location(StringBuilder stringBuilder) {
        stringBuilder.append(this.fileName);
        stringBuilder.append(':');
        int n = this.lineNumber;
        if (n <= -1) {
            n = 0;
        }
        stringBuilder.append(n);
        stringBuilder.append(":0");
    }

    public void renderJavaStyle(StringBuilder stringBuilder) {
        stringBuilder.append("\tat ");
        stringBuilder.append(this.fileName);
        if (this.lineNumber > -1) {
            stringBuilder.append(':');
            stringBuilder.append(this.lineNumber);
        }
        if (this.functionName != null) {
            stringBuilder.append(" (");
            stringBuilder.append(this.functionName);
            stringBuilder.append(')');
        }
    }

    public void renderMozillaStyle(StringBuilder stringBuilder) {
        String string2 = this.functionName;
        if (string2 != null) {
            stringBuilder.append(string2);
            stringBuilder.append("()");
        }
        stringBuilder.append('@');
        stringBuilder.append(this.fileName);
        if (this.lineNumber > -1) {
            stringBuilder.append(':');
            stringBuilder.append(this.lineNumber);
        }
    }

    public void renderV8Style(StringBuilder stringBuilder) {
        stringBuilder.append("    at ");
        String string2 = this.functionName;
        if (string2 != null && !"anonymous".equals(string2) && !"undefined".equals(this.functionName)) {
            stringBuilder.append(this.functionName);
            stringBuilder.append(" (");
            this.appendV8Location(stringBuilder);
            stringBuilder.append(')');
        } else {
            this.appendV8Location(stringBuilder);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.renderMozillaStyle(stringBuilder);
        return stringBuilder.toString();
    }
}

