/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ConstProperties;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ExternalArrayData;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.LazilyLoadedCtor;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SlotMapContainer;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolScriptable;
import org.mozilla.javascript.ThreadSafeSlotMapContainer;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.mozilla.javascript.annotations.JSSetter;
import org.mozilla.javascript.annotations.JSStaticFunction;
import org.mozilla.javascript.debug.DebuggableObject;

public abstract class ScriptableObject
implements Scriptable,
SymbolScriptable,
Serializable,
DebuggableObject,
ConstProperties {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    public static final int CONST = 13;
    public static final int DONTENUM = 2;
    public static final int EMPTY = 0;
    private static final Method GET_ARRAY_LENGTH;
    private static final Comparator<Object> KEY_COMPARATOR;
    public static final int PERMANENT = 4;
    public static final int READONLY = 1;
    public static final int UNINITIALIZED_CONST = 8;
    static final long serialVersionUID = 2829861078851942586L;
    private volatile Map<Object, Object> associatedValues;
    private transient ExternalArrayData externalData;
    private boolean isExtensible = true;
    private boolean isSealed = false;
    private Scriptable parentScopeObject;
    private Scriptable prototypeObject;
    private transient SlotMapContainer slotMap;

    static {
        try {
            GET_ARRAY_LENGTH = ScriptableObject.class.getMethod("getExternalArrayLength", new Class[0]);
            KEY_COMPARATOR = new KeyComparator();
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }

    public ScriptableObject() {
        this.slotMap = this.createSlotMap(0);
    }

    public ScriptableObject(Scriptable scriptable, Scriptable scriptable2) {
        if (scriptable != null) {
            this.parentScopeObject = scriptable;
            this.prototypeObject = scriptable2;
            this.slotMap = this.createSlotMap(0);
            return;
        }
        throw new IllegalArgumentException();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    static <T extends Scriptable> BaseFunction buildClassCtor(Scriptable var0, Class<T> var1_1, boolean var2_2, boolean var3_3) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        block32: {
            var4_4 = FunctionObject.getMethodList(var1_1);
            var5_5 = 0;
            while (true) {
                var6_6 = var4_4.length;
                var7_7 = null;
                if (var5_5 >= var6_6) break;
                var8_8 /* !! */  = var4_4[var5_5];
                if (var8_8 /* !! */ .getName().equals("init")) {
                    var9_9 = var8_8 /* !! */ .getParameterTypes();
                    if (((Class<?>[])var9_9).length == 3 && var9_9[0] == ScriptRuntime.ContextClass && var9_9[1] == ScriptRuntime.ScriptableClass && var9_9[2] == Boolean.TYPE && Modifier.isStatic(var8_8 /* !! */ .getModifiers())) {
                        var9_9 = Context.getContext();
                        var1_1 = var2_2 != false ? Boolean.TRUE : Boolean.FALSE;
                        var8_8 /* !! */ .invoke(null, new Object[]{var9_9, var0, var1_1});
                        return null;
                    }
                    if (((Class<?>[])var9_9).length == 1 && var9_9[0] == ScriptRuntime.ScriptableClass && Modifier.isStatic(var8_8 /* !! */ .getModifiers())) {
                        var8_8 /* !! */ .invoke(null, new Object[]{var0});
                        return null;
                    }
                }
                ++var5_5;
            }
            var10_10 /* !! */  = var1_1.getConstructors();
            for (var5_5 = 0; var5_5 < var10_10 /* !! */ .length; ++var5_5) {
                if (var10_10 /* !! */ [var5_5].getParameterTypes().length != 0) continue;
                var8_8 /* !! */  = var10_10 /* !! */ [var5_5];
                break block32;
            }
            var8_8 /* !! */  = null;
        }
        if (var8_8 /* !! */  == null) {
            throw Context.reportRuntimeError1("msg.zero.arg.ctor", var1_1.getName());
        }
        var11_11 = (Scriptable)var8_8 /* !! */ .newInstance(ScriptRuntime.emptyArgs);
        var12_12 = var11_11.getClassName();
        var8_8 /* !! */  = ScriptableObject.getProperty(ScriptableObject.getTopLevelScope(var0), (String)var12_12);
        if (var8_8 /* !! */  instanceof BaseFunction && (var8_8 /* !! */  = (var9_9 = (BaseFunction)var8_8 /* !! */ ).getPrototypeProperty()) != null && var1_1.equals(var8_8 /* !! */ .getClass())) {
            return var9_9;
        }
        var8_8 /* !! */  = var3_3 != false && ScriptRuntime.ScriptableClass.isAssignableFrom((Class<?>)(var8_8 /* !! */  = var1_1.getSuperclass())) != false && Modifier.isAbstract(var8_8 /* !! */ .getModifiers()) == false && (var8_8 /* !! */  = ScriptableObject.defineClass(var0, ScriptableObject.extendsScriptable(var8_8 /* !! */ ), var2_2, var3_3)) != null ? ScriptableObject.getClassPrototype(var0, (String)var8_8 /* !! */ ) : null;
        var9_9 = var8_8 /* !! */ ;
        if (var8_8 /* !! */  == null) {
            var9_9 = ScriptableObject.getObjectPrototype(var0);
        }
        var11_11.setPrototype((Scriptable)var9_9);
        var9_9 = ScriptableObject.findAnnotatedMember(var4_4, JSConstructor.class);
        var8_8 /* !! */  = var9_9;
        if (var9_9 == null) {
            var8_8 /* !! */  = ScriptableObject.findAnnotatedMember(var10_10 /* !! */ , JSConstructor.class);
        }
        var13_13 = "jsConstructor";
        var9_9 = var8_8 /* !! */ ;
        if (var8_8 /* !! */  == null) {
            var9_9 = FunctionObject.findSingleMethod((Method[])var4_4, "jsConstructor");
        }
        var14_14 = var9_9;
        if (var9_9 == null) {
            if (var10_10 /* !! */ .length == 1) {
                var8_8 /* !! */  = var10_10 /* !! */ [0];
            } else {
                var8_8 /* !! */  = var9_9;
                if (var10_10 /* !! */ .length == 2) {
                    if (var10_10 /* !! */ [0].getParameterTypes().length == 0) {
                        var8_8 /* !! */  = var10_10 /* !! */ [1];
                    } else {
                        var8_8 /* !! */  = var9_9;
                        if (var10_10 /* !! */ [1].getParameterTypes().length == 0) {
                            var8_8 /* !! */  = var10_10 /* !! */ [0];
                        }
                    }
                }
            }
            if (var8_8 /* !! */  == null) {
                throw Context.reportRuntimeError1("msg.ctor.multiple.parms", var1_1.getName());
            }
            var14_14 = var8_8 /* !! */ ;
        }
        if ((var15_15 = new FunctionObject((String)var12_12, (Member)var14_14, var0)).isVarArgsMethod()) {
            throw Context.reportRuntimeError1("msg.varargs.ctor", var14_14.getName());
        }
        var15_15.initAsConstructor(var0, var11_11);
        var10_10 /* !! */  = new HashSet<E>();
        var12_12 = new HashSet<E>();
        var6_6 = var4_4.length;
        var1_1 = var7_7;
        for (var5_5 = 0; var5_5 < var6_6; ++var5_5) {
            block39: {
                block38: {
                    block35: {
                        block37: {
                            block36: {
                                block34: {
                                    block33: {
                                        var16_16 = var4_4[var5_5];
                                        if (var16_16 == var14_14) ** GOTO lbl-1000
                                        var17_17 = var16_16.getName();
                                        if (!var17_17.equals("finishInit") || (var8_8 /* !! */  = var16_16.getParameterTypes()).length != 3 || var8_8 /* !! */ [0] != ScriptRuntime.ScriptableClass || var8_8 /* !! */ [1] != FunctionObject.class || var8_8 /* !! */ [2] != ScriptRuntime.ScriptableClass || !Modifier.isStatic(var16_16.getModifiers())) break block33;
                                        var1_1 = var16_16;
                                        ** GOTO lbl-1000
                                    }
                                    if (var17_17.indexOf(36) != -1 || var17_17.equals(var13_13)) ** GOTO lbl-1000
                                    if (!var16_16.isAnnotationPresent(JSFunction.class)) break block34;
                                    var8_8 /* !! */  = var16_16.getAnnotation(JSFunction.class);
                                    break block35;
                                }
                                if (!var16_16.isAnnotationPresent(JSStaticFunction.class)) break block36;
                                var8_8 /* !! */  = var16_16.getAnnotation(JSStaticFunction.class);
                                break block35;
                            }
                            if (!var16_16.isAnnotationPresent(JSGetter.class)) break block37;
                            var8_8 /* !! */  = var16_16.getAnnotation(JSGetter.class);
                            break block35;
                        }
                        if (var16_16.isAnnotationPresent(JSSetter.class)) ** GOTO lbl-1000
                        var8_8 /* !! */  = null;
                    }
                    var9_9 = "jsFunction_";
                    if (var8_8 /* !! */  != null) ** GOTO lbl-1000
                    if (var17_17.startsWith("jsFunction_")) ** GOTO lbl111
                    if (!var17_17.startsWith("jsStaticFunction_")) break block38;
                    var9_9 = "jsStaticFunction_";
                    ** GOTO lbl111
                }
                if (!var17_17.startsWith("jsGet_")) break block39;
                var9_9 = "jsGet_";
                ** GOTO lbl111
            }
            if (var8_8 /* !! */  == null) lbl-1000:
            // 5 sources

            {
                var8_8 /* !! */  = var1_1;
            } else lbl-1000:
            // 2 sources

            {
                var9_9 = null;
lbl111:
                // 4 sources

                var18_18 = !(var8_8 /* !! */  instanceof JSStaticFunction) && var9_9 != "jsStaticFunction_" ? 0 : 1;
                var7_7 = var18_18 != 0 ? var10_10 /* !! */  : var12_12;
                var19_19 = ScriptableObject.getPropertyName(var17_17, (String)var9_9, var8_8 /* !! */ );
                if (var7_7.contains(var19_19)) {
                    throw Context.reportRuntimeError2("duplicate.defineClass.name", var17_17, var19_19);
                }
                var7_7.add(var19_19);
                if (!(var8_8 /* !! */  instanceof JSGetter) && var9_9 != "jsGet_") {
                    if (var18_18 != 0 && !Modifier.isStatic(var16_16.getModifiers())) {
                        throw Context.reportRuntimeError("jsStaticFunction must be used with static method.");
                    }
                    var9_9 = new FunctionObject(var19_19, (Member)var16_16, var11_11);
                    if (var9_9.isVarArgsConstructor()) {
                        throw Context.reportRuntimeError1("msg.varargs.fun", var14_14.getName());
                    }
                    var8_8 /* !! */  = var18_18 != 0 ? var15_15 : var11_11;
                    ScriptableObject.defineProperty(var8_8 /* !! */ , var19_19, var9_9, 2);
                    var8_8 /* !! */  = var1_1;
                    if (var2_2) {
                        var9_9.sealObject();
                        var8_8 /* !! */  = var1_1;
                    }
                } else {
                    if (!(var11_11 instanceof ScriptableObject)) {
                        throw Context.reportRuntimeError2("msg.extend.scriptable", var11_11.getClass().toString(), var19_19);
                    }
                    var8_8 /* !! */  = ScriptableObject.findSetterMethod((Method[])var4_4, var19_19, "jsSet_");
                    var18_18 = var8_8 /* !! */  != null ? 0 : 1;
                    ((ScriptableObject)var11_11).defineProperty(var19_19, null, (Method)var16_16, (Method)var8_8 /* !! */ , var18_18 | 6);
                    var8_8 /* !! */  = var1_1;
                }
            }
            var1_1 = var8_8 /* !! */ ;
        }
        if (var1_1 != null) {
            var1_1.invoke(null, new Object[]{var0, var15_15, var11_11});
        }
        if (var2_2) {
            var15_15.sealObject();
            if (var11_11 instanceof ScriptableObject) {
                ((ScriptableObject)var11_11).sealObject();
            }
        }
        return var15_15;
    }

    protected static ScriptableObject buildDataDescriptor(Scriptable scriptable, Object object, int n) {
        NativeObject nativeObject = new NativeObject();
        ScriptRuntime.setBuiltinProtoAndParent(nativeObject, scriptable, TopLevel.Builtins.Object);
        nativeObject.defineProperty("value", object, 0);
        boolean bl = true;
        boolean bl2 = (n & 1) == 0;
        nativeObject.defineProperty("writable", (Object)bl2, 0);
        bl2 = (n & 2) == 0;
        nativeObject.defineProperty("enumerable", (Object)bl2, 0);
        bl2 = (n & 4) == 0 ? bl : false;
        nativeObject.defineProperty("configurable", (Object)bl2, 0);
        return nativeObject;
    }

    public static Object callMethod(Context context, Scriptable scriptable, String object, Object[] objectArray) {
        Object object2 = ScriptableObject.getProperty(scriptable, (String)object);
        if (object2 instanceof Function) {
            object = (Function)object2;
            object2 = ScriptableObject.getTopLevelScope(scriptable);
            if (context != null) {
                return object.call(context, (Scriptable)object2, scriptable, objectArray);
            }
            return Context.call(null, (Callable)object, (Scriptable)object2, scriptable, objectArray);
        }
        throw ScriptRuntime.notFunctionError(scriptable, object);
    }

    public static Object callMethod(Scriptable scriptable, String string2, Object[] objectArray) {
        return ScriptableObject.callMethod(null, scriptable, string2, objectArray);
    }

    private void checkNotSealed(Object object, int n) {
        if (!this.isSealed()) {
            return;
        }
        object = object != null ? object.toString() : Integer.toString(n);
        throw Context.reportRuntimeError1("msg.modify.sealed", object);
    }

    static void checkValidAttributes(int n) {
        if ((n & 0xFFFFFFF0) == 0) {
            return;
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    private SlotMapContainer createSlotMap(int n) {
        Context context = Context.getCurrentContext();
        if (context != null && context.hasFeature(17)) {
            return new ThreadSafeSlotMapContainer(n);
        }
        return new SlotMapContainer(n);
    }

    public static <T extends Scriptable> String defineClass(Scriptable scriptable, Class<T> object, boolean bl, boolean bl2) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        BaseFunction baseFunction = ScriptableObject.buildClassCtor(scriptable, object, bl, bl2);
        if (baseFunction == null) {
            return null;
        }
        object = baseFunction.getClassPrototype().getClassName();
        ScriptableObject.defineProperty(scriptable, (String)object, baseFunction, 2);
        return object;
    }

    public static <T extends Scriptable> void defineClass(Scriptable scriptable, Class<T> clazz) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        ScriptableObject.defineClass(scriptable, clazz, false, false);
    }

    public static <T extends Scriptable> void defineClass(Scriptable scriptable, Class<T> clazz, boolean bl) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        ScriptableObject.defineClass(scriptable, clazz, bl, false);
    }

    public static void defineConstProperty(Scriptable scriptable, String string2) {
        if (scriptable instanceof ConstProperties) {
            ((ConstProperties)((Object)scriptable)).defineConst(string2, scriptable);
        } else {
            ScriptableObject.defineProperty(scriptable, string2, Undefined.instance, 13);
        }
    }

    public static void defineProperty(Scriptable scriptable, String string2, Object object, int n) {
        if (!(scriptable instanceof ScriptableObject)) {
            scriptable.put(string2, scriptable, object);
            return;
        }
        ((ScriptableObject)scriptable).defineProperty(string2, object, n);
    }

    public static boolean deleteProperty(Scriptable scriptable, int n) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, n);
        if (scriptable2 == null) {
            return true;
        }
        scriptable2.delete(n);
        return scriptable2.has(n, scriptable) ^ true;
    }

    public static boolean deleteProperty(Scriptable scriptable, String string2) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, string2);
        if (scriptable2 == null) {
            return true;
        }
        scriptable2.delete(string2);
        return scriptable2.has(string2, scriptable) ^ true;
    }

    protected static Scriptable ensureScriptable(Object object) {
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        throw ScriptRuntime.typeError1("msg.arg.not.object", ScriptRuntime.typeof(object));
    }

    protected static ScriptableObject ensureScriptableObject(Object object) {
        if (object instanceof ScriptableObject) {
            return (ScriptableObject)object;
        }
        throw ScriptRuntime.typeError1("msg.arg.not.object", ScriptRuntime.typeof(object));
    }

    protected static SymbolScriptable ensureSymbolScriptable(Object object) {
        if (object instanceof SymbolScriptable) {
            return (SymbolScriptable)object;
        }
        throw ScriptRuntime.typeError1("msg.object.not.symbolscriptable", ScriptRuntime.typeof(object));
    }

    private static <T extends Scriptable> Class<T> extendsScriptable(Class<?> clazz) {
        if (ScriptRuntime.ScriptableClass.isAssignableFrom(clazz)) {
            return clazz;
        }
        return null;
    }

    private static Member findAnnotatedMember(AccessibleObject[] accessibleObjectArray, Class<? extends Annotation> clazz) {
        for (AccessibleObject accessibleObject : accessibleObjectArray) {
            if (!accessibleObject.isAnnotationPresent(clazz)) continue;
            return (Member)((Object)accessibleObject);
        }
        return null;
    }

    private Slot findAttributeSlot(String string2, int n, SlotAccess object) {
        if ((object = this.slotMap.get(string2, n, (SlotAccess)((Object)object))) == null) {
            if (string2 == null) {
                string2 = Integer.toString(n);
            }
            throw Context.reportRuntimeError1("msg.prop.not.found", string2);
        }
        return object;
    }

    private Slot findAttributeSlot(Symbol symbol, SlotAccess object) {
        if ((object = this.slotMap.get(symbol, 0, (SlotAccess)((Object)object))) != null) {
            return object;
        }
        throw Context.reportRuntimeError1("msg.prop.not.found", symbol);
    }

    private static Method findSetterMethod(Method[] methodArray, String string2, String object) {
        Object object2 = new StringBuilder();
        ((StringBuilder)object2).append("set");
        int n = 0;
        ((StringBuilder)object2).append(Character.toUpperCase(string2.charAt(0)));
        ((StringBuilder)object2).append(string2.substring(1));
        String string3 = ((StringBuilder)object2).toString();
        for (Method method : methodArray) {
            object2 = method.getAnnotation(JSSetter.class);
            if (object2 == null || !string2.equals(object2.value()) && (!"".equals(object2.value()) || !string3.equals(method.getName()))) continue;
            return method;
        }
        object2 = new StringBuilder();
        ((StringBuilder)object2).append((String)object);
        ((StringBuilder)object2).append(string2);
        string2 = ((StringBuilder)object2).toString();
        int n2 = methodArray.length;
        for (int i = n; i < n2; ++i) {
            object = methodArray[i];
            if (!string2.equals(((Method)object).getName())) continue;
            return object;
        }
        return null;
    }

    public static Scriptable getArrayPrototype(Scriptable scriptable) {
        return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(scriptable), TopLevel.Builtins.Array);
    }

    private static Scriptable getBase(Scriptable scriptable, int n) {
        while (!scriptable.has(n, scriptable)) {
            Scriptable scriptable2;
            scriptable = scriptable2 = scriptable.getPrototype();
            if (scriptable2 != null) continue;
            scriptable = scriptable2;
            break;
        }
        return scriptable;
    }

    private static Scriptable getBase(Scriptable scriptable, String string2) {
        while (!scriptable.has(string2, scriptable)) {
            Scriptable scriptable2;
            scriptable = scriptable2 = scriptable.getPrototype();
            if (scriptable2 != null) continue;
            scriptable = scriptable2;
            break;
        }
        return scriptable;
    }

    private static Scriptable getBase(Scriptable scriptable, Symbol symbol) {
        while (!ScriptableObject.ensureSymbolScriptable(scriptable).has(symbol, scriptable)) {
            Scriptable scriptable2;
            scriptable = scriptable2 = scriptable.getPrototype();
            if (scriptable2 != null) continue;
            scriptable = scriptable2;
            break;
        }
        return scriptable;
    }

    public static Scriptable getClassPrototype(Scriptable object, String string2) {
        block6: {
            block5: {
                block4: {
                    if (!((object = ScriptableObject.getProperty(ScriptableObject.getTopLevelScope((Scriptable)object), string2)) instanceof BaseFunction)) break block4;
                    object = ((BaseFunction)object).getPrototypeProperty();
                    break block5;
                }
                if (!(object instanceof Scriptable)) break block6;
                object = (Scriptable)object;
                object = object.get("prototype", (Scriptable)object);
            }
            if (object instanceof Scriptable) {
                return (Scriptable)object;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Object getDefaultValue(Scriptable scriptable, Class<?> clazz) {
        Object object;
        Object object2 = null;
        int n = 0;
        while (true) {
            Object object3;
            object = "undefined";
            if (n >= 2) break;
            boolean bl = clazz == ScriptRuntime.StringClass ? n == 0 : n == 1;
            if (bl) {
                Object[] objectArray = ScriptRuntime.emptyArgs;
                object = "toString";
            } else {
                if (clazz != null) {
                    if (clazz == ScriptRuntime.StringClass) {
                        object = "string";
                    } else if (clazz == ScriptRuntime.ScriptableClass) {
                        object = "object";
                    } else if (clazz == ScriptRuntime.FunctionClass) {
                        object = "function";
                    } else if (clazz != ScriptRuntime.BooleanClass && clazz != Boolean.TYPE) {
                        if (clazz != ScriptRuntime.NumberClass && clazz != ScriptRuntime.ByteClass && clazz != Byte.TYPE && clazz != ScriptRuntime.ShortClass && clazz != Short.TYPE && clazz != ScriptRuntime.IntegerClass && clazz != Integer.TYPE && clazz != ScriptRuntime.FloatClass && clazz != Float.TYPE && clazz != ScriptRuntime.DoubleClass) {
                            if (clazz != Double.TYPE) throw Context.reportRuntimeError1("msg.invalid.type", clazz.toString());
                        }
                        object = "number";
                    } else {
                        object = "boolean";
                    }
                }
                object3 = "valueOf";
                Object[] objectArray = new Object[]{object};
                object = object3;
            }
            object = ScriptableObject.getProperty(scriptable, (String)object);
            if (object instanceof Function) {
                void var6_9;
                object3 = (Function)object;
                object = object2;
                if (object2 == null) {
                    object = Context.getContext();
                }
                Object object4 = object3.call((Context)object, object3.getParentScope(), scriptable, (Object[])var6_9);
                object2 = object;
                if (object4 != null) {
                    if (!(object4 instanceof Scriptable)) {
                        return object4;
                    }
                    if (clazz == ScriptRuntime.ScriptableClass) return object4;
                    if (clazz == ScriptRuntime.FunctionClass) {
                        return object4;
                    }
                    object2 = object;
                    if (bl) {
                        object2 = object;
                        if (object4 instanceof Wrapper) {
                            Object object5 = ((Wrapper)object4).unwrap();
                            object2 = object;
                            if (object5 instanceof String) {
                                return object5;
                            }
                        }
                    }
                }
            }
            ++n;
        }
        if (clazz == null) {
            throw ScriptRuntime.typeError1("msg.default.value", object);
        }
        object = clazz.getName();
        throw ScriptRuntime.typeError1("msg.default.value", object);
    }

    public static Scriptable getFunctionPrototype(Scriptable scriptable) {
        return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(scriptable), TopLevel.Builtins.Function);
    }

    public static Scriptable getObjectPrototype(Scriptable scriptable) {
        return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(scriptable), TopLevel.Builtins.Object);
    }

    public static Object getProperty(Scriptable scriptable, int n) {
        Object object;
        Scriptable scriptable2 = scriptable;
        while ((object = scriptable2.get(n, scriptable)) == Scriptable.NOT_FOUND) {
            Scriptable scriptable3;
            scriptable2 = scriptable3 = scriptable2.getPrototype();
            if (scriptable3 != null) continue;
        }
        return object;
    }

    public static Object getProperty(Scriptable scriptable, String string2) {
        Object object;
        Scriptable scriptable2 = scriptable;
        while ((object = scriptable2.get(string2, scriptable)) == Scriptable.NOT_FOUND) {
            Scriptable scriptable3;
            scriptable2 = scriptable3 = scriptable2.getPrototype();
            if (scriptable3 != null) continue;
        }
        return object;
    }

    public static Object getProperty(Scriptable scriptable, Symbol symbol) {
        Object object;
        Scriptable scriptable2 = scriptable;
        while ((object = ScriptableObject.ensureSymbolScriptable(scriptable2).get(symbol, scriptable)) == Scriptable.NOT_FOUND) {
            Scriptable scriptable3;
            scriptable2 = scriptable3 = scriptable2.getPrototype();
            if (scriptable3 != null) continue;
        }
        return object;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Object[] getPropertyIds(Scriptable var0) {
        if (var0 == null) {
            return ScriptRuntime.emptyArgs;
        }
        var1_1 = var0.getIds();
        var2_2 = null;
        var3_3 /* !! */  = var0;
        var0 = var1_1;
        block0: while (true) {
            if ((var4_4 = var3_3 /* !! */ .getPrototype()) == null) {
                if (var2_2 != null) {
                    var0 = var2_2.getKeys();
                }
                return var0;
            }
            var5_5 = var4_4.getIds();
            if (var5_5.length == 0) {
                var3_3 /* !! */  = var4_4;
                continue;
            }
            var6_6 = 0;
            var7_7 = var0;
            var1_1 = var2_2;
            var8_8 = var6_6;
            if (var2_2 == null) {
                if (var0.length == 0) {
                    var0 = var5_5;
                    var3_3 /* !! */  = var4_4;
                    continue;
                }
                var1_1 = new ObjToIntMap(var0.length + var5_5.length);
                for (var8_8 = 0; var8_8 != var0.length; ++var8_8) {
                    var1_1.intern(var0[var8_8]);
                }
                var7_7 = null;
                var8_8 = var6_6;
            }
            while (true) {
                var0 = var7_7;
                var2_2 = var1_1;
                var3_3 /* !! */  = var4_4;
                if (var8_8 != var5_5.length) ** break;
                continue block0;
                var1_1.intern(var5_5[var8_8]);
                ++var8_8;
            }
            break;
        }
    }

    private static String getPropertyName(String string2, String object, Annotation object2) {
        block15: {
            block13: {
                block14: {
                    if (object != null) {
                        return string2.substring(((String)object).length());
                    }
                    object = null;
                    if (!(object2 instanceof JSGetter)) break block13;
                    if ((object2 = ((JSGetter)object2).value()) == null) break block14;
                    object = object2;
                    if (((String)object2).length() != 0) break block15;
                }
                object = object2;
                if (string2.length() > 3) {
                    object = object2;
                    if (string2.startsWith("get")) {
                        object = object2 = string2.substring(3);
                        if (Character.isUpperCase(((String)object2).charAt(0))) {
                            if (((String)object2).length() == 1) {
                                object = ((String)object2).toLowerCase();
                            } else {
                                object = object2;
                                if (!Character.isUpperCase(((String)object2).charAt(1))) {
                                    object = new StringBuilder();
                                    ((StringBuilder)object).append(Character.toLowerCase(((String)object2).charAt(0)));
                                    ((StringBuilder)object).append(((String)object2).substring(1));
                                    object = ((StringBuilder)object).toString();
                                }
                            }
                        }
                    }
                }
                break block15;
            }
            if (object2 instanceof JSFunction) {
                object = ((JSFunction)object2).value();
            } else if (object2 instanceof JSStaticFunction) {
                object = ((JSStaticFunction)object2).value();
            }
        }
        object2 = string2;
        if (object != null) {
            object2 = ((String)object).length() == 0 ? string2 : object;
        }
        return object2;
    }

    public static Scriptable getTopLevelScope(Scriptable scriptable) {
        Scriptable scriptable2;
        while ((scriptable2 = scriptable.getParentScope()) != null) {
            scriptable = scriptable2;
        }
        return scriptable;
    }

    public static Object getTopScopeValue(Scriptable scriptable, Object object) {
        Object object2;
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        do {
            if (scriptable instanceof ScriptableObject && (object2 = ((ScriptableObject)scriptable).getAssociatedValue(object)) != null) {
                return object2;
            }
            object2 = scriptable.getPrototype();
            scriptable = object2;
        } while (object2 != null);
        return null;
    }

    public static <T> T getTypedProperty(Scriptable object, int n, Class<T> clazz) {
        Object object2;
        object = object2 = ScriptableObject.getProperty((Scriptable)object, n);
        if (object2 == Scriptable.NOT_FOUND) {
            object = null;
        }
        return clazz.cast(Context.jsToJava(object, clazz));
    }

    public static <T> T getTypedProperty(Scriptable object, String object2, Class<T> clazz) {
        object = object2 = ScriptableObject.getProperty((Scriptable)object, (String)object2);
        if (object2 == Scriptable.NOT_FOUND) {
            object = null;
        }
        return clazz.cast(Context.jsToJava(object, clazz));
    }

    public static boolean hasProperty(Scriptable scriptable, int n) {
        boolean bl = ScriptableObject.getBase(scriptable, n) != null;
        return bl;
    }

    public static boolean hasProperty(Scriptable scriptable, String string2) {
        boolean bl = ScriptableObject.getBase(scriptable, string2) != null;
        return bl;
    }

    public static boolean hasProperty(Scriptable scriptable, Symbol symbol) {
        boolean bl = ScriptableObject.getBase(scriptable, symbol) != null;
        return bl;
    }

    protected static boolean isFalse(Object object) {
        return ScriptableObject.isTrue(object) ^ true;
    }

    protected static boolean isTrue(Object object) {
        boolean bl = object != NOT_FOUND && ScriptRuntime.toBoolean(object);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean putConstImpl(String object, int n, Scriptable object2, Object object3, int n2) {
        if (!this.isExtensible && Context.getContext().isStrictMode()) {
            throw ScriptRuntime.typeError0("msg.not.extensible");
        }
        if (this != object2) {
            Slot slot = this.slotMap.query(object, n);
            object = slot;
            if (slot != null) return ((Slot)object).setValue(object3, this, (Scriptable)object2);
            return false;
        }
        if (!this.isExtensible()) {
            Slot slot = this.slotMap.query(object, n);
            object = slot;
            if (slot != null) return ((Slot)object).setValue(object3, this, (Scriptable)object2);
            return true;
        }
        this.checkNotSealed(object, n);
        object2 = this.slotMap.get(object, n, SlotAccess.MODIFY_CONST);
        n = ((Slot)object2).getAttributes();
        if ((n & 1) == 0) throw Context.reportRuntimeError1("msg.var.redecl", object);
        if ((n & 8) == 0) return true;
        ((Slot)object2).value = object3;
        if (n2 == 8) return true;
        ((Slot)object2).setAttributes(n & 0xFFFFFFF7);
        return true;
    }

    public static void putConstProperty(Scriptable scriptable, String string2, Object object) {
        Scriptable scriptable2;
        Scriptable scriptable3 = scriptable2 = ScriptableObject.getBase(scriptable, string2);
        if (scriptable2 == null) {
            scriptable3 = scriptable;
        }
        if (scriptable3 instanceof ConstProperties) {
            ((ConstProperties)((Object)scriptable3)).putConst(string2, scriptable, object);
        }
    }

    private boolean putImpl(Object object, int n, Scriptable scriptable, Object object2) {
        if (!this.isExtensible && Context.getContext().isStrictMode()) {
            throw ScriptRuntime.typeError0("msg.not.extensible");
        }
        if (this != scriptable) {
            Slot slot = this.slotMap.query(object, n);
            object = slot;
            if (slot == null) {
                return false;
            }
        } else if (!this.isExtensible) {
            Slot slot = this.slotMap.query(object, n);
            object = slot;
            if (slot == null) {
                return true;
            }
        } else {
            if (this.isSealed) {
                this.checkNotSealed(object, n);
            }
            object = this.slotMap.get(object, n, SlotAccess.MODIFY);
        }
        return ((Slot)object).setValue(object2, this, scriptable);
    }

    public static void putProperty(Scriptable scriptable, int n, Object object) {
        Scriptable scriptable2;
        Scriptable scriptable3 = scriptable2 = ScriptableObject.getBase(scriptable, n);
        if (scriptable2 == null) {
            scriptable3 = scriptable;
        }
        scriptable3.put(n, scriptable, object);
    }

    public static void putProperty(Scriptable scriptable, String string2, Object object) {
        Scriptable scriptable2;
        Scriptable scriptable3 = scriptable2 = ScriptableObject.getBase(scriptable, string2);
        if (scriptable2 == null) {
            scriptable3 = scriptable;
        }
        scriptable3.put(string2, scriptable, object);
    }

    public static void putProperty(Scriptable scriptable, Symbol symbol, Object object) {
        Scriptable scriptable2;
        Scriptable scriptable3 = scriptable2 = ScriptableObject.getBase(scriptable, symbol);
        if (scriptable2 == null) {
            scriptable3 = scriptable;
        }
        ScriptableObject.ensureSymbolScriptable(scriptable3).put(symbol, scriptable, object);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.slotMap = this.createSlotMap(n);
        for (int i = 0; i < n; ++i) {
            Slot slot = (Slot)objectInputStream.readObject();
            this.slotMap.addSlot(slot);
        }
    }

    public static void redefineProperty(Scriptable scriptable, String string2, boolean bl) {
        if ((scriptable = ScriptableObject.getBase(scriptable, string2)) == null) {
            return;
        }
        if (scriptable instanceof ConstProperties && ((ConstProperties)((Object)scriptable)).isConst(string2)) {
            throw ScriptRuntime.typeError1("msg.const.redecl", string2);
        }
        if (!bl) {
            return;
        }
        throw ScriptRuntime.typeError1("msg.var.redecl", string2);
    }

    private void setGetterOrSetter(String string2, int n, Callable callable, boolean bl, boolean bl2) {
        Slot slot;
        if (string2 != null && n != 0) {
            throw new IllegalArgumentException(string2);
        }
        if (!bl2) {
            this.checkNotSealed(string2, n);
        }
        if (this.isExtensible()) {
            slot = (GetterSlot)this.slotMap.get(string2, n, SlotAccess.MODIFY_GETTER_SETTER);
        } else {
            slot = this.slotMap.query(string2, n);
            if (!(slot instanceof GetterSlot)) {
                return;
            }
            slot = (GetterSlot)slot;
        }
        if (!bl2 && (slot.getAttributes() & 1) != 0) {
            throw Context.reportRuntimeError1("msg.modify.readonly", string2);
        }
        if (bl) {
            ((GetterSlot)slot).setter = callable;
        } else {
            ((GetterSlot)slot).getter = callable;
        }
        ((GetterSlot)slot).value = Undefined.instance;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        long l = this.slotMap.readLock();
        try {
            int n = this.slotMap.dirtySize();
            if (n == 0) {
                objectOutputStream.writeInt(0);
            } else {
                objectOutputStream.writeInt(n);
                Iterator<Slot> iterator2 = this.slotMap.iterator();
                while (iterator2.hasNext()) {
                    objectOutputStream.writeObject(iterator2.next());
                }
            }
            return;
        }
        finally {
            this.slotMap.unlockRead(l);
        }
    }

    void addLazilyInitializedValue(String object, int n, LazilyLoadedCtor lazilyLoadedCtor, int n2) {
        if (object != null && n != 0) {
            throw new IllegalArgumentException((String)object);
        }
        this.checkNotSealed(object, n);
        object = (GetterSlot)this.slotMap.get(object, n, SlotAccess.MODIFY_GETTER_SETTER);
        ((Slot)object).setAttributes(n2);
        ((GetterSlot)object).getter = null;
        ((GetterSlot)object).setter = null;
        ((GetterSlot)object).value = lazilyLoadedCtor;
    }

    protected int applyDescriptorToAttributeBitset(int n, ScriptableObject object) {
        Object object2 = ScriptableObject.getProperty((Scriptable)object, "enumerable");
        int n2 = n;
        if (object2 != NOT_FOUND) {
            n2 = ScriptRuntime.toBoolean(object2) ? n & 0xFFFFFFFD : n | 2;
        }
        object2 = ScriptableObject.getProperty((Scriptable)object, "writable");
        n = n2;
        if (object2 != NOT_FOUND) {
            n = ScriptRuntime.toBoolean(object2) ? n2 & 0xFFFFFFFE : n2 | 1;
        }
        object = ScriptableObject.getProperty((Scriptable)object, "configurable");
        n2 = n;
        if (object != NOT_FOUND) {
            n2 = ScriptRuntime.toBoolean(object) ? n & 0xFFFFFFFB : n | 4;
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object associateValue(Object object, Object object2) {
        synchronized (this) {
            Throwable throwable2;
            if (object2 != null) {
                try {
                    HashMap<Object, Object> hashMap;
                    HashMap<Object, Object> hashMap2 = hashMap = this.associatedValues;
                    if (hashMap != null) return Kit.initHash(hashMap2, object, object2);
                    hashMap2 = new HashMap<Object, Object>();
                    this.associatedValues = hashMap2;
                    return Kit.initHash(hashMap2, object, object2);
                }
                catch (Throwable throwable2) {}
            } else {
                object = new IllegalArgumentException();
                throw object;
            }
            throw throwable2;
        }
    }

    public boolean avoidObjectDetection() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkPropertyChange(Object object, ScriptableObject scriptableObject, ScriptableObject scriptableObject2) {
        if (scriptableObject == null) {
            if (this.isExtensible()) return;
            throw ScriptRuntime.typeError0("msg.not.extensible");
        }
        if (!ScriptableObject.isFalse(scriptableObject.get("configurable", (Scriptable)scriptableObject))) return;
        if (ScriptableObject.isTrue(ScriptableObject.getProperty((Scriptable)scriptableObject2, "configurable"))) throw ScriptRuntime.typeError1("msg.change.configurable.false.to.true", object);
        if (ScriptableObject.isTrue(scriptableObject.get("enumerable", (Scriptable)scriptableObject)) != ScriptableObject.isTrue(ScriptableObject.getProperty((Scriptable)scriptableObject2, "enumerable"))) throw ScriptRuntime.typeError1("msg.change.enumerable.with.configurable.false", object);
        boolean bl = this.isDataDescriptor(scriptableObject2);
        boolean bl2 = this.isAccessorDescriptor(scriptableObject2);
        if (!bl && !bl2) return;
        if (bl && this.isDataDescriptor(scriptableObject)) {
            if (!ScriptableObject.isFalse(scriptableObject.get("writable", (Scriptable)scriptableObject))) return;
            if (ScriptableObject.isTrue(ScriptableObject.getProperty((Scriptable)scriptableObject2, "writable"))) throw ScriptRuntime.typeError1("msg.change.writable.false.to.true.with.configurable.false", object);
            if (this.sameValue(ScriptableObject.getProperty((Scriptable)scriptableObject2, "value"), scriptableObject.get("value", (Scriptable)scriptableObject))) return;
            throw ScriptRuntime.typeError1("msg.change.value.with.writable.false", object);
        }
        if (bl2 && this.isAccessorDescriptor(scriptableObject)) {
            if (!this.sameValue(ScriptableObject.getProperty((Scriptable)scriptableObject2, "set"), scriptableObject.get("set", (Scriptable)scriptableObject))) throw ScriptRuntime.typeError1("msg.change.setter.with.configurable.false", object);
            if (this.sameValue(ScriptableObject.getProperty((Scriptable)scriptableObject2, "get"), scriptableObject.get("get", (Scriptable)scriptableObject))) return;
            throw ScriptRuntime.typeError1("msg.change.getter.with.configurable.false", object);
        }
        if (!this.isDataDescriptor(scriptableObject)) throw ScriptRuntime.typeError1("msg.change.property.accessor.to.data.with.configurable.false", object);
        throw ScriptRuntime.typeError1("msg.change.property.data.to.accessor.with.configurable.false", object);
    }

    protected void checkPropertyDefinition(ScriptableObject scriptableObject) {
        Object object = ScriptableObject.getProperty((Scriptable)scriptableObject, "get");
        if (object != NOT_FOUND && object != Undefined.instance && !(object instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(object);
        }
        object = ScriptableObject.getProperty((Scriptable)scriptableObject, "set");
        if (object != NOT_FOUND && object != Undefined.instance && !(object instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(object);
        }
        if (this.isDataDescriptor(scriptableObject) && this.isAccessorDescriptor(scriptableObject)) {
            throw ScriptRuntime.typeError0("msg.both.data.and.accessor.desc");
        }
    }

    @Override
    public void defineConst(String string2, Scriptable scriptable) {
        if (this.putConstImpl(string2, 0, scriptable, Undefined.instance, 8)) {
            return;
        }
        if (scriptable != this) {
            if (scriptable instanceof ConstProperties) {
                ((ConstProperties)((Object)scriptable)).defineConst(string2, scriptable);
            }
            return;
        }
        throw Kit.codeBug();
    }

    public void defineFunctionProperties(String[] stringArray, Class<?> clazz, int n) {
        Method[] methodArray = FunctionObject.getMethodList(clazz);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            Method method = FunctionObject.findSingleMethod(methodArray, string2);
            if (method != null) {
                this.defineProperty(string2, (Object)new FunctionObject(string2, method, this), n);
                continue;
            }
            throw Context.reportRuntimeError2("msg.method.not.found", string2, clazz.getName());
        }
    }

    public void defineOwnProperties(Context context, ScriptableObject scriptableObject) {
        int n;
        int n2 = 0;
        Object[] objectArray = scriptableObject.getIds(false, true);
        ScriptableObject[] scriptableObjectArray = new ScriptableObject[objectArray.length];
        int n3 = objectArray.length;
        for (n = 0; n < n3; ++n) {
            ScriptableObject scriptableObject2 = ScriptableObject.ensureScriptableObject(ScriptRuntime.getObjectElem(scriptableObject, objectArray[n], context));
            this.checkPropertyDefinition(scriptableObject2);
            scriptableObjectArray[n] = scriptableObject2;
        }
        n3 = objectArray.length;
        for (n = n2; n < n3; ++n) {
            this.defineOwnProperty(context, objectArray[n], scriptableObjectArray[n]);
        }
    }

    public void defineOwnProperty(Context context, Object object, ScriptableObject scriptableObject) {
        this.checkPropertyDefinition(scriptableObject);
        this.defineOwnProperty(context, object, scriptableObject, true);
    }

    protected void defineOwnProperty(Context object, Object object2, ScriptableObject scriptableObject, boolean bl) {
        int n;
        Object object3;
        Object object4 = this.getSlot((Context)object, object2, SlotAccess.QUERY);
        boolean bl2 = object4 == null;
        if (bl) {
            object3 = object4 == null ? null : ((Slot)object4).getPropertyDescriptor((Context)object, this);
            this.checkPropertyChange(object2, (ScriptableObject)object3, scriptableObject);
        }
        bl = this.isAccessorDescriptor(scriptableObject);
        if (object4 == null) {
            object3 = bl ? SlotAccess.MODIFY_GETTER_SETTER : SlotAccess.MODIFY;
            object3 = this.getSlot((Context)object, object2, (SlotAccess)((Object)object3));
            n = this.applyDescriptorToAttributeBitset(7, scriptableObject);
        } else {
            n = this.applyDescriptorToAttributeBitset(((Slot)object4).getAttributes(), scriptableObject);
            object3 = object4;
        }
        if (bl) {
            object4 = object3;
            if (!(object3 instanceof GetterSlot)) {
                object4 = this.getSlot((Context)object, object2, SlotAccess.MODIFY_GETTER_SETTER);
            }
            object = (GetterSlot)object4;
            object2 = ScriptableObject.getProperty((Scriptable)scriptableObject, "get");
            if (object2 != NOT_FOUND) {
                ((GetterSlot)object).getter = object2;
            }
            if ((object2 = ScriptableObject.getProperty((Scriptable)scriptableObject, "set")) != NOT_FOUND) {
                ((GetterSlot)object).setter = object2;
            }
            ((GetterSlot)object).value = Undefined.instance;
            ((Slot)object).setAttributes(n);
        } else {
            object4 = object3;
            if (object3 instanceof GetterSlot) {
                object4 = object3;
                if (this.isDataDescriptor(scriptableObject)) {
                    object4 = this.getSlot((Context)object, object2, SlotAccess.CONVERT_ACCESSOR_TO_DATA);
                }
            }
            if ((object = ScriptableObject.getProperty((Scriptable)scriptableObject, "value")) != NOT_FOUND) {
                ((Slot)object4).value = object;
            } else if (bl2) {
                ((Slot)object4).value = Undefined.instance;
            }
            ((Slot)object4).setAttributes(n);
        }
    }

    public void defineProperty(String string2, Class<?> object, int n) {
        int n2 = string2.length();
        if (n2 != 0) {
            Object object2 = new char[n2 + 3];
            string2.getChars(0, n2, (char[])object2, 3);
            object2[3] = Character.toUpperCase(object2[3]);
            object2[0] = (char)103;
            object2[1] = (char)101;
            object2[2] = (char)116;
            Object object3 = new String((char[])object2);
            object2[0] = (char)115;
            String string3 = new String((char[])object2);
            object = FunctionObject.getMethodList(object);
            object2 = FunctionObject.findSingleMethod(object, (String)object3);
            object3 = FunctionObject.findSingleMethod(object, string3);
            n2 = n;
            if (object3 == null) {
                n2 = n | 1;
            }
            object = object3;
            if (object3 == null) {
                object = null;
            }
            this.defineProperty(string2, null, (Method)object2, (Method)object, n2);
            return;
        }
        throw new IllegalArgumentException();
    }

    public void defineProperty(String string2, Object object, int n) {
        this.checkNotSealed(string2, 0);
        this.put(string2, (Scriptable)this, object);
        this.setAttributes(string2, n);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void defineProperty(String var1_1, Object var2_2, Method var3_3, Method var4_4, int var5_5) {
        block24: {
            var6_6 = null;
            var7_7 = null;
            if (var3_3 == null) ** GOTO lbl34
            var8_8 = new MemberBox((Method)var3_3);
            if (!Modifier.isStatic(var3_3.getModifiers())) {
                var9_9 = var2_2 /* !! */  != null;
                var8_8.delegateTo = var2_2 /* !! */ ;
            } else {
                var8_8.delegateTo = Void.TYPE;
                var9_9 = true;
            }
            var10_10 = var3_3.getParameterTypes();
            var11_11 = var10_10.length;
            var12_12 = "msg.bad.getter.parms";
            if (var11_11 != 0) ** GOTO lbl21
            if (var9_9) {
                var13_13 = "msg.obj.getter.parms";
            } else {
                while (true) {
                    var13_13 = null;
                    break block24;
                    break;
                }
lbl21:
                // 1 sources

                var13_13 = var12_12;
                if (var10_10.length == 1) {
                    var13_13 = var10_10[0];
                    if (var13_13 != ScriptRuntime.ScriptableClass && var13_13 != ScriptRuntime.ScriptableObjectClass) {
                        var13_13 = var12_12;
                    } else {
                        if (var9_9) ** continue;
                        var13_13 = var12_12;
                    }
                }
            }
        }
        if (var13_13 == null) {
            var3_3 = var8_8;
        } else {
            throw Context.reportRuntimeError1(var13_13, var3_3.toString());
lbl34:
            // 1 sources

            var3_3 = null;
        }
        var13_13 = var6_6;
        if (var4_4 != null) {
            if (var4_4.getReturnType() == Void.TYPE) {
                var13_13 = new MemberBox(var4_4);
                if (!Modifier.isStatic(var4_4.getModifiers())) {
                    var9_9 = var2_2 /* !! */  != null;
                    var13_13.delegateTo = var2_2 /* !! */ ;
                } else {
                    var13_13.delegateTo = Void.TYPE;
                    var9_9 = true;
                }
                var2_2 /* !! */  = var4_4.getParameterTypes();
                if (var2_2 /* !! */ .length == 1) {
                    var2_2 /* !! */  = var7_7;
                    if (var9_9) {
                        var2_2 /* !! */  = "msg.setter2.expected";
                    }
                } else if (var2_2 /* !! */ .length == 2) {
                    if ((var2_2 /* !! */  = var2_2 /* !! */ [0]) != ScriptRuntime.ScriptableClass && var2_2 /* !! */  != ScriptRuntime.ScriptableObjectClass) {
                        var2_2 /* !! */  = "msg.setter2.parms";
                    } else {
                        var2_2 /* !! */  = var7_7;
                        if (!var9_9) {
                            var2_2 /* !! */  = "msg.setter1.parms";
                        }
                    }
                } else {
                    var2_2 /* !! */  = "msg.setter.parms";
                }
                if (var2_2 /* !! */  != null) {
                    throw Context.reportRuntimeError1(var2_2 /* !! */ , var4_4.toString());
                }
            } else {
                throw Context.reportRuntimeError1("msg.setter.return", var4_4.toString());
            }
        }
        var1_1 = (GetterSlot)this.slotMap.get(var1_1, 0, SlotAccess.MODIFY_GETTER_SETTER);
        var1_1.setAttributes(var5_5);
        var1_1.getter = var3_3;
        var1_1.setter = var13_13;
    }

    public void defineProperty(Symbol symbol, Object object, int n) {
        this.checkNotSealed(symbol, 0);
        this.put(symbol, (Scriptable)this, object);
        this.setAttributes(symbol, n);
    }

    @Override
    public void delete(int n) {
        this.checkNotSealed(null, n);
        this.slotMap.remove(null, n);
    }

    @Override
    public void delete(String string2) {
        this.checkNotSealed(string2, 0);
        this.slotMap.remove(string2, 0);
    }

    @Override
    public void delete(Symbol symbol) {
        this.checkNotSealed(symbol, 0);
        this.slotMap.remove(symbol, 0);
    }

    protected Object equivalentValues(Object object) {
        object = this == object ? Boolean.TRUE : Scriptable.NOT_FOUND;
        return object;
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        Object object = this.externalData;
        if (object != null) {
            if (n < object.getArrayLength()) {
                return this.externalData.getArrayElement(n);
            }
            return Scriptable.NOT_FOUND;
        }
        object = this.slotMap.query(null, n);
        if (object == null) {
            return Scriptable.NOT_FOUND;
        }
        return ((Slot)object).getValue(scriptable);
    }

    public Object get(Object object) {
        if ((object = object instanceof String ? this.get((String)object, (Scriptable)this) : (object instanceof Symbol ? this.get((Symbol)object, (Scriptable)this) : (object instanceof Number ? this.get(((Number)object).intValue(), (Scriptable)this) : null))) != Scriptable.NOT_FOUND && object != Undefined.instance) {
            Object object2 = object;
            if (object instanceof Wrapper) {
                object2 = ((Wrapper)object).unwrap();
            }
            return object2;
        }
        return null;
    }

    @Override
    public Object get(String object, Scriptable scriptable) {
        if ((object = this.slotMap.query(object, 0)) == null) {
            return Scriptable.NOT_FOUND;
        }
        return ((Slot)object).getValue(scriptable);
    }

    @Override
    public Object get(Symbol object, Scriptable scriptable) {
        if ((object = this.slotMap.query(object, 0)) == null) {
            return Scriptable.NOT_FOUND;
        }
        return ((Slot)object).getValue(scriptable);
    }

    @Override
    public Object[] getAllIds() {
        return this.getIds(true, false);
    }

    public final Object getAssociatedValue(Object object) {
        Map<Object, Object> map = this.associatedValues;
        if (map == null) {
            return null;
        }
        return map.get(object);
    }

    public int getAttributes(int n) {
        return this.findAttributeSlot(null, n, SlotAccess.QUERY).getAttributes();
    }

    @Deprecated
    public final int getAttributes(int n, Scriptable scriptable) {
        return this.getAttributes(n);
    }

    public int getAttributes(String string2) {
        return this.findAttributeSlot(string2, 0, SlotAccess.QUERY).getAttributes();
    }

    @Deprecated
    public final int getAttributes(String string2, Scriptable scriptable) {
        return this.getAttributes(string2);
    }

    public int getAttributes(Symbol symbol) {
        return this.findAttributeSlot(symbol, SlotAccess.QUERY).getAttributes();
    }

    @Override
    public abstract String getClassName();

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        return ScriptableObject.getDefaultValue(this, clazz);
    }

    public ExternalArrayData getExternalArrayData() {
        return this.externalData;
    }

    public Object getExternalArrayLength() {
        ExternalArrayData externalArrayData = this.externalData;
        int n = externalArrayData == null ? 0 : externalArrayData.getArrayLength();
        return n;
    }

    public Object getGetterOrSetter(String object, int n, boolean bl) {
        if (object != null && n != 0) {
            throw new IllegalArgumentException((String)object);
        }
        if ((object = this.slotMap.query(object, n)) == null) {
            return null;
        }
        if (object instanceof GetterSlot) {
            object = (GetterSlot)object;
            object = bl ? ((GetterSlot)object).setter : ((GetterSlot)object).getter;
            if (object == null) {
                object = Undefined.instance;
            }
            return object;
        }
        return Undefined.instance;
    }

    @Override
    public Object[] getIds() {
        return this.getIds(false, false);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object[] getIds(boolean bl, boolean bl2) {
        void var3_14;
        void var3_8;
        int n;
        Object object;
        ExternalArrayData externalArrayData = this.externalData;
        int n2 = externalArrayData == null ? 0 : externalArrayData.getArrayLength();
        if (n2 == 0) {
            Object[] objectArray = ScriptRuntime.emptyArgs;
        } else {
            object = new Object[n2];
            n = 0;
            while (true) {
                Object[] objectArray = object;
                if (n >= n2) break;
                object[n] = n;
                ++n;
            }
        }
        if (this.slotMap.isEmpty()) {
            void var3_7;
            return var3_7;
        }
        long l = this.slotMap.readLock();
        try {
            Iterator<Slot> iterator2 = this.slotMap.iterator();
            n = n2;
            while (iterator2.hasNext()) {
                void var3_11;
                Slot slot = iterator2.next();
                if (!bl && (slot.getAttributes() & 2) != 0 || !bl2 && slot.name instanceof Symbol) continue;
                object = var3_8;
                if (n == n2) {
                    object = new Object[this.slotMap.dirtySize() + n2];
                    if (var3_8 != null) {
                        System.arraycopy(var3_8, 0, object, 0, n2);
                    }
                }
                if (slot.name != null) {
                    Object object2 = slot.name;
                } else {
                    Integer n3 = slot.indexOrHash;
                }
                object[n] = var3_11;
                ++n;
                Object object3 = object;
            }
            this.slotMap.unlockRead(l);
        }
        catch (Throwable throwable) {
            this.slotMap.unlockRead(l);
            throw throwable;
        }
        if (n != ((void)var3_8).length + n2) {
            object = new Object[n];
            System.arraycopy(var3_8, 0, object, 0, n);
            Object object4 = object;
        }
        object = Context.getCurrentContext();
        if (object != null && ((Context)object).hasFeature(16)) {
            Arrays.sort(var3_14, KEY_COMPARATOR);
        }
        return var3_14;
    }

    protected ScriptableObject getOwnPropertyDescriptor(Context context, Object object) {
        Slot slot = this.getSlot(context, object, SlotAccess.QUERY);
        if (slot == null) {
            return null;
        }
        Scriptable scriptable = this.getParentScope();
        object = scriptable;
        if (scriptable == null) {
            object = this;
        }
        return slot.getPropertyDescriptor(context, (Scriptable)object);
    }

    @Override
    public Scriptable getParentScope() {
        return this.parentScopeObject;
    }

    @Override
    public Scriptable getPrototype() {
        return this.prototypeObject;
    }

    protected Slot getSlot(Context context, Object object, SlotAccess slotAccess) {
        if (object instanceof Symbol) {
            return this.slotMap.get(object, 0, slotAccess);
        }
        if ((object = ScriptRuntime.toStringIdOrIndex(context, object)) == null) {
            return this.slotMap.get(null, ScriptRuntime.lastIndexResult(context), slotAccess);
        }
        return this.slotMap.get(object, 0, slotAccess);
    }

    public String getTypeOf() {
        String string2 = this.avoidObjectDetection() ? "undefined" : "object";
        return string2;
    }

    @Override
    public boolean has(int n, Scriptable object) {
        object = this.externalData;
        boolean bl = true;
        boolean bl2 = true;
        if (object != null) {
            if (n >= object.getArrayLength()) {
                bl2 = false;
            }
            return bl2;
        }
        bl2 = this.slotMap.query(null, n) != null ? bl : false;
        return bl2;
    }

    @Override
    public boolean has(String string2, Scriptable object) {
        object = this.slotMap;
        boolean bl = false;
        if (((SlotMapContainer)object).query(string2, 0) != null) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean has(Symbol symbol, Scriptable object) {
        object = this.slotMap;
        boolean bl = false;
        if (((SlotMapContainer)object).query(symbol, 0) != null) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean hasInstance(Scriptable scriptable) {
        return ScriptRuntime.jsDelegatesTo(scriptable, this);
    }

    protected boolean isAccessorDescriptor(ScriptableObject scriptableObject) {
        boolean bl = ScriptableObject.hasProperty((Scriptable)scriptableObject, "get") || ScriptableObject.hasProperty((Scriptable)scriptableObject, "set");
        return bl;
    }

    @Override
    public boolean isConst(String object) {
        SlotMapContainer slotMapContainer = this.slotMap;
        boolean bl = false;
        if ((object = slotMapContainer.query(object, 0)) == null) {
            return false;
        }
        if ((((Slot)object).getAttributes() & 5) == 5) {
            bl = true;
        }
        return bl;
    }

    protected boolean isDataDescriptor(ScriptableObject scriptableObject) {
        boolean bl = ScriptableObject.hasProperty((Scriptable)scriptableObject, "value") || ScriptableObject.hasProperty((Scriptable)scriptableObject, "writable");
        return bl;
    }

    public boolean isEmpty() {
        return this.slotMap.isEmpty();
    }

    public boolean isExtensible() {
        return this.isExtensible;
    }

    protected boolean isGenericDescriptor(ScriptableObject scriptableObject) {
        boolean bl = !this.isDataDescriptor(scriptableObject) && !this.isAccessorDescriptor(scriptableObject);
        return bl;
    }

    protected boolean isGetterOrSetter(String object, int n, boolean bl) {
        if ((object = this.slotMap.query(object, n)) instanceof GetterSlot) {
            if (bl && ((GetterSlot)object).setter != null) {
                return true;
            }
            if (!bl && ((GetterSlot)object).getter != null) {
                return true;
            }
        }
        return false;
    }

    public final boolean isSealed() {
        return this.isSealed;
    }

    public void preventExtensions() {
        this.isExtensible = false;
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        ExternalArrayData externalArrayData = this.externalData;
        if (externalArrayData != null) {
            if (n < externalArrayData.getArrayLength()) {
                this.externalData.setArrayElement(n, object);
                return;
            }
            throw new JavaScriptException(ScriptRuntime.newNativeError(Context.getCurrentContext(), this, TopLevel.NativeErrors.RangeError, new Object[]{"External array index out of bounds "}), null, 0);
        }
        if (this.putImpl(null, n, scriptable, object)) {
            return;
        }
        if (scriptable != this) {
            scriptable.put(n, scriptable, object);
            return;
        }
        throw Kit.codeBug();
    }

    @Override
    public void put(String string2, Scriptable scriptable, Object object) {
        if (this.putImpl(string2, 0, scriptable, object)) {
            return;
        }
        if (scriptable != this) {
            scriptable.put(string2, scriptable, object);
            return;
        }
        throw Kit.codeBug();
    }

    @Override
    public void put(Symbol symbol, Scriptable scriptable, Object object) {
        if (this.putImpl(symbol, 0, scriptable, object)) {
            return;
        }
        if (scriptable != this) {
            ScriptableObject.ensureSymbolScriptable(scriptable).put(symbol, scriptable, object);
            return;
        }
        throw Kit.codeBug();
    }

    @Override
    public void putConst(String string2, Scriptable scriptable, Object object) {
        if (this.putConstImpl(string2, 0, scriptable, object, 1)) {
            return;
        }
        if (scriptable != this) {
            if (scriptable instanceof ConstProperties) {
                ((ConstProperties)((Object)scriptable)).putConst(string2, scriptable, object);
            } else {
                scriptable.put(string2, scriptable, object);
            }
            return;
        }
        throw Kit.codeBug();
    }

    protected boolean sameValue(Object object, Object object2) {
        if (object == NOT_FOUND) {
            return true;
        }
        Object object3 = object2;
        if (object2 == NOT_FOUND) {
            object3 = Undefined.instance;
        }
        if (object3 instanceof Number && object instanceof Number) {
            double d = ((Number)object3).doubleValue();
            double d2 = ((Number)object).doubleValue();
            if (Double.isNaN(d) && Double.isNaN(d2)) {
                return true;
            }
            if (d == 0.0 && Double.doubleToLongBits(d) != Double.doubleToLongBits(d2)) {
                return false;
            }
        }
        return ScriptRuntime.shallowEq(object3, object);
    }

    /*
     * Unable to fully structure code
     */
    public void sealObject() {
        block8: {
            if (this.isSealed) break block8;
            var1_1 = this.slotMap.readLock();
            var3_2 = this.slotMap.iterator();
lbl5:
            // 2 sources

            while (true) {
                if (!var3_2.hasNext()) ** GOTO lbl-1000
                var4_4 = var3_2.next();
                var5_6 = var4_4.value;
                if (!(var5_6 instanceof LazilyLoadedCtor)) continue;
                var5_6 = (LazilyLoadedCtor)var5_6;
                break;
            }
            {
                catch (Throwable var4_5) {
                    this.slotMap.unlockRead(var1_1);
                    throw var4_5;
                }
            }
            {
                var5_6.init();
                continue;
lbl-1000:
                // 1 sources

                {
                    this.isSealed = true;
                }
                this.slotMap.unlockRead(var1_1);
                break block8;
            }
            finally {
                var4_4.value = var5_6.getValue();
                ** continue;
            }
        }
    }

    public void setAttributes(int n, int n2) {
        this.checkNotSealed(null, n);
        this.findAttributeSlot(null, n, SlotAccess.MODIFY).setAttributes(n2);
    }

    @Deprecated
    public void setAttributes(int n, Scriptable scriptable, int n2) {
        this.setAttributes(n, n2);
    }

    public void setAttributes(String string2, int n) {
        this.checkNotSealed(string2, 0);
        this.findAttributeSlot(string2, 0, SlotAccess.MODIFY).setAttributes(n);
    }

    @Deprecated
    public final void setAttributes(String string2, Scriptable scriptable, int n) {
        this.setAttributes(string2, n);
    }

    public void setAttributes(Symbol symbol, int n) {
        this.checkNotSealed(symbol, 0);
        this.findAttributeSlot(symbol, SlotAccess.MODIFY).setAttributes(n);
    }

    public void setExternalArrayData(ExternalArrayData externalArrayData) {
        this.externalData = externalArrayData;
        if (externalArrayData == null) {
            this.delete("length");
        } else {
            this.defineProperty("length", null, GET_ARRAY_LENGTH, null, 3);
        }
    }

    public void setGetterOrSetter(String string2, int n, Callable callable, boolean bl) {
        this.setGetterOrSetter(string2, n, callable, bl, false);
    }

    @Override
    public void setParentScope(Scriptable scriptable) {
        this.parentScopeObject = scriptable;
    }

    @Override
    public void setPrototype(Scriptable scriptable) {
        this.prototypeObject = scriptable;
    }

    public int size() {
        return this.slotMap.size();
    }

    static final class GetterSlot
    extends Slot {
        static final long serialVersionUID = -4900574849788797588L;
        Object getter;
        Object setter;

        GetterSlot(Object object, int n, int n2) {
            super(object, n, n2);
        }

        @Override
        ScriptableObject getPropertyDescriptor(Context object, Scriptable scriptable) {
            Object object2;
            int n = this.getAttributes();
            object = new NativeObject();
            ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)object, scriptable, TopLevel.Builtins.Object);
            boolean bl = true;
            boolean bl2 = (n & 2) == 0;
            ((ScriptableObject)object).defineProperty("enumerable", (Object)bl2, 0);
            bl2 = (n & 4) == 0;
            ((ScriptableObject)object).defineProperty("configurable", (Object)bl2, 0);
            if (this.getter == null && this.setter == null) {
                bl2 = (n & 1) == 0 ? bl : false;
                ((ScriptableObject)object).defineProperty("writable", (Object)bl2, 0);
            }
            if ((object2 = this.getter) != null) {
                if (object2 instanceof MemberBox) {
                    ((ScriptableObject)object).defineProperty("get", (Object)new FunctionObject("f", ((MemberBox)this.getter).member(), scriptable), 0);
                } else if (object2 instanceof Member) {
                    ((ScriptableObject)object).defineProperty("get", (Object)new FunctionObject("f", (Member)this.getter, scriptable), 0);
                } else {
                    ((ScriptableObject)object).defineProperty("get", object2, 0);
                }
            }
            if ((object2 = this.setter) != null) {
                if (object2 instanceof MemberBox) {
                    ((ScriptableObject)object).defineProperty("set", (Object)new FunctionObject("f", ((MemberBox)this.setter).member(), scriptable), 0);
                } else if (object2 instanceof Member) {
                    ((ScriptableObject)object).defineProperty("set", (Object)new FunctionObject("f", (Member)this.setter, scriptable), 0);
                } else {
                    ((ScriptableObject)object).defineProperty("set", object2, 0);
                }
            }
            return object;
        }

        @Override
        Object getValue(Scriptable object) {
            Object object2 = this.getter;
            if (object2 != null) {
                if (object2 instanceof MemberBox) {
                    MemberBox memberBox = (MemberBox)object2;
                    if (memberBox.delegateTo == null) {
                        object2 = ScriptRuntime.emptyArgs;
                    } else {
                        object2 = memberBox.delegateTo;
                        Object[] objectArray = new Object[]{object};
                        object = object2;
                        object2 = objectArray;
                    }
                    return memberBox.invoke(object, (Object[])object2);
                }
                if (object2 instanceof Function) {
                    object2 = (Function)object2;
                    return object2.call(Context.getContext(), object2.getParentScope(), (Scriptable)object, ScriptRuntime.emptyArgs);
                }
            }
            object = object2 = this.value;
            if (object2 instanceof LazilyLoadedCtor) {
                object = (LazilyLoadedCtor)object2;
                try {
                    ((LazilyLoadedCtor)object).init();
                    this.value = object = ((LazilyLoadedCtor)object).getValue();
                }
                catch (Throwable throwable) {
                    this.value = ((LazilyLoadedCtor)object).getValue();
                    throw throwable;
                }
            }
            return object;
        }

        @Override
        boolean setValue(Object object, Scriptable objectArray, Scriptable objectArray2) {
            if (this.setter == null) {
                if (this.getter != null) {
                    object = Context.getContext();
                    if (!object.isStrictMode() && !object.hasFeature(11)) {
                        return true;
                    }
                    throw ScriptRuntime.typeError1("msg.set.prop.no.setter", this.name);
                }
                return super.setValue(object, (Scriptable)objectArray, (Scriptable)objectArray2);
            }
            objectArray = Context.getContext();
            Object object2 = this.setter;
            if (object2 instanceof MemberBox) {
                object2 = (MemberBox)object2;
                Class<?>[] classArray = ((MemberBox)object2).argTypes;
                objectArray = FunctionObject.convertArg((Context)objectArray, (Scriptable)objectArray2, object, FunctionObject.getTypeTag(classArray[classArray.length - 1]));
                if (((MemberBox)object2).delegateTo == null) {
                    object = new Object[]{objectArray};
                } else {
                    object = ((MemberBox)object2).delegateTo;
                    objectArray = new Object[]{objectArray2, objectArray};
                    objectArray2 = object;
                    object = objectArray;
                }
                ((MemberBox)object2).invoke(objectArray2, (Object[])object);
            } else if (object2 instanceof Function) {
                object2 = (Function)object2;
                object2.call((Context)objectArray, object2.getParentScope(), (Scriptable)objectArray2, new Object[]{object});
            }
            return true;
        }
    }

    public static final class KeyComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof Integer) {
                if (object2 instanceof Integer) {
                    int n;
                    int n2 = (Integer)object;
                    if (n2 < (n = ((Integer)object2).intValue())) {
                        return -1;
                    }
                    if (n2 > n) {
                        return 1;
                    }
                    return 0;
                }
                return -1;
            }
            if (object2 instanceof Integer) {
                return 1;
            }
            return 0;
        }
    }

    static class Slot
    implements Serializable {
        private static final long serialVersionUID = -6090581677123995491L;
        private short attributes;
        int indexOrHash;
        Object name;
        transient Slot next;
        transient Slot orderedNext;
        Object value;

        Slot(Object object, int n, int n2) {
            this.name = object;
            this.indexOrHash = n;
            this.attributes = (short)n2;
        }

        private void readObject(ObjectInputStream object) throws IOException, ClassNotFoundException {
            ((ObjectInputStream)object).defaultReadObject();
            object = this.name;
            if (object != null) {
                this.indexOrHash = object.hashCode();
            }
        }

        int getAttributes() {
            return this.attributes;
        }

        ScriptableObject getPropertyDescriptor(Context context, Scriptable scriptable) {
            return ScriptableObject.buildDataDescriptor(scriptable, this.value, this.attributes);
        }

        Object getValue(Scriptable scriptable) {
            return this.value;
        }

        void setAttributes(int n) {
            synchronized (this) {
                ScriptableObject.checkValidAttributes(n);
                this.attributes = (short)n;
                return;
            }
        }

        boolean setValue(Object object, Scriptable scriptable, Scriptable scriptable2) {
            if ((this.attributes & 1) != 0) {
                if (!Context.getContext().isStrictMode()) {
                    return true;
                }
                throw ScriptRuntime.typeError1("msg.modify.readonly", this.name);
            }
            if (scriptable == scriptable2) {
                this.value = object;
                return true;
            }
            return false;
        }
    }

    static final class SlotAccess
    extends Enum<SlotAccess> {
        private static final /* synthetic */ SlotAccess[] $VALUES;
        public static final /* enum */ SlotAccess CONVERT_ACCESSOR_TO_DATA;
        public static final /* enum */ SlotAccess MODIFY;
        public static final /* enum */ SlotAccess MODIFY_CONST;
        public static final /* enum */ SlotAccess MODIFY_GETTER_SETTER;
        public static final /* enum */ SlotAccess QUERY;

        static {
            SlotAccess slotAccess;
            SlotAccess slotAccess2;
            SlotAccess slotAccess3;
            SlotAccess slotAccess4;
            SlotAccess slotAccess5;
            QUERY = slotAccess5 = new SlotAccess();
            MODIFY = slotAccess4 = new SlotAccess();
            MODIFY_CONST = slotAccess3 = new SlotAccess();
            MODIFY_GETTER_SETTER = slotAccess2 = new SlotAccess();
            CONVERT_ACCESSOR_TO_DATA = slotAccess = new SlotAccess();
            $VALUES = new SlotAccess[]{slotAccess5, slotAccess4, slotAccess3, slotAccess2, slotAccess};
        }

        public static SlotAccess valueOf(String string2) {
            return Enum.valueOf(SlotAccess.class, string2);
        }

        public static SlotAccess[] values() {
            return (SlotAccess[])$VALUES.clone();
        }
    }
}

