/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.util.Map;
import java.util.WeakHashMap;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public abstract class SecureCaller {
    private static final Map<CodeSource, Map<ClassLoader, SoftReference<SecureCaller>>> callers;
    private static final byte[] secureCallerImplBytecode;

    static {
        secureCallerImplBytecode = SecureCaller.loadBytecode();
        callers = new WeakHashMap<CodeSource, Map<ClassLoader, SoftReference<SecureCaller>>>();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Object callSecurely(CodeSource softReference, Callable callable, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        WeakHashMap<ClassLoader, SoftReference<Object>> weakHashMap;
        Object object;
        final ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<Object>(Thread.currentThread()){
            final /* synthetic */ Thread val$thread;
            {
                this.val$thread = thread;
            }

            @Override
            public Object run() {
                return this.val$thread.getContextClassLoader();
            }
        });
        Object object2 = callers;
        synchronized (object2) {
            object = object2.get(softReference);
            weakHashMap = object;
            if (object == null) {
                weakHashMap = new WeakHashMap<ClassLoader, SoftReference<Object>>();
                object2.put((CodeSource)((Object)softReference), weakHashMap);
            }
        }
        synchronized (weakHashMap) {
            object = (SoftReference)weakHashMap.get(classLoader);
            object = object != null ? (SecureCaller)((SoftReference)object).get() : null;
            object2 = object;
            if (object == null) {
                try {
                    object = new PrivilegedExceptionAction<Object>((CodeSource)((Object)softReference)){
                        final /* synthetic */ CodeSource val$codeSource;
                        {
                            this.val$codeSource = codeSource;
                        }

                        @Override
                        public Object run() throws Exception {
                            Class<?> clazz = this.getClass();
                            clazz = classLoader.loadClass(clazz.getName()) != clazz ? clazz.getClassLoader() : classLoader;
                            clazz = new SecureClassLoaderImpl((ClassLoader)((Object)clazz));
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append(SecureCaller.class.getName());
                            stringBuilder.append("Impl");
                            return ((SecureClassLoaderImpl)((Object)clazz)).defineAndLinkClass(stringBuilder.toString(), secureCallerImplBytecode, this.val$codeSource).newInstance();
                        }
                    };
                    object2 = (SecureCaller)AccessController.doPrivileged(object);
                    softReference = new SoftReference<Object>(object2);
                    weakHashMap.put(classLoader, softReference);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    softReference = new SoftReference<Object>(privilegedActionException.getCause());
                    throw softReference;
                }
            }
            return ((SecureCaller)object2).call(callable, context, scriptable, scriptable2, objectArray);
        }
    }

    private static byte[] loadBytecode() {
        return (byte[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return SecureCaller.loadBytecodePrivileged();
            }
        });
    }

    private static byte[] loadBytecodePrivileged() {
        int n;
        Object object;
        Object object2 = SecureCaller.class.getResource("SecureCallerImpl.clazz");
        object2 = ((URL)object2).openStream();
        try {
            object = new ByteArrayOutputStream();
            while (true) {
                if ((n = ((InputStream)object2).read()) != -1) break block9;
                break;
            }
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)object2).close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new UndeclaredThrowableException(iOException);
            }
        }
        {
            block9: {
                object = ((ByteArrayOutputStream)object).toByteArray();
                ((InputStream)object2).close();
                return object;
            }
            ((ByteArrayOutputStream)object).write(n);
            continue;
        }
    }

    public abstract Object call(Callable var1, Context var2, Scriptable var3, Scriptable var4, Object[] var5);

    private static class SecureClassLoaderImpl
    extends SecureClassLoader {
        SecureClassLoaderImpl(ClassLoader classLoader) {
            super(classLoader);
        }

        Class<?> defineAndLinkClass(String object, byte[] byArray, CodeSource codeSource) {
            object = this.defineClass((String)object, byArray, 0, byArray.length, codeSource);
            this.resolveClass((Class<?>)object);
            return object;
        }
    }
}

